# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'JobBinaryAuthorization',
    'JobCondition',
    'JobIamBindingCondition',
    'JobIamMemberCondition',
    'JobLatestCreatedExecution',
    'JobTemplate',
    'JobTemplateTemplate',
    'JobTemplateTemplateContainer',
    'JobTemplateTemplateContainerEnv',
    'JobTemplateTemplateContainerEnvValueSource',
    'JobTemplateTemplateContainerEnvValueSourceSecretKeyRef',
    'JobTemplateTemplateContainerPort',
    'JobTemplateTemplateContainerResources',
    'JobTemplateTemplateContainerStartupProbe',
    'JobTemplateTemplateContainerStartupProbeGrpc',
    'JobTemplateTemplateContainerStartupProbeHttpGet',
    'JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader',
    'JobTemplateTemplateContainerStartupProbeTcpSocket',
    'JobTemplateTemplateContainerVolumeMount',
    'JobTemplateTemplateNodeSelector',
    'JobTemplateTemplateVolume',
    'JobTemplateTemplateVolumeCloudSqlInstance',
    'JobTemplateTemplateVolumeEmptyDir',
    'JobTemplateTemplateVolumeGcs',
    'JobTemplateTemplateVolumeNfs',
    'JobTemplateTemplateVolumeSecret',
    'JobTemplateTemplateVolumeSecretItem',
    'JobTemplateTemplateVpcAccess',
    'JobTemplateTemplateVpcAccessNetworkInterface',
    'JobTerminalCondition',
    'ServiceBinaryAuthorization',
    'ServiceBuildConfig',
    'ServiceCondition',
    'ServiceIamBindingCondition',
    'ServiceIamMemberCondition',
    'ServiceScaling',
    'ServiceTemplate',
    'ServiceTemplateContainer',
    'ServiceTemplateContainerBuildInfo',
    'ServiceTemplateContainerEnv',
    'ServiceTemplateContainerEnvValueSource',
    'ServiceTemplateContainerEnvValueSourceSecretKeyRef',
    'ServiceTemplateContainerLivenessProbe',
    'ServiceTemplateContainerLivenessProbeGrpc',
    'ServiceTemplateContainerLivenessProbeHttpGet',
    'ServiceTemplateContainerLivenessProbeHttpGetHttpHeader',
    'ServiceTemplateContainerLivenessProbeTcpSocket',
    'ServiceTemplateContainerPorts',
    'ServiceTemplateContainerResources',
    'ServiceTemplateContainerStartupProbe',
    'ServiceTemplateContainerStartupProbeGrpc',
    'ServiceTemplateContainerStartupProbeHttpGet',
    'ServiceTemplateContainerStartupProbeHttpGetHttpHeader',
    'ServiceTemplateContainerStartupProbeTcpSocket',
    'ServiceTemplateContainerVolumeMount',
    'ServiceTemplateNodeSelector',
    'ServiceTemplateScaling',
    'ServiceTemplateServiceMesh',
    'ServiceTemplateVolume',
    'ServiceTemplateVolumeCloudSqlInstance',
    'ServiceTemplateVolumeEmptyDir',
    'ServiceTemplateVolumeGcs',
    'ServiceTemplateVolumeNfs',
    'ServiceTemplateVolumeSecret',
    'ServiceTemplateVolumeSecretItem',
    'ServiceTemplateVpcAccess',
    'ServiceTemplateVpcAccessNetworkInterface',
    'ServiceTerminalCondition',
    'ServiceTraffic',
    'ServiceTrafficStatus',
    'WorkerPoolBinaryAuthorization',
    'WorkerPoolCondition',
    'WorkerPoolIamBindingCondition',
    'WorkerPoolIamMemberCondition',
    'WorkerPoolInstanceSplit',
    'WorkerPoolInstanceSplitStatus',
    'WorkerPoolScaling',
    'WorkerPoolTemplate',
    'WorkerPoolTemplateContainer',
    'WorkerPoolTemplateContainerEnv',
    'WorkerPoolTemplateContainerEnvValueSource',
    'WorkerPoolTemplateContainerEnvValueSourceSecretKeyRef',
    'WorkerPoolTemplateContainerResources',
    'WorkerPoolTemplateContainerVolumeMount',
    'WorkerPoolTemplateNodeSelector',
    'WorkerPoolTemplateVolume',
    'WorkerPoolTemplateVolumeCloudSqlInstance',
    'WorkerPoolTemplateVolumeEmptyDir',
    'WorkerPoolTemplateVolumeGcs',
    'WorkerPoolTemplateVolumeNfs',
    'WorkerPoolTemplateVolumeSecret',
    'WorkerPoolTemplateVolumeSecretItem',
    'WorkerPoolTemplateVpcAccess',
    'WorkerPoolTemplateVpcAccessNetworkInterface',
    'WorkerPoolTerminalCondition',
    'GetJobBinaryAuthorizationResult',
    'GetJobConditionResult',
    'GetJobLatestCreatedExecutionResult',
    'GetJobTemplateResult',
    'GetJobTemplateTemplateResult',
    'GetJobTemplateTemplateContainerResult',
    'GetJobTemplateTemplateContainerEnvResult',
    'GetJobTemplateTemplateContainerEnvValueSourceResult',
    'GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult',
    'GetJobTemplateTemplateContainerPortResult',
    'GetJobTemplateTemplateContainerResourceResult',
    'GetJobTemplateTemplateContainerStartupProbeResult',
    'GetJobTemplateTemplateContainerStartupProbeGrpcResult',
    'GetJobTemplateTemplateContainerStartupProbeHttpGetResult',
    'GetJobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderResult',
    'GetJobTemplateTemplateContainerStartupProbeTcpSocketResult',
    'GetJobTemplateTemplateContainerVolumeMountResult',
    'GetJobTemplateTemplateNodeSelectorResult',
    'GetJobTemplateTemplateVolumeResult',
    'GetJobTemplateTemplateVolumeCloudSqlInstanceResult',
    'GetJobTemplateTemplateVolumeEmptyDirResult',
    'GetJobTemplateTemplateVolumeGcResult',
    'GetJobTemplateTemplateVolumeNfResult',
    'GetJobTemplateTemplateVolumeSecretResult',
    'GetJobTemplateTemplateVolumeSecretItemResult',
    'GetJobTemplateTemplateVpcAccessResult',
    'GetJobTemplateTemplateVpcAccessNetworkInterfaceResult',
    'GetJobTerminalConditionResult',
    'GetServiceBinaryAuthorizationResult',
    'GetServiceBuildConfigResult',
    'GetServiceConditionResult',
    'GetServiceScalingResult',
    'GetServiceTemplateResult',
    'GetServiceTemplateContainerResult',
    'GetServiceTemplateContainerBuildInfoResult',
    'GetServiceTemplateContainerEnvResult',
    'GetServiceTemplateContainerEnvValueSourceResult',
    'GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult',
    'GetServiceTemplateContainerLivenessProbeResult',
    'GetServiceTemplateContainerLivenessProbeGrpcResult',
    'GetServiceTemplateContainerLivenessProbeHttpGetResult',
    'GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult',
    'GetServiceTemplateContainerLivenessProbeTcpSocketResult',
    'GetServiceTemplateContainerPortResult',
    'GetServiceTemplateContainerResourceResult',
    'GetServiceTemplateContainerStartupProbeResult',
    'GetServiceTemplateContainerStartupProbeGrpcResult',
    'GetServiceTemplateContainerStartupProbeHttpGetResult',
    'GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult',
    'GetServiceTemplateContainerStartupProbeTcpSocketResult',
    'GetServiceTemplateContainerVolumeMountResult',
    'GetServiceTemplateNodeSelectorResult',
    'GetServiceTemplateScalingResult',
    'GetServiceTemplateServiceMeshResult',
    'GetServiceTemplateVolumeResult',
    'GetServiceTemplateVolumeCloudSqlInstanceResult',
    'GetServiceTemplateVolumeEmptyDirResult',
    'GetServiceTemplateVolumeGcResult',
    'GetServiceTemplateVolumeNfResult',
    'GetServiceTemplateVolumeSecretResult',
    'GetServiceTemplateVolumeSecretItemResult',
    'GetServiceTemplateVpcAccessResult',
    'GetServiceTemplateVpcAccessNetworkInterfaceResult',
    'GetServiceTerminalConditionResult',
    'GetServiceTrafficResult',
    'GetServiceTrafficStatusResult',
    'GetWorkerPoolBinaryAuthorizationResult',
    'GetWorkerPoolConditionResult',
    'GetWorkerPoolInstanceSplitResult',
    'GetWorkerPoolInstanceSplitStatusResult',
    'GetWorkerPoolScalingResult',
    'GetWorkerPoolTemplateResult',
    'GetWorkerPoolTemplateContainerResult',
    'GetWorkerPoolTemplateContainerEnvResult',
    'GetWorkerPoolTemplateContainerEnvValueSourceResult',
    'GetWorkerPoolTemplateContainerEnvValueSourceSecretKeyRefResult',
    'GetWorkerPoolTemplateContainerResourceResult',
    'GetWorkerPoolTemplateContainerVolumeMountResult',
    'GetWorkerPoolTemplateNodeSelectorResult',
    'GetWorkerPoolTemplateVolumeResult',
    'GetWorkerPoolTemplateVolumeCloudSqlInstanceResult',
    'GetWorkerPoolTemplateVolumeEmptyDirResult',
    'GetWorkerPoolTemplateVolumeGcResult',
    'GetWorkerPoolTemplateVolumeNfResult',
    'GetWorkerPoolTemplateVolumeSecretResult',
    'GetWorkerPoolTemplateVolumeSecretItemResult',
    'GetWorkerPoolTemplateVpcAccessResult',
    'GetWorkerPoolTemplateVpcAccessNetworkInterfaceResult',
    'GetWorkerPoolTerminalConditionResult',
]

@pulumi.output_type
class JobBinaryAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobBinaryAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobBinaryAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobBinaryAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 use_default: Optional[_builtins.bool] = None):
        """
        :param _builtins.str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param _builtins.str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param _builtins.bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @_builtins.property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[_builtins.str]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[_builtins.bool]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class JobCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 revision_reason: Optional[_builtins.str] = None,
                 severity: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str execution_reason: (Output)
               A reason for the execution condition.
        :param _builtins.str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: (Output)
               A reason for the revision condition.
        :param _builtins.str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: (Output)
               State of the condition.
        :param _builtins.str type: (Output)
               type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class JobLatestCreatedExecution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "completionTime":
            suggest = "completion_time"
        elif key == "createTime":
            suggest = "create_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobLatestCreatedExecution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobLatestCreatedExecution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobLatestCreatedExecution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 completion_time: Optional[_builtins.str] = None,
                 create_time: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str completion_time: (Output)
               Completion timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str create_time: (Output)
               Creation timestamp of the execution.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str name: Name of the Job.
        """
        if completion_time is not None:
            pulumi.set(__self__, "completion_time", completion_time)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Completion timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "completion_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Creation timestamp of the execution.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "taskCount":
            suggest = "task_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 template: 'outputs.JobTemplateTemplate',
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 parallelism: Optional[_builtins.int] = None,
                 task_count: Optional[_builtins.int] = None):
        """
        :param 'JobTemplateTemplateArgs' template: Describes the task(s) that will be created when executing an execution
               Structure is documented below.
        :param Mapping[str, _builtins.str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Mapping[str, _builtins.str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        :param _builtins.int parallelism: Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        :param _builtins.int task_count: Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        pulumi.set(__self__, "template", template)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @_builtins.property
    @pulumi.getter
    def template(self) -> 'outputs.JobTemplateTemplate':
        """
        Describes the task(s) that will be created when executing an execution
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[_builtins.int]:
        """
        Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @_builtins.property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[_builtins.int]:
        """
        Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "task_count")


@pulumi.output_type
class JobTemplateTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "maxRetries":
            suggest = "max_retries"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 containers: Optional[Sequence['outputs.JobTemplateTemplateContainer']] = None,
                 encryption_key: Optional[_builtins.str] = None,
                 execution_environment: Optional[_builtins.str] = None,
                 max_retries: Optional[_builtins.int] = None,
                 node_selector: Optional['outputs.JobTemplateTemplateNodeSelector'] = None,
                 service_account: Optional[_builtins.str] = None,
                 timeout: Optional[_builtins.str] = None,
                 volumes: Optional[Sequence['outputs.JobTemplateTemplateVolume']] = None,
                 vpc_access: Optional['outputs.JobTemplateTemplateVpcAccess'] = None):
        """
        :param Sequence['JobTemplateTemplateContainerArgs'] containers: Holds the single container that defines the unit of execution for this task.
               Structure is documented below.
        :param _builtins.str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param _builtins.str execution_environment: The execution environment being used to host this Task.
               Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        :param _builtins.int max_retries: Number of retries allowed per Task, before marking this Task failed. Defaults to 3. Minimum value is 0.
        :param 'JobTemplateTemplateNodeSelectorArgs' node_selector: Node Selector describes the hardware requirements of the resources.
               Structure is documented below.
        :param _builtins.str service_account: Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param _builtins.str timeout: Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['JobTemplateTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param 'JobTemplateTemplateVpcAccessArgs' vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainer']]:
        """
        Holds the single container that defines the unit of execution for this task.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[_builtins.str]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[_builtins.str]:
        """
        The execution environment being used to host this Task.
        Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[_builtins.int]:
        """
        Number of retries allowed per Task, before marking this Task failed. Defaults to 3. Minimum value is 0.
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['outputs.JobTemplateTemplateNodeSelector']:
        """
        Node Selector describes the hardware requirements of the resources.
        Structure is documented below.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.JobTemplateTemplateVolume']]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional['outputs.JobTemplateTemplateVpcAccess']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class JobTemplateTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOns":
            suggest = "depends_ons"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 depends_ons: Optional[Sequence[_builtins.str]] = None,
                 envs: Optional[Sequence['outputs.JobTemplateTemplateContainerEnv']] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional[Sequence['outputs.JobTemplateTemplateContainerPort']] = None,
                 resources: Optional['outputs.JobTemplateTemplateContainerResources'] = None,
                 startup_probe: Optional['outputs.JobTemplateTemplateContainerStartupProbe'] = None,
                 volume_mounts: Optional[Sequence['outputs.JobTemplateTemplateContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param _builtins.str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] depends_ons: Names of the containers that must start before this container.
        :param Sequence['JobTemplateTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param _builtins.str name: Name of the container specified as a DNS_LABEL.
        :param Sequence['JobTemplateTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param 'JobTemplateTemplateContainerResourcesArgs' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param 'JobTemplateTemplateContainerStartupProbeArgs' startup_probe: Startup probe of application within the container.
               All other probes are disabled if a startup probe is provided, until it
               succeeds. Container will not be added to service endpoints if the probe fails.
               Structure is documented below.
        :param Sequence['JobTemplateTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if depends_ons is not None:
            pulumi.set(__self__, "depends_ons", depends_ons)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Optional[Sequence[_builtins.str]]:
        """
        Names of the containers that must start before this container.
        """
        return pulumi.get(self, "depends_ons")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerPort']]:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.JobTemplateTemplateContainerResources']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.JobTemplateTemplateContainerStartupProbe']:
        """
        Startup probe of application within the container.
        All other probes are disabled if a startup probe is provided, until it
        succeeds. Container will not be added to service endpoints if the probe fails.
        Structure is documented below.
        """
        return pulumi.get(self, "startup_probe")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class JobTemplateTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None,
                 value_source: Optional['outputs.JobTemplateTemplateContainerEnvValueSource'] = None):
        """
        :param _builtins.str name: Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        :param _builtins.str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param 'JobTemplateTemplateContainerEnvValueSourceArgs' value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and mnay not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional['outputs.JobTemplateTemplateContainerEnvValueSource']:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class JobTemplateTemplateContainerEnvValueSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerEnvValueSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerEnvValueSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerEnvValueSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.JobTemplateTemplateContainerEnvValueSourceSecretKeyRef'] = None):
        """
        :param 'JobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @_builtins.property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.JobTemplateTemplateContainerEnvValueSourceSecretKeyRef']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class JobTemplateTemplateContainerEnvValueSourceSecretKeyRef(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class JobTemplateTemplateContainerPort(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerPort. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerPort.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerPort.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param _builtins.str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[_builtins.int]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplateTemplateContainerResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[_builtins.int] = None,
                 grpc: Optional['outputs.JobTemplateTemplateContainerStartupProbeGrpc'] = None,
                 http_get: Optional['outputs.JobTemplateTemplateContainerStartupProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[_builtins.int] = None,
                 period_seconds: Optional[_builtins.int] = None,
                 tcp_socket: Optional['outputs.JobTemplateTemplateContainerStartupProbeTcpSocket'] = None,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after
               having succeeded. Defaults to 3. Minimum value is 1.
        :param 'JobTemplateTemplateContainerStartupProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'JobTemplateTemplateContainerStartupProbeHttpGetArgs' http_get: HttpGet specifies the http request to perform.
               Structure is documented below.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is
               initiated.
               Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe.
               Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        :param 'JobTemplateTemplateContainerStartupProbeTcpSocketArgs' tcp_socket: TcpSocket specifies an action involving a TCP port.
               Structure is documented below.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out.
               Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
               Must be smaller than periodSeconds.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.int]:
        """
        Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.JobTemplateTemplateContainerStartupProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @_builtins.property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.JobTemplateTemplateContainerStartupProbeHttpGet']:
        """
        HttpGet specifies the http request to perform.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after the container has started before the probe is
        initiated.
        Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        How often (in seconds) to perform the probe.
        Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.JobTemplateTemplateContainerStartupProbeTcpSocket']:
        """
        TcpSocket specifies an action involving a TCP port.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after which the probe times out.
        Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
        Must be smaller than periodSeconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 service: Optional[_builtins.str] = None):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerStartupProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader']] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param Sequence['JobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param _builtins.str path: Path to access on the HTTP server. If set, it should not be empty string.
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to access on the HTTP server. If set, it should not be empty string.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The header field name.
        :param _builtins.str value: The header field value.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The header field name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The header field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class JobTemplateTemplateContainerStartupProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class JobTemplateTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param _builtins.str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class JobTemplateTemplateNodeSelector(dict):
    def __init__(__self__, *,
                 accelerator: _builtins.str):
        """
        :param _builtins.str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/jobs/gpu for configuring GPU.
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @_builtins.property
    @pulumi.getter
    def accelerator(self) -> _builtins.str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/jobs/gpu for configuring GPU.
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class JobTemplateTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 cloud_sql_instance: Optional['outputs.JobTemplateTemplateVolumeCloudSqlInstance'] = None,
                 empty_dir: Optional['outputs.JobTemplateTemplateVolumeEmptyDir'] = None,
                 gcs: Optional['outputs.JobTemplateTemplateVolumeGcs'] = None,
                 nfs: Optional['outputs.JobTemplateTemplateVolumeNfs'] = None,
                 secret: Optional['outputs.JobTemplateTemplateVolumeSecret'] = None):
        """
        :param _builtins.str name: Volume's name.
        :param 'JobTemplateTemplateVolumeCloudSqlInstanceArgs' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeEmptyDirArgs' empty_dir: Ephemeral storage used as a shared volume.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeGcsArgs' gcs: Cloud Storage bucket mounted as a volume using GCSFuse.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeNfsArgs' nfs: NFS share mounted as a volume.
               Structure is documented below.
        :param 'JobTemplateTemplateVolumeSecretArgs' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional['outputs.JobTemplateTemplateVolumeCloudSqlInstance']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @_builtins.property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.JobTemplateTemplateVolumeEmptyDir']:
        """
        Ephemeral storage used as a shared volume.
        Structure is documented below.
        """
        return pulumi.get(self, "empty_dir")

    @_builtins.property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.JobTemplateTemplateVolumeGcs']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.JobTemplateTemplateVolumeNfs']:
        """
        NFS share mounted as a volume.
        Structure is documented below.
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional['outputs.JobTemplateTemplateVolumeSecret']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class JobTemplateTemplateVolumeCloudSqlInstance(dict):
    def __init__(__self__, *,
                 instances: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[_builtins.str]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class JobTemplateTemplateVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[_builtins.str] = None,
                 size_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.str medium: The different types of medium supported for EmptyDir.
               Default value is `MEMORY`.
               Possible values are: `MEMORY`.
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> Optional[_builtins.str]:
        """
        The different types of medium supported for EmptyDir.
        Default value is `MEMORY`.
        Possible values are: `MEMORY`.
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class JobTemplateTemplateVolumeGcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeGcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeGcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeGcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 mount_options: Optional[Sequence[_builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str bucket: Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        :param Sequence[_builtins.str] mount_options: A list of flags to pass to the gcsfuse command for configuring this volume.
               Flags should be passed without leading dashes.
        :param _builtins.bool read_only: If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        pulumi.set(__self__, "bucket", bucket)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of flags to pass to the gcsfuse command for configuring this volume.
        Flags should be passed without leading dashes.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class JobTemplateTemplateVolumeNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server: _builtins.str,
                 path: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str server: Hostname or IP address of the NFS server.
        :param _builtins.str path: Path that is exported by the NFS server.
        :param _builtins.bool read_only: If true, mount this volume as read-only in all mounts.
        """
        pulumi.set(__self__, "server", server)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        Hostname or IP address of the NFS server.
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, mount this volume as read-only in all mounts.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class JobTemplateTemplateVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret: _builtins.str,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.JobTemplateTemplateVolumeSecretItem']] = None):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param _builtins.int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['JobTemplateTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.JobTemplateTemplateVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class JobTemplateTemplateVolumeSecretItem(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 version: _builtins.str,
                 mode: Optional[_builtins.int] = None):
        """
        :param _builtins.str path: The relative path of the secret in the container.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        :param _builtins.int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")


@pulumi.output_type
class JobTemplateTemplateVpcAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTemplateTemplateVpcAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTemplateTemplateVpcAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTemplateTemplateVpcAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector: Optional[_builtins.str] = None,
                 egress: Optional[_builtins.str] = None,
                 network_interfaces: Optional[Sequence['outputs.JobTemplateTemplateVpcAccessNetworkInterface']] = None):
        """
        :param _builtins.str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param _builtins.str egress: Traffic VPC egress settings.
               Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        :param Sequence['JobTemplateTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
               Structure is documented below.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @_builtins.property
    @pulumi.getter
    def connector(self) -> Optional[_builtins.str]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @_builtins.property
    @pulumi.getter
    def egress(self) -> Optional[_builtins.str]:
        """
        Traffic VPC egress settings.
        Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.JobTemplateTemplateVpcAccessNetworkInterface']]:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class JobTemplateTemplateVpcAccessNetworkInterface(dict):
    def __init__(__self__, *,
                 network: Optional[_builtins.str] = None,
                 subnetwork: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param _builtins.str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Run job.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Network tags applied to this Cloud Run job.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class JobTerminalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobTerminalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobTerminalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobTerminalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 revision_reason: Optional[_builtins.str] = None,
                 severity: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str execution_reason: (Output)
               A reason for the execution condition.
        :param _builtins.str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: (Output)
               A reason for the revision condition.
        :param _builtins.str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: (Output)
               State of the condition.
        :param _builtins.str type: (Output)
               type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceBinaryAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBinaryAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBinaryAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBinaryAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 use_default: Optional[_builtins.bool] = None):
        """
        :param _builtins.str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param _builtins.str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param _builtins.bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @_builtins.property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[_builtins.str]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[_builtins.bool]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class ServiceBuildConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseImage":
            suggest = "base_image"
        elif key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "functionTarget":
            suggest = "function_target"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "sourceLocation":
            suggest = "source_location"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceBuildConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceBuildConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceBuildConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_image: Optional[_builtins.str] = None,
                 enable_automatic_updates: Optional[_builtins.bool] = None,
                 environment_variables: Optional[Mapping[str, _builtins.str]] = None,
                 function_target: Optional[_builtins.str] = None,
                 image_uri: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 service_account: Optional[_builtins.str] = None,
                 source_location: Optional[_builtins.str] = None,
                 worker_pool: Optional[_builtins.str] = None):
        """
        :param _builtins.str base_image: The base image used to build the function.
        :param _builtins.bool enable_automatic_updates: Sets whether the function will receive automatic base image updates.
        :param Mapping[str, _builtins.str] environment_variables: User-provided build-time environment variables for the function.
        :param _builtins.str function_target: The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function".
        :param _builtins.str image_uri: Artifact Registry URI to store the built image.
        :param _builtins.str name: (Output)
               The Cloud Build name of the latest successful deployment of the function.
        :param _builtins.str service_account: Service account to be used for building the container. The format of this field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
        :param _builtins.str source_location: The Cloud Storage bucket URI where the function source code is located.
        :param _builtins.str worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the Cloud Run function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool.
        """
        if base_image is not None:
            pulumi.set(__self__, "base_image", base_image)
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if function_target is not None:
            pulumi.set(__self__, "function_target", function_target)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @_builtins.property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> Optional[_builtins.str]:
        """
        The base image used to build the function.
        """
        return pulumi.get(self, "base_image")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[_builtins.bool]:
        """
        Sets whether the function will receive automatic base image updates.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        User-provided build-time environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="functionTarget")
    def function_target(self) -> Optional[_builtins.str]:
        """
        The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function".
        """
        return pulumi.get(self, "function_target")

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[_builtins.str]:
        """
        Artifact Registry URI to store the built image.
        """
        return pulumi.get(self, "image_uri")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        (Output)
        The Cloud Build name of the latest successful deployment of the function.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Service account to be used for building the container. The format of this field is `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[_builtins.str]:
        """
        The Cloud Storage bucket URI where the function source code is located.
        """
        return pulumi.get(self, "source_location")

    @_builtins.property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[_builtins.str]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the Cloud Run function. The format of this field is `projects/{project}/locations/{region}/workerPools/{workerPool}` where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class ServiceCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 revision_reason: Optional[_builtins.str] = None,
                 severity: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str execution_reason: (Output)
               A reason for the execution condition.
        :param _builtins.str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: (Output)
               A reason for the revision condition.
        :param _builtins.str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: (Output)
               State of the condition.
        :param _builtins.str type: (Output)
               The allocation type for this traffic target.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ServiceScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manualInstanceCount":
            suggest = "manual_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"
        elif key == "scalingMode":
            suggest = "scaling_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manual_instance_count: Optional[_builtins.int] = None,
                 min_instance_count: Optional[_builtins.int] = None,
                 scaling_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.int manual_instance_count: Total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
        :param _builtins.int min_instance_count: Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        :param _builtins.str scaling_mode: The [scaling mode](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#scalingmode) for the service.
               Possible values are: `AUTOMATIC`, `MANUAL`.
        """
        if manual_instance_count is not None:
            pulumi.set(__self__, "manual_instance_count", manual_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if scaling_mode is not None:
            pulumi.set(__self__, "scaling_mode", scaling_mode)

    @_builtins.property
    @pulumi.getter(name="manualInstanceCount")
    def manual_instance_count(self) -> Optional[_builtins.int]:
        """
        Total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
        """
        return pulumi.get(self, "manual_instance_count")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        return pulumi.get(self, "min_instance_count")

    @_builtins.property
    @pulumi.getter(name="scalingMode")
    def scaling_mode(self) -> Optional[_builtins.str]:
        """
        The [scaling mode](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#scalingmode) for the service.
        Possible values are: `AUTOMATIC`, `MANUAL`.
        """
        return pulumi.get(self, "scaling_mode")


@pulumi.output_type
class ServiceTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "executionEnvironment":
            suggest = "execution_environment"
        elif key == "gpuZonalRedundancyDisabled":
            suggest = "gpu_zonal_redundancy_disabled"
        elif key == "maxInstanceRequestConcurrency":
            suggest = "max_instance_request_concurrency"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "serviceMesh":
            suggest = "service_mesh"
        elif key == "sessionAffinity":
            suggest = "session_affinity"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 containers: Optional[Sequence['outputs.ServiceTemplateContainer']] = None,
                 encryption_key: Optional[_builtins.str] = None,
                 execution_environment: Optional[_builtins.str] = None,
                 gpu_zonal_redundancy_disabled: Optional[_builtins.bool] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 max_instance_request_concurrency: Optional[_builtins.int] = None,
                 node_selector: Optional['outputs.ServiceTemplateNodeSelector'] = None,
                 revision: Optional[_builtins.str] = None,
                 scaling: Optional['outputs.ServiceTemplateScaling'] = None,
                 service_account: Optional[_builtins.str] = None,
                 service_mesh: Optional['outputs.ServiceTemplateServiceMesh'] = None,
                 session_affinity: Optional[_builtins.bool] = None,
                 timeout: Optional[_builtins.str] = None,
                 volumes: Optional[Sequence['outputs.ServiceTemplateVolume']] = None,
                 vpc_access: Optional['outputs.ServiceTemplateVpcAccess'] = None):
        """
        :param Mapping[str, _builtins.str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Sequence['ServiceTemplateContainerArgs'] containers: Holds the containers that define the unit of execution for this Service.
               Structure is documented below.
        :param _builtins.str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param _builtins.str execution_environment: The sandbox environment to host this Revision.
               Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        :param _builtins.bool gpu_zonal_redundancy_disabled: True if GPU zonal redundancy is disabled on this revision.
        :param Mapping[str, _builtins.str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
               For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        :param _builtins.int max_instance_request_concurrency: Sets the maximum number of requests that each serving instance can receive.
               If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        :param 'ServiceTemplateNodeSelectorArgs' node_selector: Node Selector describes the hardware requirements of the resources.
               Structure is documented below.
        :param _builtins.str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        :param 'ServiceTemplateScalingArgs' scaling: Scaling settings for this Revision.
               Structure is documented below.
        :param _builtins.str service_account: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param 'ServiceTemplateServiceMeshArgs' service_mesh: Enables Cloud Service Mesh for this Revision.
               Structure is documented below.
        :param _builtins.bool session_affinity: Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        :param _builtins.str timeout: Max allowed time for an instance to respond to a request.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['ServiceTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param 'ServiceTemplateVpcAccessArgs' vpc_access: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if execution_environment is not None:
            pulumi.set(__self__, "execution_environment", execution_environment)
        if gpu_zonal_redundancy_disabled is not None:
            pulumi.set(__self__, "gpu_zonal_redundancy_disabled", gpu_zonal_redundancy_disabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_instance_request_concurrency is not None:
            pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_mesh is not None:
            pulumi.set(__self__, "service_mesh", service_mesh)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.ServiceTemplateContainer']]:
        """
        Holds the containers that define the unit of execution for this Service.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[_builtins.str]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> Optional[_builtins.str]:
        """
        The sandbox environment to host this Revision.
        Possible values are: `EXECUTION_ENVIRONMENT_GEN1`, `EXECUTION_ENVIRONMENT_GEN2`.
        """
        return pulumi.get(self, "execution_environment")

    @_builtins.property
    @pulumi.getter(name="gpuZonalRedundancyDisabled")
    def gpu_zonal_redundancy_disabled(self) -> Optional[_builtins.bool]:
        """
        True if GPU zonal redundancy is disabled on this revision.
        """
        return pulumi.get(self, "gpu_zonal_redundancy_disabled")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
        For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> Optional[_builtins.int]:
        """
        Sets the maximum number of requests that each serving instance can receive.
        If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['outputs.ServiceTemplateNodeSelector']:
        """
        Node Selector describes the hardware requirements of the resources.
        Structure is documented below.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def scaling(self) -> Optional['outputs.ServiceTemplateScaling']:
        """
        Scaling settings for this Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="serviceMesh")
    def service_mesh(self) -> Optional['outputs.ServiceTemplateServiceMesh']:
        """
        Enables Cloud Service Mesh for this Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "service_mesh")

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[_builtins.bool]:
        """
        Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        """
        return pulumi.get(self, "session_affinity")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Max allowed time for an instance to respond to a request.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.ServiceTemplateVolume']]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional['outputs.ServiceTemplateVpcAccess']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class ServiceTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseImageUri":
            suggest = "base_image_uri"
        elif key == "buildInfos":
            suggest = "build_infos"
        elif key == "dependsOns":
            suggest = "depends_ons"
        elif key == "livenessProbe":
            suggest = "liveness_probe"
        elif key == "startupProbe":
            suggest = "startup_probe"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 base_image_uri: Optional[_builtins.str] = None,
                 build_infos: Optional[Sequence['outputs.ServiceTemplateContainerBuildInfo']] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 depends_ons: Optional[Sequence[_builtins.str]] = None,
                 envs: Optional[Sequence['outputs.ServiceTemplateContainerEnv']] = None,
                 liveness_probe: Optional['outputs.ServiceTemplateContainerLivenessProbe'] = None,
                 name: Optional[_builtins.str] = None,
                 ports: Optional['outputs.ServiceTemplateContainerPorts'] = None,
                 resources: Optional['outputs.ServiceTemplateContainerResources'] = None,
                 startup_probe: Optional['outputs.ServiceTemplateContainerStartupProbe'] = None,
                 volume_mounts: Optional[Sequence['outputs.ServiceTemplateContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param _builtins.str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param _builtins.str base_image_uri: Base image for this container. If set, it indicates that the service is enrolled into automatic base image update.
        :param Sequence['ServiceTemplateContainerBuildInfoArgs'] build_infos: (Output)
               The build info of the container image.
               Structure is documented below.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] depends_ons: Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        :param Sequence['ServiceTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param 'ServiceTemplateContainerLivenessProbeArgs' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param _builtins.str name: Name of the container specified as a DNS_LABEL.
        :param 'ServiceTemplateContainerPortsArgs' ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
               Structure is documented below.
        :param 'ServiceTemplateContainerResourcesArgs' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param 'ServiceTemplateContainerStartupProbeArgs' startup_probe: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
               Structure is documented below.
        :param Sequence['ServiceTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if base_image_uri is not None:
            pulumi.set(__self__, "base_image_uri", base_image_uri)
        if build_infos is not None:
            pulumi.set(__self__, "build_infos", build_infos)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if depends_ons is not None:
            pulumi.set(__self__, "depends_ons", depends_ons)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if liveness_probe is not None:
            pulumi.set(__self__, "liveness_probe", liveness_probe)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if startup_probe is not None:
            pulumi.set(__self__, "startup_probe", startup_probe)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="baseImageUri")
    def base_image_uri(self) -> Optional[_builtins.str]:
        """
        Base image for this container. If set, it indicates that the service is enrolled into automatic base image update.
        """
        return pulumi.get(self, "base_image_uri")

    @_builtins.property
    @pulumi.getter(name="buildInfos")
    def build_infos(self) -> Optional[Sequence['outputs.ServiceTemplateContainerBuildInfo']]:
        """
        (Output)
        The build info of the container image.
        Structure is documented below.
        """
        return pulumi.get(self, "build_infos")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Optional[Sequence[_builtins.str]]:
        """
        Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        """
        return pulumi.get(self, "depends_ons")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.ServiceTemplateContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbe']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "liveness_probe")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional['outputs.ServiceTemplateContainerPorts']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        Structure is documented below.
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.ServiceTemplateContainerResources']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="startupProbe")
    def startup_probe(self) -> Optional['outputs.ServiceTemplateContainerStartupProbe']:
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        Structure is documented below.
        """
        return pulumi.get(self, "startup_probe")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ServiceTemplateContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class ServiceTemplateContainerBuildInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionTarget":
            suggest = "function_target"
        elif key == "sourceLocation":
            suggest = "source_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerBuildInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerBuildInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerBuildInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_target: Optional[_builtins.str] = None,
                 source_location: Optional[_builtins.str] = None):
        """
        :param _builtins.str function_target: Entry point of the function when the image is a Cloud Run function.
        :param _builtins.str source_location: Source code location of the image.
        """
        if function_target is not None:
            pulumi.set(__self__, "function_target", function_target)
        if source_location is not None:
            pulumi.set(__self__, "source_location", source_location)

    @_builtins.property
    @pulumi.getter(name="functionTarget")
    def function_target(self) -> Optional[_builtins.str]:
        """
        Entry point of the function when the image is a Cloud Run function.
        """
        return pulumi.get(self, "function_target")

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> Optional[_builtins.str]:
        """
        Source code location of the image.
        """
        return pulumi.get(self, "source_location")


@pulumi.output_type
class ServiceTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None,
                 value_source: Optional['outputs.ServiceTemplateContainerEnvValueSource'] = None):
        """
        :param _builtins.str name: Name of the environment variable. Must be a C_IDENTIFIER, and may not exceed 32768 characters.
        :param _builtins.str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param 'ServiceTemplateContainerEnvValueSourceArgs' value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and may not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional['outputs.ServiceTemplateContainerEnvValueSource']:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class ServiceTemplateContainerEnvValueSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerEnvValueSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerEnvValueSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerEnvValueSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.ServiceTemplateContainerEnvValueSourceSecretKeyRef'] = None):
        """
        :param 'ServiceTemplateContainerEnvValueSourceSecretKeyRefArgs' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @_builtins.property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.ServiceTemplateContainerEnvValueSourceSecretKeyRef']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class ServiceTemplateContainerEnvValueSourceSecretKeyRef(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerLivenessProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerLivenessProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerLivenessProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[_builtins.int] = None,
                 grpc: Optional['outputs.ServiceTemplateContainerLivenessProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateContainerLivenessProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[_builtins.int] = None,
                 period_seconds: Optional[_builtins.int] = None,
                 tcp_socket: Optional['outputs.ServiceTemplateContainerLivenessProbeTcpSocket'] = None,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateContainerLivenessProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateContainerLivenessProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform.
               Structure is documented below.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'ServiceTemplateContainerLivenessProbeTcpSocketArgs' tcp_socket: TCPSocketAction describes an action based on opening a socket
               Structure is documented below.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @_builtins.property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ServiceTemplateContainerLivenessProbeTcpSocket']:
        """
        TCPSocketAction describes an action based on opening a socket
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 service: Optional[_builtins.str] = None):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
               
               <a name="nested_template_containers_containers_build_info"></a>The `build_info` block contains:
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.

        <a name="nested_template_containers_containers_build_info"></a>The `build_info` block contains:
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerLivenessProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerLivenessProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateContainerLivenessProbeHttpGetHttpHeader']] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param Sequence['ServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param _builtins.str path: Path to access on the HTTP server. Defaults to '/'.
        :param _builtins.int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateContainerLivenessProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The header field name
        :param _builtins.str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateContainerLivenessProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: _builtins.int):
        """
        :param _builtins.int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerPorts(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerPort":
            suggest = "container_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerPorts. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerPorts.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerPorts.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_port: Optional[_builtins.int] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param _builtins.str name: If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        if container_port is not None:
            pulumi.set(__self__, "container_port", container_port)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> Optional[_builtins.int]:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        If specified, used to specify which protocol to use. Allowed values are "http1" and "h2c".
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateContainerResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuIdle":
            suggest = "cpu_idle"
        elif key == "startupCpuBoost":
            suggest = "startup_cpu_boost"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_idle: Optional[_builtins.bool] = None,
                 limits: Optional[Mapping[str, _builtins.str]] = None,
                 startup_cpu_boost: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool cpu_idle: Determines whether CPU is only allocated during requests. True by default if the parent `resources` field is not set. However, if
               `resources` is set, this field must be explicitly set to true to preserve the default behavior.
        :param Mapping[str, _builtins.str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param _builtins.bool startup_cpu_boost: Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        if cpu_idle is not None:
            pulumi.set(__self__, "cpu_idle", cpu_idle)
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if startup_cpu_boost is not None:
            pulumi.set(__self__, "startup_cpu_boost", startup_cpu_boost)

    @_builtins.property
    @pulumi.getter(name="cpuIdle")
    def cpu_idle(self) -> Optional[_builtins.bool]:
        """
        Determines whether CPU is only allocated during requests. True by default if the parent `resources` field is not set. However, if
        `resources` is set, this field must be explicitly set to true to preserve the default behavior.
        """
        return pulumi.get(self, "cpu_idle")

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="startupCpuBoost")
    def startup_cpu_boost(self) -> Optional[_builtins.bool]:
        """
        Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        return pulumi.get(self, "startup_cpu_boost")


@pulumi.output_type
class ServiceTemplateContainerStartupProbe(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGet":
            suggest = "http_get"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "tcpSocket":
            suggest = "tcp_socket"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerStartupProbe. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerStartupProbe.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerStartupProbe.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[_builtins.int] = None,
                 grpc: Optional['outputs.ServiceTemplateContainerStartupProbeGrpc'] = None,
                 http_get: Optional['outputs.ServiceTemplateContainerStartupProbeHttpGet'] = None,
                 initial_delay_seconds: Optional[_builtins.int] = None,
                 period_seconds: Optional[_builtins.int] = None,
                 tcp_socket: Optional['outputs.ServiceTemplateContainerStartupProbeTcpSocket'] = None,
                 timeout_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param 'ServiceTemplateContainerStartupProbeGrpcArgs' grpc: GRPC specifies an action involving a GRPC port.
               Structure is documented below.
        :param 'ServiceTemplateContainerStartupProbeHttpGetArgs' http_get: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param 'ServiceTemplateContainerStartupProbeTcpSocketArgs' tcp_socket: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
               Structure is documented below.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http_get is not None:
            pulumi.set(__self__, "http_get", http_get)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if tcp_socket is not None:
            pulumi.set(__self__, "tcp_socket", tcp_socket)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.int]:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeGrpc']:
        """
        GRPC specifies an action involving a GRPC port.
        Structure is documented below.
        """
        return pulumi.get(self, "grpc")

    @_builtins.property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeHttpGet']:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "http_get")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[_builtins.int]:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> Optional['outputs.ServiceTemplateContainerStartupProbeTcpSocket']:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "tcp_socket")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[_builtins.int]:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeGrpc(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None,
                 service: Optional[_builtins.str] = None):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
               
               <a name="nested_template_containers_containers_build_info"></a>The `build_info` block contains:
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.

        <a name="nested_template_containers_containers_build_info"></a>The `build_info` block contains:
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeHttpGet(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpHeaders":
            suggest = "http_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerStartupProbeHttpGet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerStartupProbeHttpGet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_headers: Optional[Sequence['outputs.ServiceTemplateContainerStartupProbeHttpGetHttpHeader']] = None,
                 path: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None):
        """
        :param Sequence['ServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
               Structure is documented below.
        :param _builtins.str path: Path to access on the HTTP server. Defaults to '/'.
        :param _builtins.int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Sequence['outputs.ServiceTemplateContainerStartupProbeHttpGetHttpHeader']]:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        Structure is documented below.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeHttpGetHttpHeader(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The header field name
        :param _builtins.str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceTemplateContainerStartupProbeTcpSocket(dict):
    def __init__(__self__, *,
                 port: Optional[_builtins.int] = None):
        """
        :param _builtins.int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ServiceTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param _builtins.str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceTemplateNodeSelector(dict):
    def __init__(__self__, *,
                 accelerator: _builtins.str):
        """
        :param _builtins.str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @_builtins.property
    @pulumi.getter
    def accelerator(self) -> _builtins.str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class ServiceTemplateScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instance_count: Optional[_builtins.int] = None,
                 min_instance_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_instance_count: Maximum number of serving instances that this resource should have. Must not be less than minimum instance count. If absent, Cloud Run will calculate
               a default value based on the project's available container instances quota in the region and specified instance size.
        :param _builtins.int min_instance_count: Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)

    @_builtins.property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[_builtins.int]:
        """
        Maximum number of serving instances that this resource should have. Must not be less than minimum instance count. If absent, Cloud Run will calculate
        a default value based on the project's available container instances quota in the region and specified instance size.
        """
        return pulumi.get(self, "max_instance_count")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class ServiceTemplateServiceMesh(dict):
    def __init__(__self__, *,
                 mesh: Optional[_builtins.str] = None):
        """
        :param _builtins.str mesh: The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        if mesh is not None:
            pulumi.set(__self__, "mesh", mesh)

    @_builtins.property
    @pulumi.getter
    def mesh(self) -> Optional[_builtins.str]:
        """
        The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        return pulumi.get(self, "mesh")


@pulumi.output_type
class ServiceTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 cloud_sql_instance: Optional['outputs.ServiceTemplateVolumeCloudSqlInstance'] = None,
                 empty_dir: Optional['outputs.ServiceTemplateVolumeEmptyDir'] = None,
                 gcs: Optional['outputs.ServiceTemplateVolumeGcs'] = None,
                 nfs: Optional['outputs.ServiceTemplateVolumeNfs'] = None,
                 secret: Optional['outputs.ServiceTemplateVolumeSecret'] = None):
        """
        :param _builtins.str name: Volume's name.
        :param 'ServiceTemplateVolumeCloudSqlInstanceArgs' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param 'ServiceTemplateVolumeEmptyDirArgs' empty_dir: Ephemeral storage used as a shared volume.
               Structure is documented below.
        :param 'ServiceTemplateVolumeGcsArgs' gcs: Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
               Structure is documented below.
        :param 'ServiceTemplateVolumeNfsArgs' nfs: Represents an NFS mount.
               Structure is documented below.
        :param 'ServiceTemplateVolumeSecretArgs' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional['outputs.ServiceTemplateVolumeCloudSqlInstance']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @_builtins.property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.ServiceTemplateVolumeEmptyDir']:
        """
        Ephemeral storage used as a shared volume.
        Structure is documented below.
        """
        return pulumi.get(self, "empty_dir")

    @_builtins.property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.ServiceTemplateVolumeGcs']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.ServiceTemplateVolumeNfs']:
        """
        Represents an NFS mount.
        Structure is documented below.
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional['outputs.ServiceTemplateVolumeSecret']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class ServiceTemplateVolumeCloudSqlInstance(dict):
    def __init__(__self__, *,
                 instances: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[_builtins.str]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class ServiceTemplateVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[_builtins.str] = None,
                 size_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.str medium: The different types of medium supported for EmptyDir.
               Default value is `MEMORY`.
               Possible values are: `MEMORY`.
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> Optional[_builtins.str]:
        """
        The different types of medium supported for EmptyDir.
        Default value is `MEMORY`.
        Possible values are: `MEMORY`.
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class ServiceTemplateVolumeGcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeGcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeGcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeGcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 mount_options: Optional[Sequence[_builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str bucket: GCS Bucket name
        :param Sequence[_builtins.str] mount_options: A list of flags to pass to the gcsfuse command for configuring this volume.
               Flags should be passed without leading dashes.
        :param _builtins.bool read_only: If true, mount the GCS bucket as read-only
        """
        pulumi.set(__self__, "bucket", bucket)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        GCS Bucket name
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of flags to pass to the gcsfuse command for configuring this volume.
        Flags should be passed without leading dashes.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, mount the GCS bucket as read-only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class ServiceTemplateVolumeNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 server: _builtins.str,
                 read_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str path: Path that is exported by the NFS server.
        :param _builtins.str server: Hostname or IP address of the NFS server
        :param _builtins.bool read_only: If true, mount the NFS volume as read only
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "server", server)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        Hostname or IP address of the NFS server
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, mount the NFS volume as read only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class ServiceTemplateVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret: _builtins.str,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.ServiceTemplateVolumeSecretItem']] = None):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param _builtins.int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['ServiceTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.ServiceTemplateVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class ServiceTemplateVolumeSecretItem(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 mode: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: The relative path of the secret in the container.
        :param _builtins.int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "path", path)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ServiceTemplateVpcAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTemplateVpcAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTemplateVpcAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTemplateVpcAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector: Optional[_builtins.str] = None,
                 egress: Optional[_builtins.str] = None,
                 network_interfaces: Optional[Sequence['outputs.ServiceTemplateVpcAccessNetworkInterface']] = None):
        """
        :param _builtins.str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param _builtins.str egress: Traffic VPC egress settings.
               Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        :param Sequence['ServiceTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
               Structure is documented below.
        """
        if connector is not None:
            pulumi.set(__self__, "connector", connector)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @_builtins.property
    @pulumi.getter
    def connector(self) -> Optional[_builtins.str]:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @_builtins.property
    @pulumi.getter
    def egress(self) -> Optional[_builtins.str]:
        """
        Traffic VPC egress settings.
        Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.ServiceTemplateVpcAccessNetworkInterface']]:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class ServiceTemplateVpcAccessNetworkInterface(dict):
    def __init__(__self__, *,
                 network: Optional[_builtins.str] = None,
                 subnetwork: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param _builtins.str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Run service.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Network tags applied to this Cloud Run service.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ServiceTerminalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceTerminalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceTerminalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceTerminalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 revision_reason: Optional[_builtins.str] = None,
                 severity: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str execution_reason: (Output)
               A reason for the execution condition.
        :param _builtins.str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: (Output)
               A reason for the revision condition.
        :param _builtins.str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: (Output)
               State of the condition.
        :param _builtins.str type: (Output)
               The allocation type for this traffic target.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTraffic(dict):
    def __init__(__self__, *,
                 percent: Optional[_builtins.int] = None,
                 revision: Optional[_builtins.str] = None,
                 tag: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param _builtins.str revision: Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param _builtins.str tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param _builtins.str type: The allocation type for this traffic target.
               Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.int]:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The allocation type for this traffic target.
        Possible values are: `TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST`, `TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceTrafficStatus(dict):
    def __init__(__self__, *,
                 percent: Optional[_builtins.int] = None,
                 revision: Optional[_builtins.str] = None,
                 tag: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.int percent: (Output)
               Specifies percent of the traffic to this Revision.
        :param _builtins.str revision: (Output)
               Revision to which this traffic is sent.
        :param _builtins.str tag: (Output)
               Indicates the string used in the URI to exclusively reference this target.
        :param _builtins.str type: (Output)
               The allocation type for this traffic target.
        :param _builtins.str uri: (Output)
               Displays the target URI.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.int]:
        """
        (Output)
        Specifies percent of the traffic to this Revision.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        (Output)
        Revision to which this traffic is sent.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        (Output)
        Indicates the string used in the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        Displays the target URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class WorkerPoolBinaryAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "breakglassJustification":
            suggest = "breakglass_justification"
        elif key == "useDefault":
            suggest = "use_default"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolBinaryAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolBinaryAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolBinaryAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 breakglass_justification: Optional[_builtins.str] = None,
                 policy: Optional[_builtins.str] = None,
                 use_default: Optional[_builtins.bool] = None):
        """
        :param _builtins.str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param _builtins.str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param _builtins.bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        if breakglass_justification is not None:
            pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if use_default is not None:
            pulumi.set(__self__, "use_default", use_default)

    @_builtins.property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> Optional[_builtins.str]:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[_builtins.str]:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> Optional[_builtins.bool]:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class WorkerPoolCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 revision_reason: Optional[_builtins.str] = None,
                 severity: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str execution_reason: (Output)
               A reason for the execution condition.
        :param _builtins.str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               A common (workerPool-level) reason for this condition.
        :param _builtins.str revision_reason: (Output)
               A reason for the revision condition.
        :param _builtins.str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: (Output)
               State of the condition.
        :param _builtins.str type: (Output)
               The allocation type for this instance split.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A common (workerPool-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The allocation type for this instance split.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkerPoolIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class WorkerPoolIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class WorkerPoolInstanceSplit(dict):
    def __init__(__self__, *,
                 percent: Optional[_builtins.int] = None,
                 revision: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int percent: Specifies percent of the instance split to this Revision. This defaults to zero if unspecified.
        :param _builtins.str revision: Revision to which to assign this portion of instances, if split allocation is by revision.
        :param _builtins.str type: The allocation type for this instance split.
               Possible values are: `INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST`, `INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION`.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.int]:
        """
        Specifies percent of the instance split to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        Revision to which to assign this portion of instances, if split allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The allocation type for this instance split.
        Possible values are: `INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST`, `INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkerPoolInstanceSplitStatus(dict):
    def __init__(__self__, *,
                 percent: Optional[_builtins.int] = None,
                 revision: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int percent: (Output)
               Specifies percent of the instance split to this Revision.
        :param _builtins.str revision: (Output)
               Revision to which this instance split is assigned.
        :param _builtins.str type: (Output)
               The allocation type for this instance split.
        """
        if percent is not None:
            pulumi.set(__self__, "percent", percent)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> Optional[_builtins.int]:
        """
        (Output)
        Specifies percent of the instance split to this Revision.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        (Output)
        Revision to which this instance split is assigned.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The allocation type for this instance split.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkerPoolScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manualInstanceCount":
            suggest = "manual_instance_count"
        elif key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"
        elif key == "scalingMode":
            suggest = "scaling_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manual_instance_count: Optional[_builtins.int] = None,
                 max_instance_count: Optional[_builtins.int] = None,
                 min_instance_count: Optional[_builtins.int] = None,
                 scaling_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.int manual_instance_count: The total number of instances in manual scaling mode.
        :param _builtins.int max_instance_count: The maximum count of instances distributed among revisions based on the specified instance split percentages.
        :param _builtins.int min_instance_count: The minimum count of instances distributed among revisions based on the specified instance split percentages.
        :param _builtins.str scaling_mode: The scaling mode for the worker pool. It defaults to MANUAL.
               Possible values are: `AUTOMATIC`, `MANUAL`.
        """
        if manual_instance_count is not None:
            pulumi.set(__self__, "manual_instance_count", manual_instance_count)
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if scaling_mode is not None:
            pulumi.set(__self__, "scaling_mode", scaling_mode)

    @_builtins.property
    @pulumi.getter(name="manualInstanceCount")
    def manual_instance_count(self) -> Optional[_builtins.int]:
        """
        The total number of instances in manual scaling mode.
        """
        return pulumi.get(self, "manual_instance_count")

    @_builtins.property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[_builtins.int]:
        """
        The maximum count of instances distributed among revisions based on the specified instance split percentages.
        """
        return pulumi.get(self, "max_instance_count")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[_builtins.int]:
        """
        The minimum count of instances distributed among revisions based on the specified instance split percentages.
        """
        return pulumi.get(self, "min_instance_count")

    @_builtins.property
    @pulumi.getter(name="scalingMode")
    def scaling_mode(self) -> Optional[_builtins.str]:
        """
        The scaling mode for the worker pool. It defaults to MANUAL.
        Possible values are: `AUTOMATIC`, `MANUAL`.
        """
        return pulumi.get(self, "scaling_mode")


@pulumi.output_type
class WorkerPoolTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "encryptionKeyRevocationAction":
            suggest = "encryption_key_revocation_action"
        elif key == "encryptionKeyShutdownDuration":
            suggest = "encryption_key_shutdown_duration"
        elif key == "gpuZonalRedundancyDisabled":
            suggest = "gpu_zonal_redundancy_disabled"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "vpcAccess":
            suggest = "vpc_access"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotations: Optional[Mapping[str, _builtins.str]] = None,
                 containers: Optional[Sequence['outputs.WorkerPoolTemplateContainer']] = None,
                 encryption_key: Optional[_builtins.str] = None,
                 encryption_key_revocation_action: Optional[_builtins.str] = None,
                 encryption_key_shutdown_duration: Optional[_builtins.str] = None,
                 gpu_zonal_redundancy_disabled: Optional[_builtins.bool] = None,
                 labels: Optional[Mapping[str, _builtins.str]] = None,
                 node_selector: Optional['outputs.WorkerPoolTemplateNodeSelector'] = None,
                 revision: Optional[_builtins.str] = None,
                 service_account: Optional[_builtins.str] = None,
                 volumes: Optional[Sequence['outputs.WorkerPoolTemplateVolume']] = None,
                 vpc_access: Optional['outputs.WorkerPoolTemplateVpcAccess'] = None):
        """
        :param Mapping[str, _builtins.str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Sequence['WorkerPoolTemplateContainerArgs'] containers: Holds the containers that define the unit of execution for this WorkerPool.
               Structure is documented below.
        :param _builtins.str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param _builtins.str encryption_key_revocation_action: The action to take if the encryption key is revoked.
               Possible values are: `PREVENT_NEW`, `SHUTDOWN`.
        :param _builtins.str encryption_key_shutdown_duration: If encryptionKeyRevocationAction is SHUTDOWN, the duration before shutting down all instances. The minimum increment is 1 hour.
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param _builtins.bool gpu_zonal_redundancy_disabled: True if GPU zonal redundancy is disabled on this revision.
        :param Mapping[str, _builtins.str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
               For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.
        :param 'WorkerPoolTemplateNodeSelectorArgs' node_selector: Node Selector describes the hardware requirements of the resources.
               Structure is documented below.
        :param _builtins.str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the WorkerPool name.
        :param _builtins.str service_account: Email address of the IAM service account associated with the revision of the WorkerPool. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param Sequence['WorkerPoolTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
               Structure is documented below.
        :param 'WorkerPoolTemplateVpcAccessArgs' vpc_access: VPC Access configuration to use for this Revision. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
               Structure is documented below.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_key_revocation_action is not None:
            pulumi.set(__self__, "encryption_key_revocation_action", encryption_key_revocation_action)
        if encryption_key_shutdown_duration is not None:
            pulumi.set(__self__, "encryption_key_shutdown_duration", encryption_key_shutdown_duration)
        if gpu_zonal_redundancy_disabled is not None:
            pulumi.set(__self__, "gpu_zonal_redundancy_disabled", gpu_zonal_redundancy_disabled)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if node_selector is not None:
            pulumi.set(__self__, "node_selector", node_selector)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if vpc_access is not None:
            pulumi.set(__self__, "vpc_access", vpc_access)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Optional[Sequence['outputs.WorkerPoolTemplateContainer']]:
        """
        Holds the containers that define the unit of execution for this WorkerPool.
        Structure is documented below.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[_builtins.str]:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyRevocationAction")
    def encryption_key_revocation_action(self) -> Optional[_builtins.str]:
        """
        The action to take if the encryption key is revoked.
        Possible values are: `PREVENT_NEW`, `SHUTDOWN`.
        """
        return pulumi.get(self, "encryption_key_revocation_action")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyShutdownDuration")
    def encryption_key_shutdown_duration(self) -> Optional[_builtins.str]:
        """
        If encryptionKeyRevocationAction is SHUTDOWN, the duration before shutting down all instances. The minimum increment is 1 hour.
        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "encryption_key_shutdown_duration")

    @_builtins.property
    @pulumi.getter(name="gpuZonalRedundancyDisabled")
    def gpu_zonal_redundancy_disabled(self) -> Optional[_builtins.bool]:
        """
        True if GPU zonal redundancy is disabled on this revision.
        """
        return pulumi.get(self, "gpu_zonal_redundancy_disabled")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
        For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> Optional['outputs.WorkerPoolTemplateNodeSelector']:
        """
        Node Selector describes the hardware requirements of the resources.
        Structure is documented below.
        """
        return pulumi.get(self, "node_selector")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[_builtins.str]:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the WorkerPool name.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Email address of the IAM service account associated with the revision of the WorkerPool. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.WorkerPoolTemplateVolume']]:
        """
        A list of Volumes to make available to containers.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcAccess")
    def vpc_access(self) -> Optional['outputs.WorkerPoolTemplateVpcAccess']:
        """
        VPC Access configuration to use for this Revision. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_access")


@pulumi.output_type
class WorkerPoolTemplateContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dependsOns":
            suggest = "depends_ons"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: _builtins.str,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 depends_ons: Optional[Sequence[_builtins.str]] = None,
                 envs: Optional[Sequence['outputs.WorkerPoolTemplateContainerEnv']] = None,
                 name: Optional[_builtins.str] = None,
                 resources: Optional['outputs.WorkerPoolTemplateContainerResources'] = None,
                 volume_mounts: Optional[Sequence['outputs.WorkerPoolTemplateContainerVolumeMount']] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param _builtins.str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] depends_ons: Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        :param Sequence['WorkerPoolTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
               Structure is documented below.
        :param _builtins.str name: Name of the container specified as a DNS_LABEL.
        :param 'WorkerPoolTemplateContainerResourcesArgs' resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
               Structure is documented below.
        :param Sequence['WorkerPoolTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
               Structure is documented below.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if depends_ons is not None:
            pulumi.set(__self__, "depends_ons", depends_ons)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Optional[Sequence[_builtins.str]]:
        """
        Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        """
        return pulumi.get(self, "depends_ons")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.WorkerPoolTemplateContainerEnv']]:
        """
        List of environment variables to set in the container.
        Structure is documented below.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the container specified as a DNS_LABEL.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Optional['outputs.WorkerPoolTemplateContainerResources']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        Structure is documented below.
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.WorkerPoolTemplateContainerVolumeMount']]:
        """
        Volume to mount into the container's filesystem.
        Structure is documented below.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class WorkerPoolTemplateContainerEnv(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueSource":
            suggest = "value_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateContainerEnv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateContainerEnv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateContainerEnv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 value: Optional[_builtins.str] = None,
                 value_source: Optional['outputs.WorkerPoolTemplateContainerEnvValueSource'] = None):
        """
        :param _builtins.str name: Name of the environment variable. Must be a C_IDENTIFIER, and may not exceed 32768 characters.
        :param _builtins.str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param 'WorkerPoolTemplateContainerEnvValueSourceArgs' value_source: Source for the environment variable's value.
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_source is not None:
            pulumi.set(__self__, "value_source", value_source)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER, and may not exceed 32768 characters.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> Optional[_builtins.str]:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueSource")
    def value_source(self) -> Optional['outputs.WorkerPoolTemplateContainerEnvValueSource']:
        """
        Source for the environment variable's value.
        Structure is documented below.
        """
        return pulumi.get(self, "value_source")


@pulumi.output_type
class WorkerPoolTemplateContainerEnvValueSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretKeyRef":
            suggest = "secret_key_ref"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateContainerEnvValueSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateContainerEnvValueSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateContainerEnvValueSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_key_ref: Optional['outputs.WorkerPoolTemplateContainerEnvValueSourceSecretKeyRef'] = None):
        """
        :param 'WorkerPoolTemplateContainerEnvValueSourceSecretKeyRefArgs' secret_key_ref: Selects a secret and a specific version from Cloud Secret Manager.
               Structure is documented below.
        """
        if secret_key_ref is not None:
            pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @_builtins.property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> Optional['outputs.WorkerPoolTemplateContainerEnvValueSourceSecretKeyRef']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_key_ref")


@pulumi.output_type
class WorkerPoolTemplateContainerEnvValueSourceSecretKeyRef(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WorkerPoolTemplateContainerResources(dict):
    def __init__(__self__, *,
                 limits: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key `cpu` for CPU limit, `memory` for memory limit, `nvidia.com/gpu` for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class WorkerPoolTemplateContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param _builtins.str name: This must match the Name of a Volume.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WorkerPoolTemplateNodeSelector(dict):
    def __init__(__self__, *,
                 accelerator: _builtins.str):
        """
        :param _builtins.str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @_builtins.property
    @pulumi.getter
    def accelerator(self) -> _builtins.str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class WorkerPoolTemplateVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlInstance":
            suggest = "cloud_sql_instance"
        elif key == "emptyDir":
            suggest = "empty_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 cloud_sql_instance: Optional['outputs.WorkerPoolTemplateVolumeCloudSqlInstance'] = None,
                 empty_dir: Optional['outputs.WorkerPoolTemplateVolumeEmptyDir'] = None,
                 gcs: Optional['outputs.WorkerPoolTemplateVolumeGcs'] = None,
                 nfs: Optional['outputs.WorkerPoolTemplateVolumeNfs'] = None,
                 secret: Optional['outputs.WorkerPoolTemplateVolumeSecret'] = None):
        """
        :param _builtins.str name: Volume's name.
        :param 'WorkerPoolTemplateVolumeCloudSqlInstanceArgs' cloud_sql_instance: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
               Structure is documented below.
        :param 'WorkerPoolTemplateVolumeEmptyDirArgs' empty_dir: Ephemeral storage used as a shared volume.
               Structure is documented below.
        :param 'WorkerPoolTemplateVolumeGcsArgs' gcs: Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
               Structure is documented below.
        :param 'WorkerPoolTemplateVolumeNfsArgs' nfs: Represents an NFS mount.
               Structure is documented below.
        :param 'WorkerPoolTemplateVolumeSecretArgs' secret: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
               Structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        if cloud_sql_instance is not None:
            pulumi.set(__self__, "cloud_sql_instance", cloud_sql_instance)
        if empty_dir is not None:
            pulumi.set(__self__, "empty_dir", empty_dir)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstance")
    def cloud_sql_instance(self) -> Optional['outputs.WorkerPoolTemplateVolumeCloudSqlInstance']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_sql_instance")

    @_builtins.property
    @pulumi.getter(name="emptyDir")
    def empty_dir(self) -> Optional['outputs.WorkerPoolTemplateVolumeEmptyDir']:
        """
        Ephemeral storage used as a shared volume.
        Structure is documented below.
        """
        return pulumi.get(self, "empty_dir")

    @_builtins.property
    @pulumi.getter
    def gcs(self) -> Optional['outputs.WorkerPoolTemplateVolumeGcs']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.WorkerPoolTemplateVolumeNfs']:
        """
        Represents an NFS mount.
        Structure is documented below.
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> Optional['outputs.WorkerPoolTemplateVolumeSecret']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        Structure is documented below.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class WorkerPoolTemplateVolumeCloudSqlInstance(dict):
    def __init__(__self__, *,
                 instances: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Optional[Sequence[_builtins.str]]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class WorkerPoolTemplateVolumeEmptyDir(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeLimit":
            suggest = "size_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateVolumeEmptyDir. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateVolumeEmptyDir.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateVolumeEmptyDir.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 medium: Optional[_builtins.str] = None,
                 size_limit: Optional[_builtins.str] = None):
        """
        :param _builtins.str medium: The different types of medium supported for EmptyDir.
               Default value is `MEMORY`.
               Possible values are: `MEMORY`.
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        if medium is not None:
            pulumi.set(__self__, "medium", medium)
        if size_limit is not None:
            pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> Optional[_builtins.str]:
        """
        The different types of medium supported for EmptyDir.
        Default value is `MEMORY`.
        Possible values are: `MEMORY`.
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> Optional[_builtins.str]:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class WorkerPoolTemplateVolumeGcs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateVolumeGcs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateVolumeGcs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateVolumeGcs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 mount_options: Optional[Sequence[_builtins.str]] = None,
                 read_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str bucket: GCS Bucket name
        :param Sequence[_builtins.str] mount_options: A list of flags to pass to the gcsfuse command for configuring this volume.
               Flags should be passed without leading dashes.
        :param _builtins.bool read_only: If true, mount the GCS bucket as read-only
        """
        pulumi.set(__self__, "bucket", bucket)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        GCS Bucket name
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of flags to pass to the gcsfuse command for configuring this volume.
        Flags should be passed without leading dashes.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, mount the GCS bucket as read-only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class WorkerPoolTemplateVolumeNfs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateVolumeNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateVolumeNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateVolumeNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 server: _builtins.str,
                 read_only: Optional[_builtins.bool] = None):
        """
        :param _builtins.str path: Path that is exported by the NFS server.
        :param _builtins.str server: Hostname or IP address of the NFS server
        :param _builtins.bool read_only: If true, mount the NFS volume as read only
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "server", server)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        Hostname or IP address of the NFS server
        """
        return pulumi.get(self, "server")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        If true, mount the NFS volume as read only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class WorkerPoolTemplateVolumeSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMode":
            suggest = "default_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateVolumeSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateVolumeSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateVolumeSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret: _builtins.str,
                 default_mode: Optional[_builtins.int] = None,
                 items: Optional[Sequence['outputs.WorkerPoolTemplateVolumeSecretItem']] = None):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        :param _builtins.int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['WorkerPoolTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret", secret)
        if default_mode is not None:
            pulumi.set(__self__, "default_mode", default_mode)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> Optional[_builtins.int]:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Optional[Sequence['outputs.WorkerPoolTemplateVolumeSecretItem']]:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        Structure is documented below.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class WorkerPoolTemplateVolumeSecretItem(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 mode: Optional[_builtins.int] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: The relative path of the secret in the container.
        :param _builtins.int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "path", path)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.int]:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WorkerPoolTemplateVpcAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaces":
            suggest = "network_interfaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTemplateVpcAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTemplateVpcAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTemplateVpcAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 egress: Optional[_builtins.str] = None,
                 network_interfaces: Optional[Sequence['outputs.WorkerPoolTemplateVpcAccessNetworkInterface']] = None):
        """
        :param _builtins.str egress: Traffic VPC egress settings.
               Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        :param Sequence['WorkerPoolTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
               Structure is documented below.
        """
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @_builtins.property
    @pulumi.getter
    def egress(self) -> Optional[_builtins.str]:
        """
        Traffic VPC egress settings.
        Possible values are: `ALL_TRAFFIC`, `PRIVATE_RANGES_ONLY`.
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[Sequence['outputs.WorkerPoolTemplateVpcAccessNetworkInterface']]:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        Structure is documented below.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class WorkerPoolTemplateVpcAccessNetworkInterface(dict):
    def __init__(__self__, *,
                 network: Optional[_builtins.str] = None,
                 subnetwork: Optional[_builtins.str] = None,
                 tags: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param _builtins.str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Run WorkerPool.
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[_builtins.str]:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Network tags applied to this Cloud Run WorkerPool.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class WorkerPoolTerminalCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionReason":
            suggest = "execution_reason"
        elif key == "lastTransitionTime":
            suggest = "last_transition_time"
        elif key == "revisionReason":
            suggest = "revision_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolTerminalCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolTerminalCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolTerminalCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_reason: Optional[_builtins.str] = None,
                 last_transition_time: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 reason: Optional[_builtins.str] = None,
                 revision_reason: Optional[_builtins.str] = None,
                 severity: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str execution_reason: (Output)
               A reason for the execution condition.
        :param _builtins.str last_transition_time: (Output)
               Last time the condition transitioned from one status to another.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        :param _builtins.str reason: (Output)
               A common (workerPool-level) reason for this condition.
        :param _builtins.str revision_reason: (Output)
               A reason for the revision condition.
        :param _builtins.str severity: (Output)
               How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: (Output)
               State of the condition.
        :param _builtins.str type: (Output)
               The allocation type for this instance split.
        """
        if execution_reason is not None:
            pulumi.set(__self__, "execution_reason", execution_reason)
        if last_transition_time is not None:
            pulumi.set(__self__, "last_transition_time", last_transition_time)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)
        if revision_reason is not None:
            pulumi.set(__self__, "revision_reason", revision_reason)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        Last time the condition transitioned from one status to another.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A common (workerPool-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> Optional[_builtins.str]:
        """
        (Output)
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[_builtins.str]:
        """
        (Output)
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        (Output)
        The allocation type for this instance split.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetJobBinaryAuthorizationResult(dict):
    def __init__(__self__, *,
                 breakglass_justification: _builtins.str,
                 policy: _builtins.str,
                 use_default: _builtins.bool):
        """
        :param _builtins.str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param _builtins.str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param _builtins.bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "use_default", use_default)

    @_builtins.property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> _builtins.str:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> _builtins.bool:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class GetJobConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: _builtins.str,
                 last_transition_time: _builtins.str,
                 message: _builtins.str,
                 reason: _builtins.str,
                 revision_reason: _builtins.str,
                 severity: _builtins.str,
                 state: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str execution_reason: A reason for the execution condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: Human readable message indicating details about the current status.
        :param _builtins.str reason: A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: A reason for the revision condition.
        :param _builtins.str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: State of the condition.
        :param _builtins.str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> _builtins.str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> _builtins.str:
        """
        Last time the condition transitioned from one status to another.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> _builtins.str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetJobLatestCreatedExecutionResult(dict):
    def __init__(__self__, *,
                 completion_time: _builtins.str,
                 create_time: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str completion_time: Completion timestamp of the execution.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str create_time: Creation timestamp of the execution.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str name: The name of the Cloud Run v2 Job.
        """
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> _builtins.str:
        """
        Completion timestamp of the execution.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "completion_time")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Creation timestamp of the execution.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobTemplateResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 labels: Mapping[str, _builtins.str],
                 parallelism: _builtins.int,
                 task_count: _builtins.int,
                 templates: Sequence['outputs.GetJobTemplateTemplateResult']):
        """
        :param Mapping[str, _builtins.str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               
               Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
               
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Mapping[str, _builtins.str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
               or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
               https://cloud.google.com/run/docs/configuring/labels.
               
               Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        :param _builtins.int parallelism: Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        :param _builtins.int task_count: Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        :param Sequence['GetJobTemplateTemplateArgs'] templates: Describes the task(s) that will be created when executing an execution
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "task_count", task_count)
        pulumi.set(__self__, "templates", templates)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.

        Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 ExecutionTemplate.

        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter,
        or break down billing charges by team, component, environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or
        https://cloud.google.com/run/docs/configuring/labels.

        Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 ExecutionTemplate.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> _builtins.int:
        """
        Specifies the maximum desired number of tasks the execution should run at given time. Must be <= taskCount. When the job is run, if this field is 0 or unset, the maximum possible value will be used for that execution. The actual number of tasks running in steady state will be less than this number when there are fewer tasks waiting to be completed remaining, i.e. when the work left to do is less than max parallelism.
        """
        return pulumi.get(self, "parallelism")

    @_builtins.property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> _builtins.int:
        """
        Specifies the desired number of tasks the execution should run. Setting to 1 means that parallelism is limited to 1 and the success of that task signals the success of the execution. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
        """
        return pulumi.get(self, "task_count")

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Sequence['outputs.GetJobTemplateTemplateResult']:
        """
        Describes the task(s) that will be created when executing an execution
        """
        return pulumi.get(self, "templates")


@pulumi.output_type
class GetJobTemplateTemplateResult(dict):
    def __init__(__self__, *,
                 containers: Sequence['outputs.GetJobTemplateTemplateContainerResult'],
                 encryption_key: _builtins.str,
                 execution_environment: _builtins.str,
                 max_retries: _builtins.int,
                 node_selectors: Sequence['outputs.GetJobTemplateTemplateNodeSelectorResult'],
                 service_account: _builtins.str,
                 timeout: _builtins.str,
                 volumes: Sequence['outputs.GetJobTemplateTemplateVolumeResult'],
                 vpc_accesses: Sequence['outputs.GetJobTemplateTemplateVpcAccessResult']):
        """
        :param Sequence['GetJobTemplateTemplateContainerArgs'] containers: Holds the single container that defines the unit of execution for this task.
        :param _builtins.str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param _builtins.str execution_environment: The execution environment being used to host this Task. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        :param _builtins.int max_retries: Number of retries allowed per Task, before marking this Task failed. Defaults to 3. Minimum value is 0.
        :param Sequence['GetJobTemplateTemplateNodeSelectorArgs'] node_selectors: Node Selector describes the hardware requirements of the resources.
        :param _builtins.str service_account: Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        :param _builtins.str timeout: Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.
               
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['GetJobTemplateTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
        :param Sequence['GetJobTemplateTemplateVpcAccessArgs'] vpc_accesses: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "execution_environment", execution_environment)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "node_selectors", node_selectors)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_accesses", vpc_accesses)

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetJobTemplateTemplateContainerResult']:
        """
        Holds the single container that defines the unit of execution for this task.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> _builtins.str:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> _builtins.str:
        """
        The execution environment being used to host this Task. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        """
        return pulumi.get(self, "execution_environment")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> _builtins.int:
        """
        Number of retries allowed per Task, before marking this Task failed. Defaults to 3. Minimum value is 0.
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter(name="nodeSelectors")
    def node_selectors(self) -> Sequence['outputs.GetJobTemplateTemplateNodeSelectorResult']:
        """
        Node Selector describes the hardware requirements of the resources.
        """
        return pulumi.get(self, "node_selectors")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        Email address of the IAM service account associated with the Task of a Job. The service account represents the identity of the running task, and determines what permissions the task has. If not provided, the task will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.str:
        """
        Max allowed time duration the Task may be active before the system will actively try to mark it failed and kill associated containers. This applies per attempt of a task, meaning each retry can run for the full timeout.

        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeResult']:
        """
        A list of Volumes to make available to containers.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcAccesses")
    def vpc_accesses(self) -> Sequence['outputs.GetJobTemplateTemplateVpcAccessResult']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        return pulumi.get(self, "vpc_accesses")


@pulumi.output_type
class GetJobTemplateTemplateContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 commands: Sequence[_builtins.str],
                 depends_ons: Sequence[_builtins.str],
                 envs: Sequence['outputs.GetJobTemplateTemplateContainerEnvResult'],
                 image: _builtins.str,
                 name: _builtins.str,
                 ports: Sequence['outputs.GetJobTemplateTemplateContainerPortResult'],
                 resources: Sequence['outputs.GetJobTemplateTemplateContainerResourceResult'],
                 startup_probes: Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeResult'],
                 volume_mounts: Sequence['outputs.GetJobTemplateTemplateContainerVolumeMountResult'],
                 working_dir: _builtins.str):
        """
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] depends_ons: Names of the containers that must start before this container.
        :param Sequence['GetJobTemplateTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
        :param _builtins.str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param _builtins.str name: The name of the Cloud Run v2 Job.
        :param Sequence['GetJobTemplateTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        :param Sequence['GetJobTemplateTemplateContainerResourceArgs'] resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param Sequence['GetJobTemplateTemplateContainerStartupProbeArgs'] startup_probes: Startup probe of application within the container.
               All other probes are disabled if a startup probe is provided, until it
               succeeds. Container will not be added to service endpoints if the probe fails.
        :param Sequence['GetJobTemplateTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "depends_ons", depends_ons)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "startup_probes", startup_probes)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Sequence[_builtins.str]:
        """
        Names of the containers that must start before this container.
        """
        return pulumi.get(self, "depends_ons")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetJobTemplateTemplateContainerEnvResult']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetJobTemplateTemplateContainerPortResult']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.

        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetJobTemplateTemplateContainerResourceResult']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeResult']:
        """
        Startup probe of application within the container.
        All other probes are disabled if a startup probe is provided, until it
        succeeds. Container will not be added to service endpoints if the probe fails.
        """
        return pulumi.get(self, "startup_probes")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetJobTemplateTemplateContainerVolumeMountResult']:
        """
        Volume to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> _builtins.str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetJobTemplateTemplateContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 value_sources: Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceResult']):
        """
        :param _builtins.str name: The name of the Cloud Run v2 Job.
        :param _builtins.str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param Sequence['GetJobTemplateTemplateContainerEnvValueSourceArgs'] value_sources: Source for the environment variable's value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_sources", value_sources)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueSources")
    def value_sources(self) -> Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceResult']:
        """
        Source for the environment variable's value.
        """
        return pulumi.get(self, "value_sources")


@pulumi.output_type
class GetJobTemplateTemplateContainerEnvValueSourceResult(dict):
    def __init__(__self__, *,
                 secret_key_reves: Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult']):
        """
        :param Sequence['GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefArgs'] secret_key_reves: Selects a secret and a specific version from Cloud Secret Manager.
        """
        pulumi.set(__self__, "secret_key_reves", secret_key_reves)

    @_builtins.property
    @pulumi.getter(name="secretKeyReves")
    def secret_key_reves(self) -> Sequence['outputs.GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        """
        return pulumi.get(self, "secret_key_reves")


@pulumi.output_type
class GetJobTemplateTemplateContainerEnvValueSourceSecretKeyRefResult(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetJobTemplateTemplateContainerPortResult(dict):
    def __init__(__self__, *,
                 container_port: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param _builtins.str name: The name of the Cloud Run v2 Job.
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> _builtins.int:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobTemplateTemplateContainerResourceResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        pulumi.set(__self__, "limits", limits)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Mapping[str, _builtins.str]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class GetJobTemplateTemplateContainerStartupProbeResult(dict):
    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 grpcs: Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeGrpcResult'],
                 http_gets: Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeHttpGetResult'],
                 initial_delay_seconds: _builtins.int,
                 period_seconds: _builtins.int,
                 tcp_sockets: Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeTcpSocketResult'],
                 timeout_seconds: _builtins.int):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after
               having succeeded. Defaults to 3. Minimum value is 1.
        :param Sequence['GetJobTemplateTemplateContainerStartupProbeGrpcArgs'] grpcs: GRPC specifies an action involving a GRPC port.
        :param Sequence['GetJobTemplateTemplateContainerStartupProbeHttpGetArgs'] http_gets: HttpGet specifies the http request to perform.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is
               initiated.
               Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe.
               Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        :param Sequence['GetJobTemplateTemplateContainerStartupProbeTcpSocketArgs'] tcp_sockets: TcpSocket specifies an action involving a TCP port.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out.
               Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
               Must be smaller than periodSeconds.
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpcs", grpcs)
        pulumi.set(__self__, "http_gets", http_gets)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpcs(self) -> Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeGrpcResult']:
        """
        GRPC specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpcs")

    @_builtins.property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeHttpGetResult']:
        """
        HttpGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_gets")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> _builtins.int:
        """
        Number of seconds after the container has started before the probe is
        initiated.
        Defaults to 0 seconds. Minimum value is 0. Maximum value is 240.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> _builtins.int:
        """
        How often (in seconds) to perform the probe.
        Default to 10 seconds. Minimum value is 1. Maximum value is 240.
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeTcpSocketResult']:
        """
        TcpSocket specifies an action involving a TCP port.
        """
        return pulumi.get(self, "tcp_sockets")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        Number of seconds after which the probe times out.
        Defaults to 1 second. Minimum value is 1. Maximum value is 3600.
        Must be smaller than periodSeconds.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetJobTemplateTemplateContainerStartupProbeGrpcResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 service: _builtins.str):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetJobTemplateTemplateContainerStartupProbeHttpGetResult(dict):
    def __init__(__self__, *,
                 http_headers: Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderResult'],
                 path: _builtins.str,
                 port: _builtins.int):
        """
        :param Sequence['GetJobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param _builtins.str path: Path to access on the HTTP server. If set, it should not be empty string.
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.GetJobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderResult']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to access on the HTTP server. If set, it should not be empty string.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetJobTemplateTemplateContainerStartupProbeHttpGetHttpHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Cloud Run v2 Job.
        :param _builtins.str value: The header field value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The header field value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetJobTemplateTemplateContainerStartupProbeTcpSocketResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetJobTemplateTemplateContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param _builtins.str name: The name of the Cloud Run v2 Job.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetJobTemplateTemplateNodeSelectorResult(dict):
    def __init__(__self__, *,
                 accelerator: _builtins.str):
        """
        :param _builtins.str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/jobs/gpu for configuring GPU.
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @_builtins.property
    @pulumi.getter
    def accelerator(self) -> _builtins.str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/jobs/gpu for configuring GPU.
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class GetJobTemplateTemplateVolumeResult(dict):
    def __init__(__self__, *,
                 cloud_sql_instances: Sequence['outputs.GetJobTemplateTemplateVolumeCloudSqlInstanceResult'],
                 empty_dirs: Sequence['outputs.GetJobTemplateTemplateVolumeEmptyDirResult'],
                 gcs: Sequence['outputs.GetJobTemplateTemplateVolumeGcResult'],
                 name: _builtins.str,
                 nfs: Sequence['outputs.GetJobTemplateTemplateVolumeNfResult'],
                 secrets: Sequence['outputs.GetJobTemplateTemplateVolumeSecretResult']):
        """
        :param Sequence['GetJobTemplateTemplateVolumeCloudSqlInstanceArgs'] cloud_sql_instances: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        :param Sequence['GetJobTemplateTemplateVolumeEmptyDirArgs'] empty_dirs: Ephemeral storage used as a shared volume.
        :param Sequence['GetJobTemplateTemplateVolumeGcArgs'] gcs: Cloud Storage bucket mounted as a volume using GCSFuse.
        :param _builtins.str name: The name of the Cloud Run v2 Job.
        :param Sequence['GetJobTemplateTemplateVolumeNfArgs'] nfs: NFS share mounted as a volume.
        :param Sequence['GetJobTemplateTemplateVolumeSecretArgs'] secrets: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        pulumi.set(__self__, "cloud_sql_instances", cloud_sql_instances)
        pulumi.set(__self__, "empty_dirs", empty_dirs)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs", nfs)
        pulumi.set(__self__, "secrets", secrets)

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstances")
    def cloud_sql_instances(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeCloudSqlInstanceResult']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        """
        return pulumi.get(self, "cloud_sql_instances")

    @_builtins.property
    @pulumi.getter(name="emptyDirs")
    def empty_dirs(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeEmptyDirResult']:
        """
        Ephemeral storage used as a shared volume.
        """
        return pulumi.get(self, "empty_dirs")

    @_builtins.property
    @pulumi.getter
    def gcs(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeGcResult']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse.
        """
        return pulumi.get(self, "gcs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeNfResult']:
        """
        NFS share mounted as a volume.
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeSecretResult']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class GetJobTemplateTemplateVolumeCloudSqlInstanceResult(dict):
    def __init__(__self__, *,
                 instances: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence[_builtins.str]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class GetJobTemplateTemplateVolumeEmptyDirResult(dict):
    def __init__(__self__, *,
                 medium: _builtins.str,
                 size_limit: _builtins.str):
        """
        :param _builtins.str medium: The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> _builtins.str:
        """
        The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> _builtins.str:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetJobTemplateTemplateVolumeGcResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 mount_options: Sequence[_builtins.str],
                 read_only: _builtins.bool):
        """
        :param _builtins.str bucket: Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        :param Sequence[_builtins.str] mount_options: A list of flags to pass to the gcsfuse command for configuring this volume.
               Flags should be passed without leading dashes.
        :param _builtins.bool read_only: If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Name of the cloud storage bucket to back the volume. The resource service account must have permission to access the bucket.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Sequence[_builtins.str]:
        """
        A list of flags to pass to the gcsfuse command for configuring this volume.
        Flags should be passed without leading dashes.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, mount this volume as read-only in all mounts. If false, mount this volume as read-write.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetJobTemplateTemplateVolumeNfResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 read_only: _builtins.bool,
                 server: _builtins.str):
        """
        :param _builtins.str path: Path that is exported by the NFS server.
        :param _builtins.bool read_only: If true, mount this volume as read-only in all mounts.
        :param _builtins.str server: Hostname or IP address of the NFS server.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, mount this volume as read-only in all mounts.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        Hostname or IP address of the NFS server.
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetJobTemplateTemplateVolumeSecretResult(dict):
    def __init__(__self__, *,
                 default_mode: _builtins.int,
                 items: Sequence['outputs.GetJobTemplateTemplateVolumeSecretItemResult'],
                 secret: _builtins.str):
        """
        :param _builtins.int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['GetJobTemplateTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> _builtins.int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetJobTemplateTemplateVolumeSecretItemResult']:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetJobTemplateTemplateVolumeSecretItemResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.int,
                 path: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param _builtins.str path: The relative path of the secret in the container.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetJobTemplateTemplateVpcAccessResult(dict):
    def __init__(__self__, *,
                 connector: _builtins.str,
                 egress: _builtins.str,
                 network_interfaces: Sequence['outputs.GetJobTemplateTemplateVpcAccessNetworkInterfaceResult']):
        """
        :param _builtins.str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param _builtins.str egress: Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        :param Sequence['GetJobTemplateTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
        """
        pulumi.set(__self__, "connector", connector)
        pulumi.set(__self__, "egress", egress)
        pulumi.set(__self__, "network_interfaces", network_interfaces)

    @_builtins.property
    @pulumi.getter
    def connector(self) -> _builtins.str:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @_builtins.property
    @pulumi.getter
    def egress(self) -> _builtins.str:
        """
        Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetJobTemplateTemplateVpcAccessNetworkInterfaceResult']:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class GetJobTemplateTemplateVpcAccessNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 network: _builtins.str,
                 subnetwork: _builtins.str,
                 tags: Sequence[_builtins.str]):
        """
        :param _builtins.str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param _builtins.str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Run job.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> _builtins.str:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Network tags applied to this Cloud Run job.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetJobTerminalConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: _builtins.str,
                 last_transition_time: _builtins.str,
                 message: _builtins.str,
                 reason: _builtins.str,
                 revision_reason: _builtins.str,
                 severity: _builtins.str,
                 state: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str execution_reason: A reason for the execution condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: Human readable message indicating details about the current status.
        :param _builtins.str reason: A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: A reason for the revision condition.
        :param _builtins.str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: State of the condition.
        :param _builtins.str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> _builtins.str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> _builtins.str:
        """
        Last time the condition transitioned from one status to another.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> _builtins.str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceBinaryAuthorizationResult(dict):
    def __init__(__self__, *,
                 breakglass_justification: _builtins.str,
                 policy: _builtins.str,
                 use_default: _builtins.bool):
        """
        :param _builtins.str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param _builtins.str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param _builtins.bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "use_default", use_default)

    @_builtins.property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> _builtins.str:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> _builtins.bool:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class GetServiceBuildConfigResult(dict):
    def __init__(__self__, *,
                 base_image: _builtins.str,
                 enable_automatic_updates: _builtins.bool,
                 environment_variables: Mapping[str, _builtins.str],
                 function_target: _builtins.str,
                 image_uri: _builtins.str,
                 name: _builtins.str,
                 service_account: _builtins.str,
                 source_location: _builtins.str,
                 worker_pool: _builtins.str):
        """
        :param _builtins.str base_image: The base image used to build the function.
        :param _builtins.bool enable_automatic_updates: Sets whether the function will receive automatic base image updates.
        :param Mapping[str, _builtins.str] environment_variables: User-provided build-time environment variables for the function.
        :param _builtins.str function_target: The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function".
        :param _builtins.str image_uri: Artifact Registry URI to store the built image.
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        :param _builtins.str service_account: Service account to be used for building the container. The format of this field is 'projects/{projectId}/serviceAccounts/{serviceAccountEmail}'.
        :param _builtins.str source_location: The Cloud Storage bucket URI where the function source code is located.
        :param _builtins.str worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the Cloud Run function. The format of this field is 'projects/{project}/locations/{region}/workerPools/{workerPool}' where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool.
        """
        pulumi.set(__self__, "base_image", base_image)
        pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        pulumi.set(__self__, "environment_variables", environment_variables)
        pulumi.set(__self__, "function_target", function_target)
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "source_location", source_location)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @_builtins.property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> _builtins.str:
        """
        The base image used to build the function.
        """
        return pulumi.get(self, "base_image")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> _builtins.bool:
        """
        Sets whether the function will receive automatic base image updates.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, _builtins.str]:
        """
        User-provided build-time environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="functionTarget")
    def function_target(self) -> _builtins.str:
        """
        The name of the function (as defined in source code) that will be executed. Defaults to the resource name suffix, if not specified. For backward compatibility, if function with given name is not found, then the system will try to use function named "function".
        """
        return pulumi.get(self, "function_target")

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> _builtins.str:
        """
        Artifact Registry URI to store the built image.
        """
        return pulumi.get(self, "image_uri")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        Service account to be used for building the container. The format of this field is 'projects/{projectId}/serviceAccounts/{serviceAccountEmail}'.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> _builtins.str:
        """
        The Cloud Storage bucket URI where the function source code is located.
        """
        return pulumi.get(self, "source_location")

    @_builtins.property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> _builtins.str:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the Cloud Run function. The format of this field is 'projects/{project}/locations/{region}/workerPools/{workerPool}' where {project} and {region} are the project id and region respectively where the worker pool is defined and {workerPool} is the short name of the worker pool.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class GetServiceConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: _builtins.str,
                 last_transition_time: _builtins.str,
                 message: _builtins.str,
                 reason: _builtins.str,
                 revision_reason: _builtins.str,
                 severity: _builtins.str,
                 state: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str execution_reason: A reason for the execution condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: Human readable message indicating details about the current status.
        :param _builtins.str reason: A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: A reason for the revision condition.
        :param _builtins.str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: State of the condition.
        :param _builtins.str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> _builtins.str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> _builtins.str:
        """
        Last time the condition transitioned from one status to another.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> _builtins.str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceScalingResult(dict):
    def __init__(__self__, *,
                 manual_instance_count: _builtins.int,
                 min_instance_count: _builtins.int,
                 scaling_mode: _builtins.str):
        """
        :param _builtins.int manual_instance_count: Total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
        :param _builtins.int min_instance_count: Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        :param _builtins.str scaling_mode: The [scaling mode](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#scalingmode) for the service. Possible values: ["AUTOMATIC", "MANUAL"]
        """
        pulumi.set(__self__, "manual_instance_count", manual_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)
        pulumi.set(__self__, "scaling_mode", scaling_mode)

    @_builtins.property
    @pulumi.getter(name="manualInstanceCount")
    def manual_instance_count(self) -> _builtins.int:
        """
        Total instance count for the service in manual scaling mode. This number of instances is divided among all revisions with specified traffic based on the percent of traffic they are receiving.
        """
        return pulumi.get(self, "manual_instance_count")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> _builtins.int:
        """
        Minimum number of instances for the service, to be divided among all revisions receiving traffic.
        """
        return pulumi.get(self, "min_instance_count")

    @_builtins.property
    @pulumi.getter(name="scalingMode")
    def scaling_mode(self) -> _builtins.str:
        """
        The [scaling mode](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.services#scalingmode) for the service. Possible values: ["AUTOMATIC", "MANUAL"]
        """
        return pulumi.get(self, "scaling_mode")


@pulumi.output_type
class GetServiceTemplateResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 containers: Sequence['outputs.GetServiceTemplateContainerResult'],
                 encryption_key: _builtins.str,
                 execution_environment: _builtins.str,
                 gpu_zonal_redundancy_disabled: _builtins.bool,
                 labels: Mapping[str, _builtins.str],
                 max_instance_request_concurrency: _builtins.int,
                 node_selectors: Sequence['outputs.GetServiceTemplateNodeSelectorResult'],
                 revision: _builtins.str,
                 scalings: Sequence['outputs.GetServiceTemplateScalingResult'],
                 service_account: _builtins.str,
                 service_meshes: Sequence['outputs.GetServiceTemplateServiceMeshResult'],
                 session_affinity: _builtins.bool,
                 timeout: _builtins.str,
                 volumes: Sequence['outputs.GetServiceTemplateVolumeResult'],
                 vpc_accesses: Sequence['outputs.GetServiceTemplateVpcAccessResult']):
        """
        :param Mapping[str, _builtins.str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               
               Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.
               
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Sequence['GetServiceTemplateContainerArgs'] containers: Holds the containers that define the unit of execution for this Service.
        :param _builtins.str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param _builtins.str execution_environment: The sandbox environment to host this Revision. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        :param _builtins.bool gpu_zonal_redundancy_disabled: True if GPU zonal redundancy is disabled on this revision.
        :param Mapping[str, _builtins.str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
               For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               
               Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        :param _builtins.int max_instance_request_concurrency: Sets the maximum number of requests that each serving instance can receive.
               If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        :param Sequence['GetServiceTemplateNodeSelectorArgs'] node_selectors: Node Selector describes the hardware requirements of the resources.
        :param _builtins.str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        :param Sequence['GetServiceTemplateScalingArgs'] scalings: Scaling settings for this Revision.
        :param _builtins.str service_account: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param Sequence['GetServiceTemplateServiceMeshArgs'] service_meshes: Enables Cloud Service Mesh for this Revision.
        :param _builtins.bool session_affinity: Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        :param _builtins.str timeout: Max allowed time for an instance to respond to a request.
               
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param Sequence['GetServiceTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
        :param Sequence['GetServiceTemplateVpcAccessArgs'] vpc_accesses: VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "execution_environment", execution_environment)
        pulumi.set(__self__, "gpu_zonal_redundancy_disabled", gpu_zonal_redundancy_disabled)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        pulumi.set(__self__, "node_selectors", node_selectors)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "scalings", scalings)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "service_meshes", service_meshes)
        pulumi.set(__self__, "session_affinity", session_affinity)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_accesses", vpc_accesses)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.

        Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 RevisionTemplate.

        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetServiceTemplateContainerResult']:
        """
        Holds the containers that define the unit of execution for this Service.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> _builtins.str:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="executionEnvironment")
    def execution_environment(self) -> _builtins.str:
        """
        The sandbox environment to host this Revision. Possible values: ["EXECUTION_ENVIRONMENT_GEN1", "EXECUTION_ENVIRONMENT_GEN2"]
        """
        return pulumi.get(self, "execution_environment")

    @_builtins.property
    @pulumi.getter(name="gpuZonalRedundancyDisabled")
    def gpu_zonal_redundancy_disabled(self) -> _builtins.bool:
        """
        True if GPU zonal redundancy is disabled on this revision.
        """
        return pulumi.get(self, "gpu_zonal_redundancy_disabled")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
        For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.

        Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 RevisionTemplate.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> _builtins.int:
        """
        Sets the maximum number of requests that each serving instance can receive.
        If not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1 when requested CPU < 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @_builtins.property
    @pulumi.getter(name="nodeSelectors")
    def node_selectors(self) -> Sequence['outputs.GetServiceTemplateNodeSelectorResult']:
        """
        Node Selector describes the hardware requirements of the resources.
        """
        return pulumi.get(self, "node_selectors")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the Service name.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def scalings(self) -> Sequence['outputs.GetServiceTemplateScalingResult']:
        """
        Scaling settings for this Revision.
        """
        return pulumi.get(self, "scalings")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="serviceMeshes")
    def service_meshes(self) -> Sequence['outputs.GetServiceTemplateServiceMeshResult']:
        """
        Enables Cloud Service Mesh for this Revision.
        """
        return pulumi.get(self, "service_meshes")

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> _builtins.bool:
        """
        Enables session affinity. For more information, go to https://cloud.google.com/run/docs/configuring/session-affinity
        """
        return pulumi.get(self, "session_affinity")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.str:
        """
        Max allowed time for an instance to respond to a request.

        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetServiceTemplateVolumeResult']:
        """
        A list of Volumes to make available to containers.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcAccesses")
    def vpc_accesses(self) -> Sequence['outputs.GetServiceTemplateVpcAccessResult']:
        """
        VPC Access configuration to use for this Task. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        return pulumi.get(self, "vpc_accesses")


@pulumi.output_type
class GetServiceTemplateContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 base_image_uri: _builtins.str,
                 build_infos: Sequence['outputs.GetServiceTemplateContainerBuildInfoResult'],
                 commands: Sequence[_builtins.str],
                 depends_ons: Sequence[_builtins.str],
                 envs: Sequence['outputs.GetServiceTemplateContainerEnvResult'],
                 image: _builtins.str,
                 liveness_probes: Sequence['outputs.GetServiceTemplateContainerLivenessProbeResult'],
                 name: _builtins.str,
                 ports: Sequence['outputs.GetServiceTemplateContainerPortResult'],
                 resources: Sequence['outputs.GetServiceTemplateContainerResourceResult'],
                 startup_probes: Sequence['outputs.GetServiceTemplateContainerStartupProbeResult'],
                 volume_mounts: Sequence['outputs.GetServiceTemplateContainerVolumeMountResult'],
                 working_dir: _builtins.str):
        """
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param _builtins.str base_image_uri: Base image for this container. If set, it indicates that the service is enrolled into automatic base image update.
        :param Sequence['GetServiceTemplateContainerBuildInfoArgs'] build_infos: The build info of the container image.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] depends_ons: Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        :param Sequence['GetServiceTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
        :param _builtins.str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param Sequence['GetServiceTemplateContainerLivenessProbeArgs'] liveness_probes: Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        :param Sequence['GetServiceTemplateContainerPortArgs'] ports: List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.
               
               If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        :param Sequence['GetServiceTemplateContainerResourceArgs'] resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param Sequence['GetServiceTemplateContainerStartupProbeArgs'] startup_probes: Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param Sequence['GetServiceTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "base_image_uri", base_image_uri)
        pulumi.set(__self__, "build_infos", build_infos)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "depends_ons", depends_ons)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "liveness_probes", liveness_probes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "startup_probes", startup_probes)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter(name="baseImageUri")
    def base_image_uri(self) -> _builtins.str:
        """
        Base image for this container. If set, it indicates that the service is enrolled into automatic base image update.
        """
        return pulumi.get(self, "base_image_uri")

    @_builtins.property
    @pulumi.getter(name="buildInfos")
    def build_infos(self) -> Sequence['outputs.GetServiceTemplateContainerBuildInfoResult']:
        """
        The build info of the container image.
        """
        return pulumi.get(self, "build_infos")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Sequence[_builtins.str]:
        """
        Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        """
        return pulumi.get(self, "depends_ons")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetServiceTemplateContainerEnvResult']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="livenessProbes")
    def liveness_probes(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeResult']:
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "liveness_probes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.GetServiceTemplateContainerPortResult']:
        """
        List of ports to expose from the container. Only a single port can be specified. The specified ports must be listening on all interfaces (0.0.0.0) within the container to be accessible.

        If omitted, a port number will be chosen and passed to the container through the PORT environment variable for the container to listen on
        """
        return pulumi.get(self, "ports")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetServiceTemplateContainerResourceResult']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="startupProbes")
    def startup_probes(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeResult']:
        """
        Startup probe of application within the container. All other probes are disabled if a startup probe is provided, until it succeeds. Container will not be added to service endpoints if the probe fails. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "startup_probes")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetServiceTemplateContainerVolumeMountResult']:
        """
        Volume to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> _builtins.str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetServiceTemplateContainerBuildInfoResult(dict):
    def __init__(__self__, *,
                 function_target: _builtins.str,
                 source_location: _builtins.str):
        """
        :param _builtins.str function_target: Entry point of the function when the image is a Cloud Run function.
        :param _builtins.str source_location: Source code location of the image.
        """
        pulumi.set(__self__, "function_target", function_target)
        pulumi.set(__self__, "source_location", source_location)

    @_builtins.property
    @pulumi.getter(name="functionTarget")
    def function_target(self) -> _builtins.str:
        """
        Entry point of the function when the image is a Cloud Run function.
        """
        return pulumi.get(self, "function_target")

    @_builtins.property
    @pulumi.getter(name="sourceLocation")
    def source_location(self) -> _builtins.str:
        """
        Source code location of the image.
        """
        return pulumi.get(self, "source_location")


@pulumi.output_type
class GetServiceTemplateContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 value_sources: Sequence['outputs.GetServiceTemplateContainerEnvValueSourceResult']):
        """
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        :param _builtins.str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param Sequence['GetServiceTemplateContainerEnvValueSourceArgs'] value_sources: Source for the environment variable's value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_sources", value_sources)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueSources")
    def value_sources(self) -> Sequence['outputs.GetServiceTemplateContainerEnvValueSourceResult']:
        """
        Source for the environment variable's value.
        """
        return pulumi.get(self, "value_sources")


@pulumi.output_type
class GetServiceTemplateContainerEnvValueSourceResult(dict):
    def __init__(__self__, *,
                 secret_key_reves: Sequence['outputs.GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult']):
        """
        :param Sequence['GetServiceTemplateContainerEnvValueSourceSecretKeyRefArgs'] secret_key_reves: Selects a secret and a specific version from Cloud Secret Manager.
        """
        pulumi.set(__self__, "secret_key_reves", secret_key_reves)

    @_builtins.property
    @pulumi.getter(name="secretKeyReves")
    def secret_key_reves(self) -> Sequence['outputs.GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        """
        return pulumi.get(self, "secret_key_reves")


@pulumi.output_type
class GetServiceTemplateContainerEnvValueSourceSecretKeyRefResult(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeResult(dict):
    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 grpcs: Sequence['outputs.GetServiceTemplateContainerLivenessProbeGrpcResult'],
                 http_gets: Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetResult'],
                 initial_delay_seconds: _builtins.int,
                 period_seconds: _builtins.int,
                 tcp_sockets: Sequence['outputs.GetServiceTemplateContainerLivenessProbeTcpSocketResult'],
                 timeout_seconds: _builtins.int):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param Sequence['GetServiceTemplateContainerLivenessProbeGrpcArgs'] grpcs: GRPC specifies an action involving a GRPC port.
        :param Sequence['GetServiceTemplateContainerLivenessProbeHttpGetArgs'] http_gets: HTTPGet specifies the http request to perform.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param Sequence['GetServiceTemplateContainerLivenessProbeTcpSocketArgs'] tcp_sockets: TCPSocketAction describes an action based on opening a socket
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpcs", grpcs)
        pulumi.set(__self__, "http_gets", http_gets)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpcs(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeGrpcResult']:
        """
        GRPC specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpcs")

    @_builtins.property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetResult']:
        """
        HTTPGet specifies the http request to perform.
        """
        return pulumi.get(self, "http_gets")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> _builtins.int:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> _builtins.int:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeTcpSocketResult']:
        """
        TCPSocketAction describes an action based on opening a socket
        """
        return pulumi.get(self, "tcp_sockets")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeGrpcResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 service: _builtins.str):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeHttpGetResult(dict):
    def __init__(__self__, *,
                 http_headers: Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult'],
                 path: _builtins.str,
                 port: _builtins.int):
        """
        :param Sequence['GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param _builtins.str path: Path to access on the HTTP server. Defaults to '/'.
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeHttpGetHttpHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        :param _builtins.str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceTemplateContainerLivenessProbeTcpSocketResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int):
        """
        :param _builtins.int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the exposed port of the container, which
               is the value of container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the exposed port of the container, which
        is the value of container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerPortResult(dict):
    def __init__(__self__, *,
                 container_port: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.int container_port: Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> _builtins.int:
        """
        Port number the container listens on. This must be a valid TCP port number, 0 < containerPort < 65536.
        """
        return pulumi.get(self, "container_port")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateContainerResourceResult(dict):
    def __init__(__self__, *,
                 cpu_idle: _builtins.bool,
                 limits: Mapping[str, _builtins.str],
                 startup_cpu_boost: _builtins.bool):
        """
        :param _builtins.bool cpu_idle: Determines whether CPU is only allocated during requests. True by default if the parent 'resources' field is not set. However, if
               'resources' is set, this field must be explicitly set to true to preserve the default behavior.
        :param Mapping[str, _builtins.str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param _builtins.bool startup_cpu_boost: Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        pulumi.set(__self__, "cpu_idle", cpu_idle)
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "startup_cpu_boost", startup_cpu_boost)

    @_builtins.property
    @pulumi.getter(name="cpuIdle")
    def cpu_idle(self) -> _builtins.bool:
        """
        Determines whether CPU is only allocated during requests. True by default if the parent 'resources' field is not set. However, if
        'resources' is set, this field must be explicitly set to true to preserve the default behavior.
        """
        return pulumi.get(self, "cpu_idle")

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Mapping[str, _builtins.str]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @_builtins.property
    @pulumi.getter(name="startupCpuBoost")
    def startup_cpu_boost(self) -> _builtins.bool:
        """
        Determines whether CPU should be boosted on startup of a new container instance above the requested CPU threshold, this can help reduce cold-start latency.
        """
        return pulumi.get(self, "startup_cpu_boost")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeResult(dict):
    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 grpcs: Sequence['outputs.GetServiceTemplateContainerStartupProbeGrpcResult'],
                 http_gets: Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetResult'],
                 initial_delay_seconds: _builtins.int,
                 period_seconds: _builtins.int,
                 tcp_sockets: Sequence['outputs.GetServiceTemplateContainerStartupProbeTcpSocketResult'],
                 timeout_seconds: _builtins.int):
        """
        :param _builtins.int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        :param Sequence['GetServiceTemplateContainerStartupProbeGrpcArgs'] grpcs: GRPC specifies an action involving a GRPC port.
        :param Sequence['GetServiceTemplateContainerStartupProbeHttpGetArgs'] http_gets: HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        :param _builtins.int initial_delay_seconds: Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        :param _builtins.int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        :param Sequence['GetServiceTemplateContainerStartupProbeTcpSocketArgs'] tcp_sockets: TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        :param _builtins.int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "grpcs", grpcs)
        pulumi.set(__self__, "http_gets", http_gets)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "tcp_sockets", tcp_sockets)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def grpcs(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeGrpcResult']:
        """
        GRPC specifies an action involving a GRPC port.
        """
        return pulumi.get(self, "grpcs")

    @_builtins.property
    @pulumi.getter(name="httpGets")
    def http_gets(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetResult']:
        """
        HTTPGet specifies the http request to perform. Exactly one of HTTPGet or TCPSocket must be specified.
        """
        return pulumi.get(self, "http_gets")

    @_builtins.property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> _builtins.int:
        """
        Number of seconds after the container has started before the probe is initiated. Defaults to 0 seconds. Minimum value is 0. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "initial_delay_seconds")

    @_builtins.property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> _builtins.int:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe is 3600. Maximum value for startup probe is 240. Must be greater or equal than timeoutSeconds
        """
        return pulumi.get(self, "period_seconds")

    @_builtins.property
    @pulumi.getter(name="tcpSockets")
    def tcp_sockets(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeTcpSocketResult']:
        """
        TCPSocket specifies an action involving a TCP port. Exactly one of HTTPGet or TCPSocket must be specified.
        """
        return pulumi.get(self, "tcp_sockets")

    @_builtins.property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> _builtins.int:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than periodSeconds. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeGrpcResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int,
                 service: _builtins.str):
        """
        :param _builtins.int port: Port number to access on the container. Number must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        :param _builtins.str service: The name of the service to place in the gRPC HealthCheckRequest
               (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
               If this is not specified, the default behavior is defined by gRPC.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Number must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The name of the service to place in the gRPC HealthCheckRequest
        (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
        If this is not specified, the default behavior is defined by gRPC.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeHttpGetResult(dict):
    def __init__(__self__, *,
                 http_headers: Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult'],
                 path: _builtins.str,
                 port: _builtins.int):
        """
        :param Sequence['GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :param _builtins.str path: Path to access on the HTTP server. Defaults to '/'.
        :param _builtins.int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult']:
        """
        Custom headers to set in the request. HTTP allows repeated headers.
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to access on the HTTP server. Defaults to '/'.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeHttpGetHttpHeaderResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        :param _builtins.str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The header field value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceTemplateContainerStartupProbeTcpSocketResult(dict):
    def __init__(__self__, *,
                 port: _builtins.int):
        """
        :param _builtins.int port: Port number to access on the container. Must be in the range 1 to 65535.
               If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port number to access on the container. Must be in the range 1 to 65535.
        If not specified, defaults to the same value as container.ports[0].containerPort.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GetServiceTemplateContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetServiceTemplateNodeSelectorResult(dict):
    def __init__(__self__, *,
                 accelerator: _builtins.str):
        """
        :param _builtins.str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @_builtins.property
    @pulumi.getter
    def accelerator(self) -> _builtins.str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class GetServiceTemplateScalingResult(dict):
    def __init__(__self__, *,
                 max_instance_count: _builtins.int,
                 min_instance_count: _builtins.int):
        """
        :param _builtins.int max_instance_count: Maximum number of serving instances that this resource should have. Must not be less than minimum instance count. If absent, Cloud Run will calculate
               a default value based on the project's available container instances quota in the region and specified instance size.
        :param _builtins.int min_instance_count: Minimum number of serving instances that this resource should have. Defaults to 0. Must not be greater than maximum instance count.
        """
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)

    @_builtins.property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> _builtins.int:
        """
        Maximum number of serving instances that this resource should have. Must not be less than minimum instance count. If absent, Cloud Run will calculate
        a default value based on the project's available container instances quota in the region and specified instance size.
        """
        return pulumi.get(self, "max_instance_count")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> _builtins.int:
        """
        Minimum number of serving instances that this resource should have. Defaults to 0. Must not be greater than maximum instance count.
        """
        return pulumi.get(self, "min_instance_count")


@pulumi.output_type
class GetServiceTemplateServiceMeshResult(dict):
    def __init__(__self__, *,
                 mesh: _builtins.str):
        """
        :param _builtins.str mesh: The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        pulumi.set(__self__, "mesh", mesh)

    @_builtins.property
    @pulumi.getter
    def mesh(self) -> _builtins.str:
        """
        The Mesh resource name. For more information see https://cloud.google.com/service-mesh/docs/reference/network-services/rest/v1/projects.locations.meshes#resource:-mesh.
        """
        return pulumi.get(self, "mesh")


@pulumi.output_type
class GetServiceTemplateVolumeResult(dict):
    def __init__(__self__, *,
                 cloud_sql_instances: Sequence['outputs.GetServiceTemplateVolumeCloudSqlInstanceResult'],
                 empty_dirs: Sequence['outputs.GetServiceTemplateVolumeEmptyDirResult'],
                 gcs: Sequence['outputs.GetServiceTemplateVolumeGcResult'],
                 name: _builtins.str,
                 nfs: Sequence['outputs.GetServiceTemplateVolumeNfResult'],
                 secrets: Sequence['outputs.GetServiceTemplateVolumeSecretResult']):
        """
        :param Sequence['GetServiceTemplateVolumeCloudSqlInstanceArgs'] cloud_sql_instances: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        :param Sequence['GetServiceTemplateVolumeEmptyDirArgs'] empty_dirs: Ephemeral storage used as a shared volume.
        :param Sequence['GetServiceTemplateVolumeGcArgs'] gcs: Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        :param _builtins.str name: The name of the Cloud Run v2 Service.
        :param Sequence['GetServiceTemplateVolumeNfArgs'] nfs: Represents an NFS mount.
        :param Sequence['GetServiceTemplateVolumeSecretArgs'] secrets: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        pulumi.set(__self__, "cloud_sql_instances", cloud_sql_instances)
        pulumi.set(__self__, "empty_dirs", empty_dirs)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs", nfs)
        pulumi.set(__self__, "secrets", secrets)

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstances")
    def cloud_sql_instances(self) -> Sequence['outputs.GetServiceTemplateVolumeCloudSqlInstanceResult']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        """
        return pulumi.get(self, "cloud_sql_instances")

    @_builtins.property
    @pulumi.getter(name="emptyDirs")
    def empty_dirs(self) -> Sequence['outputs.GetServiceTemplateVolumeEmptyDirResult']:
        """
        Ephemeral storage used as a shared volume.
        """
        return pulumi.get(self, "empty_dirs")

    @_builtins.property
    @pulumi.getter
    def gcs(self) -> Sequence['outputs.GetServiceTemplateVolumeGcResult']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        """
        return pulumi.get(self, "gcs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Service.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Sequence['outputs.GetServiceTemplateVolumeNfResult']:
        """
        Represents an NFS mount.
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetServiceTemplateVolumeSecretResult']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class GetServiceTemplateVolumeCloudSqlInstanceResult(dict):
    def __init__(__self__, *,
                 instances: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence[_builtins.str]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class GetServiceTemplateVolumeEmptyDirResult(dict):
    def __init__(__self__, *,
                 medium: _builtins.str,
                 size_limit: _builtins.str):
        """
        :param _builtins.str medium: The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> _builtins.str:
        """
        The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> _builtins.str:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetServiceTemplateVolumeGcResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 mount_options: Sequence[_builtins.str],
                 read_only: _builtins.bool):
        """
        :param _builtins.str bucket: GCS Bucket name
        :param Sequence[_builtins.str] mount_options: A list of flags to pass to the gcsfuse command for configuring this volume.
               Flags should be passed without leading dashes.
        :param _builtins.bool read_only: If true, mount the GCS bucket as read-only
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        GCS Bucket name
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Sequence[_builtins.str]:
        """
        A list of flags to pass to the gcsfuse command for configuring this volume.
        Flags should be passed without leading dashes.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, mount the GCS bucket as read-only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetServiceTemplateVolumeNfResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 read_only: _builtins.bool,
                 server: _builtins.str):
        """
        :param _builtins.str path: Path that is exported by the NFS server.
        :param _builtins.bool read_only: If true, mount the NFS volume as read only
        :param _builtins.str server: Hostname or IP address of the NFS server
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, mount the NFS volume as read only
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        Hostname or IP address of the NFS server
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetServiceTemplateVolumeSecretResult(dict):
    def __init__(__self__, *,
                 default_mode: _builtins.int,
                 items: Sequence['outputs.GetServiceTemplateVolumeSecretItemResult'],
                 secret: _builtins.str):
        """
        :param _builtins.int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['GetServiceTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> _builtins.int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceTemplateVolumeSecretItemResult']:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetServiceTemplateVolumeSecretItemResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.int,
                 path: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param _builtins.str path: The relative path of the secret in the container.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetServiceTemplateVpcAccessResult(dict):
    def __init__(__self__, *,
                 connector: _builtins.str,
                 egress: _builtins.str,
                 network_interfaces: Sequence['outputs.GetServiceTemplateVpcAccessNetworkInterfaceResult']):
        """
        :param _builtins.str connector: VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        :param _builtins.str egress: Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        :param Sequence['GetServiceTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
        """
        pulumi.set(__self__, "connector", connector)
        pulumi.set(__self__, "egress", egress)
        pulumi.set(__self__, "network_interfaces", network_interfaces)

    @_builtins.property
    @pulumi.getter
    def connector(self) -> _builtins.str:
        """
        VPC Access connector name. Format: projects/{project}/locations/{location}/connectors/{connector}, where {project} can be project id or number.
        """
        return pulumi.get(self, "connector")

    @_builtins.property
    @pulumi.getter
    def egress(self) -> _builtins.str:
        """
        Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetServiceTemplateVpcAccessNetworkInterfaceResult']:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class GetServiceTemplateVpcAccessNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 network: _builtins.str,
                 subnetwork: _builtins.str,
                 tags: Sequence[_builtins.str]):
        """
        :param _builtins.str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param _builtins.str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Run service.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> _builtins.str:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Network tags applied to this Cloud Run service.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetServiceTerminalConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: _builtins.str,
                 last_transition_time: _builtins.str,
                 message: _builtins.str,
                 reason: _builtins.str,
                 revision_reason: _builtins.str,
                 severity: _builtins.str,
                 state: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str execution_reason: A reason for the execution condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: Human readable message indicating details about the current status.
        :param _builtins.str reason: A common (service-level) reason for this condition.
        :param _builtins.str revision_reason: A reason for the revision condition.
        :param _builtins.str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: State of the condition.
        :param _builtins.str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> _builtins.str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> _builtins.str:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        A common (service-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> _builtins.str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceTrafficResult(dict):
    def __init__(__self__, *,
                 percent: _builtins.int,
                 revision: _builtins.str,
                 tag: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int percent: Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        :param _builtins.str revision: Revision to which to send this portion of traffic, if traffic allocation is by revision.
        :param _builtins.str tag: Indicates a string to be part of the URI to exclusively reference this target.
        :param _builtins.str type: The allocation type for this traffic target. Possible values: ["TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST", "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION"]
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Specifies percent of the traffic to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        Revision to which to send this portion of traffic, if traffic allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Indicates a string to be part of the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The allocation type for this traffic target. Possible values: ["TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST", "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION"]
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetServiceTrafficStatusResult(dict):
    def __init__(__self__, *,
                 percent: _builtins.int,
                 revision: _builtins.str,
                 tag: _builtins.str,
                 type: _builtins.str,
                 uri: _builtins.str):
        """
        :param _builtins.int percent: Specifies percent of the traffic to this Revision.
        :param _builtins.str revision: Revision to which this traffic is sent.
        :param _builtins.str tag: Indicates the string used in the URI to exclusively reference this target.
        :param _builtins.str type: The allocation type for this traffic target.
        :param _builtins.str uri: Displays the target URI.
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Specifies percent of the traffic to this Revision.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        Revision to which this traffic is sent.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Indicates the string used in the URI to exclusively reference this target.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The allocation type for this traffic target.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        Displays the target URI.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GetWorkerPoolBinaryAuthorizationResult(dict):
    def __init__(__self__, *,
                 breakglass_justification: _builtins.str,
                 policy: _builtins.str,
                 use_default: _builtins.bool):
        """
        :param _builtins.str breakglass_justification: If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        :param _builtins.str policy: The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        :param _builtins.bool use_default: If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        pulumi.set(__self__, "breakglass_justification", breakglass_justification)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "use_default", use_default)

    @_builtins.property
    @pulumi.getter(name="breakglassJustification")
    def breakglass_justification(self) -> _builtins.str:
        """
        If present, indicates to use Breakglass using this justification. If useDefault is False, then it must be empty. For more information on breakglass, see https://cloud.google.com/binary-authorization/docs/using-breakglass
        """
        return pulumi.get(self, "breakglass_justification")

    @_builtins.property
    @pulumi.getter
    def policy(self) -> _builtins.str:
        """
        The path to a binary authorization policy. Format: projects/{project}/platforms/cloudRun/{policy-name}
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="useDefault")
    def use_default(self) -> _builtins.bool:
        """
        If True, indicates to use the default project's binary authorization policy. If False, binary authorization will be disabled.
        """
        return pulumi.get(self, "use_default")


@pulumi.output_type
class GetWorkerPoolConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: _builtins.str,
                 last_transition_time: _builtins.str,
                 message: _builtins.str,
                 reason: _builtins.str,
                 revision_reason: _builtins.str,
                 severity: _builtins.str,
                 state: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str execution_reason: A reason for the execution condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str message: Human readable message indicating details about the current status.
        :param _builtins.str reason: A common (workerPool-level) reason for this condition.
        :param _builtins.str revision_reason: A reason for the revision condition.
        :param _builtins.str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: State of the condition.
        :param _builtins.str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> _builtins.str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> _builtins.str:
        """
        Last time the condition transitioned from one status to another.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        A common (workerPool-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> _builtins.str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetWorkerPoolInstanceSplitResult(dict):
    def __init__(__self__, *,
                 percent: _builtins.int,
                 revision: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int percent: Specifies percent of the instance split to this Revision. This defaults to zero if unspecified.
        :param _builtins.str revision: Revision to which to assign this portion of instances, if split allocation is by revision.
        :param _builtins.str type: The allocation type for this instance split. Possible values: ["INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST", "INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION"]
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Specifies percent of the instance split to this Revision. This defaults to zero if unspecified.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        Revision to which to assign this portion of instances, if split allocation is by revision.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The allocation type for this instance split. Possible values: ["INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST", "INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION"]
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetWorkerPoolInstanceSplitStatusResult(dict):
    def __init__(__self__, *,
                 percent: _builtins.int,
                 revision: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int percent: Specifies percent of the instance split to this Revision.
        :param _builtins.str revision: Revision to which this instance split is assigned.
        :param _builtins.str type: The allocation type for this instance split.
        """
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def percent(self) -> _builtins.int:
        """
        Specifies percent of the instance split to this Revision.
        """
        return pulumi.get(self, "percent")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        Revision to which this instance split is assigned.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The allocation type for this instance split.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetWorkerPoolScalingResult(dict):
    def __init__(__self__, *,
                 manual_instance_count: _builtins.int,
                 max_instance_count: _builtins.int,
                 min_instance_count: _builtins.int,
                 scaling_mode: _builtins.str):
        """
        :param _builtins.int manual_instance_count: The total number of instances in manual scaling mode.
        :param _builtins.int max_instance_count: The maximum count of instances distributed among revisions based on the specified instance split percentages.
        :param _builtins.int min_instance_count: The minimum count of instances distributed among revisions based on the specified instance split percentages.
        :param _builtins.str scaling_mode: The scaling mode for the worker pool. It defaults to MANUAL. Possible values: ["AUTOMATIC", "MANUAL"]
        """
        pulumi.set(__self__, "manual_instance_count", manual_instance_count)
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "min_instance_count", min_instance_count)
        pulumi.set(__self__, "scaling_mode", scaling_mode)

    @_builtins.property
    @pulumi.getter(name="manualInstanceCount")
    def manual_instance_count(self) -> _builtins.int:
        """
        The total number of instances in manual scaling mode.
        """
        return pulumi.get(self, "manual_instance_count")

    @_builtins.property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> _builtins.int:
        """
        The maximum count of instances distributed among revisions based on the specified instance split percentages.
        """
        return pulumi.get(self, "max_instance_count")

    @_builtins.property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> _builtins.int:
        """
        The minimum count of instances distributed among revisions based on the specified instance split percentages.
        """
        return pulumi.get(self, "min_instance_count")

    @_builtins.property
    @pulumi.getter(name="scalingMode")
    def scaling_mode(self) -> _builtins.str:
        """
        The scaling mode for the worker pool. It defaults to MANUAL. Possible values: ["AUTOMATIC", "MANUAL"]
        """
        return pulumi.get(self, "scaling_mode")


@pulumi.output_type
class GetWorkerPoolTemplateResult(dict):
    def __init__(__self__, *,
                 annotations: Mapping[str, _builtins.str],
                 containers: Sequence['outputs.GetWorkerPoolTemplateContainerResult'],
                 encryption_key: _builtins.str,
                 encryption_key_revocation_action: _builtins.str,
                 encryption_key_shutdown_duration: _builtins.str,
                 gpu_zonal_redundancy_disabled: _builtins.bool,
                 labels: Mapping[str, _builtins.str],
                 node_selectors: Sequence['outputs.GetWorkerPoolTemplateNodeSelectorResult'],
                 revision: _builtins.str,
                 service_account: _builtins.str,
                 volumes: Sequence['outputs.GetWorkerPoolTemplateVolumeResult'],
                 vpc_accesses: Sequence['outputs.GetWorkerPoolTemplateVpcAccessResult']):
        """
        :param Mapping[str, _builtins.str] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               
               Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system annotations in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.
               
               This field follows Kubernetes annotations' namespacing, limits, and rules.
        :param Sequence['GetWorkerPoolTemplateContainerArgs'] containers: Holds the containers that define the unit of execution for this WorkerPool.
        :param _builtins.str encryption_key: A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        :param _builtins.str encryption_key_revocation_action: The action to take if the encryption key is revoked. Possible values: ["PREVENT_NEW", "SHUTDOWN"]
        :param _builtins.str encryption_key_shutdown_duration: If encryptionKeyRevocationAction is SHUTDOWN, the duration before shutting down all instances. The minimum increment is 1 hour.
               
               A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        :param _builtins.bool gpu_zonal_redundancy_disabled: True if GPU zonal redundancy is disabled on this revision.
        :param Mapping[str, _builtins.str] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
               For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               
               Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.
        :param Sequence['GetWorkerPoolTemplateNodeSelectorArgs'] node_selectors: Node Selector describes the hardware requirements of the resources.
        :param _builtins.str revision: The unique name for the revision. If this field is omitted, it will be automatically generated based on the WorkerPool name.
        :param _builtins.str service_account: Email address of the IAM service account associated with the revision of the WorkerPool. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param Sequence['GetWorkerPoolTemplateVolumeArgs'] volumes: A list of Volumes to make available to containers.
        :param Sequence['GetWorkerPoolTemplateVpcAccessArgs'] vpc_accesses: VPC Access configuration to use for this Revision. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "encryption_key_revocation_action", encryption_key_revocation_action)
        pulumi.set(__self__, "encryption_key_shutdown_duration", encryption_key_shutdown_duration)
        pulumi.set(__self__, "gpu_zonal_redundancy_disabled", gpu_zonal_redundancy_disabled)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "node_selectors", node_selectors)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_accesses", vpc_accesses)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Mapping[str, _builtins.str]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.

        Cloud Run API v2 does not support annotations with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system annotations in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.

        This field follows Kubernetes annotations' namespacing, limits, and rules.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.GetWorkerPoolTemplateContainerResult']:
        """
        Holds the containers that define the unit of execution for this WorkerPool.
        """
        return pulumi.get(self, "containers")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> _builtins.str:
        """
        A reference to a customer managed encryption key (CMEK) to use to encrypt this container image. For more information, go to https://cloud.google.com/run/docs/securing/using-cmek
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyRevocationAction")
    def encryption_key_revocation_action(self) -> _builtins.str:
        """
        The action to take if the encryption key is revoked. Possible values: ["PREVENT_NEW", "SHUTDOWN"]
        """
        return pulumi.get(self, "encryption_key_revocation_action")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyShutdownDuration")
    def encryption_key_shutdown_duration(self) -> _builtins.str:
        """
        If encryptionKeyRevocationAction is SHUTDOWN, the duration before shutting down all instances. The minimum increment is 1 hour.

        A duration in seconds with up to nine fractional digits, ending with 's'. Example: "3.5s".
        """
        return pulumi.get(self, "encryption_key_shutdown_duration")

    @_builtins.property
    @pulumi.getter(name="gpuZonalRedundancyDisabled")
    def gpu_zonal_redundancy_disabled(self) -> _builtins.bool:
        """
        True if GPU zonal redundancy is disabled on this revision.
        """
        return pulumi.get(self, "gpu_zonal_redundancy_disabled")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component, environment, state, etc.
        For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.

        Cloud Run API v2 does not support labels with 'run.googleapis.com', 'cloud.googleapis.com', 'serving.knative.dev', or 'autoscaling.knative.dev' namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 WorkerPoolRevisionTemplate.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="nodeSelectors")
    def node_selectors(self) -> Sequence['outputs.GetWorkerPoolTemplateNodeSelectorResult']:
        """
        Node Selector describes the hardware requirements of the resources.
        """
        return pulumi.get(self, "node_selectors")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> _builtins.str:
        """
        The unique name for the revision. If this field is omitted, it will be automatically generated based on the WorkerPool name.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> _builtins.str:
        """
        Email address of the IAM service account associated with the revision of the WorkerPool. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetWorkerPoolTemplateVolumeResult']:
        """
        A list of Volumes to make available to containers.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter(name="vpcAccesses")
    def vpc_accesses(self) -> Sequence['outputs.GetWorkerPoolTemplateVpcAccessResult']:
        """
        VPC Access configuration to use for this Revision. For more information, visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
        """
        return pulumi.get(self, "vpc_accesses")


@pulumi.output_type
class GetWorkerPoolTemplateContainerResult(dict):
    def __init__(__self__, *,
                 args: Sequence[_builtins.str],
                 commands: Sequence[_builtins.str],
                 depends_ons: Sequence[_builtins.str],
                 envs: Sequence['outputs.GetWorkerPoolTemplateContainerEnvResult'],
                 image: _builtins.str,
                 name: _builtins.str,
                 resources: Sequence['outputs.GetWorkerPoolTemplateContainerResourceResult'],
                 volume_mounts: Sequence['outputs.GetWorkerPoolTemplateContainerVolumeMountResult'],
                 working_dir: _builtins.str):
        """
        :param Sequence[_builtins.str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        :param Sequence[_builtins.str] commands: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        :param Sequence[_builtins.str] depends_ons: Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        :param Sequence['GetWorkerPoolTemplateContainerEnvArgs'] envs: List of environment variables to set in the container.
        :param _builtins.str image: URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        :param _builtins.str name: The name of the Cloud Run v2 Worker Pool.
        :param Sequence['GetWorkerPoolTemplateContainerResourceArgs'] resources: Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        :param Sequence['GetWorkerPoolTemplateContainerVolumeMountArgs'] volume_mounts: Volume to mount into the container's filesystem.
        :param _builtins.str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "depends_ons", depends_ons)
        pulumi.set(__self__, "envs", envs)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="dependsOns")
    def depends_ons(self) -> Sequence[_builtins.str]:
        """
        Containers which should be started before this container. If specified the container will wait to start until all containers with the listed names are healthy.
        """
        return pulumi.get(self, "depends_ons")

    @_builtins.property
    @pulumi.getter
    def envs(self) -> Sequence['outputs.GetWorkerPoolTemplateContainerEnvResult']:
        """
        List of environment variables to set in the container.
        """
        return pulumi.get(self, "envs")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        URL of the Container image in Google Container Registry or Google Artifact Registry. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Worker Pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetWorkerPoolTemplateContainerResourceResult']:
        """
        Compute Resource requirements by this container. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
        """
        return pulumi.get(self, "resources")

    @_builtins.property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.GetWorkerPoolTemplateContainerVolumeMountResult']:
        """
        Volume to mount into the container's filesystem.
        """
        return pulumi.get(self, "volume_mounts")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> _builtins.str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetWorkerPoolTemplateContainerEnvResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 value_sources: Sequence['outputs.GetWorkerPoolTemplateContainerEnvValueSourceResult']):
        """
        :param _builtins.str name: The name of the Cloud Run v2 Worker Pool.
        :param _builtins.str value: Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        :param Sequence['GetWorkerPoolTemplateContainerEnvValueSourceArgs'] value_sources: Source for the environment variable's value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_sources", value_sources)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Worker Pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Literal value of the environment variable. Defaults to "" and the maximum allowed length is 32768 characters. Variable references are not supported in Cloud Run.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter(name="valueSources")
    def value_sources(self) -> Sequence['outputs.GetWorkerPoolTemplateContainerEnvValueSourceResult']:
        """
        Source for the environment variable's value.
        """
        return pulumi.get(self, "value_sources")


@pulumi.output_type
class GetWorkerPoolTemplateContainerEnvValueSourceResult(dict):
    def __init__(__self__, *,
                 secret_key_reves: Sequence['outputs.GetWorkerPoolTemplateContainerEnvValueSourceSecretKeyRefResult']):
        """
        :param Sequence['GetWorkerPoolTemplateContainerEnvValueSourceSecretKeyRefArgs'] secret_key_reves: Selects a secret and a specific version from Cloud Secret Manager.
        """
        pulumi.set(__self__, "secret_key_reves", secret_key_reves)

    @_builtins.property
    @pulumi.getter(name="secretKeyReves")
    def secret_key_reves(self) -> Sequence['outputs.GetWorkerPoolTemplateContainerEnvValueSourceSecretKeyRefResult']:
        """
        Selects a secret and a specific version from Cloud Secret Manager.
        """
        return pulumi.get(self, "secret_key_reves")


@pulumi.output_type
class GetWorkerPoolTemplateContainerEnvValueSourceSecretKeyRefResult(dict):
    def __init__(__self__, *,
                 secret: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secretName} if the secret is in the same project. projects/{project}/secrets/{secretName} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetWorkerPoolTemplateContainerResourceResult(dict):
    def __init__(__self__, *,
                 limits: Mapping[str, _builtins.str]):
        """
        :param Mapping[str, _builtins.str] limits: Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        pulumi.set(__self__, "limits", limits)

    @_builtins.property
    @pulumi.getter
    def limits(self) -> Mapping[str, _builtins.str]:
        """
        Only memory, CPU, and nvidia.com/gpu are supported. Use key 'cpu' for CPU limit, 'memory' for memory limit, 'nvidia.com/gpu' for gpu limit. Note: The only supported values for CPU are '1', '2', '4', and '8'. Setting 4 CPU requires at least 2Gi of memory. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")


@pulumi.output_type
class GetWorkerPoolTemplateContainerVolumeMountResult(dict):
    def __init__(__self__, *,
                 mount_path: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        :param _builtins.str name: The name of the Cloud Run v2 Worker Pool.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> _builtins.str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty, or must otherwise be /cloudsql. All instances defined in the Volume will be available as /cloudsql/[instance]. For more information on Cloud SQL volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
        """
        return pulumi.get(self, "mount_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Worker Pool.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetWorkerPoolTemplateNodeSelectorResult(dict):
    def __init__(__self__, *,
                 accelerator: _builtins.str):
        """
        :param _builtins.str accelerator: The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        pulumi.set(__self__, "accelerator", accelerator)

    @_builtins.property
    @pulumi.getter
    def accelerator(self) -> _builtins.str:
        """
        The GPU to attach to an instance. See https://cloud.google.com/run/docs/configuring/services/gpu for configuring GPU.
        """
        return pulumi.get(self, "accelerator")


@pulumi.output_type
class GetWorkerPoolTemplateVolumeResult(dict):
    def __init__(__self__, *,
                 cloud_sql_instances: Sequence['outputs.GetWorkerPoolTemplateVolumeCloudSqlInstanceResult'],
                 empty_dirs: Sequence['outputs.GetWorkerPoolTemplateVolumeEmptyDirResult'],
                 gcs: Sequence['outputs.GetWorkerPoolTemplateVolumeGcResult'],
                 name: _builtins.str,
                 nfs: Sequence['outputs.GetWorkerPoolTemplateVolumeNfResult'],
                 secrets: Sequence['outputs.GetWorkerPoolTemplateVolumeSecretResult']):
        """
        :param Sequence['GetWorkerPoolTemplateVolumeCloudSqlInstanceArgs'] cloud_sql_instances: For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        :param Sequence['GetWorkerPoolTemplateVolumeEmptyDirArgs'] empty_dirs: Ephemeral storage used as a shared volume.
        :param Sequence['GetWorkerPoolTemplateVolumeGcArgs'] gcs: Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        :param _builtins.str name: The name of the Cloud Run v2 Worker Pool.
        :param Sequence['GetWorkerPoolTemplateVolumeNfArgs'] nfs: Represents an NFS mount.
        :param Sequence['GetWorkerPoolTemplateVolumeSecretArgs'] secrets: Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        pulumi.set(__self__, "cloud_sql_instances", cloud_sql_instances)
        pulumi.set(__self__, "empty_dirs", empty_dirs)
        pulumi.set(__self__, "gcs", gcs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs", nfs)
        pulumi.set(__self__, "secrets", secrets)

    @_builtins.property
    @pulumi.getter(name="cloudSqlInstances")
    def cloud_sql_instances(self) -> Sequence['outputs.GetWorkerPoolTemplateVolumeCloudSqlInstanceResult']:
        """
        For Cloud SQL volumes, contains the specific instances that should be mounted. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run.
        """
        return pulumi.get(self, "cloud_sql_instances")

    @_builtins.property
    @pulumi.getter(name="emptyDirs")
    def empty_dirs(self) -> Sequence['outputs.GetWorkerPoolTemplateVolumeEmptyDirResult']:
        """
        Ephemeral storage used as a shared volume.
        """
        return pulumi.get(self, "empty_dirs")

    @_builtins.property
    @pulumi.getter
    def gcs(self) -> Sequence['outputs.GetWorkerPoolTemplateVolumeGcResult']:
        """
        Cloud Storage bucket mounted as a volume using GCSFuse. This feature is only supported in the gen2 execution environment.
        """
        return pulumi.get(self, "gcs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Cloud Run v2 Worker Pool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nfs(self) -> Sequence['outputs.GetWorkerPoolTemplateVolumeNfResult']:
        """
        Represents an NFS mount.
        """
        return pulumi.get(self, "nfs")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetWorkerPoolTemplateVolumeSecretResult']:
        """
        Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class GetWorkerPoolTemplateVolumeCloudSqlInstanceResult(dict):
    def __init__(__self__, *,
                 instances: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] instances: The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence[_builtins.str]:
        """
        The Cloud SQL instance connection names, as can be found in https://console.cloud.google.com/sql/instances. Visit https://cloud.google.com/sql/docs/mysql/connect-run for more information on how to connect Cloud SQL and Cloud Run. Format: {project}:{location}:{instance}
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class GetWorkerPoolTemplateVolumeEmptyDirResult(dict):
    def __init__(__self__, *,
                 medium: _builtins.str,
                 size_limit: _builtins.str):
        """
        :param _builtins.str medium: The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        :param _builtins.str size_limit: Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        pulumi.set(__self__, "medium", medium)
        pulumi.set(__self__, "size_limit", size_limit)

    @_builtins.property
    @pulumi.getter
    def medium(self) -> _builtins.str:
        """
        The different types of medium supported for EmptyDir. Default value: "MEMORY" Possible values: ["MEMORY"]
        """
        return pulumi.get(self, "medium")

    @_builtins.property
    @pulumi.getter(name="sizeLimit")
    def size_limit(self) -> _builtins.str:
        """
        Limit on the storage usable by this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. This field's values are of the 'Quantity' k8s type: https://kubernetes.io/docs/reference/kubernetes-api/common-definitions/quantity/. The default is nil which means that the limit is undefined. More info: https://kubernetes.io/docs/concepts/storage/volumes/#emptydir.
        """
        return pulumi.get(self, "size_limit")


@pulumi.output_type
class GetWorkerPoolTemplateVolumeGcResult(dict):
    def __init__(__self__, *,
                 bucket: _builtins.str,
                 mount_options: Sequence[_builtins.str],
                 read_only: _builtins.bool):
        """
        :param _builtins.str bucket: GCS Bucket name
        :param Sequence[_builtins.str] mount_options: A list of flags to pass to the gcsfuse command for configuring this volume.
               Flags should be passed without leading dashes.
        :param _builtins.bool read_only: If true, mount the GCS bucket as read-only
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "read_only", read_only)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        GCS Bucket name
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Sequence[_builtins.str]:
        """
        A list of flags to pass to the gcsfuse command for configuring this volume.
        Flags should be passed without leading dashes.
        """
        return pulumi.get(self, "mount_options")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, mount the GCS bucket as read-only
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class GetWorkerPoolTemplateVolumeNfResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 read_only: _builtins.bool,
                 server: _builtins.str):
        """
        :param _builtins.str path: Path that is exported by the NFS server.
        :param _builtins.bool read_only: If true, mount the NFS volume as read only
        :param _builtins.str server: Hostname or IP address of the NFS server
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "server", server)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path that is exported by the NFS server.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> _builtins.bool:
        """
        If true, mount the NFS volume as read only
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter
    def server(self) -> _builtins.str:
        """
        Hostname or IP address of the NFS server
        """
        return pulumi.get(self, "server")


@pulumi.output_type
class GetWorkerPoolTemplateVolumeSecretResult(dict):
    def __init__(__self__, *,
                 default_mode: _builtins.int,
                 items: Sequence['outputs.GetWorkerPoolTemplateVolumeSecretItemResult'],
                 secret: _builtins.str):
        """
        :param _builtins.int default_mode: Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        :param Sequence['GetWorkerPoolTemplateVolumeSecretItemArgs'] items: If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        :param _builtins.str secret: The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "secret", secret)

    @_builtins.property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> _builtins.int:
        """
        Integer representation of mode bits to use on created files by default. Must be a value between 0000 and 0777 (octal), defaulting to 0444. Directories within the path are not affected by this setting.
        """
        return pulumi.get(self, "default_mode")

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetWorkerPoolTemplateVolumeSecretItemResult']:
        """
        If unspecified, the volume will expose a file whose name is the secret, relative to VolumeMount.mount_path. If specified, the key will be used as the version to fetch from Cloud Secret Manager and the path will be the name of the file exposed in the volume. When items are defined, they must specify a path and a version.
        """
        return pulumi.get(self, "items")

    @_builtins.property
    @pulumi.getter
    def secret(self) -> _builtins.str:
        """
        The name of the secret in Cloud Secret Manager. Format: {secret} if the secret is in the same project. projects/{project}/secrets/{secret} if the secret is in a different project.
        """
        return pulumi.get(self, "secret")


@pulumi.output_type
class GetWorkerPoolTemplateVolumeSecretItemResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.int,
                 path: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.int mode: Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        :param _builtins.str path: The relative path of the secret in the container.
        :param _builtins.str version: The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.int:
        """
        Integer octal mode bits to use on this file, must be a value between 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The relative path of the secret in the container.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Cloud Secret Manager secret version. Can be 'latest' for the latest value or an integer for a specific version
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetWorkerPoolTemplateVpcAccessResult(dict):
    def __init__(__self__, *,
                 egress: _builtins.str,
                 network_interfaces: Sequence['outputs.GetWorkerPoolTemplateVpcAccessNetworkInterfaceResult']):
        """
        :param _builtins.str egress: Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        :param Sequence['GetWorkerPoolTemplateVpcAccessNetworkInterfaceArgs'] network_interfaces: Direct VPC egress settings. Currently only single network interface is supported.
        """
        pulumi.set(__self__, "egress", egress)
        pulumi.set(__self__, "network_interfaces", network_interfaces)

    @_builtins.property
    @pulumi.getter
    def egress(self) -> _builtins.str:
        """
        Traffic VPC egress settings. Possible values: ["ALL_TRAFFIC", "PRIVATE_RANGES_ONLY"]
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetWorkerPoolTemplateVpcAccessNetworkInterfaceResult']:
        """
        Direct VPC egress settings. Currently only single network interface is supported.
        """
        return pulumi.get(self, "network_interfaces")


@pulumi.output_type
class GetWorkerPoolTemplateVpcAccessNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 network: _builtins.str,
                 subnetwork: _builtins.str,
                 tags: Sequence[_builtins.str]):
        """
        :param _builtins.str network: The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
               looked up from the subnetwork.
        :param _builtins.str subnetwork: The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
               network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
               subnetwork with the same name with the network will be used.
        :param Sequence[_builtins.str] tags: Network tags applied to this Cloud Run WorkerPool.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The VPC network that the Cloud Run resource will be able to send traffic to. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If network is not specified, it will be
        looked up from the subnetwork.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> _builtins.str:
        """
        The VPC subnetwork that the Cloud Run resource will get IPs from. At least one of network or subnetwork must be specified. If both
        network and subnetwork are specified, the given VPC subnetwork must belong to the given VPC network. If subnetwork is not specified, the
        subnetwork with the same name with the network will be used.
        """
        return pulumi.get(self, "subnetwork")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        Network tags applied to this Cloud Run WorkerPool.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetWorkerPoolTerminalConditionResult(dict):
    def __init__(__self__, *,
                 execution_reason: _builtins.str,
                 last_transition_time: _builtins.str,
                 message: _builtins.str,
                 reason: _builtins.str,
                 revision_reason: _builtins.str,
                 severity: _builtins.str,
                 state: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str execution_reason: A reason for the execution condition.
        :param _builtins.str last_transition_time: Last time the condition transitioned from one status to another.
        :param _builtins.str message: Human readable message indicating details about the current status.
        :param _builtins.str reason: A common (workerPool-level) reason for this condition.
        :param _builtins.str revision_reason: A reason for the revision condition.
        :param _builtins.str severity: How to interpret failures of this condition, one of Error, Warning, Info
        :param _builtins.str state: State of the condition.
        :param _builtins.str type: type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        pulumi.set(__self__, "execution_reason", execution_reason)
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "revision_reason", revision_reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="executionReason")
    def execution_reason(self) -> _builtins.str:
        """
        A reason for the execution condition.
        """
        return pulumi.get(self, "execution_reason")

    @_builtins.property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> _builtins.str:
        """
        Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> _builtins.str:
        """
        A common (workerPool-level) reason for this condition.
        """
        return pulumi.get(self, "reason")

    @_builtins.property
    @pulumi.getter(name="revisionReason")
    def revision_reason(self) -> _builtins.str:
        """
        A reason for the revision condition.
        """
        return pulumi.get(self, "revision_reason")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the condition.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting Types common to all resources include: * "Ready": True when the Resource is ready.
        """
        return pulumi.get(self, "type")


