# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkerPoolArgs', 'WorkerPool']

@pulumi.input_type
class WorkerPoolArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 template: pulumi.Input['WorkerPoolTemplateArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['WorkerPoolBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_splits: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling: Optional[pulumi.Input['WorkerPoolScalingArgs']] = None):
        """
        The set of arguments for constructing a WorkerPool resource.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run worker pool
        :param pulumi.Input['WorkerPoolTemplateArgs'] template: The template used to create revisions for this WorkerPool.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected in new resources.
               All system annotations in v1 now have a corresponding field in v2 WorkerPool.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['WorkerPoolBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_audiences: One or more custom audiences that you want this worker pool to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
               For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[_builtins.str] description: User-provided description of the WorkerPool. This field currently has a 512-character limit.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]] instance_splits: Specifies how to distribute instances over a collection of Revisions belonging to the WorkerPool. If instance split is empty or not provided, defaults to 100% instances assigned to the latest Ready Revision.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with  `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 WorkerPool.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] name: Name of the WorkerPool.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['WorkerPoolScalingArgs'] scaling: Scaling settings that apply to the worker pool.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "template", template)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if custom_audiences is not None:
            pulumi.set(__self__, "custom_audiences", custom_audiences)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_splits is not None:
            pulumi.set(__self__, "instance_splits", instance_splits)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the cloud run worker pool
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Input['WorkerPoolTemplateArgs']:
        """
        The template used to create revisions for this WorkerPool.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input['WorkerPoolTemplateArgs']):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected in new resources.
        All system annotations in v1 now have a corresponding field in v2 WorkerPool.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['WorkerPoolBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['WorkerPoolBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @_builtins.property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client", value)

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_version", value)

    @_builtins.property
    @pulumi.getter(name="customAudiences")
    def custom_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more custom audiences that you want this worker pool to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
        For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
        """
        return pulumi.get(self, "custom_audiences")

    @custom_audiences.setter
    def custom_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_audiences", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description of the WorkerPool. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceSplits")
    def instance_splits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]]]:
        """
        Specifies how to distribute instances over a collection of Revisions belonging to the WorkerPool. If instance split is empty or not provided, defaults to 100% instances assigned to the latest Ready Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_splits")

    @instance_splits.setter
    def instance_splits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]]]):
        pulumi.set(self, "instance_splits", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with  `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 WorkerPool.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_stage", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the WorkerPool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def scaling(self) -> Optional[pulumi.Input['WorkerPoolScalingArgs']]:
        """
        Scaling settings that apply to the worker pool.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @scaling.setter
    def scaling(self, value: Optional[pulumi.Input['WorkerPoolScalingArgs']]):
        pulumi.set(self, "scaling", value)


@pulumi.input_type
class _WorkerPoolState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['WorkerPoolBinaryAuthorizationArgs']] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolConditionArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 generation: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_split_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitStatusArgs']]]] = None,
                 instance_splits: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 last_modifier: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_created_revision: Optional[pulumi.Input[_builtins.str]] = None,
                 latest_ready_revision: Optional[pulumi.Input[_builtins.str]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 observed_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
                 scaling: Optional[pulumi.Input['WorkerPoolScalingArgs']] = None,
                 template: Optional[pulumi.Input['WorkerPoolTemplateArgs']] = None,
                 terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolTerminalConditionArgs']]]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkerPool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected in new resources.
               All system annotations in v1 now have a corresponding field in v2 WorkerPool.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['WorkerPoolBinaryAuthorizationArgs'] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerPoolConditionArgs']]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the WorkerPool does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.str] creator: Email address of the authenticated creator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_audiences: One or more custom audiences that you want this worker pool to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
               For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[_builtins.str] delete_time: The deletion time.
        :param pulumi.Input[_builtins.str] description: User-provided description of the WorkerPool. This field currently has a 512-character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[_builtins.str] expire_time: For a deleted resource, the time after which it will be permanently deleted.
        :param pulumi.Input[_builtins.str] generation: A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitStatusArgs']]] instance_split_statuses: Detailed status information for corresponding instance splits. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]] instance_splits: Specifies how to distribute instances over a collection of Revisions belonging to the WorkerPool. If instance split is empty or not provided, defaults to 100% instances assigned to the latest Ready Revision.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with  `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 WorkerPool.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] last_modifier: Email address of the last authenticated modifier.
        :param pulumi.Input[_builtins.str] latest_created_revision: Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[_builtins.str] latest_ready_revision: Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run worker pool
        :param pulumi.Input[_builtins.str] name: Name of the WorkerPool.
        :param pulumi.Input[_builtins.str] observed_generation: The generation of this WorkerPool currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Returns true if the WorkerPool is currently being acted upon by the system to bring it into the desired state.
               When a new WorkerPool is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the WorkerPool to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the WorkerPool, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
               If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created WorkerPools. Additional information on the failure can be found in terminalCondition and conditions.
        :param pulumi.Input['WorkerPoolScalingArgs'] scaling: Scaling settings that apply to the worker pool.
               Structure is documented below.
        :param pulumi.Input['WorkerPoolTemplateArgs'] template: The template used to create revisions for this WorkerPool.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['WorkerPoolTerminalConditionArgs']]] terminal_conditions: The Condition of this WorkerPool, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if client is not None:
            pulumi.set(__self__, "client", client)
        if client_version is not None:
            pulumi.set(__self__, "client_version", client_version)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if custom_audiences is not None:
            pulumi.set(__self__, "custom_audiences", custom_audiences)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if instance_split_statuses is not None:
            pulumi.set(__self__, "instance_split_statuses", instance_split_statuses)
        if instance_splits is not None:
            pulumi.set(__self__, "instance_splits", instance_splits)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if last_modifier is not None:
            pulumi.set(__self__, "last_modifier", last_modifier)
        if latest_created_revision is not None:
            pulumi.set(__self__, "latest_created_revision", latest_created_revision)
        if latest_ready_revision is not None:
            pulumi.set(__self__, "latest_ready_revision", latest_ready_revision)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if observed_generation is not None:
            pulumi.set(__self__, "observed_generation", observed_generation)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if scaling is not None:
            pulumi.set(__self__, "scaling", scaling)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if terminal_conditions is not None:
            pulumi.set(__self__, "terminal_conditions", terminal_conditions)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected in new resources.
        All system annotations in v1 now have a corresponding field in v2 WorkerPool.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['WorkerPoolBinaryAuthorizationArgs']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['WorkerPoolBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @_builtins.property
    @pulumi.getter
    def client(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @client.setter
    def client(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client", value)

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @client_version.setter
    def client_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_version", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolConditionArgs']]]]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the WorkerPool does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the authenticated creator.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter(name="customAudiences")
    def custom_audiences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more custom audiences that you want this worker pool to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
        For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
        """
        return pulumi.get(self, "custom_audiences")

    @custom_audiences.setter
    def custom_audiences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "custom_audiences", value)

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The deletion time.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided description of the WorkerPool. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For a deleted resource, the time after which it will be permanently deleted.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "generation", value)

    @_builtins.property
    @pulumi.getter(name="instanceSplitStatuses")
    def instance_split_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitStatusArgs']]]]:
        """
        Detailed status information for corresponding instance splits. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_split_statuses")

    @instance_split_statuses.setter
    def instance_split_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitStatusArgs']]]]):
        pulumi.set(self, "instance_split_statuses", value)

    @_builtins.property
    @pulumi.getter(name="instanceSplits")
    def instance_splits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]]]:
        """
        Specifies how to distribute instances over a collection of Revisions belonging to the WorkerPool. If instance split is empty or not provided, defaults to 100% instances assigned to the latest Ready Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_splits")

    @instance_splits.setter
    def instance_splits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolInstanceSplitArgs']]]]):
        pulumi.set(self, "instance_splits", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with  `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 WorkerPool.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="lastModifier")
    def last_modifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address of the last authenticated modifier.
        """
        return pulumi.get(self, "last_modifier")

    @last_modifier.setter
    def last_modifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_modifier", value)

    @_builtins.property
    @pulumi.getter(name="latestCreatedRevision")
    def latest_created_revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_created_revision")

    @latest_created_revision.setter
    def latest_created_revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_created_revision", value)

    @_builtins.property
    @pulumi.getter(name="latestReadyRevision")
    def latest_ready_revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_ready_revision")

    @latest_ready_revision.setter
    def latest_ready_revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "latest_ready_revision", value)

    @_builtins.property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launch_stage", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the cloud run worker pool
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the WorkerPool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generation of this WorkerPool currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "observed_generation")

    @observed_generation.setter
    def observed_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "observed_generation", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Returns true if the WorkerPool is currently being acted upon by the system to bring it into the desired state.
        When a new WorkerPool is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the WorkerPool to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the WorkerPool, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
        If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created WorkerPools. Additional information on the failure can be found in terminalCondition and conditions.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @_builtins.property
    @pulumi.getter
    def scaling(self) -> Optional[pulumi.Input['WorkerPoolScalingArgs']]:
        """
        Scaling settings that apply to the worker pool.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @scaling.setter
    def scaling(self, value: Optional[pulumi.Input['WorkerPoolScalingArgs']]):
        pulumi.set(self, "scaling", value)

    @_builtins.property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['WorkerPoolTemplateArgs']]:
        """
        The template used to create revisions for this WorkerPool.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['WorkerPoolTemplateArgs']]):
        pulumi.set(self, "template", value)

    @_builtins.property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolTerminalConditionArgs']]]]:
        """
        The Condition of this WorkerPool, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @terminal_conditions.setter
    def terminal_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkerPoolTerminalConditionArgs']]]]):
        pulumi.set(self, "terminal_conditions", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:cloudrunv2/workerPool:WorkerPool")
class WorkerPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['WorkerPoolBinaryAuthorizationArgs', 'WorkerPoolBinaryAuthorizationArgsDict']]] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_splits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolInstanceSplitArgs', 'WorkerPoolInstanceSplitArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling: Optional[pulumi.Input[Union['WorkerPoolScalingArgs', 'WorkerPoolScalingArgsDict']]] = None,
                 template: Optional[pulumi.Input[Union['WorkerPoolTemplateArgs', 'WorkerPoolTemplateArgsDict']]] = None,
                 __props__=None):
        """
        WorkerPool acts as a top-level container that manages a set of configurations and revision templates which implement a pull-based workload. WorkerPool exists to provide a singular abstraction which can be access controlled, reasoned about, and which encapsulates software lifecycle decisions such as rollout policy and team resource ownership.

        To get more information about WorkerPool, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.workerPools)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage

        ### Cloudrunv2 Worker Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Limits

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "resources": {
                        "limits": {
                            "cpu": "2",
                            "memory": "1024Mi",
                        },
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "volumes": [{
                    "name": "cloudsql",
                    "cloud_sql_instance": {
                        "instances": [instance.connection_name],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "envs": [
                        {
                            "name": "FOO",
                            "value": "bar",
                        },
                        {
                            "name": "SECRET_ENV_VAR",
                            "value_source": {
                                "secret_key_ref": {
                                    "secret": secret.secret_id,
                                    "version": "1",
                                },
                            },
                        },
                    ],
                    "volume_mounts": [{
                        "name": "cloudsql",
                        "mount_path": "/cloudsql",
                    }],
                }],
            },
            instance_splits=[{
                "type": "INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST",
                "percent": 100,
            }],
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Worker Pool Directvpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                        "tags": [
                            "tag1",
                            "tag2",
                            "tag3",
                        ],
                    }],
                },
            })
        ```
        ### Cloudrunv2 Worker Pool Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="ALPHA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "resources": {
                        "limits": {
                            "cpu": "4",
                            "memory": "16Gi",
                            "nvidia.com/gpu": "1",
                        },
                    },
                }],
                "node_selector": {
                    "accelerator": "nvidia-l4",
                },
            })
        ```
        ### Cloudrunv2 Worker Pool Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "volumes": [{
                    "name": "a-volume",
                    "secret": {
                        "secret": secret.secret_id,
                        "default_mode": 292,
                        "items": [{
                            "version": "1",
                            "path": "my-secret",
                            "mode": 444,
                        }],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "volume_mounts": [{
                        "name": "a-volume",
                        "mount_path": "/secrets",
                    }],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Worker Pool Multicontainer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [
                    {
                        "name": "hello-1",
                        "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                        "volume_mounts": [{
                            "name": "empty-dir-volume",
                            "mount_path": "/mnt",
                        }],
                    },
                    {
                        "name": "hello-2",
                        "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    },
                ],
                "volumes": [{
                    "name": "empty-dir-volume",
                    "empty_dir": {
                        "medium": "MEMORY",
                        "size_limit": "256Mi",
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Mount Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_bucket = gcp.storage.Bucket("default",
            name="cloudrun-worker-pool",
            location="US",
            uniform_bucket_level_access=True)
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "volume_mounts": [{
                        "name": "bucket",
                        "mount_path": "/var/www",
                    }],
                }],
                "volumes": [{
                    "name": "bucket",
                    "gcs": {
                        "bucket": default_bucket.name,
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Mount Nfs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_instance = gcp.filestore.Instance("default",
            name="cloudrun-worker-pool",
            location="us-central1-b",
            tier="BASIC_HDD",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool:latest",
                    "volume_mounts": [{
                        "name": "nfs",
                        "mount_path": "/mnt/nfs/filestore",
                    }],
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                    }],
                },
                "volumes": [{
                    "name": "nfs",
                    "nfs": {
                        "server": default_instance.networks[0].ip_addresses[0],
                        "path": "/share1",
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Custom Audiences

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            custom_audiences=["aud1"],
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                }],
            })
        ```

        ## Import

        WorkerPool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workerPools/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, WorkerPool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrunv2/workerPool:WorkerPool default projects/{{project}}/locations/{{location}}/workerPools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/workerPool:WorkerPool default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/workerPool:WorkerPool default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected in new resources.
               All system annotations in v1 now have a corresponding field in v2 WorkerPool.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['WorkerPoolBinaryAuthorizationArgs', 'WorkerPoolBinaryAuthorizationArgsDict']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_audiences: One or more custom audiences that you want this worker pool to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
               For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[_builtins.str] description: User-provided description of the WorkerPool. This field currently has a 512-character limit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolInstanceSplitArgs', 'WorkerPoolInstanceSplitArgsDict']]]] instance_splits: Specifies how to distribute instances over a collection of Revisions belonging to the WorkerPool. If instance split is empty or not provided, defaults to 100% instances assigned to the latest Ready Revision.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with  `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 WorkerPool.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run worker pool
        :param pulumi.Input[_builtins.str] name: Name of the WorkerPool.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['WorkerPoolScalingArgs', 'WorkerPoolScalingArgsDict']] scaling: Scaling settings that apply to the worker pool.
               Structure is documented below.
        :param pulumi.Input[Union['WorkerPoolTemplateArgs', 'WorkerPoolTemplateArgsDict']] template: The template used to create revisions for this WorkerPool.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkerPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        WorkerPool acts as a top-level container that manages a set of configurations and revision templates which implement a pull-based workload. WorkerPool exists to provide a singular abstraction which can be access controlled, reasoned about, and which encapsulates software lifecycle decisions such as rollout policy and team resource ownership.

        To get more information about WorkerPool, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v2/projects.locations.workerPools)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        ## Example Usage

        ### Cloudrunv2 Worker Pool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Limits

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "resources": {
                        "limits": {
                            "cpu": "2",
                            "memory": "1024Mi",
                        },
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-central1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "volumes": [{
                    "name": "cloudsql",
                    "cloud_sql_instance": {
                        "instances": [instance.connection_name],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "envs": [
                        {
                            "name": "FOO",
                            "value": "bar",
                        },
                        {
                            "name": "SECRET_ENV_VAR",
                            "value_source": {
                                "secret_key_ref": {
                                    "secret": secret.secret_id,
                                    "version": "1",
                                },
                            },
                        },
                    ],
                    "volume_mounts": [{
                        "name": "cloudsql",
                        "mount_path": "/cloudsql",
                    }],
                }],
            },
            instance_splits=[{
                "type": "INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST",
                "percent": 100,
            }],
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Worker Pool Directvpc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                        "tags": [
                            "tag1",
                            "tag2",
                            "tag3",
                        ],
                    }],
                },
            })
        ```
        ### Cloudrunv2 Worker Pool Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="ALPHA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "resources": {
                        "limits": {
                            "cpu": "4",
                            "memory": "16Gi",
                            "nvidia.com/gpu": "1",
                        },
                    },
                }],
                "node_selector": {
                    "accelerator": "nvidia-l4",
                },
            })
        ```
        ### Cloudrunv2 Worker Pool Secret

        ```python
        import pulumi
        import pulumi_gcp as gcp

        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret-1",
            replication={
                "auto": {},
            })
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data")
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "volumes": [{
                    "name": "a-volume",
                    "secret": {
                        "secret": secret.secret_id,
                        "default_mode": 292,
                        "items": [{
                            "version": "1",
                            "path": "my-secret",
                            "mode": 444,
                        }],
                    },
                }],
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "volume_mounts": [{
                        "name": "a-volume",
                        "mount_path": "/secrets",
                    }],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[secret_version_data]))
        project = gcp.organizations.get_project()
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts = pulumi.ResourceOptions(depends_on=[secret]))
        ```
        ### Cloudrunv2 Worker Pool Multicontainer

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [
                    {
                        "name": "hello-1",
                        "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                        "volume_mounts": [{
                            "name": "empty-dir-volume",
                            "mount_path": "/mnt",
                        }],
                    },
                    {
                        "name": "hello-2",
                        "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    },
                ],
                "volumes": [{
                    "name": "empty-dir-volume",
                    "empty_dir": {
                        "medium": "MEMORY",
                        "size_limit": "256Mi",
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Mount Gcs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_bucket = gcp.storage.Bucket("default",
            name="cloudrun-worker-pool",
            location="US",
            uniform_bucket_level_access=True)
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                    "volume_mounts": [{
                        "name": "bucket",
                        "mount_path": "/var/www",
                    }],
                }],
                "volumes": [{
                    "name": "bucket",
                    "gcs": {
                        "bucket": default_bucket.name,
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Mount Nfs

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_instance = gcp.filestore.Instance("default",
            name="cloudrun-worker-pool",
            location="us-central1-b",
            tier="BASIC_HDD",
            file_shares={
                "capacity_gb": 1024,
                "name": "share1",
            },
            networks=[{
                "network": "default",
                "modes": ["MODE_IPV4"],
            }])
        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool:latest",
                    "volume_mounts": [{
                        "name": "nfs",
                        "mount_path": "/mnt/nfs/filestore",
                    }],
                }],
                "vpc_access": {
                    "network_interfaces": [{
                        "network": "default",
                        "subnetwork": "default",
                    }],
                },
                "volumes": [{
                    "name": "nfs",
                    "nfs": {
                        "server": default_instance.networks[0].ip_addresses[0],
                        "path": "/share1",
                        "read_only": False,
                    },
                }],
            })
        ```
        ### Cloudrunv2 Worker Pool Custom Audiences

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrunv2.WorkerPool("default",
            name="cloudrun-worker-pool",
            location="us-central1",
            deletion_protection=False,
            launch_stage="BETA",
            custom_audiences=["aud1"],
            template={
                "containers": [{
                    "image": "us-docker.pkg.dev/cloudrun/container/worker-pool",
                }],
            })
        ```

        ## Import

        WorkerPool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/workerPools/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, WorkerPool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrunv2/workerPool:WorkerPool default projects/{{project}}/locations/{{location}}/workerPools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/workerPool:WorkerPool default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrunv2/workerPool:WorkerPool default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param WorkerPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkerPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['WorkerPoolBinaryAuthorizationArgs', 'WorkerPoolBinaryAuthorizationArgsDict']]] = None,
                 client: Optional[pulumi.Input[_builtins.str]] = None,
                 client_version: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_splits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolInstanceSplitArgs', 'WorkerPoolInstanceSplitArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scaling: Optional[pulumi.Input[Union['WorkerPoolScalingArgs', 'WorkerPoolScalingArgsDict']]] = None,
                 template: Optional[pulumi.Input[Union['WorkerPoolTemplateArgs', 'WorkerPoolTemplateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkerPoolArgs.__new__(WorkerPoolArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["binary_authorization"] = binary_authorization
            __props__.__dict__["client"] = client
            __props__.__dict__["client_version"] = client_version
            __props__.__dict__["custom_audiences"] = custom_audiences
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_splits"] = instance_splits
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_stage"] = launch_stage
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["scaling"] = scaling
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
            __props__.__dict__["conditions"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["generation"] = None
            __props__.__dict__["instance_split_statuses"] = None
            __props__.__dict__["last_modifier"] = None
            __props__.__dict__["latest_created_revision"] = None
            __props__.__dict__["latest_ready_revision"] = None
            __props__.__dict__["observed_generation"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["terminal_conditions"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WorkerPool, __self__).__init__(
            'gcp:cloudrunv2/workerPool:WorkerPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            binary_authorization: Optional[pulumi.Input[Union['WorkerPoolBinaryAuthorizationArgs', 'WorkerPoolBinaryAuthorizationArgsDict']]] = None,
            client: Optional[pulumi.Input[_builtins.str]] = None,
            client_version: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolConditionArgs', 'WorkerPoolConditionArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            custom_audiences: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            generation: Optional[pulumi.Input[_builtins.str]] = None,
            instance_split_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolInstanceSplitStatusArgs', 'WorkerPoolInstanceSplitStatusArgsDict']]]]] = None,
            instance_splits: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolInstanceSplitArgs', 'WorkerPoolInstanceSplitArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            last_modifier: Optional[pulumi.Input[_builtins.str]] = None,
            latest_created_revision: Optional[pulumi.Input[_builtins.str]] = None,
            latest_ready_revision: Optional[pulumi.Input[_builtins.str]] = None,
            launch_stage: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            observed_generation: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciling: Optional[pulumi.Input[_builtins.bool]] = None,
            scaling: Optional[pulumi.Input[Union['WorkerPoolScalingArgs', 'WorkerPoolScalingArgsDict']]] = None,
            template: Optional[pulumi.Input[Union['WorkerPoolTemplateArgs', 'WorkerPoolTemplateArgsDict']]] = None,
            terminal_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolTerminalConditionArgs', 'WorkerPoolTerminalConditionArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkerPool':
        """
        Get an existing WorkerPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
               Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected in new resources.
               All system annotations in v1 now have a corresponding field in v2 WorkerPool.
               This field follows Kubernetes annotations' namespacing, limits, and rules.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['WorkerPoolBinaryAuthorizationArgs', 'WorkerPoolBinaryAuthorizationArgsDict']] binary_authorization: Settings for the Binary Authorization feature.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] client: Arbitrary identifier for the API client.
        :param pulumi.Input[_builtins.str] client_version: Arbitrary version identifier for the API client.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolConditionArgs', 'WorkerPoolConditionArgsDict']]]] conditions: The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the WorkerPool does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The creation time.
        :param pulumi.Input[_builtins.str] creator: Email address of the authenticated creator.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] custom_audiences: One or more custom audiences that you want this worker pool to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
               For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
        :param pulumi.Input[_builtins.str] delete_time: The deletion time.
        :param pulumi.Input[_builtins.str] description: User-provided description of the WorkerPool. This field currently has a 512-character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        :param pulumi.Input[_builtins.str] expire_time: For a deleted resource, the time after which it will be permanently deleted.
        :param pulumi.Input[_builtins.str] generation: A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolInstanceSplitStatusArgs', 'WorkerPoolInstanceSplitStatusArgsDict']]]] instance_split_statuses: Detailed status information for corresponding instance splits. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolInstanceSplitArgs', 'WorkerPoolInstanceSplitArgsDict']]]] instance_splits: Specifies how to distribute instances over a collection of Revisions belonging to the WorkerPool. If instance split is empty or not provided, defaults to 100% instances assigned to the latest Ready Revision.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
               environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
               Cloud Run API v2 does not support labels with  `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
               All system labels in v1 now have a corresponding field in v2 WorkerPool.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] last_modifier: Email address of the last authenticated modifier.
        :param pulumi.Input[_builtins.str] latest_created_revision: Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[_builtins.str] latest_ready_revision: Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        :param pulumi.Input[_builtins.str] launch_stage: The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
               If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
               For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
               Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        :param pulumi.Input[_builtins.str] location: The location of the cloud run worker pool
        :param pulumi.Input[_builtins.str] name: Name of the WorkerPool.
        :param pulumi.Input[_builtins.str] observed_generation: The generation of this WorkerPool currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reconciling: Returns true if the WorkerPool is currently being acted upon by the system to bring it into the desired state.
               When a new WorkerPool is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the WorkerPool to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the WorkerPool, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
               If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
               If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created WorkerPools. Additional information on the failure can be found in terminalCondition and conditions.
        :param pulumi.Input[Union['WorkerPoolScalingArgs', 'WorkerPoolScalingArgsDict']] scaling: Scaling settings that apply to the worker pool.
               Structure is documented below.
        :param pulumi.Input[Union['WorkerPoolTemplateArgs', 'WorkerPoolTemplateArgsDict']] template: The template used to create revisions for this WorkerPool.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WorkerPoolTerminalConditionArgs', 'WorkerPoolTerminalConditionArgsDict']]]] terminal_conditions: The Condition of this WorkerPool, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        :param pulumi.Input[_builtins.str] update_time: The last-modified time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkerPoolState.__new__(_WorkerPoolState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["client"] = client
        __props__.__dict__["client_version"] = client_version
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["custom_audiences"] = custom_audiences
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["generation"] = generation
        __props__.__dict__["instance_split_statuses"] = instance_split_statuses
        __props__.__dict__["instance_splits"] = instance_splits
        __props__.__dict__["labels"] = labels
        __props__.__dict__["last_modifier"] = last_modifier
        __props__.__dict__["latest_created_revision"] = latest_created_revision
        __props__.__dict__["latest_ready_revision"] = latest_ready_revision
        __props__.__dict__["launch_stage"] = launch_stage
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["observed_generation"] = observed_generation
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["scaling"] = scaling
        __props__.__dict__["template"] = template
        __props__.__dict__["terminal_conditions"] = terminal_conditions
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return WorkerPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that may be set by external tools to store and arbitrary metadata. They are not queryable and should be preserved when modifying objects.
        Cloud Run API v2 does not support annotations with `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected in new resources.
        All system annotations in v1 now have a corresponding field in v2 WorkerPool.
        This field follows Kubernetes annotations' namespacing, limits, and rules.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output[Optional['outputs.WorkerPoolBinaryAuthorization']]:
        """
        Settings for the Binary Authorization feature.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @_builtins.property
    @pulumi.getter
    def client(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Arbitrary identifier for the API client.
        """
        return pulumi.get(self, "client")

    @_builtins.property
    @pulumi.getter(name="clientVersion")
    def client_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Arbitrary version identifier for the API client.
        """
        return pulumi.get(self, "client_version")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Sequence['outputs.WorkerPoolCondition']]:
        """
        The Conditions of all other associated sub-resources. They contain additional diagnostics information in case the WorkerPool does not reach its Serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the authenticated creator.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="customAudiences")
    def custom_audiences(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        One or more custom audiences that you want this worker pool to support. Specify each custom audience as the full URL in a string. The custom audiences are encoded in the token and used to authenticate requests.
        For more information, see https://cloud.google.com/run/docs/configuring/custom-audiences.
        """
        return pulumi.get(self, "custom_audiences")

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        The deletion time.
        """
        return pulumi.get(self, "delete_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-provided description of the WorkerPool. This field currently has a 512-character limit.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        A system-generated fingerprint for this version of the resource. May be used to detect modification conflict during updates.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        For a deleted resource, the time after which it will be permanently deleted.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> pulumi.Output[_builtins.str]:
        """
        A number that monotonically increases every time the user modifies the desired state. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter(name="instanceSplitStatuses")
    def instance_split_statuses(self) -> pulumi.Output[Sequence['outputs.WorkerPoolInstanceSplitStatus']]:
        """
        Detailed status information for corresponding instance splits. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_split_statuses")

    @_builtins.property
    @pulumi.getter(name="instanceSplits")
    def instance_splits(self) -> pulumi.Output[Sequence['outputs.WorkerPoolInstanceSplit']]:
        """
        Specifies how to distribute instances over a collection of Revisions belonging to the WorkerPool. If instance split is empty or not provided, defaults to 100% instances assigned to the latest Ready Revision.
        Structure is documented below.
        """
        return pulumi.get(self, "instance_splits")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that can be used to organize and categorize objects. User-provided labels are shared with Google's billing system, so they can be used to filter, or break down billing charges by team, component,
        environment, state, etc. For more information, visit https://cloud.google.com/resource-manager/docs/creating-managing-labels or https://cloud.google.com/run/docs/configuring/labels.
        Cloud Run API v2 does not support labels with  `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they will be rejected.
        All system labels in v1 now have a corresponding field in v2 WorkerPool.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="lastModifier")
    def last_modifier(self) -> pulumi.Output[_builtins.str]:
        """
        Email address of the last authenticated modifier.
        """
        return pulumi.get(self, "last_modifier")

    @_builtins.property
    @pulumi.getter(name="latestCreatedRevision")
    def latest_created_revision(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the last created revision. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_created_revision")

    @_builtins.property
    @pulumi.getter(name="latestReadyRevision")
    def latest_ready_revision(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the latest revision that is serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        """
        return pulumi.get(self, "latest_ready_revision")

    @_builtins.property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> pulumi.Output[_builtins.str]:
        """
        The launch stage as defined by [Google Cloud Platform Launch Stages](https://cloud.google.com/products#product-launch-stages). Cloud Run supports ALPHA, BETA, and GA.
        If no value is specified, GA is assumed. Set the launch stage to a preview stage on input to allow use of preview features in that stage. On read (or output), describes whether the resource uses preview features.
        For example, if ALPHA is provided as input, but only BETA and GA-level features are used, this field will be BETA on output.
        Possible values are: `UNIMPLEMENTED`, `PRELAUNCH`, `EARLY_ACCESS`, `ALPHA`, `BETA`, `GA`, `DEPRECATED`.
        """
        return pulumi.get(self, "launch_stage")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the cloud run worker pool
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the WorkerPool.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> pulumi.Output[_builtins.str]:
        """
        The generation of this WorkerPool currently serving traffic. See comments in reconciling for additional information on reconciliation process in Cloud Run. Please note that unlike v1, this is an int64 value. As with most Google APIs, its JSON representation will be a string instead of an integer.
        """
        return pulumi.get(self, "observed_generation")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[_builtins.bool]:
        """
        Returns true if the WorkerPool is currently being acted upon by the system to bring it into the desired state.
        When a new WorkerPool is created, or an existing one is updated, Cloud Run will asynchronously perform all necessary steps to bring the WorkerPool to the desired serving state. This process is called reconciliation. While reconciliation is in process, observedGeneration, latest_ready_revison, trafficStatuses, and uri will have transient values that might mismatch the intended state: Once reconciliation is over (and this field is false), there are two possible outcomes: reconciliation succeeded and the serving state matches the WorkerPool, or there was an error, and reconciliation failed. This state can be found in terminalCondition.state.
        If reconciliation succeeded, the following fields will match: traffic and trafficStatuses, observedGeneration and generation, latestReadyRevision and latestCreatedRevision.
        If reconciliation failed, trafficStatuses, observedGeneration, and latestReadyRevision will have the state of the last serving revision, or empty for newly created WorkerPools. Additional information on the failure can be found in terminalCondition and conditions.
        """
        return pulumi.get(self, "reconciling")

    @_builtins.property
    @pulumi.getter
    def scaling(self) -> pulumi.Output['outputs.WorkerPoolScaling']:
        """
        Scaling settings that apply to the worker pool.
        Structure is documented below.
        """
        return pulumi.get(self, "scaling")

    @_builtins.property
    @pulumi.getter
    def template(self) -> pulumi.Output['outputs.WorkerPoolTemplate']:
        """
        The template used to create revisions for this WorkerPool.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @_builtins.property
    @pulumi.getter(name="terminalConditions")
    def terminal_conditions(self) -> pulumi.Output[Sequence['outputs.WorkerPoolTerminalCondition']]:
        """
        The Condition of this WorkerPool, containing its readiness status, and detailed error information in case it did not reach a serving state. See comments in reconciling for additional information on reconciliation process in Cloud Run.
        Structure is documented below.
        """
        return pulumi.get(self, "terminal_conditions")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Server assigned unique identifier for the trigger. The value is a UUID4 string and guaranteed to remain unchanged until the resource is deleted.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last-modified time.
        """
        return pulumi.get(self, "update_time")

