# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'QueueAppEngineRoutingOverrideArgs',
    'QueueAppEngineRoutingOverrideArgsDict',
    'QueueHttpTargetArgs',
    'QueueHttpTargetArgsDict',
    'QueueHttpTargetHeaderOverrideArgs',
    'QueueHttpTargetHeaderOverrideArgsDict',
    'QueueHttpTargetHeaderOverrideHeaderArgs',
    'QueueHttpTargetHeaderOverrideHeaderArgsDict',
    'QueueHttpTargetOauthTokenArgs',
    'QueueHttpTargetOauthTokenArgsDict',
    'QueueHttpTargetOidcTokenArgs',
    'QueueHttpTargetOidcTokenArgsDict',
    'QueueHttpTargetUriOverrideArgs',
    'QueueHttpTargetUriOverrideArgsDict',
    'QueueHttpTargetUriOverridePathOverrideArgs',
    'QueueHttpTargetUriOverridePathOverrideArgsDict',
    'QueueHttpTargetUriOverrideQueryOverrideArgs',
    'QueueHttpTargetUriOverrideQueryOverrideArgsDict',
    'QueueIamBindingConditionArgs',
    'QueueIamBindingConditionArgsDict',
    'QueueIamMemberConditionArgs',
    'QueueIamMemberConditionArgsDict',
    'QueueRateLimitsArgs',
    'QueueRateLimitsArgsDict',
    'QueueRetryConfigArgs',
    'QueueRetryConfigArgsDict',
    'QueueStackdriverLoggingConfigArgs',
    'QueueStackdriverLoggingConfigArgsDict',
]

MYPY = False

if not MYPY:
    class QueueAppEngineRoutingOverrideArgsDict(TypedDict):
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Output)
        The host that the task is sent to.
        """
        instance: NotRequired[pulumi.Input[_builtins.str]]
        """
        App instance.
        By default, the task is sent to an instance which is available when the task is attempted.
        """
        service: NotRequired[pulumi.Input[_builtins.str]]
        """
        App service.
        By default, the task is sent to the service which is the default service when the task is attempted.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        App version.
        By default, the task is sent to the version which is the default version when the task is attempted.
        """
elif False:
    QueueAppEngineRoutingOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueAppEngineRoutingOverrideArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 service: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] host: (Output)
               The host that the task is sent to.
        :param pulumi.Input[_builtins.str] instance: App instance.
               By default, the task is sent to an instance which is available when the task is attempted.
        :param pulumi.Input[_builtins.str] service: App service.
               By default, the task is sent to the service which is the default service when the task is attempted.
        :param pulumi.Input[_builtins.str] version: App version.
               By default, the task is sent to the version which is the default version when the task is attempted.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The host that the task is sent to.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App instance.
        By default, the task is sent to an instance which is available when the task is attempted.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App service.
        By default, the task is sent to the service which is the default service when the task is attempted.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        App version.
        By default, the task is sent to the version which is the default version when the task is attempted.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class QueueHttpTargetArgsDict(TypedDict):
        header_overrides: NotRequired[pulumi.Input[Sequence[pulumi.Input['QueueHttpTargetHeaderOverrideArgsDict']]]]
        """
        HTTP target headers.
        This map contains the header field names and values.
        Headers will be set when running the CreateTask and/or BufferTask.
        These headers represent a subset of the headers that will be configured for the task's HTTP request.
        Some HTTP request headers will be ignored or replaced.
        Headers which can have multiple values (according to RFC2616) can be specified using comma-separated values.
        The size of the headers must be less than 80KB. Queue-level headers to override headers of all the tasks in the queue.
        Structure is documented below.
        """
        http_method: NotRequired[pulumi.Input[_builtins.str]]
        """
        The HTTP method to use for the request.
        When specified, it overrides HttpRequest for the task.
        Note that if the value is set to GET the body of the task will be ignored at execution time.
        Possible values are: `HTTP_METHOD_UNSPECIFIED`, `POST`, `GET`, `HEAD`, `PUT`, `DELETE`, `PATCH`, `OPTIONS`.
        """
        oauth_token: NotRequired[pulumi.Input['QueueHttpTargetOauthTokenArgsDict']]
        """
        If specified, an OAuth token is generated and attached as the Authorization header in the HTTP request.
        This type of authorization should generally be used only when calling Google APIs hosted on *.googleapis.com.
        Note that both the service account email and the scope MUST be specified when using the queue-level authorization override.
        Structure is documented below.
        """
        oidc_token: NotRequired[pulumi.Input['QueueHttpTargetOidcTokenArgsDict']]
        """
        If specified, an OIDC token is generated and attached as an Authorization header in the HTTP request.
        This type of authorization can be used for many scenarios, including calling Cloud Run, or endpoints where you intend to validate the token yourself.
        Note that both the service account email and the audience MUST be specified when using the queue-level authorization override.
        Structure is documented below.
        """
        uri_override: NotRequired[pulumi.Input['QueueHttpTargetUriOverrideArgsDict']]
        """
        URI override.
        When specified, overrides the execution URI for all the tasks in the queue.
        Structure is documented below.
        """
elif False:
    QueueHttpTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetArgs:
    def __init__(__self__, *,
                 header_overrides: Optional[pulumi.Input[Sequence[pulumi.Input['QueueHttpTargetHeaderOverrideArgs']]]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth_token: Optional[pulumi.Input['QueueHttpTargetOauthTokenArgs']] = None,
                 oidc_token: Optional[pulumi.Input['QueueHttpTargetOidcTokenArgs']] = None,
                 uri_override: Optional[pulumi.Input['QueueHttpTargetUriOverrideArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['QueueHttpTargetHeaderOverrideArgs']]] header_overrides: HTTP target headers.
               This map contains the header field names and values.
               Headers will be set when running the CreateTask and/or BufferTask.
               These headers represent a subset of the headers that will be configured for the task's HTTP request.
               Some HTTP request headers will be ignored or replaced.
               Headers which can have multiple values (according to RFC2616) can be specified using comma-separated values.
               The size of the headers must be less than 80KB. Queue-level headers to override headers of all the tasks in the queue.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] http_method: The HTTP method to use for the request.
               When specified, it overrides HttpRequest for the task.
               Note that if the value is set to GET the body of the task will be ignored at execution time.
               Possible values are: `HTTP_METHOD_UNSPECIFIED`, `POST`, `GET`, `HEAD`, `PUT`, `DELETE`, `PATCH`, `OPTIONS`.
        :param pulumi.Input['QueueHttpTargetOauthTokenArgs'] oauth_token: If specified, an OAuth token is generated and attached as the Authorization header in the HTTP request.
               This type of authorization should generally be used only when calling Google APIs hosted on *.googleapis.com.
               Note that both the service account email and the scope MUST be specified when using the queue-level authorization override.
               Structure is documented below.
        :param pulumi.Input['QueueHttpTargetOidcTokenArgs'] oidc_token: If specified, an OIDC token is generated and attached as an Authorization header in the HTTP request.
               This type of authorization can be used for many scenarios, including calling Cloud Run, or endpoints where you intend to validate the token yourself.
               Note that both the service account email and the audience MUST be specified when using the queue-level authorization override.
               Structure is documented below.
        :param pulumi.Input['QueueHttpTargetUriOverrideArgs'] uri_override: URI override.
               When specified, overrides the execution URI for all the tasks in the queue.
               Structure is documented below.
        """
        if header_overrides is not None:
            pulumi.set(__self__, "header_overrides", header_overrides)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if oauth_token is not None:
            pulumi.set(__self__, "oauth_token", oauth_token)
        if oidc_token is not None:
            pulumi.set(__self__, "oidc_token", oidc_token)
        if uri_override is not None:
            pulumi.set(__self__, "uri_override", uri_override)

    @_builtins.property
    @pulumi.getter(name="headerOverrides")
    def header_overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueueHttpTargetHeaderOverrideArgs']]]]:
        """
        HTTP target headers.
        This map contains the header field names and values.
        Headers will be set when running the CreateTask and/or BufferTask.
        These headers represent a subset of the headers that will be configured for the task's HTTP request.
        Some HTTP request headers will be ignored or replaced.
        Headers which can have multiple values (according to RFC2616) can be specified using comma-separated values.
        The size of the headers must be less than 80KB. Queue-level headers to override headers of all the tasks in the queue.
        Structure is documented below.
        """
        return pulumi.get(self, "header_overrides")

    @header_overrides.setter
    def header_overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueueHttpTargetHeaderOverrideArgs']]]]):
        pulumi.set(self, "header_overrides", value)

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HTTP method to use for the request.
        When specified, it overrides HttpRequest for the task.
        Note that if the value is set to GET the body of the task will be ignored at execution time.
        Possible values are: `HTTP_METHOD_UNSPECIFIED`, `POST`, `GET`, `HEAD`, `PUT`, `DELETE`, `PATCH`, `OPTIONS`.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_method", value)

    @_builtins.property
    @pulumi.getter(name="oauthToken")
    def oauth_token(self) -> Optional[pulumi.Input['QueueHttpTargetOauthTokenArgs']]:
        """
        If specified, an OAuth token is generated and attached as the Authorization header in the HTTP request.
        This type of authorization should generally be used only when calling Google APIs hosted on *.googleapis.com.
        Note that both the service account email and the scope MUST be specified when using the queue-level authorization override.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth_token")

    @oauth_token.setter
    def oauth_token(self, value: Optional[pulumi.Input['QueueHttpTargetOauthTokenArgs']]):
        pulumi.set(self, "oauth_token", value)

    @_builtins.property
    @pulumi.getter(name="oidcToken")
    def oidc_token(self) -> Optional[pulumi.Input['QueueHttpTargetOidcTokenArgs']]:
        """
        If specified, an OIDC token is generated and attached as an Authorization header in the HTTP request.
        This type of authorization can be used for many scenarios, including calling Cloud Run, or endpoints where you intend to validate the token yourself.
        Note that both the service account email and the audience MUST be specified when using the queue-level authorization override.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_token")

    @oidc_token.setter
    def oidc_token(self, value: Optional[pulumi.Input['QueueHttpTargetOidcTokenArgs']]):
        pulumi.set(self, "oidc_token", value)

    @_builtins.property
    @pulumi.getter(name="uriOverride")
    def uri_override(self) -> Optional[pulumi.Input['QueueHttpTargetUriOverrideArgs']]:
        """
        URI override.
        When specified, overrides the execution URI for all the tasks in the queue.
        Structure is documented below.
        """
        return pulumi.get(self, "uri_override")

    @uri_override.setter
    def uri_override(self, value: Optional[pulumi.Input['QueueHttpTargetUriOverrideArgs']]):
        pulumi.set(self, "uri_override", value)


if not MYPY:
    class QueueHttpTargetHeaderOverrideArgsDict(TypedDict):
        header: pulumi.Input['QueueHttpTargetHeaderOverrideHeaderArgsDict']
        """
        Header embodying a key and a value.
        Structure is documented below.
        """
elif False:
    QueueHttpTargetHeaderOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetHeaderOverrideArgs:
    def __init__(__self__, *,
                 header: pulumi.Input['QueueHttpTargetHeaderOverrideHeaderArgs']):
        """
        :param pulumi.Input['QueueHttpTargetHeaderOverrideHeaderArgs'] header: Header embodying a key and a value.
               Structure is documented below.
        """
        pulumi.set(__self__, "header", header)

    @_builtins.property
    @pulumi.getter
    def header(self) -> pulumi.Input['QueueHttpTargetHeaderOverrideHeaderArgs']:
        """
        Header embodying a key and a value.
        Structure is documented below.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: pulumi.Input['QueueHttpTargetHeaderOverrideHeaderArgs']):
        pulumi.set(self, "header", value)


if not MYPY:
    class QueueHttpTargetHeaderOverrideHeaderArgsDict(TypedDict):
        key: pulumi.Input[_builtins.str]
        """
        The Key of the header.
        """
        value: pulumi.Input[_builtins.str]
        """
        The Value of the header.
        """
elif False:
    QueueHttpTargetHeaderOverrideHeaderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetHeaderOverrideHeaderArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key: The Key of the header.
        :param pulumi.Input[_builtins.str] value: The Value of the header.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The Key of the header.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The Value of the header.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class QueueHttpTargetOauthTokenArgsDict(TypedDict):
        service_account_email: pulumi.Input[_builtins.str]
        """
        Service account email to be used for generating OAuth token.
        The service account must be within the same project as the queue.
        The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        scope: NotRequired[pulumi.Input[_builtins.str]]
        """
        OAuth scope to be used for generating OAuth access token.
        If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
        """
elif False:
    QueueHttpTargetOauthTokenArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetOauthTokenArgs:
    def __init__(__self__, *,
                 service_account_email: pulumi.Input[_builtins.str],
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] service_account_email: Service account email to be used for generating OAuth token.
               The service account must be within the same project as the queue.
               The caller must have iam.serviceAccounts.actAs permission for the service account.
        :param pulumi.Input[_builtins.str] scope: OAuth scope to be used for generating OAuth access token.
               If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
        """
        pulumi.set(__self__, "service_account_email", service_account_email)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Input[_builtins.str]:
        """
        Service account email to be used for generating OAuth token.
        The service account must be within the same project as the queue.
        The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth scope to be used for generating OAuth access token.
        If not specified, "https://www.googleapis.com/auth/cloud-platform" will be used.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


if not MYPY:
    class QueueHttpTargetOidcTokenArgsDict(TypedDict):
        service_account_email: pulumi.Input[_builtins.str]
        """
        Service account email to be used for generating OIDC token.
        The service account must be within the same project as the queue.
        The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        audience: NotRequired[pulumi.Input[_builtins.str]]
        """
        Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
        """
elif False:
    QueueHttpTargetOidcTokenArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetOidcTokenArgs:
    def __init__(__self__, *,
                 service_account_email: pulumi.Input[_builtins.str],
                 audience: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] service_account_email: Service account email to be used for generating OIDC token.
               The service account must be within the same project as the queue.
               The caller must have iam.serviceAccounts.actAs permission for the service account.
        :param pulumi.Input[_builtins.str] audience: Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
        """
        pulumi.set(__self__, "service_account_email", service_account_email)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Input[_builtins.str]:
        """
        Service account email to be used for generating OIDC token.
        The service account must be within the same project as the queue.
        The caller must have iam.serviceAccounts.actAs permission for the service account.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Audience to be used when generating OIDC token. If not specified, the URI specified in target will be used.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "audience", value)


if not MYPY:
    class QueueHttpTargetUriOverrideArgsDict(TypedDict):
        host: NotRequired[pulumi.Input[_builtins.str]]
        """
        Host override.
        When specified, replaces the host part of the task URL.
        For example, if the task URL is "https://www.google.com", and host value
        is set to "example.net", the overridden URI will be changed to "https://example.net".
        Host value cannot be an empty string (INVALID_ARGUMENT).
        """
        path_override: NotRequired[pulumi.Input['QueueHttpTargetUriOverridePathOverrideArgsDict']]
        """
        URI path.
        When specified, replaces the existing path of the task URL.
        Setting the path value to an empty string clears the URI path segment.
        Structure is documented below.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        Port override.
        When specified, replaces the port part of the task URI.
        For instance, for a URI http://www.google.com/foo and port=123, the overridden URI becomes http://www.google.com:123/foo.
        Note that the port value must be a positive integer.
        Setting the port to 0 (Zero) clears the URI port.
        """
        query_override: NotRequired[pulumi.Input['QueueHttpTargetUriOverrideQueryOverrideArgsDict']]
        """
        URI query.
        When specified, replaces the query part of the task URI. Setting the query value to an empty string clears the URI query segment.
        Structure is documented below.
        """
        scheme: NotRequired[pulumi.Input[_builtins.str]]
        """
        Scheme override.
        When specified, the task URI scheme is replaced by the provided value (HTTP or HTTPS).
        Possible values are: `HTTP`, `HTTPS`.
        """
        uri_override_enforce_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        URI Override Enforce Mode
        When specified, determines the Target UriOverride mode. If not specified, it defaults to ALWAYS.
        Possible values are: `ALWAYS`, `IF_NOT_EXISTS`.
        """
elif False:
    QueueHttpTargetUriOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetUriOverrideArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 path_override: Optional[pulumi.Input['QueueHttpTargetUriOverridePathOverrideArgs']] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 query_override: Optional[pulumi.Input['QueueHttpTargetUriOverrideQueryOverrideArgs']] = None,
                 scheme: Optional[pulumi.Input[_builtins.str]] = None,
                 uri_override_enforce_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] host: Host override.
               When specified, replaces the host part of the task URL.
               For example, if the task URL is "https://www.google.com", and host value
               is set to "example.net", the overridden URI will be changed to "https://example.net".
               Host value cannot be an empty string (INVALID_ARGUMENT).
        :param pulumi.Input['QueueHttpTargetUriOverridePathOverrideArgs'] path_override: URI path.
               When specified, replaces the existing path of the task URL.
               Setting the path value to an empty string clears the URI path segment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] port: Port override.
               When specified, replaces the port part of the task URI.
               For instance, for a URI http://www.google.com/foo and port=123, the overridden URI becomes http://www.google.com:123/foo.
               Note that the port value must be a positive integer.
               Setting the port to 0 (Zero) clears the URI port.
        :param pulumi.Input['QueueHttpTargetUriOverrideQueryOverrideArgs'] query_override: URI query.
               When specified, replaces the query part of the task URI. Setting the query value to an empty string clears the URI query segment.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] scheme: Scheme override.
               When specified, the task URI scheme is replaced by the provided value (HTTP or HTTPS).
               Possible values are: `HTTP`, `HTTPS`.
        :param pulumi.Input[_builtins.str] uri_override_enforce_mode: URI Override Enforce Mode
               When specified, determines the Target UriOverride mode. If not specified, it defaults to ALWAYS.
               Possible values are: `ALWAYS`, `IF_NOT_EXISTS`.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if path_override is not None:
            pulumi.set(__self__, "path_override", path_override)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if query_override is not None:
            pulumi.set(__self__, "query_override", query_override)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if uri_override_enforce_mode is not None:
            pulumi.set(__self__, "uri_override_enforce_mode", uri_override_enforce_mode)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Host override.
        When specified, replaces the host part of the task URL.
        For example, if the task URL is "https://www.google.com", and host value
        is set to "example.net", the overridden URI will be changed to "https://example.net".
        Host value cannot be an empty string (INVALID_ARGUMENT).
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="pathOverride")
    def path_override(self) -> Optional[pulumi.Input['QueueHttpTargetUriOverridePathOverrideArgs']]:
        """
        URI path.
        When specified, replaces the existing path of the task URL.
        Setting the path value to an empty string clears the URI path segment.
        Structure is documented below.
        """
        return pulumi.get(self, "path_override")

    @path_override.setter
    def path_override(self, value: Optional[pulumi.Input['QueueHttpTargetUriOverridePathOverrideArgs']]):
        pulumi.set(self, "path_override", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Port override.
        When specified, replaces the port part of the task URI.
        For instance, for a URI http://www.google.com/foo and port=123, the overridden URI becomes http://www.google.com:123/foo.
        Note that the port value must be a positive integer.
        Setting the port to 0 (Zero) clears the URI port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="queryOverride")
    def query_override(self) -> Optional[pulumi.Input['QueueHttpTargetUriOverrideQueryOverrideArgs']]:
        """
        URI query.
        When specified, replaces the query part of the task URI. Setting the query value to an empty string clears the URI query segment.
        Structure is documented below.
        """
        return pulumi.get(self, "query_override")

    @query_override.setter
    def query_override(self, value: Optional[pulumi.Input['QueueHttpTargetUriOverrideQueryOverrideArgs']]):
        pulumi.set(self, "query_override", value)

    @_builtins.property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheme override.
        When specified, the task URI scheme is replaced by the provided value (HTTP or HTTPS).
        Possible values are: `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheme", value)

    @_builtins.property
    @pulumi.getter(name="uriOverrideEnforceMode")
    def uri_override_enforce_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI Override Enforce Mode
        When specified, determines the Target UriOverride mode. If not specified, it defaults to ALWAYS.
        Possible values are: `ALWAYS`, `IF_NOT_EXISTS`.
        """
        return pulumi.get(self, "uri_override_enforce_mode")

    @uri_override_enforce_mode.setter
    def uri_override_enforce_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri_override_enforce_mode", value)


if not MYPY:
    class QueueHttpTargetUriOverridePathOverrideArgsDict(TypedDict):
        path: NotRequired[pulumi.Input[_builtins.str]]
        """
        The URI path (e.g., /users/1234). Default is an empty string.
        """
elif False:
    QueueHttpTargetUriOverridePathOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetUriOverridePathOverrideArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] path: The URI path (e.g., /users/1234). Default is an empty string.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI path (e.g., /users/1234). Default is an empty string.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class QueueHttpTargetUriOverrideQueryOverrideArgsDict(TypedDict):
        query_params: NotRequired[pulumi.Input[_builtins.str]]
        """
        The query parameters (e.g., qparam1=123&qparam2=456). Default is an empty string.
        """
elif False:
    QueueHttpTargetUriOverrideQueryOverrideArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueHttpTargetUriOverrideQueryOverrideArgs:
    def __init__(__self__, *,
                 query_params: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] query_params: The query parameters (e.g., qparam1=123&qparam2=456). Default is an empty string.
        """
        if query_params is not None:
            pulumi.set(__self__, "query_params", query_params)

    @_builtins.property
    @pulumi.getter(name="queryParams")
    def query_params(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The query parameters (e.g., qparam1=123&qparam2=456). Default is an empty string.
        """
        return pulumi.get(self, "query_params")

    @query_params.setter
    def query_params(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_params", value)


if not MYPY:
    class QueueIamBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        title: pulumi.Input[_builtins.str]
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    QueueIamBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class QueueIamMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[_builtins.str]
        title: pulumi.Input[_builtins.str]
        description: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    QueueIamMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[_builtins.str],
                 title: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expression", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "title", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class QueueRateLimitsArgsDict(TypedDict):
        max_burst_size: NotRequired[pulumi.Input[_builtins.int]]
        """
        (Output)
        The max burst size.
        Max burst size limits how fast tasks in queue are processed when many tasks are
        in the queue and the rate is high. This field allows the queue to have a high
        rate so processing starts shortly after a task is enqueued, but still limits
        resource usage when many tasks are enqueued in a short period of time.
        """
        max_concurrent_dispatches: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of concurrent tasks that Cloud Tasks allows to
        be dispatched for this queue. After this threshold has been
        reached, Cloud Tasks stops dispatching tasks until the number of
        concurrent requests decreases.
        """
        max_dispatches_per_second: NotRequired[pulumi.Input[_builtins.float]]
        """
        The maximum rate at which tasks are dispatched from this queue.
        If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
elif False:
    QueueRateLimitsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueRateLimitsArgs:
    def __init__(__self__, *,
                 max_burst_size: Optional[pulumi.Input[_builtins.int]] = None,
                 max_concurrent_dispatches: Optional[pulumi.Input[_builtins.int]] = None,
                 max_dispatches_per_second: Optional[pulumi.Input[_builtins.float]] = None):
        """
        :param pulumi.Input[_builtins.int] max_burst_size: (Output)
               The max burst size.
               Max burst size limits how fast tasks in queue are processed when many tasks are
               in the queue and the rate is high. This field allows the queue to have a high
               rate so processing starts shortly after a task is enqueued, but still limits
               resource usage when many tasks are enqueued in a short period of time.
        :param pulumi.Input[_builtins.int] max_concurrent_dispatches: The maximum number of concurrent tasks that Cloud Tasks allows to
               be dispatched for this queue. After this threshold has been
               reached, Cloud Tasks stops dispatching tasks until the number of
               concurrent requests decreases.
        :param pulumi.Input[_builtins.float] max_dispatches_per_second: The maximum rate at which tasks are dispatched from this queue.
               If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        if max_burst_size is not None:
            pulumi.set(__self__, "max_burst_size", max_burst_size)
        if max_concurrent_dispatches is not None:
            pulumi.set(__self__, "max_concurrent_dispatches", max_concurrent_dispatches)
        if max_dispatches_per_second is not None:
            pulumi.set(__self__, "max_dispatches_per_second", max_dispatches_per_second)

    @_builtins.property
    @pulumi.getter(name="maxBurstSize")
    def max_burst_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Output)
        The max burst size.
        Max burst size limits how fast tasks in queue are processed when many tasks are
        in the queue and the rate is high. This field allows the queue to have a high
        rate so processing starts shortly after a task is enqueued, but still limits
        resource usage when many tasks are enqueued in a short period of time.
        """
        return pulumi.get(self, "max_burst_size")

    @max_burst_size.setter
    def max_burst_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_burst_size", value)

    @_builtins.property
    @pulumi.getter(name="maxConcurrentDispatches")
    def max_concurrent_dispatches(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of concurrent tasks that Cloud Tasks allows to
        be dispatched for this queue. After this threshold has been
        reached, Cloud Tasks stops dispatching tasks until the number of
        concurrent requests decreases.
        """
        return pulumi.get(self, "max_concurrent_dispatches")

    @max_concurrent_dispatches.setter
    def max_concurrent_dispatches(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_concurrent_dispatches", value)

    @_builtins.property
    @pulumi.getter(name="maxDispatchesPerSecond")
    def max_dispatches_per_second(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The maximum rate at which tasks are dispatched from this queue.
        If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        return pulumi.get(self, "max_dispatches_per_second")

    @max_dispatches_per_second.setter
    def max_dispatches_per_second(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "max_dispatches_per_second", value)


if not MYPY:
    class QueueRetryConfigArgsDict(TypedDict):
        max_attempts: NotRequired[pulumi.Input[_builtins.int]]
        """
        Number of attempts per task.
        Cloud Tasks will attempt the task maxAttempts times (that is, if
        the first attempt fails, then there will be maxAttempts - 1
        retries). Must be >= -1.
        If unspecified when the queue is created, Cloud Tasks will pick
        the default.
        -1 indicates unlimited attempts.
        """
        max_backoff: NotRequired[pulumi.Input[_builtins.str]]
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
        max_doublings: NotRequired[pulumi.Input[_builtins.int]]
        """
        The time between retries will double maxDoublings times.
        A task's retry interval starts at minBackoff, then doubles maxDoublings times,
        then increases linearly, and finally retries retries at intervals of maxBackoff
        up to maxAttempts times.
        """
        max_retry_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        If positive, maxRetryDuration specifies the time limit for
        retrying a failed task, measured from when the task was first
        attempted. Once maxRetryDuration time has passed and the task has
        been attempted maxAttempts times, no further attempts will be
        made and the task will be deleted.
        If zero, then the task age is unlimited.
        """
        min_backoff: NotRequired[pulumi.Input[_builtins.str]]
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
elif False:
    QueueRetryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueRetryConfigArgs:
    def __init__(__self__, *,
                 max_attempts: Optional[pulumi.Input[_builtins.int]] = None,
                 max_backoff: Optional[pulumi.Input[_builtins.str]] = None,
                 max_doublings: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retry_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 min_backoff: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] max_attempts: Number of attempts per task.
               Cloud Tasks will attempt the task maxAttempts times (that is, if
               the first attempt fails, then there will be maxAttempts - 1
               retries). Must be >= -1.
               If unspecified when the queue is created, Cloud Tasks will pick
               the default.
               -1 indicates unlimited attempts.
        :param pulumi.Input[_builtins.str] max_backoff: A task will be scheduled for retry between minBackoff and
               maxBackoff duration after it fails, if the queue's RetryConfig
               specifies that the task should be retried.
        :param pulumi.Input[_builtins.int] max_doublings: The time between retries will double maxDoublings times.
               A task's retry interval starts at minBackoff, then doubles maxDoublings times,
               then increases linearly, and finally retries retries at intervals of maxBackoff
               up to maxAttempts times.
        :param pulumi.Input[_builtins.str] max_retry_duration: If positive, maxRetryDuration specifies the time limit for
               retrying a failed task, measured from when the task was first
               attempted. Once maxRetryDuration time has passed and the task has
               been attempted maxAttempts times, no further attempts will be
               made and the task will be deleted.
               If zero, then the task age is unlimited.
        :param pulumi.Input[_builtins.str] min_backoff: A task will be scheduled for retry between minBackoff and
               maxBackoff duration after it fails, if the queue's RetryConfig
               specifies that the task should be retried.
        """
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if max_backoff is not None:
            pulumi.set(__self__, "max_backoff", max_backoff)
        if max_doublings is not None:
            pulumi.set(__self__, "max_doublings", max_doublings)
        if max_retry_duration is not None:
            pulumi.set(__self__, "max_retry_duration", max_retry_duration)
        if min_backoff is not None:
            pulumi.set(__self__, "min_backoff", min_backoff)

    @_builtins.property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of attempts per task.
        Cloud Tasks will attempt the task maxAttempts times (that is, if
        the first attempt fails, then there will be maxAttempts - 1
        retries). Must be >= -1.
        If unspecified when the queue is created, Cloud Tasks will pick
        the default.
        -1 indicates unlimited attempts.
        """
        return pulumi.get(self, "max_attempts")

    @max_attempts.setter
    def max_attempts(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_attempts", value)

    @_builtins.property
    @pulumi.getter(name="maxBackoff")
    def max_backoff(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
        return pulumi.get(self, "max_backoff")

    @max_backoff.setter
    def max_backoff(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_backoff", value)

    @_builtins.property
    @pulumi.getter(name="maxDoublings")
    def max_doublings(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time between retries will double maxDoublings times.
        A task's retry interval starts at minBackoff, then doubles maxDoublings times,
        then increases linearly, and finally retries retries at intervals of maxBackoff
        up to maxAttempts times.
        """
        return pulumi.get(self, "max_doublings")

    @max_doublings.setter
    def max_doublings(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_doublings", value)

    @_builtins.property
    @pulumi.getter(name="maxRetryDuration")
    def max_retry_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If positive, maxRetryDuration specifies the time limit for
        retrying a failed task, measured from when the task was first
        attempted. Once maxRetryDuration time has passed and the task has
        been attempted maxAttempts times, no further attempts will be
        made and the task will be deleted.
        If zero, then the task age is unlimited.
        """
        return pulumi.get(self, "max_retry_duration")

    @max_retry_duration.setter
    def max_retry_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "max_retry_duration", value)

    @_builtins.property
    @pulumi.getter(name="minBackoff")
    def min_backoff(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
        return pulumi.get(self, "min_backoff")

    @min_backoff.setter
    def min_backoff(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_backoff", value)


if not MYPY:
    class QueueStackdriverLoggingConfigArgsDict(TypedDict):
        sampling_ratio: pulumi.Input[_builtins.float]
        """
        Specifies the fraction of operations to write to Stackdriver Logging.
        This field may contain any value between 0.0 and 1.0, inclusive. 0.0 is the
        default and means that no operations are logged.
        """
elif False:
    QueueStackdriverLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class QueueStackdriverLoggingConfigArgs:
    def __init__(__self__, *,
                 sampling_ratio: pulumi.Input[_builtins.float]):
        """
        :param pulumi.Input[_builtins.float] sampling_ratio: Specifies the fraction of operations to write to Stackdriver Logging.
               This field may contain any value between 0.0 and 1.0, inclusive. 0.0 is the
               default and means that no operations are logged.
        """
        pulumi.set(__self__, "sampling_ratio", sampling_ratio)

    @_builtins.property
    @pulumi.getter(name="samplingRatio")
    def sampling_ratio(self) -> pulumi.Input[_builtins.float]:
        """
        Specifies the fraction of operations to write to Stackdriver Logging.
        This field may contain any value between 0.0 and 1.0, inclusive. 0.0 is the
        default and means that no operations are logged.
        """
        return pulumi.get(self, "sampling_ratio")

    @sampling_ratio.setter
    def sampling_ratio(self, value: pulumi.Input[_builtins.float]):
        pulumi.set(self, "sampling_ratio", value)


