# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetInstanceIamPolicyResult',
    'AwaitableGetInstanceIamPolicyResult',
    'get_instance_iam_policy',
    'get_instance_iam_policy_output',
]

@pulumi.output_type
class GetInstanceIamPolicyResult:
    """
    A collection of values returned by getInstanceIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, instance_name=None, policy_data=None, project=None, zone=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `compute.InstanceIAMPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetInstanceIamPolicyResult(GetInstanceIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceIamPolicyResult(
            etag=self.etag,
            id=self.id,
            instance_name=self.instance_name,
            policy_data=self.policy_data,
            project=self.project,
            zone=self.zone)


def get_instance_iam_policy(instance_name: Optional[_builtins.str] = None,
                            project: Optional[_builtins.str] = None,
                            zone: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceIamPolicyResult:
    """
    Retrieves the current IAM policy data for instance

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.compute.get_instance_iam_policy(project=default["project"],
        zone=default["zone"],
        instance_name=default["name"])
    ```


    :param _builtins.str instance_name: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str zone: A reference to the zone where the machine resides. Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no zone is provided in the parent identifier and no
           zone is specified, it is taken from the provider configuration.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getInstanceIamPolicy:getInstanceIamPolicy', __args__, opts=opts, typ=GetInstanceIamPolicyResult).value

    return AwaitableGetInstanceIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        zone=pulumi.get(__ret__, 'zone'))
def get_instance_iam_policy_output(instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                                   project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceIamPolicyResult]:
    """
    Retrieves the current IAM policy data for instance

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.compute.get_instance_iam_policy(project=default["project"],
        zone=default["zone"],
        instance_name=default["name"])
    ```


    :param _builtins.str instance_name: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str zone: A reference to the zone where the machine resides. Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no zone is provided in the parent identifier and no
           zone is specified, it is taken from the provider configuration.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getInstanceIamPolicy:getInstanceIamPolicy', __args__, opts=opts, typ=GetInstanceIamPolicyResult)
    return __ret__.apply(lambda __response__: GetInstanceIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        zone=pulumi.get(__response__, 'zone')))
