# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSubnetworksResult',
    'AwaitableGetSubnetworksResult',
    'get_subnetworks',
    'get_subnetworks_output',
]

@pulumi.output_type
class GetSubnetworksResult:
    """
    A collection of values returned by getSubnetworks.
    """
    def __init__(__self__, filter=None, id=None, project=None, region=None, subnetworks=None):
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if subnetworks and not isinstance(subnetworks, list):
            raise TypeError("Expected argument 'subnetworks' to be a list")
        pulumi.set(__self__, "subnetworks", subnetworks)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> Sequence['outputs.GetSubnetworksSubnetworkResult']:
        """
        A list of all retrieved GCE subnetworks. Structure is defined below.
        """
        return pulumi.get(self, "subnetworks")


class AwaitableGetSubnetworksResult(GetSubnetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubnetworksResult(
            filter=self.filter,
            id=self.id,
            project=self.project,
            region=self.region,
            subnetworks=self.subnetworks)


def get_subnetworks(filter: Optional[_builtins.str] = None,
                    project: Optional[_builtins.str] = None,
                    region: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubnetworksResult:
    """
    Get subnetworks within GCE.
    See [the official documentation](https://cloud.google.com/vpc/docs/subnets)
    and [API](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_subnetworks = gcp.compute.get_subnetworks(filter="ipCidrRange eq 192.168.178.0/24",
        project="my-project",
        region="us-east1")
    ```


    :param _builtins.str filter: A string filter as defined in the [REST API](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks/list#query-parameters).
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str region: The region this subnetwork has been created in. If
           unspecified, this defaults to the region configured in the provider.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getSubnetworks:getSubnetworks', __args__, opts=opts, typ=GetSubnetworksResult).value

    return AwaitableGetSubnetworksResult(
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'),
        subnetworks=pulumi.get(__ret__, 'subnetworks'))
def get_subnetworks_output(filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubnetworksResult]:
    """
    Get subnetworks within GCE.
    See [the official documentation](https://cloud.google.com/vpc/docs/subnets)
    and [API](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks/list).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_subnetworks = gcp.compute.get_subnetworks(filter="ipCidrRange eq 192.168.178.0/24",
        project="my-project",
        region="us-east1")
    ```


    :param _builtins.str filter: A string filter as defined in the [REST API](https://cloud.google.com/compute/docs/reference/rest/v1/subnetworks/list#query-parameters).
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param _builtins.str region: The region this subnetwork has been created in. If
           unspecified, this defaults to the region configured in the provider.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getSubnetworks:getSubnetworks', __args__, opts=opts, typ=GetSubnetworksResult)
    return __ret__.apply(lambda __response__: GetSubnetworksResult(
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region'),
        subnetworks=pulumi.get(__response__, 'subnetworks')))
