# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceGroupManagerArgs', 'InstanceGroupManager']

@pulumi.input_type
class InstanceGroupManagerArgs:
    def __init__(__self__, *,
                 base_instance_name: pulumi.Input[_builtins.str],
                 versions: pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]],
                 all_instances_config: Optional[pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs']] = None,
                 auto_healing_policies: Optional[pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_lifecycle_policy: Optional[pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs']] = None,
                 list_managed_instances_results: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_ports: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]]] = None,
                 params: Optional[pulumi.Input['InstanceGroupManagerParamsArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_policies: Optional[pulumi.Input['InstanceGroupManagerResourcePoliciesArgs']] = None,
                 standby_policy: Optional[pulumi.Input['InstanceGroupManagerStandbyPolicyArgs']] = None,
                 stateful_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]]] = None,
                 stateful_external_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]]] = None,
                 stateful_internal_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]]] = None,
                 target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_stopped_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_suspended_size: Optional[pulumi.Input[_builtins.int]] = None,
                 update_policy: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyArgs']] = None,
                 wait_for_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_instances_status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceGroupManager resource.
        :param pulumi.Input[_builtins.str] base_instance_name: The base instance name to use for
               instances in this group. The value must be a valid
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) name. Supported characters
               are lowercase letters, numbers, and hyphens (-). Instances are named by
               appending a hyphen and a random four-character string to the base instance
               name.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]] versions: Application versions managed by this instance group. Each
               version deals with a specific instance template, allowing canary release scenarios.
               Structure is documented below.
        :param pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs'] all_instances_config: Properties to set on all instances in the group. After setting
               allInstancesConfig on the group, you must update the group's instances to
               apply the configuration.
        :param pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs'] auto_healing_policies: The autohealing policies for this managed instance
               group. You can specify only one value. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances#monitoring_groups).
        :param pulumi.Input[_builtins.str] description: An optional textual description of the instance
               group manager.
        :param pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs'] instance_lifecycle_policy: The instance lifecycle policy for this managed instance group.
        :param pulumi.Input[_builtins.str] list_managed_instances_results: Pagination behavior of the `listManagedInstances` API
               method for this managed instance group. Valid values are: `PAGELESS`, `PAGINATED`.
               If `PAGELESS` (default), Pagination is disabled for the group's `listManagedInstances` API method.
               `maxResults` and `pageToken` query parameters are ignored and all instances are returned in a single
               response. If `PAGINATED`, pagination is enabled, `maxResults` and `pageToken` query parameters are
               respected.
        :param pulumi.Input[_builtins.str] name: The name of the instance group manager. Must be 1-63
               characters long and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Supported characters
               include lowercase letters, numbers, and hyphens.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]] named_ports: The named port configuration. See the section below
               for details on configuration.
        :param pulumi.Input['InstanceGroupManagerParamsArgs'] params: Input only additional params for instance group manager creation. Structure is documented below. For more information, see [API](https://cloud.google.com/compute/docs/reference/rest/beta/instanceGroupManagers/insert).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['InstanceGroupManagerResourcePoliciesArgs'] resource_policies: Resource policies for this managed instance group. Structure is documented below.
               
               - - -
        :param pulumi.Input['InstanceGroupManagerStandbyPolicyArgs'] standby_policy: The standby policy for stopped and suspended instances. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/suspended-and-stopped-vms-in-mig).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]] stateful_disks: Disks created on the instances that will be preserved on instance delete, update, etc. Structure is documented below. For more information see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/configuring-stateful-disks-in-migs).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]] stateful_external_ips: External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]] stateful_internal_ips: Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_pools: The full URL of all target pools to which new
               instances in the group are added. Updating the target pools attribute does
               not affect existing instances.
        :param pulumi.Input[_builtins.int] target_size: The target number of running instances for this managed instance group. This value should always be explicitly set
               unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
        :param pulumi.Input[_builtins.int] target_stopped_size: The target number of stopped instances for this managed instance group.
        :param pulumi.Input[_builtins.int] target_suspended_size: The target number of suspended instances for this managed instance group.
        :param pulumi.Input['InstanceGroupManagerUpdatePolicyArgs'] update_policy: The update policy for this managed instance group. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/updating-managed-instance-groups) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagers/patch).
        :param pulumi.Input[_builtins.bool] wait_for_instances: Whether to wait for all instances to be created/updated before
               returning. Note that if this is set to true and the operation does not succeed, this provider will
               continue trying until it times out.
        :param pulumi.Input[_builtins.str] wait_for_instances_status: When used with `wait_for_instances` it specifies the status to wait for.
               When `STABLE` is specified this resource will wait until the instances are stable before returning. When `UPDATED` is
               set, it will wait for the version target to be reached and any per instance configs to be effective as well as all
               instances to be stable before returning. The possible values are `STABLE` and `UPDATED`
        :param pulumi.Input[_builtins.str] zone: The zone that instances in this group should be created
               in.
               
               - - -
        """
        pulumi.set(__self__, "base_instance_name", base_instance_name)
        pulumi.set(__self__, "versions", versions)
        if all_instances_config is not None:
            pulumi.set(__self__, "all_instances_config", all_instances_config)
        if auto_healing_policies is not None:
            pulumi.set(__self__, "auto_healing_policies", auto_healing_policies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_lifecycle_policy is not None:
            pulumi.set(__self__, "instance_lifecycle_policy", instance_lifecycle_policy)
        if list_managed_instances_results is not None:
            pulumi.set(__self__, "list_managed_instances_results", list_managed_instances_results)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_ports is not None:
            pulumi.set(__self__, "named_ports", named_ports)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if standby_policy is not None:
            pulumi.set(__self__, "standby_policy", standby_policy)
        if stateful_disks is not None:
            pulumi.set(__self__, "stateful_disks", stateful_disks)
        if stateful_external_ips is not None:
            pulumi.set(__self__, "stateful_external_ips", stateful_external_ips)
        if stateful_internal_ips is not None:
            pulumi.set(__self__, "stateful_internal_ips", stateful_internal_ips)
        if target_pools is not None:
            pulumi.set(__self__, "target_pools", target_pools)
        if target_size is not None:
            pulumi.set(__self__, "target_size", target_size)
        if target_stopped_size is not None:
            pulumi.set(__self__, "target_stopped_size", target_stopped_size)
        if target_suspended_size is not None:
            pulumi.set(__self__, "target_suspended_size", target_suspended_size)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if wait_for_instances is not None:
            pulumi.set(__self__, "wait_for_instances", wait_for_instances)
        if wait_for_instances_status is not None:
            pulumi.set(__self__, "wait_for_instances_status", wait_for_instances_status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="baseInstanceName")
    def base_instance_name(self) -> pulumi.Input[_builtins.str]:
        """
        The base instance name to use for
        instances in this group. The value must be a valid
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) name. Supported characters
        are lowercase letters, numbers, and hyphens (-). Instances are named by
        appending a hyphen and a random four-character string to the base instance
        name.
        """
        return pulumi.get(self, "base_instance_name")

    @base_instance_name.setter
    def base_instance_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "base_instance_name", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]]:
        """
        Application versions managed by this instance group. Each
        version deals with a specific instance template, allowing canary release scenarios.
        Structure is documented below.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]]):
        pulumi.set(self, "versions", value)

    @_builtins.property
    @pulumi.getter(name="allInstancesConfig")
    def all_instances_config(self) -> Optional[pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs']]:
        """
        Properties to set on all instances in the group. After setting
        allInstancesConfig on the group, you must update the group's instances to
        apply the configuration.
        """
        return pulumi.get(self, "all_instances_config")

    @all_instances_config.setter
    def all_instances_config(self, value: Optional[pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs']]):
        pulumi.set(self, "all_instances_config", value)

    @_builtins.property
    @pulumi.getter(name="autoHealingPolicies")
    def auto_healing_policies(self) -> Optional[pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs']]:
        """
        The autohealing policies for this managed instance
        group. You can specify only one value. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances#monitoring_groups).
        """
        return pulumi.get(self, "auto_healing_policies")

    @auto_healing_policies.setter
    def auto_healing_policies(self, value: Optional[pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs']]):
        pulumi.set(self, "auto_healing_policies", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional textual description of the instance
        group manager.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceLifecyclePolicy")
    def instance_lifecycle_policy(self) -> Optional[pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs']]:
        """
        The instance lifecycle policy for this managed instance group.
        """
        return pulumi.get(self, "instance_lifecycle_policy")

    @instance_lifecycle_policy.setter
    def instance_lifecycle_policy(self, value: Optional[pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs']]):
        pulumi.set(self, "instance_lifecycle_policy", value)

    @_builtins.property
    @pulumi.getter(name="listManagedInstancesResults")
    def list_managed_instances_results(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pagination behavior of the `listManagedInstances` API
        method for this managed instance group. Valid values are: `PAGELESS`, `PAGINATED`.
        If `PAGELESS` (default), Pagination is disabled for the group's `listManagedInstances` API method.
        `maxResults` and `pageToken` query parameters are ignored and all instances are returned in a single
        response. If `PAGINATED`, pagination is enabled, `maxResults` and `pageToken` query parameters are
        respected.
        """
        return pulumi.get(self, "list_managed_instances_results")

    @list_managed_instances_results.setter
    def list_managed_instances_results(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "list_managed_instances_results", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance group manager. Must be 1-63
        characters long and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Supported characters
        include lowercase letters, numbers, and hyphens.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedPorts")
    def named_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]]]:
        """
        The named port configuration. See the section below
        for details on configuration.
        """
        return pulumi.get(self, "named_ports")

    @named_ports.setter
    def named_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]]]):
        pulumi.set(self, "named_ports", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['InstanceGroupManagerParamsArgs']]:
        """
        Input only additional params for instance group manager creation. Structure is documented below. For more information, see [API](https://cloud.google.com/compute/docs/reference/rest/beta/instanceGroupManagers/insert).
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['InstanceGroupManagerParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input['InstanceGroupManagerResourcePoliciesArgs']]:
        """
        Resource policies for this managed instance group. Structure is documented below.

        - - -
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input['InstanceGroupManagerResourcePoliciesArgs']]):
        pulumi.set(self, "resource_policies", value)

    @_builtins.property
    @pulumi.getter(name="standbyPolicy")
    def standby_policy(self) -> Optional[pulumi.Input['InstanceGroupManagerStandbyPolicyArgs']]:
        """
        The standby policy for stopped and suspended instances. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/suspended-and-stopped-vms-in-mig).
        """
        return pulumi.get(self, "standby_policy")

    @standby_policy.setter
    def standby_policy(self, value: Optional[pulumi.Input['InstanceGroupManagerStandbyPolicyArgs']]):
        pulumi.set(self, "standby_policy", value)

    @_builtins.property
    @pulumi.getter(name="statefulDisks")
    def stateful_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]]]:
        """
        Disks created on the instances that will be preserved on instance delete, update, etc. Structure is documented below. For more information see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/configuring-stateful-disks-in-migs).
        """
        return pulumi.get(self, "stateful_disks")

    @stateful_disks.setter
    def stateful_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]]]):
        pulumi.set(self, "stateful_disks", value)

    @_builtins.property
    @pulumi.getter(name="statefulExternalIps")
    def stateful_external_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]]]:
        """
        External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        """
        return pulumi.get(self, "stateful_external_ips")

    @stateful_external_ips.setter
    def stateful_external_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]]]):
        pulumi.set(self, "stateful_external_ips", value)

    @_builtins.property
    @pulumi.getter(name="statefulInternalIps")
    def stateful_internal_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]]]:
        """
        Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        """
        return pulumi.get(self, "stateful_internal_ips")

    @stateful_internal_ips.setter
    def stateful_internal_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]]]):
        pulumi.set(self, "stateful_internal_ips", value)

    @_builtins.property
    @pulumi.getter(name="targetPools")
    def target_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The full URL of all target pools to which new
        instances in the group are added. Updating the target pools attribute does
        not affect existing instances.
        """
        return pulumi.get(self, "target_pools")

    @target_pools.setter
    def target_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_pools", value)

    @_builtins.property
    @pulumi.getter(name="targetSize")
    def target_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The target number of running instances for this managed instance group. This value should always be explicitly set
        unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
        """
        return pulumi.get(self, "target_size")

    @target_size.setter
    def target_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_size", value)

    @_builtins.property
    @pulumi.getter(name="targetStoppedSize")
    def target_stopped_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The target number of stopped instances for this managed instance group.
        """
        return pulumi.get(self, "target_stopped_size")

    @target_stopped_size.setter
    def target_stopped_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_stopped_size", value)

    @_builtins.property
    @pulumi.getter(name="targetSuspendedSize")
    def target_suspended_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The target number of suspended instances for this managed instance group.
        """
        return pulumi.get(self, "target_suspended_size")

    @target_suspended_size.setter
    def target_suspended_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_suspended_size", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyArgs']]:
        """
        The update policy for this managed instance group. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/updating-managed-instance-groups) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagers/patch).
        """
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter(name="waitForInstances")
    def wait_for_instances(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait for all instances to be created/updated before
        returning. Note that if this is set to true and the operation does not succeed, this provider will
        continue trying until it times out.
        """
        return pulumi.get(self, "wait_for_instances")

    @wait_for_instances.setter
    def wait_for_instances(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_instances", value)

    @_builtins.property
    @pulumi.getter(name="waitForInstancesStatus")
    def wait_for_instances_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When used with `wait_for_instances` it specifies the status to wait for.
        When `STABLE` is specified this resource will wait until the instances are stable before returning. When `UPDATED` is
        set, it will wait for the version target to be reached and any per instance configs to be effective as well as all
        instances to be stable before returning. The possible values are `STABLE` and `UPDATED`
        """
        return pulumi.get(self, "wait_for_instances_status")

    @wait_for_instances_status.setter
    def wait_for_instances_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wait_for_instances_status", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone that instances in this group should be created
        in.

        - - -
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceGroupManagerState:
    def __init__(__self__, *,
                 all_instances_config: Optional[pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs']] = None,
                 auto_healing_policies: Optional[pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs']] = None,
                 base_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_group_manager_id: Optional[pulumi.Input[_builtins.int]] = None,
                 instance_lifecycle_policy: Optional[pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs']] = None,
                 list_managed_instances_results: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_ports: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input['InstanceGroupManagerParamsArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_policies: Optional[pulumi.Input['InstanceGroupManagerResourcePoliciesArgs']] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 standby_policy: Optional[pulumi.Input['InstanceGroupManagerStandbyPolicyArgs']] = None,
                 stateful_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]]] = None,
                 stateful_external_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]]] = None,
                 stateful_internal_ips: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatusArgs']]]] = None,
                 target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_stopped_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_suspended_size: Optional[pulumi.Input[_builtins.int]] = None,
                 update_policy: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyArgs']] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]]] = None,
                 wait_for_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_instances_status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceGroupManager resources.
        :param pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs'] all_instances_config: Properties to set on all instances in the group. After setting
               allInstancesConfig on the group, you must update the group's instances to
               apply the configuration.
        :param pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs'] auto_healing_policies: The autohealing policies for this managed instance
               group. You can specify only one value. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances#monitoring_groups).
        :param pulumi.Input[_builtins.str] base_instance_name: The base instance name to use for
               instances in this group. The value must be a valid
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) name. Supported characters
               are lowercase letters, numbers, and hyphens (-). Instances are named by
               appending a hyphen and a random four-character string to the base instance
               name.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional textual description of the instance
               group manager.
        :param pulumi.Input[_builtins.str] fingerprint: The fingerprint of the instance group manager.
        :param pulumi.Input[_builtins.str] instance_group: The full URL of the instance group created by the manager.
        :param pulumi.Input[_builtins.int] instance_group_manager_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs'] instance_lifecycle_policy: The instance lifecycle policy for this managed instance group.
        :param pulumi.Input[_builtins.str] list_managed_instances_results: Pagination behavior of the `listManagedInstances` API
               method for this managed instance group. Valid values are: `PAGELESS`, `PAGINATED`.
               If `PAGELESS` (default), Pagination is disabled for the group's `listManagedInstances` API method.
               `maxResults` and `pageToken` query parameters are ignored and all instances are returned in a single
               response. If `PAGINATED`, pagination is enabled, `maxResults` and `pageToken` query parameters are
               respected.
        :param pulumi.Input[_builtins.str] name: The name of the instance group manager. Must be 1-63
               characters long and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Supported characters
               include lowercase letters, numbers, and hyphens.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]] named_ports: The named port configuration. See the section below
               for details on configuration.
        :param pulumi.Input['InstanceGroupManagerParamsArgs'] params: Input only additional params for instance group manager creation. Structure is documented below. For more information, see [API](https://cloud.google.com/compute/docs/reference/rest/beta/instanceGroupManagers/insert).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['InstanceGroupManagerResourcePoliciesArgs'] resource_policies: Resource policies for this managed instance group. Structure is documented below.
               
               - - -
        :param pulumi.Input[_builtins.str] self_link: The URL of the created resource.
        :param pulumi.Input['InstanceGroupManagerStandbyPolicyArgs'] standby_policy: The standby policy for stopped and suspended instances. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/suspended-and-stopped-vms-in-mig).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]] stateful_disks: Disks created on the instances that will be preserved on instance delete, update, etc. Structure is documented below. For more information see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/configuring-stateful-disks-in-migs).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]] stateful_external_ips: External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]] stateful_internal_ips: Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatusArgs']]] statuses: The status of this managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_pools: The full URL of all target pools to which new
               instances in the group are added. Updating the target pools attribute does
               not affect existing instances.
        :param pulumi.Input[_builtins.int] target_size: The target number of running instances for this managed instance group. This value should always be explicitly set
               unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
        :param pulumi.Input[_builtins.int] target_stopped_size: The target number of stopped instances for this managed instance group.
        :param pulumi.Input[_builtins.int] target_suspended_size: The target number of suspended instances for this managed instance group.
        :param pulumi.Input['InstanceGroupManagerUpdatePolicyArgs'] update_policy: The update policy for this managed instance group. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/updating-managed-instance-groups) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagers/patch).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]] versions: Application versions managed by this instance group. Each
               version deals with a specific instance template, allowing canary release scenarios.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] wait_for_instances: Whether to wait for all instances to be created/updated before
               returning. Note that if this is set to true and the operation does not succeed, this provider will
               continue trying until it times out.
        :param pulumi.Input[_builtins.str] wait_for_instances_status: When used with `wait_for_instances` it specifies the status to wait for.
               When `STABLE` is specified this resource will wait until the instances are stable before returning. When `UPDATED` is
               set, it will wait for the version target to be reached and any per instance configs to be effective as well as all
               instances to be stable before returning. The possible values are `STABLE` and `UPDATED`
        :param pulumi.Input[_builtins.str] zone: The zone that instances in this group should be created
               in.
               
               - - -
        """
        if all_instances_config is not None:
            pulumi.set(__self__, "all_instances_config", all_instances_config)
        if auto_healing_policies is not None:
            pulumi.set(__self__, "auto_healing_policies", auto_healing_policies)
        if base_instance_name is not None:
            pulumi.set(__self__, "base_instance_name", base_instance_name)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if instance_group is not None:
            pulumi.set(__self__, "instance_group", instance_group)
        if instance_group_manager_id is not None:
            pulumi.set(__self__, "instance_group_manager_id", instance_group_manager_id)
        if instance_lifecycle_policy is not None:
            pulumi.set(__self__, "instance_lifecycle_policy", instance_lifecycle_policy)
        if list_managed_instances_results is not None:
            pulumi.set(__self__, "list_managed_instances_results", list_managed_instances_results)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if named_ports is not None:
            pulumi.set(__self__, "named_ports", named_ports)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if standby_policy is not None:
            pulumi.set(__self__, "standby_policy", standby_policy)
        if stateful_disks is not None:
            pulumi.set(__self__, "stateful_disks", stateful_disks)
        if stateful_external_ips is not None:
            pulumi.set(__self__, "stateful_external_ips", stateful_external_ips)
        if stateful_internal_ips is not None:
            pulumi.set(__self__, "stateful_internal_ips", stateful_internal_ips)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if target_pools is not None:
            pulumi.set(__self__, "target_pools", target_pools)
        if target_size is not None:
            pulumi.set(__self__, "target_size", target_size)
        if target_stopped_size is not None:
            pulumi.set(__self__, "target_stopped_size", target_stopped_size)
        if target_suspended_size is not None:
            pulumi.set(__self__, "target_suspended_size", target_suspended_size)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)
        if wait_for_instances is not None:
            pulumi.set(__self__, "wait_for_instances", wait_for_instances)
        if wait_for_instances_status is not None:
            pulumi.set(__self__, "wait_for_instances_status", wait_for_instances_status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="allInstancesConfig")
    def all_instances_config(self) -> Optional[pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs']]:
        """
        Properties to set on all instances in the group. After setting
        allInstancesConfig on the group, you must update the group's instances to
        apply the configuration.
        """
        return pulumi.get(self, "all_instances_config")

    @all_instances_config.setter
    def all_instances_config(self, value: Optional[pulumi.Input['InstanceGroupManagerAllInstancesConfigArgs']]):
        pulumi.set(self, "all_instances_config", value)

    @_builtins.property
    @pulumi.getter(name="autoHealingPolicies")
    def auto_healing_policies(self) -> Optional[pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs']]:
        """
        The autohealing policies for this managed instance
        group. You can specify only one value. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances#monitoring_groups).
        """
        return pulumi.get(self, "auto_healing_policies")

    @auto_healing_policies.setter
    def auto_healing_policies(self, value: Optional[pulumi.Input['InstanceGroupManagerAutoHealingPoliciesArgs']]):
        pulumi.set(self, "auto_healing_policies", value)

    @_builtins.property
    @pulumi.getter(name="baseInstanceName")
    def base_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base instance name to use for
        instances in this group. The value must be a valid
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) name. Supported characters
        are lowercase letters, numbers, and hyphens (-). Instances are named by
        appending a hyphen and a random four-character string to the base instance
        name.
        """
        return pulumi.get(self, "base_instance_name")

    @base_instance_name.setter
    def base_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional textual description of the instance
        group manager.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fingerprint of the instance group manager.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroup")
    def instance_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full URL of the instance group created by the manager.
        """
        return pulumi.get(self, "instance_group")

    @instance_group.setter
    def instance_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_group", value)

    @_builtins.property
    @pulumi.getter(name="instanceGroupManagerId")
    def instance_group_manager_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "instance_group_manager_id")

    @instance_group_manager_id.setter
    def instance_group_manager_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_group_manager_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceLifecyclePolicy")
    def instance_lifecycle_policy(self) -> Optional[pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs']]:
        """
        The instance lifecycle policy for this managed instance group.
        """
        return pulumi.get(self, "instance_lifecycle_policy")

    @instance_lifecycle_policy.setter
    def instance_lifecycle_policy(self, value: Optional[pulumi.Input['InstanceGroupManagerInstanceLifecyclePolicyArgs']]):
        pulumi.set(self, "instance_lifecycle_policy", value)

    @_builtins.property
    @pulumi.getter(name="listManagedInstancesResults")
    def list_managed_instances_results(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pagination behavior of the `listManagedInstances` API
        method for this managed instance group. Valid values are: `PAGELESS`, `PAGINATED`.
        If `PAGELESS` (default), Pagination is disabled for the group's `listManagedInstances` API method.
        `maxResults` and `pageToken` query parameters are ignored and all instances are returned in a single
        response. If `PAGINATED`, pagination is enabled, `maxResults` and `pageToken` query parameters are
        respected.
        """
        return pulumi.get(self, "list_managed_instances_results")

    @list_managed_instances_results.setter
    def list_managed_instances_results(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "list_managed_instances_results", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance group manager. Must be 1-63
        characters long and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Supported characters
        include lowercase letters, numbers, and hyphens.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namedPorts")
    def named_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]]]:
        """
        The named port configuration. See the section below
        for details on configuration.
        """
        return pulumi.get(self, "named_ports")

    @named_ports.setter
    def named_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerNamedPortArgs']]]]):
        pulumi.set(self, "named_ports", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['InstanceGroupManagerParamsArgs']]:
        """
        Input only additional params for instance group manager creation. Structure is documented below. For more information, see [API](https://cloud.google.com/compute/docs/reference/rest/beta/instanceGroupManagers/insert).
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['InstanceGroupManagerParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input['InstanceGroupManagerResourcePoliciesArgs']]:
        """
        Resource policies for this managed instance group. Structure is documented below.

        - - -
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input['InstanceGroupManagerResourcePoliciesArgs']]):
        pulumi.set(self, "resource_policies", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="standbyPolicy")
    def standby_policy(self) -> Optional[pulumi.Input['InstanceGroupManagerStandbyPolicyArgs']]:
        """
        The standby policy for stopped and suspended instances. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/suspended-and-stopped-vms-in-mig).
        """
        return pulumi.get(self, "standby_policy")

    @standby_policy.setter
    def standby_policy(self, value: Optional[pulumi.Input['InstanceGroupManagerStandbyPolicyArgs']]):
        pulumi.set(self, "standby_policy", value)

    @_builtins.property
    @pulumi.getter(name="statefulDisks")
    def stateful_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]]]:
        """
        Disks created on the instances that will be preserved on instance delete, update, etc. Structure is documented below. For more information see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/configuring-stateful-disks-in-migs).
        """
        return pulumi.get(self, "stateful_disks")

    @stateful_disks.setter
    def stateful_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulDiskArgs']]]]):
        pulumi.set(self, "stateful_disks", value)

    @_builtins.property
    @pulumi.getter(name="statefulExternalIps")
    def stateful_external_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]]]:
        """
        External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        """
        return pulumi.get(self, "stateful_external_ips")

    @stateful_external_ips.setter
    def stateful_external_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulExternalIpArgs']]]]):
        pulumi.set(self, "stateful_external_ips", value)

    @_builtins.property
    @pulumi.getter(name="statefulInternalIps")
    def stateful_internal_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]]]:
        """
        Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        """
        return pulumi.get(self, "stateful_internal_ips")

    @stateful_internal_ips.setter
    def stateful_internal_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatefulInternalIpArgs']]]]):
        pulumi.set(self, "stateful_internal_ips", value)

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatusArgs']]]]:
        """
        The status of this managed instance group.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @_builtins.property
    @pulumi.getter(name="targetPools")
    def target_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The full URL of all target pools to which new
        instances in the group are added. Updating the target pools attribute does
        not affect existing instances.
        """
        return pulumi.get(self, "target_pools")

    @target_pools.setter
    def target_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_pools", value)

    @_builtins.property
    @pulumi.getter(name="targetSize")
    def target_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The target number of running instances for this managed instance group. This value should always be explicitly set
        unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
        """
        return pulumi.get(self, "target_size")

    @target_size.setter
    def target_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_size", value)

    @_builtins.property
    @pulumi.getter(name="targetStoppedSize")
    def target_stopped_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The target number of stopped instances for this managed instance group.
        """
        return pulumi.get(self, "target_stopped_size")

    @target_stopped_size.setter
    def target_stopped_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_stopped_size", value)

    @_builtins.property
    @pulumi.getter(name="targetSuspendedSize")
    def target_suspended_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The target number of suspended instances for this managed instance group.
        """
        return pulumi.get(self, "target_suspended_size")

    @target_suspended_size.setter
    def target_suspended_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "target_suspended_size", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyArgs']]:
        """
        The update policy for this managed instance group. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/updating-managed-instance-groups) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagers/patch).
        """
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['InstanceGroupManagerUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]]]:
        """
        Application versions managed by this instance group. Each
        version deals with a specific instance template, allowing canary release scenarios.
        Structure is documented below.
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupManagerVersionArgs']]]]):
        pulumi.set(self, "versions", value)

    @_builtins.property
    @pulumi.getter(name="waitForInstances")
    def wait_for_instances(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to wait for all instances to be created/updated before
        returning. Note that if this is set to true and the operation does not succeed, this provider will
        continue trying until it times out.
        """
        return pulumi.get(self, "wait_for_instances")

    @wait_for_instances.setter
    def wait_for_instances(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_instances", value)

    @_builtins.property
    @pulumi.getter(name="waitForInstancesStatus")
    def wait_for_instances_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When used with `wait_for_instances` it specifies the status to wait for.
        When `STABLE` is specified this resource will wait until the instances are stable before returning. When `UPDATED` is
        set, it will wait for the version target to be reached and any per instance configs to be effective as well as all
        instances to be stable before returning. The possible values are `STABLE` and `UPDATED`
        """
        return pulumi.get(self, "wait_for_instances_status")

    @wait_for_instances_status.setter
    def wait_for_instances_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "wait_for_instances_status", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone that instances in this group should be created
        in.

        - - -
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/instanceGroupManager:InstanceGroupManager")
class InstanceGroupManager(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_instances_config: Optional[pulumi.Input[Union['InstanceGroupManagerAllInstancesConfigArgs', 'InstanceGroupManagerAllInstancesConfigArgsDict']]] = None,
                 auto_healing_policies: Optional[pulumi.Input[Union['InstanceGroupManagerAutoHealingPoliciesArgs', 'InstanceGroupManagerAutoHealingPoliciesArgsDict']]] = None,
                 base_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_lifecycle_policy: Optional[pulumi.Input[Union['InstanceGroupManagerInstanceLifecyclePolicyArgs', 'InstanceGroupManagerInstanceLifecyclePolicyArgsDict']]] = None,
                 list_managed_instances_results: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerNamedPortArgs', 'InstanceGroupManagerNamedPortArgsDict']]]]] = None,
                 params: Optional[pulumi.Input[Union['InstanceGroupManagerParamsArgs', 'InstanceGroupManagerParamsArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_policies: Optional[pulumi.Input[Union['InstanceGroupManagerResourcePoliciesArgs', 'InstanceGroupManagerResourcePoliciesArgsDict']]] = None,
                 standby_policy: Optional[pulumi.Input[Union['InstanceGroupManagerStandbyPolicyArgs', 'InstanceGroupManagerStandbyPolicyArgsDict']]] = None,
                 stateful_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulDiskArgs', 'InstanceGroupManagerStatefulDiskArgsDict']]]]] = None,
                 stateful_external_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulExternalIpArgs', 'InstanceGroupManagerStatefulExternalIpArgsDict']]]]] = None,
                 stateful_internal_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulInternalIpArgs', 'InstanceGroupManagerStatefulInternalIpArgsDict']]]]] = None,
                 target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_stopped_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_suspended_size: Optional[pulumi.Input[_builtins.int]] = None,
                 update_policy: Optional[pulumi.Input[Union['InstanceGroupManagerUpdatePolicyArgs', 'InstanceGroupManagerUpdatePolicyArgsDict']]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerVersionArgs', 'InstanceGroupManagerVersionArgsDict']]]]] = None,
                 wait_for_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_instances_status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The Google Compute Engine Instance Group Manager API creates and manages pools
        of homogeneous Compute Engine virtual machine instances from a common instance
        template. For more information, see [the official documentation](https://cloud.google.com/compute/docs/instance-groups/manager)
        and [API](https://cloud.google.com/compute/docs/reference/latest/instanceGroupManagers)

        > **Note:** Use [compute.RegionInstanceGroupManager](https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html) to create a regional (multi-zone) instance group manager.

        ## Example Usage

        ### With Top Level Instance Template (`Google` Provider)

        ```python
        import pulumi
        import pulumi_gcp as gcp

        autohealing = gcp.compute.HealthCheck("autohealing",
            name="autohealing-health-check",
            check_interval_sec=5,
            timeout_sec=5,
            healthy_threshold=2,
            unhealthy_threshold=10,
            http_health_check={
                "request_path": "/healthz",
                "port": 8080,
            })
        appserver = gcp.compute.InstanceGroupManager("appserver",
            name="appserver-igm",
            base_instance_name="app",
            zone="us-central1-a",
            versions=[{
                "instance_template": appserver_google_compute_instance_template["selfLinkUnique"],
            }],
            all_instances_config={
                "metadata": {
                    "metadata_key": "metadata_value",
                },
                "labels": {
                    "label_key": "label_value",
                },
            },
            target_pools=[appserver_google_compute_target_pool["id"]],
            target_size=2,
            named_ports=[{
                "name": "customhttp",
                "port": 8888,
            }],
            auto_healing_policies={
                "health_check": autohealing.id,
                "initial_delay_sec": 300,
            })
        ```

        ### With Multiple Versions (`Google-Beta` Provider)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        appserver = gcp.compute.InstanceGroupManager("appserver",
            name="appserver-igm",
            base_instance_name="app",
            zone="us-central1-a",
            target_size=5,
            versions=[
                {
                    "name": "appserver",
                    "instance_template": appserver_google_compute_instance_template["selfLinkUnique"],
                },
                {
                    "name": "appserver-canary",
                    "instance_template": appserver_canary["selfLinkUnique"],
                    "target_size": {
                        "fixed": 1,
                    },
                },
            ])
        ```

        ### With Standby Policy (`Google` Provider)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        igm_sr = gcp.compute.InstanceGroupManager("igm-sr",
            name="tf-sr-igm",
            base_instance_name="tf-sr-igm-instance",
            zone="us-central1-a",
            target_size=5,
            versions=[{
                "instance_template": sr_igm["selfLink"],
                "name": "primary",
            }],
            standby_policy={
                "initial_delay_sec": 30,
                "mode": "MANUAL",
            },
            target_suspended_size=2,
            target_stopped_size=1)
        ```

        ### With Resource Policies (`Google` Provider)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        workload_policy = gcp.compute.ResourcePolicy("workload_policy",
            name="tf-test-gce-policy",
            region="us-central1",
            workload_policy={
                "type": "HIGH_THROUGHPUT",
            })
        igm_basic = gcp.compute.InstanceTemplate("igm-basic",
            name="igm-instance-template",
            machine_type="a4-highgpu-8g",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[{
                "source_image": my_image.self_link,
                "auto_delete": True,
                "boot": True,
                "disk_type": "hyperdisk-balanced",
            }],
            network_interfaces=[{
                "network": "default",
            }],
            service_account={
                "scopes": [
                    "userinfo-email",
                    "compute-ro",
                    "storage-ro",
                ],
            })
        igm_workload_policy = gcp.compute.InstanceGroupManager("igm-workload-policy",
            description="Terraform test instance group manager",
            name="igm-basic-workload-policy",
            versions=[{
                "name": "prod",
                "instance_template": igm_basic.self_link,
            }],
            base_instance_name="tf-test-igm-no-tp",
            zone="us-central1-b",
            target_size=0,
            resource_policies={
                "workload_policy": workload_policy.self_link,
            })
        ```

        ## Import

        Instance group managers can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, instance group managers can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceGroupManagerAllInstancesConfigArgs', 'InstanceGroupManagerAllInstancesConfigArgsDict']] all_instances_config: Properties to set on all instances in the group. After setting
               allInstancesConfig on the group, you must update the group's instances to
               apply the configuration.
        :param pulumi.Input[Union['InstanceGroupManagerAutoHealingPoliciesArgs', 'InstanceGroupManagerAutoHealingPoliciesArgsDict']] auto_healing_policies: The autohealing policies for this managed instance
               group. You can specify only one value. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances#monitoring_groups).
        :param pulumi.Input[_builtins.str] base_instance_name: The base instance name to use for
               instances in this group. The value must be a valid
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) name. Supported characters
               are lowercase letters, numbers, and hyphens (-). Instances are named by
               appending a hyphen and a random four-character string to the base instance
               name.
        :param pulumi.Input[_builtins.str] description: An optional textual description of the instance
               group manager.
        :param pulumi.Input[Union['InstanceGroupManagerInstanceLifecyclePolicyArgs', 'InstanceGroupManagerInstanceLifecyclePolicyArgsDict']] instance_lifecycle_policy: The instance lifecycle policy for this managed instance group.
        :param pulumi.Input[_builtins.str] list_managed_instances_results: Pagination behavior of the `listManagedInstances` API
               method for this managed instance group. Valid values are: `PAGELESS`, `PAGINATED`.
               If `PAGELESS` (default), Pagination is disabled for the group's `listManagedInstances` API method.
               `maxResults` and `pageToken` query parameters are ignored and all instances are returned in a single
               response. If `PAGINATED`, pagination is enabled, `maxResults` and `pageToken` query parameters are
               respected.
        :param pulumi.Input[_builtins.str] name: The name of the instance group manager. Must be 1-63
               characters long and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Supported characters
               include lowercase letters, numbers, and hyphens.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerNamedPortArgs', 'InstanceGroupManagerNamedPortArgsDict']]]] named_ports: The named port configuration. See the section below
               for details on configuration.
        :param pulumi.Input[Union['InstanceGroupManagerParamsArgs', 'InstanceGroupManagerParamsArgsDict']] params: Input only additional params for instance group manager creation. Structure is documented below. For more information, see [API](https://cloud.google.com/compute/docs/reference/rest/beta/instanceGroupManagers/insert).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['InstanceGroupManagerResourcePoliciesArgs', 'InstanceGroupManagerResourcePoliciesArgsDict']] resource_policies: Resource policies for this managed instance group. Structure is documented below.
               
               - - -
        :param pulumi.Input[Union['InstanceGroupManagerStandbyPolicyArgs', 'InstanceGroupManagerStandbyPolicyArgsDict']] standby_policy: The standby policy for stopped and suspended instances. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/suspended-and-stopped-vms-in-mig).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulDiskArgs', 'InstanceGroupManagerStatefulDiskArgsDict']]]] stateful_disks: Disks created on the instances that will be preserved on instance delete, update, etc. Structure is documented below. For more information see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/configuring-stateful-disks-in-migs).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulExternalIpArgs', 'InstanceGroupManagerStatefulExternalIpArgsDict']]]] stateful_external_ips: External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulInternalIpArgs', 'InstanceGroupManagerStatefulInternalIpArgsDict']]]] stateful_internal_ips: Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_pools: The full URL of all target pools to which new
               instances in the group are added. Updating the target pools attribute does
               not affect existing instances.
        :param pulumi.Input[_builtins.int] target_size: The target number of running instances for this managed instance group. This value should always be explicitly set
               unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
        :param pulumi.Input[_builtins.int] target_stopped_size: The target number of stopped instances for this managed instance group.
        :param pulumi.Input[_builtins.int] target_suspended_size: The target number of suspended instances for this managed instance group.
        :param pulumi.Input[Union['InstanceGroupManagerUpdatePolicyArgs', 'InstanceGroupManagerUpdatePolicyArgsDict']] update_policy: The update policy for this managed instance group. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/updating-managed-instance-groups) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagers/patch).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerVersionArgs', 'InstanceGroupManagerVersionArgsDict']]]] versions: Application versions managed by this instance group. Each
               version deals with a specific instance template, allowing canary release scenarios.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] wait_for_instances: Whether to wait for all instances to be created/updated before
               returning. Note that if this is set to true and the operation does not succeed, this provider will
               continue trying until it times out.
        :param pulumi.Input[_builtins.str] wait_for_instances_status: When used with `wait_for_instances` it specifies the status to wait for.
               When `STABLE` is specified this resource will wait until the instances are stable before returning. When `UPDATED` is
               set, it will wait for the version target to be reached and any per instance configs to be effective as well as all
               instances to be stable before returning. The possible values are `STABLE` and `UPDATED`
        :param pulumi.Input[_builtins.str] zone: The zone that instances in this group should be created
               in.
               
               - - -
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceGroupManagerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Google Compute Engine Instance Group Manager API creates and manages pools
        of homogeneous Compute Engine virtual machine instances from a common instance
        template. For more information, see [the official documentation](https://cloud.google.com/compute/docs/instance-groups/manager)
        and [API](https://cloud.google.com/compute/docs/reference/latest/instanceGroupManagers)

        > **Note:** Use [compute.RegionInstanceGroupManager](https://www.terraform.io/docs/providers/google/r/compute_region_instance_group_manager.html) to create a regional (multi-zone) instance group manager.

        ## Example Usage

        ### With Top Level Instance Template (`Google` Provider)

        ```python
        import pulumi
        import pulumi_gcp as gcp

        autohealing = gcp.compute.HealthCheck("autohealing",
            name="autohealing-health-check",
            check_interval_sec=5,
            timeout_sec=5,
            healthy_threshold=2,
            unhealthy_threshold=10,
            http_health_check={
                "request_path": "/healthz",
                "port": 8080,
            })
        appserver = gcp.compute.InstanceGroupManager("appserver",
            name="appserver-igm",
            base_instance_name="app",
            zone="us-central1-a",
            versions=[{
                "instance_template": appserver_google_compute_instance_template["selfLinkUnique"],
            }],
            all_instances_config={
                "metadata": {
                    "metadata_key": "metadata_value",
                },
                "labels": {
                    "label_key": "label_value",
                },
            },
            target_pools=[appserver_google_compute_target_pool["id"]],
            target_size=2,
            named_ports=[{
                "name": "customhttp",
                "port": 8888,
            }],
            auto_healing_policies={
                "health_check": autohealing.id,
                "initial_delay_sec": 300,
            })
        ```

        ### With Multiple Versions (`Google-Beta` Provider)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        appserver = gcp.compute.InstanceGroupManager("appserver",
            name="appserver-igm",
            base_instance_name="app",
            zone="us-central1-a",
            target_size=5,
            versions=[
                {
                    "name": "appserver",
                    "instance_template": appserver_google_compute_instance_template["selfLinkUnique"],
                },
                {
                    "name": "appserver-canary",
                    "instance_template": appserver_canary["selfLinkUnique"],
                    "target_size": {
                        "fixed": 1,
                    },
                },
            ])
        ```

        ### With Standby Policy (`Google` Provider)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        igm_sr = gcp.compute.InstanceGroupManager("igm-sr",
            name="tf-sr-igm",
            base_instance_name="tf-sr-igm-instance",
            zone="us-central1-a",
            target_size=5,
            versions=[{
                "instance_template": sr_igm["selfLink"],
                "name": "primary",
            }],
            standby_policy={
                "initial_delay_sec": 30,
                "mode": "MANUAL",
            },
            target_suspended_size=2,
            target_stopped_size=1)
        ```

        ### With Resource Policies (`Google` Provider)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        workload_policy = gcp.compute.ResourcePolicy("workload_policy",
            name="tf-test-gce-policy",
            region="us-central1",
            workload_policy={
                "type": "HIGH_THROUGHPUT",
            })
        igm_basic = gcp.compute.InstanceTemplate("igm-basic",
            name="igm-instance-template",
            machine_type="a4-highgpu-8g",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[{
                "source_image": my_image.self_link,
                "auto_delete": True,
                "boot": True,
                "disk_type": "hyperdisk-balanced",
            }],
            network_interfaces=[{
                "network": "default",
            }],
            service_account={
                "scopes": [
                    "userinfo-email",
                    "compute-ro",
                    "storage-ro",
                ],
            })
        igm_workload_policy = gcp.compute.InstanceGroupManager("igm-workload-policy",
            description="Terraform test instance group manager",
            name="igm-basic-workload-policy",
            versions=[{
                "name": "prod",
                "instance_template": igm_basic.self_link,
            }],
            base_instance_name="tf-test-igm-no-tp",
            zone="us-central1-b",
            target_size=0,
            resource_policies={
                "workload_policy": workload_policy.self_link,
            })
        ```

        ## Import

        Instance group managers can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, instance group managers can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default projects/{{project}}/zones/{{zone}}/instanceGroupManagers/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instanceGroupManager:InstanceGroupManager default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceGroupManagerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceGroupManagerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 all_instances_config: Optional[pulumi.Input[Union['InstanceGroupManagerAllInstancesConfigArgs', 'InstanceGroupManagerAllInstancesConfigArgsDict']]] = None,
                 auto_healing_policies: Optional[pulumi.Input[Union['InstanceGroupManagerAutoHealingPoliciesArgs', 'InstanceGroupManagerAutoHealingPoliciesArgsDict']]] = None,
                 base_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_lifecycle_policy: Optional[pulumi.Input[Union['InstanceGroupManagerInstanceLifecyclePolicyArgs', 'InstanceGroupManagerInstanceLifecyclePolicyArgsDict']]] = None,
                 list_managed_instances_results: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 named_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerNamedPortArgs', 'InstanceGroupManagerNamedPortArgsDict']]]]] = None,
                 params: Optional[pulumi.Input[Union['InstanceGroupManagerParamsArgs', 'InstanceGroupManagerParamsArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_policies: Optional[pulumi.Input[Union['InstanceGroupManagerResourcePoliciesArgs', 'InstanceGroupManagerResourcePoliciesArgsDict']]] = None,
                 standby_policy: Optional[pulumi.Input[Union['InstanceGroupManagerStandbyPolicyArgs', 'InstanceGroupManagerStandbyPolicyArgsDict']]] = None,
                 stateful_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulDiskArgs', 'InstanceGroupManagerStatefulDiskArgsDict']]]]] = None,
                 stateful_external_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulExternalIpArgs', 'InstanceGroupManagerStatefulExternalIpArgsDict']]]]] = None,
                 stateful_internal_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulInternalIpArgs', 'InstanceGroupManagerStatefulInternalIpArgsDict']]]]] = None,
                 target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_stopped_size: Optional[pulumi.Input[_builtins.int]] = None,
                 target_suspended_size: Optional[pulumi.Input[_builtins.int]] = None,
                 update_policy: Optional[pulumi.Input[Union['InstanceGroupManagerUpdatePolicyArgs', 'InstanceGroupManagerUpdatePolicyArgsDict']]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerVersionArgs', 'InstanceGroupManagerVersionArgsDict']]]]] = None,
                 wait_for_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 wait_for_instances_status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceGroupManagerArgs.__new__(InstanceGroupManagerArgs)

            __props__.__dict__["all_instances_config"] = all_instances_config
            __props__.__dict__["auto_healing_policies"] = auto_healing_policies
            if base_instance_name is None and not opts.urn:
                raise TypeError("Missing required property 'base_instance_name'")
            __props__.__dict__["base_instance_name"] = base_instance_name
            __props__.__dict__["description"] = description
            __props__.__dict__["instance_lifecycle_policy"] = instance_lifecycle_policy
            __props__.__dict__["list_managed_instances_results"] = list_managed_instances_results
            __props__.__dict__["name"] = name
            __props__.__dict__["named_ports"] = named_ports
            __props__.__dict__["params"] = params
            __props__.__dict__["project"] = project
            __props__.__dict__["resource_policies"] = resource_policies
            __props__.__dict__["standby_policy"] = standby_policy
            __props__.__dict__["stateful_disks"] = stateful_disks
            __props__.__dict__["stateful_external_ips"] = stateful_external_ips
            __props__.__dict__["stateful_internal_ips"] = stateful_internal_ips
            __props__.__dict__["target_pools"] = target_pools
            __props__.__dict__["target_size"] = target_size
            __props__.__dict__["target_stopped_size"] = target_stopped_size
            __props__.__dict__["target_suspended_size"] = target_suspended_size
            __props__.__dict__["update_policy"] = update_policy
            if versions is None and not opts.urn:
                raise TypeError("Missing required property 'versions'")
            __props__.__dict__["versions"] = versions
            __props__.__dict__["wait_for_instances"] = wait_for_instances
            __props__.__dict__["wait_for_instances_status"] = wait_for_instances_status
            __props__.__dict__["zone"] = zone
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["instance_group"] = None
            __props__.__dict__["instance_group_manager_id"] = None
            __props__.__dict__["operation"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["statuses"] = None
        super(InstanceGroupManager, __self__).__init__(
            'gcp:compute/instanceGroupManager:InstanceGroupManager',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_instances_config: Optional[pulumi.Input[Union['InstanceGroupManagerAllInstancesConfigArgs', 'InstanceGroupManagerAllInstancesConfigArgsDict']]] = None,
            auto_healing_policies: Optional[pulumi.Input[Union['InstanceGroupManagerAutoHealingPoliciesArgs', 'InstanceGroupManagerAutoHealingPoliciesArgsDict']]] = None,
            base_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            instance_group: Optional[pulumi.Input[_builtins.str]] = None,
            instance_group_manager_id: Optional[pulumi.Input[_builtins.int]] = None,
            instance_lifecycle_policy: Optional[pulumi.Input[Union['InstanceGroupManagerInstanceLifecyclePolicyArgs', 'InstanceGroupManagerInstanceLifecyclePolicyArgsDict']]] = None,
            list_managed_instances_results: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            named_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerNamedPortArgs', 'InstanceGroupManagerNamedPortArgsDict']]]]] = None,
            operation: Optional[pulumi.Input[_builtins.str]] = None,
            params: Optional[pulumi.Input[Union['InstanceGroupManagerParamsArgs', 'InstanceGroupManagerParamsArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            resource_policies: Optional[pulumi.Input[Union['InstanceGroupManagerResourcePoliciesArgs', 'InstanceGroupManagerResourcePoliciesArgsDict']]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            standby_policy: Optional[pulumi.Input[Union['InstanceGroupManagerStandbyPolicyArgs', 'InstanceGroupManagerStandbyPolicyArgsDict']]] = None,
            stateful_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulDiskArgs', 'InstanceGroupManagerStatefulDiskArgsDict']]]]] = None,
            stateful_external_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulExternalIpArgs', 'InstanceGroupManagerStatefulExternalIpArgsDict']]]]] = None,
            stateful_internal_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulInternalIpArgs', 'InstanceGroupManagerStatefulInternalIpArgsDict']]]]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatusArgs', 'InstanceGroupManagerStatusArgsDict']]]]] = None,
            target_pools: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_size: Optional[pulumi.Input[_builtins.int]] = None,
            target_stopped_size: Optional[pulumi.Input[_builtins.int]] = None,
            target_suspended_size: Optional[pulumi.Input[_builtins.int]] = None,
            update_policy: Optional[pulumi.Input[Union['InstanceGroupManagerUpdatePolicyArgs', 'InstanceGroupManagerUpdatePolicyArgsDict']]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerVersionArgs', 'InstanceGroupManagerVersionArgsDict']]]]] = None,
            wait_for_instances: Optional[pulumi.Input[_builtins.bool]] = None,
            wait_for_instances_status: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceGroupManager':
        """
        Get an existing InstanceGroupManager resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceGroupManagerAllInstancesConfigArgs', 'InstanceGroupManagerAllInstancesConfigArgsDict']] all_instances_config: Properties to set on all instances in the group. After setting
               allInstancesConfig on the group, you must update the group's instances to
               apply the configuration.
        :param pulumi.Input[Union['InstanceGroupManagerAutoHealingPoliciesArgs', 'InstanceGroupManagerAutoHealingPoliciesArgsDict']] auto_healing_policies: The autohealing policies for this managed instance
               group. You can specify only one value. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances#monitoring_groups).
        :param pulumi.Input[_builtins.str] base_instance_name: The base instance name to use for
               instances in this group. The value must be a valid
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) name. Supported characters
               are lowercase letters, numbers, and hyphens (-). Instances are named by
               appending a hyphen and a random four-character string to the base instance
               name.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional textual description of the instance
               group manager.
        :param pulumi.Input[_builtins.str] fingerprint: The fingerprint of the instance group manager.
        :param pulumi.Input[_builtins.str] instance_group: The full URL of the instance group created by the manager.
        :param pulumi.Input[_builtins.int] instance_group_manager_id: The unique identifier number for the resource. This identifier is defined by the server.
        :param pulumi.Input[Union['InstanceGroupManagerInstanceLifecyclePolicyArgs', 'InstanceGroupManagerInstanceLifecyclePolicyArgsDict']] instance_lifecycle_policy: The instance lifecycle policy for this managed instance group.
        :param pulumi.Input[_builtins.str] list_managed_instances_results: Pagination behavior of the `listManagedInstances` API
               method for this managed instance group. Valid values are: `PAGELESS`, `PAGINATED`.
               If `PAGELESS` (default), Pagination is disabled for the group's `listManagedInstances` API method.
               `maxResults` and `pageToken` query parameters are ignored and all instances are returned in a single
               response. If `PAGINATED`, pagination is enabled, `maxResults` and `pageToken` query parameters are
               respected.
        :param pulumi.Input[_builtins.str] name: The name of the instance group manager. Must be 1-63
               characters long and comply with
               [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Supported characters
               include lowercase letters, numbers, and hyphens.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerNamedPortArgs', 'InstanceGroupManagerNamedPortArgsDict']]]] named_ports: The named port configuration. See the section below
               for details on configuration.
        :param pulumi.Input[Union['InstanceGroupManagerParamsArgs', 'InstanceGroupManagerParamsArgsDict']] params: Input only additional params for instance group manager creation. Structure is documented below. For more information, see [API](https://cloud.google.com/compute/docs/reference/rest/beta/instanceGroupManagers/insert).
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['InstanceGroupManagerResourcePoliciesArgs', 'InstanceGroupManagerResourcePoliciesArgsDict']] resource_policies: Resource policies for this managed instance group. Structure is documented below.
               
               - - -
        :param pulumi.Input[_builtins.str] self_link: The URL of the created resource.
        :param pulumi.Input[Union['InstanceGroupManagerStandbyPolicyArgs', 'InstanceGroupManagerStandbyPolicyArgsDict']] standby_policy: The standby policy for stopped and suspended instances. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/suspended-and-stopped-vms-in-mig).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulDiskArgs', 'InstanceGroupManagerStatefulDiskArgsDict']]]] stateful_disks: Disks created on the instances that will be preserved on instance delete, update, etc. Structure is documented below. For more information see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/configuring-stateful-disks-in-migs).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulExternalIpArgs', 'InstanceGroupManagerStatefulExternalIpArgsDict']]]] stateful_external_ips: External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatefulInternalIpArgs', 'InstanceGroupManagerStatefulInternalIpArgsDict']]]] stateful_internal_ips: Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerStatusArgs', 'InstanceGroupManagerStatusArgsDict']]]] statuses: The status of this managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_pools: The full URL of all target pools to which new
               instances in the group are added. Updating the target pools attribute does
               not affect existing instances.
        :param pulumi.Input[_builtins.int] target_size: The target number of running instances for this managed instance group. This value should always be explicitly set
               unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
        :param pulumi.Input[_builtins.int] target_stopped_size: The target number of stopped instances for this managed instance group.
        :param pulumi.Input[_builtins.int] target_suspended_size: The target number of suspended instances for this managed instance group.
        :param pulumi.Input[Union['InstanceGroupManagerUpdatePolicyArgs', 'InstanceGroupManagerUpdatePolicyArgsDict']] update_policy: The update policy for this managed instance group. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/updating-managed-instance-groups) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagers/patch).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupManagerVersionArgs', 'InstanceGroupManagerVersionArgsDict']]]] versions: Application versions managed by this instance group. Each
               version deals with a specific instance template, allowing canary release scenarios.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] wait_for_instances: Whether to wait for all instances to be created/updated before
               returning. Note that if this is set to true and the operation does not succeed, this provider will
               continue trying until it times out.
        :param pulumi.Input[_builtins.str] wait_for_instances_status: When used with `wait_for_instances` it specifies the status to wait for.
               When `STABLE` is specified this resource will wait until the instances are stable before returning. When `UPDATED` is
               set, it will wait for the version target to be reached and any per instance configs to be effective as well as all
               instances to be stable before returning. The possible values are `STABLE` and `UPDATED`
        :param pulumi.Input[_builtins.str] zone: The zone that instances in this group should be created
               in.
               
               - - -
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceGroupManagerState.__new__(_InstanceGroupManagerState)

        __props__.__dict__["all_instances_config"] = all_instances_config
        __props__.__dict__["auto_healing_policies"] = auto_healing_policies
        __props__.__dict__["base_instance_name"] = base_instance_name
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["instance_group"] = instance_group
        __props__.__dict__["instance_group_manager_id"] = instance_group_manager_id
        __props__.__dict__["instance_lifecycle_policy"] = instance_lifecycle_policy
        __props__.__dict__["list_managed_instances_results"] = list_managed_instances_results
        __props__.__dict__["name"] = name
        __props__.__dict__["named_ports"] = named_ports
        __props__.__dict__["operation"] = operation
        __props__.__dict__["params"] = params
        __props__.__dict__["project"] = project
        __props__.__dict__["resource_policies"] = resource_policies
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["standby_policy"] = standby_policy
        __props__.__dict__["stateful_disks"] = stateful_disks
        __props__.__dict__["stateful_external_ips"] = stateful_external_ips
        __props__.__dict__["stateful_internal_ips"] = stateful_internal_ips
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["target_pools"] = target_pools
        __props__.__dict__["target_size"] = target_size
        __props__.__dict__["target_stopped_size"] = target_stopped_size
        __props__.__dict__["target_suspended_size"] = target_suspended_size
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["versions"] = versions
        __props__.__dict__["wait_for_instances"] = wait_for_instances
        __props__.__dict__["wait_for_instances_status"] = wait_for_instances_status
        __props__.__dict__["zone"] = zone
        return InstanceGroupManager(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allInstancesConfig")
    def all_instances_config(self) -> pulumi.Output[Optional['outputs.InstanceGroupManagerAllInstancesConfig']]:
        """
        Properties to set on all instances in the group. After setting
        allInstancesConfig on the group, you must update the group's instances to
        apply the configuration.
        """
        return pulumi.get(self, "all_instances_config")

    @_builtins.property
    @pulumi.getter(name="autoHealingPolicies")
    def auto_healing_policies(self) -> pulumi.Output[Optional['outputs.InstanceGroupManagerAutoHealingPolicies']]:
        """
        The autohealing policies for this managed instance
        group. You can specify only one value. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances#monitoring_groups).
        """
        return pulumi.get(self, "auto_healing_policies")

    @_builtins.property
    @pulumi.getter(name="baseInstanceName")
    def base_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        The base instance name to use for
        instances in this group. The value must be a valid
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt) name. Supported characters
        are lowercase letters, numbers, and hyphens (-). Instances are named by
        appending a hyphen and a random four-character string to the base instance
        name.
        """
        return pulumi.get(self, "base_instance_name")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional textual description of the instance
        group manager.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        The fingerprint of the instance group manager.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="instanceGroup")
    def instance_group(self) -> pulumi.Output[_builtins.str]:
        """
        The full URL of the instance group created by the manager.
        """
        return pulumi.get(self, "instance_group")

    @_builtins.property
    @pulumi.getter(name="instanceGroupManagerId")
    def instance_group_manager_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier number for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "instance_group_manager_id")

    @_builtins.property
    @pulumi.getter(name="instanceLifecyclePolicy")
    def instance_lifecycle_policy(self) -> pulumi.Output['outputs.InstanceGroupManagerInstanceLifecyclePolicy']:
        """
        The instance lifecycle policy for this managed instance group.
        """
        return pulumi.get(self, "instance_lifecycle_policy")

    @_builtins.property
    @pulumi.getter(name="listManagedInstancesResults")
    def list_managed_instances_results(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Pagination behavior of the `listManagedInstances` API
        method for this managed instance group. Valid values are: `PAGELESS`, `PAGINATED`.
        If `PAGELESS` (default), Pagination is disabled for the group's `listManagedInstances` API method.
        `maxResults` and `pageToken` query parameters are ignored and all instances are returned in a single
        response. If `PAGINATED`, pagination is enabled, `maxResults` and `pageToken` query parameters are
        respected.
        """
        return pulumi.get(self, "list_managed_instances_results")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the instance group manager. Must be 1-63
        characters long and comply with
        [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Supported characters
        include lowercase letters, numbers, and hyphens.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namedPorts")
    def named_ports(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceGroupManagerNamedPort']]]:
        """
        The named port configuration. See the section below
        for details on configuration.
        """
        return pulumi.get(self, "named_ports")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional['outputs.InstanceGroupManagerParams']]:
        """
        Input only additional params for instance group manager creation. Structure is documented below. For more information, see [API](https://cloud.google.com/compute/docs/reference/rest/beta/instanceGroupManagers/insert).
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> pulumi.Output[Optional['outputs.InstanceGroupManagerResourcePolicies']]:
        """
        Resource policies for this managed instance group. Structure is documented below.

        - - -
        """
        return pulumi.get(self, "resource_policies")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="standbyPolicy")
    def standby_policy(self) -> pulumi.Output['outputs.InstanceGroupManagerStandbyPolicy']:
        """
        The standby policy for stopped and suspended instances. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/suspended-and-stopped-vms-in-mig).
        """
        return pulumi.get(self, "standby_policy")

    @_builtins.property
    @pulumi.getter(name="statefulDisks")
    def stateful_disks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceGroupManagerStatefulDisk']]]:
        """
        Disks created on the instances that will be preserved on instance delete, update, etc. Structure is documented below. For more information see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/configuring-stateful-disks-in-migs).
        """
        return pulumi.get(self, "stateful_disks")

    @_builtins.property
    @pulumi.getter(name="statefulExternalIps")
    def stateful_external_ips(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceGroupManagerStatefulExternalIp']]]:
        """
        External network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        """
        return pulumi.get(self, "stateful_external_ips")

    @_builtins.property
    @pulumi.getter(name="statefulInternalIps")
    def stateful_internal_ips(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceGroupManagerStatefulInternalIp']]]:
        """
        Internal network IPs assigned to the instances that will be preserved on instance delete, update, etc. This map is keyed with the network interface name. Structure is documented below.
        """
        return pulumi.get(self, "stateful_internal_ips")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.InstanceGroupManagerStatus']]:
        """
        The status of this managed instance group.
        """
        return pulumi.get(self, "statuses")

    @_builtins.property
    @pulumi.getter(name="targetPools")
    def target_pools(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The full URL of all target pools to which new
        instances in the group are added. Updating the target pools attribute does
        not affect existing instances.
        """
        return pulumi.get(self, "target_pools")

    @_builtins.property
    @pulumi.getter(name="targetSize")
    def target_size(self) -> pulumi.Output[_builtins.int]:
        """
        The target number of running instances for this managed instance group. This value should always be explicitly set
        unless this resource is attached to an autoscaler, in which case it should never be set. Defaults to 0.
        """
        return pulumi.get(self, "target_size")

    @_builtins.property
    @pulumi.getter(name="targetStoppedSize")
    def target_stopped_size(self) -> pulumi.Output[_builtins.int]:
        """
        The target number of stopped instances for this managed instance group.
        """
        return pulumi.get(self, "target_stopped_size")

    @_builtins.property
    @pulumi.getter(name="targetSuspendedSize")
    def target_suspended_size(self) -> pulumi.Output[_builtins.int]:
        """
        The target number of suspended instances for this managed instance group.
        """
        return pulumi.get(self, "target_suspended_size")

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output['outputs.InstanceGroupManagerUpdatePolicy']:
        """
        The update policy for this managed instance group. Structure is documented below. For more information, see the [official documentation](https://cloud.google.com/compute/docs/instance-groups/updating-managed-instance-groups) and [API](https://cloud.google.com/compute/docs/reference/rest/v1/instanceGroupManagers/patch).
        """
        return pulumi.get(self, "update_policy")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence['outputs.InstanceGroupManagerVersion']]:
        """
        Application versions managed by this instance group. Each
        version deals with a specific instance template, allowing canary release scenarios.
        Structure is documented below.
        """
        return pulumi.get(self, "versions")

    @_builtins.property
    @pulumi.getter(name="waitForInstances")
    def wait_for_instances(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to wait for all instances to be created/updated before
        returning. Note that if this is set to true and the operation does not succeed, this provider will
        continue trying until it times out.
        """
        return pulumi.get(self, "wait_for_instances")

    @_builtins.property
    @pulumi.getter(name="waitForInstancesStatus")
    def wait_for_instances_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When used with `wait_for_instances` it specifies the status to wait for.
        When `STABLE` is specified this resource will wait until the instances are stable before returning. When `UPDATED` is
        set, it will wait for the version target to be reached and any per instance configs to be effective as well as all
        instances to be stable before returning. The possible values are `STABLE` and `UPDATED`
        """
        return pulumi.get(self, "wait_for_instances_status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The zone that instances in this group should be created
        in.

        - - -
        """
        return pulumi.get(self, "zone")

