# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkArgs', 'Network']

@pulumi.input_type
class NetworkArgs:
    def __init__(__self__, *,
                 auto_create_subnetworks: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_always_compare_med: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_best_path_selection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_inter_region_cost: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_enforcement_order: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input['NetworkParamsArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Network resource.
        :param pulumi.Input[_builtins.bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[_builtins.bool] bgp_always_compare_med: Enables/disables the comparison of MED across routes with different Neighbor ASNs.
               This value can only be set if the --bgp-best-path-selection-mode is STANDARD
        :param pulumi.Input[_builtins.str] bgp_best_path_selection_mode: The BGP best selection algorithm to be employed. MODE can be LEGACY or STANDARD.
               Possible values are: `LEGACY`, `STANDARD`.
        :param pulumi.Input[_builtins.str] bgp_inter_region_cost: Choice of the behavior of inter-regional cost and MED in the BPS algorithm.
               Possible values are: `DEFAULT`, `ADD_COST_TO_MED`.
        :param pulumi.Input[_builtins.bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[_builtins.bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[_builtins.str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit in bytes. The default value is 1460 bytes.
               The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
               Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
               with an ICMP `Fragmentation-Needed` message if the packets are routed to the Internet or other VPCs
               with varying MTUs.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network_firewall_policy_enforcement_order: Set the order that Firewall Rules and Firewall Policies are evaluated.
               Default value is `AFTER_CLASSIC_FIREWALL`.
               Possible values are: `BEFORE_CLASSIC_FIREWALL`, `AFTER_CLASSIC_FIREWALL`.
        :param pulumi.Input[_builtins.str] network_profile: A full or partial URL of the network profile to apply to this network.
               This field can be set only at resource creation time. For example, the
               following are valid URLs:
               * https://www.googleapis.com/compute/v1/projects/{projectId}/global/networkProfiles/{network_profile_name}
               * projects/{projectId}/global/networkProfiles/{network_profile_name}
        :param pulumi.Input['NetworkParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are: `REGIONAL`, `GLOBAL`.
        """
        if auto_create_subnetworks is not None:
            pulumi.set(__self__, "auto_create_subnetworks", auto_create_subnetworks)
        if bgp_always_compare_med is not None:
            pulumi.set(__self__, "bgp_always_compare_med", bgp_always_compare_med)
        if bgp_best_path_selection_mode is not None:
            pulumi.set(__self__, "bgp_best_path_selection_mode", bgp_best_path_selection_mode)
        if bgp_inter_region_cost is not None:
            pulumi.set(__self__, "bgp_inter_region_cost", bgp_inter_region_cost)
        if delete_default_routes_on_create is not None:
            pulumi.set(__self__, "delete_default_routes_on_create", delete_default_routes_on_create)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ula_internal_ipv6 is not None:
            pulumi.set(__self__, "enable_ula_internal_ipv6", enable_ula_internal_ipv6)
        if internal_ipv6_range is not None:
            pulumi.set(__self__, "internal_ipv6_range", internal_ipv6_range)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_enforcement_order is not None:
            pulumi.set(__self__, "network_firewall_policy_enforcement_order", network_firewall_policy_enforcement_order)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)

    @_builtins.property
    @pulumi.getter(name="autoCreateSubnetworks")
    def auto_create_subnetworks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to `true`, the network is created in "auto subnet mode" and
        it will create a subnet for each region automatically across the
        `10.128.0.0/9` address range.
        When set to `false`, the network is created in "custom subnet mode" so
        the user can explicitly connect subnetwork resources.
        """
        return pulumi.get(self, "auto_create_subnetworks")

    @auto_create_subnetworks.setter
    def auto_create_subnetworks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_subnetworks", value)

    @_builtins.property
    @pulumi.getter(name="bgpAlwaysCompareMed")
    def bgp_always_compare_med(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables/disables the comparison of MED across routes with different Neighbor ASNs.
        This value can only be set if the --bgp-best-path-selection-mode is STANDARD
        """
        return pulumi.get(self, "bgp_always_compare_med")

    @bgp_always_compare_med.setter
    def bgp_always_compare_med(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bgp_always_compare_med", value)

    @_builtins.property
    @pulumi.getter(name="bgpBestPathSelectionMode")
    def bgp_best_path_selection_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The BGP best selection algorithm to be employed. MODE can be LEGACY or STANDARD.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "bgp_best_path_selection_mode")

    @bgp_best_path_selection_mode.setter
    def bgp_best_path_selection_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_best_path_selection_mode", value)

    @_builtins.property
    @pulumi.getter(name="bgpInterRegionCost")
    def bgp_inter_region_cost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Choice of the behavior of inter-regional cost and MED in the BPS algorithm.
        Possible values are: `DEFAULT`, `ADD_COST_TO_MED`.
        """
        return pulumi.get(self, "bgp_inter_region_cost")

    @bgp_inter_region_cost.setter
    def bgp_inter_region_cost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_inter_region_cost", value)

    @_builtins.property
    @pulumi.getter(name="deleteDefaultRoutesOnCreate")
    def delete_default_routes_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, default routes (`0.0.0.0/0`) will be deleted
        immediately after network creation. Defaults to `false`.
        """
        return pulumi.get(self, "delete_default_routes_on_create")

    @delete_default_routes_on_create.setter
    def delete_default_routes_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_default_routes_on_create", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. The resource must be
        recreated to modify this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableUlaInternalIpv6")
    def enable_ula_internal_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable ULA internal ipv6 on this network. Enabling this feature will assign
        a /48 from google defined ULA prefix fd20::/20.
        """
        return pulumi.get(self, "enable_ula_internal_ipv6")

    @enable_ula_internal_ipv6.setter
    def enable_ula_internal_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ula_internal_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="internalIpv6Range")
    def internal_ipv6_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When enabling ula internal ipv6, caller optionally can specify the /48 range
        they want from the google defined ULA prefix fd20::/20. The input must be a
        valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
        fail if the speficied /48 is already in used by another resource.
        If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        """
        return pulumi.get(self, "internal_ipv6_range")

    @internal_ipv6_range.setter
    def internal_ipv6_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_ipv6_range", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum Transmission Unit in bytes. The default value is 1460 bytes.
        The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
        Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
        with an ICMP `Fragmentation-Needed` message if the packets are routed to the Internet or other VPCs
        with varying MTUs.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyEnforcementOrder")
    def network_firewall_policy_enforcement_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the order that Firewall Rules and Firewall Policies are evaluated.
        Default value is `AFTER_CLASSIC_FIREWALL`.
        Possible values are: `BEFORE_CLASSIC_FIREWALL`, `AFTER_CLASSIC_FIREWALL`.
        """
        return pulumi.get(self, "network_firewall_policy_enforcement_order")

    @network_firewall_policy_enforcement_order.setter
    def network_firewall_policy_enforcement_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_firewall_policy_enforcement_order", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A full or partial URL of the network profile to apply to this network.
        This field can be set only at resource creation time. For example, the
        following are valid URLs:
        * https://www.googleapis.com/compute/v1/projects/{projectId}/global/networkProfiles/{network_profile_name}
        * projects/{projectId}/global/networkProfiles/{network_profile_name}
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['NetworkParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['NetworkParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network-wide routing mode to use. If set to `REGIONAL`, this
        network's cloud routers will only advertise routes with subnetworks
        of this network in the same region as the router. If set to `GLOBAL`,
        this network's cloud routers will advertise routes with all
        subnetworks of this network, across regions.
        Possible values are: `REGIONAL`, `GLOBAL`.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_mode", value)


@pulumi.input_type
class _NetworkState:
    def __init__(__self__, *,
                 auto_create_subnetworks: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_always_compare_med: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_best_path_selection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_inter_region_cost: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 gateway_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_enforcement_order: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 numeric_id: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input['NetworkParamsArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Network resources.
        :param pulumi.Input[_builtins.bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[_builtins.bool] bgp_always_compare_med: Enables/disables the comparison of MED across routes with different Neighbor ASNs.
               This value can only be set if the --bgp-best-path-selection-mode is STANDARD
        :param pulumi.Input[_builtins.str] bgp_best_path_selection_mode: The BGP best selection algorithm to be employed. MODE can be LEGACY or STANDARD.
               Possible values are: `LEGACY`, `STANDARD`.
        :param pulumi.Input[_builtins.str] bgp_inter_region_cost: Choice of the behavior of inter-regional cost and MED in the BPS algorithm.
               Possible values are: `DEFAULT`, `ADD_COST_TO_MED`.
        :param pulumi.Input[_builtins.bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[_builtins.bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[_builtins.str] gateway_ipv4: The gateway address for default routing out of the network. This value
               is selected by GCP.
        :param pulumi.Input[_builtins.str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit in bytes. The default value is 1460 bytes.
               The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
               Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
               with an ICMP `Fragmentation-Needed` message if the packets are routed to the Internet or other VPCs
               with varying MTUs.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network_firewall_policy_enforcement_order: Set the order that Firewall Rules and Firewall Policies are evaluated.
               Default value is `AFTER_CLASSIC_FIREWALL`.
               Possible values are: `BEFORE_CLASSIC_FIREWALL`, `AFTER_CLASSIC_FIREWALL`.
        :param pulumi.Input[_builtins.str] network_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] network_profile: A full or partial URL of the network profile to apply to this network.
               This field can be set only at resource creation time. For example, the
               following are valid URLs:
               * https://www.googleapis.com/compute/v1/projects/{projectId}/global/networkProfiles/{network_profile_name}
               * projects/{projectId}/global/networkProfiles/{network_profile_name}
        :param pulumi.Input[_builtins.str] numeric_id: (Deprecated)
               The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input['NetworkParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are: `REGIONAL`, `GLOBAL`.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        """
        if auto_create_subnetworks is not None:
            pulumi.set(__self__, "auto_create_subnetworks", auto_create_subnetworks)
        if bgp_always_compare_med is not None:
            pulumi.set(__self__, "bgp_always_compare_med", bgp_always_compare_med)
        if bgp_best_path_selection_mode is not None:
            pulumi.set(__self__, "bgp_best_path_selection_mode", bgp_best_path_selection_mode)
        if bgp_inter_region_cost is not None:
            pulumi.set(__self__, "bgp_inter_region_cost", bgp_inter_region_cost)
        if delete_default_routes_on_create is not None:
            pulumi.set(__self__, "delete_default_routes_on_create", delete_default_routes_on_create)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_ula_internal_ipv6 is not None:
            pulumi.set(__self__, "enable_ula_internal_ipv6", enable_ula_internal_ipv6)
        if gateway_ipv4 is not None:
            pulumi.set(__self__, "gateway_ipv4", gateway_ipv4)
        if internal_ipv6_range is not None:
            pulumi.set(__self__, "internal_ipv6_range", internal_ipv6_range)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_enforcement_order is not None:
            pulumi.set(__self__, "network_firewall_policy_enforcement_order", network_firewall_policy_enforcement_order)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if network_profile is not None:
            pulumi.set(__self__, "network_profile", network_profile)
        if numeric_id is not None:
            warnings.warn("""`numeric_id` is deprecated and will be removed in a future major release. Use `network_id` instead.""", DeprecationWarning)
            pulumi.log.warn("""numeric_id is deprecated: `numeric_id` is deprecated and will be removed in a future major release. Use `network_id` instead.""")
        if numeric_id is not None:
            pulumi.set(__self__, "numeric_id", numeric_id)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if routing_mode is not None:
            pulumi.set(__self__, "routing_mode", routing_mode)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @_builtins.property
    @pulumi.getter(name="autoCreateSubnetworks")
    def auto_create_subnetworks(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to `true`, the network is created in "auto subnet mode" and
        it will create a subnet for each region automatically across the
        `10.128.0.0/9` address range.
        When set to `false`, the network is created in "custom subnet mode" so
        the user can explicitly connect subnetwork resources.
        """
        return pulumi.get(self, "auto_create_subnetworks")

    @auto_create_subnetworks.setter
    def auto_create_subnetworks(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_subnetworks", value)

    @_builtins.property
    @pulumi.getter(name="bgpAlwaysCompareMed")
    def bgp_always_compare_med(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables/disables the comparison of MED across routes with different Neighbor ASNs.
        This value can only be set if the --bgp-best-path-selection-mode is STANDARD
        """
        return pulumi.get(self, "bgp_always_compare_med")

    @bgp_always_compare_med.setter
    def bgp_always_compare_med(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bgp_always_compare_med", value)

    @_builtins.property
    @pulumi.getter(name="bgpBestPathSelectionMode")
    def bgp_best_path_selection_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The BGP best selection algorithm to be employed. MODE can be LEGACY or STANDARD.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "bgp_best_path_selection_mode")

    @bgp_best_path_selection_mode.setter
    def bgp_best_path_selection_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_best_path_selection_mode", value)

    @_builtins.property
    @pulumi.getter(name="bgpInterRegionCost")
    def bgp_inter_region_cost(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Choice of the behavior of inter-regional cost and MED in the BPS algorithm.
        Possible values are: `DEFAULT`, `ADD_COST_TO_MED`.
        """
        return pulumi.get(self, "bgp_inter_region_cost")

    @bgp_inter_region_cost.setter
    def bgp_inter_region_cost(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgp_inter_region_cost", value)

    @_builtins.property
    @pulumi.getter(name="deleteDefaultRoutesOnCreate")
    def delete_default_routes_on_create(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to `true`, default routes (`0.0.0.0/0`) will be deleted
        immediately after network creation. Defaults to `false`.
        """
        return pulumi.get(self, "delete_default_routes_on_create")

    @delete_default_routes_on_create.setter
    def delete_default_routes_on_create(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_default_routes_on_create", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource. The resource must be
        recreated to modify this field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableUlaInternalIpv6")
    def enable_ula_internal_ipv6(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable ULA internal ipv6 on this network. Enabling this feature will assign
        a /48 from google defined ULA prefix fd20::/20.
        """
        return pulumi.get(self, "enable_ula_internal_ipv6")

    @enable_ula_internal_ipv6.setter
    def enable_ula_internal_ipv6(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_ula_internal_ipv6", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIpv4")
    def gateway_ipv4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The gateway address for default routing out of the network. This value
        is selected by GCP.
        """
        return pulumi.get(self, "gateway_ipv4")

    @gateway_ipv4.setter
    def gateway_ipv4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_ipv4", value)

    @_builtins.property
    @pulumi.getter(name="internalIpv6Range")
    def internal_ipv6_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When enabling ula internal ipv6, caller optionally can specify the /48 range
        they want from the google defined ULA prefix fd20::/20. The input must be a
        valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
        fail if the speficied /48 is already in used by another resource.
        If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        """
        return pulumi.get(self, "internal_ipv6_range")

    @internal_ipv6_range.setter
    def internal_ipv6_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internal_ipv6_range", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum Transmission Unit in bytes. The default value is 1460 bytes.
        The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
        Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
        with an ICMP `Fragmentation-Needed` message if the packets are routed to the Internet or other VPCs
        with varying MTUs.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyEnforcementOrder")
    def network_firewall_policy_enforcement_order(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the order that Firewall Rules and Firewall Policies are evaluated.
        Default value is `AFTER_CLASSIC_FIREWALL`.
        Possible values are: `BEFORE_CLASSIC_FIREWALL`, `AFTER_CLASSIC_FIREWALL`.
        """
        return pulumi.get(self, "network_firewall_policy_enforcement_order")

    @network_firewall_policy_enforcement_order.setter
    def network_firewall_policy_enforcement_order(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_firewall_policy_enforcement_order", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A full or partial URL of the network profile to apply to this network.
        This field can be set only at resource creation time. For example, the
        following are valid URLs:
        * https://www.googleapis.com/compute/v1/projects/{projectId}/global/networkProfiles/{network_profile_name}
        * projects/{projectId}/global/networkProfiles/{network_profile_name}
        """
        return pulumi.get(self, "network_profile")

    @network_profile.setter
    def network_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_profile", value)

    @_builtins.property
    @pulumi.getter(name="numericId")
    @_utilities.deprecated("""`numeric_id` is deprecated and will be removed in a future major release. Use `network_id` instead.""")
    def numeric_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated)
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "numeric_id")

    @numeric_id.setter
    def numeric_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "numeric_id", value)

    @_builtins.property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['NetworkParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['NetworkParamsArgs']]):
        pulumi.set(self, "params", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network-wide routing mode to use. If set to `REGIONAL`, this
        network's cloud routers will only advertise routes with subnetworks
        of this network in the same region as the router. If set to `GLOBAL`,
        this network's cloud routers will advertise routes with all
        subnetworks of this network, across regions.
        Possible values are: `REGIONAL`, `GLOBAL`.
        """
        return pulumi.get(self, "routing_mode")

    @routing_mode.setter
    def routing_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_mode", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)


@pulumi.type_token("gcp:compute/network:Network")
class Network(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_subnetworks: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_always_compare_med: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_best_path_selection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_inter_region_cost: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_enforcement_order: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['NetworkParamsArgs', 'NetworkParamsArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a VPC network or legacy network resource on GCP.

        To get more information about Network, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/vpc)

        ## Example Usage

        ### Network Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network", name="vpc-network")
        ```
        ### Network Custom Mtu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            auto_create_subnetworks=True,
            mtu=1460)
        ```
        ### Network Custom Firewall Enforcement Order

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            auto_create_subnetworks=True,
            network_firewall_policy_enforcement_order="BEFORE_CLASSIC_FIREWALL")
        ```
        ### Network Bgp Best Path Selection Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            routing_mode="GLOBAL")
        ```
        ### Network Bgp Best Path Selection Mode Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            routing_mode="GLOBAL",
            bgp_best_path_selection_mode="STANDARD")
        ```
        ### Network Bgp Best Path Selection Mode Standard Custom Fields

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            routing_mode="GLOBAL",
            bgp_best_path_selection_mode="STANDARD",
            bgp_always_compare_med=True,
            bgp_inter_region_cost="ADD_COST_TO_MED")
        ```

        ## Import

        Network can be imported using any of these accepted formats:

        * `projects/{{project}}/global/networks/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Network can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/network:Network default projects/{{project}}/global/networks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/network:Network default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/network:Network default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[_builtins.bool] bgp_always_compare_med: Enables/disables the comparison of MED across routes with different Neighbor ASNs.
               This value can only be set if the --bgp-best-path-selection-mode is STANDARD
        :param pulumi.Input[_builtins.str] bgp_best_path_selection_mode: The BGP best selection algorithm to be employed. MODE can be LEGACY or STANDARD.
               Possible values are: `LEGACY`, `STANDARD`.
        :param pulumi.Input[_builtins.str] bgp_inter_region_cost: Choice of the behavior of inter-regional cost and MED in the BPS algorithm.
               Possible values are: `DEFAULT`, `ADD_COST_TO_MED`.
        :param pulumi.Input[_builtins.bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[_builtins.bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[_builtins.str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit in bytes. The default value is 1460 bytes.
               The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
               Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
               with an ICMP `Fragmentation-Needed` message if the packets are routed to the Internet or other VPCs
               with varying MTUs.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network_firewall_policy_enforcement_order: Set the order that Firewall Rules and Firewall Policies are evaluated.
               Default value is `AFTER_CLASSIC_FIREWALL`.
               Possible values are: `BEFORE_CLASSIC_FIREWALL`, `AFTER_CLASSIC_FIREWALL`.
        :param pulumi.Input[_builtins.str] network_profile: A full or partial URL of the network profile to apply to this network.
               This field can be set only at resource creation time. For example, the
               following are valid URLs:
               * https://www.googleapis.com/compute/v1/projects/{projectId}/global/networkProfiles/{network_profile_name}
               * projects/{projectId}/global/networkProfiles/{network_profile_name}
        :param pulumi.Input[Union['NetworkParamsArgs', 'NetworkParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are: `REGIONAL`, `GLOBAL`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NetworkArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC network or legacy network resource on GCP.

        To get more information about Network, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/networks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/vpc)

        ## Example Usage

        ### Network Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network", name="vpc-network")
        ```
        ### Network Custom Mtu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            auto_create_subnetworks=True,
            mtu=1460)
        ```
        ### Network Custom Firewall Enforcement Order

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            auto_create_subnetworks=True,
            network_firewall_policy_enforcement_order="BEFORE_CLASSIC_FIREWALL")
        ```
        ### Network Bgp Best Path Selection Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            routing_mode="GLOBAL")
        ```
        ### Network Bgp Best Path Selection Mode Standard

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            routing_mode="GLOBAL",
            bgp_best_path_selection_mode="STANDARD")
        ```
        ### Network Bgp Best Path Selection Mode Standard Custom Fields

        ```python
        import pulumi
        import pulumi_gcp as gcp

        vpc_network = gcp.compute.Network("vpc_network",
            project="my-project-name",
            name="vpc-network",
            routing_mode="GLOBAL",
            bgp_best_path_selection_mode="STANDARD",
            bgp_always_compare_med=True,
            bgp_inter_region_cost="ADD_COST_TO_MED")
        ```

        ## Import

        Network can be imported using any of these accepted formats:

        * `projects/{{project}}/global/networks/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Network can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/network:Network default projects/{{project}}/global/networks/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/network:Network default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/network:Network default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NetworkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_subnetworks: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_always_compare_med: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgp_best_path_selection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 bgp_inter_region_cost: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_default_routes_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_ula_internal_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
                 internal_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_firewall_policy_enforcement_order: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['NetworkParamsArgs', 'NetworkParamsArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkArgs.__new__(NetworkArgs)

            __props__.__dict__["auto_create_subnetworks"] = auto_create_subnetworks
            __props__.__dict__["bgp_always_compare_med"] = bgp_always_compare_med
            __props__.__dict__["bgp_best_path_selection_mode"] = bgp_best_path_selection_mode
            __props__.__dict__["bgp_inter_region_cost"] = bgp_inter_region_cost
            __props__.__dict__["delete_default_routes_on_create"] = delete_default_routes_on_create
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_ula_internal_ipv6"] = enable_ula_internal_ipv6
            __props__.__dict__["internal_ipv6_range"] = internal_ipv6_range
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["network_firewall_policy_enforcement_order"] = network_firewall_policy_enforcement_order
            __props__.__dict__["network_profile"] = network_profile
            __props__.__dict__["params"] = params
            __props__.__dict__["project"] = project
            __props__.__dict__["routing_mode"] = routing_mode
            __props__.__dict__["gateway_ipv4"] = None
            __props__.__dict__["network_id"] = None
            __props__.__dict__["numeric_id"] = None
            __props__.__dict__["self_link"] = None
        super(Network, __self__).__init__(
            'gcp:compute/network:Network',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create_subnetworks: Optional[pulumi.Input[_builtins.bool]] = None,
            bgp_always_compare_med: Optional[pulumi.Input[_builtins.bool]] = None,
            bgp_best_path_selection_mode: Optional[pulumi.Input[_builtins.str]] = None,
            bgp_inter_region_cost: Optional[pulumi.Input[_builtins.str]] = None,
            delete_default_routes_on_create: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_ula_internal_ipv6: Optional[pulumi.Input[_builtins.bool]] = None,
            gateway_ipv4: Optional[pulumi.Input[_builtins.str]] = None,
            internal_ipv6_range: Optional[pulumi.Input[_builtins.str]] = None,
            mtu: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_firewall_policy_enforcement_order: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_profile: Optional[pulumi.Input[_builtins.str]] = None,
            numeric_id: Optional[pulumi.Input[_builtins.str]] = None,
            params: Optional[pulumi.Input[Union['NetworkParamsArgs', 'NetworkParamsArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            routing_mode: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None) -> 'Network':
        """
        Get an existing Network resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create_subnetworks: When set to `true`, the network is created in "auto subnet mode" and
               it will create a subnet for each region automatically across the
               `10.128.0.0/9` address range.
               When set to `false`, the network is created in "custom subnet mode" so
               the user can explicitly connect subnetwork resources.
        :param pulumi.Input[_builtins.bool] bgp_always_compare_med: Enables/disables the comparison of MED across routes with different Neighbor ASNs.
               This value can only be set if the --bgp-best-path-selection-mode is STANDARD
        :param pulumi.Input[_builtins.str] bgp_best_path_selection_mode: The BGP best selection algorithm to be employed. MODE can be LEGACY or STANDARD.
               Possible values are: `LEGACY`, `STANDARD`.
        :param pulumi.Input[_builtins.str] bgp_inter_region_cost: Choice of the behavior of inter-regional cost and MED in the BPS algorithm.
               Possible values are: `DEFAULT`, `ADD_COST_TO_MED`.
        :param pulumi.Input[_builtins.bool] delete_default_routes_on_create: If set to `true`, default routes (`0.0.0.0/0`) will be deleted
               immediately after network creation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource. The resource must be
               recreated to modify this field.
        :param pulumi.Input[_builtins.bool] enable_ula_internal_ipv6: Enable ULA internal ipv6 on this network. Enabling this feature will assign
               a /48 from google defined ULA prefix fd20::/20.
        :param pulumi.Input[_builtins.str] gateway_ipv4: The gateway address for default routing out of the network. This value
               is selected by GCP.
        :param pulumi.Input[_builtins.str] internal_ipv6_range: When enabling ula internal ipv6, caller optionally can specify the /48 range
               they want from the google defined ULA prefix fd20::/20. The input must be a
               valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
               fail if the speficied /48 is already in used by another resource.
               If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        :param pulumi.Input[_builtins.int] mtu: Maximum Transmission Unit in bytes. The default value is 1460 bytes.
               The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
               Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
               with an ICMP `Fragmentation-Needed` message if the packets are routed to the Internet or other VPCs
               with varying MTUs.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] network_firewall_policy_enforcement_order: Set the order that Firewall Rules and Firewall Policies are evaluated.
               Default value is `AFTER_CLASSIC_FIREWALL`.
               Possible values are: `BEFORE_CLASSIC_FIREWALL`, `AFTER_CLASSIC_FIREWALL`.
        :param pulumi.Input[_builtins.str] network_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[_builtins.str] network_profile: A full or partial URL of the network profile to apply to this network.
               This field can be set only at resource creation time. For example, the
               following are valid URLs:
               * https://www.googleapis.com/compute/v1/projects/{projectId}/global/networkProfiles/{network_profile_name}
               * projects/{projectId}/global/networkProfiles/{network_profile_name}
        :param pulumi.Input[_builtins.str] numeric_id: (Deprecated)
               The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[Union['NetworkParamsArgs', 'NetworkParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] routing_mode: The network-wide routing mode to use. If set to `REGIONAL`, this
               network's cloud routers will only advertise routes with subnetworks
               of this network in the same region as the router. If set to `GLOBAL`,
               this network's cloud routers will advertise routes with all
               subnetworks of this network, across regions.
               Possible values are: `REGIONAL`, `GLOBAL`.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkState.__new__(_NetworkState)

        __props__.__dict__["auto_create_subnetworks"] = auto_create_subnetworks
        __props__.__dict__["bgp_always_compare_med"] = bgp_always_compare_med
        __props__.__dict__["bgp_best_path_selection_mode"] = bgp_best_path_selection_mode
        __props__.__dict__["bgp_inter_region_cost"] = bgp_inter_region_cost
        __props__.__dict__["delete_default_routes_on_create"] = delete_default_routes_on_create
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_ula_internal_ipv6"] = enable_ula_internal_ipv6
        __props__.__dict__["gateway_ipv4"] = gateway_ipv4
        __props__.__dict__["internal_ipv6_range"] = internal_ipv6_range
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_enforcement_order"] = network_firewall_policy_enforcement_order
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["network_profile"] = network_profile
        __props__.__dict__["numeric_id"] = numeric_id
        __props__.__dict__["params"] = params
        __props__.__dict__["project"] = project
        __props__.__dict__["routing_mode"] = routing_mode
        __props__.__dict__["self_link"] = self_link
        return Network(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoCreateSubnetworks")
    def auto_create_subnetworks(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When set to `true`, the network is created in "auto subnet mode" and
        it will create a subnet for each region automatically across the
        `10.128.0.0/9` address range.
        When set to `false`, the network is created in "custom subnet mode" so
        the user can explicitly connect subnetwork resources.
        """
        return pulumi.get(self, "auto_create_subnetworks")

    @_builtins.property
    @pulumi.getter(name="bgpAlwaysCompareMed")
    def bgp_always_compare_med(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables/disables the comparison of MED across routes with different Neighbor ASNs.
        This value can only be set if the --bgp-best-path-selection-mode is STANDARD
        """
        return pulumi.get(self, "bgp_always_compare_med")

    @_builtins.property
    @pulumi.getter(name="bgpBestPathSelectionMode")
    def bgp_best_path_selection_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The BGP best selection algorithm to be employed. MODE can be LEGACY or STANDARD.
        Possible values are: `LEGACY`, `STANDARD`.
        """
        return pulumi.get(self, "bgp_best_path_selection_mode")

    @_builtins.property
    @pulumi.getter(name="bgpInterRegionCost")
    def bgp_inter_region_cost(self) -> pulumi.Output[_builtins.str]:
        """
        Choice of the behavior of inter-regional cost and MED in the BPS algorithm.
        Possible values are: `DEFAULT`, `ADD_COST_TO_MED`.
        """
        return pulumi.get(self, "bgp_inter_region_cost")

    @_builtins.property
    @pulumi.getter(name="deleteDefaultRoutesOnCreate")
    def delete_default_routes_on_create(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to `true`, default routes (`0.0.0.0/0`) will be deleted
        immediately after network creation. Defaults to `false`.
        """
        return pulumi.get(self, "delete_default_routes_on_create")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource. The resource must be
        recreated to modify this field.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableUlaInternalIpv6")
    def enable_ula_internal_ipv6(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable ULA internal ipv6 on this network. Enabling this feature will assign
        a /48 from google defined ULA prefix fd20::/20.
        """
        return pulumi.get(self, "enable_ula_internal_ipv6")

    @_builtins.property
    @pulumi.getter(name="gatewayIpv4")
    def gateway_ipv4(self) -> pulumi.Output[_builtins.str]:
        """
        The gateway address for default routing out of the network. This value
        is selected by GCP.
        """
        return pulumi.get(self, "gateway_ipv4")

    @_builtins.property
    @pulumi.getter(name="internalIpv6Range")
    def internal_ipv6_range(self) -> pulumi.Output[_builtins.str]:
        """
        When enabling ula internal ipv6, caller optionally can specify the /48 range
        they want from the google defined ULA prefix fd20::/20. The input must be a
        valid /48 ULA IPv6 address and must be within the fd20::/20. Operation will
        fail if the speficied /48 is already in used by another resource.
        If the field is not speficied, then a /48 range will be randomly allocated from fd20::/20 and returned via this field.
        """
        return pulumi.get(self, "internal_ipv6_range")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum Transmission Unit in bytes. The default value is 1460 bytes.
        The minimum value for this field is 1300 and the maximum value is 8896 bytes (jumbo frames).
        Note that packets larger than 1500 bytes (standard Ethernet) can be subject to TCP-MSS clamping or dropped
        with an ICMP `Fragmentation-Needed` message if the packets are routed to the Internet or other VPCs
        with varying MTUs.
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFirewallPolicyEnforcementOrder")
    def network_firewall_policy_enforcement_order(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the order that Firewall Rules and Firewall Policies are evaluated.
        Default value is `AFTER_CLASSIC_FIREWALL`.
        Possible values are: `BEFORE_CLASSIC_FIREWALL`, `AFTER_CLASSIC_FIREWALL`.
        """
        return pulumi.get(self, "network_firewall_policy_enforcement_order")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A full or partial URL of the network profile to apply to this network.
        This field can be set only at resource creation time. For example, the
        following are valid URLs:
        * https://www.googleapis.com/compute/v1/projects/{projectId}/global/networkProfiles/{network_profile_name}
        * projects/{projectId}/global/networkProfiles/{network_profile_name}
        """
        return pulumi.get(self, "network_profile")

    @_builtins.property
    @pulumi.getter(name="numericId")
    @_utilities.deprecated("""`numeric_id` is deprecated and will be removed in a future major release. Use `network_id` instead.""")
    def numeric_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Deprecated)
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "numeric_id")

    @_builtins.property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional['outputs.NetworkParams']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="routingMode")
    def routing_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The network-wide routing mode to use. If set to `REGIONAL`, this
        network's cloud routers will only advertise routes with subnetworks
        of this network in the same region as the router. If set to `GLOBAL`,
        this network's cloud routers will advertise routes with all
        subnetworks of this network, across regions.
        Possible values are: `REGIONAL`, `GLOBAL`.
        """
        return pulumi.get(self, "routing_mode")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

