# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicDelegatedPrefixArgs', 'PublicDelegatedPrefix']

@pulumi.input_type
class PublicDelegatedPrefixArgs:
    def __init__(__self__, *,
                 ip_cidr_range: pulumi.Input[_builtins.str],
                 parent_prefix: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 allocatable_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_live_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PublicDelegatedPrefix resource.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP address range, in CIDR format, represented by this public delegated prefix.
        :param pulumi.Input[_builtins.str] parent_prefix: The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
        :param pulumi.Input[_builtins.str] region: A region where the prefix will reside.
        :param pulumi.Input[_builtins.int] allocatable_prefix_length: The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.bool] is_live_migration: If true, the prefix will be live migrated.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of this IPv6 PDP. MODE must be one of: DELEGATION,
               EXTERNAL_IPV6_FORWARDING_RULE_CREATION and EXTERNAL_IPV6_SUBNETWORK_CREATION.
               Possible values are: `DELEGATION`, `EXTERNAL_IPV6_FORWARDING_RULE_CREATION`, `EXTERNAL_IPV6_SUBNETWORK_CREATION`.
        :param pulumi.Input[_builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        pulumi.set(__self__, "parent_prefix", parent_prefix)
        pulumi.set(__self__, "region", region)
        if allocatable_prefix_length is not None:
            pulumi.set(__self__, "allocatable_prefix_length", allocatable_prefix_length)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_live_migration is not None:
            pulumi.set(__self__, "is_live_migration", is_live_migration)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address range, in CIDR format, represented by this public delegated prefix.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="parentPrefix")
    def parent_prefix(self) -> pulumi.Input[_builtins.str]:
        """
        The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
        """
        return pulumi.get(self, "parent_prefix")

    @parent_prefix.setter
    def parent_prefix(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "parent_prefix", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        A region where the prefix will reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="allocatablePrefixLength")
    def allocatable_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
        """
        return pulumi.get(self, "allocatable_prefix_length")

    @allocatable_prefix_length.setter
    def allocatable_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocatable_prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isLiveMigration")
    def is_live_migration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the prefix will be live migrated.
        """
        return pulumi.get(self, "is_live_migration")

    @is_live_migration.setter
    def is_live_migration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_live_migration", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of this IPv6 PDP. MODE must be one of: DELEGATION,
        EXTERNAL_IPV6_FORWARDING_RULE_CREATION and EXTERNAL_IPV6_SUBNETWORK_CREATION.
        Possible values are: `DELEGATION`, `EXTERNAL_IPV6_FORWARDING_RULE_CREATION`, `EXTERNAL_IPV6_SUBNETWORK_CREATION`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _PublicDelegatedPrefixState:
    def __init__(__self__, *,
                 allocatable_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 is_live_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PublicDelegatedPrefix resources.
        :param pulumi.Input[_builtins.int] allocatable_prefix_length: The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP address range, in CIDR format, represented by this public delegated prefix.
        :param pulumi.Input[_builtins.bool] is_live_migration: If true, the prefix will be live migrated.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of this IPv6 PDP. MODE must be one of: DELEGATION,
               EXTERNAL_IPV6_FORWARDING_RULE_CREATION and EXTERNAL_IPV6_SUBNETWORK_CREATION.
               Possible values are: `DELEGATION`, `EXTERNAL_IPV6_FORWARDING_RULE_CREATION`, `EXTERNAL_IPV6_SUBNETWORK_CREATION`.
        :param pulumi.Input[_builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] parent_prefix: The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: A region where the prefix will reside.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        """
        if allocatable_prefix_length is not None:
            pulumi.set(__self__, "allocatable_prefix_length", allocatable_prefix_length)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if is_live_migration is not None:
            pulumi.set(__self__, "is_live_migration", is_live_migration)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent_prefix is not None:
            pulumi.set(__self__, "parent_prefix", parent_prefix)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @_builtins.property
    @pulumi.getter(name="allocatablePrefixLength")
    def allocatable_prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
        """
        return pulumi.get(self, "allocatable_prefix_length")

    @allocatable_prefix_length.setter
    def allocatable_prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocatable_prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address range, in CIDR format, represented by this public delegated prefix.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter(name="isLiveMigration")
    def is_live_migration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, the prefix will be live migrated.
        """
        return pulumi.get(self, "is_live_migration")

    @is_live_migration.setter
    def is_live_migration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_live_migration", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of this IPv6 PDP. MODE must be one of: DELEGATION,
        EXTERNAL_IPV6_FORWARDING_RULE_CREATION and EXTERNAL_IPV6_SUBNETWORK_CREATION.
        Possible values are: `DELEGATION`, `EXTERNAL_IPV6_FORWARDING_RULE_CREATION`, `EXTERNAL_IPV6_SUBNETWORK_CREATION`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parentPrefix")
    def parent_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
        """
        return pulumi.get(self, "parent_prefix")

    @parent_prefix.setter
    def parent_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_prefix", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A region where the prefix will reside.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)


@pulumi.type_token("gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix")
class PublicDelegatedPrefix(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocatable_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 is_live_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a PublicDelegatedPrefix for use with bring your own IP addresses (BYOIP).

        To get more information about PublicDelegatedPrefix, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/publicDelegatedPrefixes)
        * How-to Guides
            * [Using bring your own IP](https://cloud.google.com/vpc/docs/using-bring-your-own-ip)

        ## Example Usage

        ### Public Delegated Prefixes Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advertised = gcp.compute.PublicAdvertisedPrefix("advertised",
            name="my-prefix",
            description="description",
            dns_verification_ip="127.127.0.0",
            ip_cidr_range="127.127.0.0/16")
        prefixes = gcp.compute.PublicDelegatedPrefix("prefixes",
            name="my-prefix",
            region="us-central1",
            description="my description",
            ip_cidr_range="127.127.0.0/24",
            parent_prefix=advertised.id)
        ```
        ### Public Delegated Prefixes Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advertised = gcp.compute.PublicAdvertisedPrefix("advertised",
            name="ipv6-pap",
            description="description",
            dns_verification_ip="2001:db8::",
            ip_cidr_range="2001:db8::/32",
            pdp_scope="REGIONAL")
        prefix = gcp.compute.PublicDelegatedPrefix("prefix",
            name="ipv6-root-pdp",
            description="test-delegation-mode-pdp",
            region="us-west1",
            ip_cidr_range="2001:db8::/40",
            parent_prefix=advertised.id,
            mode="DELEGATION")
        subprefix = gcp.compute.PublicDelegatedPrefix("subprefix",
            name="ipv6-sub-pdp",
            description="test-forwarding-rule-mode-pdp",
            region="us-west1",
            ip_cidr_range="2001:db8::/48",
            parent_prefix=prefix.id,
            allocatable_prefix_length=64,
            mode="EXTERNAL_IPV6_FORWARDING_RULE_CREATION")
        ```
        ### Public Delegated Prefix Ipv6 Subnet Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advertised = gcp.compute.PublicAdvertisedPrefix("advertised",
            name="ipv6-pap",
            description="description",
            dns_verification_ip="2001:db8::",
            ip_cidr_range="2001:db8::/32",
            pdp_scope="REGIONAL")
        prefix = gcp.compute.PublicDelegatedPrefix("prefix",
            name="ipv6-root-pdp",
            description="test-delegation-mode-pdp",
            region="us-east1",
            ip_cidr_range="2001:db8::/40",
            parent_prefix=advertised.id,
            mode="DELEGATION")
        subprefix = gcp.compute.PublicDelegatedPrefix("subprefix",
            name="ipv6-sub-pdp",
            description="test-subnet-mode-pdp",
            region="us-east1",
            ip_cidr_range="2001:db8::/48",
            parent_prefix=prefix.id,
            mode="EXTERNAL_IPV6_SUBNETWORK_CREATION")
        ```

        ## Import

        PublicDelegatedPrefix can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/publicDelegatedPrefixes/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PublicDelegatedPrefix can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default projects/{{project}}/regions/{{region}}/publicDelegatedPrefixes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allocatable_prefix_length: The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP address range, in CIDR format, represented by this public delegated prefix.
        :param pulumi.Input[_builtins.bool] is_live_migration: If true, the prefix will be live migrated.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of this IPv6 PDP. MODE must be one of: DELEGATION,
               EXTERNAL_IPV6_FORWARDING_RULE_CREATION and EXTERNAL_IPV6_SUBNETWORK_CREATION.
               Possible values are: `DELEGATION`, `EXTERNAL_IPV6_FORWARDING_RULE_CREATION`, `EXTERNAL_IPV6_SUBNETWORK_CREATION`.
        :param pulumi.Input[_builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] parent_prefix: The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: A region where the prefix will reside.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicDelegatedPrefixArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a PublicDelegatedPrefix for use with bring your own IP addresses (BYOIP).

        To get more information about PublicDelegatedPrefix, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/publicDelegatedPrefixes)
        * How-to Guides
            * [Using bring your own IP](https://cloud.google.com/vpc/docs/using-bring-your-own-ip)

        ## Example Usage

        ### Public Delegated Prefixes Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advertised = gcp.compute.PublicAdvertisedPrefix("advertised",
            name="my-prefix",
            description="description",
            dns_verification_ip="127.127.0.0",
            ip_cidr_range="127.127.0.0/16")
        prefixes = gcp.compute.PublicDelegatedPrefix("prefixes",
            name="my-prefix",
            region="us-central1",
            description="my description",
            ip_cidr_range="127.127.0.0/24",
            parent_prefix=advertised.id)
        ```
        ### Public Delegated Prefixes Ipv6

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advertised = gcp.compute.PublicAdvertisedPrefix("advertised",
            name="ipv6-pap",
            description="description",
            dns_verification_ip="2001:db8::",
            ip_cidr_range="2001:db8::/32",
            pdp_scope="REGIONAL")
        prefix = gcp.compute.PublicDelegatedPrefix("prefix",
            name="ipv6-root-pdp",
            description="test-delegation-mode-pdp",
            region="us-west1",
            ip_cidr_range="2001:db8::/40",
            parent_prefix=advertised.id,
            mode="DELEGATION")
        subprefix = gcp.compute.PublicDelegatedPrefix("subprefix",
            name="ipv6-sub-pdp",
            description="test-forwarding-rule-mode-pdp",
            region="us-west1",
            ip_cidr_range="2001:db8::/48",
            parent_prefix=prefix.id,
            allocatable_prefix_length=64,
            mode="EXTERNAL_IPV6_FORWARDING_RULE_CREATION")
        ```
        ### Public Delegated Prefix Ipv6 Subnet Mode

        ```python
        import pulumi
        import pulumi_gcp as gcp

        advertised = gcp.compute.PublicAdvertisedPrefix("advertised",
            name="ipv6-pap",
            description="description",
            dns_verification_ip="2001:db8::",
            ip_cidr_range="2001:db8::/32",
            pdp_scope="REGIONAL")
        prefix = gcp.compute.PublicDelegatedPrefix("prefix",
            name="ipv6-root-pdp",
            description="test-delegation-mode-pdp",
            region="us-east1",
            ip_cidr_range="2001:db8::/40",
            parent_prefix=advertised.id,
            mode="DELEGATION")
        subprefix = gcp.compute.PublicDelegatedPrefix("subprefix",
            name="ipv6-sub-pdp",
            description="test-subnet-mode-pdp",
            region="us-east1",
            ip_cidr_range="2001:db8::/48",
            parent_prefix=prefix.id,
            mode="EXTERNAL_IPV6_SUBNETWORK_CREATION")
        ```

        ## Import

        PublicDelegatedPrefix can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/publicDelegatedPrefixes/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PublicDelegatedPrefix can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default projects/{{project}}/regions/{{region}}/publicDelegatedPrefixes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PublicDelegatedPrefixArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicDelegatedPrefixArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocatable_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 is_live_migration: Optional[pulumi.Input[_builtins.bool]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicDelegatedPrefixArgs.__new__(PublicDelegatedPrefixArgs)

            __props__.__dict__["allocatable_prefix_length"] = allocatable_prefix_length
            __props__.__dict__["description"] = description
            if ip_cidr_range is None and not opts.urn:
                raise TypeError("Missing required property 'ip_cidr_range'")
            __props__.__dict__["ip_cidr_range"] = ip_cidr_range
            __props__.__dict__["is_live_migration"] = is_live_migration
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            if parent_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'parent_prefix'")
            __props__.__dict__["parent_prefix"] = parent_prefix
            __props__.__dict__["project"] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["self_link"] = None
        super(PublicDelegatedPrefix, __self__).__init__(
            'gcp:compute/publicDelegatedPrefix:PublicDelegatedPrefix',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocatable_prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
            is_live_migration: Optional[pulumi.Input[_builtins.bool]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parent_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None) -> 'PublicDelegatedPrefix':
        """
        Get an existing PublicDelegatedPrefix resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allocatable_prefix_length: The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP address range, in CIDR format, represented by this public delegated prefix.
        :param pulumi.Input[_builtins.bool] is_live_migration: If true, the prefix will be live migrated.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of this IPv6 PDP. MODE must be one of: DELEGATION,
               EXTERNAL_IPV6_FORWARDING_RULE_CREATION and EXTERNAL_IPV6_SUBNETWORK_CREATION.
               Possible values are: `DELEGATION`, `EXTERNAL_IPV6_FORWARDING_RULE_CREATION`, `EXTERNAL_IPV6_SUBNETWORK_CREATION`.
        :param pulumi.Input[_builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] parent_prefix: The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: A region where the prefix will reside.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicDelegatedPrefixState.__new__(_PublicDelegatedPrefixState)

        __props__.__dict__["allocatable_prefix_length"] = allocatable_prefix_length
        __props__.__dict__["description"] = description
        __props__.__dict__["ip_cidr_range"] = ip_cidr_range
        __props__.__dict__["is_live_migration"] = is_live_migration
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["parent_prefix"] = parent_prefix
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        return PublicDelegatedPrefix(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocatablePrefixLength")
    def allocatable_prefix_length(self) -> pulumi.Output[_builtins.int]:
        """
        The allocatable prefix length supported by this public delegated prefix. This field is optional and cannot be set for prefixes in DELEGATION mode. It cannot be set for IPv4 prefixes either, and it always defaults to 32.
        """
        return pulumi.get(self, "allocatable_prefix_length")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address range, in CIDR format, represented by this public delegated prefix.
        """
        return pulumi.get(self, "ip_cidr_range")

    @_builtins.property
    @pulumi.getter(name="isLiveMigration")
    def is_live_migration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, the prefix will be live migrated.
        """
        return pulumi.get(self, "is_live_migration")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the mode of this IPv6 PDP. MODE must be one of: DELEGATION,
        EXTERNAL_IPV6_FORWARDING_RULE_CREATION and EXTERNAL_IPV6_SUBNETWORK_CREATION.
        Possible values are: `DELEGATION`, `EXTERNAL_IPV6_FORWARDING_RULE_CREATION`, `EXTERNAL_IPV6_SUBNETWORK_CREATION`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentPrefix")
    def parent_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of parent prefix. Either PublicAdvertisedPrefix or PublicDelegatedPrefix.
        """
        return pulumi.get(self, "parent_prefix")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        A region where the prefix will reside.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

