# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegionSslCertificateArgs', 'RegionSslCertificate']

@pulumi.input_type
class RegionSslCertificateArgs:
    def __init__(__self__, *,
                 certificate: pulumi.Input[_builtins.str],
                 private_key: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegionSslCertificate resource.
        :param pulumi.Input[_builtins.str] certificate: The certificate in PEM format.
               The certificate chain must be no greater than 5 certs long.
               The chain must include at least one intermediate cert.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] private_key: The write-only private key in PEM format.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               These are in the same namespace as the managed SSL certificates.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the
               specified prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created regional ssl certificate should reside.
               If it is not provided, the provider region is used.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Input[_builtins.str]:
        """
        The certificate in PEM format.
        The certificate chain must be no greater than 5 certs long.
        The chain must include at least one intermediate cert.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[_builtins.str]:
        """
        The write-only private key in PEM format.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        These are in the same namespace as the managed SSL certificates.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the
        specified prefix. Conflicts with `name`. Max length is 54 characters.
        Prefixes with lengths longer than 37 characters will use a shortened
        UUID that will be more prone to collisions.
        Resulting name for a `name_prefix` <= 37 characters:
        `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
        Resulting name for a `name_prefix` 38 - 54 characters:
        `name_prefix` + YYmmdd + 3 digit incremental counter
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the created regional ssl certificate should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RegionSslCertificateState:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expire_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegionSslCertificate resources.
        :param pulumi.Input[_builtins.str] certificate: The certificate in PEM format.
               The certificate chain must be no greater than 5 certs long.
               The chain must include at least one intermediate cert.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.int] certificate_id: The unique identifier for the resource.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] expire_time: Expire time of the certificate in RFC3339 text format.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               These are in the same namespace as the managed SSL certificates.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the
               specified prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[_builtins.str] private_key: The write-only private key in PEM format.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created regional ssl certificate should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The certificate in PEM format.
        The certificate chain must be no greater than 5 certs long.
        The chain must include at least one intermediate cert.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expire time of the certificate in RFC3339 text format.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        These are in the same namespace as the managed SSL certificates.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates a unique name beginning with the
        specified prefix. Conflicts with `name`. Max length is 54 characters.
        Prefixes with lengths longer than 37 characters will use a shortened
        UUID that will be more prone to collisions.
        Resulting name for a `name_prefix` <= 37 characters:
        `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
        Resulting name for a `name_prefix` 38 - 54 characters:
        `name_prefix` + YYmmdd + 3 digit incremental counter
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name_prefix", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The write-only private key in PEM format.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Region in which the created regional ssl certificate should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)


@pulumi.type_token("gcp:compute/regionSslCertificate:RegionSslCertificate")
class RegionSslCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A RegionSslCertificate resource, used for HTTPS load balancing. This resource
        provides a mechanism to upload an SSL key and certificate to
        the load balancer to serve secure connections from the user.

        To get more information about RegionSslCertificate, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/regionSslCertificates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/load-balancing/docs/ssl-certificates)

        ## Example Usage

        ## Import

        RegionSslCertificate can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/sslCertificates/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionSslCertificate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default projects/{{project}}/regions/{{region}}/sslCertificates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: The certificate in PEM format.
               The certificate chain must be no greater than 5 certs long.
               The chain must include at least one intermediate cert.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               These are in the same namespace as the managed SSL certificates.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the
               specified prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[_builtins.str] private_key: The write-only private key in PEM format.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created regional ssl certificate should reside.
               If it is not provided, the provider region is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionSslCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A RegionSslCertificate resource, used for HTTPS load balancing. This resource
        provides a mechanism to upload an SSL key and certificate to
        the load balancer to serve secure connections from the user.

        To get more information about RegionSslCertificate, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/regionSslCertificates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/load-balancing/docs/ssl-certificates)

        ## Example Usage

        ## Import

        RegionSslCertificate can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/sslCertificates/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionSslCertificate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default projects/{{project}}/regions/{{region}}/sslCertificates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionSslCertificate:RegionSslCertificate default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionSslCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionSslCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionSslCertificateArgs.__new__(RegionSslCertificateArgs)

            if certificate is None and not opts.urn:
                raise TypeError("Missing required property 'certificate'")
            __props__.__dict__["certificate"] = None if certificate is None else pulumi.Output.secret(certificate)
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["certificate_id"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["expire_time"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificate", "privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RegionSslCertificate, __self__).__init__(
            'gcp:compute/regionSslCertificate:RegionSslCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_id: Optional[pulumi.Input[_builtins.int]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            expire_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegionSslCertificate':
        """
        Get an existing RegionSslCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate: The certificate in PEM format.
               The certificate chain must be no greater than 5 certs long.
               The chain must include at least one intermediate cert.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.int] certificate_id: The unique identifier for the resource.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.str] expire_time: Expire time of the certificate in RFC3339 text format.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
               These are in the same namespace as the managed SSL certificates.
        :param pulumi.Input[_builtins.str] name_prefix: Creates a unique name beginning with the
               specified prefix. Conflicts with `name`. Max length is 54 characters.
               Prefixes with lengths longer than 37 characters will use a shortened
               UUID that will be more prone to collisions.
               Resulting name for a `name_prefix` <= 37 characters:
               `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
               Resulting name for a `name_prefix` 38 - 54 characters:
               `name_prefix` + YYmmdd + 3 digit incremental counter
        :param pulumi.Input[_builtins.str] private_key: The write-only private key in PEM format.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] region: The Region in which the created regional ssl certificate should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionSslCertificateState.__new__(_RegionSslCertificateState)

        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["expire_time"] = expire_time
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        return RegionSslCertificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[_builtins.str]:
        """
        The certificate in PEM format.
        The certificate chain must be no greater than 5 certs long.
        The chain must include at least one intermediate cert.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[_builtins.int]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> pulumi.Output[_builtins.str]:
        """
        Expire time of the certificate in RFC3339 text format.
        """
        return pulumi.get(self, "expire_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        These are in the same namespace as the managed SSL certificates.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[_builtins.str]:
        """
        Creates a unique name beginning with the
        specified prefix. Conflicts with `name`. Max length is 54 characters.
        Prefixes with lengths longer than 37 characters will use a shortened
        UUID that will be more prone to collisions.
        Resulting name for a `name_prefix` <= 37 characters:
        `name_prefix` + YYYYmmddHHSSssss + 8 digit incremental counter
        Resulting name for a `name_prefix` 38 - 54 characters:
        `name_prefix` + YYmmdd + 3 digit incremental counter
        """
        return pulumi.get(self, "name_prefix")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[_builtins.str]:
        """
        The write-only private key in PEM format.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The Region in which the created regional ssl certificate should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

