# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReservationArgs', 'Reservation']

@pulumi.input_type
class ReservationArgs:
    def __init__(__self__, *,
                 specific_reservation: pulumi.Input['ReservationSpecificReservationArgs'],
                 zone: pulumi.Input[_builtins.str],
                 delete_after_duration: Optional[pulumi.Input['ReservationDeleteAfterDurationArgs']] = None,
                 delete_at_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_emergent_maintenance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_sharing_policy: Optional[pulumi.Input['ReservationReservationSharingPolicyArgs']] = None,
                 share_settings: Optional[pulumi.Input['ReservationShareSettingsArgs']] = None,
                 specific_reservation_required: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Reservation resource.
        :param pulumi.Input['ReservationSpecificReservationArgs'] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] zone: The zone where the reservation is made.
        :param pulumi.Input['ReservationDeleteAfterDurationArgs'] delete_after_duration: Duration after which the reservation will be auto-deleted by Compute Engine. Cannot be used with delete_at_time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] delete_at_time: Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
               Cannot be used with delete_after_duration.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.bool] enable_emergent_maintenance: Indicates if this group of VMs have emergent maintenance enabled.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ReservationReservationSharingPolicyArgs'] reservation_sharing_policy: Sharing policy for reservations with Google Cloud managed services.
               Structure is documented below.
        :param pulumi.Input['ReservationShareSettingsArgs'] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        """
        pulumi.set(__self__, "specific_reservation", specific_reservation)
        pulumi.set(__self__, "zone", zone)
        if delete_after_duration is not None:
            pulumi.set(__self__, "delete_after_duration", delete_after_duration)
        if delete_at_time is not None:
            pulumi.set(__self__, "delete_at_time", delete_at_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_emergent_maintenance is not None:
            pulumi.set(__self__, "enable_emergent_maintenance", enable_emergent_maintenance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reservation_sharing_policy is not None:
            pulumi.set(__self__, "reservation_sharing_policy", reservation_sharing_policy)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_reservation_required is not None:
            pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)

    @_builtins.property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> pulumi.Input['ReservationSpecificReservationArgs']:
        """
        Reservation for instances with specific machine shapes.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_reservation")

    @specific_reservation.setter
    def specific_reservation(self, value: pulumi.Input['ReservationSpecificReservationArgs']):
        pulumi.set(self, "specific_reservation", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Input[_builtins.str]:
        """
        The zone where the reservation is made.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "zone", value)

    @_builtins.property
    @pulumi.getter(name="deleteAfterDuration")
    def delete_after_duration(self) -> Optional[pulumi.Input['ReservationDeleteAfterDurationArgs']]:
        """
        Duration after which the reservation will be auto-deleted by Compute Engine. Cannot be used with delete_at_time.
        Structure is documented below.
        """
        return pulumi.get(self, "delete_after_duration")

    @delete_after_duration.setter
    def delete_after_duration(self, value: Optional[pulumi.Input['ReservationDeleteAfterDurationArgs']]):
        pulumi.set(self, "delete_after_duration", value)

    @_builtins.property
    @pulumi.getter(name="deleteAtTime")
    def delete_at_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
        Cannot be used with delete_after_duration.
        """
        return pulumi.get(self, "delete_at_time")

    @delete_at_time.setter
    def delete_at_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_at_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableEmergentMaintenance")
    def enable_emergent_maintenance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if this group of VMs have emergent maintenance enabled.
        """
        return pulumi.get(self, "enable_emergent_maintenance")

    @enable_emergent_maintenance.setter
    def enable_emergent_maintenance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_emergent_maintenance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="reservationSharingPolicy")
    def reservation_sharing_policy(self) -> Optional[pulumi.Input['ReservationReservationSharingPolicyArgs']]:
        """
        Sharing policy for reservations with Google Cloud managed services.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_sharing_policy")

    @reservation_sharing_policy.setter
    def reservation_sharing_policy(self, value: Optional[pulumi.Input['ReservationReservationSharingPolicyArgs']]):
        pulumi.set(self, "reservation_sharing_policy", value)

    @_builtins.property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['ReservationShareSettingsArgs']]:
        """
        The share setting for reservations.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['ReservationShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @_builtins.property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, only VMs that target this reservation by name can
        consume this reservation. Otherwise, it can be consumed by VMs with
        affinity for any reservation. Defaults to false.
        """
        return pulumi.get(self, "specific_reservation_required")

    @specific_reservation_required.setter
    def specific_reservation_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "specific_reservation_required", value)


@pulumi.input_type
class _ReservationState:
    def __init__(__self__, *,
                 commitment: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_after_duration: Optional[pulumi.Input['ReservationDeleteAfterDurationArgs']] = None,
                 delete_at_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_emergent_maintenance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_sharing_policy: Optional[pulumi.Input['ReservationReservationSharingPolicyArgs']] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 share_settings: Optional[pulumi.Input['ReservationShareSettingsArgs']] = None,
                 specific_reservation: Optional[pulumi.Input['ReservationSpecificReservationArgs']] = None,
                 specific_reservation_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Reservation resources.
        :param pulumi.Input[_builtins.str] commitment: Full or partial URL to a parent commitment. This field displays for
               reservations that are tied to a commitment.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input['ReservationDeleteAfterDurationArgs'] delete_after_duration: Duration after which the reservation will be auto-deleted by Compute Engine. Cannot be used with delete_at_time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] delete_at_time: Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
               Cannot be used with delete_after_duration.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.bool] enable_emergent_maintenance: Indicates if this group of VMs have emergent maintenance enabled.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ReservationReservationSharingPolicyArgs'] reservation_sharing_policy: Sharing policy for reservations with Google Cloud managed services.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['ReservationShareSettingsArgs'] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input['ReservationSpecificReservationArgs'] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        :param pulumi.Input[_builtins.str] status: The status of the reservation.
        :param pulumi.Input[_builtins.str] zone: The zone where the reservation is made.
        """
        if commitment is not None:
            pulumi.set(__self__, "commitment", commitment)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if delete_after_duration is not None:
            pulumi.set(__self__, "delete_after_duration", delete_after_duration)
        if delete_at_time is not None:
            pulumi.set(__self__, "delete_at_time", delete_at_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_emergent_maintenance is not None:
            pulumi.set(__self__, "enable_emergent_maintenance", enable_emergent_maintenance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reservation_sharing_policy is not None:
            pulumi.set(__self__, "reservation_sharing_policy", reservation_sharing_policy)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if share_settings is not None:
            pulumi.set(__self__, "share_settings", share_settings)
        if specific_reservation is not None:
            pulumi.set(__self__, "specific_reservation", specific_reservation)
        if specific_reservation_required is not None:
            pulumi.set(__self__, "specific_reservation_required", specific_reservation_required)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter
    def commitment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full or partial URL to a parent commitment. This field displays for
        reservations that are tied to a commitment.
        """
        return pulumi.get(self, "commitment")

    @commitment.setter
    def commitment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commitment", value)

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="deleteAfterDuration")
    def delete_after_duration(self) -> Optional[pulumi.Input['ReservationDeleteAfterDurationArgs']]:
        """
        Duration after which the reservation will be auto-deleted by Compute Engine. Cannot be used with delete_at_time.
        Structure is documented below.
        """
        return pulumi.get(self, "delete_after_duration")

    @delete_after_duration.setter
    def delete_after_duration(self, value: Optional[pulumi.Input['ReservationDeleteAfterDurationArgs']]):
        pulumi.set(self, "delete_after_duration", value)

    @_builtins.property
    @pulumi.getter(name="deleteAtTime")
    def delete_at_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
        Cannot be used with delete_after_duration.
        """
        return pulumi.get(self, "delete_at_time")

    @delete_at_time.setter
    def delete_at_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_at_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableEmergentMaintenance")
    def enable_emergent_maintenance(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates if this group of VMs have emergent maintenance enabled.
        """
        return pulumi.get(self, "enable_emergent_maintenance")

    @enable_emergent_maintenance.setter
    def enable_emergent_maintenance(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_emergent_maintenance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="reservationSharingPolicy")
    def reservation_sharing_policy(self) -> Optional[pulumi.Input['ReservationReservationSharingPolicyArgs']]:
        """
        Sharing policy for reservations with Google Cloud managed services.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_sharing_policy")

    @reservation_sharing_policy.setter
    def reservation_sharing_policy(self, value: Optional[pulumi.Input['ReservationReservationSharingPolicyArgs']]):
        pulumi.set(self, "reservation_sharing_policy", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> Optional[pulumi.Input['ReservationShareSettingsArgs']]:
        """
        The share setting for reservations.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @share_settings.setter
    def share_settings(self, value: Optional[pulumi.Input['ReservationShareSettingsArgs']]):
        pulumi.set(self, "share_settings", value)

    @_builtins.property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> Optional[pulumi.Input['ReservationSpecificReservationArgs']]:
        """
        Reservation for instances with specific machine shapes.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_reservation")

    @specific_reservation.setter
    def specific_reservation(self, value: Optional[pulumi.Input['ReservationSpecificReservationArgs']]):
        pulumi.set(self, "specific_reservation", value)

    @_builtins.property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When set to true, only VMs that target this reservation by name can
        consume this reservation. Otherwise, it can be consumed by VMs with
        affinity for any reservation. Defaults to false.
        """
        return pulumi.get(self, "specific_reservation_required")

    @specific_reservation_required.setter
    def specific_reservation_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "specific_reservation_required", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the reservation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone where the reservation is made.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/reservation:Reservation")
class Reservation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_after_duration: Optional[pulumi.Input[Union['ReservationDeleteAfterDurationArgs', 'ReservationDeleteAfterDurationArgsDict']]] = None,
                 delete_at_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_emergent_maintenance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_sharing_policy: Optional[pulumi.Input[Union['ReservationReservationSharingPolicyArgs', 'ReservationReservationSharingPolicyArgsDict']]] = None,
                 share_settings: Optional[pulumi.Input[Union['ReservationShareSettingsArgs', 'ReservationShareSettingsArgsDict']]] = None,
                 specific_reservation: Optional[pulumi.Input[Union['ReservationSpecificReservationArgs', 'ReservationSpecificReservationArgsDict']]] = None,
                 specific_reservation_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Represents a reservation resource. A reservation ensures that capacity is
        held in a specific zone even if the reserved VMs are not running.

        Reservations apply only to Compute Engine, Cloud Dataproc, and Google
        Kubernetes Engine VM usage.Reservations do not apply to `f1-micro` or
        `g1-small` machine types, preemptible VMs, sole tenant nodes, or other
        services not listed above
        like Cloud SQL and Dataflow.

        To get more information about Reservation, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/reservations)
        * How-to Guides
            * [Reserving zonal resources](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)

        ## Example Usage

        ### Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_reservation = gcp.compute.Reservation("gce_reservation",
            name="gce-reservation",
            zone="us-central1-a",
            specific_reservation={
                "count": 1,
                "instance_properties": {
                    "min_cpu_platform": "Intel Cascade Lake",
                    "machine_type": "n2-standard-2",
                },
            })
        ```
        ### Reservation Basic Beta

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_reservation = gcp.compute.Reservation("gce_reservation",
            name="gce-reservation",
            zone="us-central1-a",
            specific_reservation={
                "count": 1,
                "instance_properties": {
                    "min_cpu_platform": "Intel Cascade Lake",
                    "machine_type": "n2-standard-2",
                    "maintenance_interval": "PERIODIC",
                },
            },
            enable_emergent_maintenance=True)
        ```
        ### Reservation Source Instance Template

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        foobar = gcp.compute.InstanceTemplate("foobar",
            name="tf-test-instance-template",
            machine_type="n2-standard-2",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[{
                "source_image": my_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            network_interfaces=[{
                "network": "default",
            }],
            scheduling={
                "preemptible": False,
                "automatic_restart": True,
            },
            metadata={
                "foo": "bar",
            },
            service_account={
                "scopes": [
                    "userinfo-email",
                    "compute-ro",
                    "storage-ro",
                ],
            },
            labels={
                "my_label": "foobar",
            })
        gce_reservation_source_instance_template = gcp.compute.Reservation("gce_reservation_source_instance_template",
            name="gce-reservation-source-instance-template",
            zone="us-central1-a",
            specific_reservation={
                "count": 1,
                "source_instance_template": foobar.self_link,
            })
        ```
        ### Reservation Sharing Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        foobar = gcp.compute.InstanceTemplate("foobar",
            name="tf-test-instance-template",
            machine_type="g2-standard-4",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[{
                "source_image": my_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            network_interfaces=[{
                "network": "default",
            }],
            scheduling={
                "preemptible": False,
                "automatic_restart": True,
            },
            metadata={
                "foo": "bar",
            },
            service_account={
                "scopes": [
                    "userinfo-email",
                    "compute-ro",
                    "storage-ro",
                ],
            },
            labels={
                "my_label": "foobar",
            })
        gce_reservation_sharing_policy = gcp.compute.Reservation("gce_reservation_sharing_policy",
            name="gce-reservation-sharing-policy",
            zone="us-central1-b",
            specific_reservation={
                "count": 2,
                "source_instance_template": foobar.self_link,
            },
            reservation_sharing_policy={
                "service_share_type": "ALLOW_ALL",
            })
        ```

        ## Import

        Reservation can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/reservations/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Reservation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default projects/{{project}}/zones/{{zone}}/reservations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ReservationDeleteAfterDurationArgs', 'ReservationDeleteAfterDurationArgsDict']] delete_after_duration: Duration after which the reservation will be auto-deleted by Compute Engine. Cannot be used with delete_at_time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] delete_at_time: Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
               Cannot be used with delete_after_duration.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.bool] enable_emergent_maintenance: Indicates if this group of VMs have emergent maintenance enabled.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ReservationReservationSharingPolicyArgs', 'ReservationReservationSharingPolicyArgsDict']] reservation_sharing_policy: Sharing policy for reservations with Google Cloud managed services.
               Structure is documented below.
        :param pulumi.Input[Union['ReservationShareSettingsArgs', 'ReservationShareSettingsArgsDict']] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input[Union['ReservationSpecificReservationArgs', 'ReservationSpecificReservationArgsDict']] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        :param pulumi.Input[_builtins.str] zone: The zone where the reservation is made.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReservationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a reservation resource. A reservation ensures that capacity is
        held in a specific zone even if the reserved VMs are not running.

        Reservations apply only to Compute Engine, Cloud Dataproc, and Google
        Kubernetes Engine VM usage.Reservations do not apply to `f1-micro` or
        `g1-small` machine types, preemptible VMs, sole tenant nodes, or other
        services not listed above
        like Cloud SQL and Dataflow.

        To get more information about Reservation, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/reservations)
        * How-to Guides
            * [Reserving zonal resources](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources)

        ## Example Usage

        ### Reservation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_reservation = gcp.compute.Reservation("gce_reservation",
            name="gce-reservation",
            zone="us-central1-a",
            specific_reservation={
                "count": 1,
                "instance_properties": {
                    "min_cpu_platform": "Intel Cascade Lake",
                    "machine_type": "n2-standard-2",
                },
            })
        ```
        ### Reservation Basic Beta

        ```python
        import pulumi
        import pulumi_gcp as gcp

        gce_reservation = gcp.compute.Reservation("gce_reservation",
            name="gce-reservation",
            zone="us-central1-a",
            specific_reservation={
                "count": 1,
                "instance_properties": {
                    "min_cpu_platform": "Intel Cascade Lake",
                    "machine_type": "n2-standard-2",
                    "maintenance_interval": "PERIODIC",
                },
            },
            enable_emergent_maintenance=True)
        ```
        ### Reservation Source Instance Template

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        foobar = gcp.compute.InstanceTemplate("foobar",
            name="tf-test-instance-template",
            machine_type="n2-standard-2",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[{
                "source_image": my_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            network_interfaces=[{
                "network": "default",
            }],
            scheduling={
                "preemptible": False,
                "automatic_restart": True,
            },
            metadata={
                "foo": "bar",
            },
            service_account={
                "scopes": [
                    "userinfo-email",
                    "compute-ro",
                    "storage-ro",
                ],
            },
            labels={
                "my_label": "foobar",
            })
        gce_reservation_source_instance_template = gcp.compute.Reservation("gce_reservation_source_instance_template",
            name="gce-reservation-source-instance-template",
            zone="us-central1-a",
            specific_reservation={
                "count": 1,
                "source_instance_template": foobar.self_link,
            })
        ```
        ### Reservation Sharing Policy

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_image = gcp.compute.get_image(family="debian-11",
            project="debian-cloud")
        foobar = gcp.compute.InstanceTemplate("foobar",
            name="tf-test-instance-template",
            machine_type="g2-standard-4",
            can_ip_forward=False,
            tags=[
                "foo",
                "bar",
            ],
            disks=[{
                "source_image": my_image.self_link,
                "auto_delete": True,
                "boot": True,
            }],
            network_interfaces=[{
                "network": "default",
            }],
            scheduling={
                "preemptible": False,
                "automatic_restart": True,
            },
            metadata={
                "foo": "bar",
            },
            service_account={
                "scopes": [
                    "userinfo-email",
                    "compute-ro",
                    "storage-ro",
                ],
            },
            labels={
                "my_label": "foobar",
            })
        gce_reservation_sharing_policy = gcp.compute.Reservation("gce_reservation_sharing_policy",
            name="gce-reservation-sharing-policy",
            zone="us-central1-b",
            specific_reservation={
                "count": 2,
                "source_instance_template": foobar.self_link,
            },
            reservation_sharing_policy={
                "service_share_type": "ALLOW_ALL",
            })
        ```

        ## Import

        Reservation can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/reservations/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Reservation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default projects/{{project}}/zones/{{zone}}/reservations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default {{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/reservation:Reservation default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ReservationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReservationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delete_after_duration: Optional[pulumi.Input[Union['ReservationDeleteAfterDurationArgs', 'ReservationDeleteAfterDurationArgsDict']]] = None,
                 delete_at_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_emergent_maintenance: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_sharing_policy: Optional[pulumi.Input[Union['ReservationReservationSharingPolicyArgs', 'ReservationReservationSharingPolicyArgsDict']]] = None,
                 share_settings: Optional[pulumi.Input[Union['ReservationShareSettingsArgs', 'ReservationShareSettingsArgsDict']]] = None,
                 specific_reservation: Optional[pulumi.Input[Union['ReservationSpecificReservationArgs', 'ReservationSpecificReservationArgsDict']]] = None,
                 specific_reservation_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReservationArgs.__new__(ReservationArgs)

            __props__.__dict__["delete_after_duration"] = delete_after_duration
            __props__.__dict__["delete_at_time"] = delete_at_time
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_emergent_maintenance"] = enable_emergent_maintenance
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["reservation_sharing_policy"] = reservation_sharing_policy
            __props__.__dict__["share_settings"] = share_settings
            if specific_reservation is None and not opts.urn:
                raise TypeError("Missing required property 'specific_reservation'")
            __props__.__dict__["specific_reservation"] = specific_reservation
            __props__.__dict__["specific_reservation_required"] = specific_reservation_required
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__.__dict__["zone"] = zone
            __props__.__dict__["commitment"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["status"] = None
        super(Reservation, __self__).__init__(
            'gcp:compute/reservation:Reservation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            commitment: Optional[pulumi.Input[_builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            delete_after_duration: Optional[pulumi.Input[Union['ReservationDeleteAfterDurationArgs', 'ReservationDeleteAfterDurationArgsDict']]] = None,
            delete_at_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_emergent_maintenance: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_sharing_policy: Optional[pulumi.Input[Union['ReservationReservationSharingPolicyArgs', 'ReservationReservationSharingPolicyArgsDict']]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            share_settings: Optional[pulumi.Input[Union['ReservationShareSettingsArgs', 'ReservationShareSettingsArgsDict']]] = None,
            specific_reservation: Optional[pulumi.Input[Union['ReservationSpecificReservationArgs', 'ReservationSpecificReservationArgsDict']]] = None,
            specific_reservation_required: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Reservation':
        """
        Get an existing Reservation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] commitment: Full or partial URL to a parent commitment. This field displays for
               reservations that are tied to a commitment.
        :param pulumi.Input[_builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Union['ReservationDeleteAfterDurationArgs', 'ReservationDeleteAfterDurationArgsDict']] delete_after_duration: Duration after which the reservation will be auto-deleted by Compute Engine. Cannot be used with delete_at_time.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] delete_at_time: Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
               Cannot be used with delete_after_duration.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[_builtins.bool] enable_emergent_maintenance: Indicates if this group of VMs have emergent maintenance enabled.
        :param pulumi.Input[_builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ReservationReservationSharingPolicyArgs', 'ReservationReservationSharingPolicyArgsDict']] reservation_sharing_policy: Sharing policy for reservations with Google Cloud managed services.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['ReservationShareSettingsArgs', 'ReservationShareSettingsArgsDict']] share_settings: The share setting for reservations.
               Structure is documented below.
        :param pulumi.Input[Union['ReservationSpecificReservationArgs', 'ReservationSpecificReservationArgsDict']] specific_reservation: Reservation for instances with specific machine shapes.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] specific_reservation_required: When set to true, only VMs that target this reservation by name can
               consume this reservation. Otherwise, it can be consumed by VMs with
               affinity for any reservation. Defaults to false.
        :param pulumi.Input[_builtins.str] status: The status of the reservation.
        :param pulumi.Input[_builtins.str] zone: The zone where the reservation is made.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReservationState.__new__(_ReservationState)

        __props__.__dict__["commitment"] = commitment
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["delete_after_duration"] = delete_after_duration
        __props__.__dict__["delete_at_time"] = delete_at_time
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_emergent_maintenance"] = enable_emergent_maintenance
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["reservation_sharing_policy"] = reservation_sharing_policy
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["share_settings"] = share_settings
        __props__.__dict__["specific_reservation"] = specific_reservation
        __props__.__dict__["specific_reservation_required"] = specific_reservation_required
        __props__.__dict__["status"] = status
        __props__.__dict__["zone"] = zone
        return Reservation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def commitment(self) -> pulumi.Output[_builtins.str]:
        """
        Full or partial URL to a parent commitment. This field displays for
        reservations that are tied to a commitment.
        """
        return pulumi.get(self, "commitment")

    @_builtins.property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDuration")
    def delete_after_duration(self) -> pulumi.Output[Optional['outputs.ReservationDeleteAfterDuration']]:
        """
        Duration after which the reservation will be auto-deleted by Compute Engine. Cannot be used with delete_at_time.
        Structure is documented below.
        """
        return pulumi.get(self, "delete_after_duration")

    @_builtins.property
    @pulumi.getter(name="deleteAtTime")
    def delete_at_time(self) -> pulumi.Output[_builtins.str]:
        """
        Absolute time in future when the reservation will be auto-deleted by Compute Engine. Timestamp is represented in RFC3339 text format.
        Cannot be used with delete_after_duration.
        """
        return pulumi.get(self, "delete_at_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableEmergentMaintenance")
    def enable_emergent_maintenance(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates if this group of VMs have emergent maintenance enabled.
        """
        return pulumi.get(self, "enable_emergent_maintenance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="reservationSharingPolicy")
    def reservation_sharing_policy(self) -> pulumi.Output['outputs.ReservationReservationSharingPolicy']:
        """
        Sharing policy for reservations with Google Cloud managed services.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_sharing_policy")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="shareSettings")
    def share_settings(self) -> pulumi.Output['outputs.ReservationShareSettings']:
        """
        The share setting for reservations.
        Structure is documented below.
        """
        return pulumi.get(self, "share_settings")

    @_builtins.property
    @pulumi.getter(name="specificReservation")
    def specific_reservation(self) -> pulumi.Output['outputs.ReservationSpecificReservation']:
        """
        Reservation for instances with specific machine shapes.
        Structure is documented below.
        """
        return pulumi.get(self, "specific_reservation")

    @_builtins.property
    @pulumi.getter(name="specificReservationRequired")
    def specific_reservation_required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When set to true, only VMs that target this reservation by name can
        consume this reservation. Otherwise, it can be consumed by VMs with
        affinity for any reservation. Defaults to false.
        """
        return pulumi.get(self, "specific_reservation_required")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the reservation.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        """
        The zone where the reservation is made.
        """
        return pulumi.get(self, "zone")

