# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedZoneArgs', 'ManagedZone']

@pulumi.input_type
class ManagedZoneArgs:
    def __init__(__self__, *,
                 dns_name: pulumi.Input[_builtins.str],
                 cloud_logging_config: Optional[pulumi.Input['ManagedZoneCloudLoggingConfigArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dnssec_config: Optional[pulumi.Input['ManagedZoneDnssecConfigArgs']] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_config: Optional[pulumi.Input['ManagedZoneForwardingConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_config: Optional[pulumi.Input['ManagedZonePeeringConfigArgs']] = None,
                 private_visibility_config: Optional[pulumi.Input['ManagedZonePrivateVisibilityConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_directory_config: Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigArgs']] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedZone resource.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name of this managed zone, for instance "example.com.".
        :param pulumi.Input['ManagedZoneCloudLoggingConfigArgs'] cloud_logging_config: Cloud logging configuration
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A textual description field. Defaults to 'Managed by Pulumi'.
        :param pulumi.Input['ManagedZoneDnssecConfigArgs'] dnssec_config: DNSSEC configuration
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_destroy: Set this true to delete all records in the zone.
        :param pulumi.Input['ManagedZoneForwardingConfigArgs'] forwarding_config: The presence for this field indicates that outbound forwarding is enabled
               for this zone. The value of this field contains the set of destinations
               to forward to.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this ManagedZone.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: User assigned name for this resource.
               Must be unique within the project.
        :param pulumi.Input['ManagedZonePeeringConfigArgs'] peering_config: The presence of this field indicates that DNS Peering is enabled for this
               zone. The value of this field contains the network to peer with.
               Structure is documented below.
        :param pulumi.Input['ManagedZonePrivateVisibilityConfigArgs'] private_visibility_config: For privately visible zones, the set of Virtual Private Cloud
               resources that the zone is visible from. At least one of `gke_clusters` or `networks` must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] reverse_lookup: Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
               lookup queries using automatically configured records for VPC resources. This only applies
               to networks listed under `private_visibility_config`.
        :param pulumi.Input['ManagedZoneServiceDirectoryConfigArgs'] service_directory_config: The presence of this field indicates that this zone is backed by Service Directory. The value of this field contains information related to the namespace associated with the zone.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] visibility: The zone's visibility: public zones are exposed to the Internet,
               while private zones are visible only to Virtual Private Cloud resources.
               Default value is `public`.
               Possible values are: `private`, `public`.
        """
        pulumi.set(__self__, "dns_name", dns_name)
        if cloud_logging_config is not None:
            pulumi.set(__self__, "cloud_logging_config", cloud_logging_config)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dnssec_config is not None:
            pulumi.set(__self__, "dnssec_config", dnssec_config)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if forwarding_config is not None:
            pulumi.set(__self__, "forwarding_config", forwarding_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peering_config is not None:
            pulumi.set(__self__, "peering_config", peering_config)
        if private_visibility_config is not None:
            pulumi.set(__self__, "private_visibility_config", private_visibility_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reverse_lookup is not None:
            pulumi.set(__self__, "reverse_lookup", reverse_lookup)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Input[_builtins.str]:
        """
        The DNS name of this managed zone, for instance "example.com.".
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="cloudLoggingConfig")
    def cloud_logging_config(self) -> Optional[pulumi.Input['ManagedZoneCloudLoggingConfigArgs']]:
        """
        Cloud logging configuration
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_logging_config")

    @cloud_logging_config.setter
    def cloud_logging_config(self, value: Optional[pulumi.Input['ManagedZoneCloudLoggingConfigArgs']]):
        pulumi.set(self, "cloud_logging_config", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A textual description field. Defaults to 'Managed by Pulumi'.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnssecConfig")
    def dnssec_config(self) -> Optional[pulumi.Input['ManagedZoneDnssecConfigArgs']]:
        """
        DNSSEC configuration
        Structure is documented below.
        """
        return pulumi.get(self, "dnssec_config")

    @dnssec_config.setter
    def dnssec_config(self, value: Optional[pulumi.Input['ManagedZoneDnssecConfigArgs']]):
        pulumi.set(self, "dnssec_config", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this true to delete all records in the zone.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forwardingConfig")
    def forwarding_config(self) -> Optional[pulumi.Input['ManagedZoneForwardingConfigArgs']]:
        """
        The presence for this field indicates that outbound forwarding is enabled
        for this zone. The value of this field contains the set of destinations
        to forward to.
        Structure is documented below.
        """
        return pulumi.get(self, "forwarding_config")

    @forwarding_config.setter
    def forwarding_config(self, value: Optional[pulumi.Input['ManagedZoneForwardingConfigArgs']]):
        pulumi.set(self, "forwarding_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to this ManagedZone.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User assigned name for this resource.
        Must be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peeringConfig")
    def peering_config(self) -> Optional[pulumi.Input['ManagedZonePeeringConfigArgs']]:
        """
        The presence of this field indicates that DNS Peering is enabled for this
        zone. The value of this field contains the network to peer with.
        Structure is documented below.
        """
        return pulumi.get(self, "peering_config")

    @peering_config.setter
    def peering_config(self, value: Optional[pulumi.Input['ManagedZonePeeringConfigArgs']]):
        pulumi.set(self, "peering_config", value)

    @_builtins.property
    @pulumi.getter(name="privateVisibilityConfig")
    def private_visibility_config(self) -> Optional[pulumi.Input['ManagedZonePrivateVisibilityConfigArgs']]:
        """
        For privately visible zones, the set of Virtual Private Cloud
        resources that the zone is visible from. At least one of `gke_clusters` or `networks` must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "private_visibility_config")

    @private_visibility_config.setter
    def private_visibility_config(self, value: Optional[pulumi.Input['ManagedZonePrivateVisibilityConfigArgs']]):
        pulumi.set(self, "private_visibility_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="reverseLookup")
    def reverse_lookup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
        lookup queries using automatically configured records for VPC resources. This only applies
        to networks listed under `private_visibility_config`.
        """
        return pulumi.get(self, "reverse_lookup")

    @reverse_lookup.setter
    def reverse_lookup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reverse_lookup", value)

    @_builtins.property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigArgs']]:
        """
        The presence of this field indicates that this zone is backed by Service Directory. The value of this field contains information related to the namespace associated with the zone.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @service_directory_config.setter
    def service_directory_config(self, value: Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigArgs']]):
        pulumi.set(self, "service_directory_config", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone's visibility: public zones are exposed to the Internet,
        while private zones are visible only to Virtual Private Cloud resources.
        Default value is `public`.
        Possible values are: `private`, `public`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.input_type
class _ManagedZoneState:
    def __init__(__self__, *,
                 cloud_logging_config: Optional[pulumi.Input['ManagedZoneCloudLoggingConfigArgs']] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dnssec_config: Optional[pulumi.Input['ManagedZoneDnssecConfigArgs']] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_config: Optional[pulumi.Input['ManagedZoneForwardingConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 managed_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peering_config: Optional[pulumi.Input['ManagedZonePeeringConfigArgs']] = None,
                 private_visibility_config: Optional[pulumi.Input['ManagedZonePrivateVisibilityConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reverse_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_directory_config: Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigArgs']] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedZone resources.
        :param pulumi.Input['ManagedZoneCloudLoggingConfigArgs'] cloud_logging_config: Cloud logging configuration
               Structure is documented below.
        :param pulumi.Input[_builtins.str] creation_time: The time that this resource was created on the server.
               This is in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A textual description field. Defaults to 'Managed by Pulumi'.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name of this managed zone, for instance "example.com.".
        :param pulumi.Input['ManagedZoneDnssecConfigArgs'] dnssec_config: DNSSEC configuration
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] force_destroy: Set this true to delete all records in the zone.
        :param pulumi.Input['ManagedZoneForwardingConfigArgs'] forwarding_config: The presence for this field indicates that outbound forwarding is enabled
               for this zone. The value of this field contains the set of destinations
               to forward to.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this ManagedZone.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] managed_zone_id: Unique identifier for the resource; defined by the server.
        :param pulumi.Input[_builtins.str] name: User assigned name for this resource.
               Must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: Delegate your managed_zone to these virtual name servers;
               defined by the server
        :param pulumi.Input['ManagedZonePeeringConfigArgs'] peering_config: The presence of this field indicates that DNS Peering is enabled for this
               zone. The value of this field contains the network to peer with.
               Structure is documented below.
        :param pulumi.Input['ManagedZonePrivateVisibilityConfigArgs'] private_visibility_config: For privately visible zones, the set of Virtual Private Cloud
               resources that the zone is visible from. At least one of `gke_clusters` or `networks` must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reverse_lookup: Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
               lookup queries using automatically configured records for VPC resources. This only applies
               to networks listed under `private_visibility_config`.
        :param pulumi.Input['ManagedZoneServiceDirectoryConfigArgs'] service_directory_config: The presence of this field indicates that this zone is backed by Service Directory. The value of this field contains information related to the namespace associated with the zone.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] visibility: The zone's visibility: public zones are exposed to the Internet,
               while private zones are visible only to Virtual Private Cloud resources.
               Default value is `public`.
               Possible values are: `private`, `public`.
        """
        if cloud_logging_config is not None:
            pulumi.set(__self__, "cloud_logging_config", cloud_logging_config)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is None:
            description = 'Managed by Pulumi'
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if dnssec_config is not None:
            pulumi.set(__self__, "dnssec_config", dnssec_config)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if forwarding_config is not None:
            pulumi.set(__self__, "forwarding_config", forwarding_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if managed_zone_id is not None:
            pulumi.set(__self__, "managed_zone_id", managed_zone_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if peering_config is not None:
            pulumi.set(__self__, "peering_config", peering_config)
        if private_visibility_config is not None:
            pulumi.set(__self__, "private_visibility_config", private_visibility_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reverse_lookup is not None:
            pulumi.set(__self__, "reverse_lookup", reverse_lookup)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter(name="cloudLoggingConfig")
    def cloud_logging_config(self) -> Optional[pulumi.Input['ManagedZoneCloudLoggingConfigArgs']]:
        """
        Cloud logging configuration
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_logging_config")

    @cloud_logging_config.setter
    def cloud_logging_config(self, value: Optional[pulumi.Input['ManagedZoneCloudLoggingConfigArgs']]):
        pulumi.set(self, "cloud_logging_config", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time that this resource was created on the server.
        This is in RFC3339 text format.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A textual description field. Defaults to 'Managed by Pulumi'.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS name of this managed zone, for instance "example.com.".
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_name", value)

    @_builtins.property
    @pulumi.getter(name="dnssecConfig")
    def dnssec_config(self) -> Optional[pulumi.Input['ManagedZoneDnssecConfigArgs']]:
        """
        DNSSEC configuration
        Structure is documented below.
        """
        return pulumi.get(self, "dnssec_config")

    @dnssec_config.setter
    def dnssec_config(self, value: Optional[pulumi.Input['ManagedZoneDnssecConfigArgs']]):
        pulumi.set(self, "dnssec_config", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set this true to delete all records in the zone.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forwardingConfig")
    def forwarding_config(self) -> Optional[pulumi.Input['ManagedZoneForwardingConfigArgs']]:
        """
        The presence for this field indicates that outbound forwarding is enabled
        for this zone. The value of this field contains the set of destinations
        to forward to.
        Structure is documented below.
        """
        return pulumi.get(self, "forwarding_config")

    @forwarding_config.setter
    def forwarding_config(self, value: Optional[pulumi.Input['ManagedZoneForwardingConfigArgs']]):
        pulumi.set(self, "forwarding_config", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to this ManagedZone.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="managedZoneId")
    def managed_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique identifier for the resource; defined by the server.
        """
        return pulumi.get(self, "managed_zone_id")

    @managed_zone_id.setter
    def managed_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_zone_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User assigned name for this resource.
        Must be unique within the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Delegate your managed_zone to these virtual name servers;
        defined by the server
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "name_servers", value)

    @_builtins.property
    @pulumi.getter(name="peeringConfig")
    def peering_config(self) -> Optional[pulumi.Input['ManagedZonePeeringConfigArgs']]:
        """
        The presence of this field indicates that DNS Peering is enabled for this
        zone. The value of this field contains the network to peer with.
        Structure is documented below.
        """
        return pulumi.get(self, "peering_config")

    @peering_config.setter
    def peering_config(self, value: Optional[pulumi.Input['ManagedZonePeeringConfigArgs']]):
        pulumi.set(self, "peering_config", value)

    @_builtins.property
    @pulumi.getter(name="privateVisibilityConfig")
    def private_visibility_config(self) -> Optional[pulumi.Input['ManagedZonePrivateVisibilityConfigArgs']]:
        """
        For privately visible zones, the set of Virtual Private Cloud
        resources that the zone is visible from. At least one of `gke_clusters` or `networks` must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "private_visibility_config")

    @private_visibility_config.setter
    def private_visibility_config(self, value: Optional[pulumi.Input['ManagedZonePrivateVisibilityConfigArgs']]):
        pulumi.set(self, "private_visibility_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="reverseLookup")
    def reverse_lookup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
        lookup queries using automatically configured records for VPC resources. This only applies
        to networks listed under `private_visibility_config`.
        """
        return pulumi.get(self, "reverse_lookup")

    @reverse_lookup.setter
    def reverse_lookup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "reverse_lookup", value)

    @_builtins.property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigArgs']]:
        """
        The presence of this field indicates that this zone is backed by Service Directory. The value of this field contains information related to the namespace associated with the zone.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @service_directory_config.setter
    def service_directory_config(self, value: Optional[pulumi.Input['ManagedZoneServiceDirectoryConfigArgs']]):
        pulumi.set(self, "service_directory_config", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone's visibility: public zones are exposed to the Internet,
        while private zones are visible only to Virtual Private Cloud resources.
        Default value is `public`.
        Possible values are: `private`, `public`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)


@pulumi.type_token("gcp:dns/managedZone:ManagedZone")
class ManagedZone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_logging_config: Optional[pulumi.Input[Union['ManagedZoneCloudLoggingConfigArgs', 'ManagedZoneCloudLoggingConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dnssec_config: Optional[pulumi.Input[Union['ManagedZoneDnssecConfigArgs', 'ManagedZoneDnssecConfigArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_config: Optional[pulumi.Input[Union['ManagedZoneForwardingConfigArgs', 'ManagedZoneForwardingConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_config: Optional[pulumi.Input[Union['ManagedZonePeeringConfigArgs', 'ManagedZonePeeringConfigArgsDict']]] = None,
                 private_visibility_config: Optional[pulumi.Input[Union['ManagedZonePrivateVisibilityConfigArgs', 'ManagedZonePrivateVisibilityConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_directory_config: Optional[pulumi.Input[Union['ManagedZoneServiceDirectoryConfigArgs', 'ManagedZoneServiceDirectoryConfigArgsDict']]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A zone is a subtree of the DNS namespace under one administrative
        responsibility. A ManagedZone is a resource that represents a DNS zone
        hosted by the Cloud DNS service.

        To get more information about ManagedZone, see:

        * [API documentation](https://cloud.google.com/dns/api/v1/managedZones)
        * How-to Guides
            * [Managing Zones](https://cloud.google.com/dns/zones/)

        ## Example Usage

        ### Dns Managed Zone Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_zone = gcp.dns.ManagedZone("example-zone",
            name="example-zone",
            dns_name="my-domain.com.",
            description="Example DNS zone",
            labels={
                "foo": "bar",
            })
        ```
        ### Dns Managed Zone Private

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1",
            name="network-1",
            auto_create_subnetworks=False)
        network_2 = gcp.compute.Network("network-2",
            name="network-2",
            auto_create_subnetworks=False)
        private_zone = gcp.dns.ManagedZone("private-zone",
            name="private-zone",
            dns_name="private.example.com.",
            description="Example private DNS zone",
            labels={
                "foo": "bar",
            },
            visibility="private",
            private_visibility_config={
                "networks": [
                    {
                        "network_url": network_1.id,
                    },
                    {
                        "network_url": network_2.id,
                    },
                ],
            })
        ```
        ### Dns Managed Zone Private Forwarding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1",
            name="network-1",
            auto_create_subnetworks=False)
        network_2 = gcp.compute.Network("network-2",
            name="network-2",
            auto_create_subnetworks=False)
        private_zone = gcp.dns.ManagedZone("private-zone",
            name="private-zone",
            dns_name="private.example.com.",
            description="Example private DNS zone",
            labels={
                "foo": "bar",
            },
            visibility="private",
            private_visibility_config={
                "networks": [
                    {
                        "network_url": network_1.id,
                    },
                    {
                        "network_url": network_2.id,
                    },
                ],
            },
            forwarding_config={
                "target_name_servers": [
                    {
                        "ipv4_address": "172.16.1.10",
                    },
                    {
                        "ipv4_address": "172.16.1.20",
                    },
                ],
            })
        ```
        ### Dns Managed Zone Private Gke

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1",
            name="network-1",
            auto_create_subnetworks=False)
        subnetwork_1 = gcp.compute.Subnetwork("subnetwork-1",
            name=network_1.name,
            network=network_1.name,
            ip_cidr_range="10.0.36.0/24",
            region="us-central1",
            private_ip_google_access=True,
            secondary_ip_ranges=[
                {
                    "range_name": "pod",
                    "ip_cidr_range": "10.0.0.0/19",
                },
                {
                    "range_name": "svc",
                    "ip_cidr_range": "10.0.32.0/22",
                },
            ])
        cluster_1 = gcp.container.Cluster("cluster-1",
            name="cluster-1",
            location="us-central1-c",
            initial_node_count=1,
            networking_mode="VPC_NATIVE",
            default_snat_status={
                "disabled": True,
            },
            network=network_1.name,
            subnetwork=subnetwork_1.name,
            private_cluster_config={
                "enable_private_endpoint": True,
                "enable_private_nodes": True,
                "master_ipv4_cidr_block": "10.42.0.0/28",
                "master_global_access_config": {
                    "enabled": True,
                },
            },
            master_authorized_networks_config={},
            ip_allocation_policy={
                "cluster_secondary_range_name": subnetwork_1.secondary_ip_ranges[0].range_name,
                "services_secondary_range_name": subnetwork_1.secondary_ip_ranges[1].range_name,
            },
            deletion_protection=True)
        private_zone_gke = gcp.dns.ManagedZone("private-zone-gke",
            name="private-zone",
            dns_name="private.example.com.",
            description="Example private DNS zone",
            labels={
                "foo": "bar",
            },
            visibility="private",
            private_visibility_config={
                "gke_clusters": [{
                    "gke_cluster_name": cluster_1.id,
                }],
            })
        ```
        ### Dns Managed Zone Private Peering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_source = gcp.compute.Network("network-source",
            name="network-source",
            auto_create_subnetworks=False)
        network_target = gcp.compute.Network("network-target",
            name="network-target",
            auto_create_subnetworks=False)
        peering_zone = gcp.dns.ManagedZone("peering-zone",
            name="peering-zone",
            dns_name="peering.example.com.",
            description="Example private DNS peering zone",
            visibility="private",
            private_visibility_config={
                "networks": [{
                    "network_url": network_source.id,
                }],
            },
            peering_config={
                "target_network": {
                    "network_url": network_target.id,
                },
            })
        ```
        ### Dns Managed Zone Service Directory

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.servicedirectory.Namespace("example",
            namespace_id="example",
            location="us-central1")
        sd_zone = gcp.dns.ManagedZone("sd-zone",
            name="peering-zone",
            dns_name="services.example.com.",
            description="Example private DNS Service Directory zone",
            visibility="private",
            service_directory_config={
                "namespace": {
                    "namespace_url": example.id,
                },
            })
        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        ```
        ### Dns Managed Zone Cloud Logging

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloud_logging_enabled_zone = gcp.dns.ManagedZone("cloud-logging-enabled-zone",
            name="cloud-logging-enabled-zone",
            dns_name="services.example.com.",
            description="Example cloud logging enabled DNS zone",
            labels={
                "foo": "bar",
            },
            cloud_logging_config={
                "enable_logging": True,
            })
        ```

        ## Import

        ManagedZone can be imported using any of these accepted formats:

        * `projects/{{project}}/managedZones/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ManagedZone can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dns/managedZone:ManagedZone default projects/{{project}}/managedZones/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dns/managedZone:ManagedZone default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dns/managedZone:ManagedZone default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagedZoneCloudLoggingConfigArgs', 'ManagedZoneCloudLoggingConfigArgsDict']] cloud_logging_config: Cloud logging configuration
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: A textual description field. Defaults to 'Managed by Pulumi'.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name of this managed zone, for instance "example.com.".
        :param pulumi.Input[Union['ManagedZoneDnssecConfigArgs', 'ManagedZoneDnssecConfigArgsDict']] dnssec_config: DNSSEC configuration
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_destroy: Set this true to delete all records in the zone.
        :param pulumi.Input[Union['ManagedZoneForwardingConfigArgs', 'ManagedZoneForwardingConfigArgsDict']] forwarding_config: The presence for this field indicates that outbound forwarding is enabled
               for this zone. The value of this field contains the set of destinations
               to forward to.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this ManagedZone.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: User assigned name for this resource.
               Must be unique within the project.
        :param pulumi.Input[Union['ManagedZonePeeringConfigArgs', 'ManagedZonePeeringConfigArgsDict']] peering_config: The presence of this field indicates that DNS Peering is enabled for this
               zone. The value of this field contains the network to peer with.
               Structure is documented below.
        :param pulumi.Input[Union['ManagedZonePrivateVisibilityConfigArgs', 'ManagedZonePrivateVisibilityConfigArgsDict']] private_visibility_config: For privately visible zones, the set of Virtual Private Cloud
               resources that the zone is visible from. At least one of `gke_clusters` or `networks` must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.bool] reverse_lookup: Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
               lookup queries using automatically configured records for VPC resources. This only applies
               to networks listed under `private_visibility_config`.
        :param pulumi.Input[Union['ManagedZoneServiceDirectoryConfigArgs', 'ManagedZoneServiceDirectoryConfigArgsDict']] service_directory_config: The presence of this field indicates that this zone is backed by Service Directory. The value of this field contains information related to the namespace associated with the zone.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] visibility: The zone's visibility: public zones are exposed to the Internet,
               while private zones are visible only to Virtual Private Cloud resources.
               Default value is `public`.
               Possible values are: `private`, `public`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A zone is a subtree of the DNS namespace under one administrative
        responsibility. A ManagedZone is a resource that represents a DNS zone
        hosted by the Cloud DNS service.

        To get more information about ManagedZone, see:

        * [API documentation](https://cloud.google.com/dns/api/v1/managedZones)
        * How-to Guides
            * [Managing Zones](https://cloud.google.com/dns/zones/)

        ## Example Usage

        ### Dns Managed Zone Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_zone = gcp.dns.ManagedZone("example-zone",
            name="example-zone",
            dns_name="my-domain.com.",
            description="Example DNS zone",
            labels={
                "foo": "bar",
            })
        ```
        ### Dns Managed Zone Private

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1",
            name="network-1",
            auto_create_subnetworks=False)
        network_2 = gcp.compute.Network("network-2",
            name="network-2",
            auto_create_subnetworks=False)
        private_zone = gcp.dns.ManagedZone("private-zone",
            name="private-zone",
            dns_name="private.example.com.",
            description="Example private DNS zone",
            labels={
                "foo": "bar",
            },
            visibility="private",
            private_visibility_config={
                "networks": [
                    {
                        "network_url": network_1.id,
                    },
                    {
                        "network_url": network_2.id,
                    },
                ],
            })
        ```
        ### Dns Managed Zone Private Forwarding

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1",
            name="network-1",
            auto_create_subnetworks=False)
        network_2 = gcp.compute.Network("network-2",
            name="network-2",
            auto_create_subnetworks=False)
        private_zone = gcp.dns.ManagedZone("private-zone",
            name="private-zone",
            dns_name="private.example.com.",
            description="Example private DNS zone",
            labels={
                "foo": "bar",
            },
            visibility="private",
            private_visibility_config={
                "networks": [
                    {
                        "network_url": network_1.id,
                    },
                    {
                        "network_url": network_2.id,
                    },
                ],
            },
            forwarding_config={
                "target_name_servers": [
                    {
                        "ipv4_address": "172.16.1.10",
                    },
                    {
                        "ipv4_address": "172.16.1.20",
                    },
                ],
            })
        ```
        ### Dns Managed Zone Private Gke

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_1 = gcp.compute.Network("network-1",
            name="network-1",
            auto_create_subnetworks=False)
        subnetwork_1 = gcp.compute.Subnetwork("subnetwork-1",
            name=network_1.name,
            network=network_1.name,
            ip_cidr_range="10.0.36.0/24",
            region="us-central1",
            private_ip_google_access=True,
            secondary_ip_ranges=[
                {
                    "range_name": "pod",
                    "ip_cidr_range": "10.0.0.0/19",
                },
                {
                    "range_name": "svc",
                    "ip_cidr_range": "10.0.32.0/22",
                },
            ])
        cluster_1 = gcp.container.Cluster("cluster-1",
            name="cluster-1",
            location="us-central1-c",
            initial_node_count=1,
            networking_mode="VPC_NATIVE",
            default_snat_status={
                "disabled": True,
            },
            network=network_1.name,
            subnetwork=subnetwork_1.name,
            private_cluster_config={
                "enable_private_endpoint": True,
                "enable_private_nodes": True,
                "master_ipv4_cidr_block": "10.42.0.0/28",
                "master_global_access_config": {
                    "enabled": True,
                },
            },
            master_authorized_networks_config={},
            ip_allocation_policy={
                "cluster_secondary_range_name": subnetwork_1.secondary_ip_ranges[0].range_name,
                "services_secondary_range_name": subnetwork_1.secondary_ip_ranges[1].range_name,
            },
            deletion_protection=True)
        private_zone_gke = gcp.dns.ManagedZone("private-zone-gke",
            name="private-zone",
            dns_name="private.example.com.",
            description="Example private DNS zone",
            labels={
                "foo": "bar",
            },
            visibility="private",
            private_visibility_config={
                "gke_clusters": [{
                    "gke_cluster_name": cluster_1.id,
                }],
            })
        ```
        ### Dns Managed Zone Private Peering

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network_source = gcp.compute.Network("network-source",
            name="network-source",
            auto_create_subnetworks=False)
        network_target = gcp.compute.Network("network-target",
            name="network-target",
            auto_create_subnetworks=False)
        peering_zone = gcp.dns.ManagedZone("peering-zone",
            name="peering-zone",
            dns_name="peering.example.com.",
            description="Example private DNS peering zone",
            visibility="private",
            private_visibility_config={
                "networks": [{
                    "network_url": network_source.id,
                }],
            },
            peering_config={
                "target_network": {
                    "network_url": network_target.id,
                },
            })
        ```
        ### Dns Managed Zone Service Directory

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.servicedirectory.Namespace("example",
            namespace_id="example",
            location="us-central1")
        sd_zone = gcp.dns.ManagedZone("sd-zone",
            name="peering-zone",
            dns_name="services.example.com.",
            description="Example private DNS Service Directory zone",
            visibility="private",
            service_directory_config={
                "namespace": {
                    "namespace_url": example.id,
                },
            })
        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        ```
        ### Dns Managed Zone Cloud Logging

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cloud_logging_enabled_zone = gcp.dns.ManagedZone("cloud-logging-enabled-zone",
            name="cloud-logging-enabled-zone",
            dns_name="services.example.com.",
            description="Example cloud logging enabled DNS zone",
            labels={
                "foo": "bar",
            },
            cloud_logging_config={
                "enable_logging": True,
            })
        ```

        ## Import

        ManagedZone can be imported using any of these accepted formats:

        * `projects/{{project}}/managedZones/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ManagedZone can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dns/managedZone:ManagedZone default projects/{{project}}/managedZones/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dns/managedZone:ManagedZone default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dns/managedZone:ManagedZone default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ManagedZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_logging_config: Optional[pulumi.Input[Union['ManagedZoneCloudLoggingConfigArgs', 'ManagedZoneCloudLoggingConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dnssec_config: Optional[pulumi.Input[Union['ManagedZoneDnssecConfigArgs', 'ManagedZoneDnssecConfigArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 forwarding_config: Optional[pulumi.Input[Union['ManagedZoneForwardingConfigArgs', 'ManagedZoneForwardingConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_config: Optional[pulumi.Input[Union['ManagedZonePeeringConfigArgs', 'ManagedZonePeeringConfigArgsDict']]] = None,
                 private_visibility_config: Optional[pulumi.Input[Union['ManagedZonePrivateVisibilityConfigArgs', 'ManagedZonePrivateVisibilityConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_directory_config: Optional[pulumi.Input[Union['ManagedZoneServiceDirectoryConfigArgs', 'ManagedZoneServiceDirectoryConfigArgsDict']]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedZoneArgs.__new__(ManagedZoneArgs)

            __props__.__dict__["cloud_logging_config"] = cloud_logging_config
            if description is None:
                description = 'Managed by Pulumi'
            __props__.__dict__["description"] = description
            if dns_name is None and not opts.urn:
                raise TypeError("Missing required property 'dns_name'")
            __props__.__dict__["dns_name"] = dns_name
            __props__.__dict__["dnssec_config"] = dnssec_config
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["forwarding_config"] = forwarding_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["peering_config"] = peering_config
            __props__.__dict__["private_visibility_config"] = private_visibility_config
            __props__.__dict__["project"] = project
            __props__.__dict__["reverse_lookup"] = reverse_lookup
            __props__.__dict__["service_directory_config"] = service_directory_config
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["managed_zone_id"] = None
            __props__.__dict__["name_servers"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ManagedZone, __self__).__init__(
            'gcp:dns/managedZone:ManagedZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_logging_config: Optional[pulumi.Input[Union['ManagedZoneCloudLoggingConfigArgs', 'ManagedZoneCloudLoggingConfigArgsDict']]] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_name: Optional[pulumi.Input[_builtins.str]] = None,
            dnssec_config: Optional[pulumi.Input[Union['ManagedZoneDnssecConfigArgs', 'ManagedZoneDnssecConfigArgsDict']]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            forwarding_config: Optional[pulumi.Input[Union['ManagedZoneForwardingConfigArgs', 'ManagedZoneForwardingConfigArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            managed_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            peering_config: Optional[pulumi.Input[Union['ManagedZonePeeringConfigArgs', 'ManagedZonePeeringConfigArgsDict']]] = None,
            private_visibility_config: Optional[pulumi.Input[Union['ManagedZonePrivateVisibilityConfigArgs', 'ManagedZonePrivateVisibilityConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reverse_lookup: Optional[pulumi.Input[_builtins.bool]] = None,
            service_directory_config: Optional[pulumi.Input[Union['ManagedZoneServiceDirectoryConfigArgs', 'ManagedZoneServiceDirectoryConfigArgsDict']]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedZone':
        """
        Get an existing ManagedZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ManagedZoneCloudLoggingConfigArgs', 'ManagedZoneCloudLoggingConfigArgsDict']] cloud_logging_config: Cloud logging configuration
               Structure is documented below.
        :param pulumi.Input[_builtins.str] creation_time: The time that this resource was created on the server.
               This is in RFC3339 text format.
        :param pulumi.Input[_builtins.str] description: A textual description field. Defaults to 'Managed by Pulumi'.
        :param pulumi.Input[_builtins.str] dns_name: The DNS name of this managed zone, for instance "example.com.".
        :param pulumi.Input[Union['ManagedZoneDnssecConfigArgs', 'ManagedZoneDnssecConfigArgsDict']] dnssec_config: DNSSEC configuration
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] force_destroy: Set this true to delete all records in the zone.
        :param pulumi.Input[Union['ManagedZoneForwardingConfigArgs', 'ManagedZoneForwardingConfigArgsDict']] forwarding_config: The presence for this field indicates that outbound forwarding is enabled
               for this zone. The value of this field contains the set of destinations
               to forward to.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to this ManagedZone.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] managed_zone_id: Unique identifier for the resource; defined by the server.
        :param pulumi.Input[_builtins.str] name: User assigned name for this resource.
               Must be unique within the project.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] name_servers: Delegate your managed_zone to these virtual name servers;
               defined by the server
        :param pulumi.Input[Union['ManagedZonePeeringConfigArgs', 'ManagedZonePeeringConfigArgsDict']] peering_config: The presence of this field indicates that DNS Peering is enabled for this
               zone. The value of this field contains the network to peer with.
               Structure is documented below.
        :param pulumi.Input[Union['ManagedZonePrivateVisibilityConfigArgs', 'ManagedZonePrivateVisibilityConfigArgsDict']] private_visibility_config: For privately visible zones, the set of Virtual Private Cloud
               resources that the zone is visible from. At least one of `gke_clusters` or `networks` must be specified.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] reverse_lookup: Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
               lookup queries using automatically configured records for VPC resources. This only applies
               to networks listed under `private_visibility_config`.
        :param pulumi.Input[Union['ManagedZoneServiceDirectoryConfigArgs', 'ManagedZoneServiceDirectoryConfigArgsDict']] service_directory_config: The presence of this field indicates that this zone is backed by Service Directory. The value of this field contains information related to the namespace associated with the zone.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] visibility: The zone's visibility: public zones are exposed to the Internet,
               while private zones are visible only to Virtual Private Cloud resources.
               Default value is `public`.
               Possible values are: `private`, `public`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedZoneState.__new__(_ManagedZoneState)

        __props__.__dict__["cloud_logging_config"] = cloud_logging_config
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["dnssec_config"] = dnssec_config
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["forwarding_config"] = forwarding_config
        __props__.__dict__["labels"] = labels
        __props__.__dict__["managed_zone_id"] = managed_zone_id
        __props__.__dict__["name"] = name
        __props__.__dict__["name_servers"] = name_servers
        __props__.__dict__["peering_config"] = peering_config
        __props__.__dict__["private_visibility_config"] = private_visibility_config
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reverse_lookup"] = reverse_lookup
        __props__.__dict__["service_directory_config"] = service_directory_config
        __props__.__dict__["visibility"] = visibility
        return ManagedZone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudLoggingConfig")
    def cloud_logging_config(self) -> pulumi.Output['outputs.ManagedZoneCloudLoggingConfig']:
        """
        Cloud logging configuration
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_logging_config")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time that this resource was created on the server.
        This is in RFC3339 text format.
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        A textual description field. Defaults to 'Managed by Pulumi'.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS name of this managed zone, for instance "example.com.".
        """
        return pulumi.get(self, "dns_name")

    @_builtins.property
    @pulumi.getter(name="dnssecConfig")
    def dnssec_config(self) -> pulumi.Output['outputs.ManagedZoneDnssecConfig']:
        """
        DNSSEC configuration
        Structure is documented below.
        """
        return pulumi.get(self, "dnssec_config")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set this true to delete all records in the zone.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="forwardingConfig")
    def forwarding_config(self) -> pulumi.Output[Optional['outputs.ManagedZoneForwardingConfig']]:
        """
        The presence for this field indicates that outbound forwarding is enabled
        for this zone. The value of this field contains the set of destinations
        to forward to.
        Structure is documented below.
        """
        return pulumi.get(self, "forwarding_config")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs to assign to this ManagedZone.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="managedZoneId")
    def managed_zone_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique identifier for the resource; defined by the server.
        """
        return pulumi.get(self, "managed_zone_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        User assigned name for this resource.
        Must be unique within the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Delegate your managed_zone to these virtual name servers;
        defined by the server
        """
        return pulumi.get(self, "name_servers")

    @_builtins.property
    @pulumi.getter(name="peeringConfig")
    def peering_config(self) -> pulumi.Output[Optional['outputs.ManagedZonePeeringConfig']]:
        """
        The presence of this field indicates that DNS Peering is enabled for this
        zone. The value of this field contains the network to peer with.
        Structure is documented below.
        """
        return pulumi.get(self, "peering_config")

    @_builtins.property
    @pulumi.getter(name="privateVisibilityConfig")
    def private_visibility_config(self) -> pulumi.Output[Optional['outputs.ManagedZonePrivateVisibilityConfig']]:
        """
        For privately visible zones, the set of Virtual Private Cloud
        resources that the zone is visible from. At least one of `gke_clusters` or `networks` must be specified.
        Structure is documented below.
        """
        return pulumi.get(self, "private_visibility_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="reverseLookup")
    def reverse_lookup(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if this is a managed reverse lookup zone. If true, Cloud DNS will resolve reverse
        lookup queries using automatically configured records for VPC resources. This only applies
        to networks listed under `private_visibility_config`.
        """
        return pulumi.get(self, "reverse_lookup")

    @_builtins.property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> pulumi.Output[Optional['outputs.ManagedZoneServiceDirectoryConfig']]:
        """
        The presence of this field indicates that this zone is backed by Service Directory. The value of this field contains information related to the namespace associated with the zone.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The zone's visibility: public zones are exposed to the Internet,
        while private zones are visible only to Virtual Private Cloud resources.
        Default value is `public`.
        Possible values are: `private`, `public`.
        """
        return pulumi.get(self, "visibility")

