# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AppHostingBackendArgs', 'AppHostingBackend']

@pulumi.input_type
class AppHostingBackendArgs:
    def __init__(__self__, *,
                 app_id: pulumi.Input[_builtins.str],
                 backend_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 service_account: pulumi.Input[_builtins.str],
                 serving_locality: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 codebase: Optional[pulumi.Input['AppHostingBackendCodebaseArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AppHostingBackend resource.
        :param pulumi.Input[_builtins.str] app_id: The [ID of a Web
               App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
               associated with the backend.
        :param pulumi.Input[_builtins.str] backend_id: Id of the backend. Also used as the service ID for Cloud Run, and as part
               of the default domain name.
        :param pulumi.Input[_builtins.str] location: The canonical IDs of a Google Cloud location such as "us-east1".
        :param pulumi.Input[_builtins.str] service_account: The name of the service account used for Cloud Build and Cloud Run.
               Should have the role roles/firebaseapphosting.computeRunner
               or equivalent permissions.
        :param pulumi.Input[_builtins.str] serving_locality: Immutable. Specifies how App Hosting will serve the content for this backend. It will
               either be contained to a single region (REGIONAL_STRICT) or allowed to use
               App Hosting's global-replicated serving infrastructure (GLOBAL_ACCESS).
               Possible values are: `REGIONAL_STRICT`, `GLOBAL_ACCESS`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AppHostingBackendCodebaseArgs'] codebase: The connection to an external source repository to watch for event-driven
               updates to the backend.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[_builtins.str] environment: The environment name of the backend, used to load environment variables
               from environment specific configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "app_id", app_id)
        pulumi.set(__self__, "backend_id", backend_id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "serving_locality", serving_locality)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if codebase is not None:
            pulumi.set(__self__, "codebase", codebase)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [ID of a Web
        App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
        associated with the backend.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the backend. Also used as the service ID for Cloud Run, and as part
        of the default domain name.
        """
        return pulumi.get(self, "backend_id")

    @backend_id.setter
    def backend_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The canonical IDs of a Google Cloud location such as "us-east1".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the service account used for Cloud Build and Cloud Run.
        Should have the role roles/firebaseapphosting.computeRunner
        or equivalent permissions.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="servingLocality")
    def serving_locality(self) -> pulumi.Input[_builtins.str]:
        """
        Immutable. Specifies how App Hosting will serve the content for this backend. It will
        either be contained to a single region (REGIONAL_STRICT) or allowed to use
        App Hosting's global-replicated serving infrastructure (GLOBAL_ACCESS).
        Possible values are: `REGIONAL_STRICT`, `GLOBAL_ACCESS`.
        """
        return pulumi.get(self, "serving_locality")

    @serving_locality.setter
    def serving_locality(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "serving_locality", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to
        store and arbitrary metadata. They are not queryable and should be
        preserved when modifying objects.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def codebase(self) -> Optional[pulumi.Input['AppHostingBackendCodebaseArgs']]:
        """
        The connection to an external source repository to watch for event-driven
        updates to the backend.
        Structure is documented below.
        """
        return pulumi.get(self, "codebase")

    @codebase.setter
    def codebase(self, value: Optional[pulumi.Input['AppHostingBackendCodebaseArgs']]):
        pulumi.set(self, "codebase", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name. 63 character limit.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The environment name of the backend, used to load environment variables
        from environment specific configuration.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize
        objects.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AppHostingBackendState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_id: Optional[pulumi.Input[_builtins.str]] = None,
                 codebase: Optional[pulumi.Input['AppHostingBackendCodebaseArgs']] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_resources: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingBackendManagedResourceArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 serving_locality: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AppHostingBackend resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] app_id: The [ID of a Web
               App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
               associated with the backend.
        :param pulumi.Input[_builtins.str] backend_id: Id of the backend. Also used as the service ID for Cloud Run, and as part
               of the default domain name.
        :param pulumi.Input['AppHostingBackendCodebaseArgs'] codebase: The connection to an external source repository to watch for event-driven
               updates to the backend.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Time at which the backend was created.
        :param pulumi.Input[_builtins.str] delete_time: Time at which the backend was deleted.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] environment: The environment name of the backend, used to load environment variables
               from environment specific configuration.
        :param pulumi.Input[_builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The canonical IDs of a Google Cloud location such as "us-east1".
        :param pulumi.Input[Sequence[pulumi.Input['AppHostingBackendManagedResourceArgs']]] managed_resources: A list of the resources managed by this backend.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the backend.
               Format:
               `projects/{project}/locations/{locationId}/backends/{backendId}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: The name of the service account used for Cloud Build and Cloud Run.
               Should have the role roles/firebaseapphosting.computeRunner
               or equivalent permissions.
        :param pulumi.Input[_builtins.str] serving_locality: Immutable. Specifies how App Hosting will serve the content for this backend. It will
               either be contained to a single region (REGIONAL_STRICT) or allowed to use
               App Hosting's global-replicated serving infrastructure (GLOBAL_ACCESS).
               Possible values are: `REGIONAL_STRICT`, `GLOBAL_ACCESS`.
        :param pulumi.Input[_builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[_builtins.str] update_time: Time at which the backend was last updated.
        :param pulumi.Input[_builtins.str] uri: The primary URI to communicate with the backend.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if backend_id is not None:
            pulumi.set(__self__, "backend_id", backend_id)
        if codebase is not None:
            pulumi.set(__self__, "codebase", codebase)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_resources is not None:
            pulumi.set(__self__, "managed_resources", managed_resources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if serving_locality is not None:
            pulumi.set(__self__, "serving_locality", serving_locality)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that may be set by external tools to
        store and arbitrary metadata. They are not queryable and should be
        preserved when modifying objects.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [ID of a Web
        App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
        associated with the backend.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_id", value)

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the backend. Also used as the service ID for Cloud Run, and as part
        of the default domain name.
        """
        return pulumi.get(self, "backend_id")

    @backend_id.setter
    def backend_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_id", value)

    @_builtins.property
    @pulumi.getter
    def codebase(self) -> Optional[pulumi.Input['AppHostingBackendCodebaseArgs']]:
        """
        The connection to an external source repository to watch for event-driven
        updates to the backend.
        Structure is documented below.
        """
        return pulumi.get(self, "codebase")

    @codebase.setter
    def codebase(self, value: Optional[pulumi.Input['AppHostingBackendCodebaseArgs']]):
        pulumi.set(self, "codebase", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the backend was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the backend was deleted.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human-readable name. 63 character limit.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The environment name of the backend, used to load environment variables
        from environment specific configuration.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Unstructured key value map that can be used to organize and categorize
        objects.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The canonical IDs of a Google Cloud location such as "us-east1".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedResources")
    def managed_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingBackendManagedResourceArgs']]]]:
        """
        A list of the resources managed by this backend.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_resources")

    @managed_resources.setter
    def managed_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AppHostingBackendManagedResourceArgs']]]]):
        pulumi.set(self, "managed_resources", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier. The resource name of the backend.
        Format:
        `projects/{project}/locations/{locationId}/backends/{backendId}`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service account used for Cloud Build and Cloud Run.
        Should have the role roles/firebaseapphosting.computeRunner
        or equivalent permissions.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter(name="servingLocality")
    def serving_locality(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutable. Specifies how App Hosting will serve the content for this backend. It will
        either be contained to a single region (REGIONAL_STRICT) or allowed to use
        App Hosting's global-replicated serving infrastructure (GLOBAL_ACCESS).
        Possible values are: `REGIONAL_STRICT`, `GLOBAL_ACCESS`.
        """
        return pulumi.get(self, "serving_locality")

    @serving_locality.setter
    def serving_locality(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "serving_locality", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time at which the backend was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary URI to communicate with the backend.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)


@pulumi.type_token("gcp:firebase/appHostingBackend:AppHostingBackend")
class AppHostingBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_id: Optional[pulumi.Input[_builtins.str]] = None,
                 codebase: Optional[pulumi.Input[Union['AppHostingBackendCodebaseArgs', 'AppHostingBackendCodebaseArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 serving_locality: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Backend is the primary resource of App Hosting.

        ## Example Usage

        ### Firebase App Hosting Backend Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Backend Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            display_name="My Backend",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            environment="prod",
            annotations={
                "key": "value",
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        app_hosting_sa_developerconnect = gcp.projects.IAMMember("app_hosting_sa_developerconnect",
            project="my-project-name",
            role="roles/developerconnect.readTokenAccessor",
            member=service_account.member)
        app_hosting_sa_adminsdk = gcp.projects.IAMMember("app_hosting_sa_adminsdk",
            project="my-project-name",
            role="roles/firebase.sdkAdminServiceAgent",
            member=service_account.member)
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Backend Github

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        devconnect_p4sa = gcp.projects.ServiceIdentity("devconnect-p4sa",
            project="my-project-name",
            service="developerconnect.googleapis.com")
        devconnect_secret = gcp.projects.IAMMember("devconnect-secret",
            project="my-project-name",
            role="roles/secretmanager.admin",
            member=devconnect_p4sa.member)
        ###
        ### Include these blocks only once per Github account ###
        my_connection = gcp.developerconnect.Connection("my-connection",
            project="my-project-name",
            location="us-central1",
            connection_id="tf-test-connection-new",
            github_config={
                "github_app": "FIREBASE",
            },
            opts = pulumi.ResourceOptions(depends_on=[devconnect_secret]))
        my_repository = gcp.developerconnect.GitRepositoryLink("my-repository",
            project="my-project-name",
            location="us-central1",
            git_repository_link_id="my-repo",
            parent_connection=my_connection.connection_id,
            clone_uri="https://github.com/myuser/myrepo.git")
        example = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="my-backend-gh",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            display_name="My Backend",
            serving_locality="GLOBAL_ACCESS",
            service_account="firebase-app-hosting-compute@my-project-name.iam.gserviceaccount.com",
            environment="prod",
            annotations={
                "key": "value",
            },
            labels={
                "key": "value",
            },
            codebase={
                "repository": my_repository.name,
                "root_directory": "/",
            })
        pulumi.export("nextSteps", my_connection.installation_states)
        ```

        ## Import

        Backend can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend_id}}`

        * `{{project}}/{{location}}/{{backend_id}}`

        * `{{location}}/{{backend_id}}`

        When using the `pulumi import` command, Backend can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingBackend:AppHostingBackend default projects/{{project}}/locations/{{location}}/backends/{{backend_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBackend:AppHostingBackend default {{project}}/{{location}}/{{backend_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBackend:AppHostingBackend default {{location}}/{{backend_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] app_id: The [ID of a Web
               App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
               associated with the backend.
        :param pulumi.Input[_builtins.str] backend_id: Id of the backend. Also used as the service ID for Cloud Run, and as part
               of the default domain name.
        :param pulumi.Input[Union['AppHostingBackendCodebaseArgs', 'AppHostingBackendCodebaseArgsDict']] codebase: The connection to an external source repository to watch for event-driven
               updates to the backend.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[_builtins.str] environment: The environment name of the backend, used to load environment variables
               from environment specific configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The canonical IDs of a Google Cloud location such as "us-east1".
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] service_account: The name of the service account used for Cloud Build and Cloud Run.
               Should have the role roles/firebaseapphosting.computeRunner
               or equivalent permissions.
        :param pulumi.Input[_builtins.str] serving_locality: Immutable. Specifies how App Hosting will serve the content for this backend. It will
               either be contained to a single region (REGIONAL_STRICT) or allowed to use
               App Hosting's global-replicated serving infrastructure (GLOBAL_ACCESS).
               Possible values are: `REGIONAL_STRICT`, `GLOBAL_ACCESS`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppHostingBackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Backend is the primary resource of App Hosting.

        ## Example Usage

        ### Firebase App Hosting Backend Minimal

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="mini",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Backend Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        service_account = gcp.serviceaccount.Account("service_account",
            project="my-project-name",
            account_id="firebase-app-hosting-compute",
            display_name="Firebase App Hosting compute service account",
            create_ignore_already_exists=True)
        fah = gcp.projects.Service("fah",
            project="my-project-name",
            service="firebaseapphosting.googleapis.com",
            disable_on_destroy=False)
        example = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="full",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            display_name="My Backend",
            serving_locality="GLOBAL_ACCESS",
            service_account=service_account.email,
            environment="prod",
            annotations={
                "key": "value",
            },
            labels={
                "key": "value",
            },
            opts = pulumi.ResourceOptions(depends_on=[fah]))
        app_hosting_sa_developerconnect = gcp.projects.IAMMember("app_hosting_sa_developerconnect",
            project="my-project-name",
            role="roles/developerconnect.readTokenAccessor",
            member=service_account.member)
        app_hosting_sa_adminsdk = gcp.projects.IAMMember("app_hosting_sa_adminsdk",
            project="my-project-name",
            role="roles/firebase.sdkAdminServiceAgent",
            member=service_account.member)
        app_hosting_sa_runner = gcp.projects.IAMMember("app_hosting_sa_runner",
            project="my-project-name",
            role="roles/firebaseapphosting.computeRunner",
            member=service_account.member)
        ```
        ### Firebase App Hosting Backend Github

        ```python
        import pulumi
        import pulumi_gcp as gcp

        ### Include these blocks only once per project if you are starting from scratch ###
        devconnect_p4sa = gcp.projects.ServiceIdentity("devconnect-p4sa",
            project="my-project-name",
            service="developerconnect.googleapis.com")
        devconnect_secret = gcp.projects.IAMMember("devconnect-secret",
            project="my-project-name",
            role="roles/secretmanager.admin",
            member=devconnect_p4sa.member)
        ###
        ### Include these blocks only once per Github account ###
        my_connection = gcp.developerconnect.Connection("my-connection",
            project="my-project-name",
            location="us-central1",
            connection_id="tf-test-connection-new",
            github_config={
                "github_app": "FIREBASE",
            },
            opts = pulumi.ResourceOptions(depends_on=[devconnect_secret]))
        my_repository = gcp.developerconnect.GitRepositoryLink("my-repository",
            project="my-project-name",
            location="us-central1",
            git_repository_link_id="my-repo",
            parent_connection=my_connection.connection_id,
            clone_uri="https://github.com/myuser/myrepo.git")
        example = gcp.firebase.AppHostingBackend("example",
            project="my-project-name",
            location="us-central1",
            backend_id="my-backend-gh",
            app_id="1:0000000000:web:674cde32020e16fbce9dbd",
            display_name="My Backend",
            serving_locality="GLOBAL_ACCESS",
            service_account="firebase-app-hosting-compute@my-project-name.iam.gserviceaccount.com",
            environment="prod",
            annotations={
                "key": "value",
            },
            labels={
                "key": "value",
            },
            codebase={
                "repository": my_repository.name,
                "root_directory": "/",
            })
        pulumi.export("nextSteps", my_connection.installation_states)
        ```

        ## Import

        Backend can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backends/{{backend_id}}`

        * `{{project}}/{{location}}/{{backend_id}}`

        * `{{location}}/{{backend_id}}`

        When using the `pulumi import` command, Backend can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:firebase/appHostingBackend:AppHostingBackend default projects/{{project}}/locations/{{location}}/backends/{{backend_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBackend:AppHostingBackend default {{project}}/{{location}}/{{backend_id}}
        ```

        ```sh
        $ pulumi import gcp:firebase/appHostingBackend:AppHostingBackend default {{location}}/{{backend_id}}
        ```

        :param str resource_name: The name of the resource.
        :param AppHostingBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppHostingBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_id: Optional[pulumi.Input[_builtins.str]] = None,
                 codebase: Optional[pulumi.Input[Union['AppHostingBackendCodebaseArgs', 'AppHostingBackendCodebaseArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 serving_locality: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppHostingBackendArgs.__new__(AppHostingBackendArgs)

            __props__.__dict__["annotations"] = annotations
            if app_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_id'")
            __props__.__dict__["app_id"] = app_id
            if backend_id is None and not opts.urn:
                raise TypeError("Missing required property 'backend_id'")
            __props__.__dict__["backend_id"] = backend_id
            __props__.__dict__["codebase"] = codebase
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["environment"] = environment
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if service_account is None and not opts.urn:
                raise TypeError("Missing required property 'service_account'")
            __props__.__dict__["service_account"] = service_account
            if serving_locality is None and not opts.urn:
                raise TypeError("Missing required property 'serving_locality'")
            __props__.__dict__["serving_locality"] = serving_locality
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["managed_resources"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["uri"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AppHostingBackend, __self__).__init__(
            'gcp:firebase/appHostingBackend:AppHostingBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            app_id: Optional[pulumi.Input[_builtins.str]] = None,
            backend_id: Optional[pulumi.Input[_builtins.str]] = None,
            codebase: Optional[pulumi.Input[Union['AppHostingBackendCodebaseArgs', 'AppHostingBackendCodebaseArgsDict']]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            environment: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AppHostingBackendManagedResourceArgs', 'AppHostingBackendManagedResourceArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            serving_locality: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None) -> 'AppHostingBackend':
        """
        Get an existing AppHostingBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Unstructured key value map that may be set by external tools to
               store and arbitrary metadata. They are not queryable and should be
               preserved when modifying objects.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] app_id: The [ID of a Web
               App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
               associated with the backend.
        :param pulumi.Input[_builtins.str] backend_id: Id of the backend. Also used as the service ID for Cloud Run, and as part
               of the default domain name.
        :param pulumi.Input[Union['AppHostingBackendCodebaseArgs', 'AppHostingBackendCodebaseArgsDict']] codebase: The connection to an external source repository to watch for event-driven
               updates to the backend.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: Time at which the backend was created.
        :param pulumi.Input[_builtins.str] delete_time: Time at which the backend was deleted.
        :param pulumi.Input[_builtins.str] display_name: Human-readable name. 63 character limit.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] environment: The environment name of the backend, used to load environment variables
               from environment specific configuration.
        :param pulumi.Input[_builtins.str] etag: Server-computed checksum based on other values; may be sent
               on update or delete to ensure operation is done on expected resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Unstructured key value map that can be used to organize and categorize
               objects.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The canonical IDs of a Google Cloud location such as "us-east1".
        :param pulumi.Input[Sequence[pulumi.Input[Union['AppHostingBackendManagedResourceArgs', 'AppHostingBackendManagedResourceArgsDict']]]] managed_resources: A list of the resources managed by this backend.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Identifier. The resource name of the backend.
               Format:
               `projects/{project}/locations/{locationId}/backends/{backendId}`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: The name of the service account used for Cloud Build and Cloud Run.
               Should have the role roles/firebaseapphosting.computeRunner
               or equivalent permissions.
        :param pulumi.Input[_builtins.str] serving_locality: Immutable. Specifies how App Hosting will serve the content for this backend. It will
               either be contained to a single region (REGIONAL_STRICT) or allowed to use
               App Hosting's global-replicated serving infrastructure (GLOBAL_ACCESS).
               Possible values are: `REGIONAL_STRICT`, `GLOBAL_ACCESS`.
        :param pulumi.Input[_builtins.str] uid: System-assigned, unique identifier.
        :param pulumi.Input[_builtins.str] update_time: Time at which the backend was last updated.
        :param pulumi.Input[_builtins.str] uri: The primary URI to communicate with the backend.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppHostingBackendState.__new__(_AppHostingBackendState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["backend_id"] = backend_id
        __props__.__dict__["codebase"] = codebase
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["environment"] = environment
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_resources"] = managed_resources
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["serving_locality"] = serving_locality
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["uri"] = uri
        return AppHostingBackend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that may be set by external tools to
        store and arbitrary metadata. They are not queryable and should be
        preserved when modifying objects.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [ID of a Web
        App](https://firebase.google.com/docs/reference/firebase-management/rest/v1beta1/projects.webApps#WebApp.FIELDS.app_id)
        associated with the backend.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the backend. Also used as the service ID for Cloud Run, and as part
        of the default domain name.
        """
        return pulumi.get(self, "backend_id")

    @_builtins.property
    @pulumi.getter
    def codebase(self) -> pulumi.Output[Optional['outputs.AppHostingBackendCodebase']]:
        """
        The connection to an external source repository to watch for event-driven
        updates to the backend.
        Structure is documented below.
        """
        return pulumi.get(self, "codebase")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the backend was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the backend was deleted.
        """
        return pulumi.get(self, "delete_time")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human-readable name. 63 character limit.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The environment name of the backend, used to load environment variables
        from environment specific configuration.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Server-computed checksum based on other values; may be sent
        on update or delete to ensure operation is done on expected resource.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Unstructured key value map that can be used to organize and categorize
        objects.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The canonical IDs of a Google Cloud location such as "us-east1".
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedResources")
    def managed_resources(self) -> pulumi.Output[Sequence['outputs.AppHostingBackendManagedResource']]:
        """
        A list of the resources managed by this backend.
        Structure is documented below.
        """
        return pulumi.get(self, "managed_resources")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier. The resource name of the backend.
        Format:
        `projects/{project}/locations/{locationId}/backends/{backendId}`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service account used for Cloud Build and Cloud Run.
        Should have the role roles/firebaseapphosting.computeRunner
        or equivalent permissions.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="servingLocality")
    def serving_locality(self) -> pulumi.Output[_builtins.str]:
        """
        Immutable. Specifies how App Hosting will serve the content for this backend. It will
        either be contained to a single region (REGIONAL_STRICT) or allowed to use
        App Hosting's global-replicated serving infrastructure (GLOBAL_ACCESS).
        Possible values are: `REGIONAL_STRICT`, `GLOBAL_ACCESS`.
        """
        return pulumi.get(self, "serving_locality")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        System-assigned, unique identifier.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time at which the backend was last updated.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[_builtins.str]:
        """
        The primary URI to communicate with the backend.
        """
        return pulumi.get(self, "uri")

