# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAndroidAppResult',
    'AwaitableGetAndroidAppResult',
    'get_android_app',
    'get_android_app_output',
]

@pulumi.output_type
class GetAndroidAppResult:
    """
    A collection of values returned by getAndroidApp.
    """
    def __init__(__self__, api_key_id=None, app_id=None, deletion_policy=None, display_name=None, etag=None, id=None, name=None, package_name=None, project=None, sha1_hashes=None, sha256_hashes=None):
        if api_key_id and not isinstance(api_key_id, str):
            raise TypeError("Expected argument 'api_key_id' to be a str")
        pulumi.set(__self__, "api_key_id", api_key_id)
        if app_id and not isinstance(app_id, str):
            raise TypeError("Expected argument 'app_id' to be a str")
        pulumi.set(__self__, "app_id", app_id)
        if deletion_policy and not isinstance(deletion_policy, str):
            raise TypeError("Expected argument 'deletion_policy' to be a str")
        pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_name and not isinstance(package_name, str):
            raise TypeError("Expected argument 'package_name' to be a str")
        pulumi.set(__self__, "package_name", package_name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if sha1_hashes and not isinstance(sha1_hashes, list):
            raise TypeError("Expected argument 'sha1_hashes' to be a list")
        pulumi.set(__self__, "sha1_hashes", sha1_hashes)
        if sha256_hashes and not isinstance(sha256_hashes, list):
            raise TypeError("Expected argument 'sha256_hashes' to be a list")
        pulumi.set(__self__, "sha256_hashes", sha256_hashes)

    @_builtins.property
    @pulumi.getter(name="apiKeyId")
    def api_key_id(self) -> _builtins.str:
        return pulumi.get(self, "api_key_id")

    @_builtins.property
    @pulumi.getter(name="appId")
    def app_id(self) -> _builtins.str:
        """
        Immutable. The globally unique, Firebase-assigned identifier of the AndroidApp.
        This identifier should be treated as an opaque token, as the data format is not specified.
        """
        return pulumi.get(self, "app_id")

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> _builtins.str:
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The user-assigned display name of the AndroidApp.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        This checksum is computed by the server based on the value of other fields, and it may be sent
        with update requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The fully qualified resource name of the AndroidApp, for example:
        projects/projectId/androidApps/appId
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="packageName")
    def package_name(self) -> _builtins.str:
        """
        The canonical package name of the Android app as would appear in the Google Play Developer Console.
        """
        return pulumi.get(self, "package_name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="sha1Hashes")
    def sha1_hashes(self) -> Sequence[_builtins.str]:
        """
        The SHA1 certificate hashes for the AndroidApp.
        """
        return pulumi.get(self, "sha1_hashes")

    @_builtins.property
    @pulumi.getter(name="sha256Hashes")
    def sha256_hashes(self) -> Sequence[_builtins.str]:
        """
        The SHA256 certificate hashes for the AndroidApp.
        """
        return pulumi.get(self, "sha256_hashes")


class AwaitableGetAndroidAppResult(GetAndroidAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAndroidAppResult(
            api_key_id=self.api_key_id,
            app_id=self.app_id,
            deletion_policy=self.deletion_policy,
            display_name=self.display_name,
            etag=self.etag,
            id=self.id,
            name=self.name,
            package_name=self.package_name,
            project=self.project,
            sha1_hashes=self.sha1_hashes,
            sha256_hashes=self.sha256_hashes)


def get_android_app(app_id: Optional[_builtins.str] = None,
                    project: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAndroidAppResult:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str app_id: The app_id of name of the Firebase androidApp.
           
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:firebase/getAndroidApp:getAndroidApp', __args__, opts=opts, typ=GetAndroidAppResult).value

    return AwaitableGetAndroidAppResult(
        api_key_id=pulumi.get(__ret__, 'api_key_id'),
        app_id=pulumi.get(__ret__, 'app_id'),
        deletion_policy=pulumi.get(__ret__, 'deletion_policy'),
        display_name=pulumi.get(__ret__, 'display_name'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        package_name=pulumi.get(__ret__, 'package_name'),
        project=pulumi.get(__ret__, 'project'),
        sha1_hashes=pulumi.get(__ret__, 'sha1_hashes'),
        sha256_hashes=pulumi.get(__ret__, 'sha256_hashes'))
def get_android_app_output(app_id: Optional[pulumi.Input[_builtins.str]] = None,
                           project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAndroidAppResult]:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str app_id: The app_id of name of the Firebase androidApp.
           
           
           - - -
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['appId'] = app_id
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:firebase/getAndroidApp:getAndroidApp', __args__, opts=opts, typ=GetAndroidAppResult)
    return __ret__.apply(lambda __response__: GetAndroidAppResult(
        api_key_id=pulumi.get(__response__, 'api_key_id'),
        app_id=pulumi.get(__response__, 'app_id'),
        deletion_policy=pulumi.get(__response__, 'deletion_policy'),
        display_name=pulumi.get(__response__, 'display_name'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        package_name=pulumi.get(__response__, 'package_name'),
        project=pulumi.get(__response__, 'project'),
        sha1_hashes=pulumi.get(__response__, 'sha1_hashes'),
        sha256_hashes=pulumi.get(__response__, 'sha256_hashes')))
