# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRepositoryGroupIamPolicyResult',
    'AwaitableGetRepositoryGroupIamPolicyResult',
    'get_repository_group_iam_policy',
    'get_repository_group_iam_policy_output',
]

@pulumi.output_type
class GetRepositoryGroupIamPolicyResult:
    """
    A collection of values returned by getRepositoryGroupIamPolicy.
    """
    def __init__(__self__, code_repository_index=None, etag=None, id=None, location=None, policy_data=None, project=None, repository_group_id=None):
        if code_repository_index and not isinstance(code_repository_index, str):
            raise TypeError("Expected argument 'code_repository_index' to be a str")
        pulumi.set(__self__, "code_repository_index", code_repository_index)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repository_group_id and not isinstance(repository_group_id, str):
            raise TypeError("Expected argument 'repository_group_id' to be a str")
        pulumi.set(__self__, "repository_group_id", repository_group_id)

    @_builtins.property
    @pulumi.getter(name="codeRepositoryIndex")
    def code_repository_index(self) -> _builtins.str:
        return pulumi.get(self, "code_repository_index")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `gemini.RepositoryGroupIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="repositoryGroupId")
    def repository_group_id(self) -> _builtins.str:
        return pulumi.get(self, "repository_group_id")


class AwaitableGetRepositoryGroupIamPolicyResult(GetRepositoryGroupIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryGroupIamPolicyResult(
            code_repository_index=self.code_repository_index,
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project,
            repository_group_id=self.repository_group_id)


def get_repository_group_iam_policy(code_repository_index: Optional[_builtins.str] = None,
                                    location: Optional[_builtins.str] = None,
                                    project: Optional[_builtins.str] = None,
                                    repository_group_id: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryGroupIamPolicyResult:
    """
    Retrieves the current IAM policy data for repositorygroup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.gemini.get_repository_group_iam_policy(project=example["project"],
        location=example["location"],
        code_repository_index=example["codeRepositoryIndex"],
        repository_group_id=example["repositoryGroupId"])
    ```


    :param _builtins.str code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
    :param _builtins.str location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str repository_group_id: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['codeRepositoryIndex'] = code_repository_index
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryGroupId'] = repository_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:gemini/getRepositoryGroupIamPolicy:getRepositoryGroupIamPolicy', __args__, opts=opts, typ=GetRepositoryGroupIamPolicyResult).value

    return AwaitableGetRepositoryGroupIamPolicyResult(
        code_repository_index=pulumi.get(__ret__, 'code_repository_index'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        repository_group_id=pulumi.get(__ret__, 'repository_group_id'))
def get_repository_group_iam_policy_output(code_repository_index: Optional[pulumi.Input[_builtins.str]] = None,
                                           location: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           repository_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoryGroupIamPolicyResult]:
    """
    Retrieves the current IAM policy data for repositorygroup

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.gemini.get_repository_group_iam_policy(project=example["project"],
        location=example["location"],
        code_repository_index=example["codeRepositoryIndex"],
        repository_group_id=example["repositoryGroupId"])
    ```


    :param _builtins.str code_repository_index: Required. Id of the Code Repository Index. Used to find the parent resource to bind the IAM policy to
    :param _builtins.str location: The location of the Code Repository Index, for example `us-central1`. Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param _builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    :param _builtins.str repository_group_id: Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['codeRepositoryIndex'] = code_repository_index
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryGroupId'] = repository_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:gemini/getRepositoryGroupIamPolicy:getRepositoryGroupIamPolicy', __args__, opts=opts, typ=GetRepositoryGroupIamPolicyResult)
    return __ret__.apply(lambda __response__: GetRepositoryGroupIamPolicyResult(
        code_repository_index=pulumi.get(__response__, 'code_repository_index'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        repository_group_id=pulumi.get(__response__, 'repository_group_id')))
