# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RestoreChannelArgs', 'RestoreChannel']

@pulumi.input_type
class RestoreChannelArgs:
    def __init__(__self__, *,
                 destination_project: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RestoreChannel resource.
        :param pulumi.Input[_builtins.str] destination_project: The project where Backups will be restored.
               The format is `projects/{project}`.
               {project} can be project number or project id.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Channel.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestoreChannel.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The full name of the RestoreChannel Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "destination_project", destination_project)
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="destinationProject")
    def destination_project(self) -> pulumi.Input[_builtins.str]:
        """
        The project where Backups will be restored.
        The format is `projects/{project}`.
        {project} can be project number or project id.
        """
        return pulumi.get(self, "destination_project")

    @destination_project.setter
    def destination_project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_project", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The region of the Restore Channel.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User specified descriptive string for this RestoreChannel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the RestoreChannel Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RestoreChannelState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_project: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RestoreChannel resources.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestoreChannel.
        :param pulumi.Input[_builtins.str] destination_project: The project where Backups will be restored.
               The format is `projects/{project}`.
               {project} can be project number or project id.
        :param pulumi.Input[_builtins.str] destination_project_id: The project_id where Backups will be restored.
               Example Project ID: "my-project-id".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: etag is used for optimistic concurrency control as a way to help prevent simultaneous
               updates of a restore channel from overwriting each other. It is strongly suggested that
               systems make use of the 'etag' in the read-modify-write cycle to perform RestoreChannel updates
               in order to avoid race conditions: An etag is returned in the response to restoreChannels.get,
               and systems are expected to put that etag in the request to restoreChannels.patch or
               restoreChannels.delete to ensure that their change will be applied to the same version of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Channel.
        :param pulumi.Input[_builtins.str] name: The full name of the RestoreChannel Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] uid: Server generated, unique identifier of UUID format.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_project is not None:
            pulumi.set(__self__, "destination_project", destination_project)
        if destination_project_id is not None:
            pulumi.set(__self__, "destination_project_id", destination_project_id)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User specified descriptive string for this RestoreChannel.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationProject")
    def destination_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project where Backups will be restored.
        The format is `projects/{project}`.
        {project} can be project number or project id.
        """
        return pulumi.get(self, "destination_project")

    @destination_project.setter
    def destination_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_project", value)

    @_builtins.property
    @pulumi.getter(name="destinationProjectId")
    def destination_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project_id where Backups will be restored.
        Example Project ID: "my-project-id".
        """
        return pulumi.get(self, "destination_project_id")

    @destination_project_id.setter
    def destination_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_project_id", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        etag is used for optimistic concurrency control as a way to help prevent simultaneous
        updates of a restore channel from overwriting each other. It is strongly suggested that
        systems make use of the 'etag' in the read-modify-write cycle to perform RestoreChannel updates
        in order to avoid race conditions: An etag is returned in the response to restoreChannels.get,
        and systems are expected to put that etag in the request to restoreChannels.patch or
        restoreChannels.delete to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region of the Restore Channel.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the RestoreChannel Resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server generated, unique identifier of UUID format.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)


@pulumi.type_token("gcp:gkebackup/restoreChannel:RestoreChannel")
class RestoreChannel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_project: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A RestoreChannel imposes constraints on where backups can be restored.
        The RestoreChannel should be in the same project and region
        as the backups. The backups can only be restored in the
        destination_project.

        To get more information about RestoreChannel, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/projects.locations.restoreChannels)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)

        ## Example Usage

        ### Gkebackup Restorechannel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.gkebackup.RestoreChannel("basic",
            name="basic-channel",
            location="us-central1",
            description="Description",
            destination_project="projects/24240755850",
            labels={
                "key": "some-value",
            })
        ```

        ## Import

        RestoreChannel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/restoreChannels/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RestoreChannel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkebackup/restoreChannel:RestoreChannel default projects/{{project}}/locations/{{location}}/restoreChannels/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restoreChannel:RestoreChannel default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restoreChannel:RestoreChannel default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestoreChannel.
        :param pulumi.Input[_builtins.str] destination_project: The project where Backups will be restored.
               The format is `projects/{project}`.
               {project} can be project number or project id.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Channel.
        :param pulumi.Input[_builtins.str] name: The full name of the RestoreChannel Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestoreChannelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A RestoreChannel imposes constraints on where backups can be restored.
        The RestoreChannel should be in the same project and region
        as the backups. The backups can only be restored in the
        destination_project.

        To get more information about RestoreChannel, see:

        * [API documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke/reference/rest/v1/projects.locations.restoreChannels)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/kubernetes-engine/docs/add-on/backup-for-gke)

        ## Example Usage

        ### Gkebackup Restorechannel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.gkebackup.RestoreChannel("basic",
            name="basic-channel",
            location="us-central1",
            description="Description",
            destination_project="projects/24240755850",
            labels={
                "key": "some-value",
            })
        ```

        ## Import

        RestoreChannel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/restoreChannels/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, RestoreChannel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkebackup/restoreChannel:RestoreChannel default projects/{{project}}/locations/{{location}}/restoreChannels/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restoreChannel:RestoreChannel default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:gkebackup/restoreChannel:RestoreChannel default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RestoreChannelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestoreChannelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_project: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestoreChannelArgs.__new__(RestoreChannelArgs)

            __props__.__dict__["description"] = description
            if destination_project is None and not opts.urn:
                raise TypeError("Missing required property 'destination_project'")
            __props__.__dict__["destination_project"] = destination_project
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["destination_project_id"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RestoreChannel, __self__).__init__(
            'gcp:gkebackup/restoreChannel:RestoreChannel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_project: Optional[pulumi.Input[_builtins.str]] = None,
            destination_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None) -> 'RestoreChannel':
        """
        Get an existing RestoreChannel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: User specified descriptive string for this RestoreChannel.
        :param pulumi.Input[_builtins.str] destination_project: The project where Backups will be restored.
               The format is `projects/{project}`.
               {project} can be project number or project id.
        :param pulumi.Input[_builtins.str] destination_project_id: The project_id where Backups will be restored.
               Example Project ID: "my-project-id".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] etag: etag is used for optimistic concurrency control as a way to help prevent simultaneous
               updates of a restore channel from overwriting each other. It is strongly suggested that
               systems make use of the 'etag' in the read-modify-write cycle to perform RestoreChannel updates
               in order to avoid race conditions: An etag is returned in the response to restoreChannels.get,
               and systems are expected to put that etag in the request to restoreChannels.patch or
               restoreChannels.delete to ensure that their change will be applied to the same version of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Description: A set of custom labels supplied by the user.
               A list of key->value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The region of the Restore Channel.
        :param pulumi.Input[_builtins.str] name: The full name of the RestoreChannel Resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] uid: Server generated, unique identifier of UUID format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestoreChannelState.__new__(_RestoreChannelState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination_project"] = destination_project
        __props__.__dict__["destination_project_id"] = destination_project_id
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["uid"] = uid
        return RestoreChannel(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User specified descriptive string for this RestoreChannel.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationProject")
    def destination_project(self) -> pulumi.Output[_builtins.str]:
        """
        The project where Backups will be restored.
        The format is `projects/{project}`.
        {project} can be project number or project id.
        """
        return pulumi.get(self, "destination_project")

    @_builtins.property
    @pulumi.getter(name="destinationProjectId")
    def destination_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project_id where Backups will be restored.
        Example Project ID: "my-project-id".
        """
        return pulumi.get(self, "destination_project_id")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        etag is used for optimistic concurrency control as a way to help prevent simultaneous
        updates of a restore channel from overwriting each other. It is strongly suggested that
        systems make use of the 'etag' in the read-modify-write cycle to perform RestoreChannel updates
        in order to avoid race conditions: An etag is returned in the response to restoreChannels.get,
        and systems are expected to put that etag in the request to restoreChannels.patch or
        restoreChannels.delete to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Description: A set of custom labels supplied by the user.
        A list of key->value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The region of the Restore Channel.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the RestoreChannel Resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Server generated, unique identifier of UUID format.
        """
        return pulumi.get(self, "uid")

