# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MembershipBindingArgs', 'MembershipBinding']

@pulumi.input_type
class MembershipBindingArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 membership_binding_id: pulumi.Input[_builtins.str],
                 membership_id: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MembershipBinding resource.
        :param pulumi.Input[_builtins.str] location: Location of the membership
        :param pulumi.Input[_builtins.str] membership_binding_id: The client-provided identifier of the membership binding.
        :param pulumi.Input[_builtins.str] membership_id: Id of the membership
        :param pulumi.Input[_builtins.str] scope: A Workspace resource name in the format
               `projects/*/locations/*/scopes/*`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for this Membership binding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "membership_binding_id", membership_binding_id)
        pulumi.set(__self__, "membership_id", membership_id)
        pulumi.set(__self__, "scope", scope)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Location of the membership
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="membershipBindingId")
    def membership_binding_id(self) -> pulumi.Input[_builtins.str]:
        """
        The client-provided identifier of the membership binding.
        """
        return pulumi.get(self, "membership_binding_id")

    @membership_binding_id.setter
    def membership_binding_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "membership_binding_id", value)

    @_builtins.property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the membership
        """
        return pulumi.get(self, "membership_id")

    @membership_id.setter
    def membership_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "membership_id", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        A Workspace resource name in the format
        `projects/*/locations/*/scopes/*`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for this Membership binding.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _MembershipBindingState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 delete_time: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 membership_binding_id: Optional[pulumi.Input[_builtins.str]] = None,
                 membership_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 states: Optional[pulumi.Input[Sequence[pulumi.Input['MembershipBindingStateArgs']]]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MembershipBinding resources.
        :param pulumi.Input[_builtins.str] create_time: Time the MembershipBinding was created in UTC.
        :param pulumi.Input[_builtins.str] delete_time: Time the MembershipBinding was deleted in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for this Membership binding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of the membership
        :param pulumi.Input[_builtins.str] membership_binding_id: The client-provided identifier of the membership binding.
        :param pulumi.Input[_builtins.str] membership_id: Id of the membership
        :param pulumi.Input[_builtins.str] name: The resource name for the membershipbinding itself
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] scope: A Workspace resource name in the format
               `projects/*/locations/*/scopes/*`.
        :param pulumi.Input[Sequence[pulumi.Input['MembershipBindingStateArgs']]] states: State of the membership binding resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Google-generated UUID for this resource.
        :param pulumi.Input[_builtins.str] update_time: Time the MembershipBinding was updated in UTC.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if membership_binding_id is not None:
            pulumi.set(__self__, "membership_binding_id", membership_binding_id)
        if membership_id is not None:
            pulumi.set(__self__, "membership_id", membership_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if states is not None:
            pulumi.set(__self__, "states", states)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the MembershipBinding was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the MembershipBinding was deleted in UTC.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delete_time", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels for this Membership binding.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location of the membership
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="membershipBindingId")
    def membership_binding_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client-provided identifier of the membership binding.
        """
        return pulumi.get(self, "membership_binding_id")

    @membership_binding_id.setter
    def membership_binding_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "membership_binding_id", value)

    @_builtins.property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the membership
        """
        return pulumi.get(self, "membership_id")

    @membership_id.setter
    def membership_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "membership_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for the membershipbinding itself
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Workspace resource name in the format
        `projects/*/locations/*/scopes/*`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def states(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MembershipBindingStateArgs']]]]:
        """
        State of the membership binding resource.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @states.setter
    def states(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MembershipBindingStateArgs']]]]):
        pulumi.set(self, "states", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Google-generated UUID for this resource.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time the MembershipBinding was updated in UTC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:gkehub/membershipBinding:MembershipBinding")
class MembershipBinding(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 membership_binding_id: Optional[pulumi.Input[_builtins.str]] = None,
                 membership_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        MembershipBinding is a subresource of a Membership, representing what Fleet Scopes (or other, future Fleet resources) a Membership is bound to.

        To get more information about MembershipBinding, see:

        * [API documentation](https://cloud.google.com/anthos/fleet-management/docs/reference/rest/v1/projects.locations.memberships.bindings)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Membership Binding Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            deletion_protection=True,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="tf-test-membership_37559",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[primary]))
        scope = gcp.gkehub.Scope("scope", scope_id="tf-test-scope_91980")
        membership_binding = gcp.gkehub.MembershipBinding("membership_binding",
            membership_binding_id="tf-test-membership-binding_37118",
            scope=scope.name,
            membership_id=membership.membership_id,
            location="global",
            labels={
                "keyb": "valueb",
                "keya": "valuea",
                "keyc": "valuec",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    membership,
                    scope,
                ]))
        ```

        ## Import

        MembershipBinding can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}/bindings/{{membership_binding_id}}`

        * `{{project}}/{{location}}/{{membership_id}}/{{membership_binding_id}}`

        * `{{location}}/{{membership_id}}/{{membership_binding_id}}`

        When using the `pulumi import` command, MembershipBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/membershipBinding:MembershipBinding default projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}/bindings/{{membership_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membershipBinding:MembershipBinding default {{project}}/{{location}}/{{membership_id}}/{{membership_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membershipBinding:MembershipBinding default {{location}}/{{membership_id}}/{{membership_binding_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for this Membership binding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of the membership
        :param pulumi.Input[_builtins.str] membership_binding_id: The client-provided identifier of the membership binding.
        :param pulumi.Input[_builtins.str] membership_id: Id of the membership
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] scope: A Workspace resource name in the format
               `projects/*/locations/*/scopes/*`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MembershipBindingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        MembershipBinding is a subresource of a Membership, representing what Fleet Scopes (or other, future Fleet resources) a Membership is bound to.

        To get more information about MembershipBinding, see:

        * [API documentation](https://cloud.google.com/anthos/fleet-management/docs/reference/rest/v1/projects.locations.memberships.bindings)
        * How-to Guides
            * [Registering a Cluster](https://cloud.google.com/anthos/multicluster-management/connect/registering-a-cluster#register_cluster)

        ## Example Usage

        ### Gkehub Membership Binding Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        primary = gcp.container.Cluster("primary",
            name="basic-cluster",
            location="us-central1-a",
            initial_node_count=1,
            deletion_protection=True,
            network="default",
            subnetwork="default")
        membership = gcp.gkehub.Membership("membership",
            membership_id="tf-test-membership_37559",
            endpoint={
                "gke_cluster": {
                    "resource_link": primary.id.apply(lambda id: f"//container.googleapis.com/{id}"),
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[primary]))
        scope = gcp.gkehub.Scope("scope", scope_id="tf-test-scope_91980")
        membership_binding = gcp.gkehub.MembershipBinding("membership_binding",
            membership_binding_id="tf-test-membership-binding_37118",
            scope=scope.name,
            membership_id=membership.membership_id,
            location="global",
            labels={
                "keyb": "valueb",
                "keya": "valuea",
                "keyc": "valuec",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    membership,
                    scope,
                ]))
        ```

        ## Import

        MembershipBinding can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}/bindings/{{membership_binding_id}}`

        * `{{project}}/{{location}}/{{membership_id}}/{{membership_binding_id}}`

        * `{{location}}/{{membership_id}}/{{membership_binding_id}}`

        When using the `pulumi import` command, MembershipBinding can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:gkehub/membershipBinding:MembershipBinding default projects/{{project}}/locations/{{location}}/memberships/{{membership_id}}/bindings/{{membership_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membershipBinding:MembershipBinding default {{project}}/{{location}}/{{membership_id}}/{{membership_binding_id}}
        ```

        ```sh
        $ pulumi import gcp:gkehub/membershipBinding:MembershipBinding default {{location}}/{{membership_id}}/{{membership_binding_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MembershipBindingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MembershipBindingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 membership_binding_id: Optional[pulumi.Input[_builtins.str]] = None,
                 membership_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MembershipBindingArgs.__new__(MembershipBindingArgs)

            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            if membership_binding_id is None and not opts.urn:
                raise TypeError("Missing required property 'membership_binding_id'")
            __props__.__dict__["membership_binding_id"] = membership_binding_id
            if membership_id is None and not opts.urn:
                raise TypeError("Missing required property 'membership_id'")
            __props__.__dict__["membership_id"] = membership_id
            __props__.__dict__["project"] = project
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["states"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MembershipBinding, __self__).__init__(
            'gcp:gkehub/membershipBinding:MembershipBinding',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            delete_time: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            membership_binding_id: Optional[pulumi.Input[_builtins.str]] = None,
            membership_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            states: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MembershipBindingStateArgs', 'MembershipBindingStateArgsDict']]]]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'MembershipBinding':
        """
        Get an existing MembershipBinding resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: Time the MembershipBinding was created in UTC.
        :param pulumi.Input[_builtins.str] delete_time: Time the MembershipBinding was deleted in UTC.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels for this Membership binding.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location of the membership
        :param pulumi.Input[_builtins.str] membership_binding_id: The client-provided identifier of the membership binding.
        :param pulumi.Input[_builtins.str] membership_id: Id of the membership
        :param pulumi.Input[_builtins.str] name: The resource name for the membershipbinding itself
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] scope: A Workspace resource name in the format
               `projects/*/locations/*/scopes/*`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MembershipBindingStateArgs', 'MembershipBindingStateArgsDict']]]] states: State of the membership binding resource.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] uid: Google-generated UUID for this resource.
        :param pulumi.Input[_builtins.str] update_time: Time the MembershipBinding was updated in UTC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MembershipBindingState.__new__(_MembershipBindingState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["membership_binding_id"] = membership_binding_id
        __props__.__dict__["membership_id"] = membership_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["scope"] = scope
        __props__.__dict__["states"] = states
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return MembershipBinding(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the MembershipBinding was created in UTC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the MembershipBinding was deleted in UTC.
        """
        return pulumi.get(self, "delete_time")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels for this Membership binding.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location of the membership
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="membershipBindingId")
    def membership_binding_id(self) -> pulumi.Output[_builtins.str]:
        """
        The client-provided identifier of the membership binding.
        """
        return pulumi.get(self, "membership_binding_id")

    @_builtins.property
    @pulumi.getter(name="membershipId")
    def membership_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the membership
        """
        return pulumi.get(self, "membership_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name for the membershipbinding itself
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        A Workspace resource name in the format
        `projects/*/locations/*/scopes/*`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def states(self) -> pulumi.Output[Sequence['outputs.MembershipBindingState']]:
        """
        State of the membership binding resource.
        Structure is documented below.
        """
        return pulumi.get(self, "states")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Google-generated UUID for this resource.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time the MembershipBinding was updated in UTC.
        """
        return pulumi.get(self, "update_time")

