# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineJobArgs', 'PipelineJob']

@pulumi.input_type
class PipelineJobArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 backfill_pipeline_job: Optional[pulumi.Input['PipelineJobBackfillPipelineJobArgs']] = None,
                 disable_lineage: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 mapping_pipeline_job: Optional[pulumi.Input['PipelineJobMappingPipelineJobArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reconciliation_pipeline_job: Optional[pulumi.Input['PipelineJobReconciliationPipelineJobArgs']] = None):
        """
        The set of arguments for constructing a PipelineJob resource.
        :param pulumi.Input[_builtins.str] dataset: Healthcare Dataset under which the Pipeline Job is to run
        :param pulumi.Input[_builtins.str] location: Location where the Pipeline Job is to run
        :param pulumi.Input['PipelineJobBackfillPipelineJobArgs'] backfill_pipeline_job: Specifies the backfill configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.bool] disable_lineage: If true, disables writing lineage for the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize Pipeline Jobs.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, and must conform to the following PCRE regular expression:
               [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a
               UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE
               regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given pipeline.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['PipelineJobMappingPipelineJobArgs'] mapping_pipeline_job: Specifies mapping configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the pipeline job. This field is user-assigned.
        :param pulumi.Input['PipelineJobReconciliationPipelineJobArgs'] reconciliation_pipeline_job: Specifies reconciliation configuration.
               Structure is documented below.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "location", location)
        if backfill_pipeline_job is not None:
            pulumi.set(__self__, "backfill_pipeline_job", backfill_pipeline_job)
        if disable_lineage is not None:
            pulumi.set(__self__, "disable_lineage", disable_lineage)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mapping_pipeline_job is not None:
            pulumi.set(__self__, "mapping_pipeline_job", mapping_pipeline_job)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reconciliation_pipeline_job is not None:
            pulumi.set(__self__, "reconciliation_pipeline_job", reconciliation_pipeline_job)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[_builtins.str]:
        """
        Healthcare Dataset under which the Pipeline Job is to run
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Location where the Pipeline Job is to run
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="backfillPipelineJob")
    def backfill_pipeline_job(self) -> Optional[pulumi.Input['PipelineJobBackfillPipelineJobArgs']]:
        """
        Specifies the backfill configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_pipeline_job")

    @backfill_pipeline_job.setter
    def backfill_pipeline_job(self, value: Optional[pulumi.Input['PipelineJobBackfillPipelineJobArgs']]):
        pulumi.set(self, "backfill_pipeline_job", value)

    @_builtins.property
    @pulumi.getter(name="disableLineage")
    def disable_lineage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, disables writing lineage for the pipeline.
        """
        return pulumi.get(self, "disable_lineage")

    @disable_lineage.setter
    def disable_lineage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_lineage", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-supplied key-value pairs used to organize Pipeline Jobs.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of
        maximum 128 bytes, and must conform to the following PCRE regular expression:
        [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values are optional, must be between 1 and 63 characters long, have a
        UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE
        regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be associated with a given pipeline.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="mappingPipelineJob")
    def mapping_pipeline_job(self) -> Optional[pulumi.Input['PipelineJobMappingPipelineJobArgs']]:
        """
        Specifies mapping configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "mapping_pipeline_job")

    @mapping_pipeline_job.setter
    def mapping_pipeline_job(self, value: Optional[pulumi.Input['PipelineJobMappingPipelineJobArgs']]):
        pulumi.set(self, "mapping_pipeline_job", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the pipeline job. This field is user-assigned.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="reconciliationPipelineJob")
    def reconciliation_pipeline_job(self) -> Optional[pulumi.Input['PipelineJobReconciliationPipelineJobArgs']]:
        """
        Specifies reconciliation configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "reconciliation_pipeline_job")

    @reconciliation_pipeline_job.setter
    def reconciliation_pipeline_job(self, value: Optional[pulumi.Input['PipelineJobReconciliationPipelineJobArgs']]):
        pulumi.set(self, "reconciliation_pipeline_job", value)


@pulumi.input_type
class _PipelineJobState:
    def __init__(__self__, *,
                 backfill_pipeline_job: Optional[pulumi.Input['PipelineJobBackfillPipelineJobArgs']] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_lineage: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_pipeline_job: Optional[pulumi.Input['PipelineJobMappingPipelineJobArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 reconciliation_pipeline_job: Optional[pulumi.Input['PipelineJobReconciliationPipelineJobArgs']] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PipelineJob resources.
        :param pulumi.Input['PipelineJobBackfillPipelineJobArgs'] backfill_pipeline_job: Specifies the backfill configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset: Healthcare Dataset under which the Pipeline Job is to run
        :param pulumi.Input[_builtins.bool] disable_lineage: If true, disables writing lineage for the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize Pipeline Jobs.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, and must conform to the following PCRE regular expression:
               [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a
               UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE
               regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given pipeline.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location where the Pipeline Job is to run
        :param pulumi.Input['PipelineJobMappingPipelineJobArgs'] mapping_pipeline_job: Specifies mapping configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the pipeline job. This field is user-assigned.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['PipelineJobReconciliationPipelineJobArgs'] reconciliation_pipeline_job: Specifies reconciliation configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The fully qualified name of this dataset
        """
        if backfill_pipeline_job is not None:
            pulumi.set(__self__, "backfill_pipeline_job", backfill_pipeline_job)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if disable_lineage is not None:
            pulumi.set(__self__, "disable_lineage", disable_lineage)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mapping_pipeline_job is not None:
            pulumi.set(__self__, "mapping_pipeline_job", mapping_pipeline_job)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reconciliation_pipeline_job is not None:
            pulumi.set(__self__, "reconciliation_pipeline_job", reconciliation_pipeline_job)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @_builtins.property
    @pulumi.getter(name="backfillPipelineJob")
    def backfill_pipeline_job(self) -> Optional[pulumi.Input['PipelineJobBackfillPipelineJobArgs']]:
        """
        Specifies the backfill configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_pipeline_job")

    @backfill_pipeline_job.setter
    def backfill_pipeline_job(self, value: Optional[pulumi.Input['PipelineJobBackfillPipelineJobArgs']]):
        pulumi.set(self, "backfill_pipeline_job", value)

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Healthcare Dataset under which the Pipeline Job is to run
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dataset", value)

    @_builtins.property
    @pulumi.getter(name="disableLineage")
    def disable_lineage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, disables writing lineage for the pipeline.
        """
        return pulumi.get(self, "disable_lineage")

    @disable_lineage.setter
    def disable_lineage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_lineage", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-supplied key-value pairs used to organize Pipeline Jobs.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of
        maximum 128 bytes, and must conform to the following PCRE regular expression:
        [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values are optional, must be between 1 and 63 characters long, have a
        UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE
        regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be associated with a given pipeline.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Location where the Pipeline Job is to run
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mappingPipelineJob")
    def mapping_pipeline_job(self) -> Optional[pulumi.Input['PipelineJobMappingPipelineJobArgs']]:
        """
        Specifies mapping configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "mapping_pipeline_job")

    @mapping_pipeline_job.setter
    def mapping_pipeline_job(self, value: Optional[pulumi.Input['PipelineJobMappingPipelineJobArgs']]):
        pulumi.set(self, "mapping_pipeline_job", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the pipeline job. This field is user-assigned.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="reconciliationPipelineJob")
    def reconciliation_pipeline_job(self) -> Optional[pulumi.Input['PipelineJobReconciliationPipelineJobArgs']]:
        """
        Specifies reconciliation configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "reconciliation_pipeline_job")

    @reconciliation_pipeline_job.setter
    def reconciliation_pipeline_job(self, value: Optional[pulumi.Input['PipelineJobReconciliationPipelineJobArgs']]):
        pulumi.set(self, "reconciliation_pipeline_job", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of this dataset
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)


@pulumi.type_token("gcp:healthcare/pipelineJob:PipelineJob")
class PipelineJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backfill_pipeline_job: Optional[pulumi.Input[Union['PipelineJobBackfillPipelineJobArgs', 'PipelineJobBackfillPipelineJobArgsDict']]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_lineage: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_pipeline_job: Optional[pulumi.Input[Union['PipelineJobMappingPipelineJobArgs', 'PipelineJobMappingPipelineJobArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reconciliation_pipeline_job: Optional[pulumi.Input[Union['PipelineJobReconciliationPipelineJobArgs', 'PipelineJobReconciliationPipelineJobArgsDict']]] = None,
                 __props__=None):
        """
        PipelineJobs are Long Running Operations on Healthcare API to Map or Reconcile
        incoming data into FHIR format

        To get more information about PipelineJob, see:

        * [API documentation](https://cloud.google.com/healthcare-api/healthcare-data-engine/docs/reference/rest/v1/projects.locations.datasets.pipelineJobs)
        * How-to Guides
            * [Creating a PipelineJob](https://cloud.google.com/healthcare-api/private/healthcare-data-engine/docs/reference/rest/v1/projects.locations.datasets.pipelineJobs#PipelineJob)

        ## Example Usage

        ### Healthcare Pipeline Job Reconciliation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        fhirstore = gcp.healthcare.FhirStore("fhirstore",
            name="fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        bucket = gcp.storage.Bucket("bucket",
            name="example_bucket_name",
            location="us-central1",
            uniform_bucket_level_access=True)
        merge_file = gcp.storage.BucketObject("merge_file",
            name="merge.wstl",
            content=" ",
            bucket=bucket.name)
        example_pipeline = gcp.healthcare.PipelineJob("example-pipeline",
            name="example_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            reconciliation_pipeline_job={
                "merge_config": {
                    "description": "sample description for reconciliation rules",
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mergeFileName=merge_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mergeFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                },
                "matching_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                "fhir_store_destination": pulumi.Output.all(
                    id=dataset.id,
                    name=fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
            })
        hsa = gcp.storage.BucketIAMMember("hsa",
            bucket=bucket.name,
            role="roles/storage.objectUser",
            member=f"serviceAccount:service-{project.number}@gcp-sa-healthcare.iam.gserviceaccount.com")
        ```
        ### Healthcare Pipeline Job Backfill

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        example_pipeline = gcp.healthcare.PipelineJob("example-pipeline",
            name="example_backfill_pipeline",
            location="us-central1",
            dataset=dataset.id,
            backfill_pipeline_job={
                "mapping_pipeline_job": dataset.id.apply(lambda id: f"{id}/pipelineJobs/example_mapping_pipeline_job"),
            })
        ```
        ### Healthcare Pipeline Job Whistle Mapping

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        source_fhirstore = gcp.healthcare.FhirStore("source_fhirstore",
            name="source_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        dest_fhirstore = gcp.healthcare.FhirStore("dest_fhirstore",
            name="dest_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        bucket = gcp.storage.Bucket("bucket",
            name="example_bucket_name",
            location="us-central1",
            uniform_bucket_level_access=True)
        mapping_file = gcp.storage.BucketObject("mapping_file",
            name="mapping.wstl",
            content=" ",
            bucket=bucket.name)
        example_mapping_pipeline = gcp.healthcare.PipelineJob("example-mapping-pipeline",
            name="example_mapping_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            labels={
                "example_label_key": "example_label_value",
            },
            mapping_pipeline_job={
                "mapping_config": {
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mappingFileName=mapping_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mappingFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                    "description": "example description for mapping configuration",
                },
                "fhir_streaming_source": {
                    "fhir_store": pulumi.Output.all(
                        id=dataset.id,
                        name=source_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
                    "description": "example description for streaming fhirstore",
                },
                "fhir_store_destination": pulumi.Output.all(
                    id=dataset.id,
                    name=dest_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
            })
        hsa = gcp.storage.BucketIAMMember("hsa",
            bucket=bucket.name,
            role="roles/storage.objectUser",
            member=f"serviceAccount:service-{project.number}@gcp-sa-healthcare.iam.gserviceaccount.com")
        ```
        ### Healthcare Pipeline Job Mapping Recon Dest

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        dest_fhirstore = gcp.healthcare.FhirStore("dest_fhirstore",
            name="dest_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        bucket = gcp.storage.Bucket("bucket",
            name="example_bucket_name",
            location="us-central1",
            uniform_bucket_level_access=True)
        merge_file = gcp.storage.BucketObject("merge_file",
            name="merge.wstl",
            content=" ",
            bucket=bucket.name)
        recon = gcp.healthcare.PipelineJob("recon",
            name="example_recon_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            reconciliation_pipeline_job={
                "merge_config": {
                    "description": "sample description for reconciliation rules",
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mergeFileName=merge_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mergeFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                },
                "matching_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                "fhir_store_destination": pulumi.Output.all(
                    id=dataset.id,
                    name=dest_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
            })
        source_fhirstore = gcp.healthcare.FhirStore("source_fhirstore",
            name="source_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        mapping_file = gcp.storage.BucketObject("mapping_file",
            name="mapping.wstl",
            content=" ",
            bucket=bucket.name)
        example_mapping_pipeline = gcp.healthcare.PipelineJob("example-mapping-pipeline",
            name="example_mapping_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            labels={
                "example_label_key": "example_label_value",
            },
            mapping_pipeline_job={
                "mapping_config": {
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mappingFileName=mapping_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mappingFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                    "description": "example description for mapping configuration",
                },
                "fhir_streaming_source": {
                    "fhir_store": pulumi.Output.all(
                        id=dataset.id,
                        name=source_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
                    "description": "example description for streaming fhirstore",
                },
                "reconciliation_destination": True,
            },
            opts = pulumi.ResourceOptions(depends_on=[recon]))
        hsa = gcp.storage.BucketIAMMember("hsa",
            bucket=bucket.name,
            role="roles/storage.objectUser",
            member=f"serviceAccount:service-{project.number}@gcp-sa-healthcare.iam.gserviceaccount.com")
        ```

        ## Import

        PipelineJob can be imported using any of these accepted formats:

        * `{{dataset}}/pipelineJobs/{{name}}`

        * `{{dataset}}/pipelineJobs?pipelineJobId={{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PipelineJob can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:healthcare/pipelineJob:PipelineJob default {{dataset}}/pipelineJobs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:healthcare/pipelineJob:PipelineJob default {{dataset}}/pipelineJobs?pipelineJobId={{name}}
        ```

        ```sh
        $ pulumi import gcp:healthcare/pipelineJob:PipelineJob default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PipelineJobBackfillPipelineJobArgs', 'PipelineJobBackfillPipelineJobArgsDict']] backfill_pipeline_job: Specifies the backfill configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset: Healthcare Dataset under which the Pipeline Job is to run
        :param pulumi.Input[_builtins.bool] disable_lineage: If true, disables writing lineage for the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize Pipeline Jobs.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, and must conform to the following PCRE regular expression:
               [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a
               UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE
               regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given pipeline.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location where the Pipeline Job is to run
        :param pulumi.Input[Union['PipelineJobMappingPipelineJobArgs', 'PipelineJobMappingPipelineJobArgsDict']] mapping_pipeline_job: Specifies mapping configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the pipeline job. This field is user-assigned.
        :param pulumi.Input[Union['PipelineJobReconciliationPipelineJobArgs', 'PipelineJobReconciliationPipelineJobArgsDict']] reconciliation_pipeline_job: Specifies reconciliation configuration.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PipelineJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        PipelineJobs are Long Running Operations on Healthcare API to Map or Reconcile
        incoming data into FHIR format

        To get more information about PipelineJob, see:

        * [API documentation](https://cloud.google.com/healthcare-api/healthcare-data-engine/docs/reference/rest/v1/projects.locations.datasets.pipelineJobs)
        * How-to Guides
            * [Creating a PipelineJob](https://cloud.google.com/healthcare-api/private/healthcare-data-engine/docs/reference/rest/v1/projects.locations.datasets.pipelineJobs#PipelineJob)

        ## Example Usage

        ### Healthcare Pipeline Job Reconciliation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        fhirstore = gcp.healthcare.FhirStore("fhirstore",
            name="fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        bucket = gcp.storage.Bucket("bucket",
            name="example_bucket_name",
            location="us-central1",
            uniform_bucket_level_access=True)
        merge_file = gcp.storage.BucketObject("merge_file",
            name="merge.wstl",
            content=" ",
            bucket=bucket.name)
        example_pipeline = gcp.healthcare.PipelineJob("example-pipeline",
            name="example_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            reconciliation_pipeline_job={
                "merge_config": {
                    "description": "sample description for reconciliation rules",
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mergeFileName=merge_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mergeFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                },
                "matching_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                "fhir_store_destination": pulumi.Output.all(
                    id=dataset.id,
                    name=fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
            })
        hsa = gcp.storage.BucketIAMMember("hsa",
            bucket=bucket.name,
            role="roles/storage.objectUser",
            member=f"serviceAccount:service-{project.number}@gcp-sa-healthcare.iam.gserviceaccount.com")
        ```
        ### Healthcare Pipeline Job Backfill

        ```python
        import pulumi
        import pulumi_gcp as gcp

        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        example_pipeline = gcp.healthcare.PipelineJob("example-pipeline",
            name="example_backfill_pipeline",
            location="us-central1",
            dataset=dataset.id,
            backfill_pipeline_job={
                "mapping_pipeline_job": dataset.id.apply(lambda id: f"{id}/pipelineJobs/example_mapping_pipeline_job"),
            })
        ```
        ### Healthcare Pipeline Job Whistle Mapping

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        source_fhirstore = gcp.healthcare.FhirStore("source_fhirstore",
            name="source_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        dest_fhirstore = gcp.healthcare.FhirStore("dest_fhirstore",
            name="dest_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        bucket = gcp.storage.Bucket("bucket",
            name="example_bucket_name",
            location="us-central1",
            uniform_bucket_level_access=True)
        mapping_file = gcp.storage.BucketObject("mapping_file",
            name="mapping.wstl",
            content=" ",
            bucket=bucket.name)
        example_mapping_pipeline = gcp.healthcare.PipelineJob("example-mapping-pipeline",
            name="example_mapping_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            labels={
                "example_label_key": "example_label_value",
            },
            mapping_pipeline_job={
                "mapping_config": {
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mappingFileName=mapping_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mappingFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                    "description": "example description for mapping configuration",
                },
                "fhir_streaming_source": {
                    "fhir_store": pulumi.Output.all(
                        id=dataset.id,
                        name=source_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
                    "description": "example description for streaming fhirstore",
                },
                "fhir_store_destination": pulumi.Output.all(
                    id=dataset.id,
                    name=dest_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
            })
        hsa = gcp.storage.BucketIAMMember("hsa",
            bucket=bucket.name,
            role="roles/storage.objectUser",
            member=f"serviceAccount:service-{project.number}@gcp-sa-healthcare.iam.gserviceaccount.com")
        ```
        ### Healthcare Pipeline Job Mapping Recon Dest

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        dataset = gcp.healthcare.Dataset("dataset",
            name="example_dataset",
            location="us-central1")
        dest_fhirstore = gcp.healthcare.FhirStore("dest_fhirstore",
            name="dest_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        bucket = gcp.storage.Bucket("bucket",
            name="example_bucket_name",
            location="us-central1",
            uniform_bucket_level_access=True)
        merge_file = gcp.storage.BucketObject("merge_file",
            name="merge.wstl",
            content=" ",
            bucket=bucket.name)
        recon = gcp.healthcare.PipelineJob("recon",
            name="example_recon_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            reconciliation_pipeline_job={
                "merge_config": {
                    "description": "sample description for reconciliation rules",
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mergeFileName=merge_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mergeFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                },
                "matching_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                "fhir_store_destination": pulumi.Output.all(
                    id=dataset.id,
                    name=dest_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
            })
        source_fhirstore = gcp.healthcare.FhirStore("source_fhirstore",
            name="source_fhir_store",
            dataset=dataset.id,
            version="R4",
            enable_update_create=True,
            disable_referential_integrity=True)
        mapping_file = gcp.storage.BucketObject("mapping_file",
            name="mapping.wstl",
            content=" ",
            bucket=bucket.name)
        example_mapping_pipeline = gcp.healthcare.PipelineJob("example-mapping-pipeline",
            name="example_mapping_pipeline_job",
            location="us-central1",
            dataset=dataset.id,
            disable_lineage=True,
            labels={
                "example_label_key": "example_label_value",
            },
            mapping_pipeline_job={
                "mapping_config": {
                    "whistle_config_source": {
                        "uri": pulumi.Output.all(
                            bucketName=bucket.name,
                            mappingFileName=mapping_file.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucketName']}/{resolved_outputs['mappingFileName']}")
        ,
                        "import_uri_prefix": bucket.name.apply(lambda name: f"gs://{name}"),
                    },
                    "description": "example description for mapping configuration",
                },
                "fhir_streaming_source": {
                    "fhir_store": pulumi.Output.all(
                        id=dataset.id,
                        name=source_fhirstore.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['id']}/fhirStores/{resolved_outputs['name']}")
        ,
                    "description": "example description for streaming fhirstore",
                },
                "reconciliation_destination": True,
            },
            opts = pulumi.ResourceOptions(depends_on=[recon]))
        hsa = gcp.storage.BucketIAMMember("hsa",
            bucket=bucket.name,
            role="roles/storage.objectUser",
            member=f"serviceAccount:service-{project.number}@gcp-sa-healthcare.iam.gserviceaccount.com")
        ```

        ## Import

        PipelineJob can be imported using any of these accepted formats:

        * `{{dataset}}/pipelineJobs/{{name}}`

        * `{{dataset}}/pipelineJobs?pipelineJobId={{name}}`

        * `{{name}}`

        When using the `pulumi import` command, PipelineJob can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:healthcare/pipelineJob:PipelineJob default {{dataset}}/pipelineJobs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:healthcare/pipelineJob:PipelineJob default {{dataset}}/pipelineJobs?pipelineJobId={{name}}
        ```

        ```sh
        $ pulumi import gcp:healthcare/pipelineJob:PipelineJob default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PipelineJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backfill_pipeline_job: Optional[pulumi.Input[Union['PipelineJobBackfillPipelineJobArgs', 'PipelineJobBackfillPipelineJobArgsDict']]] = None,
                 dataset: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_lineage: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mapping_pipeline_job: Optional[pulumi.Input[Union['PipelineJobMappingPipelineJobArgs', 'PipelineJobMappingPipelineJobArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reconciliation_pipeline_job: Optional[pulumi.Input[Union['PipelineJobReconciliationPipelineJobArgs', 'PipelineJobReconciliationPipelineJobArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineJobArgs.__new__(PipelineJobArgs)

            __props__.__dict__["backfill_pipeline_job"] = backfill_pipeline_job
            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["disable_lineage"] = disable_lineage
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["mapping_pipeline_job"] = mapping_pipeline_job
            __props__.__dict__["name"] = name
            __props__.__dict__["reconciliation_pipeline_job"] = reconciliation_pipeline_job
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PipelineJob, __self__).__init__(
            'gcp:healthcare/pipelineJob:PipelineJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backfill_pipeline_job: Optional[pulumi.Input[Union['PipelineJobBackfillPipelineJobArgs', 'PipelineJobBackfillPipelineJobArgsDict']]] = None,
            dataset: Optional[pulumi.Input[_builtins.str]] = None,
            disable_lineage: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mapping_pipeline_job: Optional[pulumi.Input[Union['PipelineJobMappingPipelineJobArgs', 'PipelineJobMappingPipelineJobArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            reconciliation_pipeline_job: Optional[pulumi.Input[Union['PipelineJobReconciliationPipelineJobArgs', 'PipelineJobReconciliationPipelineJobArgsDict']]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None) -> 'PipelineJob':
        """
        Get an existing PipelineJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PipelineJobBackfillPipelineJobArgs', 'PipelineJobBackfillPipelineJobArgsDict']] backfill_pipeline_job: Specifies the backfill configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] dataset: Healthcare Dataset under which the Pipeline Job is to run
        :param pulumi.Input[_builtins.bool] disable_lineage: If true, disables writing lineage for the pipeline.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-supplied key-value pairs used to organize Pipeline Jobs.
               Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of
               maximum 128 bytes, and must conform to the following PCRE regular expression:
               [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
               Label values are optional, must be between 1 and 63 characters long, have a
               UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE
               regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
               No more than 64 labels can be associated with a given pipeline.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Location where the Pipeline Job is to run
        :param pulumi.Input[Union['PipelineJobMappingPipelineJobArgs', 'PipelineJobMappingPipelineJobArgsDict']] mapping_pipeline_job: Specifies mapping configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the pipeline job. This field is user-assigned.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['PipelineJobReconciliationPipelineJobArgs', 'PipelineJobReconciliationPipelineJobArgsDict']] reconciliation_pipeline_job: Specifies reconciliation configuration.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] self_link: The fully qualified name of this dataset
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineJobState.__new__(_PipelineJobState)

        __props__.__dict__["backfill_pipeline_job"] = backfill_pipeline_job
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["disable_lineage"] = disable_lineage
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mapping_pipeline_job"] = mapping_pipeline_job
        __props__.__dict__["name"] = name
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reconciliation_pipeline_job"] = reconciliation_pipeline_job
        __props__.__dict__["self_link"] = self_link
        return PipelineJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backfillPipelineJob")
    def backfill_pipeline_job(self) -> pulumi.Output[Optional['outputs.PipelineJobBackfillPipelineJob']]:
        """
        Specifies the backfill configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "backfill_pipeline_job")

    @_builtins.property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[_builtins.str]:
        """
        Healthcare Dataset under which the Pipeline Job is to run
        """
        return pulumi.get(self, "dataset")

    @_builtins.property
    @pulumi.getter(name="disableLineage")
    def disable_lineage(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, disables writing lineage for the pipeline.
        """
        return pulumi.get(self, "disable_lineage")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-supplied key-value pairs used to organize Pipeline Jobs.
        Label keys must be between 1 and 63 characters long, have a UTF-8 encoding of
        maximum 128 bytes, and must conform to the following PCRE regular expression:
        [\\p{Ll}\\p{Lo}][\\p{Ll}\\p{Lo}\\p{N}_-]{0,62}
        Label values are optional, must be between 1 and 63 characters long, have a
        UTF-8 encoding of maximum 128 bytes, and must conform to the following PCRE
        regular expression: [\\p{Ll}\\p{Lo}\\p{N}_-]{0,63}
        No more than 64 labels can be associated with a given pipeline.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Location where the Pipeline Job is to run
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mappingPipelineJob")
    def mapping_pipeline_job(self) -> pulumi.Output[Optional['outputs.PipelineJobMappingPipelineJob']]:
        """
        Specifies mapping configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "mapping_pipeline_job")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the pipeline job. This field is user-assigned.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="reconciliationPipelineJob")
    def reconciliation_pipeline_job(self) -> pulumi.Output[Optional['outputs.PipelineJobReconciliationPipelineJob']]:
        """
        Specifies reconciliation configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "reconciliation_pipeline_job")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of this dataset
        """
        return pulumi.get(self, "self_link")

