# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TenantDefaultSupportedIdpConfigArgs', 'TenantDefaultSupportedIdpConfig']

@pulumi.input_type
class TenantDefaultSupportedIdpConfigArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[_builtins.str],
                 client_secret: pulumi.Input[_builtins.str],
                 idp_id: pulumi.Input[_builtins.str],
                 tenant: pulumi.Input[_builtins.str],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a TenantDefaultSupportedIdpConfig resource.
        :param pulumi.Input[_builtins.str] client_id: OAuth client ID
        :param pulumi.Input[_builtins.str] client_secret: OAuth client secret
        :param pulumi.Input[_builtins.str] idp_id: ID of the IDP. Possible values include:
               * `apple.com`
               * `facebook.com`
               * `gc.apple.com`
               * `github.com`
               * `google.com`
               * `linkedin.com`
               * `microsoft.com`
               * `playgames.google.com`
               * `twitter.com`
               * `yahoo.com`
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this DefaultSupportedIdpConfig resource exists
        :param pulumi.Input[_builtins.bool] enabled: If this IDP allows the user to sign in
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "idp_id", idp_id)
        pulumi.set(__self__, "tenant", tenant)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        OAuth client ID
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[_builtins.str]:
        """
        OAuth client secret
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the IDP. Possible values include:
        * `apple.com`
        * `facebook.com`
        * `gc.apple.com`
        * `github.com`
        * `google.com`
        * `linkedin.com`
        * `microsoft.com`
        * `playgames.google.com`
        * `twitter.com`
        * `yahoo.com`
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "idp_id", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the tenant where this DefaultSupportedIdpConfig resource exists
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this IDP allows the user to sign in
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _TenantDefaultSupportedIdpConfigState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TenantDefaultSupportedIdpConfig resources.
        :param pulumi.Input[_builtins.str] client_id: OAuth client ID
        :param pulumi.Input[_builtins.str] client_secret: OAuth client secret
        :param pulumi.Input[_builtins.bool] enabled: If this IDP allows the user to sign in
        :param pulumi.Input[_builtins.str] idp_id: ID of the IDP. Possible values include:
               * `apple.com`
               * `facebook.com`
               * `gc.apple.com`
               * `github.com`
               * `google.com`
               * `linkedin.com`
               * `microsoft.com`
               * `playgames.google.com`
               * `twitter.com`
               * `yahoo.com`
        :param pulumi.Input[_builtins.str] name: The name of the default supported IDP config resource
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this DefaultSupportedIdpConfig resource exists
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if idp_id is not None:
            pulumi.set(__self__, "idp_id", idp_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tenant is not None:
            pulumi.set(__self__, "tenant", tenant)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth client ID
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        OAuth client secret
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If this IDP allows the user to sign in
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the IDP. Possible values include:
        * `apple.com`
        * `facebook.com`
        * `gc.apple.com`
        * `github.com`
        * `google.com`
        * `linkedin.com`
        * `microsoft.com`
        * `playgames.google.com`
        * `twitter.com`
        * `yahoo.com`
        """
        return pulumi.get(self, "idp_id")

    @idp_id.setter
    def idp_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "idp_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the default supported IDP config resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the tenant where this DefaultSupportedIdpConfig resource exists
        """
        return pulumi.get(self, "tenant")

    @tenant.setter
    def tenant(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant", value)


@pulumi.type_token("gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig")
class TenantDefaultSupportedIdpConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Configurations options for the tenant for authenticating with a the standard set of Identity Toolkit-trusted IDPs.

        You must enable the
        [Google Identity Platform](https://console.cloud.google.com/marketplace/details/google-cloud-platform/customer-identity) in
        the marketplace prior to using this resource.

        ## Example Usage

        ### Identity Platform Tenant Default Supported Idp Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tenant = gcp.identityplatform.Tenant("tenant", display_name="tenant")
        idp_config = gcp.identityplatform.TenantDefaultSupportedIdpConfig("idp_config",
            enabled=True,
            tenant=tenant.name,
            idp_id="playgames.google.com",
            client_id="my-client-id",
            client_secret="secret")
        ```

        ## Import

        TenantDefaultSupportedIdpConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/tenants/{{tenant}}/defaultSupportedIdpConfigs/{{idp_id}}`

        * `{{project}}/{{tenant}}/{{idp_id}}`

        * `{{tenant}}/{{idp_id}}`

        When using the `pulumi import` command, TenantDefaultSupportedIdpConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig default projects/{{project}}/tenants/{{tenant}}/defaultSupportedIdpConfigs/{{idp_id}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig default {{project}}/{{tenant}}/{{idp_id}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig default {{tenant}}/{{idp_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: OAuth client ID
        :param pulumi.Input[_builtins.str] client_secret: OAuth client secret
        :param pulumi.Input[_builtins.bool] enabled: If this IDP allows the user to sign in
        :param pulumi.Input[_builtins.str] idp_id: ID of the IDP. Possible values include:
               * `apple.com`
               * `facebook.com`
               * `gc.apple.com`
               * `github.com`
               * `google.com`
               * `linkedin.com`
               * `microsoft.com`
               * `playgames.google.com`
               * `twitter.com`
               * `yahoo.com`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this DefaultSupportedIdpConfig resource exists
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TenantDefaultSupportedIdpConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configurations options for the tenant for authenticating with a the standard set of Identity Toolkit-trusted IDPs.

        You must enable the
        [Google Identity Platform](https://console.cloud.google.com/marketplace/details/google-cloud-platform/customer-identity) in
        the marketplace prior to using this resource.

        ## Example Usage

        ### Identity Platform Tenant Default Supported Idp Config Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tenant = gcp.identityplatform.Tenant("tenant", display_name="tenant")
        idp_config = gcp.identityplatform.TenantDefaultSupportedIdpConfig("idp_config",
            enabled=True,
            tenant=tenant.name,
            idp_id="playgames.google.com",
            client_id="my-client-id",
            client_secret="secret")
        ```

        ## Import

        TenantDefaultSupportedIdpConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/tenants/{{tenant}}/defaultSupportedIdpConfigs/{{idp_id}}`

        * `{{project}}/{{tenant}}/{{idp_id}}`

        * `{{tenant}}/{{idp_id}}`

        When using the `pulumi import` command, TenantDefaultSupportedIdpConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig default projects/{{project}}/tenants/{{tenant}}/defaultSupportedIdpConfigs/{{idp_id}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig default {{project}}/{{tenant}}/{{idp_id}}
        ```

        ```sh
        $ pulumi import gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig default {{tenant}}/{{idp_id}}
        ```

        :param str resource_name: The name of the resource.
        :param TenantDefaultSupportedIdpConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantDefaultSupportedIdpConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 idp_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantDefaultSupportedIdpConfigArgs.__new__(TenantDefaultSupportedIdpConfigArgs)

            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["enabled"] = enabled
            if idp_id is None and not opts.urn:
                raise TypeError("Missing required property 'idp_id'")
            __props__.__dict__["idp_id"] = idp_id
            __props__.__dict__["project"] = project
            if tenant is None and not opts.urn:
                raise TypeError("Missing required property 'tenant'")
            __props__.__dict__["tenant"] = tenant
            __props__.__dict__["name"] = None
        super(TenantDefaultSupportedIdpConfig, __self__).__init__(
            'gcp:identityplatform/tenantDefaultSupportedIdpConfig:TenantDefaultSupportedIdpConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            idp_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            tenant: Optional[pulumi.Input[_builtins.str]] = None) -> 'TenantDefaultSupportedIdpConfig':
        """
        Get an existing TenantDefaultSupportedIdpConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] client_id: OAuth client ID
        :param pulumi.Input[_builtins.str] client_secret: OAuth client secret
        :param pulumi.Input[_builtins.bool] enabled: If this IDP allows the user to sign in
        :param pulumi.Input[_builtins.str] idp_id: ID of the IDP. Possible values include:
               * `apple.com`
               * `facebook.com`
               * `gc.apple.com`
               * `github.com`
               * `google.com`
               * `linkedin.com`
               * `microsoft.com`
               * `playgames.google.com`
               * `twitter.com`
               * `yahoo.com`
        :param pulumi.Input[_builtins.str] name: The name of the default supported IDP config resource
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] tenant: The name of the tenant where this DefaultSupportedIdpConfig resource exists
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantDefaultSupportedIdpConfigState.__new__(_TenantDefaultSupportedIdpConfigState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["idp_id"] = idp_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["tenant"] = tenant
        return TenantDefaultSupportedIdpConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        OAuth client ID
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        OAuth client secret
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If this IDP allows the user to sign in
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="idpId")
    def idp_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the IDP. Possible values include:
        * `apple.com`
        * `facebook.com`
        * `gc.apple.com`
        * `github.com`
        * `google.com`
        * `linkedin.com`
        * `microsoft.com`
        * `playgames.google.com`
        * `twitter.com`
        * `yahoo.com`
        """
        return pulumi.get(self, "idp_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the default supported IDP config resource
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def tenant(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the tenant where this DefaultSupportedIdpConfig resource exists
        """
        return pulumi.get(self, "tenant")

