# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionAuthConfig',
    'ConnectionAuthConfigAdditionalVariable',
    'ConnectionAuthConfigAdditionalVariableEncryptionKeyValue',
    'ConnectionAuthConfigAdditionalVariableSecretValue',
    'ConnectionAuthConfigOauth2AuthCodeFlow',
    'ConnectionAuthConfigOauth2AuthCodeFlowClientSecret',
    'ConnectionAuthConfigOauth2ClientCredentials',
    'ConnectionAuthConfigOauth2ClientCredentialsClientSecret',
    'ConnectionAuthConfigOauth2JwtBearer',
    'ConnectionAuthConfigOauth2JwtBearerClientKey',
    'ConnectionAuthConfigOauth2JwtBearerJwtClaims',
    'ConnectionAuthConfigSshPublicKey',
    'ConnectionAuthConfigSshPublicKeySshClientCert',
    'ConnectionAuthConfigSshPublicKeySshClientCertPass',
    'ConnectionAuthConfigUserPassword',
    'ConnectionAuthConfigUserPasswordPassword',
    'ConnectionConfigVariable',
    'ConnectionConfigVariableEncryptionKeyValue',
    'ConnectionConfigVariableSecretValue',
    'ConnectionConnectorVersionInfraConfig',
    'ConnectionDestinationConfig',
    'ConnectionDestinationConfigDestination',
    'ConnectionEventingConfig',
    'ConnectionEventingConfigAdditionalVariable',
    'ConnectionEventingConfigAdditionalVariableEncryptionKeyValue',
    'ConnectionEventingConfigAdditionalVariableSecretValue',
    'ConnectionEventingConfigAuthConfig',
    'ConnectionEventingConfigAuthConfigAdditionalVariable',
    'ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue',
    'ConnectionEventingConfigAuthConfigAdditionalVariableSecretValue',
    'ConnectionEventingConfigAuthConfigUserPassword',
    'ConnectionEventingConfigAuthConfigUserPasswordPassword',
    'ConnectionEventingConfigRegistrationDestinationConfig',
    'ConnectionEventingConfigRegistrationDestinationConfigDestination',
    'ConnectionEventingRuntimeData',
    'ConnectionEventingRuntimeDataStatus',
    'ConnectionLockConfig',
    'ConnectionLogConfig',
    'ConnectionNodeConfig',
    'ConnectionSslConfig',
    'ConnectionSslConfigAdditionalVariable',
    'ConnectionSslConfigAdditionalVariableEncryptionKeyValue',
    'ConnectionSslConfigAdditionalVariableSecretValue',
    'ConnectionSslConfigClientCertificate',
    'ConnectionSslConfigClientPrivateKey',
    'ConnectionSslConfigClientPrivateKeyPass',
    'ConnectionSslConfigPrivateServerCertificate',
    'ConnectionStatus',
]

@pulumi.output_type
class ConnectionAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "additionalVariables":
            suggest = "additional_variables"
        elif key == "authKey":
            suggest = "auth_key"
        elif key == "oauth2AuthCodeFlow":
            suggest = "oauth2_auth_code_flow"
        elif key == "oauth2ClientCredentials":
            suggest = "oauth2_client_credentials"
        elif key == "oauth2JwtBearer":
            suggest = "oauth2_jwt_bearer"
        elif key == "sshPublicKey":
            suggest = "ssh_public_key"
        elif key == "userPassword":
            suggest = "user_password"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str,
                 additional_variables: Optional[Sequence['outputs.ConnectionAuthConfigAdditionalVariable']] = None,
                 auth_key: Optional[_builtins.str] = None,
                 oauth2_auth_code_flow: Optional['outputs.ConnectionAuthConfigOauth2AuthCodeFlow'] = None,
                 oauth2_client_credentials: Optional['outputs.ConnectionAuthConfigOauth2ClientCredentials'] = None,
                 oauth2_jwt_bearer: Optional['outputs.ConnectionAuthConfigOauth2JwtBearer'] = None,
                 ssh_public_key: Optional['outputs.ConnectionAuthConfigSshPublicKey'] = None,
                 user_password: Optional['outputs.ConnectionAuthConfigUserPassword'] = None):
        """
        :param _builtins.str auth_type: authType of the Connection
               Possible values are: `USER_PASSWORD`.
        :param Sequence['ConnectionAuthConfigAdditionalVariableArgs'] additional_variables: List containing additional auth configs.
               Structure is documented below.
        :param _builtins.str auth_key: The type of authentication configured.
        :param 'ConnectionAuthConfigOauth2AuthCodeFlowArgs' oauth2_auth_code_flow: Parameters to support Oauth 2.0 Auth Code Grant Authentication.
               Structure is documented below.
        :param 'ConnectionAuthConfigOauth2ClientCredentialsArgs' oauth2_client_credentials: OAuth3 Client Credentials for Authentication.
               Structure is documented below.
        :param 'ConnectionAuthConfigOauth2JwtBearerArgs' oauth2_jwt_bearer: OAuth2 JWT Bearer for Authentication.
               Structure is documented below.
        :param 'ConnectionAuthConfigSshPublicKeyArgs' ssh_public_key: SSH Public Key for Authentication.
               Structure is documented below.
        :param 'ConnectionAuthConfigUserPasswordArgs' user_password: User password for Authentication.
               Structure is documented below.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        if additional_variables is not None:
            pulumi.set(__self__, "additional_variables", additional_variables)
        if auth_key is not None:
            pulumi.set(__self__, "auth_key", auth_key)
        if oauth2_auth_code_flow is not None:
            pulumi.set(__self__, "oauth2_auth_code_flow", oauth2_auth_code_flow)
        if oauth2_client_credentials is not None:
            pulumi.set(__self__, "oauth2_client_credentials", oauth2_client_credentials)
        if oauth2_jwt_bearer is not None:
            pulumi.set(__self__, "oauth2_jwt_bearer", oauth2_jwt_bearer)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        authType of the Connection
        Possible values are: `USER_PASSWORD`.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="additionalVariables")
    def additional_variables(self) -> Optional[Sequence['outputs.ConnectionAuthConfigAdditionalVariable']]:
        """
        List containing additional auth configs.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_variables")

    @_builtins.property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> Optional[_builtins.str]:
        """
        The type of authentication configured.
        """
        return pulumi.get(self, "auth_key")

    @_builtins.property
    @pulumi.getter(name="oauth2AuthCodeFlow")
    def oauth2_auth_code_flow(self) -> Optional['outputs.ConnectionAuthConfigOauth2AuthCodeFlow']:
        """
        Parameters to support Oauth 2.0 Auth Code Grant Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_auth_code_flow")

    @_builtins.property
    @pulumi.getter(name="oauth2ClientCredentials")
    def oauth2_client_credentials(self) -> Optional['outputs.ConnectionAuthConfigOauth2ClientCredentials']:
        """
        OAuth3 Client Credentials for Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_client_credentials")

    @_builtins.property
    @pulumi.getter(name="oauth2JwtBearer")
    def oauth2_jwt_bearer(self) -> Optional['outputs.ConnectionAuthConfigOauth2JwtBearer']:
        """
        OAuth2 JWT Bearer for Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "oauth2_jwt_bearer")

    @_builtins.property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional['outputs.ConnectionAuthConfigSshPublicKey']:
        """
        SSH Public Key for Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "ssh_public_key")

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional['outputs.ConnectionAuthConfigUserPassword']:
        """
        User password for Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "user_password")


@pulumi.output_type
class ConnectionAuthConfigAdditionalVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "encryptionKeyValue":
            suggest = "encryption_key_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "secretValue":
            suggest = "secret_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigAdditionalVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigAdditionalVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigAdditionalVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 boolean_value: Optional[_builtins.bool] = None,
                 encryption_key_value: Optional['outputs.ConnectionAuthConfigAdditionalVariableEncryptionKeyValue'] = None,
                 integer_value: Optional[_builtins.int] = None,
                 secret_value: Optional['outputs.ConnectionAuthConfigAdditionalVariableSecretValue'] = None,
                 string_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Key for the configVariable
        :param _builtins.bool boolean_value: Boolean Value of configVariable.
        :param 'ConnectionAuthConfigAdditionalVariableEncryptionKeyValueArgs' encryption_key_value: Encryption key value of configVariable.
               Structure is documented below.
        :param _builtins.int integer_value: Integer Value of configVariable.
        :param 'ConnectionAuthConfigAdditionalVariableSecretValueArgs' secret_value: Secret value of configVariable
               Structure is documented below.
        :param _builtins.str string_value: String Value of configVariabley.
        """
        pulumi.set(__self__, "key", key)
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if encryption_key_value is not None:
            pulumi.set(__self__, "encryption_key_value", encryption_key_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key for the configVariable
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[_builtins.bool]:
        """
        Boolean Value of configVariable.
        """
        return pulumi.get(self, "boolean_value")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyValue")
    def encryption_key_value(self) -> Optional['outputs.ConnectionAuthConfigAdditionalVariableEncryptionKeyValue']:
        """
        Encryption key value of configVariable.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key_value")

    @_builtins.property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[_builtins.int]:
        """
        Integer Value of configVariable.
        """
        return pulumi.get(self, "integer_value")

    @_builtins.property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional['outputs.ConnectionAuthConfigAdditionalVariableSecretValue']:
        """
        Secret value of configVariable
        Structure is documented below.
        """
        return pulumi.get(self, "secret_value")

    @_builtins.property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[_builtins.str]:
        """
        String Value of configVariabley.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class ConnectionAuthConfigAdditionalVariableEncryptionKeyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigAdditionalVariableEncryptionKeyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of Encryption Key
               Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        :param _builtins.str kms_key_name: The [KMS key name] with which the content of the Operation is encrypted. The
               expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
               Will be empty string if google managed.
        """
        pulumi.set(__self__, "type", type)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of Encryption Key
        Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The [KMS key name] with which the content of the Operation is encrypted. The
        expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
        Will be empty string if google managed.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ConnectionAuthConfigAdditionalVariableSecretValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigAdditionalVariableSecretValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionAuthConfigOauth2AuthCodeFlow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authUri":
            suggest = "auth_uri"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "enablePkce":
            suggest = "enable_pkce"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigOauth2AuthCodeFlow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigOauth2AuthCodeFlow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigOauth2AuthCodeFlow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_uri: Optional[_builtins.str] = None,
                 client_id: Optional[_builtins.str] = None,
                 client_secret: Optional['outputs.ConnectionAuthConfigOauth2AuthCodeFlowClientSecret'] = None,
                 enable_pkce: Optional[_builtins.bool] = None,
                 scopes: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str auth_uri: Auth URL for Authorization Code Flow.
        :param _builtins.str client_id: Client ID for user-provided OAuth app.
        :param 'ConnectionAuthConfigOauth2AuthCodeFlowClientSecretArgs' client_secret: Client secret for user-provided OAuth app.
        :param _builtins.bool enable_pkce: Whether to enable PKCE when the user performs the auth code flow.
        :param Sequence[_builtins.str] scopes: Scopes the connection will request when the user performs the auth code flow.
        """
        if auth_uri is not None:
            pulumi.set(__self__, "auth_uri", auth_uri)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enable_pkce is not None:
            pulumi.set(__self__, "enable_pkce", enable_pkce)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @_builtins.property
    @pulumi.getter(name="authUri")
    def auth_uri(self) -> Optional[_builtins.str]:
        """
        Auth URL for Authorization Code Flow.
        """
        return pulumi.get(self, "auth_uri")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        Client ID for user-provided OAuth app.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional['outputs.ConnectionAuthConfigOauth2AuthCodeFlowClientSecret']:
        """
        Client secret for user-provided OAuth app.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="enablePkce")
    def enable_pkce(self) -> Optional[_builtins.bool]:
        """
        Whether to enable PKCE when the user performs the auth code flow.
        """
        return pulumi.get(self, "enable_pkce")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Scopes the connection will request when the user performs the auth code flow.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ConnectionAuthConfigOauth2AuthCodeFlowClientSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigOauth2AuthCodeFlowClientSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigOauth2AuthCodeFlowClientSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigOauth2AuthCodeFlowClientSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: projects/*/secrets/*/versions/*.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionAuthConfigOauth2ClientCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigOauth2ClientCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigOauth2ClientCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigOauth2ClientCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: _builtins.str,
                 client_secret: Optional['outputs.ConnectionAuthConfigOauth2ClientCredentialsClientSecret'] = None):
        """
        :param _builtins.str client_id: Secret version of Password for Authentication.
        :param 'ConnectionAuthConfigOauth2ClientCredentialsClientSecretArgs' client_secret: Secret version reference containing the client secret.
        """
        pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> _builtins.str:
        """
        Secret version of Password for Authentication.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional['outputs.ConnectionAuthConfigOauth2ClientCredentialsClientSecret']:
        """
        Secret version reference containing the client secret.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class ConnectionAuthConfigOauth2ClientCredentialsClientSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigOauth2ClientCredentialsClientSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigOauth2ClientCredentialsClientSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigOauth2ClientCredentialsClientSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: projects/*/secrets/*/versions/*.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionAuthConfigOauth2JwtBearer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientKey":
            suggest = "client_key"
        elif key == "jwtClaims":
            suggest = "jwt_claims"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigOauth2JwtBearer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigOauth2JwtBearer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigOauth2JwtBearer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_key: Optional['outputs.ConnectionAuthConfigOauth2JwtBearerClientKey'] = None,
                 jwt_claims: Optional['outputs.ConnectionAuthConfigOauth2JwtBearerJwtClaims'] = None):
        """
        :param 'ConnectionAuthConfigOauth2JwtBearerClientKeyArgs' client_key: Secret version reference containing a PKCS#8 PEM-encoded private key associated with the Client Certificate.
               This private key will be used to sign JWTs used for the jwt-bearer authorization grant.
               Specified in the form as: projects/*/secrets/*/versions/*.
        :param 'ConnectionAuthConfigOauth2JwtBearerJwtClaimsArgs' jwt_claims: JwtClaims providers fields to generate the token.
        """
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if jwt_claims is not None:
            pulumi.set(__self__, "jwt_claims", jwt_claims)

    @_builtins.property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional['outputs.ConnectionAuthConfigOauth2JwtBearerClientKey']:
        """
        Secret version reference containing a PKCS#8 PEM-encoded private key associated with the Client Certificate.
        This private key will be used to sign JWTs used for the jwt-bearer authorization grant.
        Specified in the form as: projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "client_key")

    @_builtins.property
    @pulumi.getter(name="jwtClaims")
    def jwt_claims(self) -> Optional['outputs.ConnectionAuthConfigOauth2JwtBearerJwtClaims']:
        """
        JwtClaims providers fields to generate the token.
        """
        return pulumi.get(self, "jwt_claims")


@pulumi.output_type
class ConnectionAuthConfigOauth2JwtBearerClientKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigOauth2JwtBearerClientKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigOauth2JwtBearerClientKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigOauth2JwtBearerClientKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: projects/*/secrets/*/versions/*.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionAuthConfigOauth2JwtBearerJwtClaims(dict):
    def __init__(__self__, *,
                 audience: Optional[_builtins.str] = None,
                 issuer: Optional[_builtins.str] = None,
                 subject: Optional[_builtins.str] = None):
        """
        :param _builtins.str audience: Value for the "aud" claim.
               
               <a name="nested_auth_config_oauth2_client_credentials"></a>The `oauth2_client_credentials` block supports:
        :param _builtins.str issuer: Value for the "iss" claim.
        :param _builtins.str subject: Value for the "sub" claim.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @_builtins.property
    @pulumi.getter
    def audience(self) -> Optional[_builtins.str]:
        """
        Value for the "aud" claim.

        <a name="nested_auth_config_oauth2_client_credentials"></a>The `oauth2_client_credentials` block supports:
        """
        return pulumi.get(self, "audience")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> Optional[_builtins.str]:
        """
        Value for the "iss" claim.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def subject(self) -> Optional[_builtins.str]:
        """
        Value for the "sub" claim.
        """
        return pulumi.get(self, "subject")


@pulumi.output_type
class ConnectionAuthConfigSshPublicKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certType":
            suggest = "cert_type"
        elif key == "sshClientCert":
            suggest = "ssh_client_cert"
        elif key == "sshClientCertPass":
            suggest = "ssh_client_cert_pass"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigSshPublicKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigSshPublicKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigSshPublicKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 username: _builtins.str,
                 cert_type: Optional[_builtins.str] = None,
                 ssh_client_cert: Optional['outputs.ConnectionAuthConfigSshPublicKeySshClientCert'] = None,
                 ssh_client_cert_pass: Optional['outputs.ConnectionAuthConfigSshPublicKeySshClientCertPass'] = None):
        """
        :param _builtins.str username: The user account used to authenticate.
        :param _builtins.str cert_type: Format of SSH Client cert.
        :param 'ConnectionAuthConfigSshPublicKeySshClientCertArgs' ssh_client_cert: SSH Client Cert. It should contain both public and private key.
               Structure is documented below.
        :param 'ConnectionAuthConfigSshPublicKeySshClientCertPassArgs' ssh_client_cert_pass: Password (passphrase) for ssh client certificate if it has one.
               Structure is documented below.
        """
        pulumi.set(__self__, "username", username)
        if cert_type is not None:
            pulumi.set(__self__, "cert_type", cert_type)
        if ssh_client_cert is not None:
            pulumi.set(__self__, "ssh_client_cert", ssh_client_cert)
        if ssh_client_cert_pass is not None:
            pulumi.set(__self__, "ssh_client_cert_pass", ssh_client_cert_pass)

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The user account used to authenticate.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="certType")
    def cert_type(self) -> Optional[_builtins.str]:
        """
        Format of SSH Client cert.
        """
        return pulumi.get(self, "cert_type")

    @_builtins.property
    @pulumi.getter(name="sshClientCert")
    def ssh_client_cert(self) -> Optional['outputs.ConnectionAuthConfigSshPublicKeySshClientCert']:
        """
        SSH Client Cert. It should contain both public and private key.
        Structure is documented below.
        """
        return pulumi.get(self, "ssh_client_cert")

    @_builtins.property
    @pulumi.getter(name="sshClientCertPass")
    def ssh_client_cert_pass(self) -> Optional['outputs.ConnectionAuthConfigSshPublicKeySshClientCertPass']:
        """
        Password (passphrase) for ssh client certificate if it has one.
        Structure is documented below.
        """
        return pulumi.get(self, "ssh_client_cert_pass")


@pulumi.output_type
class ConnectionAuthConfigSshPublicKeySshClientCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigSshPublicKeySshClientCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigSshPublicKeySshClientCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigSshPublicKeySshClientCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: projects/*/secrets/*/versions/*.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionAuthConfigSshPublicKeySshClientCertPass(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigSshPublicKeySshClientCertPass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigSshPublicKeySshClientCertPass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigSshPublicKeySshClientCertPass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: projects/*/secrets/*/versions/*.
               
               <a name="nested_auth_config_oauth2_auth_code_flow"></a>The `oauth2_auth_code_flow` block supports:
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: projects/*/secrets/*/versions/*.

        <a name="nested_auth_config_oauth2_auth_code_flow"></a>The `oauth2_auth_code_flow` block supports:
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionAuthConfigUserPassword(dict):
    def __init__(__self__, *,
                 username: _builtins.str,
                 password: Optional['outputs.ConnectionAuthConfigUserPasswordPassword'] = None):
        """
        :param _builtins.str username: Username for Authentication.
        :param 'ConnectionAuthConfigUserPasswordPasswordArgs' password: Password for Authentication.
               Structure is documented below.
        """
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        Username for Authentication.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional['outputs.ConnectionAuthConfigUserPasswordPassword']:
        """
        Password for Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "password")


@pulumi.output_type
class ConnectionAuthConfigUserPasswordPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthConfigUserPasswordPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthConfigUserPasswordPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthConfigUserPasswordPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: projects/*/secrets/*/versions/*.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionConfigVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "encryptionKeyValue":
            suggest = "encryption_key_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "secretValue":
            suggest = "secret_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionConfigVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionConfigVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionConfigVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 boolean_value: Optional[_builtins.bool] = None,
                 encryption_key_value: Optional['outputs.ConnectionConfigVariableEncryptionKeyValue'] = None,
                 integer_value: Optional[_builtins.int] = None,
                 secret_value: Optional['outputs.ConnectionConfigVariableSecretValue'] = None,
                 string_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Key for the configVariable
        :param _builtins.bool boolean_value: Boolean Value of configVariable
        :param 'ConnectionConfigVariableEncryptionKeyValueArgs' encryption_key_value: Encryption key value of configVariable.
               Structure is documented below.
        :param _builtins.int integer_value: Integer Value of configVariable
        :param 'ConnectionConfigVariableSecretValueArgs' secret_value: Secret value of configVariable.
               Structure is documented below.
        :param _builtins.str string_value: String Value of configVariabley
        """
        pulumi.set(__self__, "key", key)
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if encryption_key_value is not None:
            pulumi.set(__self__, "encryption_key_value", encryption_key_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key for the configVariable
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[_builtins.bool]:
        """
        Boolean Value of configVariable
        """
        return pulumi.get(self, "boolean_value")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyValue")
    def encryption_key_value(self) -> Optional['outputs.ConnectionConfigVariableEncryptionKeyValue']:
        """
        Encryption key value of configVariable.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key_value")

    @_builtins.property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[_builtins.int]:
        """
        Integer Value of configVariable
        """
        return pulumi.get(self, "integer_value")

    @_builtins.property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional['outputs.ConnectionConfigVariableSecretValue']:
        """
        Secret value of configVariable.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_value")

    @_builtins.property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[_builtins.str]:
        """
        String Value of configVariabley
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class ConnectionConfigVariableEncryptionKeyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionConfigVariableEncryptionKeyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionConfigVariableEncryptionKeyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionConfigVariableEncryptionKeyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 kms_key_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Type of Encryption Key
               Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        :param _builtins.str kms_key_name: The [KMS key name] with which the content of the Operation is encrypted. The
               expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
               Will be empty string if google managed.
        """
        pulumi.set(__self__, "type", type)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of Encryption Key
        Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The [KMS key name] with which the content of the Operation is encrypted. The
        expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
        Will be empty string if google managed.
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class ConnectionConfigVariableSecretValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionConfigVariableSecretValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionConfigVariableSecretValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionConfigVariableSecretValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionConnectorVersionInfraConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ratelimitThreshold":
            suggest = "ratelimit_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionConnectorVersionInfraConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionConnectorVersionInfraConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionConnectorVersionInfraConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ratelimit_threshold: Optional[_builtins.str] = None):
        """
        :param _builtins.str ratelimit_threshold: (Output)
               Max QPS supported by the connector version before throttling of requests.
        """
        if ratelimit_threshold is not None:
            pulumi.set(__self__, "ratelimit_threshold", ratelimit_threshold)

    @_builtins.property
    @pulumi.getter(name="ratelimitThreshold")
    def ratelimit_threshold(self) -> Optional[_builtins.str]:
        """
        (Output)
        Max QPS supported by the connector version before throttling of requests.
        """
        return pulumi.get(self, "ratelimit_threshold")


@pulumi.output_type
class ConnectionDestinationConfig(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 destinations: Optional[Sequence['outputs.ConnectionDestinationConfigDestination']] = None):
        """
        :param _builtins.str key: The key is the destination identifier that is supported by the Connector.
        :param Sequence['ConnectionDestinationConfigDestinationArgs'] destinations: The destinations for the key.
               Structure is documented below.
        """
        pulumi.set(__self__, "key", key)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The key is the destination identifier that is supported by the Connector.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.ConnectionDestinationConfigDestination']]:
        """
        The destinations for the key.
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")


@pulumi.output_type
class ConnectionDestinationConfigDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionDestinationConfigDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionDestinationConfigDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionDestinationConfigDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 service_attachment: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: Host
        :param _builtins.int port: port number
        :param _builtins.str service_attachment: Service Attachment
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        port number
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[_builtins.str]:
        """
        Service Attachment
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class ConnectionEventingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registrationDestinationConfig":
            suggest = "registration_destination_config"
        elif key == "additionalVariables":
            suggest = "additional_variables"
        elif key == "authConfig":
            suggest = "auth_config"
        elif key == "enrichmentEnabled":
            suggest = "enrichment_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registration_destination_config: 'outputs.ConnectionEventingConfigRegistrationDestinationConfig',
                 additional_variables: Optional[Sequence['outputs.ConnectionEventingConfigAdditionalVariable']] = None,
                 auth_config: Optional['outputs.ConnectionEventingConfigAuthConfig'] = None,
                 enrichment_enabled: Optional[_builtins.bool] = None):
        """
        :param 'ConnectionEventingConfigRegistrationDestinationConfigArgs' registration_destination_config: registrationDestinationConfig
               Structure is documented below.
        :param Sequence['ConnectionEventingConfigAdditionalVariableArgs'] additional_variables: List containing additional auth configs.
               Structure is documented below.
        :param 'ConnectionEventingConfigAuthConfigArgs' auth_config: authConfig for Eventing Configuration.
               Structure is documented below.
        :param _builtins.bool enrichment_enabled: Enrichment Enabled.
        """
        pulumi.set(__self__, "registration_destination_config", registration_destination_config)
        if additional_variables is not None:
            pulumi.set(__self__, "additional_variables", additional_variables)
        if auth_config is not None:
            pulumi.set(__self__, "auth_config", auth_config)
        if enrichment_enabled is not None:
            pulumi.set(__self__, "enrichment_enabled", enrichment_enabled)

    @_builtins.property
    @pulumi.getter(name="registrationDestinationConfig")
    def registration_destination_config(self) -> 'outputs.ConnectionEventingConfigRegistrationDestinationConfig':
        """
        registrationDestinationConfig
        Structure is documented below.
        """
        return pulumi.get(self, "registration_destination_config")

    @_builtins.property
    @pulumi.getter(name="additionalVariables")
    def additional_variables(self) -> Optional[Sequence['outputs.ConnectionEventingConfigAdditionalVariable']]:
        """
        List containing additional auth configs.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_variables")

    @_builtins.property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> Optional['outputs.ConnectionEventingConfigAuthConfig']:
        """
        authConfig for Eventing Configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "auth_config")

    @_builtins.property
    @pulumi.getter(name="enrichmentEnabled")
    def enrichment_enabled(self) -> Optional[_builtins.bool]:
        """
        Enrichment Enabled.
        """
        return pulumi.get(self, "enrichment_enabled")


@pulumi.output_type
class ConnectionEventingConfigAdditionalVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "encryptionKeyValue":
            suggest = "encryption_key_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "secretValue":
            suggest = "secret_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAdditionalVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAdditionalVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAdditionalVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 boolean_value: Optional[_builtins.bool] = None,
                 encryption_key_value: Optional['outputs.ConnectionEventingConfigAdditionalVariableEncryptionKeyValue'] = None,
                 integer_value: Optional[_builtins.int] = None,
                 secret_value: Optional['outputs.ConnectionEventingConfigAdditionalVariableSecretValue'] = None,
                 string_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Key for the configVariable
        :param _builtins.bool boolean_value: Boolean Value of configVariable.
        :param 'ConnectionEventingConfigAdditionalVariableEncryptionKeyValueArgs' encryption_key_value: Encryption key value of configVariable.
               Structure is documented below.
        :param _builtins.int integer_value: Integer Value of configVariable.
        :param 'ConnectionEventingConfigAdditionalVariableSecretValueArgs' secret_value: Secret value of configVariable
               Structure is documented below.
        :param _builtins.str string_value: String Value of configVariabley.
        """
        pulumi.set(__self__, "key", key)
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if encryption_key_value is not None:
            pulumi.set(__self__, "encryption_key_value", encryption_key_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key for the configVariable
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[_builtins.bool]:
        """
        Boolean Value of configVariable.
        """
        return pulumi.get(self, "boolean_value")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyValue")
    def encryption_key_value(self) -> Optional['outputs.ConnectionEventingConfigAdditionalVariableEncryptionKeyValue']:
        """
        Encryption key value of configVariable.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key_value")

    @_builtins.property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[_builtins.int]:
        """
        Integer Value of configVariable.
        """
        return pulumi.get(self, "integer_value")

    @_builtins.property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional['outputs.ConnectionEventingConfigAdditionalVariableSecretValue']:
        """
        Secret value of configVariable
        Structure is documented below.
        """
        return pulumi.get(self, "secret_value")

    @_builtins.property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[_builtins.str]:
        """
        String Value of configVariabley.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class ConnectionEventingConfigAdditionalVariableEncryptionKeyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAdditionalVariableEncryptionKeyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The [KMS key name] with which the content of the Operation is encrypted. The
               expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
               Will be empty string if google managed.
        :param _builtins.str type: Type of Encryption Key
               Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The [KMS key name] with which the content of the Operation is encrypted. The
        expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
        Will be empty string if google managed.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of Encryption Key
        Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionEventingConfigAdditionalVariableSecretValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAdditionalVariableSecretValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionEventingConfigAuthConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authType":
            suggest = "auth_type"
        elif key == "userPassword":
            suggest = "user_password"
        elif key == "additionalVariables":
            suggest = "additional_variables"
        elif key == "authKey":
            suggest = "auth_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAuthConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAuthConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAuthConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_type: _builtins.str,
                 user_password: 'outputs.ConnectionEventingConfigAuthConfigUserPassword',
                 additional_variables: Optional[Sequence['outputs.ConnectionEventingConfigAuthConfigAdditionalVariable']] = None,
                 auth_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_type: authType of the Connection
               Possible values are: `USER_PASSWORD`.
        :param 'ConnectionEventingConfigAuthConfigUserPasswordArgs' user_password: User password for Authentication.
               Structure is documented below.
        :param Sequence['ConnectionEventingConfigAuthConfigAdditionalVariableArgs'] additional_variables: List containing additional auth configs.
               Structure is documented below.
        :param _builtins.str auth_key: The type of authentication configured.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "user_password", user_password)
        if additional_variables is not None:
            pulumi.set(__self__, "additional_variables", additional_variables)
        if auth_key is not None:
            pulumi.set(__self__, "auth_key", auth_key)

    @_builtins.property
    @pulumi.getter(name="authType")
    def auth_type(self) -> _builtins.str:
        """
        authType of the Connection
        Possible values are: `USER_PASSWORD`.
        """
        return pulumi.get(self, "auth_type")

    @_builtins.property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> 'outputs.ConnectionEventingConfigAuthConfigUserPassword':
        """
        User password for Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "user_password")

    @_builtins.property
    @pulumi.getter(name="additionalVariables")
    def additional_variables(self) -> Optional[Sequence['outputs.ConnectionEventingConfigAuthConfigAdditionalVariable']]:
        """
        List containing additional auth configs.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_variables")

    @_builtins.property
    @pulumi.getter(name="authKey")
    def auth_key(self) -> Optional[_builtins.str]:
        """
        The type of authentication configured.
        """
        return pulumi.get(self, "auth_key")


@pulumi.output_type
class ConnectionEventingConfigAuthConfigAdditionalVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "encryptionKeyValue":
            suggest = "encryption_key_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "secretValue":
            suggest = "secret_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAuthConfigAdditionalVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAuthConfigAdditionalVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAuthConfigAdditionalVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 boolean_value: Optional[_builtins.bool] = None,
                 encryption_key_value: Optional['outputs.ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue'] = None,
                 integer_value: Optional[_builtins.int] = None,
                 secret_value: Optional['outputs.ConnectionEventingConfigAuthConfigAdditionalVariableSecretValue'] = None,
                 string_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Key for the configVariable
        :param _builtins.bool boolean_value: Boolean Value of configVariable.
        :param 'ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValueArgs' encryption_key_value: Encryption key value of configVariable.
               Structure is documented below.
        :param _builtins.int integer_value: Integer Value of configVariable.
        :param 'ConnectionEventingConfigAuthConfigAdditionalVariableSecretValueArgs' secret_value: Secret value of configVariable
               Structure is documented below.
        :param _builtins.str string_value: String Value of configVariabley.
        """
        pulumi.set(__self__, "key", key)
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if encryption_key_value is not None:
            pulumi.set(__self__, "encryption_key_value", encryption_key_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key for the configVariable
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[_builtins.bool]:
        """
        Boolean Value of configVariable.
        """
        return pulumi.get(self, "boolean_value")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyValue")
    def encryption_key_value(self) -> Optional['outputs.ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue']:
        """
        Encryption key value of configVariable.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key_value")

    @_builtins.property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[_builtins.int]:
        """
        Integer Value of configVariable.
        """
        return pulumi.get(self, "integer_value")

    @_builtins.property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional['outputs.ConnectionEventingConfigAuthConfigAdditionalVariableSecretValue']:
        """
        Secret value of configVariable
        Structure is documented below.
        """
        return pulumi.get(self, "secret_value")

    @_builtins.property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[_builtins.str]:
        """
        String Value of configVariabley.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAuthConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The [KMS key name] with which the content of the Operation is encrypted. The
               expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
               Will be empty string if google managed.
        :param _builtins.str type: Type of Encryption Key
               Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The [KMS key name] with which the content of the Operation is encrypted. The
        expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
        Will be empty string if google managed.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of Encryption Key
        Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionEventingConfigAuthConfigAdditionalVariableSecretValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAuthConfigAdditionalVariableSecretValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAuthConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAuthConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionEventingConfigAuthConfigUserPassword(dict):
    def __init__(__self__, *,
                 password: Optional['outputs.ConnectionEventingConfigAuthConfigUserPasswordPassword'] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param 'ConnectionEventingConfigAuthConfigUserPasswordPasswordArgs' password: Password for Authentication.
               Structure is documented below.
        :param _builtins.str username: Username for Authentication.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional['outputs.ConnectionEventingConfigAuthConfigUserPasswordPassword']:
        """
        Password for Authentication.
        Structure is documented below.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Username for Authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionEventingConfigAuthConfigUserPasswordPassword(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigAuthConfigUserPasswordPassword. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigAuthConfigUserPasswordPassword.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigAuthConfigUserPasswordPassword.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: The resource name of the secret version in the format,
               format as: projects/*/secrets/*/versions/*.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        The resource name of the secret version in the format,
        format as: projects/*/secrets/*/versions/*.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionEventingConfigRegistrationDestinationConfig(dict):
    def __init__(__self__, *,
                 destinations: Optional[Sequence['outputs.ConnectionEventingConfigRegistrationDestinationConfigDestination']] = None,
                 key: Optional[_builtins.str] = None):
        """
        :param Sequence['ConnectionEventingConfigRegistrationDestinationConfigDestinationArgs'] destinations: destinations for the connection
               Structure is documented below.
        :param _builtins.str key: Key for the connection
        """
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[Sequence['outputs.ConnectionEventingConfigRegistrationDestinationConfigDestination']]:
        """
        destinations for the connection
        Structure is documented below.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        Key for the connection
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class ConnectionEventingConfigRegistrationDestinationConfigDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAttachment":
            suggest = "service_attachment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingConfigRegistrationDestinationConfigDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingConfigRegistrationDestinationConfigDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingConfigRegistrationDestinationConfigDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 service_attachment: Optional[_builtins.str] = None):
        """
        :param _builtins.str host: Host
        :param _builtins.int port: port number
        :param _builtins.str service_attachment: Service Attachment
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if service_attachment is not None:
            pulumi.set(__self__, "service_attachment", service_attachment)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        port number
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="serviceAttachment")
    def service_attachment(self) -> Optional[_builtins.str]:
        """
        Service Attachment
        """
        return pulumi.get(self, "service_attachment")


@pulumi.output_type
class ConnectionEventingRuntimeData(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventsListenerEndpoint":
            suggest = "events_listener_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionEventingRuntimeData. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionEventingRuntimeData.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionEventingRuntimeData.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 events_listener_endpoint: Optional[_builtins.str] = None,
                 statuses: Optional[Sequence['outputs.ConnectionEventingRuntimeDataStatus']] = None):
        """
        :param _builtins.str events_listener_endpoint: Events listener endpoint. The value will populated after provisioning the events listener.
        :param Sequence['ConnectionEventingRuntimeDataStatusArgs'] statuses: (Output)
               Current status of eventing.
               Structure is documented below.
        """
        if events_listener_endpoint is not None:
            pulumi.set(__self__, "events_listener_endpoint", events_listener_endpoint)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)

    @_builtins.property
    @pulumi.getter(name="eventsListenerEndpoint")
    def events_listener_endpoint(self) -> Optional[_builtins.str]:
        """
        Events listener endpoint. The value will populated after provisioning the events listener.
        """
        return pulumi.get(self, "events_listener_endpoint")

    @_builtins.property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.ConnectionEventingRuntimeDataStatus']]:
        """
        (Output)
        Current status of eventing.
        Structure is documented below.
        """
        return pulumi.get(self, "statuses")


@pulumi.output_type
class ConnectionEventingRuntimeDataStatus(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: An arbitrary description for the Connection.
        :param _builtins.str state: (Output)
               State of the Eventing
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        An arbitrary description for the Connection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the Eventing
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ConnectionLockConfig(dict):
    def __init__(__self__, *,
                 locked: _builtins.bool,
                 reason: Optional[_builtins.str] = None):
        """
        :param _builtins.bool locked: Indicates whether or not the connection is locked.
        :param _builtins.str reason: Describes why a connection is locked.
        """
        pulumi.set(__self__, "locked", locked)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def locked(self) -> _builtins.bool:
        """
        Indicates whether or not the connection is locked.
        """
        return pulumi.get(self, "locked")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        Describes why a connection is locked.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class ConnectionLogConfig(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 level: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enabled represents whether logging is enabled or not for a connection.
        :param _builtins.str level: Log configuration level.
               Possible values are: `LOG_LEVEL_UNSPECIFIED`, `ERROR`, `INFO`, `DEBUG`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enabled represents whether logging is enabled or not for a connection.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def level(self) -> Optional[_builtins.str]:
        """
        Log configuration level.
        Possible values are: `LOG_LEVEL_UNSPECIFIED`, `ERROR`, `INFO`, `DEBUG`.
        """
        return pulumi.get(self, "level")


@pulumi.output_type
class ConnectionNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: Optional[_builtins.int] = None,
                 min_node_count: Optional[_builtins.int] = None):
        """
        :param _builtins.int max_node_count: Minimum number of nodes in the runtime nodes.
        :param _builtins.int min_node_count: Minimum number of nodes in the runtime nodes.
        """
        if max_node_count is not None:
            pulumi.set(__self__, "max_node_count", max_node_count)
        if min_node_count is not None:
            pulumi.set(__self__, "min_node_count", min_node_count)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of nodes in the runtime nodes.
        """
        return pulumi.get(self, "max_node_count")

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> Optional[_builtins.int]:
        """
        Minimum number of nodes in the runtime nodes.
        """
        return pulumi.get(self, "min_node_count")


@pulumi.output_type
class ConnectionSslConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalVariables":
            suggest = "additional_variables"
        elif key == "clientCertType":
            suggest = "client_cert_type"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientPrivateKey":
            suggest = "client_private_key"
        elif key == "clientPrivateKeyPass":
            suggest = "client_private_key_pass"
        elif key == "privateServerCertificate":
            suggest = "private_server_certificate"
        elif key == "serverCertType":
            suggest = "server_cert_type"
        elif key == "trustModel":
            suggest = "trust_model"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 additional_variables: Optional[Sequence['outputs.ConnectionSslConfigAdditionalVariable']] = None,
                 client_cert_type: Optional[_builtins.str] = None,
                 client_certificate: Optional['outputs.ConnectionSslConfigClientCertificate'] = None,
                 client_private_key: Optional['outputs.ConnectionSslConfigClientPrivateKey'] = None,
                 client_private_key_pass: Optional['outputs.ConnectionSslConfigClientPrivateKeyPass'] = None,
                 private_server_certificate: Optional['outputs.ConnectionSslConfigPrivateServerCertificate'] = None,
                 server_cert_type: Optional[_builtins.str] = None,
                 trust_model: Optional[_builtins.str] = None,
                 use_ssl: Optional[_builtins.bool] = None):
        """
        :param _builtins.str type: Enum for controlling the SSL Type (TLS/MTLS)
               Possible values are: `TLS`, `MTLS`.
        :param Sequence['ConnectionSslConfigAdditionalVariableArgs'] additional_variables: Additional SSL related field values.
               Structure is documented below.
        :param _builtins.str client_cert_type: Type of Client Cert (PEM/JKS/.. etc.)
               Possible values are: `PEM`.
        :param 'ConnectionSslConfigClientCertificateArgs' client_certificate: Client Certificate
               Structure is documented below.
        :param 'ConnectionSslConfigClientPrivateKeyArgs' client_private_key: Client Private Key
               Structure is documented below.
        :param 'ConnectionSslConfigClientPrivateKeyPassArgs' client_private_key_pass: Secret containing the passphrase protecting the Client Private Key
               Structure is documented below.
        :param 'ConnectionSslConfigPrivateServerCertificateArgs' private_server_certificate: Private Server Certificate. Needs to be specified if trust model is PRIVATE.
               Structure is documented below.
        :param _builtins.str server_cert_type: Type of Server Cert (PEM/JKS/.. etc.)
               Possible values are: `PEM`.
        :param _builtins.str trust_model: Enum for Trust Model
               Possible values are: `PUBLIC`, `PRIVATE`, `INSECURE`.
        :param _builtins.bool use_ssl: Bool for enabling SSL
        """
        pulumi.set(__self__, "type", type)
        if additional_variables is not None:
            pulumi.set(__self__, "additional_variables", additional_variables)
        if client_cert_type is not None:
            pulumi.set(__self__, "client_cert_type", client_cert_type)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_private_key is not None:
            pulumi.set(__self__, "client_private_key", client_private_key)
        if client_private_key_pass is not None:
            pulumi.set(__self__, "client_private_key_pass", client_private_key_pass)
        if private_server_certificate is not None:
            pulumi.set(__self__, "private_server_certificate", private_server_certificate)
        if server_cert_type is not None:
            pulumi.set(__self__, "server_cert_type", server_cert_type)
        if trust_model is not None:
            pulumi.set(__self__, "trust_model", trust_model)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Enum for controlling the SSL Type (TLS/MTLS)
        Possible values are: `TLS`, `MTLS`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="additionalVariables")
    def additional_variables(self) -> Optional[Sequence['outputs.ConnectionSslConfigAdditionalVariable']]:
        """
        Additional SSL related field values.
        Structure is documented below.
        """
        return pulumi.get(self, "additional_variables")

    @_builtins.property
    @pulumi.getter(name="clientCertType")
    def client_cert_type(self) -> Optional[_builtins.str]:
        """
        Type of Client Cert (PEM/JKS/.. etc.)
        Possible values are: `PEM`.
        """
        return pulumi.get(self, "client_cert_type")

    @_builtins.property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional['outputs.ConnectionSslConfigClientCertificate']:
        """
        Client Certificate
        Structure is documented below.
        """
        return pulumi.get(self, "client_certificate")

    @_builtins.property
    @pulumi.getter(name="clientPrivateKey")
    def client_private_key(self) -> Optional['outputs.ConnectionSslConfigClientPrivateKey']:
        """
        Client Private Key
        Structure is documented below.
        """
        return pulumi.get(self, "client_private_key")

    @_builtins.property
    @pulumi.getter(name="clientPrivateKeyPass")
    def client_private_key_pass(self) -> Optional['outputs.ConnectionSslConfigClientPrivateKeyPass']:
        """
        Secret containing the passphrase protecting the Client Private Key
        Structure is documented below.
        """
        return pulumi.get(self, "client_private_key_pass")

    @_builtins.property
    @pulumi.getter(name="privateServerCertificate")
    def private_server_certificate(self) -> Optional['outputs.ConnectionSslConfigPrivateServerCertificate']:
        """
        Private Server Certificate. Needs to be specified if trust model is PRIVATE.
        Structure is documented below.
        """
        return pulumi.get(self, "private_server_certificate")

    @_builtins.property
    @pulumi.getter(name="serverCertType")
    def server_cert_type(self) -> Optional[_builtins.str]:
        """
        Type of Server Cert (PEM/JKS/.. etc.)
        Possible values are: `PEM`.
        """
        return pulumi.get(self, "server_cert_type")

    @_builtins.property
    @pulumi.getter(name="trustModel")
    def trust_model(self) -> Optional[_builtins.str]:
        """
        Enum for Trust Model
        Possible values are: `PUBLIC`, `PRIVATE`, `INSECURE`.
        """
        return pulumi.get(self, "trust_model")

    @_builtins.property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[_builtins.bool]:
        """
        Bool for enabling SSL
        """
        return pulumi.get(self, "use_ssl")


@pulumi.output_type
class ConnectionSslConfigAdditionalVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "booleanValue":
            suggest = "boolean_value"
        elif key == "encryptionKeyValue":
            suggest = "encryption_key_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "secretValue":
            suggest = "secret_value"
        elif key == "stringValue":
            suggest = "string_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfigAdditionalVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfigAdditionalVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfigAdditionalVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 boolean_value: Optional[_builtins.bool] = None,
                 encryption_key_value: Optional['outputs.ConnectionSslConfigAdditionalVariableEncryptionKeyValue'] = None,
                 integer_value: Optional[_builtins.int] = None,
                 secret_value: Optional['outputs.ConnectionSslConfigAdditionalVariableSecretValue'] = None,
                 string_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: Key for the configVariable
        :param _builtins.bool boolean_value: Boolean Value of configVariable.
        :param 'ConnectionSslConfigAdditionalVariableEncryptionKeyValueArgs' encryption_key_value: Encryption key value of configVariable.
               Structure is documented below.
        :param _builtins.int integer_value: Integer Value of configVariable.
        :param 'ConnectionSslConfigAdditionalVariableSecretValueArgs' secret_value: Secret value of configVariable
               Structure is documented below.
        :param _builtins.str string_value: String Value of configVariabley.
        """
        pulumi.set(__self__, "key", key)
        if boolean_value is not None:
            pulumi.set(__self__, "boolean_value", boolean_value)
        if encryption_key_value is not None:
            pulumi.set(__self__, "encryption_key_value", encryption_key_value)
        if integer_value is not None:
            pulumi.set(__self__, "integer_value", integer_value)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        Key for the configVariable
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> Optional[_builtins.bool]:
        """
        Boolean Value of configVariable.
        """
        return pulumi.get(self, "boolean_value")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyValue")
    def encryption_key_value(self) -> Optional['outputs.ConnectionSslConfigAdditionalVariableEncryptionKeyValue']:
        """
        Encryption key value of configVariable.
        Structure is documented below.
        """
        return pulumi.get(self, "encryption_key_value")

    @_builtins.property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> Optional[_builtins.int]:
        """
        Integer Value of configVariable.
        """
        return pulumi.get(self, "integer_value")

    @_builtins.property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional['outputs.ConnectionSslConfigAdditionalVariableSecretValue']:
        """
        Secret value of configVariable
        Structure is documented below.
        """
        return pulumi.get(self, "secret_value")

    @_builtins.property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[_builtins.str]:
        """
        String Value of configVariabley.
        """
        return pulumi.get(self, "string_value")


@pulumi.output_type
class ConnectionSslConfigAdditionalVariableEncryptionKeyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfigAdditionalVariableEncryptionKeyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfigAdditionalVariableEncryptionKeyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str kms_key_name: The [KMS key name] with which the content of the Operation is encrypted. The
               expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
               Will be empty string if google managed.
        :param _builtins.str type: Type of Encryption Key
               Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[_builtins.str]:
        """
        The [KMS key name] with which the content of the Operation is encrypted. The
        expected format: projects/*/locations/*/keyRings/*/cryptoKeys/*.
        Will be empty string if google managed.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Type of Encryption Key
        Possible values are: `GOOGLE_MANAGED`, `CUSTOMER_MANAGED`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ConnectionSslConfigAdditionalVariableSecretValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfigAdditionalVariableSecretValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfigAdditionalVariableSecretValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionSslConfigClientCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfigClientCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfigClientCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfigClientCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionSslConfigClientPrivateKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfigClientPrivateKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfigClientPrivateKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfigClientPrivateKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionSslConfigClientPrivateKeyPass(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfigClientPrivateKeyPass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfigClientPrivateKeyPass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfigClientPrivateKeyPass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionSslConfigPrivateServerCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretVersion":
            suggest = "secret_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionSslConfigPrivateServerCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionSslConfigPrivateServerCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionSslConfigPrivateServerCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_version: _builtins.str):
        """
        :param _builtins.str secret_version: Secret version of Secret Value for Config variable.
        """
        pulumi.set(__self__, "secret_version", secret_version)

    @_builtins.property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> _builtins.str:
        """
        Secret version of Secret Value for Config variable.
        """
        return pulumi.get(self, "secret_version")


@pulumi.output_type
class ConnectionStatus(dict):
    def __init__(__self__, *,
                 description: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None):
        """
        :param _builtins.str description: An arbitrary description for the Connection.
        :param _builtins.str state: (Output)
               State of the Eventing
        :param _builtins.str status: (Output)
               Current status of eventing.
               Structure is documented below.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        An arbitrary description for the Connection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        (Output)
        State of the Eventing
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        (Output)
        Current status of eventing.
        Structure is documented below.
        """
        return pulumi.get(self, "status")


