# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKMSSecretAsymmetricResult',
    'AwaitableGetKMSSecretAsymmetricResult',
    'get_kms_secret_asymmetric',
    'get_kms_secret_asymmetric_output',
]

@pulumi.output_type
class GetKMSSecretAsymmetricResult:
    """
    A collection of values returned by getKMSSecretAsymmetric.
    """
    def __init__(__self__, ciphertext=None, crc32=None, crypto_key_version=None, id=None, plaintext=None):
        if ciphertext and not isinstance(ciphertext, str):
            raise TypeError("Expected argument 'ciphertext' to be a str")
        pulumi.set(__self__, "ciphertext", ciphertext)
        if crc32 and not isinstance(crc32, str):
            raise TypeError("Expected argument 'crc32' to be a str")
        pulumi.set(__self__, "crc32", crc32)
        if crypto_key_version and not isinstance(crypto_key_version, str):
            raise TypeError("Expected argument 'crypto_key_version' to be a str")
        pulumi.set(__self__, "crypto_key_version", crypto_key_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plaintext and not isinstance(plaintext, str):
            raise TypeError("Expected argument 'plaintext' to be a str")
        pulumi.set(__self__, "plaintext", plaintext)

    @_builtins.property
    @pulumi.getter
    def ciphertext(self) -> _builtins.str:
        return pulumi.get(self, "ciphertext")

    @_builtins.property
    @pulumi.getter
    def crc32(self) -> Optional[_builtins.str]:
        """
        Contains the crc32 checksum of the provided ciphertext.
        """
        return pulumi.get(self, "crc32")

    @_builtins.property
    @pulumi.getter(name="cryptoKeyVersion")
    def crypto_key_version(self) -> _builtins.str:
        return pulumi.get(self, "crypto_key_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def plaintext(self) -> _builtins.str:
        """
        Contains the result of decrypting the provided ciphertext.
        """
        return pulumi.get(self, "plaintext")


class AwaitableGetKMSSecretAsymmetricResult(GetKMSSecretAsymmetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKMSSecretAsymmetricResult(
            ciphertext=self.ciphertext,
            crc32=self.crc32,
            crypto_key_version=self.crypto_key_version,
            id=self.id,
            plaintext=self.plaintext)


def get_kms_secret_asymmetric(ciphertext: Optional[_builtins.str] = None,
                              crc32: Optional[_builtins.str] = None,
                              crypto_key_version: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKMSSecretAsymmetricResult:
    """
    ## Example Usage

    First, create a KMS KeyRing and CryptoKey using the resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.KeyRing("my_key_ring",
        project="my-project",
        name="my-key-ring",
        location="us-central1")
    my_crypto_key_crypto_key = gcp.kms.CryptoKey("my_crypto_key",
        name="my-crypto-key",
        key_ring=my_key_ring.id,
        purpose="ASYMMETRIC_DECRYPT",
        version_template={
            "algorithm": "RSA_DECRYPT_OAEP_4096_SHA256",
        })
    my_crypto_key = gcp.kms.get_kms_crypto_key_version_output(crypto_key=my_crypto_key_crypto_key.id)
    ```

    Next, use the [Cloud SDK](https://cloud.google.com/kms/docs/encrypt-decrypt-rsa#kms-encrypt-asymmetric-cli) to encrypt
    some sensitive information:

    Finally, reference the encrypted ciphertext in your resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_random as random

    sql_user_password = gcp.kms.get_kms_secret_asymmetric(crypto_key_version=my_crypto_key["id"],
        crc32="12c59e54",
        ciphertext=\"\"\"    M7nUoba9EGVTu2LjNjBKGdGVBYjyS/i/AY+4yQMQF0Qf/RfUfX31Jw6+VO9OuThq
        ylu/7ihX9XD4bM7yYdXnMv9p1OHQUlorSBSbb/J6n1W9UJhcp6um8Tw8/Isx4f75
        4PskYS6f8Y2ItliGt1/A9iR5BTgGtJBwOxMlgoX2Ggq+Nh4E5SbdoaE5o6CO1nBx
        eIPsPEebQ6qC4JehQM3IGuV/lrm58+hZhaXAqNzX1cEYyAt5GYqJIVCiI585SUYs
        wRToGyTgaN+zthF0HP9IWlR4Am4LmJ/1OcePTnYw11CkU8wNRbDzVAzogwNH+rXr
        LTmf7hxVjBm6bBSVSNFcBKAXFlllubSfIeZ5hgzGqn54OmSf6odO12L5JxllddHc
        yAd54vWKs2kJtnsKV2V4ZdkI0w6y1TeI67baFZDNGo6qsCpFMPnvv7d46Pg2VOp1
        J6Ivner0NnNHE4MzNmpZRk8WXMwqq4P/gTiT7F/aCX6oFCUQ4AWPQhJYh2dkcOmL
        IP+47Veb10aFn61F1CJwpmOOiGNXKdDT1vK8CMnnwhm825K0q/q9Zqpzc1+1ae1z
        mSqol1zCoa88CuSN6nTLQlVnN/dzfrGbc0boJPaM0iGhHtSzHk4SWg84LhiJB1q9
        A9XFJmOVdkvRY9nnz/iVLAdd0Q3vFtLqCdUYsNN2yh4=
    \"\"\")
    db_name_suffix = random.RandomId("db_name_suffix", byte_length=4)
    main = gcp.sql.DatabaseInstance("main",
        name=db_name_suffix.hex.apply(lambda hex: f"main-instance-{hex}"),
        database_version="MYSQL_5_7",
        settings={
            "tier": "db-f1-micro",
        })
    users = gcp.sql.User("users",
        name="me",
        instance=main.name,
        host="me.com",
        password=sql_user_password_google_kms_secret["plaintext"])
    ```

    This will result in a Cloud SQL user being created with password `my-secret-password`.


    :param _builtins.str ciphertext: The ciphertext to be decrypted, encoded in base64
    :param _builtins.str crc32: The crc32 checksum of the `ciphertext` in hexadecimal notation. If not specified, it will be computed.
    :param _builtins.str crypto_key_version: The id of the CryptoKey version that will be used to
           decrypt the provided ciphertext. This is represented by the format
           `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}`.
    """
    __args__ = dict()
    __args__['ciphertext'] = ciphertext
    __args__['crc32'] = crc32
    __args__['cryptoKeyVersion'] = crypto_key_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:kms/getKMSSecretAsymmetric:getKMSSecretAsymmetric', __args__, opts=opts, typ=GetKMSSecretAsymmetricResult).value

    return AwaitableGetKMSSecretAsymmetricResult(
        ciphertext=pulumi.get(__ret__, 'ciphertext'),
        crc32=pulumi.get(__ret__, 'crc32'),
        crypto_key_version=pulumi.get(__ret__, 'crypto_key_version'),
        id=pulumi.get(__ret__, 'id'),
        plaintext=pulumi.get(__ret__, 'plaintext'))
def get_kms_secret_asymmetric_output(ciphertext: Optional[pulumi.Input[_builtins.str]] = None,
                                     crc32: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     crypto_key_version: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKMSSecretAsymmetricResult]:
    """
    ## Example Usage

    First, create a KMS KeyRing and CryptoKey using the resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_key_ring = gcp.kms.KeyRing("my_key_ring",
        project="my-project",
        name="my-key-ring",
        location="us-central1")
    my_crypto_key_crypto_key = gcp.kms.CryptoKey("my_crypto_key",
        name="my-crypto-key",
        key_ring=my_key_ring.id,
        purpose="ASYMMETRIC_DECRYPT",
        version_template={
            "algorithm": "RSA_DECRYPT_OAEP_4096_SHA256",
        })
    my_crypto_key = gcp.kms.get_kms_crypto_key_version_output(crypto_key=my_crypto_key_crypto_key.id)
    ```

    Next, use the [Cloud SDK](https://cloud.google.com/kms/docs/encrypt-decrypt-rsa#kms-encrypt-asymmetric-cli) to encrypt
    some sensitive information:

    Finally, reference the encrypted ciphertext in your resource definitions:

    ```python
    import pulumi
    import pulumi_gcp as gcp
    import pulumi_random as random

    sql_user_password = gcp.kms.get_kms_secret_asymmetric(crypto_key_version=my_crypto_key["id"],
        crc32="12c59e54",
        ciphertext=\"\"\"    M7nUoba9EGVTu2LjNjBKGdGVBYjyS/i/AY+4yQMQF0Qf/RfUfX31Jw6+VO9OuThq
        ylu/7ihX9XD4bM7yYdXnMv9p1OHQUlorSBSbb/J6n1W9UJhcp6um8Tw8/Isx4f75
        4PskYS6f8Y2ItliGt1/A9iR5BTgGtJBwOxMlgoX2Ggq+Nh4E5SbdoaE5o6CO1nBx
        eIPsPEebQ6qC4JehQM3IGuV/lrm58+hZhaXAqNzX1cEYyAt5GYqJIVCiI585SUYs
        wRToGyTgaN+zthF0HP9IWlR4Am4LmJ/1OcePTnYw11CkU8wNRbDzVAzogwNH+rXr
        LTmf7hxVjBm6bBSVSNFcBKAXFlllubSfIeZ5hgzGqn54OmSf6odO12L5JxllddHc
        yAd54vWKs2kJtnsKV2V4ZdkI0w6y1TeI67baFZDNGo6qsCpFMPnvv7d46Pg2VOp1
        J6Ivner0NnNHE4MzNmpZRk8WXMwqq4P/gTiT7F/aCX6oFCUQ4AWPQhJYh2dkcOmL
        IP+47Veb10aFn61F1CJwpmOOiGNXKdDT1vK8CMnnwhm825K0q/q9Zqpzc1+1ae1z
        mSqol1zCoa88CuSN6nTLQlVnN/dzfrGbc0boJPaM0iGhHtSzHk4SWg84LhiJB1q9
        A9XFJmOVdkvRY9nnz/iVLAdd0Q3vFtLqCdUYsNN2yh4=
    \"\"\")
    db_name_suffix = random.RandomId("db_name_suffix", byte_length=4)
    main = gcp.sql.DatabaseInstance("main",
        name=db_name_suffix.hex.apply(lambda hex: f"main-instance-{hex}"),
        database_version="MYSQL_5_7",
        settings={
            "tier": "db-f1-micro",
        })
    users = gcp.sql.User("users",
        name="me",
        instance=main.name,
        host="me.com",
        password=sql_user_password_google_kms_secret["plaintext"])
    ```

    This will result in a Cloud SQL user being created with password `my-secret-password`.


    :param _builtins.str ciphertext: The ciphertext to be decrypted, encoded in base64
    :param _builtins.str crc32: The crc32 checksum of the `ciphertext` in hexadecimal notation. If not specified, it will be computed.
    :param _builtins.str crypto_key_version: The id of the CryptoKey version that will be used to
           decrypt the provided ciphertext. This is represented by the format
           `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}/cryptoKeyVersions/{version}`.
    """
    __args__ = dict()
    __args__['ciphertext'] = ciphertext
    __args__['crc32'] = crc32
    __args__['cryptoKeyVersion'] = crypto_key_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:kms/getKMSSecretAsymmetric:getKMSSecretAsymmetric', __args__, opts=opts, typ=GetKMSSecretAsymmetricResult)
    return __ret__.apply(lambda __response__: GetKMSSecretAsymmetricResult(
        ciphertext=pulumi.get(__response__, 'ciphertext'),
        crc32=pulumi.get(__response__, 'crc32'),
        crypto_key_version=pulumi.get(__response__, 'crypto_key_version'),
        id=pulumi.get(__response__, 'id'),
        plaintext=pulumi.get(__response__, 'plaintext')))
