# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FolderSinkArgs', 'FolderSink']

@pulumi.input_type
class FolderSinkArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[_builtins.str],
                 folder: pulumi.Input[_builtins.str],
                 bigquery_options: Optional[pulumi.Input['FolderSinkBigqueryOptionsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 include_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 intercept_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FolderSink resource.
        :param pulumi.Input[_builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input[_builtins.str] folder: The folder to be exported to the sink. Note that either `[FOLDER_ID]` or `folders/[FOLDER_ID]` is
               accepted.
        :param pulumi.Input['FolderSinkBigqueryOptionsArgs'] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[_builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.bool] include_children: Whether or not to include children folders in the sink export. If true, logs
               associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
        :param pulumi.Input[_builtins.bool] intercept_children: Whether or not to intercept logs from child projects. If true, matching logs will not
               match with sinks in child resources, except _Required sinks. This sink will be visible to child resources when listing sinks.
        :param pulumi.Input[_builtins.str] name: The name of the logging sink.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "folder", folder)
        if bigquery_options is not None:
            pulumi.set(__self__, "bigquery_options", bigquery_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if include_children is not None:
            pulumi.set(__self__, "include_children", include_children)
        if intercept_children is not None:
            pulumi.set(__self__, "intercept_children", intercept_children)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input[_builtins.str]:
        """
        The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:

        - `storage.googleapis.com/[GCS_BUCKET]`
        - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
        - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]`

        The writer associated with the sink must have access to write to the above resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Input[_builtins.str]:
        """
        The folder to be exported to the sink. Note that either `[FOLDER_ID]` or `folders/[FOLDER_ID]` is
        accepted.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="bigqueryOptions")
    def bigquery_options(self) -> Optional[pulumi.Input['FolderSinkBigqueryOptionsArgs']]:
        """
        Options that affect sinks exporting data to BigQuery. Structure documented below.
        """
        return pulumi.get(self, "bigquery_options")

    @bigquery_options.setter
    def bigquery_options(self, value: Optional[pulumi.Input['FolderSinkBigqueryOptionsArgs']]):
        pulumi.set(self, "bigquery_options", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this sink. The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to True, then this sink is disabled and it does not export any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]]]:
        """
        Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filter to apply when exporting logs. Only log entries that match the filter are exported.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter(name="includeChildren")
    def include_children(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to include children folders in the sink export. If true, logs
        associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
        """
        return pulumi.get(self, "include_children")

    @include_children.setter
    def include_children(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_children", value)

    @_builtins.property
    @pulumi.getter(name="interceptChildren")
    def intercept_children(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to intercept logs from child projects. If true, matching logs will not
        match with sinks in child resources, except _Required sinks. This sink will be visible to child resources when listing sinks.
        """
        return pulumi.get(self, "intercept_children")

    @intercept_children.setter
    def intercept_children(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "intercept_children", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the logging sink.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FolderSinkState:
    def __init__(__self__, *,
                 bigquery_options: Optional[pulumi.Input['FolderSinkBigqueryOptionsArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 include_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 intercept_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 writer_identity: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FolderSink resources.
        :param pulumi.Input['FolderSinkBigqueryOptionsArgs'] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[_builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.str] folder: The folder to be exported to the sink. Note that either `[FOLDER_ID]` or `folders/[FOLDER_ID]` is
               accepted.
        :param pulumi.Input[_builtins.bool] include_children: Whether or not to include children folders in the sink export. If true, logs
               associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
        :param pulumi.Input[_builtins.bool] intercept_children: Whether or not to intercept logs from child projects. If true, matching logs will not
               match with sinks in child resources, except _Required sinks. This sink will be visible to child resources when listing sinks.
        :param pulumi.Input[_builtins.str] name: The name of the logging sink.
        :param pulumi.Input[_builtins.str] writer_identity: The identity associated with this sink. This identity must be granted write access to the
               configured `destination`.
        """
        if bigquery_options is not None:
            pulumi.set(__self__, "bigquery_options", bigquery_options)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if exclusions is not None:
            pulumi.set(__self__, "exclusions", exclusions)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if include_children is not None:
            pulumi.set(__self__, "include_children", include_children)
        if intercept_children is not None:
            pulumi.set(__self__, "intercept_children", intercept_children)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if writer_identity is not None:
            pulumi.set(__self__, "writer_identity", writer_identity)

    @_builtins.property
    @pulumi.getter(name="bigqueryOptions")
    def bigquery_options(self) -> Optional[pulumi.Input['FolderSinkBigqueryOptionsArgs']]:
        """
        Options that affect sinks exporting data to BigQuery. Structure documented below.
        """
        return pulumi.get(self, "bigquery_options")

    @bigquery_options.setter
    def bigquery_options(self, value: Optional[pulumi.Input['FolderSinkBigqueryOptionsArgs']]):
        pulumi.set(self, "bigquery_options", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this sink. The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:

        - `storage.googleapis.com/[GCS_BUCKET]`
        - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
        - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]`

        The writer associated with the sink must have access to write to the above resource.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to True, then this sink is disabled and it does not export any log entries.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]]]:
        """
        Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        """
        return pulumi.get(self, "exclusions")

    @exclusions.setter
    def exclusions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FolderSinkExclusionArgs']]]]):
        pulumi.set(self, "exclusions", value)

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The filter to apply when exporting logs. Only log entries that match the filter are exported.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filter", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder to be exported to the sink. Note that either `[FOLDER_ID]` or `folders/[FOLDER_ID]` is
        accepted.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="includeChildren")
    def include_children(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to include children folders in the sink export. If true, logs
        associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
        """
        return pulumi.get(self, "include_children")

    @include_children.setter
    def include_children(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "include_children", value)

    @_builtins.property
    @pulumi.getter(name="interceptChildren")
    def intercept_children(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to intercept logs from child projects. If true, matching logs will not
        match with sinks in child resources, except _Required sinks. This sink will be visible to child resources when listing sinks.
        """
        return pulumi.get(self, "intercept_children")

    @intercept_children.setter
    def intercept_children(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "intercept_children", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the logging sink.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="writerIdentity")
    def writer_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identity associated with this sink. This identity must be granted write access to the
        configured `destination`.
        """
        return pulumi.get(self, "writer_identity")

    @writer_identity.setter
    def writer_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "writer_identity", value)


@pulumi.type_token("gcp:logging/folderSink:FolderSink")
class FolderSink(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_options: Optional[pulumi.Input[Union['FolderSinkBigqueryOptionsArgs', 'FolderSinkBigqueryOptionsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FolderSinkExclusionArgs', 'FolderSinkExclusionArgsDict']]]]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 include_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 intercept_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a folder-level logging sink. For more information see:
        * [API documentation](https://cloud.google.com/logging/docs/reference/v2/rest/v2/folders.sinks)
        * How-to Guides
            * [Exporting Logs](https://cloud.google.com/logging/docs/export)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        log_bucket = gcp.storage.Bucket("log-bucket",
            name="folder-logging-bucket",
            location="US")
        my_folder = gcp.organizations.Folder("my-folder",
            display_name="My folder",
            parent="organizations/123456")
        my_sink = gcp.logging.FolderSink("my-sink",
            name="my-sink",
            description="some explanation on what this is",
            folder=my_folder.name,
            destination=log_bucket.name.apply(lambda name: f"storage.googleapis.com/{name}"),
            filter="resource.type = gce_instance AND severity >= WARNING")
        log_writer = gcp.projects.IAMBinding("log-writer",
            project="your-project-id",
            role="roles/storage.objectCreator",
            members=[my_sink.writer_identity])
        ```

        ## Import

        Folder-level logging sinks can be imported using this format:

        * `folders/{{folder_id}}/sinks/{{name}}`

        When using the `pulumi import` command, folder-level logging sinks can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/folderSink:FolderSink default folders/{{folder_id}}/sinks/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FolderSinkBigqueryOptionsArgs', 'FolderSinkBigqueryOptionsArgsDict']] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[_builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FolderSinkExclusionArgs', 'FolderSinkExclusionArgsDict']]]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.str] folder: The folder to be exported to the sink. Note that either `[FOLDER_ID]` or `folders/[FOLDER_ID]` is
               accepted.
        :param pulumi.Input[_builtins.bool] include_children: Whether or not to include children folders in the sink export. If true, logs
               associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
        :param pulumi.Input[_builtins.bool] intercept_children: Whether or not to intercept logs from child projects. If true, matching logs will not
               match with sinks in child resources, except _Required sinks. This sink will be visible to child resources when listing sinks.
        :param pulumi.Input[_builtins.str] name: The name of the logging sink.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FolderSinkArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a folder-level logging sink. For more information see:
        * [API documentation](https://cloud.google.com/logging/docs/reference/v2/rest/v2/folders.sinks)
        * How-to Guides
            * [Exporting Logs](https://cloud.google.com/logging/docs/export)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        log_bucket = gcp.storage.Bucket("log-bucket",
            name="folder-logging-bucket",
            location="US")
        my_folder = gcp.organizations.Folder("my-folder",
            display_name="My folder",
            parent="organizations/123456")
        my_sink = gcp.logging.FolderSink("my-sink",
            name="my-sink",
            description="some explanation on what this is",
            folder=my_folder.name,
            destination=log_bucket.name.apply(lambda name: f"storage.googleapis.com/{name}"),
            filter="resource.type = gce_instance AND severity >= WARNING")
        log_writer = gcp.projects.IAMBinding("log-writer",
            project="your-project-id",
            role="roles/storage.objectCreator",
            members=[my_sink.writer_identity])
        ```

        ## Import

        Folder-level logging sinks can be imported using this format:

        * `folders/{{folder_id}}/sinks/{{name}}`

        When using the `pulumi import` command, folder-level logging sinks can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:logging/folderSink:FolderSink default folders/{{folder_id}}/sinks/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FolderSinkArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderSinkArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_options: Optional[pulumi.Input[Union['FolderSinkBigqueryOptionsArgs', 'FolderSinkBigqueryOptionsArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input[_builtins.str]] = None,
                 disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FolderSinkExclusionArgs', 'FolderSinkExclusionArgsDict']]]]] = None,
                 filter: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 include_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 intercept_children: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderSinkArgs.__new__(FolderSinkArgs)

            __props__.__dict__["bigquery_options"] = bigquery_options
            __props__.__dict__["description"] = description
            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["exclusions"] = exclusions
            __props__.__dict__["filter"] = filter
            if folder is None and not opts.urn:
                raise TypeError("Missing required property 'folder'")
            __props__.__dict__["folder"] = folder
            __props__.__dict__["include_children"] = include_children
            __props__.__dict__["intercept_children"] = intercept_children
            __props__.__dict__["name"] = name
            __props__.__dict__["writer_identity"] = None
        super(FolderSink, __self__).__init__(
            'gcp:logging/folderSink:FolderSink',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bigquery_options: Optional[pulumi.Input[Union['FolderSinkBigqueryOptionsArgs', 'FolderSinkBigqueryOptionsArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[_builtins.str]] = None,
            disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FolderSinkExclusionArgs', 'FolderSinkExclusionArgsDict']]]]] = None,
            filter: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            include_children: Optional[pulumi.Input[_builtins.bool]] = None,
            intercept_children: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            writer_identity: Optional[pulumi.Input[_builtins.str]] = None) -> 'FolderSink':
        """
        Get an existing FolderSink resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FolderSinkBigqueryOptionsArgs', 'FolderSinkBigqueryOptionsArgsDict']] bigquery_options: Options that affect sinks exporting data to BigQuery. Structure documented below.
        :param pulumi.Input[_builtins.str] description: A description of this sink. The maximum length of the description is 8000 characters.
        :param pulumi.Input[_builtins.str] destination: The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:
               
               - `storage.googleapis.com/[GCS_BUCKET]`
               - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
               - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
               - `logging.googleapis.com/projects/[PROJECT_ID]`
               
               The writer associated with the sink must have access to write to the above resource.
        :param pulumi.Input[_builtins.bool] disabled: If set to True, then this sink is disabled and it does not export any log entries.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FolderSinkExclusionArgs', 'FolderSinkExclusionArgsDict']]]] exclusions: Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        :param pulumi.Input[_builtins.str] filter: The filter to apply when exporting logs. Only log entries that match the filter are exported.
               See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
               write a filter.
        :param pulumi.Input[_builtins.str] folder: The folder to be exported to the sink. Note that either `[FOLDER_ID]` or `folders/[FOLDER_ID]` is
               accepted.
        :param pulumi.Input[_builtins.bool] include_children: Whether or not to include children folders in the sink export. If true, logs
               associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
        :param pulumi.Input[_builtins.bool] intercept_children: Whether or not to intercept logs from child projects. If true, matching logs will not
               match with sinks in child resources, except _Required sinks. This sink will be visible to child resources when listing sinks.
        :param pulumi.Input[_builtins.str] name: The name of the logging sink.
        :param pulumi.Input[_builtins.str] writer_identity: The identity associated with this sink. This identity must be granted write access to the
               configured `destination`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FolderSinkState.__new__(_FolderSinkState)

        __props__.__dict__["bigquery_options"] = bigquery_options
        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["exclusions"] = exclusions
        __props__.__dict__["filter"] = filter
        __props__.__dict__["folder"] = folder
        __props__.__dict__["include_children"] = include_children
        __props__.__dict__["intercept_children"] = intercept_children
        __props__.__dict__["name"] = name
        __props__.__dict__["writer_identity"] = writer_identity
        return FolderSink(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bigqueryOptions")
    def bigquery_options(self) -> pulumi.Output['outputs.FolderSinkBigqueryOptions']:
        """
        Options that affect sinks exporting data to BigQuery. Structure documented below.
        """
        return pulumi.get(self, "bigquery_options")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of this sink. The maximum length of the description is 8000 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output[_builtins.str]:
        """
        The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, a BigQuery dataset, a Cloud Logging bucket, or a Google Cloud project. Examples:

        - `storage.googleapis.com/[GCS_BUCKET]`
        - `bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]`
        - `pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]/locations/global/buckets/[BUCKET_ID]`
        - `logging.googleapis.com/projects/[PROJECT_ID]`

        The writer associated with the sink must have access to write to the above resource.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to True, then this sink is disabled and it does not export any log entries.
        """
        return pulumi.get(self, "disabled")

    @_builtins.property
    @pulumi.getter
    def exclusions(self) -> pulumi.Output[Optional[Sequence['outputs.FolderSinkExclusion']]]:
        """
        Log entries that match any of the exclusion filters will not be exported. If a log entry is matched by both `filter` and one of `exclusions.filter`, it will not be exported.  Can be repeated multiple times for multiple exclusions. Structure is documented below.
        """
        return pulumi.get(self, "exclusions")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The filter to apply when exporting logs. Only log entries that match the filter are exported.
        See [Advanced Log Filters](https://cloud.google.com/logging/docs/view/advanced_filters) for information on how to
        write a filter.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[_builtins.str]:
        """
        The folder to be exported to the sink. Note that either `[FOLDER_ID]` or `folders/[FOLDER_ID]` is
        accepted.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="includeChildren")
    def include_children(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to include children folders in the sink export. If true, logs
        associated with child projects are also exported; otherwise only logs relating to the provided folder are included.
        """
        return pulumi.get(self, "include_children")

    @_builtins.property
    @pulumi.getter(name="interceptChildren")
    def intercept_children(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to intercept logs from child projects. If true, matching logs will not
        match with sinks in child resources, except _Required sinks. This sink will be visible to child resources when listing sinks.
        """
        return pulumi.get(self, "intercept_children")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the logging sink.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="writerIdentity")
    def writer_identity(self) -> pulumi.Output[_builtins.str]:
        """
        The identity associated with this sink. This identity must be granted write access to the
        configured `destination`.
        """
        return pulumi.get(self, "writer_identity")

