# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InternalRangeArgs', 'InternalRange']

@pulumi.input_type
class InternalRangeArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[_builtins.str],
                 peering: pulumi.Input[_builtins.str],
                 usage: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 migration: Optional[pulumi.Input['InternalRangeMigrationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overlaps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a InternalRange resource.
        :param pulumi.Input[_builtins.str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[_builtins.str] peering: The type of peering set for this internal range.
               Possible values are: `FOR_SELF`, `FOR_PEER`, `NOT_SHARED`.
        :param pulumi.Input[_builtins.str] usage: The type of usage set for this InternalRange.
               Possible values are: `FOR_VPC`, `EXTERNAL_TO_VPC`, `FOR_MIGRATION`.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_cidr_ranges: Optional. List of IP CIDR ranges to be excluded. Resulting reserved Internal Range will not overlap with any CIDR blocks mentioned in this list.
               Only IPv4 CIDR ranges are supported.
        :param pulumi.Input[_builtins.bool] immutable: Immutable ranges cannot have their fields modified, except for labels and description.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP range that this internal range defines.
               NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and peering=FOR_SELF
               NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must be specified explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['InternalRangeMigrationArgs'] migration: Specification for migration with source and target resource names.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the policy based route.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] overlaps: Optional. Types of resources that are allowed to overlap with the current internal range.
               Each value may be one of: `OVERLAP_ROUTE_RANGE`, `OVERLAP_EXISTING_SUBNET_RANGE`.
        :param pulumi.Input[_builtins.int] prefix_length: An alternate to ipCidrRange. Can be set when trying to create a reservation that automatically finds a free range of the given size.
               If both ipCidrRange and prefixLength are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
               NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and both fields must match. In other words, with IPv6 this field only works as
               a redundant parameter.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_cidr_ranges: Optional. Can be set to narrow down or pick a different address space while searching for a free range.
               If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "peering", peering)
        pulumi.set(__self__, "usage", usage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_cidr_ranges is not None:
            pulumi.set(__self__, "exclude_cidr_ranges", exclude_cidr_ranges)
        if immutable is not None:
            pulumi.set(__self__, "immutable", immutable)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if migration is not None:
            pulumi.set(__self__, "migration", migration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overlaps is not None:
            pulumi.set(__self__, "overlaps", overlaps)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if target_cidr_ranges is not None:
            pulumi.set(__self__, "target_cidr_ranges", target_cidr_ranges)

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Input[_builtins.str]:
        """
        Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def peering(self) -> pulumi.Input[_builtins.str]:
        """
        The type of peering set for this internal range.
        Possible values are: `FOR_SELF`, `FOR_PEER`, `NOT_SHARED`.
        """
        return pulumi.get(self, "peering")

    @peering.setter
    def peering(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peering", value)

    @_builtins.property
    @pulumi.getter
    def usage(self) -> pulumi.Input[_builtins.str]:
        """
        The type of usage set for this InternalRange.
        Possible values are: `FOR_VPC`, `EXTERNAL_TO_VPC`, `FOR_MIGRATION`.
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "usage", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="excludeCidrRanges")
    def exclude_cidr_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. List of IP CIDR ranges to be excluded. Resulting reserved Internal Range will not overlap with any CIDR blocks mentioned in this list.
        Only IPv4 CIDR ranges are supported.
        """
        return pulumi.get(self, "exclude_cidr_ranges")

    @exclude_cidr_ranges.setter
    def exclude_cidr_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_cidr_ranges", value)

    @_builtins.property
    @pulumi.getter
    def immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Immutable ranges cannot have their fields modified, except for labels and description.
        """
        return pulumi.get(self, "immutable")

    @immutable.setter
    def immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immutable", value)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP range that this internal range defines.
        NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and peering=FOR_SELF
        NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must be specified explicitly.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def migration(self) -> Optional[pulumi.Input['InternalRangeMigrationArgs']]:
        """
        Specification for migration with source and target resource names.
        Structure is documented below.
        """
        return pulumi.get(self, "migration")

    @migration.setter
    def migration(self, value: Optional[pulumi.Input['InternalRangeMigrationArgs']]):
        pulumi.set(self, "migration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy based route.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def overlaps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. Types of resources that are allowed to overlap with the current internal range.
        Each value may be one of: `OVERLAP_ROUTE_RANGE`, `OVERLAP_EXISTING_SUBNET_RANGE`.
        """
        return pulumi.get(self, "overlaps")

    @overlaps.setter
    def overlaps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "overlaps", value)

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An alternate to ipCidrRange. Can be set when trying to create a reservation that automatically finds a free range of the given size.
        If both ipCidrRange and prefixLength are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
        NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and both fields must match. In other words, with IPv6 this field only works as
        a redundant parameter.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="targetCidrRanges")
    def target_cidr_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. Can be set to narrow down or pick a different address space while searching for a free range.
        If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        """
        return pulumi.get(self, "target_cidr_ranges")

    @target_cidr_ranges.setter
    def target_cidr_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_cidr_ranges", value)


@pulumi.input_type
class _InternalRangeState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 exclude_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 migration: Optional[pulumi.Input['InternalRangeMigrationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 overlaps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peering: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering InternalRange resources.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_cidr_ranges: Optional. List of IP CIDR ranges to be excluded. Resulting reserved Internal Range will not overlap with any CIDR blocks mentioned in this list.
               Only IPv4 CIDR ranges are supported.
        :param pulumi.Input[_builtins.bool] immutable: Immutable ranges cannot have their fields modified, except for labels and description.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP range that this internal range defines.
               NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and peering=FOR_SELF
               NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must be specified explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input['InternalRangeMigrationArgs'] migration: Specification for migration with source and target resource names.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the policy based route.
        :param pulumi.Input[_builtins.str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] overlaps: Optional. Types of resources that are allowed to overlap with the current internal range.
               Each value may be one of: `OVERLAP_ROUTE_RANGE`, `OVERLAP_EXISTING_SUBNET_RANGE`.
        :param pulumi.Input[_builtins.str] peering: The type of peering set for this internal range.
               Possible values are: `FOR_SELF`, `FOR_PEER`, `NOT_SHARED`.
        :param pulumi.Input[_builtins.int] prefix_length: An alternate to ipCidrRange. Can be set when trying to create a reservation that automatically finds a free range of the given size.
               If both ipCidrRange and prefixLength are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
               NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and both fields must match. In other words, with IPv6 this field only works as
               a redundant parameter.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_cidr_ranges: Optional. Can be set to narrow down or pick a different address space while searching for a free range.
               If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        :param pulumi.Input[_builtins.str] usage: The type of usage set for this InternalRange.
               Possible values are: `FOR_VPC`, `EXTERNAL_TO_VPC`, `FOR_MIGRATION`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: Output only. The list of resources that refer to this internal range.
               Resources that use the internal range for their range allocation are referred to as users of the range.
               Other resources mark themselves as users while doing so by creating a reference to this internal range. Having a user, based on this reference, prevents deletion of the internal range referred to. Can be empty.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if exclude_cidr_ranges is not None:
            pulumi.set(__self__, "exclude_cidr_ranges", exclude_cidr_ranges)
        if immutable is not None:
            pulumi.set(__self__, "immutable", immutable)
        if ip_cidr_range is not None:
            pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if migration is not None:
            pulumi.set(__self__, "migration", migration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if overlaps is not None:
            pulumi.set(__self__, "overlaps", overlaps)
        if peering is not None:
            pulumi.set(__self__, "peering", peering)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if target_cidr_ranges is not None:
            pulumi.set(__self__, "target_cidr_ranges", target_cidr_ranges)
        if usage is not None:
            pulumi.set(__self__, "usage", usage)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="excludeCidrRanges")
    def exclude_cidr_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. List of IP CIDR ranges to be excluded. Resulting reserved Internal Range will not overlap with any CIDR blocks mentioned in this list.
        Only IPv4 CIDR ranges are supported.
        """
        return pulumi.get(self, "exclude_cidr_ranges")

    @exclude_cidr_ranges.setter
    def exclude_cidr_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "exclude_cidr_ranges", value)

    @_builtins.property
    @pulumi.getter
    def immutable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Immutable ranges cannot have their fields modified, except for labels and description.
        """
        return pulumi.get(self, "immutable")

    @immutable.setter
    def immutable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immutable", value)

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP range that this internal range defines.
        NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and peering=FOR_SELF
        NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must be specified explicitly.
        """
        return pulumi.get(self, "ip_cidr_range")

    @ip_cidr_range.setter
    def ip_cidr_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_cidr_range", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def migration(self) -> Optional[pulumi.Input['InternalRangeMigrationArgs']]:
        """
        Specification for migration with source and target resource names.
        Structure is documented below.
        """
        return pulumi.get(self, "migration")

    @migration.setter
    def migration(self, value: Optional[pulumi.Input['InternalRangeMigrationArgs']]):
        pulumi.set(self, "migration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy based route.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def overlaps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. Types of resources that are allowed to overlap with the current internal range.
        Each value may be one of: `OVERLAP_ROUTE_RANGE`, `OVERLAP_EXISTING_SUBNET_RANGE`.
        """
        return pulumi.get(self, "overlaps")

    @overlaps.setter
    def overlaps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "overlaps", value)

    @_builtins.property
    @pulumi.getter
    def peering(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of peering set for this internal range.
        Possible values are: `FOR_SELF`, `FOR_PEER`, `NOT_SHARED`.
        """
        return pulumi.get(self, "peering")

    @peering.setter
    def peering(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering", value)

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An alternate to ipCidrRange. Can be set when trying to create a reservation that automatically finds a free range of the given size.
        If both ipCidrRange and prefixLength are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
        NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and both fields must match. In other words, with IPv6 this field only works as
        a redundant parameter.
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "prefix_length", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="targetCidrRanges")
    def target_cidr_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Optional. Can be set to narrow down or pick a different address space while searching for a free range.
        If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        """
        return pulumi.get(self, "target_cidr_ranges")

    @target_cidr_ranges.setter
    def target_cidr_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "target_cidr_ranges", value)

    @_builtins.property
    @pulumi.getter
    def usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of usage set for this InternalRange.
        Possible values are: `FOR_VPC`, `EXTERNAL_TO_VPC`, `FOR_MIGRATION`.
        """
        return pulumi.get(self, "usage")

    @usage.setter
    def usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "usage", value)

    @_builtins.property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Output only. The list of resources that refer to this internal range.
        Resources that use the internal range for their range allocation are referred to as users of the range.
        Other resources mark themselves as users while doing so by creating a reference to this internal range. Having a user, based on this reference, prevents deletion of the internal range referred to. Can be empty.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "users", value)


@pulumi.type_token("gcp:networkconnectivity/internalRange:InternalRange")
class InternalRange(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 migration: Optional[pulumi.Input[Union['InternalRangeMigrationArgs', 'InternalRangeMigrationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 overlaps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peering: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The internal range resource for IPAM operations within a VPC network. Used to represent a private address range along with behavioral characterstics of that range (its usage and peering behavior). Networking resources can link to this range if they are created as belonging to it.

        To get more information about InternalRange, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.internalRanges)
        * How-to Guides
            * [Use internal ranges](https://cloud.google.com/vpc/docs/create-use-internal-ranges)

        ## Example Usage

        ### Network Connectivity Internal Ranges Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.InternalRange("default",
            name="basic",
            description="Test internal range",
            network=default_network.self_link,
            usage="FOR_VPC",
            peering="FOR_SELF",
            ip_cidr_range="10.0.0.0/24",
            labels={
                "label-a": "b",
            })
        ```
        ### Network Connectivity Internal Ranges Automatic Reservation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.InternalRange("default",
            name="automatic-reservation",
            network=default_network.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=24,
            target_cidr_ranges=["192.16.0.0/16"])
        ```
        ### Network Connectivity Internal Ranges External Ranges

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.InternalRange("default",
            name="external-ranges",
            network=default_network.id,
            usage="EXTERNAL_TO_VPC",
            peering="FOR_SELF",
            ip_cidr_range="172.16.0.0/24",
            labels={
                "external-reserved-range": "on-premises",
            })
        ```
        ### Network Connectivity Internal Ranges Reserve With Overlap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="overlapping-subnet",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.id)
        default = gcp.networkconnectivity.InternalRange("default",
            name="overlap-range",
            description="Test internal range",
            network=default_network.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            ip_cidr_range="10.0.0.0/30",
            overlaps=["OVERLAP_EXISTING_SUBNET_RANGE"],
            opts = pulumi.ResourceOptions(depends_on=[default_subnetwork]))
        ```
        ### Network Connectivity Internal Ranges Migration

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        source = gcp.compute.Subnetwork("source",
            name="source-subnet",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            network=default_network.name)
        target_project = gcp.organizations.get_project()
        default = gcp.networkconnectivity.InternalRange("default",
            name="migration",
            description="Test internal range",
            network=default_network.self_link,
            usage="FOR_MIGRATION",
            peering="FOR_SELF",
            ip_cidr_range="10.1.0.0/16",
            migration={
                "source": source.self_link,
                "target": f"projects/{target_project.project_id}/regions/us-central1/subnetworks/target-subnet",
            })
        ```

        ## Import

        InternalRange can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/internalRanges/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InternalRange can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/internalRange:InternalRange default projects/{{project}}/locations/global/internalRanges/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/internalRange:InternalRange default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/internalRange:InternalRange default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_cidr_ranges: Optional. List of IP CIDR ranges to be excluded. Resulting reserved Internal Range will not overlap with any CIDR blocks mentioned in this list.
               Only IPv4 CIDR ranges are supported.
        :param pulumi.Input[_builtins.bool] immutable: Immutable ranges cannot have their fields modified, except for labels and description.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP range that this internal range defines.
               NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and peering=FOR_SELF
               NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must be specified explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['InternalRangeMigrationArgs', 'InternalRangeMigrationArgsDict']] migration: Specification for migration with source and target resource names.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the policy based route.
        :param pulumi.Input[_builtins.str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] overlaps: Optional. Types of resources that are allowed to overlap with the current internal range.
               Each value may be one of: `OVERLAP_ROUTE_RANGE`, `OVERLAP_EXISTING_SUBNET_RANGE`.
        :param pulumi.Input[_builtins.str] peering: The type of peering set for this internal range.
               Possible values are: `FOR_SELF`, `FOR_PEER`, `NOT_SHARED`.
        :param pulumi.Input[_builtins.int] prefix_length: An alternate to ipCidrRange. Can be set when trying to create a reservation that automatically finds a free range of the given size.
               If both ipCidrRange and prefixLength are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
               NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and both fields must match. In other words, with IPv6 this field only works as
               a redundant parameter.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_cidr_ranges: Optional. Can be set to narrow down or pick a different address space while searching for a free range.
               If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        :param pulumi.Input[_builtins.str] usage: The type of usage set for this InternalRange.
               Possible values are: `FOR_VPC`, `EXTERNAL_TO_VPC`, `FOR_MIGRATION`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InternalRangeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The internal range resource for IPAM operations within a VPC network. Used to represent a private address range along with behavioral characterstics of that range (its usage and peering behavior). Networking resources can link to this range if they are created as belonging to it.

        To get more information about InternalRange, see:

        * [API documentation](https://cloud.google.com/network-connectivity/docs/reference/networkconnectivity/rest/v1/projects.locations.internalRanges)
        * How-to Guides
            * [Use internal ranges](https://cloud.google.com/vpc/docs/create-use-internal-ranges)

        ## Example Usage

        ### Network Connectivity Internal Ranges Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.InternalRange("default",
            name="basic",
            description="Test internal range",
            network=default_network.self_link,
            usage="FOR_VPC",
            peering="FOR_SELF",
            ip_cidr_range="10.0.0.0/24",
            labels={
                "label-a": "b",
            })
        ```
        ### Network Connectivity Internal Ranges Automatic Reservation

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.InternalRange("default",
            name="automatic-reservation",
            network=default_network.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            prefix_length=24,
            target_cidr_ranges=["192.16.0.0/16"])
        ```
        ### Network Connectivity Internal Ranges External Ranges

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default = gcp.networkconnectivity.InternalRange("default",
            name="external-ranges",
            network=default_network.id,
            usage="EXTERNAL_TO_VPC",
            peering="FOR_SELF",
            ip_cidr_range="172.16.0.0/24",
            labels={
                "external-reserved-range": "on-premises",
            })
        ```
        ### Network Connectivity Internal Ranges Reserve With Overlap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="overlapping-subnet",
            ip_cidr_range="10.0.0.0/24",
            region="us-central1",
            network=default_network.id)
        default = gcp.networkconnectivity.InternalRange("default",
            name="overlap-range",
            description="Test internal range",
            network=default_network.id,
            usage="FOR_VPC",
            peering="FOR_SELF",
            ip_cidr_range="10.0.0.0/30",
            overlaps=["OVERLAP_EXISTING_SUBNET_RANGE"],
            opts = pulumi.ResourceOptions(depends_on=[default_subnetwork]))
        ```
        ### Network Connectivity Internal Ranges Migration

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default",
            name="internal-ranges",
            auto_create_subnetworks=False)
        source = gcp.compute.Subnetwork("source",
            name="source-subnet",
            ip_cidr_range="10.1.0.0/16",
            region="us-central1",
            network=default_network.name)
        target_project = gcp.organizations.get_project()
        default = gcp.networkconnectivity.InternalRange("default",
            name="migration",
            description="Test internal range",
            network=default_network.self_link,
            usage="FOR_MIGRATION",
            peering="FOR_SELF",
            ip_cidr_range="10.1.0.0/16",
            migration={
                "source": source.self_link,
                "target": f"projects/{target_project.project_id}/regions/us-central1/subnetworks/target-subnet",
            })
        ```

        ## Import

        InternalRange can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/internalRanges/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InternalRange can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:networkconnectivity/internalRange:InternalRange default projects/{{project}}/locations/global/internalRanges/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/internalRange:InternalRange default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:networkconnectivity/internalRange:InternalRange default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InternalRangeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InternalRangeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 immutable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 migration: Optional[pulumi.Input[Union['InternalRangeMigrationArgs', 'InternalRangeMigrationArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[_builtins.str]] = None,
                 overlaps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 peering: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 target_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 usage: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InternalRangeArgs.__new__(InternalRangeArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_cidr_ranges"] = exclude_cidr_ranges
            __props__.__dict__["immutable"] = immutable
            __props__.__dict__["ip_cidr_range"] = ip_cidr_range
            __props__.__dict__["labels"] = labels
            __props__.__dict__["migration"] = migration
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["overlaps"] = overlaps
            if peering is None and not opts.urn:
                raise TypeError("Missing required property 'peering'")
            __props__.__dict__["peering"] = peering
            __props__.__dict__["prefix_length"] = prefix_length
            __props__.__dict__["project"] = project
            __props__.__dict__["target_cidr_ranges"] = target_cidr_ranges
            if usage is None and not opts.urn:
                raise TypeError("Missing required property 'usage'")
            __props__.__dict__["usage"] = usage
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["users"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(InternalRange, __self__).__init__(
            'gcp:networkconnectivity/internalRange:InternalRange',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            exclude_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            immutable: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_cidr_range: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            migration: Optional[pulumi.Input[Union['InternalRangeMigrationArgs', 'InternalRangeMigrationArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[_builtins.str]] = None,
            overlaps: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            peering: Optional[pulumi.Input[_builtins.str]] = None,
            prefix_length: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_cidr_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            usage: Optional[pulumi.Input[_builtins.str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'InternalRange':
        """
        Get an existing InternalRange resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] exclude_cidr_ranges: Optional. List of IP CIDR ranges to be excluded. Resulting reserved Internal Range will not overlap with any CIDR blocks mentioned in this list.
               Only IPv4 CIDR ranges are supported.
        :param pulumi.Input[_builtins.bool] immutable: Immutable ranges cannot have their fields modified, except for labels and description.
        :param pulumi.Input[_builtins.str] ip_cidr_range: The IP range that this internal range defines.
               NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and peering=FOR_SELF
               NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must be specified explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: User-defined labels.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Union['InternalRangeMigrationArgs', 'InternalRangeMigrationArgsDict']] migration: Specification for migration with source and target resource names.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the policy based route.
        :param pulumi.Input[_builtins.str] network: Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] overlaps: Optional. Types of resources that are allowed to overlap with the current internal range.
               Each value may be one of: `OVERLAP_ROUTE_RANGE`, `OVERLAP_EXISTING_SUBNET_RANGE`.
        :param pulumi.Input[_builtins.str] peering: The type of peering set for this internal range.
               Possible values are: `FOR_SELF`, `FOR_PEER`, `NOT_SHARED`.
        :param pulumi.Input[_builtins.int] prefix_length: An alternate to ipCidrRange. Can be set when trying to create a reservation that automatically finds a free range of the given size.
               If both ipCidrRange and prefixLength are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
               NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and both fields must match. In other words, with IPv6 this field only works as
               a redundant parameter.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] target_cidr_ranges: Optional. Can be set to narrow down or pick a different address space while searching for a free range.
               If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        :param pulumi.Input[_builtins.str] usage: The type of usage set for this InternalRange.
               Possible values are: `FOR_VPC`, `EXTERNAL_TO_VPC`, `FOR_MIGRATION`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] users: Output only. The list of resources that refer to this internal range.
               Resources that use the internal range for their range allocation are referred to as users of the range.
               Other resources mark themselves as users while doing so by creating a reference to this internal range. Having a user, based on this reference, prevents deletion of the internal range referred to. Can be empty.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InternalRangeState.__new__(_InternalRangeState)

        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["exclude_cidr_ranges"] = exclude_cidr_ranges
        __props__.__dict__["immutable"] = immutable
        __props__.__dict__["ip_cidr_range"] = ip_cidr_range
        __props__.__dict__["labels"] = labels
        __props__.__dict__["migration"] = migration
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["overlaps"] = overlaps
        __props__.__dict__["peering"] = peering
        __props__.__dict__["prefix_length"] = prefix_length
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["target_cidr_ranges"] = target_cidr_ranges
        __props__.__dict__["usage"] = usage
        __props__.__dict__["users"] = users
        return InternalRange(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="excludeCidrRanges")
    def exclude_cidr_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Optional. List of IP CIDR ranges to be excluded. Resulting reserved Internal Range will not overlap with any CIDR blocks mentioned in this list.
        Only IPv4 CIDR ranges are supported.
        """
        return pulumi.get(self, "exclude_cidr_ranges")

    @_builtins.property
    @pulumi.getter
    def immutable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Immutable ranges cannot have their fields modified, except for labels and description.
        """
        return pulumi.get(self, "immutable")

    @_builtins.property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> pulumi.Output[_builtins.str]:
        """
        The IP range that this internal range defines.
        NOTE: IPv6 ranges are limited to usage=EXTERNAL_TO_VPC and peering=FOR_SELF
        NOTE: For IPv6 Ranges this field is compulsory, i.e. the address range must be specified explicitly.
        """
        return pulumi.get(self, "ip_cidr_range")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        User-defined labels.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def migration(self) -> pulumi.Output[Optional['outputs.InternalRangeMigration']]:
        """
        Specification for migration with source and target resource names.
        Structure is documented below.
        """
        return pulumi.get(self, "migration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the policy based route.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[_builtins.str]:
        """
        Fully-qualified URL of the network that this route applies to, for example: projects/my-project/global/networks/my-network.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def overlaps(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Optional. Types of resources that are allowed to overlap with the current internal range.
        Each value may be one of: `OVERLAP_ROUTE_RANGE`, `OVERLAP_EXISTING_SUBNET_RANGE`.
        """
        return pulumi.get(self, "overlaps")

    @_builtins.property
    @pulumi.getter
    def peering(self) -> pulumi.Output[_builtins.str]:
        """
        The type of peering set for this internal range.
        Possible values are: `FOR_SELF`, `FOR_PEER`, `NOT_SHARED`.
        """
        return pulumi.get(self, "peering")

    @_builtins.property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        An alternate to ipCidrRange. Can be set when trying to create a reservation that automatically finds a free range of the given size.
        If both ipCidrRange and prefixLength are set, there is an error if the range sizes do not match. Can also be used during updates to change the range size.
        NOTE: For IPv6 this field only works if ip_cidr_range is set as well, and both fields must match. In other words, with IPv6 this field only works as
        a redundant parameter.
        """
        return pulumi.get(self, "prefix_length")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="targetCidrRanges")
    def target_cidr_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Optional. Can be set to narrow down or pick a different address space while searching for a free range.
        If not set, defaults to the "10.0.0.0/8" address space. This can be used to search in other rfc-1918 address spaces like "172.16.0.0/12" and "192.168.0.0/16" or non-rfc-1918 address spaces used in the VPC.
        """
        return pulumi.get(self, "target_cidr_ranges")

    @_builtins.property
    @pulumi.getter
    def usage(self) -> pulumi.Output[_builtins.str]:
        """
        The type of usage set for this InternalRange.
        Possible values are: `FOR_VPC`, `EXTERNAL_TO_VPC`, `FOR_MIGRATION`.
        """
        return pulumi.get(self, "usage")

    @_builtins.property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Output only. The list of resources that refer to this internal range.
        Resources that use the internal range for their range allocation are referred to as users of the range.
        Other resources mark themselves as users while doing so by creating a reference to this internal range. Having a user, based on this reference, prevents deletion of the internal range referred to. Can be empty.
        """
        return pulumi.get(self, "users")

