# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GroupAutoAccept',
    'HubRoutingVpc',
    'InternalRangeMigration',
    'PolicyBasedRouteFilter',
    'PolicyBasedRouteInterconnectAttachment',
    'PolicyBasedRouteVirtualMachine',
    'PolicyBasedRouteWarning',
    'ServiceConnectionPolicyPscConfig',
    'ServiceConnectionPolicyPscConnection',
    'ServiceConnectionPolicyPscConnectionError',
    'ServiceConnectionPolicyPscConnectionErrorInfo',
    'SpokeLinkedInterconnectAttachments',
    'SpokeLinkedProducerVpcNetwork',
    'SpokeLinkedRouterApplianceInstances',
    'SpokeLinkedRouterApplianceInstancesInstance',
    'SpokeLinkedVpcNetwork',
    'SpokeLinkedVpnTunnels',
    'SpokeReason',
]

@pulumi.output_type
class GroupAutoAccept(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoAcceptProjects":
            suggest = "auto_accept_projects"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GroupAutoAccept. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GroupAutoAccept.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GroupAutoAccept.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_accept_projects: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] auto_accept_projects: A list of project ids or project numbers for which you want to enable auto-accept. The auto-accept setting is applied to spokes being created or updated in these projects.
        """
        pulumi.set(__self__, "auto_accept_projects", auto_accept_projects)

    @_builtins.property
    @pulumi.getter(name="autoAcceptProjects")
    def auto_accept_projects(self) -> Sequence[_builtins.str]:
        """
        A list of project ids or project numbers for which you want to enable auto-accept. The auto-accept setting is applied to spokes being created or updated in these projects.
        """
        return pulumi.get(self, "auto_accept_projects")


@pulumi.output_type
class HubRoutingVpc(dict):
    def __init__(__self__, *,
                 uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The URI of the VPC network.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[_builtins.str]:
        """
        The URI of the VPC network.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class InternalRangeMigration(dict):
    def __init__(__self__, *,
                 source: _builtins.str,
                 target: _builtins.str):
        """
        :param _builtins.str source: Resource path as an URI of the source resource, for example a subnet.
               The project for the source resource should match the project for the
               InternalRange.
               An example /projects/{project}/regions/{region}/subnetworks/{subnet}
        :param _builtins.str target: Resource path of the target resource. The target project can be
               different, as in the cases when migrating to peer networks. The resource
               may not exist yet.
               For example /projects/{project}/regions/{region}/subnetworks/{subnet}
        """
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def source(self) -> _builtins.str:
        """
        Resource path as an URI of the source resource, for example a subnet.
        The project for the source resource should match the project for the
        InternalRange.
        An example /projects/{project}/regions/{region}/subnetworks/{subnet}
        """
        return pulumi.get(self, "source")

    @_builtins.property
    @pulumi.getter
    def target(self) -> _builtins.str:
        """
        Resource path of the target resource. The target project can be
        different, as in the cases when migrating to peer networks. The resource
        may not exist yet.
        For example /projects/{project}/regions/{region}/subnetworks/{subnet}
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class PolicyBasedRouteFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "destRange":
            suggest = "dest_range"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "srcRange":
            suggest = "src_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyBasedRouteFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyBasedRouteFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyBasedRouteFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol_version: _builtins.str,
                 dest_range: Optional[_builtins.str] = None,
                 ip_protocol: Optional[_builtins.str] = None,
                 src_range: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol_version: Internet protocol versions this policy-based route applies to.
               Possible values are: `IPV4`, `IPV6`.
        :param _builtins.str dest_range: The destination IP range of outgoing packets that this policy-based route applies to. Default is "0.0.0.0/0".
        :param _builtins.str ip_protocol: The IP protocol that this policy-based route applies to. Valid values are 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
        :param _builtins.str src_range: The source IP range of outgoing packets that this policy-based route applies to. Default is "0.0.0.0/0".
        """
        pulumi.set(__self__, "protocol_version", protocol_version)
        if dest_range is not None:
            pulumi.set(__self__, "dest_range", dest_range)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if src_range is not None:
            pulumi.set(__self__, "src_range", src_range)

    @_builtins.property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> _builtins.str:
        """
        Internet protocol versions this policy-based route applies to.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "protocol_version")

    @_builtins.property
    @pulumi.getter(name="destRange")
    def dest_range(self) -> Optional[_builtins.str]:
        """
        The destination IP range of outgoing packets that this policy-based route applies to. Default is "0.0.0.0/0".
        """
        return pulumi.get(self, "dest_range")

    @_builtins.property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[_builtins.str]:
        """
        The IP protocol that this policy-based route applies to. Valid values are 'TCP', 'UDP', and 'ALL'. Default is 'ALL'.
        """
        return pulumi.get(self, "ip_protocol")

    @_builtins.property
    @pulumi.getter(name="srcRange")
    def src_range(self) -> Optional[_builtins.str]:
        """
        The source IP range of outgoing packets that this policy-based route applies to. Default is "0.0.0.0/0".
        """
        return pulumi.get(self, "src_range")


@pulumi.output_type
class PolicyBasedRouteInterconnectAttachment(dict):
    def __init__(__self__, *,
                 region: _builtins.str):
        """
        :param _builtins.str region: Cloud region to install this policy-based route on for Interconnect attachments. Use `all` to install it on all Interconnect attachments.
        """
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        Cloud region to install this policy-based route on for Interconnect attachments. Use `all` to install it on all Interconnect attachments.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class PolicyBasedRouteVirtualMachine(dict):
    def __init__(__self__, *,
                 tags: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] tags: A list of VM instance tags that this policy-based route applies to. VM instances that have ANY of tags specified here will install this PBR.
        """
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        A list of VM instance tags that this policy-based route applies to. VM instances that have ANY of tags specified here will install this PBR.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class PolicyBasedRouteWarning(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "warningMessage":
            suggest = "warning_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyBasedRouteWarning. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyBasedRouteWarning.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyBasedRouteWarning.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[_builtins.str] = None,
                 data: Optional[Mapping[str, _builtins.str]] = None,
                 warning_message: Optional[_builtins.str] = None):
        """
        :param _builtins.str code: (Output)
               A warning code, if applicable.
        :param Mapping[str, _builtins.str] data: (Output)
               Metadata about this warning in key: value format. The key should provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement.
        :param _builtins.str warning_message: (Output)
               A human-readable description of the warning code.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if warning_message is not None:
            pulumi.set(__self__, "warning_message", warning_message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.str]:
        """
        (Output)
        A warning code, if applicable.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        (Output)
        Metadata about this warning in key: value format. The key should provides more detail on the warning being returned. For example, for warnings where there are no results in a list request for a particular zone, this key might be scope and the key value might be the zone name. Other examples might be a key indicating a deprecated resource and a suggested replacement.
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="warningMessage")
    def warning_message(self) -> Optional[_builtins.str]:
        """
        (Output)
        A human-readable description of the warning code.
        """
        return pulumi.get(self, "warning_message")


@pulumi.output_type
class ServiceConnectionPolicyPscConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedGoogleProducersResourceHierarchyLevels":
            suggest = "allowed_google_producers_resource_hierarchy_levels"
        elif key == "producerInstanceLocation":
            suggest = "producer_instance_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnectionPolicyPscConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnectionPolicyPscConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnectionPolicyPscConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnetworks: Sequence[_builtins.str],
                 allowed_google_producers_resource_hierarchy_levels: Optional[Sequence[_builtins.str]] = None,
                 limit: Optional[_builtins.str] = None,
                 producer_instance_location: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] subnetworks: IDs of the subnetworks or fully qualified identifiers for the subnetworks
        :param Sequence[_builtins.str] allowed_google_producers_resource_hierarchy_levels: List of Projects, Folders, or Organizations from where the Producer instance can be within. For example,
               a network administrator can provide both 'organizations/foo' and 'projects/bar' as
               allowed_google_producers_resource_hierarchy_levels. This allowlists this network to connect with any Producer
               instance within the 'foo' organization or the 'bar' project. By default,
               allowedGoogleProducersResourceHierarchyLevel is empty. The format for each
               allowedGoogleProducersResourceHierarchyLevel is / where is one of 'projects', 'folders', or 'organizations'
               and is either the ID or the number of the resource type. Format for each
               allowedGoogleProducersResourceHierarchyLevel value: 'projects/' or 'folders/' or 'organizations/' Eg.
               [projects/my-project-id, projects/567, folders/891, organizations/123]
        :param _builtins.str limit: Max number of PSC connections for this policy.
        :param _builtins.str producer_instance_location: ProducerInstanceLocation is used to specify which authorization mechanism to use to determine which projects
               the Producer instance can be within.
               Possible values are: `PRODUCER_INSTANCE_LOCATION_UNSPECIFIED`, `CUSTOM_RESOURCE_HIERARCHY_LEVELS`.
        """
        pulumi.set(__self__, "subnetworks", subnetworks)
        if allowed_google_producers_resource_hierarchy_levels is not None:
            pulumi.set(__self__, "allowed_google_producers_resource_hierarchy_levels", allowed_google_producers_resource_hierarchy_levels)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)
        if producer_instance_location is not None:
            pulumi.set(__self__, "producer_instance_location", producer_instance_location)

    @_builtins.property
    @pulumi.getter
    def subnetworks(self) -> Sequence[_builtins.str]:
        """
        IDs of the subnetworks or fully qualified identifiers for the subnetworks
        """
        return pulumi.get(self, "subnetworks")

    @_builtins.property
    @pulumi.getter(name="allowedGoogleProducersResourceHierarchyLevels")
    def allowed_google_producers_resource_hierarchy_levels(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of Projects, Folders, or Organizations from where the Producer instance can be within. For example,
        a network administrator can provide both 'organizations/foo' and 'projects/bar' as
        allowed_google_producers_resource_hierarchy_levels. This allowlists this network to connect with any Producer
        instance within the 'foo' organization or the 'bar' project. By default,
        allowedGoogleProducersResourceHierarchyLevel is empty. The format for each
        allowedGoogleProducersResourceHierarchyLevel is / where is one of 'projects', 'folders', or 'organizations'
        and is either the ID or the number of the resource type. Format for each
        allowedGoogleProducersResourceHierarchyLevel value: 'projects/' or 'folders/' or 'organizations/' Eg.
        [projects/my-project-id, projects/567, folders/891, organizations/123]
        """
        return pulumi.get(self, "allowed_google_producers_resource_hierarchy_levels")

    @_builtins.property
    @pulumi.getter
    def limit(self) -> Optional[_builtins.str]:
        """
        Max number of PSC connections for this policy.
        """
        return pulumi.get(self, "limit")

    @_builtins.property
    @pulumi.getter(name="producerInstanceLocation")
    def producer_instance_location(self) -> Optional[_builtins.str]:
        """
        ProducerInstanceLocation is used to specify which authorization mechanism to use to determine which projects
        the Producer instance can be within.
        Possible values are: `PRODUCER_INSTANCE_LOCATION_UNSPECIFIED`, `CUSTOM_RESOURCE_HIERARCHY_LEVELS`.
        """
        return pulumi.get(self, "producer_instance_location")


@pulumi.output_type
class ServiceConnectionPolicyPscConnection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumerAddress":
            suggest = "consumer_address"
        elif key == "consumerForwardingRule":
            suggest = "consumer_forwarding_rule"
        elif key == "consumerTargetProject":
            suggest = "consumer_target_project"
        elif key == "errorInfo":
            suggest = "error_info"
        elif key == "errorType":
            suggest = "error_type"
        elif key == "gceOperation":
            suggest = "gce_operation"
        elif key == "pscConnectionId":
            suggest = "psc_connection_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceConnectionPolicyPscConnection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceConnectionPolicyPscConnection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceConnectionPolicyPscConnection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consumer_address: Optional[_builtins.str] = None,
                 consumer_forwarding_rule: Optional[_builtins.str] = None,
                 consumer_target_project: Optional[_builtins.str] = None,
                 error: Optional['outputs.ServiceConnectionPolicyPscConnectionError'] = None,
                 error_info: Optional['outputs.ServiceConnectionPolicyPscConnectionErrorInfo'] = None,
                 error_type: Optional[_builtins.str] = None,
                 gce_operation: Optional[_builtins.str] = None,
                 psc_connection_id: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str consumer_address: The resource reference of the consumer address.
        :param _builtins.str consumer_forwarding_rule: The resource reference of the PSC Forwarding Rule within the consumer VPC.
        :param _builtins.str consumer_target_project: The project where the PSC connection is created.
        :param 'ServiceConnectionPolicyPscConnectionErrorArgs' error: The most recent error during operating this connection.
               Structure is documented below.
        :param 'ServiceConnectionPolicyPscConnectionErrorInfoArgs' error_info: The error info for the latest error during operating this connection.
               Structure is documented below.
        :param _builtins.str error_type: The error type indicates whether the error is consumer facing, producer
               facing or system internal.
               Possible values are: `CONNECTION_ERROR_TYPE_UNSPECIFIED`, `ERROR_INTERNAL`, `ERROR_CONSUMER_SIDE`, `ERROR_PRODUCER_SIDE`.
        :param _builtins.str gce_operation: The last Compute Engine operation to setup PSC connection.
        :param _builtins.str psc_connection_id: The PSC connection id of the PSC forwarding rule.
        :param _builtins.str state: The state of the PSC connection.
               Possible values are: `STATE_UNSPECIFIED`, `ACTIVE`, `CREATING`, `DELETING`, `FAILED`.
        """
        if consumer_address is not None:
            pulumi.set(__self__, "consumer_address", consumer_address)
        if consumer_forwarding_rule is not None:
            pulumi.set(__self__, "consumer_forwarding_rule", consumer_forwarding_rule)
        if consumer_target_project is not None:
            pulumi.set(__self__, "consumer_target_project", consumer_target_project)
        if error is not None:
            pulumi.set(__self__, "error", error)
        if error_info is not None:
            pulumi.set(__self__, "error_info", error_info)
        if error_type is not None:
            pulumi.set(__self__, "error_type", error_type)
        if gce_operation is not None:
            pulumi.set(__self__, "gce_operation", gce_operation)
        if psc_connection_id is not None:
            pulumi.set(__self__, "psc_connection_id", psc_connection_id)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="consumerAddress")
    def consumer_address(self) -> Optional[_builtins.str]:
        """
        The resource reference of the consumer address.
        """
        return pulumi.get(self, "consumer_address")

    @_builtins.property
    @pulumi.getter(name="consumerForwardingRule")
    def consumer_forwarding_rule(self) -> Optional[_builtins.str]:
        """
        The resource reference of the PSC Forwarding Rule within the consumer VPC.
        """
        return pulumi.get(self, "consumer_forwarding_rule")

    @_builtins.property
    @pulumi.getter(name="consumerTargetProject")
    def consumer_target_project(self) -> Optional[_builtins.str]:
        """
        The project where the PSC connection is created.
        """
        return pulumi.get(self, "consumer_target_project")

    @_builtins.property
    @pulumi.getter
    def error(self) -> Optional['outputs.ServiceConnectionPolicyPscConnectionError']:
        """
        The most recent error during operating this connection.
        Structure is documented below.
        """
        return pulumi.get(self, "error")

    @_builtins.property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> Optional['outputs.ServiceConnectionPolicyPscConnectionErrorInfo']:
        """
        The error info for the latest error during operating this connection.
        Structure is documented below.
        """
        return pulumi.get(self, "error_info")

    @_builtins.property
    @pulumi.getter(name="errorType")
    def error_type(self) -> Optional[_builtins.str]:
        """
        The error type indicates whether the error is consumer facing, producer
        facing or system internal.
        Possible values are: `CONNECTION_ERROR_TYPE_UNSPECIFIED`, `ERROR_INTERNAL`, `ERROR_CONSUMER_SIDE`, `ERROR_PRODUCER_SIDE`.
        """
        return pulumi.get(self, "error_type")

    @_builtins.property
    @pulumi.getter(name="gceOperation")
    def gce_operation(self) -> Optional[_builtins.str]:
        """
        The last Compute Engine operation to setup PSC connection.
        """
        return pulumi.get(self, "gce_operation")

    @_builtins.property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> Optional[_builtins.str]:
        """
        The PSC connection id of the PSC forwarding rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The state of the PSC connection.
        Possible values are: `STATE_UNSPECIFIED`, `ACTIVE`, `CREATING`, `DELETING`, `FAILED`.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ServiceConnectionPolicyPscConnectionError(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[Sequence[Mapping[str, _builtins.str]]] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: The status code, which should be an enum value of [google.rpc.Code][].
        :param Sequence[Mapping[str, _builtins.str]] details: (Output)
               A list of messages that carry the error details.
        :param _builtins.str message: A developer-facing error message.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        The status code, which should be an enum value of [google.rpc.Code][].
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, _builtins.str]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        A developer-facing error message.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class ServiceConnectionPolicyPscConnectionErrorInfo(dict):
    def __init__(__self__, *,
                 domain: Optional[_builtins.str] = None,
                 metadata: Optional[Mapping[str, _builtins.str]] = None,
                 reason: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain: The logical grouping to which the "reason" belongs.
        :param Mapping[str, _builtins.str] metadata: Additional structured details about this error.
        :param _builtins.str reason: The reason of the error.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        The logical grouping to which the "reason" belongs.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Additional structured details about this error.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def reason(self) -> Optional[_builtins.str]:
        """
        The reason of the error.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class SpokeLinkedInterconnectAttachments(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "siteToSiteDataTransfer":
            suggest = "site_to_site_data_transfer"
        elif key == "includeImportRanges":
            suggest = "include_import_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpokeLinkedInterconnectAttachments. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpokeLinkedInterconnectAttachments.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpokeLinkedInterconnectAttachments.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 site_to_site_data_transfer: _builtins.bool,
                 uris: Sequence[_builtins.str],
                 include_import_ranges: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool site_to_site_data_transfer: A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
        :param Sequence[_builtins.str] uris: The URIs of linked interconnect attachment resources
        :param Sequence[_builtins.str] include_import_ranges: IP ranges allowed to be included during import from hub (does not control transit connectivity).
               The only allowed value for now is "ALL_IPV4_RANGES".
        """
        pulumi.set(__self__, "site_to_site_data_transfer", site_to_site_data_transfer)
        pulumi.set(__self__, "uris", uris)
        if include_import_ranges is not None:
            pulumi.set(__self__, "include_import_ranges", include_import_ranges)

    @_builtins.property
    @pulumi.getter(name="siteToSiteDataTransfer")
    def site_to_site_data_transfer(self) -> _builtins.bool:
        """
        A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
        """
        return pulumi.get(self, "site_to_site_data_transfer")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Sequence[_builtins.str]:
        """
        The URIs of linked interconnect attachment resources
        """
        return pulumi.get(self, "uris")

    @_builtins.property
    @pulumi.getter(name="includeImportRanges")
    def include_import_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP ranges allowed to be included during import from hub (does not control transit connectivity).
        The only allowed value for now is "ALL_IPV4_RANGES".
        """
        return pulumi.get(self, "include_import_ranges")


@pulumi.output_type
class SpokeLinkedProducerVpcNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeExportRanges":
            suggest = "exclude_export_ranges"
        elif key == "includeExportRanges":
            suggest = "include_export_ranges"
        elif key == "producerNetwork":
            suggest = "producer_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpokeLinkedProducerVpcNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpokeLinkedProducerVpcNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpokeLinkedProducerVpcNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network: _builtins.str,
                 peering: _builtins.str,
                 exclude_export_ranges: Optional[Sequence[_builtins.str]] = None,
                 include_export_ranges: Optional[Sequence[_builtins.str]] = None,
                 producer_network: Optional[_builtins.str] = None):
        """
        :param _builtins.str network: The URI of the Service Consumer VPC that the Producer VPC is peered with.
        :param _builtins.str peering: The name of the VPC peering between the Service Consumer VPC and the Producer VPC (defined in the Tenant project) which is added to the NCC hub. This peering must be in ACTIVE state.
        :param Sequence[_builtins.str] exclude_export_ranges: IP ranges encompassing the subnets to be excluded from peering.
        :param Sequence[_builtins.str] include_export_ranges: IP ranges allowed to be included from peering.
        :param _builtins.str producer_network: (Output)
               The URI of the Producer VPC.
        """
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "peering", peering)
        if exclude_export_ranges is not None:
            pulumi.set(__self__, "exclude_export_ranges", exclude_export_ranges)
        if include_export_ranges is not None:
            pulumi.set(__self__, "include_export_ranges", include_export_ranges)
        if producer_network is not None:
            pulumi.set(__self__, "producer_network", producer_network)

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        The URI of the Service Consumer VPC that the Producer VPC is peered with.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def peering(self) -> _builtins.str:
        """
        The name of the VPC peering between the Service Consumer VPC and the Producer VPC (defined in the Tenant project) which is added to the NCC hub. This peering must be in ACTIVE state.
        """
        return pulumi.get(self, "peering")

    @_builtins.property
    @pulumi.getter(name="excludeExportRanges")
    def exclude_export_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP ranges encompassing the subnets to be excluded from peering.
        """
        return pulumi.get(self, "exclude_export_ranges")

    @_builtins.property
    @pulumi.getter(name="includeExportRanges")
    def include_export_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP ranges allowed to be included from peering.
        """
        return pulumi.get(self, "include_export_ranges")

    @_builtins.property
    @pulumi.getter(name="producerNetwork")
    def producer_network(self) -> Optional[_builtins.str]:
        """
        (Output)
        The URI of the Producer VPC.
        """
        return pulumi.get(self, "producer_network")


@pulumi.output_type
class SpokeLinkedRouterApplianceInstances(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "siteToSiteDataTransfer":
            suggest = "site_to_site_data_transfer"
        elif key == "includeImportRanges":
            suggest = "include_import_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpokeLinkedRouterApplianceInstances. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpokeLinkedRouterApplianceInstances.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpokeLinkedRouterApplianceInstances.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instances: Sequence['outputs.SpokeLinkedRouterApplianceInstancesInstance'],
                 site_to_site_data_transfer: _builtins.bool,
                 include_import_ranges: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence['SpokeLinkedRouterApplianceInstancesInstanceArgs'] instances: The list of router appliance instances
               Structure is documented below.
        :param _builtins.bool site_to_site_data_transfer: A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
        :param Sequence[_builtins.str] include_import_ranges: IP ranges allowed to be included during import from hub (does not control transit connectivity).
               The only allowed value for now is "ALL_IPV4_RANGES".
        """
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "site_to_site_data_transfer", site_to_site_data_transfer)
        if include_import_ranges is not None:
            pulumi.set(__self__, "include_import_ranges", include_import_ranges)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.SpokeLinkedRouterApplianceInstancesInstance']:
        """
        The list of router appliance instances
        Structure is documented below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="siteToSiteDataTransfer")
    def site_to_site_data_transfer(self) -> _builtins.bool:
        """
        A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
        """
        return pulumi.get(self, "site_to_site_data_transfer")

    @_builtins.property
    @pulumi.getter(name="includeImportRanges")
    def include_import_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP ranges allowed to be included during import from hub (does not control transit connectivity).
        The only allowed value for now is "ALL_IPV4_RANGES".
        """
        return pulumi.get(self, "include_import_ranges")


@pulumi.output_type
class SpokeLinkedRouterApplianceInstancesInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "virtualMachine":
            suggest = "virtual_machine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpokeLinkedRouterApplianceInstancesInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpokeLinkedRouterApplianceInstancesInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpokeLinkedRouterApplianceInstancesInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: _builtins.str,
                 virtual_machine: _builtins.str):
        """
        :param _builtins.str ip_address: The IP address on the VM to use for peering.
        :param _builtins.str virtual_machine: The URI of the virtual machine resource
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "virtual_machine", virtual_machine)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address on the VM to use for peering.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> _builtins.str:
        """
        The URI of the virtual machine resource
        """
        return pulumi.get(self, "virtual_machine")


@pulumi.output_type
class SpokeLinkedVpcNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeExportRanges":
            suggest = "exclude_export_ranges"
        elif key == "includeExportRanges":
            suggest = "include_export_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpokeLinkedVpcNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpokeLinkedVpcNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpokeLinkedVpcNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 uri: _builtins.str,
                 exclude_export_ranges: Optional[Sequence[_builtins.str]] = None,
                 include_export_ranges: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str uri: The URI of the VPC network resource.
        :param Sequence[_builtins.str] exclude_export_ranges: IP ranges encompassing the subnets to be excluded from peering.
        :param Sequence[_builtins.str] include_export_ranges: IP ranges allowed to be included from peering.
        """
        pulumi.set(__self__, "uri", uri)
        if exclude_export_ranges is not None:
            pulumi.set(__self__, "exclude_export_ranges", exclude_export_ranges)
        if include_export_ranges is not None:
            pulumi.set(__self__, "include_export_ranges", include_export_ranges)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the VPC network resource.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="excludeExportRanges")
    def exclude_export_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP ranges encompassing the subnets to be excluded from peering.
        """
        return pulumi.get(self, "exclude_export_ranges")

    @_builtins.property
    @pulumi.getter(name="includeExportRanges")
    def include_export_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP ranges allowed to be included from peering.
        """
        return pulumi.get(self, "include_export_ranges")


@pulumi.output_type
class SpokeLinkedVpnTunnels(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "siteToSiteDataTransfer":
            suggest = "site_to_site_data_transfer"
        elif key == "includeImportRanges":
            suggest = "include_import_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpokeLinkedVpnTunnels. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpokeLinkedVpnTunnels.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpokeLinkedVpnTunnels.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 site_to_site_data_transfer: _builtins.bool,
                 uris: Sequence[_builtins.str],
                 include_import_ranges: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool site_to_site_data_transfer: A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
        :param Sequence[_builtins.str] uris: The URIs of linked VPN tunnel resources.
        :param Sequence[_builtins.str] include_import_ranges: IP ranges allowed to be included during import from hub (does not control transit connectivity).
               The only allowed value for now is "ALL_IPV4_RANGES".
        """
        pulumi.set(__self__, "site_to_site_data_transfer", site_to_site_data_transfer)
        pulumi.set(__self__, "uris", uris)
        if include_import_ranges is not None:
            pulumi.set(__self__, "include_import_ranges", include_import_ranges)

    @_builtins.property
    @pulumi.getter(name="siteToSiteDataTransfer")
    def site_to_site_data_transfer(self) -> _builtins.bool:
        """
        A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
        """
        return pulumi.get(self, "site_to_site_data_transfer")

    @_builtins.property
    @pulumi.getter
    def uris(self) -> Sequence[_builtins.str]:
        """
        The URIs of linked VPN tunnel resources.
        """
        return pulumi.get(self, "uris")

    @_builtins.property
    @pulumi.getter(name="includeImportRanges")
    def include_import_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        IP ranges allowed to be included during import from hub (does not control transit connectivity).
        The only allowed value for now is "ALL_IPV4_RANGES".
        """
        return pulumi.get(self, "include_import_ranges")


@pulumi.output_type
class SpokeReason(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userDetails":
            suggest = "user_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpokeReason. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpokeReason.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpokeReason.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: Optional[_builtins.str] = None,
                 message: Optional[_builtins.str] = None,
                 user_details: Optional[_builtins.str] = None):
        """
        :param _builtins.str code: The code associated with this reason.
        :param _builtins.str message: Human-readable details about this reason.
        :param _builtins.str user_details: Additional information provided by the user in the RejectSpoke call.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if user_details is not None:
            pulumi.set(__self__, "user_details", user_details)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.str]:
        """
        The code associated with this reason.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        Human-readable details about this reason.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="userDetails")
    def user_details(self) -> Optional[_builtins.str]:
        """
        Additional information provided by the user in the RejectSpoke call.
        """
        return pulumi.get(self, "user_details")


