# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCloudVmClusterResult',
    'AwaitableGetCloudVmClusterResult',
    'get_cloud_vm_cluster',
    'get_cloud_vm_cluster_output',
]

@pulumi.output_type
class GetCloudVmClusterResult:
    """
    A collection of values returned by getCloudVmCluster.
    """
    def __init__(__self__, backup_subnet_cidr=None, cidr=None, cloud_vm_cluster_id=None, create_time=None, deletion_protection=None, display_name=None, effective_labels=None, exadata_infrastructure=None, gcp_oracle_zone=None, id=None, labels=None, location=None, name=None, network=None, project=None, properties=None, pulumi_labels=None):
        if backup_subnet_cidr and not isinstance(backup_subnet_cidr, str):
            raise TypeError("Expected argument 'backup_subnet_cidr' to be a str")
        pulumi.set(__self__, "backup_subnet_cidr", backup_subnet_cidr)
        if cidr and not isinstance(cidr, str):
            raise TypeError("Expected argument 'cidr' to be a str")
        pulumi.set(__self__, "cidr", cidr)
        if cloud_vm_cluster_id and not isinstance(cloud_vm_cluster_id, str):
            raise TypeError("Expected argument 'cloud_vm_cluster_id' to be a str")
        pulumi.set(__self__, "cloud_vm_cluster_id", cloud_vm_cluster_id)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if exadata_infrastructure and not isinstance(exadata_infrastructure, str):
            raise TypeError("Expected argument 'exadata_infrastructure' to be a str")
        pulumi.set(__self__, "exadata_infrastructure", exadata_infrastructure)
        if gcp_oracle_zone and not isinstance(gcp_oracle_zone, str):
            raise TypeError("Expected argument 'gcp_oracle_zone' to be a str")
        pulumi.set(__self__, "gcp_oracle_zone", gcp_oracle_zone)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network and not isinstance(network, str):
            raise TypeError("Expected argument 'network' to be a str")
        pulumi.set(__self__, "network", network)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)

    @_builtins.property
    @pulumi.getter(name="backupSubnetCidr")
    def backup_subnet_cidr(self) -> _builtins.str:
        return pulumi.get(self, "backup_subnet_cidr")

    @_builtins.property
    @pulumi.getter
    def cidr(self) -> _builtins.str:
        return pulumi.get(self, "cidr")

    @_builtins.property
    @pulumi.getter(name="cloudVmClusterId")
    def cloud_vm_cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cloud_vm_cluster_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> _builtins.bool:
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="exadataInfrastructure")
    def exadata_infrastructure(self) -> _builtins.str:
        return pulumi.get(self, "exadata_infrastructure")

    @_builtins.property
    @pulumi.getter(name="gcpOracleZone")
    def gcp_oracle_zone(self) -> _builtins.str:
        return pulumi.get(self, "gcp_oracle_zone")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetCloudVmClusterPropertyResult']:
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "pulumi_labels")


class AwaitableGetCloudVmClusterResult(GetCloudVmClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudVmClusterResult(
            backup_subnet_cidr=self.backup_subnet_cidr,
            cidr=self.cidr,
            cloud_vm_cluster_id=self.cloud_vm_cluster_id,
            create_time=self.create_time,
            deletion_protection=self.deletion_protection,
            display_name=self.display_name,
            effective_labels=self.effective_labels,
            exadata_infrastructure=self.exadata_infrastructure,
            gcp_oracle_zone=self.gcp_oracle_zone,
            id=self.id,
            labels=self.labels,
            location=self.location,
            name=self.name,
            network=self.network,
            project=self.project,
            properties=self.properties,
            pulumi_labels=self.pulumi_labels)


def get_cloud_vm_cluster(cloud_vm_cluster_id: Optional[_builtins.str] = None,
                         location: Optional[_builtins.str] = None,
                         project: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudVmClusterResult:
    """
    Get information about a CloudVmCluster.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_vmcluster = gcp.oracledatabase.get_cloud_vm_cluster(location="us-east4",
        cloud_vm_cluster_id="vmcluster-id")
    ```


    :param _builtins.str cloud_vm_cluster_id: The ID of the VM Cluster.
    :param _builtins.str location: The location of the resource.
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:oracledatabase/getCloudVmCluster:getCloudVmCluster', __args__, opts=opts, typ=GetCloudVmClusterResult).value

    return AwaitableGetCloudVmClusterResult(
        backup_subnet_cidr=pulumi.get(__ret__, 'backup_subnet_cidr'),
        cidr=pulumi.get(__ret__, 'cidr'),
        cloud_vm_cluster_id=pulumi.get(__ret__, 'cloud_vm_cluster_id'),
        create_time=pulumi.get(__ret__, 'create_time'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        display_name=pulumi.get(__ret__, 'display_name'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        exadata_infrastructure=pulumi.get(__ret__, 'exadata_infrastructure'),
        gcp_oracle_zone=pulumi.get(__ret__, 'gcp_oracle_zone'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        network=pulumi.get(__ret__, 'network'),
        project=pulumi.get(__ret__, 'project'),
        properties=pulumi.get(__ret__, 'properties'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'))
def get_cloud_vm_cluster_output(cloud_vm_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                location: Optional[pulumi.Input[_builtins.str]] = None,
                                project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudVmClusterResult]:
    """
    Get information about a CloudVmCluster.

    For more information see the
    [API](https://cloud.google.com/oracle/database/docs/reference/rest/v1/projects.locations.cloudVmClusters).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_vmcluster = gcp.oracledatabase.get_cloud_vm_cluster(location="us-east4",
        cloud_vm_cluster_id="vmcluster-id")
    ```


    :param _builtins.str cloud_vm_cluster_id: The ID of the VM Cluster.
    :param _builtins.str location: The location of the resource.
           
           - - -
    :param _builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['cloudVmClusterId'] = cloud_vm_cluster_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:oracledatabase/getCloudVmCluster:getCloudVmCluster', __args__, opts=opts, typ=GetCloudVmClusterResult)
    return __ret__.apply(lambda __response__: GetCloudVmClusterResult(
        backup_subnet_cidr=pulumi.get(__response__, 'backup_subnet_cidr'),
        cidr=pulumi.get(__response__, 'cidr'),
        cloud_vm_cluster_id=pulumi.get(__response__, 'cloud_vm_cluster_id'),
        create_time=pulumi.get(__response__, 'create_time'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        display_name=pulumi.get(__response__, 'display_name'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        exadata_infrastructure=pulumi.get(__response__, 'exadata_infrastructure'),
        gcp_oracle_zone=pulumi.get(__response__, 'gcp_oracle_zone'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        network=pulumi.get(__response__, 'network'),
        project=pulumi.get(__response__, 'project'),
        properties=pulumi.get(__response__, 'properties'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels')))
