# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 auto_create_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing_account: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.bool] auto_create_network: Create the 'default' network automatically. Default true. If set to false, the default network will be deleted. Note
               that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even
               if you set auto_create_network to false, since the network will exist momentarily.
        :param pulumi.Input[_builtins.str] billing_account: The alphanumeric ID of the billing account this project
               belongs to. The user or service account performing this operation with the provider
               must have at mininum Billing Account User privileges (`roles/billing.user`) on the billing account.
               See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/docs/how-to/billing-access)
               for more details.
        :param pulumi.Input[_builtins.str] folder_id: The numeric ID of the folder this project should be
               created under. Only one of `org_id` or `folder_id` may be
               specified. If the `folder_id` is specified, then the project is
               created under the specified folder. Changing this forces the
               project to be migrated to the newly specified folder.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the project.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The display name of the project.
        :param pulumi.Input[_builtins.str] org_id: The numeric ID of the organization this project belongs to.
               Changing this forces a new project to be created.  Only one of
               `org_id` or `folder_id` may be specified. If the `org_id` is
               specified then the project is created at the top level. Changing
               this forces the project to be migrated to the newly specified
               organization.
        :param pulumi.Input[_builtins.str] project_id: The project ID. Changing this forces a new project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored when empty. The field is immutable and causes resource replacement when mutated. This field is only set at create time and modifying this field after creation will trigger recreation. To apply tags to an existing resource, see the `tags.TagValue` resource.
        """
        if auto_create_network is not None:
            pulumi.set(__self__, "auto_create_network", auto_create_network)
        if billing_account is not None:
            pulumi.set(__self__, "billing_account", billing_account)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoCreateNetwork")
    def auto_create_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Create the 'default' network automatically. Default true. If set to false, the default network will be deleted. Note
        that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even
        if you set auto_create_network to false, since the network will exist momentarily.
        """
        return pulumi.get(self, "auto_create_network")

    @auto_create_network.setter
    def auto_create_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_network", value)

    @_builtins.property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alphanumeric ID of the billing account this project
        belongs to. The user or service account performing this operation with the provider
        must have at mininum Billing Account User privileges (`roles/billing.user`) on the billing account.
        See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/docs/how-to/billing-access)
        for more details.
        """
        return pulumi.get(self, "billing_account")

    @billing_account.setter
    def billing_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_account", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The numeric ID of the folder this project should be
        created under. Only one of `org_id` or `folder_id` may be
        specified. If the `folder_id` is specified, then the project is
        created under the specified folder. Changing this forces the
        project to be migrated to the newly specified folder.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to the project.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The numeric ID of the organization this project belongs to.
        Changing this forces a new project to be created.  Only one of
        `org_id` or `folder_id` may be specified. If the `org_id` is
        specified then the project is created at the top level. Changing
        this forces the project to be migrated to the newly specified
        organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID. Changing this forces a new project to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored when empty. The field is immutable and causes resource replacement when mutated. This field is only set at create time and modifying this field after creation will trigger recreation. To apply tags to an existing resource, see the `tags.TagValue` resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 auto_create_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing_account: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.bool] auto_create_network: Create the 'default' network automatically. Default true. If set to false, the default network will be deleted. Note
               that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even
               if you set auto_create_network to false, since the network will exist momentarily.
        :param pulumi.Input[_builtins.str] billing_account: The alphanumeric ID of the billing account this project
               belongs to. The user or service account performing this operation with the provider
               must have at mininum Billing Account User privileges (`roles/billing.user`) on the billing account.
               See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/docs/how-to/billing-access)
               for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] folder_id: The numeric ID of the folder this project should be
               created under. Only one of `org_id` or `folder_id` may be
               specified. If the `folder_id` is specified, then the project is
               created under the specified folder. Changing this forces the
               project to be migrated to the newly specified folder.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the project.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The display name of the project.
        :param pulumi.Input[_builtins.str] number: The numeric identifier of the project.
        :param pulumi.Input[_builtins.str] org_id: The numeric ID of the organization this project belongs to.
               Changing this forces a new project to be created.  Only one of
               `org_id` or `folder_id` may be specified. If the `org_id` is
               specified then the project is created at the top level. Changing
               this forces the project to be migrated to the newly specified
               organization.
        :param pulumi.Input[_builtins.str] project_id: The project ID. Changing this forces a new project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored when empty. The field is immutable and causes resource replacement when mutated. This field is only set at create time and modifying this field after creation will trigger recreation. To apply tags to an existing resource, see the `tags.TagValue` resource.
        """
        if auto_create_network is not None:
            pulumi.set(__self__, "auto_create_network", auto_create_network)
        if billing_account is not None:
            pulumi.set(__self__, "billing_account", billing_account)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="autoCreateNetwork")
    def auto_create_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Create the 'default' network automatically. Default true. If set to false, the default network will be deleted. Note
        that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even
        if you set auto_create_network to false, since the network will exist momentarily.
        """
        return pulumi.get(self, "auto_create_network")

    @auto_create_network.setter
    def auto_create_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_create_network", value)

    @_builtins.property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alphanumeric ID of the billing account this project
        belongs to. The user or service account performing this operation with the provider
        must have at mininum Billing Account User privileges (`roles/billing.user`) on the billing account.
        See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/docs/how-to/billing-access)
        for more details.
        """
        return pulumi.get(self, "billing_account")

    @billing_account.setter
    def billing_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "billing_account", value)

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The numeric ID of the folder this project should be
        created under. Only one of `org_id` or `folder_id` may be
        specified. If the `folder_id` is specified, then the project is
        created under the specified folder. Changing this forces the
        project to be migrated to the newly specified folder.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A set of key/value label pairs to assign to the project.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The numeric identifier of the project.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The numeric ID of the organization this project belongs to.
        Changing this forces a new project to be created.  Only one of
        `org_id` or `folder_id` may be specified. If the `org_id` is
        specified then the project is created at the top level. Changing
        this forces the project to be migrated to the newly specified
        organization.
        """
        return pulumi.get(self, "org_id")

    @org_id.setter
    def org_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project ID. Changing this forces a new project to be created.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored when empty. The field is immutable and causes resource replacement when mutated. This field is only set at create time and modifying this field after creation will trigger recreation. To apply tags to an existing resource, see the `tags.TagValue` resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("gcp:organizations/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing_account: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Allows creation and management of a Google Cloud Platform project.

        Projects created with this resource must be associated with an Organization.
        See the [Organization documentation](https://cloud.google.com/resource-manager/docs/quickstarts) for more details.

        The user or service account that is running this provider when creating a `organizations.Project`
        resource must have `roles/resourcemanager.projectCreator` on the specified organization. See the
        [Access Control for Organizations Using IAM](https://cloud.google.com/resource-manager/docs/access-control-org)
        doc for more information.

        > This resource reads the specified billing account on every pulumi up and plan operation so you must have permissions on the specified billing account.

        > It is recommended to use the `constraints/compute.skipDefaultNetworkCreation` [constraint](https://www.terraform.io/docs/providers/google/r/google_organization_policy.html) to remove the default network instead of setting `auto_create_network` to false, when possible.

        > It may take a while for the attached tag bindings to be deleted after the project is scheduled to be deleted.

        To get more information about projects, see:

        * [API documentation](https://cloud.google.com/resource-manager/reference/rest/v1/projects)
        * How-to Guides
            * [Creating and managing projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.organizations.Project("my_project",
            name="My Project",
            project_id="your-project-id",
            org_id="1234567")
        ```

        To create a project under a specific folder

        ```python
        import pulumi
        import pulumi_gcp as gcp

        department1 = gcp.organizations.Folder("department1",
            display_name="Department 1",
            parent="organizations/1234567")
        my_project_in_a_folder = gcp.organizations.Project("my_project-in-a-folder",
            name="My Project",
            project_id="your-project-id",
            folder_id=department1.name)
        ```

        To create a project with a tag

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.organizations.Project("my_project",
            name="My Project",
            project_id="your-project-id",
            org_id="1234567",
            tags={
                "1234567/env": "staging",
            })
        ```

        ## Import

        Projects can be imported using the `project_id`, e.g.

        * `{{project_id}}`

        When using the `pulumi import` command, Projects can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:organizations/project:Project default {{project_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create_network: Create the 'default' network automatically. Default true. If set to false, the default network will be deleted. Note
               that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even
               if you set auto_create_network to false, since the network will exist momentarily.
        :param pulumi.Input[_builtins.str] billing_account: The alphanumeric ID of the billing account this project
               belongs to. The user or service account performing this operation with the provider
               must have at mininum Billing Account User privileges (`roles/billing.user`) on the billing account.
               See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/docs/how-to/billing-access)
               for more details.
        :param pulumi.Input[_builtins.str] folder_id: The numeric ID of the folder this project should be
               created under. Only one of `org_id` or `folder_id` may be
               specified. If the `folder_id` is specified, then the project is
               created under the specified folder. Changing this forces the
               project to be migrated to the newly specified folder.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the project.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The display name of the project.
        :param pulumi.Input[_builtins.str] org_id: The numeric ID of the organization this project belongs to.
               Changing this forces a new project to be created.  Only one of
               `org_id` or `folder_id` may be specified. If the `org_id` is
               specified then the project is created at the top level. Changing
               this forces the project to be migrated to the newly specified
               organization.
        :param pulumi.Input[_builtins.str] project_id: The project ID. Changing this forces a new project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored when empty. The field is immutable and causes resource replacement when mutated. This field is only set at create time and modifying this field after creation will trigger recreation. To apply tags to an existing resource, see the `tags.TagValue` resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows creation and management of a Google Cloud Platform project.

        Projects created with this resource must be associated with an Organization.
        See the [Organization documentation](https://cloud.google.com/resource-manager/docs/quickstarts) for more details.

        The user or service account that is running this provider when creating a `organizations.Project`
        resource must have `roles/resourcemanager.projectCreator` on the specified organization. See the
        [Access Control for Organizations Using IAM](https://cloud.google.com/resource-manager/docs/access-control-org)
        doc for more information.

        > This resource reads the specified billing account on every pulumi up and plan operation so you must have permissions on the specified billing account.

        > It is recommended to use the `constraints/compute.skipDefaultNetworkCreation` [constraint](https://www.terraform.io/docs/providers/google/r/google_organization_policy.html) to remove the default network instead of setting `auto_create_network` to false, when possible.

        > It may take a while for the attached tag bindings to be deleted after the project is scheduled to be deleted.

        To get more information about projects, see:

        * [API documentation](https://cloud.google.com/resource-manager/reference/rest/v1/projects)
        * How-to Guides
            * [Creating and managing projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.organizations.Project("my_project",
            name="My Project",
            project_id="your-project-id",
            org_id="1234567")
        ```

        To create a project under a specific folder

        ```python
        import pulumi
        import pulumi_gcp as gcp

        department1 = gcp.organizations.Folder("department1",
            display_name="Department 1",
            parent="organizations/1234567")
        my_project_in_a_folder = gcp.organizations.Project("my_project-in-a-folder",
            name="My Project",
            project_id="your-project-id",
            folder_id=department1.name)
        ```

        To create a project with a tag

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_project = gcp.organizations.Project("my_project",
            name="My Project",
            project_id="your-project-id",
            org_id="1234567",
            tags={
                "1234567/env": "staging",
            })
        ```

        ## Import

        Projects can be imported using the `project_id`, e.g.

        * `{{project_id}}`

        When using the `pulumi import` command, Projects can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:organizations/project:Project default {{project_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_create_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 billing_account: Optional[pulumi.Input[_builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 folder_id: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["auto_create_network"] = auto_create_network
            __props__.__dict__["billing_account"] = billing_account
            __props__.__dict__["deletion_policy"] = deletion_policy
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["org_id"] = org_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["number"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Project, __self__).__init__(
            'gcp:organizations/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_create_network: Optional[pulumi.Input[_builtins.bool]] = None,
            billing_account: Optional[pulumi.Input[_builtins.str]] = None,
            deletion_policy: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            folder_id: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            number: Optional[pulumi.Input[_builtins.str]] = None,
            org_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] auto_create_network: Create the 'default' network automatically. Default true. If set to false, the default network will be deleted. Note
               that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even
               if you set auto_create_network to false, since the network will exist momentarily.
        :param pulumi.Input[_builtins.str] billing_account: The alphanumeric ID of the billing account this project
               belongs to. The user or service account performing this operation with the provider
               must have at mininum Billing Account User privileges (`roles/billing.user`) on the billing account.
               See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/docs/how-to/billing-access)
               for more details.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] folder_id: The numeric ID of the folder this project should be
               created under. Only one of `org_id` or `folder_id` may be
               specified. If the `folder_id` is specified, then the project is
               created under the specified folder. Changing this forces the
               project to be migrated to the newly specified folder.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A set of key/value label pairs to assign to the project.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The display name of the project.
        :param pulumi.Input[_builtins.str] number: The numeric identifier of the project.
        :param pulumi.Input[_builtins.str] org_id: The numeric ID of the organization this project belongs to.
               Changing this forces a new project to be created.  Only one of
               `org_id` or `folder_id` may be specified. If the `org_id` is
               specified then the project is created at the top level. Changing
               this forces the project to be migrated to the newly specified
               organization.
        :param pulumi.Input[_builtins.str] project_id: The project ID. Changing this forces a new project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored when empty. The field is immutable and causes resource replacement when mutated. This field is only set at create time and modifying this field after creation will trigger recreation. To apply tags to an existing resource, see the `tags.TagValue` resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["auto_create_network"] = auto_create_network
        __props__.__dict__["billing_account"] = billing_account
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["number"] = number
        __props__.__dict__["org_id"] = org_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["tags"] = tags
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoCreateNetwork")
    def auto_create_network(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Create the 'default' network automatically. Default true. If set to false, the default network will be deleted. Note
        that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even
        if you set auto_create_network to false, since the network will exist momentarily.
        """
        return pulumi.get(self, "auto_create_network")

    @_builtins.property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The alphanumeric ID of the billing account this project
        belongs to. The user or service account performing this operation with the provider
        must have at mininum Billing Account User privileges (`roles/billing.user`) on the billing account.
        See [Google Cloud Billing API Access Control](https://cloud.google.com/billing/docs/how-to/billing-access)
        for more details.
        """
        return pulumi.get(self, "billing_account")

    @_builtins.property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "deletion_policy")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The numeric ID of the folder this project should be
        created under. Only one of `org_id` or `folder_id` may be
        specified. If the `folder_id` is specified, then the project is
        created under the specified folder. Changing this forces the
        project to be migrated to the newly specified folder.
        """
        return pulumi.get(self, "folder_id")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A set of key/value label pairs to assign to the project.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def number(self) -> pulumi.Output[_builtins.str]:
        """
        The numeric identifier of the project.
        """
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The numeric ID of the organization this project belongs to.
        Changing this forces a new project to be created.  Only one of
        `org_id` or `folder_id` may be specified. If the `org_id` is
        specified then the project is created at the top level. Changing
        this forces the project to be migrated to the newly specified
        organization.
        """
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project ID. Changing this forces a new project to be created.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of resource manager tags. Resource manager tag keys and values have the same definition as resource manager tags. Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/456. The field is ignored when empty. The field is immutable and causes resource replacement when mutated. This field is only set at create time and modifying this field after creation will trigger recreation. To apply tags to an existing resource, see the `tags.TagValue` resource.
        """
        return pulumi.get(self, "tags")

