# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UsageExportBucketArgs', 'UsageExportBucket']

@pulumi.input_type
class UsageExportBucketArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[_builtins.str],
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a UsageExportBucket resource.
        :param pulumi.Input[_builtins.str] bucket_name: The bucket to store reports in.
               
               - - -
        :param pulumi.Input[_builtins.str] prefix: A prefix for the reports, for instance, the project name.
        :param pulumi.Input[_builtins.str] project: The project to set the export bucket on. If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[_builtins.str]:
        """
        The bucket to store reports in.

        - - -
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A prefix for the reports, for instance, the project name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project to set the export bucket on. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _UsageExportBucketState:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering UsageExportBucket resources.
        :param pulumi.Input[_builtins.str] bucket_name: The bucket to store reports in.
               
               - - -
        :param pulumi.Input[_builtins.str] prefix: A prefix for the reports, for instance, the project name.
        :param pulumi.Input[_builtins.str] project: The project to set the export bucket on. If it is not provided, the provider project is used.
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The bucket to store reports in.

        - - -
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket_name", value)

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A prefix for the reports, for instance, the project name.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "prefix", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project to set the export bucket on. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:projects/usageExportBucket:UsageExportBucket")
class UsageExportBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Sets up a usage export bucket for a particular project.  A usage export bucket
        is a pre-configured GCS bucket which is set up to receive daily and monthly
        reports of the GCE resources used.

        For more information see the [Docs](https://cloud.google.com/compute/docs/usage-export)
        and for further details, the
        [API Documentation](https://cloud.google.com/compute/docs/reference/rest/beta/projects/setUsageExportBucket).

        > **Note:** You should specify only one of these per project.  If there are two or more
        they will fight over which bucket the reports should be stored in.  It is
        safe to have multiple resources with the same backing bucket.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        usage_export = gcp.projects.UsageExportBucket("usage_export",
            project="development-project",
            bucket_name="usage-tracking-bucket")
        ```

        ## Import

        A project's Usage Export Bucket can be imported using this format:

        * `{{project_id}}`

        When using the `pulumi import` command, NAME_HERE can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:projects/usageExportBucket:UsageExportBucket default {{project_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: The bucket to store reports in.
               
               - - -
        :param pulumi.Input[_builtins.str] prefix: A prefix for the reports, for instance, the project name.
        :param pulumi.Input[_builtins.str] project: The project to set the export bucket on. If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UsageExportBucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Sets up a usage export bucket for a particular project.  A usage export bucket
        is a pre-configured GCS bucket which is set up to receive daily and monthly
        reports of the GCE resources used.

        For more information see the [Docs](https://cloud.google.com/compute/docs/usage-export)
        and for further details, the
        [API Documentation](https://cloud.google.com/compute/docs/reference/rest/beta/projects/setUsageExportBucket).

        > **Note:** You should specify only one of these per project.  If there are two or more
        they will fight over which bucket the reports should be stored in.  It is
        safe to have multiple resources with the same backing bucket.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        usage_export = gcp.projects.UsageExportBucket("usage_export",
            project="development-project",
            bucket_name="usage-tracking-bucket")
        ```

        ## Import

        A project's Usage Export Bucket can be imported using this format:

        * `{{project_id}}`

        When using the `pulumi import` command, NAME_HERE can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:projects/usageExportBucket:UsageExportBucket default {{project_id}}
        ```

        :param str resource_name: The name of the resource.
        :param UsageExportBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UsageExportBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
                 prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UsageExportBucketArgs.__new__(UsageExportBucketArgs)

            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["prefix"] = prefix
            __props__.__dict__["project"] = project
        super(UsageExportBucket, __self__).__init__(
            'gcp:projects/usageExportBucket:UsageExportBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_name: Optional[pulumi.Input[_builtins.str]] = None,
            prefix: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None) -> 'UsageExportBucket':
        """
        Get an existing UsageExportBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket_name: The bucket to store reports in.
               
               - - -
        :param pulumi.Input[_builtins.str] prefix: A prefix for the reports, for instance, the project name.
        :param pulumi.Input[_builtins.str] project: The project to set the export bucket on. If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UsageExportBucketState.__new__(_UsageExportBucketState)

        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["project"] = project
        return UsageExportBucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[_builtins.str]:
        """
        The bucket to store reports in.

        - - -
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A prefix for the reports, for instance, the project name.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The project to set the export bucket on. If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

