# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'EnterpriseKeyAndroidSettings',
    'EnterpriseKeyIosSettings',
    'EnterpriseKeyTestingOptions',
    'EnterpriseKeyWafSettings',
    'EnterpriseKeyWebSettings',
]

@pulumi.output_type
class EnterpriseKeyAndroidSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowAllPackageNames":
            suggest = "allow_all_package_names"
        elif key == "allowedPackageNames":
            suggest = "allowed_package_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnterpriseKeyAndroidSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnterpriseKeyAndroidSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnterpriseKeyAndroidSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_all_package_names: Optional[_builtins.bool] = None,
                 allowed_package_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool allow_all_package_names: If set to true, it means allowed_package_names will not be enforced.
        :param Sequence[_builtins.str] allowed_package_names: Android package names of apps allowed to use the key. Example: 'com.companyname.appname'
        """
        if allow_all_package_names is not None:
            pulumi.set(__self__, "allow_all_package_names", allow_all_package_names)
        if allowed_package_names is not None:
            pulumi.set(__self__, "allowed_package_names", allowed_package_names)

    @_builtins.property
    @pulumi.getter(name="allowAllPackageNames")
    def allow_all_package_names(self) -> Optional[_builtins.bool]:
        """
        If set to true, it means allowed_package_names will not be enforced.
        """
        return pulumi.get(self, "allow_all_package_names")

    @_builtins.property
    @pulumi.getter(name="allowedPackageNames")
    def allowed_package_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        Android package names of apps allowed to use the key. Example: 'com.companyname.appname'
        """
        return pulumi.get(self, "allowed_package_names")


@pulumi.output_type
class EnterpriseKeyIosSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowAllBundleIds":
            suggest = "allow_all_bundle_ids"
        elif key == "allowedBundleIds":
            suggest = "allowed_bundle_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnterpriseKeyIosSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnterpriseKeyIosSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnterpriseKeyIosSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_all_bundle_ids: Optional[_builtins.bool] = None,
                 allowed_bundle_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool allow_all_bundle_ids: If set to true, it means allowed_bundle_ids will not be enforced.
        :param Sequence[_builtins.str] allowed_bundle_ids: iOS bundle ids of apps allowed to use the key. Example: 'com.companyname.productname.appname'
        """
        if allow_all_bundle_ids is not None:
            pulumi.set(__self__, "allow_all_bundle_ids", allow_all_bundle_ids)
        if allowed_bundle_ids is not None:
            pulumi.set(__self__, "allowed_bundle_ids", allowed_bundle_ids)

    @_builtins.property
    @pulumi.getter(name="allowAllBundleIds")
    def allow_all_bundle_ids(self) -> Optional[_builtins.bool]:
        """
        If set to true, it means allowed_bundle_ids will not be enforced.
        """
        return pulumi.get(self, "allow_all_bundle_ids")

    @_builtins.property
    @pulumi.getter(name="allowedBundleIds")
    def allowed_bundle_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        iOS bundle ids of apps allowed to use the key. Example: 'com.companyname.productname.appname'
        """
        return pulumi.get(self, "allowed_bundle_ids")


@pulumi.output_type
class EnterpriseKeyTestingOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testingChallenge":
            suggest = "testing_challenge"
        elif key == "testingScore":
            suggest = "testing_score"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnterpriseKeyTestingOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnterpriseKeyTestingOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnterpriseKeyTestingOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 testing_challenge: Optional[_builtins.str] = None,
                 testing_score: Optional[_builtins.float] = None):
        """
        :param _builtins.str testing_challenge: For challenge-based keys only (CHECKBOX, INVISIBLE), all challenge requests for this site will return nocaptcha if NOCAPTCHA, or an unsolvable challenge if UNSOLVABLE_CHALLENGE. Possible values: TESTING_CHALLENGE_UNSPECIFIED, NOCAPTCHA, UNSOLVABLE_CHALLENGE
        :param _builtins.float testing_score: All assessments for this Key will return this score. Must be between 0 (likely not legitimate) and 1 (likely legitimate) inclusive.
        """
        if testing_challenge is not None:
            pulumi.set(__self__, "testing_challenge", testing_challenge)
        if testing_score is not None:
            pulumi.set(__self__, "testing_score", testing_score)

    @_builtins.property
    @pulumi.getter(name="testingChallenge")
    def testing_challenge(self) -> Optional[_builtins.str]:
        """
        For challenge-based keys only (CHECKBOX, INVISIBLE), all challenge requests for this site will return nocaptcha if NOCAPTCHA, or an unsolvable challenge if UNSOLVABLE_CHALLENGE. Possible values: TESTING_CHALLENGE_UNSPECIFIED, NOCAPTCHA, UNSOLVABLE_CHALLENGE
        """
        return pulumi.get(self, "testing_challenge")

    @_builtins.property
    @pulumi.getter(name="testingScore")
    def testing_score(self) -> Optional[_builtins.float]:
        """
        All assessments for this Key will return this score. Must be between 0 (likely not legitimate) and 1 (likely legitimate) inclusive.
        """
        return pulumi.get(self, "testing_score")


@pulumi.output_type
class EnterpriseKeyWafSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "wafFeature":
            suggest = "waf_feature"
        elif key == "wafService":
            suggest = "waf_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnterpriseKeyWafSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnterpriseKeyWafSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnterpriseKeyWafSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 waf_feature: _builtins.str,
                 waf_service: _builtins.str):
        """
        :param _builtins.str waf_feature: Supported WAF features. For more information, see https://cloud.google.com/recaptcha-enterprise/docs/usecase#comparison_of_features. Possible values: CHALLENGE_PAGE, SESSION_TOKEN, ACTION_TOKEN, EXPRESS
        :param _builtins.str waf_service: The WAF service that uses this key. Possible values: CA, FASTLY
        """
        pulumi.set(__self__, "waf_feature", waf_feature)
        pulumi.set(__self__, "waf_service", waf_service)

    @_builtins.property
    @pulumi.getter(name="wafFeature")
    def waf_feature(self) -> _builtins.str:
        """
        Supported WAF features. For more information, see https://cloud.google.com/recaptcha-enterprise/docs/usecase#comparison_of_features. Possible values: CHALLENGE_PAGE, SESSION_TOKEN, ACTION_TOKEN, EXPRESS
        """
        return pulumi.get(self, "waf_feature")

    @_builtins.property
    @pulumi.getter(name="wafService")
    def waf_service(self) -> _builtins.str:
        """
        The WAF service that uses this key. Possible values: CA, FASTLY
        """
        return pulumi.get(self, "waf_service")


@pulumi.output_type
class EnterpriseKeyWebSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "integrationType":
            suggest = "integration_type"
        elif key == "allowAllDomains":
            suggest = "allow_all_domains"
        elif key == "allowAmpTraffic":
            suggest = "allow_amp_traffic"
        elif key == "allowedDomains":
            suggest = "allowed_domains"
        elif key == "challengeSecurityPreference":
            suggest = "challenge_security_preference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnterpriseKeyWebSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnterpriseKeyWebSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnterpriseKeyWebSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 integration_type: _builtins.str,
                 allow_all_domains: Optional[_builtins.bool] = None,
                 allow_amp_traffic: Optional[_builtins.bool] = None,
                 allowed_domains: Optional[Sequence[_builtins.str]] = None,
                 challenge_security_preference: Optional[_builtins.str] = None):
        """
        :param _builtins.str integration_type: Required. Describes how this key is integrated with the website. Possible values: SCORE, CHECKBOX, INVISIBLE
        :param _builtins.bool allow_all_domains: If set to true, it means allowed_domains will not be enforced.
        :param _builtins.bool allow_amp_traffic: If set to true, the key can be used on AMP (Accelerated Mobile Pages) websites. This is supported only for the SCORE integration type.
        :param Sequence[_builtins.str] allowed_domains: Domains or subdomains of websites allowed to use the key. All subdomains of an allowed domain are automatically allowed. A valid domain requires a host and must not include any path, port, query or fragment. Examples: 'example.com' or 'subdomain.example.com'
        :param _builtins.str challenge_security_preference: Settings for the frequency and difficulty at which this key triggers captcha challenges. This should only be specified for IntegrationTypes CHECKBOX and INVISIBLE. Possible values: CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED, USABILITY, BALANCE, SECURITY
        """
        pulumi.set(__self__, "integration_type", integration_type)
        if allow_all_domains is not None:
            pulumi.set(__self__, "allow_all_domains", allow_all_domains)
        if allow_amp_traffic is not None:
            pulumi.set(__self__, "allow_amp_traffic", allow_amp_traffic)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if challenge_security_preference is not None:
            pulumi.set(__self__, "challenge_security_preference", challenge_security_preference)

    @_builtins.property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> _builtins.str:
        """
        Required. Describes how this key is integrated with the website. Possible values: SCORE, CHECKBOX, INVISIBLE
        """
        return pulumi.get(self, "integration_type")

    @_builtins.property
    @pulumi.getter(name="allowAllDomains")
    def allow_all_domains(self) -> Optional[_builtins.bool]:
        """
        If set to true, it means allowed_domains will not be enforced.
        """
        return pulumi.get(self, "allow_all_domains")

    @_builtins.property
    @pulumi.getter(name="allowAmpTraffic")
    def allow_amp_traffic(self) -> Optional[_builtins.bool]:
        """
        If set to true, the key can be used on AMP (Accelerated Mobile Pages) websites. This is supported only for the SCORE integration type.
        """
        return pulumi.get(self, "allow_amp_traffic")

    @_builtins.property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[Sequence[_builtins.str]]:
        """
        Domains or subdomains of websites allowed to use the key. All subdomains of an allowed domain are automatically allowed. A valid domain requires a host and must not include any path, port, query or fragment. Examples: 'example.com' or 'subdomain.example.com'
        """
        return pulumi.get(self, "allowed_domains")

    @_builtins.property
    @pulumi.getter(name="challengeSecurityPreference")
    def challenge_security_preference(self) -> Optional[_builtins.str]:
        """
        Settings for the frequency and difficulty at which this key triggers captcha challenges. This should only be specified for IntegrationTypes CHECKBOX and INVISIBLE. Possible values: CHALLENGE_SECURITY_PREFERENCE_UNSPECIFIED, USABILITY, BALANCE, SECURITY
        """
        return pulumi.get(self, "challenge_security_preference")


