# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 memory_size_gb: pulumi.Input[_builtins.int],
                 alternative_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input['InstancePersistenceConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replicas_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[_builtins.str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[_builtins.bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[_builtins.str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[_builtins.str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[_builtins.str] customer_managed_key: Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
               instance. If this is provided, CMEK is enabled.
        :param pulumi.Input[_builtins.str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: The self service update maintenance version.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input['InstancePersistenceConfigArgs'] persistence_config: Persistence configuration for an instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance.
               If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
               - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
               instance cannot scale up or down the number of replicas.
               - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
               can scale up and down the number of replicas.
               Possible values are: `READ_REPLICAS_DISABLED`, `READ_REPLICAS_ENABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[_builtins.str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[_builtins.str] region: The name of the Redis region of the instance.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with
               read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
               for a Standard Tier instance, the only valid value is 1 and the default is 1.
               The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[_builtins.str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[_builtins.str] secondary_ip_range: Optional. Additional IP range for node placement. Required when enabling read replicas on
               an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
               "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
               range associated with the private service access connection, or "auto".
        :param pulumi.Input[_builtins.str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are: `BASIC`, `STANDARD_HA`.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are: `SERVER_AUTHENTICATION`, `DISABLED`.
        """
        pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        if alternative_location_id is not None:
            pulumi.set(__self__, "alternative_location_id", alternative_location_id)
        if auth_enabled is not None:
            pulumi.set(__self__, "auth_enabled", auth_enabled)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if connect_mode is not None:
            pulumi.set(__self__, "connect_mode", connect_mode)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if read_replicas_mode is not None:
            pulumi.set(__self__, "read_replicas_mode", read_replicas_mode)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if secondary_ip_range is not None:
            pulumi.set(__self__, "secondary_ip_range", secondary_ip_range)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)

    @_builtins.property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> pulumi.Input[_builtins.int]:
        """
        Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @memory_size_gb.setter
    def memory_size_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only applicable to STANDARD_HA tier which protects the instance
        against zonal failures by provisioning it across two zones.
        If provided, it must be a different zone from the one provided in
        [locationId].
        """
        return pulumi.get(self, "alternative_location_id")

    @alternative_location_id.setter
    def alternative_location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alternative_location_id", value)

    @_builtins.property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the
        instance. If set to "true" AUTH is enabled on the instance.
        Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @auth_enabled.setter
    def auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auth_enabled", value)

    @_builtins.property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the Google Compute Engine network to which the
        instance is connected. If left unspecified, the default network
        will be used.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_network", value)

    @_builtins.property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection mode of the Redis instance.
        Default value is `DIRECT_PEERING`.
        Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`.
        """
        return pulumi.get(self, "connect_mode")

    @connect_mode.setter
    def connect_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_mode", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
        instance. If this is provided, CMEK is enabled.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone where the instance will be provisioned. If not provided,
        the service will choose a zone for the instance. For STANDARD_HA tier,
        instances will be created across two zones for protection against
        zonal failures. If [alternativeLocationId] is also provided, it must
        be different from [locationId].
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location_id", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The self service update maintenance version.
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigArgs']]:
        """
        Persistence configuration for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="readReplicasMode")
    def read_replicas_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Read replica mode. Can only be specified when trying to create the instance.
        If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
        - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
        instance cannot scale up or down the number of replicas.
        - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
        can scale up and down the number of replicas.
        Possible values are: `READ_REPLICAS_DISABLED`, `READ_REPLICAS_ENABLED`.
        """
        return pulumi.get(self, "read_replicas_mode")

    @read_replicas_mode.setter
    def read_replicas_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_replicas_mode", value)

    @_builtins.property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Redis configuration parameters, according to http://redis.io/topics/config.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_configs", value)

    @_builtins.property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Redis software. If not provided, latest supported
        version will be used. Please check the API documentation linked
        at the top for the latest valid values.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_version", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis region of the instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. The number of replica nodes. The valid range for the Standard Tier with
        read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
        for a Standard Tier instance, the only valid value is 1 and the default is 1.
        The valid value for basic tier is 0 and the default is also 0.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_ip_range", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpRange")
    def secondary_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Additional IP range for node placement. Required when enabling read replicas on
        an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
        "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
        range associated with the private service access connection, or "auto".
        """
        return pulumi.get(self, "secondary_ip_range")

    @secondary_ip_range.setter
    def secondary_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_ip_range", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service tier of the instance. Must be one of these values:
        - BASIC: standalone instance
        - STANDARD_HA: highly available primary/replica instances
        Default value is `BASIC`.
        Possible values are: `BASIC`, `STANDARD_HA`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
        - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
        Default value is `DISABLED`.
        Possible values are: `SERVER_AUTHENTICATION`, `DISABLED`.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 alternative_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auth_string: Optional[pulumi.Input[_builtins.str]] = None,
                 authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 current_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_reserved_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']] = None,
                 maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]] = None,
                 persistence_config: Optional[pulumi.Input['InstancePersistenceConfigArgs']] = None,
                 persistence_iam_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 read_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 read_endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
                 read_replicas_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[_builtins.bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[_builtins.str] auth_string: AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        :param pulumi.Input[_builtins.str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[_builtins.str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[_builtins.str] create_time: (Output)
               The time when the certificate was created.
        :param pulumi.Input[_builtins.str] current_location_id: The current zone where the Redis endpoint is placed.
               For Basic Tier instances, this will always be the same as the
               [locationId] provided by the user at creation time. For Standard Tier
               instances, this can be either [locationId] or [alternativeLocationId]
               and can change after a failover event.
        :param pulumi.Input[_builtins.str] customer_managed_key: Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
               instance. If this is provided, CMEK is enabled.
        :param pulumi.Input[_builtins.str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] effective_reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[_builtins.str] host: Hostname or IP address of the exposed Redis endpoint used by clients
               to connect to the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input['InstanceMaintenancePolicyArgs'] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: The self service update maintenance version.
        :param pulumi.Input[_builtins.int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]] nodes: Output only. Info per node.
               Structure is documented below.
        :param pulumi.Input['InstancePersistenceConfigArgs'] persistence_config: Persistence configuration for an instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] persistence_iam_identity: Output only. Cloud IAM identity used by import / export operations
               to transfer data to/from Cloud Storage. Format is "serviceAccount:".
               The value may change over time for a given instance so should be
               checked before each import/export operation.
        :param pulumi.Input[_builtins.int] port: The port number of the exposed Redis endpoint.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] read_endpoint: Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only.
               Targets all healthy replica nodes in instance. Replication is asynchronous and replica nodes
               will exhibit some lag behind the primary. Write requests must target 'host'.
        :param pulumi.Input[_builtins.int] read_endpoint_port: Output only. The port number of the exposed readonly redis endpoint. Standard tier only.
               Write requests should target 'port'.
        :param pulumi.Input[_builtins.str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance.
               If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
               - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
               instance cannot scale up or down the number of replicas.
               - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
               can scale up and down the number of replicas.
               Possible values are: `READ_REPLICAS_DISABLED`, `READ_REPLICAS_ENABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[_builtins.str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[_builtins.str] region: The name of the Redis region of the instance.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with
               read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
               for a Standard Tier instance, the only valid value is 1 and the default is 1.
               The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[_builtins.str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[_builtins.str] secondary_ip_range: Optional. Additional IP range for node placement. Required when enabling read replicas on
               an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
               "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
               range associated with the private service access connection, or "auto".
        :param pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]] server_ca_certs: List of server CA certificates for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are: `BASIC`, `STANDARD_HA`.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are: `SERVER_AUTHENTICATION`, `DISABLED`.
        """
        if alternative_location_id is not None:
            pulumi.set(__self__, "alternative_location_id", alternative_location_id)
        if auth_enabled is not None:
            pulumi.set(__self__, "auth_enabled", auth_enabled)
        if auth_string is not None:
            pulumi.set(__self__, "auth_string", auth_string)
        if authorized_network is not None:
            pulumi.set(__self__, "authorized_network", authorized_network)
        if connect_mode is not None:
            pulumi.set(__self__, "connect_mode", connect_mode)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if current_location_id is not None:
            pulumi.set(__self__, "current_location_id", current_location_id)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_reserved_ip_range is not None:
            pulumi.set(__self__, "effective_reserved_ip_range", effective_reserved_ip_range)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if maintenance_policy is not None:
            pulumi.set(__self__, "maintenance_policy", maintenance_policy)
        if maintenance_schedules is not None:
            pulumi.set(__self__, "maintenance_schedules", maintenance_schedules)
        if maintenance_version is not None:
            pulumi.set(__self__, "maintenance_version", maintenance_version)
        if memory_size_gb is not None:
            pulumi.set(__self__, "memory_size_gb", memory_size_gb)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if persistence_config is not None:
            pulumi.set(__self__, "persistence_config", persistence_config)
        if persistence_iam_identity is not None:
            pulumi.set(__self__, "persistence_iam_identity", persistence_iam_identity)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if read_endpoint is not None:
            pulumi.set(__self__, "read_endpoint", read_endpoint)
        if read_endpoint_port is not None:
            pulumi.set(__self__, "read_endpoint_port", read_endpoint_port)
        if read_replicas_mode is not None:
            pulumi.set(__self__, "read_replicas_mode", read_replicas_mode)
        if redis_configs is not None:
            pulumi.set(__self__, "redis_configs", redis_configs)
        if redis_version is not None:
            pulumi.set(__self__, "redis_version", redis_version)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_count is not None:
            pulumi.set(__self__, "replica_count", replica_count)
        if reserved_ip_range is not None:
            pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)
        if secondary_ip_range is not None:
            pulumi.set(__self__, "secondary_ip_range", secondary_ip_range)
        if server_ca_certs is not None:
            pulumi.set(__self__, "server_ca_certs", server_ca_certs)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if transit_encryption_mode is not None:
            pulumi.set(__self__, "transit_encryption_mode", transit_encryption_mode)

    @_builtins.property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Only applicable to STANDARD_HA tier which protects the instance
        against zonal failures by provisioning it across two zones.
        If provided, it must be a different zone from the one provided in
        [locationId].
        """
        return pulumi.get(self, "alternative_location_id")

    @alternative_location_id.setter
    def alternative_location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alternative_location_id", value)

    @_builtins.property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the
        instance. If set to "true" AUTH is enabled on the instance.
        Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @auth_enabled.setter
    def auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auth_enabled", value)

    @_builtins.property
    @pulumi.getter(name="authString")
    def auth_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        """
        return pulumi.get(self, "auth_string")

    @auth_string.setter
    def auth_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auth_string", value)

    @_builtins.property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full name of the Google Compute Engine network to which the
        instance is connected. If left unspecified, the default network
        will be used.
        """
        return pulumi.get(self, "authorized_network")

    @authorized_network.setter
    def authorized_network(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorized_network", value)

    @_builtins.property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection mode of the Redis instance.
        Default value is `DIRECT_PEERING`.
        Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`.
        """
        return pulumi.get(self, "connect_mode")

    @connect_mode.setter
    def connect_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_mode", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="currentLocationId")
    def current_location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current zone where the Redis endpoint is placed.
        For Basic Tier instances, this will always be the same as the
        [locationId] provided by the user at creation time. For Standard Tier
        instances, this can be either [locationId] or [alternativeLocationId]
        and can change after a failover event.
        """
        return pulumi.get(self, "current_location_id")

    @current_location_id.setter
    def current_location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "current_location_id", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
        instance. If this is provided, CMEK is enabled.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="effectiveReservedIpRange")
    def effective_reserved_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "effective_reserved_ip_range")

    @effective_reserved_ip_range.setter
    def effective_reserved_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_reserved_ip_range", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Hostname or IP address of the exposed Redis endpoint used by clients
        to connect to the service.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The zone where the instance will be provisioned. If not provided,
        the service will choose a zone for the instance. For STANDARD_HA tier,
        instances will be created across two zones for protection against
        zonal failures. If [alternativeLocationId] is also provided, it must
        be different from [locationId].
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location_id", value)

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]:
        """
        Maintenance policy for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @maintenance_policy.setter
    def maintenance_policy(self, value: Optional[pulumi.Input['InstanceMaintenancePolicyArgs']]):
        pulumi.set(self, "maintenance_policy", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @maintenance_schedules.setter
    def maintenance_schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceScheduleArgs']]]]):
        pulumi.set(self, "maintenance_schedules", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The self service update maintenance version.
        """
        return pulumi.get(self, "maintenance_version")

    @maintenance_version.setter
    def maintenance_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintenance_version", value)

    @_builtins.property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @memory_size_gb.setter
    def memory_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_size_gb", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]:
        """
        Output only. Info per node.
        Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> Optional[pulumi.Input['InstancePersistenceConfigArgs']]:
        """
        Persistence configuration for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @persistence_config.setter
    def persistence_config(self, value: Optional[pulumi.Input['InstancePersistenceConfigArgs']]):
        pulumi.set(self, "persistence_config", value)

    @_builtins.property
    @pulumi.getter(name="persistenceIamIdentity")
    def persistence_iam_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Cloud IAM identity used by import / export operations
        to transfer data to/from Cloud Storage. Format is "serviceAccount:".
        The value may change over time for a given instance so should be
        checked before each import/export operation.
        """
        return pulumi.get(self, "persistence_iam_identity")

    @persistence_iam_identity.setter
    def persistence_iam_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "persistence_iam_identity", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number of the exposed Redis endpoint.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only.
        Targets all healthy replica nodes in instance. Replication is asynchronous and replica nodes
        will exhibit some lag behind the primary. Write requests must target 'host'.
        """
        return pulumi.get(self, "read_endpoint")

    @read_endpoint.setter
    def read_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="readEndpointPort")
    def read_endpoint_port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Output only. The port number of the exposed readonly redis endpoint. Standard tier only.
        Write requests should target 'port'.
        """
        return pulumi.get(self, "read_endpoint_port")

    @read_endpoint_port.setter
    def read_endpoint_port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "read_endpoint_port", value)

    @_builtins.property
    @pulumi.getter(name="readReplicasMode")
    def read_replicas_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Read replica mode. Can only be specified when trying to create the instance.
        If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
        - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
        instance cannot scale up or down the number of replicas.
        - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
        can scale up and down the number of replicas.
        Possible values are: `READ_REPLICAS_DISABLED`, `READ_REPLICAS_ENABLED`.
        """
        return pulumi.get(self, "read_replicas_mode")

    @read_replicas_mode.setter
    def read_replicas_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "read_replicas_mode", value)

    @_builtins.property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Redis configuration parameters, according to http://redis.io/topics/config.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        """
        return pulumi.get(self, "redis_configs")

    @redis_configs.setter
    def redis_configs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "redis_configs", value)

    @_builtins.property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Redis software. If not provided, latest supported
        version will be used. Please check the API documentation linked
        at the top for the latest valid values.
        """
        return pulumi.get(self, "redis_version")

    @redis_version.setter
    def redis_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_version", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Redis region of the instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Optional. The number of replica nodes. The valid range for the Standard Tier with
        read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
        for a Standard Tier instance, the only valid value is 1 and the default is 1.
        The valid value for basic tier is 0 and the default is also 0.
        """
        return pulumi.get(self, "replica_count")

    @replica_count.setter
    def replica_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_count", value)

    @_builtins.property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "reserved_ip_range")

    @reserved_ip_range.setter
    def reserved_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reserved_ip_range", value)

    @_builtins.property
    @pulumi.getter(name="secondaryIpRange")
    def secondary_ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Additional IP range for node placement. Required when enabling read replicas on
        an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
        "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
        range associated with the private service access connection, or "auto".
        """
        return pulumi.get(self, "secondary_ip_range")

    @secondary_ip_range.setter
    def secondary_ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_ip_range", value)

    @_builtins.property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]]]:
        """
        List of server CA certificates for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "server_ca_certs")

    @server_ca_certs.setter
    def server_ca_certs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceServerCaCertArgs']]]]):
        pulumi.set(self, "server_ca_certs", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service tier of the instance. Must be one of these values:
        - BASIC: standalone instance
        - STANDARD_HA: highly available primary/replica instances
        Default value is `BASIC`.
        Possible values are: `BASIC`, `STANDARD_HA`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
        - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
        Default value is `DISABLED`.
        Possible values are: `SERVER_AUTHENTICATION`, `DISABLED`.
        """
        return pulumi.get(self, "transit_encryption_mode")

    @transit_encryption_mode.setter
    def transit_encryption_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "transit_encryption_mode", value)


@pulumi.type_token("gcp:redis/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replicas_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Google Cloud Redis instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/redis/)

        ## Example Usage

        ### Redis Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache = gcp.redis.Instance("cache",
            name="memory-cache",
            memory_size_gb=1)
        ```
        ### Redis Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            name="ha-memory-cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            reserved_ip_range="192.168.0.0/29",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "TUESDAY",
                    "start_time": {
                        "hours": 0,
                        "minutes": 30,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            })
        ```
        ### Redis Instance Full With Persistence Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache_persis = gcp.redis.Instance("cache-persis",
            name="ha-memory-cache-persis",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            persistence_config={
                "persistence_mode": "RDB",
                "rdb_snapshot_period": "TWELVE_HOURS",
            })
        ```
        ### Redis Instance Private Service

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.Network("redis-network", name="redis-test-network")
        service_range = gcp.compute.GlobalAddress("service_range",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=redis_network.id)
        private_service_connection = gcp.servicenetworking.Connection("private_service_connection",
            network=redis_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        cache = gcp.redis.Instance("cache",
            name="private-cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            connect_mode="PRIVATE_SERVICE_ACCESS",
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            opts = pulumi.ResourceOptions(depends_on=[private_service_connection]))
        ```
        ### Redis Instance Mrr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            name="mrr-memory-cache",
            tier="STANDARD_HA",
            memory_size_gb=5,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_6_X",
            display_name="Terraform Test Instance",
            reserved_ip_range="192.168.0.0/28",
            replica_count=5,
            read_replicas_mode="READ_REPLICAS_ENABLED",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            })
        ```
        ### Redis Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_keyring = gcp.kms.KeyRing("redis_keyring",
            name="redis-keyring",
            location="us-central1")
        redis_key = gcp.kms.CryptoKey("redis_key",
            name="redis-key",
            key_ring=redis_keyring.id)
        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            name="cmek-memory-cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_6_X",
            display_name="Terraform Test Instance",
            reserved_ip_range="192.168.0.0/29",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            customer_managed_key=redis_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[_builtins.bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[_builtins.str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[_builtins.str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[_builtins.str] customer_managed_key: Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
               instance. If this is provided, CMEK is enabled.
        :param pulumi.Input[_builtins.str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: The self service update maintenance version.
        :param pulumi.Input[_builtins.int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']] persistence_config: Persistence configuration for an instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance.
               If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
               - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
               instance cannot scale up or down the number of replicas.
               - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
               can scale up and down the number of replicas.
               Possible values are: `READ_REPLICAS_DISABLED`, `READ_REPLICAS_ENABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[_builtins.str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[_builtins.str] region: The name of the Redis region of the instance.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with
               read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
               for a Standard Tier instance, the only valid value is 1 and the default is 1.
               The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[_builtins.str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[_builtins.str] secondary_ip_range: Optional. Additional IP range for node placement. Required when enabling read replicas on
               an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
               "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
               range associated with the private service access connection, or "auto".
        :param pulumi.Input[_builtins.str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are: `BASIC`, `STANDARD_HA`.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are: `SERVER_AUTHENTICATION`, `DISABLED`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Redis instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/memorystore/docs/redis/)

        ## Example Usage

        ### Redis Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache = gcp.redis.Instance("cache",
            name="memory-cache",
            memory_size_gb=1)
        ```
        ### Redis Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            name="ha-memory-cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            reserved_ip_range="192.168.0.0/29",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            maintenance_policy={
                "weekly_maintenance_windows": [{
                    "day": "TUESDAY",
                    "start_time": {
                        "hours": 0,
                        "minutes": 30,
                        "seconds": 0,
                        "nanos": 0,
                    },
                }],
            })
        ```
        ### Redis Instance Full With Persistence Config

        ```python
        import pulumi
        import pulumi_gcp as gcp

        cache_persis = gcp.redis.Instance("cache-persis",
            name="ha-memory-cache-persis",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            persistence_config={
                "persistence_mode": "RDB",
                "rdb_snapshot_period": "TWELVE_HOURS",
            })
        ```
        ### Redis Instance Private Service

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.Network("redis-network", name="redis-test-network")
        service_range = gcp.compute.GlobalAddress("service_range",
            name="address",
            purpose="VPC_PEERING",
            address_type="INTERNAL",
            prefix_length=16,
            network=redis_network.id)
        private_service_connection = gcp.servicenetworking.Connection("private_service_connection",
            network=redis_network.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[service_range.name])
        cache = gcp.redis.Instance("cache",
            name="private-cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            connect_mode="PRIVATE_SERVICE_ACCESS",
            redis_version="REDIS_4_0",
            display_name="Test Instance",
            opts = pulumi.ResourceOptions(depends_on=[private_service_connection]))
        ```
        ### Redis Instance Mrr

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            name="mrr-memory-cache",
            tier="STANDARD_HA",
            memory_size_gb=5,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_6_X",
            display_name="Terraform Test Instance",
            reserved_ip_range="192.168.0.0/28",
            replica_count=5,
            read_replicas_mode="READ_REPLICAS_ENABLED",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            })
        ```
        ### Redis Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        redis_keyring = gcp.kms.KeyRing("redis_keyring",
            name="redis-keyring",
            location="us-central1")
        redis_key = gcp.kms.CryptoKey("redis_key",
            name="redis-key",
            key_ring=redis_keyring.id)
        # This example assumes this network already exists.
        # The API creates a tenant network per network authorized for a
        # Redis instance and that network is not deleted when the user-created
        # network (authorized_network) is deleted, so this prevents issues
        # with tenant network quota.
        # If this network hasn't been created and you are using this example in your
        # config, add an additional network resource or change
        # this from "data"to "resource"
        redis_network = gcp.compute.get_network(name="redis-test-network")
        cache = gcp.redis.Instance("cache",
            name="cmek-memory-cache",
            tier="STANDARD_HA",
            memory_size_gb=1,
            location_id="us-central1-a",
            alternative_location_id="us-central1-f",
            authorized_network=redis_network.id,
            redis_version="REDIS_6_X",
            display_name="Terraform Test Instance",
            reserved_ip_range="192.168.0.0/29",
            labels={
                "my_key": "my_val",
                "other_key": "other_val",
            },
            customer_managed_key=redis_key.id)
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:redis/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:redis/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alternative_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
                 maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
                 memory_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 read_replicas_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 redis_version: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_count: Optional[pulumi.Input[_builtins.int]] = None,
                 reserved_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["alternative_location_id"] = alternative_location_id
            __props__.__dict__["auth_enabled"] = auth_enabled
            __props__.__dict__["authorized_network"] = authorized_network
            __props__.__dict__["connect_mode"] = connect_mode
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location_id"] = location_id
            __props__.__dict__["maintenance_policy"] = maintenance_policy
            __props__.__dict__["maintenance_version"] = maintenance_version
            if memory_size_gb is None and not opts.urn:
                raise TypeError("Missing required property 'memory_size_gb'")
            __props__.__dict__["memory_size_gb"] = memory_size_gb
            __props__.__dict__["name"] = name
            __props__.__dict__["persistence_config"] = persistence_config
            __props__.__dict__["project"] = project
            __props__.__dict__["read_replicas_mode"] = read_replicas_mode
            __props__.__dict__["redis_configs"] = redis_configs
            __props__.__dict__["redis_version"] = redis_version
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_count"] = replica_count
            __props__.__dict__["reserved_ip_range"] = reserved_ip_range
            __props__.__dict__["secondary_ip_range"] = secondary_ip_range
            __props__.__dict__["tier"] = tier
            __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
            __props__.__dict__["auth_string"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["current_location_id"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["effective_reserved_ip_range"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["maintenance_schedules"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["persistence_iam_identity"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["read_endpoint"] = None
            __props__.__dict__["read_endpoint_port"] = None
            __props__.__dict__["server_ca_certs"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authString", "effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:redis/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alternative_location_id: Optional[pulumi.Input[_builtins.str]] = None,
            auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auth_string: Optional[pulumi.Input[_builtins.str]] = None,
            authorized_network: Optional[pulumi.Input[_builtins.str]] = None,
            connect_mode: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            current_location_id: Optional[pulumi.Input[_builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_reserved_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location_id: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_policy: Optional[pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']]] = None,
            maintenance_schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceMaintenanceScheduleArgs', 'InstanceMaintenanceScheduleArgsDict']]]]] = None,
            maintenance_version: Optional[pulumi.Input[_builtins.str]] = None,
            memory_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeArgs', 'InstanceNodeArgsDict']]]]] = None,
            persistence_config: Optional[pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']]] = None,
            persistence_iam_identity: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            read_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            read_endpoint_port: Optional[pulumi.Input[_builtins.int]] = None,
            read_replicas_mode: Optional[pulumi.Input[_builtins.str]] = None,
            redis_configs: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            redis_version: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replica_count: Optional[pulumi.Input[_builtins.int]] = None,
            reserved_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_ip_range: Optional[pulumi.Input[_builtins.str]] = None,
            server_ca_certs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerCaCertArgs', 'InstanceServerCaCertArgsDict']]]]] = None,
            tier: Optional[pulumi.Input[_builtins.str]] = None,
            transit_encryption_mode: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alternative_location_id: Only applicable to STANDARD_HA tier which protects the instance
               against zonal failures by provisioning it across two zones.
               If provided, it must be a different zone from the one provided in
               [locationId].
        :param pulumi.Input[_builtins.bool] auth_enabled: Optional. Indicates whether OSS Redis AUTH is enabled for the
               instance. If set to "true" AUTH is enabled on the instance.
               Default value is "false" meaning AUTH is disabled.
        :param pulumi.Input[_builtins.str] auth_string: AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        :param pulumi.Input[_builtins.str] authorized_network: The full name of the Google Compute Engine network to which the
               instance is connected. If left unspecified, the default network
               will be used.
        :param pulumi.Input[_builtins.str] connect_mode: The connection mode of the Redis instance.
               Default value is `DIRECT_PEERING`.
               Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`.
        :param pulumi.Input[_builtins.str] create_time: (Output)
               The time when the certificate was created.
        :param pulumi.Input[_builtins.str] current_location_id: The current zone where the Redis endpoint is placed.
               For Basic Tier instances, this will always be the same as the
               [locationId] provided by the user at creation time. For Standard Tier
               instances, this can be either [locationId] or [alternativeLocationId]
               and can change after a failover event.
        :param pulumi.Input[_builtins.str] customer_managed_key: Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
               instance. If this is provided, CMEK is enabled.
        :param pulumi.Input[_builtins.str] display_name: An arbitrary and optional user-provided name for the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] effective_reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[_builtins.str] host: Hostname or IP address of the exposed Redis endpoint used by clients
               to connect to the service.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location_id: The zone where the instance will be provisioned. If not provided,
               the service will choose a zone for the instance. For STANDARD_HA tier,
               instances will be created across two zones for protection against
               zonal failures. If [alternativeLocationId] is also provided, it must
               be different from [locationId].
        :param pulumi.Input[Union['InstanceMaintenancePolicyArgs', 'InstanceMaintenancePolicyArgsDict']] maintenance_policy: Maintenance policy for an instance.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceMaintenanceScheduleArgs', 'InstanceMaintenanceScheduleArgsDict']]]] maintenance_schedules: Upcoming maintenance schedule.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] maintenance_version: The self service update maintenance version.
        :param pulumi.Input[_builtins.int] memory_size_gb: Redis memory size in GiB.
        :param pulumi.Input[_builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeArgs', 'InstanceNodeArgsDict']]]] nodes: Output only. Info per node.
               Structure is documented below.
        :param pulumi.Input[Union['InstancePersistenceConfigArgs', 'InstancePersistenceConfigArgsDict']] persistence_config: Persistence configuration for an instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] persistence_iam_identity: Output only. Cloud IAM identity used by import / export operations
               to transfer data to/from Cloud Storage. Format is "serviceAccount:".
               The value may change over time for a given instance so should be
               checked before each import/export operation.
        :param pulumi.Input[_builtins.int] port: The port number of the exposed Redis endpoint.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] read_endpoint: Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only.
               Targets all healthy replica nodes in instance. Replication is asynchronous and replica nodes
               will exhibit some lag behind the primary. Write requests must target 'host'.
        :param pulumi.Input[_builtins.int] read_endpoint_port: Output only. The port number of the exposed readonly redis endpoint. Standard tier only.
               Write requests should target 'port'.
        :param pulumi.Input[_builtins.str] read_replicas_mode: Optional. Read replica mode. Can only be specified when trying to create the instance.
               If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
               - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
               instance cannot scale up or down the number of replicas.
               - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
               can scale up and down the number of replicas.
               Possible values are: `READ_REPLICAS_DISABLED`, `READ_REPLICAS_ENABLED`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] redis_configs: Redis configuration parameters, according to http://redis.io/topics/config.
               Please check Memorystore documentation for the list of supported parameters:
               https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        :param pulumi.Input[_builtins.str] redis_version: The version of Redis software. If not provided, latest supported
               version will be used. Please check the API documentation linked
               at the top for the latest valid values.
        :param pulumi.Input[_builtins.str] region: The name of the Redis region of the instance.
        :param pulumi.Input[_builtins.int] replica_count: Optional. The number of replica nodes. The valid range for the Standard Tier with
               read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
               for a Standard Tier instance, the only valid value is 1 and the default is 1.
               The valid value for basic tier is 0 and the default is also 0.
        :param pulumi.Input[_builtins.str] reserved_ip_range: The CIDR range of internal addresses that are reserved for this
               instance. If not provided, the service will choose an unused /29
               block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
               unique and non-overlapping with existing subnets in an authorized
               network.
        :param pulumi.Input[_builtins.str] secondary_ip_range: Optional. Additional IP range for node placement. Required when enabling read replicas on
               an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
               "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
               range associated with the private service access connection, or "auto".
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceServerCaCertArgs', 'InstanceServerCaCertArgsDict']]]] server_ca_certs: List of server CA certificates for the instance.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] tier: The service tier of the instance. Must be one of these values:
               - BASIC: standalone instance
               - STANDARD_HA: highly available primary/replica instances
               Default value is `BASIC`.
               Possible values are: `BASIC`, `STANDARD_HA`.
        :param pulumi.Input[_builtins.str] transit_encryption_mode: The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
               - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
               Default value is `DISABLED`.
               Possible values are: `SERVER_AUTHENTICATION`, `DISABLED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["alternative_location_id"] = alternative_location_id
        __props__.__dict__["auth_enabled"] = auth_enabled
        __props__.__dict__["auth_string"] = auth_string
        __props__.__dict__["authorized_network"] = authorized_network
        __props__.__dict__["connect_mode"] = connect_mode
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["current_location_id"] = current_location_id
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["effective_reserved_ip_range"] = effective_reserved_ip_range
        __props__.__dict__["host"] = host
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location_id"] = location_id
        __props__.__dict__["maintenance_policy"] = maintenance_policy
        __props__.__dict__["maintenance_schedules"] = maintenance_schedules
        __props__.__dict__["maintenance_version"] = maintenance_version
        __props__.__dict__["memory_size_gb"] = memory_size_gb
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["persistence_config"] = persistence_config
        __props__.__dict__["persistence_iam_identity"] = persistence_iam_identity
        __props__.__dict__["port"] = port
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["read_endpoint"] = read_endpoint
        __props__.__dict__["read_endpoint_port"] = read_endpoint_port
        __props__.__dict__["read_replicas_mode"] = read_replicas_mode
        __props__.__dict__["redis_configs"] = redis_configs
        __props__.__dict__["redis_version"] = redis_version
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_count"] = replica_count
        __props__.__dict__["reserved_ip_range"] = reserved_ip_range
        __props__.__dict__["secondary_ip_range"] = secondary_ip_range
        __props__.__dict__["server_ca_certs"] = server_ca_certs
        __props__.__dict__["tier"] = tier
        __props__.__dict__["transit_encryption_mode"] = transit_encryption_mode
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="alternativeLocationId")
    def alternative_location_id(self) -> pulumi.Output[_builtins.str]:
        """
        Only applicable to STANDARD_HA tier which protects the instance
        against zonal failures by provisioning it across two zones.
        If provided, it must be a different zone from the one provided in
        [locationId].
        """
        return pulumi.get(self, "alternative_location_id")

    @_builtins.property
    @pulumi.getter(name="authEnabled")
    def auth_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Optional. Indicates whether OSS Redis AUTH is enabled for the
        instance. If set to "true" AUTH is enabled on the instance.
        Default value is "false" meaning AUTH is disabled.
        """
        return pulumi.get(self, "auth_enabled")

    @_builtins.property
    @pulumi.getter(name="authString")
    def auth_string(self) -> pulumi.Output[_builtins.str]:
        """
        AUTH String set on the instance. This field will only be populated if auth_enabled is true.
        """
        return pulumi.get(self, "auth_string")

    @_builtins.property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[_builtins.str]:
        """
        The full name of the Google Compute Engine network to which the
        instance is connected. If left unspecified, the default network
        will be used.
        """
        return pulumi.get(self, "authorized_network")

    @_builtins.property
    @pulumi.getter(name="connectMode")
    def connect_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The connection mode of the Redis instance.
        Default value is `DIRECT_PEERING`.
        Possible values are: `DIRECT_PEERING`, `PRIVATE_SERVICE_ACCESS`.
        """
        return pulumi.get(self, "connect_mode")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        The time when the certificate was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="currentLocationId")
    def current_location_id(self) -> pulumi.Output[_builtins.str]:
        """
        The current zone where the Redis endpoint is placed.
        For Basic Tier instances, this will always be the same as the
        [locationId] provided by the user at creation time. For Standard Tier
        instances, this can be either [locationId] or [alternativeLocationId]
        and can change after a failover event.
        """
        return pulumi.get(self, "current_location_id")

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The KMS key reference that you want to use to encrypt the data at rest for this Redis
        instance. If this is provided, CMEK is enabled.
        """
        return pulumi.get(self, "customer_managed_key")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        An arbitrary and optional user-provided name for the instance.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="effectiveReservedIpRange")
    def effective_reserved_ip_range(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "effective_reserved_ip_range")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        Hostname or IP address of the exposed Redis endpoint used by clients
        to connect to the service.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[_builtins.str]:
        """
        The zone where the instance will be provisioned. If not provided,
        the service will choose a zone for the instance. For STANDARD_HA tier,
        instances will be created across two zones for protection against
        zonal failures. If [alternativeLocationId] is also provided, it must
        be different from [locationId].
        """
        return pulumi.get(self, "location_id")

    @_builtins.property
    @pulumi.getter(name="maintenancePolicy")
    def maintenance_policy(self) -> pulumi.Output[Optional['outputs.InstanceMaintenancePolicy']]:
        """
        Maintenance policy for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_policy")

    @_builtins.property
    @pulumi.getter(name="maintenanceSchedules")
    def maintenance_schedules(self) -> pulumi.Output[Sequence['outputs.InstanceMaintenanceSchedule']]:
        """
        Upcoming maintenance schedule.
        Structure is documented below.
        """
        return pulumi.get(self, "maintenance_schedules")

    @_builtins.property
    @pulumi.getter(name="maintenanceVersion")
    def maintenance_version(self) -> pulumi.Output[_builtins.str]:
        """
        The self service update maintenance version.
        """
        return pulumi.get(self, "maintenance_version")

    @_builtins.property
    @pulumi.getter(name="memorySizeGb")
    def memory_size_gb(self) -> pulumi.Output[_builtins.int]:
        """
        Redis memory size in GiB.
        """
        return pulumi.get(self, "memory_size_gb")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.InstanceNode']]:
        """
        Output only. Info per node.
        Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter(name="persistenceConfig")
    def persistence_config(self) -> pulumi.Output['outputs.InstancePersistenceConfig']:
        """
        Persistence configuration for an instance.
        Structure is documented below.
        """
        return pulumi.get(self, "persistence_config")

    @_builtins.property
    @pulumi.getter(name="persistenceIamIdentity")
    def persistence_iam_identity(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Cloud IAM identity used by import / export operations
        to transfer data to/from Cloud Storage. Format is "serviceAccount:".
        The value may change over time for a given instance so should be
        checked before each import/export operation.
        """
        return pulumi.get(self, "persistence_iam_identity")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port number of the exposed Redis endpoint.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="readEndpoint")
    def read_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Hostname or IP address of the exposed readonly Redis endpoint. Standard tier only.
        Targets all healthy replica nodes in instance. Replication is asynchronous and replica nodes
        will exhibit some lag behind the primary. Write requests must target 'host'.
        """
        return pulumi.get(self, "read_endpoint")

    @_builtins.property
    @pulumi.getter(name="readEndpointPort")
    def read_endpoint_port(self) -> pulumi.Output[_builtins.int]:
        """
        Output only. The port number of the exposed readonly redis endpoint. Standard tier only.
        Write requests should target 'port'.
        """
        return pulumi.get(self, "read_endpoint_port")

    @_builtins.property
    @pulumi.getter(name="readReplicasMode")
    def read_replicas_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Read replica mode. Can only be specified when trying to create the instance.
        If not set, Memorystore Redis backend will default to READ_REPLICAS_DISABLED.
        - READ_REPLICAS_DISABLED: If disabled, read endpoint will not be provided and the
        instance cannot scale up or down the number of replicas.
        - READ_REPLICAS_ENABLED: If enabled, read endpoint will be provided and the instance
        can scale up and down the number of replicas.
        Possible values are: `READ_REPLICAS_DISABLED`, `READ_REPLICAS_ENABLED`.
        """
        return pulumi.get(self, "read_replicas_mode")

    @_builtins.property
    @pulumi.getter(name="redisConfigs")
    def redis_configs(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Redis configuration parameters, according to http://redis.io/topics/config.
        Please check Memorystore documentation for the list of supported parameters:
        https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs
        """
        return pulumi.get(self, "redis_configs")

    @_builtins.property
    @pulumi.getter(name="redisVersion")
    def redis_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of Redis software. If not provided, latest supported
        version will be used. Please check the API documentation linked
        at the top for the latest valid values.
        """
        return pulumi.get(self, "redis_version")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Redis region of the instance.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> pulumi.Output[_builtins.int]:
        """
        Optional. The number of replica nodes. The valid range for the Standard Tier with
        read replicas enabled is [1-5] and defaults to 2. If read replicas are not enabled
        for a Standard Tier instance, the only valid value is 1 and the default is 1.
        The valid value for basic tier is 0 and the default is also 0.
        """
        return pulumi.get(self, "replica_count")

    @_builtins.property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR range of internal addresses that are reserved for this
        instance. If not provided, the service will choose an unused /29
        block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
        unique and non-overlapping with existing subnets in an authorized
        network.
        """
        return pulumi.get(self, "reserved_ip_range")

    @_builtins.property
    @pulumi.getter(name="secondaryIpRange")
    def secondary_ip_range(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Additional IP range for node placement. Required when enabling read replicas on
        an existing instance. For DIRECT_PEERING mode value must be a CIDR range of size /28, or
        "auto". For PRIVATE_SERVICE_ACCESS mode value must be the name of an allocated address
        range associated with the private service access connection, or "auto".
        """
        return pulumi.get(self, "secondary_ip_range")

    @_builtins.property
    @pulumi.getter(name="serverCaCerts")
    def server_ca_certs(self) -> pulumi.Output[Sequence['outputs.InstanceServerCaCert']]:
        """
        List of server CA certificates for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "server_ca_certs")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The service tier of the instance. Must be one of these values:
        - BASIC: standalone instance
        - STANDARD_HA: highly available primary/replica instances
        Default value is `BASIC`.
        Possible values are: `BASIC`, `STANDARD_HA`.
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="transitEncryptionMode")
    def transit_encryption_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
        - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentication
        Default value is `DISABLED`.
        Possible values are: `SERVER_AUTHENTICATION`, `DISABLED`.
        """
        return pulumi.get(self, "transit_encryption_mode")

