# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatabaseIamPolicyResult',
    'AwaitableGetDatabaseIamPolicyResult',
    'get_database_iam_policy',
    'get_database_iam_policy_output',
]

@pulumi.output_type
class GetDatabaseIamPolicyResult:
    """
    A collection of values returned by getDatabaseIamPolicy.
    """
    def __init__(__self__, database=None, etag=None, id=None, instance=None, policy_data=None, project=None):
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance and not isinstance(instance, str):
            raise TypeError("Expected argument 'instance' to be a str")
        pulumi.set(__self__, "instance", instance)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def database(self) -> _builtins.str:
        return pulumi.get(self, "database")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> _builtins.str:
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetDatabaseIamPolicyResult(GetDatabaseIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseIamPolicyResult(
            database=self.database,
            etag=self.etag,
            id=self.id,
            instance=self.instance,
            policy_data=self.policy_data,
            project=self.project)


def get_database_iam_policy(database: Optional[_builtins.str] = None,
                            instance: Optional[_builtins.str] = None,
                            project: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Spanner database.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.spanner.get_database_iam_policy(project=database["project"],
        database=database["name"],
        instance=database["instance"])
    ```


    :param _builtins.str database: The name of the Spanner database.
    :param _builtins.str instance: The name of the Spanner instance the database belongs to.
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['database'] = database
    __args__['instance'] = instance
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:spanner/getDatabaseIamPolicy:getDatabaseIamPolicy', __args__, opts=opts, typ=GetDatabaseIamPolicyResult).value

    return AwaitableGetDatabaseIamPolicyResult(
        database=pulumi.get(__ret__, 'database'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        instance=pulumi.get(__ret__, 'instance'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_database_iam_policy_output(database: Optional[pulumi.Input[_builtins.str]] = None,
                                   instance: Optional[pulumi.Input[_builtins.str]] = None,
                                   project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Spanner database.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    foo = gcp.spanner.get_database_iam_policy(project=database["project"],
        database=database["name"],
        instance=database["instance"])
    ```


    :param _builtins.str database: The name of the Spanner database.
    :param _builtins.str instance: The name of the Spanner instance the database belongs to.
    :param _builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['database'] = database
    __args__['instance'] = instance
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:spanner/getDatabaseIamPolicy:getDatabaseIamPolicy', __args__, opts=opts, typ=GetDatabaseIamPolicyResult)
    return __ret__.apply(lambda __response__: GetDatabaseIamPolicyResult(
        database=pulumi.get(__response__, 'database'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        instance=pulumi.get(__response__, 'instance'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
