# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 autoclass: Optional[pulumi.Input['BucketAutoclassArgs']] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]]] = None,
                 custom_placement_config: Optional[pulumi.Input['BucketCustomPlacementConfigArgs']] = None,
                 default_event_based_hold: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_object_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['BucketEncryptionArgs']] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 hierarchical_namespace: Optional[pulumi.Input['BucketHierarchicalNamespaceArgs']] = None,
                 ip_filter: Optional[pulumi.Input['BucketIpFilterArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 logging: Optional[pulumi.Input['BucketLoggingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access_prevention: Optional[pulumi.Input[_builtins.str]] = None,
                 requester_pays: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_policy: Optional[pulumi.Input['BucketRetentionPolicyArgs']] = None,
                 rpo: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_policy: Optional[pulumi.Input['BucketSoftDeletePolicyArgs']] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 uniform_bucket_level_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input[_builtins.str] location: The [GCS location](https://cloud.google.com/storage/docs/bucket-locations).
               
               - - -
        :param pulumi.Input['BucketAutoclassArgs'] autoclass: The bucket's [Autoclass](https://cloud.google.com/storage/docs/autoclass) configuration.  Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]] cors: The bucket's [Cross-Origin Resource Sharing (CORS)](https://www.w3.org/TR/cors/) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input['BucketCustomPlacementConfigArgs'] custom_placement_config: The bucket's custom location configuration, which specifies the individual regions that comprise a dual-region bucket. If the bucket is designated a single or multi-region, the parameters are empty. Structure is documented below.
        :param pulumi.Input[_builtins.bool] default_event_based_hold: Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
        :param pulumi.Input[_builtins.bool] enable_object_retention: Enables [object retention](https://cloud.google.com/storage/docs/object-lock) on a storage bucket.
        :param pulumi.Input['BucketEncryptionArgs'] encryption: The bucket's encryption configuration. Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_destroy: When deleting a bucket, this
               boolean option will delete all contained objects. If you try to delete a
               bucket that contains objects, the provider will fail that run.
        :param pulumi.Input['BucketHierarchicalNamespaceArgs'] hierarchical_namespace: The bucket's hierarchical namespace policy, which defines the bucket capability to handle folders in logical structure. Structure is documented below. To use this configuration, `uniform_bucket_level_access` must be enabled on bucket.
        :param pulumi.Input['BucketIpFilterArgs'] ip_filter: The bucket IP filtering configuration. Specifies the network sources that can access the bucket, as well as its underlying objects. Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the bucket.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: The bucket's [Lifecycle Rules](https://cloud.google.com/storage/docs/lifecycle#configuration) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input['BucketLoggingArgs'] logging: The bucket's [Access & Storage Logs](https://cloud.google.com/storage/docs/access-logs) configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] public_access_prevention: Prevents public access to a bucket. Acceptable values are "inherited" or "enforced". If "inherited", the bucket uses [public access prevention](https://cloud.google.com/storage/docs/public-access-prevention) only if the bucket is subject to the public access prevention organization policy constraint. Defaults to "inherited".
        :param pulumi.Input[_builtins.bool] requester_pays: Enables [Requester Pays](https://cloud.google.com/storage/docs/requester-pays) on a storage bucket.
        :param pulumi.Input['BucketRetentionPolicyArgs'] retention_policy: Configuration of the bucket's data retention policy for how long objects in the bucket should be retained. Structure is documented below.
        :param pulumi.Input[_builtins.str] rpo: The recovery point objective for cross-region replication of the bucket. Applicable only for dual and multi-region buckets. `"DEFAULT"` sets default replication. `"ASYNC_TURBO"` value enables turbo replication, valid for dual-region buckets only. See [Turbo Replication](https://cloud.google.com/storage/docs/managing-turbo-replication) for more information. If rpo is not specified at bucket creation, it defaults to `"DEFAULT"` for dual and multi-region buckets. **NOTE** If used with single-region bucket, It will throw an error.
        :param pulumi.Input['BucketSoftDeletePolicyArgs'] soft_delete_policy: The bucket's soft delete policy, which defines the period of time that soft-deleted objects will be retained, and cannot
               be permanently deleted. If it is not provided, by default Google Cloud Storage sets this to default soft delete policy
        :param pulumi.Input[_builtins.str] storage_class: The [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of the new bucket. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        :param pulumi.Input[_builtins.bool] uniform_bucket_level_access: Enables [Uniform bucket-level access](https://cloud.google.com/storage/docs/uniform-bucket-level-access) access to a bucket.
        :param pulumi.Input['BucketVersioningArgs'] versioning: The bucket's [Versioning](https://cloud.google.com/storage/docs/object-versioning) configuration.  Structure is documented below.
        :param pulumi.Input['BucketWebsiteArgs'] website: Configuration if the bucket acts as a website. Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if autoclass is not None:
            pulumi.set(__self__, "autoclass", autoclass)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if custom_placement_config is not None:
            pulumi.set(__self__, "custom_placement_config", custom_placement_config)
        if default_event_based_hold is not None:
            pulumi.set(__self__, "default_event_based_hold", default_event_based_hold)
        if enable_object_retention is not None:
            pulumi.set(__self__, "enable_object_retention", enable_object_retention)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if hierarchical_namespace is not None:
            pulumi.set(__self__, "hierarchical_namespace", hierarchical_namespace)
        if ip_filter is not None:
            pulumi.set(__self__, "ip_filter", ip_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if public_access_prevention is not None:
            pulumi.set(__self__, "public_access_prevention", public_access_prevention)
        if requester_pays is not None:
            pulumi.set(__self__, "requester_pays", requester_pays)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if soft_delete_policy is not None:
            pulumi.set(__self__, "soft_delete_policy", soft_delete_policy)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if uniform_bucket_level_access is not None:
            pulumi.set(__self__, "uniform_bucket_level_access", uniform_bucket_level_access)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The [GCS location](https://cloud.google.com/storage/docs/bucket-locations).

        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def autoclass(self) -> Optional[pulumi.Input['BucketAutoclassArgs']]:
        """
        The bucket's [Autoclass](https://cloud.google.com/storage/docs/autoclass) configuration.  Structure is documented below.
        """
        return pulumi.get(self, "autoclass")

    @autoclass.setter
    def autoclass(self, value: Optional[pulumi.Input['BucketAutoclassArgs']]):
        pulumi.set(self, "autoclass", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]]]:
        """
        The bucket's [Cross-Origin Resource Sharing (CORS)](https://www.w3.org/TR/cors/) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]]]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="customPlacementConfig")
    def custom_placement_config(self) -> Optional[pulumi.Input['BucketCustomPlacementConfigArgs']]:
        """
        The bucket's custom location configuration, which specifies the individual regions that comprise a dual-region bucket. If the bucket is designated a single or multi-region, the parameters are empty. Structure is documented below.
        """
        return pulumi.get(self, "custom_placement_config")

    @custom_placement_config.setter
    def custom_placement_config(self, value: Optional[pulumi.Input['BucketCustomPlacementConfigArgs']]):
        pulumi.set(self, "custom_placement_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultEventBasedHold")
    def default_event_based_hold(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
        """
        return pulumi.get(self, "default_event_based_hold")

    @default_event_based_hold.setter
    def default_event_based_hold(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_event_based_hold", value)

    @_builtins.property
    @pulumi.getter(name="enableObjectRetention")
    def enable_object_retention(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [object retention](https://cloud.google.com/storage/docs/object-lock) on a storage bucket.
        """
        return pulumi.get(self, "enable_object_retention")

    @enable_object_retention.setter
    def enable_object_retention(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_object_retention", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['BucketEncryptionArgs']]:
        """
        The bucket's encryption configuration. Structure is documented below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['BucketEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When deleting a bucket, this
        boolean option will delete all contained objects. If you try to delete a
        bucket that contains objects, the provider will fail that run.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="hierarchicalNamespace")
    def hierarchical_namespace(self) -> Optional[pulumi.Input['BucketHierarchicalNamespaceArgs']]:
        """
        The bucket's hierarchical namespace policy, which defines the bucket capability to handle folders in logical structure. Structure is documented below. To use this configuration, `uniform_bucket_level_access` must be enabled on bucket.
        """
        return pulumi.get(self, "hierarchical_namespace")

    @hierarchical_namespace.setter
    def hierarchical_namespace(self, value: Optional[pulumi.Input['BucketHierarchicalNamespaceArgs']]):
        pulumi.set(self, "hierarchical_namespace", value)

    @_builtins.property
    @pulumi.getter(name="ipFilter")
    def ip_filter(self) -> Optional[pulumi.Input['BucketIpFilterArgs']]:
        """
        The bucket IP filtering configuration. Specifies the network sources that can access the bucket, as well as its underlying objects. Structure is documented below.
        """
        return pulumi.get(self, "ip_filter")

    @ip_filter.setter
    def ip_filter(self, value: Optional[pulumi.Input['BucketIpFilterArgs']]):
        pulumi.set(self, "ip_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the bucket.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        The bucket's [Lifecycle Rules](https://cloud.google.com/storage/docs/lifecycle#configuration) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['BucketLoggingArgs']]:
        """
        The bucket's [Access & Storage Logs](https://cloud.google.com/storage/docs/access-logs) configuration. Structure is documented below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BucketLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="publicAccessPrevention")
    def public_access_prevention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prevents public access to a bucket. Acceptable values are "inherited" or "enforced". If "inherited", the bucket uses [public access prevention](https://cloud.google.com/storage/docs/public-access-prevention) only if the bucket is subject to the public access prevention organization policy constraint. Defaults to "inherited".
        """
        return pulumi.get(self, "public_access_prevention")

    @public_access_prevention.setter
    def public_access_prevention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_access_prevention", value)

    @_builtins.property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [Requester Pays](https://cloud.google.com/storage/docs/requester-pays) on a storage bucket.
        """
        return pulumi.get(self, "requester_pays")

    @requester_pays.setter
    def requester_pays(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requester_pays", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['BucketRetentionPolicyArgs']]:
        """
        Configuration of the bucket's data retention policy for how long objects in the bucket should be retained. Structure is documented below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['BucketRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recovery point objective for cross-region replication of the bucket. Applicable only for dual and multi-region buckets. `"DEFAULT"` sets default replication. `"ASYNC_TURBO"` value enables turbo replication, valid for dual-region buckets only. See [Turbo Replication](https://cloud.google.com/storage/docs/managing-turbo-replication) for more information. If rpo is not specified at bucket creation, it defaults to `"DEFAULT"` for dual and multi-region buckets. **NOTE** If used with single-region bucket, It will throw an error.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rpo", value)

    @_builtins.property
    @pulumi.getter(name="softDeletePolicy")
    def soft_delete_policy(self) -> Optional[pulumi.Input['BucketSoftDeletePolicyArgs']]:
        """
        The bucket's soft delete policy, which defines the period of time that soft-deleted objects will be retained, and cannot
        be permanently deleted. If it is not provided, by default Google Cloud Storage sets this to default soft delete policy
        """
        return pulumi.get(self, "soft_delete_policy")

    @soft_delete_policy.setter
    def soft_delete_policy(self, value: Optional[pulumi.Input['BucketSoftDeletePolicyArgs']]):
        pulumi.set(self, "soft_delete_policy", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of the new bucket. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter(name="uniformBucketLevelAccess")
    def uniform_bucket_level_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [Uniform bucket-level access](https://cloud.google.com/storage/docs/uniform-bucket-level-access) access to a bucket.
        """
        return pulumi.get(self, "uniform_bucket_level_access")

    @uniform_bucket_level_access.setter
    def uniform_bucket_level_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "uniform_bucket_level_access", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningArgs']]:
        """
        The bucket's [Versioning](https://cloud.google.com/storage/docs/object-versioning) configuration.  Structure is documented below.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        Configuration if the bucket acts as a website. Structure is documented below.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


@pulumi.input_type
class _BucketState:
    def __init__(__self__, *,
                 autoclass: Optional[pulumi.Input['BucketAutoclassArgs']] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]]] = None,
                 custom_placement_config: Optional[pulumi.Input['BucketCustomPlacementConfigArgs']] = None,
                 default_event_based_hold: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_object_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['BucketEncryptionArgs']] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 hierarchical_namespace: Optional[pulumi.Input['BucketHierarchicalNamespaceArgs']] = None,
                 ip_filter: Optional[pulumi.Input['BucketIpFilterArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input['BucketLoggingArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 project_number: Optional[pulumi.Input[_builtins.int]] = None,
                 public_access_prevention: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 requester_pays: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_policy: Optional[pulumi.Input['BucketRetentionPolicyArgs']] = None,
                 rpo: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_policy: Optional[pulumi.Input['BucketSoftDeletePolicyArgs']] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 uniform_bucket_level_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 versioning: Optional[pulumi.Input['BucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        Input properties used for looking up and filtering Bucket resources.
        :param pulumi.Input['BucketAutoclassArgs'] autoclass: The bucket's [Autoclass](https://cloud.google.com/storage/docs/autoclass) configuration.  Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]] cors: The bucket's [Cross-Origin Resource Sharing (CORS)](https://www.w3.org/TR/cors/) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input['BucketCustomPlacementConfigArgs'] custom_placement_config: The bucket's custom location configuration, which specifies the individual regions that comprise a dual-region bucket. If the bucket is designated a single or multi-region, the parameters are empty. Structure is documented below.
        :param pulumi.Input[_builtins.bool] default_event_based_hold: Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
        :param pulumi.Input[_builtins.bool] enable_object_retention: Enables [object retention](https://cloud.google.com/storage/docs/object-lock) on a storage bucket.
        :param pulumi.Input['BucketEncryptionArgs'] encryption: The bucket's encryption configuration. Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_destroy: When deleting a bucket, this
               boolean option will delete all contained objects. If you try to delete a
               bucket that contains objects, the provider will fail that run.
        :param pulumi.Input['BucketHierarchicalNamespaceArgs'] hierarchical_namespace: The bucket's hierarchical namespace policy, which defines the bucket capability to handle folders in logical structure. Structure is documented below. To use this configuration, `uniform_bucket_level_access` must be enabled on bucket.
        :param pulumi.Input['BucketIpFilterArgs'] ip_filter: The bucket IP filtering configuration. Specifies the network sources that can access the bucket, as well as its underlying objects. Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the bucket.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: The bucket's [Lifecycle Rules](https://cloud.google.com/storage/docs/lifecycle#configuration) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The [GCS location](https://cloud.google.com/storage/docs/bucket-locations).
               
               - - -
        :param pulumi.Input['BucketLoggingArgs'] logging: The bucket's [Access & Storage Logs](https://cloud.google.com/storage/docs/access-logs) configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.int] project_number: The project number of the project in which the resource belongs.
        :param pulumi.Input[_builtins.str] public_access_prevention: Prevents public access to a bucket. Acceptable values are "inherited" or "enforced". If "inherited", the bucket uses [public access prevention](https://cloud.google.com/storage/docs/public-access-prevention) only if the bucket is subject to the public access prevention organization policy constraint. Defaults to "inherited".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] requester_pays: Enables [Requester Pays](https://cloud.google.com/storage/docs/requester-pays) on a storage bucket.
        :param pulumi.Input['BucketRetentionPolicyArgs'] retention_policy: Configuration of the bucket's data retention policy for how long objects in the bucket should be retained. Structure is documented below.
        :param pulumi.Input[_builtins.str] rpo: The recovery point objective for cross-region replication of the bucket. Applicable only for dual and multi-region buckets. `"DEFAULT"` sets default replication. `"ASYNC_TURBO"` value enables turbo replication, valid for dual-region buckets only. See [Turbo Replication](https://cloud.google.com/storage/docs/managing-turbo-replication) for more information. If rpo is not specified at bucket creation, it defaults to `"DEFAULT"` for dual and multi-region buckets. **NOTE** If used with single-region bucket, It will throw an error.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['BucketSoftDeletePolicyArgs'] soft_delete_policy: The bucket's soft delete policy, which defines the period of time that soft-deleted objects will be retained, and cannot
               be permanently deleted. If it is not provided, by default Google Cloud Storage sets this to default soft delete policy
        :param pulumi.Input[_builtins.str] storage_class: The [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of the new bucket. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        :param pulumi.Input[_builtins.str] time_created: The creation time of the bucket in RFC 3339 format.
        :param pulumi.Input[_builtins.bool] uniform_bucket_level_access: Enables [Uniform bucket-level access](https://cloud.google.com/storage/docs/uniform-bucket-level-access) access to a bucket.
        :param pulumi.Input[_builtins.str] updated: The time at which the bucket's metadata or IAM policy was last updated, in RFC 3339 format.
        :param pulumi.Input[_builtins.str] url: The base URL of the bucket, in the format `gs://<bucket-name>`.
        :param pulumi.Input['BucketVersioningArgs'] versioning: The bucket's [Versioning](https://cloud.google.com/storage/docs/object-versioning) configuration.  Structure is documented below.
        :param pulumi.Input['BucketWebsiteArgs'] website: Configuration if the bucket acts as a website. Structure is documented below.
        """
        if autoclass is not None:
            pulumi.set(__self__, "autoclass", autoclass)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if custom_placement_config is not None:
            pulumi.set(__self__, "custom_placement_config", custom_placement_config)
        if default_event_based_hold is not None:
            pulumi.set(__self__, "default_event_based_hold", default_event_based_hold)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_object_retention is not None:
            pulumi.set(__self__, "enable_object_retention", enable_object_retention)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if hierarchical_namespace is not None:
            pulumi.set(__self__, "hierarchical_namespace", hierarchical_namespace)
        if ip_filter is not None:
            pulumi.set(__self__, "ip_filter", ip_filter)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if public_access_prevention is not None:
            pulumi.set(__self__, "public_access_prevention", public_access_prevention)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if requester_pays is not None:
            pulumi.set(__self__, "requester_pays", requester_pays)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if rpo is not None:
            pulumi.set(__self__, "rpo", rpo)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if soft_delete_policy is not None:
            pulumi.set(__self__, "soft_delete_policy", soft_delete_policy)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if uniform_bucket_level_access is not None:
            pulumi.set(__self__, "uniform_bucket_level_access", uniform_bucket_level_access)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @_builtins.property
    @pulumi.getter
    def autoclass(self) -> Optional[pulumi.Input['BucketAutoclassArgs']]:
        """
        The bucket's [Autoclass](https://cloud.google.com/storage/docs/autoclass) configuration.  Structure is documented below.
        """
        return pulumi.get(self, "autoclass")

    @autoclass.setter
    def autoclass(self, value: Optional[pulumi.Input['BucketAutoclassArgs']]):
        pulumi.set(self, "autoclass", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]]]:
        """
        The bucket's [Cross-Origin Resource Sharing (CORS)](https://www.w3.org/TR/cors/) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorArgs']]]]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="customPlacementConfig")
    def custom_placement_config(self) -> Optional[pulumi.Input['BucketCustomPlacementConfigArgs']]:
        """
        The bucket's custom location configuration, which specifies the individual regions that comprise a dual-region bucket. If the bucket is designated a single or multi-region, the parameters are empty. Structure is documented below.
        """
        return pulumi.get(self, "custom_placement_config")

    @custom_placement_config.setter
    def custom_placement_config(self, value: Optional[pulumi.Input['BucketCustomPlacementConfigArgs']]):
        pulumi.set(self, "custom_placement_config", value)

    @_builtins.property
    @pulumi.getter(name="defaultEventBasedHold")
    def default_event_based_hold(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
        """
        return pulumi.get(self, "default_event_based_hold")

    @default_event_based_hold.setter
    def default_event_based_hold(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "default_event_based_hold", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="enableObjectRetention")
    def enable_object_retention(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [object retention](https://cloud.google.com/storage/docs/object-lock) on a storage bucket.
        """
        return pulumi.get(self, "enable_object_retention")

    @enable_object_retention.setter
    def enable_object_retention(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_object_retention", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['BucketEncryptionArgs']]:
        """
        The bucket's encryption configuration. Structure is documented below.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['BucketEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When deleting a bucket, this
        boolean option will delete all contained objects. If you try to delete a
        bucket that contains objects, the provider will fail that run.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="hierarchicalNamespace")
    def hierarchical_namespace(self) -> Optional[pulumi.Input['BucketHierarchicalNamespaceArgs']]:
        """
        The bucket's hierarchical namespace policy, which defines the bucket capability to handle folders in logical structure. Structure is documented below. To use this configuration, `uniform_bucket_level_access` must be enabled on bucket.
        """
        return pulumi.get(self, "hierarchical_namespace")

    @hierarchical_namespace.setter
    def hierarchical_namespace(self, value: Optional[pulumi.Input['BucketHierarchicalNamespaceArgs']]):
        pulumi.set(self, "hierarchical_namespace", value)

    @_builtins.property
    @pulumi.getter(name="ipFilter")
    def ip_filter(self) -> Optional[pulumi.Input['BucketIpFilterArgs']]:
        """
        The bucket IP filtering configuration. Specifies the network sources that can access the bucket, as well as its underlying objects. Structure is documented below.
        """
        return pulumi.get(self, "ip_filter")

    @ip_filter.setter
    def ip_filter(self, value: Optional[pulumi.Input['BucketIpFilterArgs']]):
        pulumi.set(self, "ip_filter", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the bucket.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        The bucket's [Lifecycle Rules](https://cloud.google.com/storage/docs/lifecycle#configuration) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [GCS location](https://cloud.google.com/storage/docs/bucket-locations).

        - - -
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['BucketLoggingArgs']]:
        """
        The bucket's [Access & Storage Logs](https://cloud.google.com/storage/docs/access-logs) configuration. Structure is documented below.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['BucketLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The project number of the project in which the resource belongs.
        """
        return pulumi.get(self, "project_number")

    @project_number.setter
    def project_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "project_number", value)

    @_builtins.property
    @pulumi.getter(name="publicAccessPrevention")
    def public_access_prevention(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Prevents public access to a bucket. Acceptable values are "inherited" or "enforced". If "inherited", the bucket uses [public access prevention](https://cloud.google.com/storage/docs/public-access-prevention) only if the bucket is subject to the public access prevention organization policy constraint. Defaults to "inherited".
        """
        return pulumi.get(self, "public_access_prevention")

    @public_access_prevention.setter
    def public_access_prevention(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_access_prevention", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [Requester Pays](https://cloud.google.com/storage/docs/requester-pays) on a storage bucket.
        """
        return pulumi.get(self, "requester_pays")

    @requester_pays.setter
    def requester_pays(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requester_pays", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input['BucketRetentionPolicyArgs']]:
        """
        Configuration of the bucket's data retention policy for how long objects in the bucket should be retained. Structure is documented below.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input['BucketRetentionPolicyArgs']]):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recovery point objective for cross-region replication of the bucket. Applicable only for dual and multi-region buckets. `"DEFAULT"` sets default replication. `"ASYNC_TURBO"` value enables turbo replication, valid for dual-region buckets only. See [Turbo Replication](https://cloud.google.com/storage/docs/managing-turbo-replication) for more information. If rpo is not specified at bucket creation, it defaults to `"DEFAULT"` for dual and multi-region buckets. **NOTE** If used with single-region bucket, It will throw an error.
        """
        return pulumi.get(self, "rpo")

    @rpo.setter
    def rpo(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rpo", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="softDeletePolicy")
    def soft_delete_policy(self) -> Optional[pulumi.Input['BucketSoftDeletePolicyArgs']]:
        """
        The bucket's soft delete policy, which defines the period of time that soft-deleted objects will be retained, and cannot
        be permanently deleted. If it is not provided, by default Google Cloud Storage sets this to default soft delete policy
        """
        return pulumi.get(self, "soft_delete_policy")

    @soft_delete_policy.setter
    def soft_delete_policy(self, value: Optional[pulumi.Input['BucketSoftDeletePolicyArgs']]):
        pulumi.set(self, "soft_delete_policy", value)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of the new bucket. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_class", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="uniformBucketLevelAccess")
    def uniform_bucket_level_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables [Uniform bucket-level access](https://cloud.google.com/storage/docs/uniform-bucket-level-access) access to a bucket.
        """
        return pulumi.get(self, "uniform_bucket_level_access")

    @uniform_bucket_level_access.setter
    def uniform_bucket_level_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "uniform_bucket_level_access", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time at which the bucket's metadata or IAM policy was last updated, in RFC 3339 format.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base URL of the bucket, in the format `gs://<bucket-name>`.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['BucketVersioningArgs']]:
        """
        The bucket's [Versioning](https://cloud.google.com/storage/docs/object-versioning) configuration.  Structure is documented below.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['BucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @_builtins.property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        Configuration if the bucket acts as a website. Structure is documented below.
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


@pulumi.type_token("gcp:storage/bucket:Bucket")
class Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoclass: Optional[pulumi.Input[Union['BucketAutoclassArgs', 'BucketAutoclassArgsDict']]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorArgs', 'BucketCorArgsDict']]]]] = None,
                 custom_placement_config: Optional[pulumi.Input[Union['BucketCustomPlacementConfigArgs', 'BucketCustomPlacementConfigArgsDict']]] = None,
                 default_event_based_hold: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_object_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['BucketEncryptionArgs', 'BucketEncryptionArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 hierarchical_namespace: Optional[pulumi.Input[Union['BucketHierarchicalNamespaceArgs', 'BucketHierarchicalNamespaceArgsDict']]] = None,
                 ip_filter: Optional[pulumi.Input[Union['BucketIpFilterArgs', 'BucketIpFilterArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access_prevention: Optional[pulumi.Input[_builtins.str]] = None,
                 requester_pays: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_policy: Optional[pulumi.Input[Union['BucketRetentionPolicyArgs', 'BucketRetentionPolicyArgsDict']]] = None,
                 rpo: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_policy: Optional[pulumi.Input[Union['BucketSoftDeletePolicyArgs', 'BucketSoftDeletePolicyArgsDict']]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 uniform_bucket_level_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None,
                 __props__=None):
        """
        Creates a new bucket in Google cloud storage service (GCS).
        Once a bucket has been created, its location can't be changed.

        For more information see
        [the official documentation](https://cloud.google.com/storage/docs/overview)
        and
        [API](https://cloud.google.com/storage/docs/json_api/v1/buckets).

        **Note**: If the project id is not set on the resource or in the provider block it will be dynamically
        determined which will require enabling the compute api.

        ## Example Usage

        ### Creating A Private Bucket In Standard Storage, In The EU Region. Bucket Configured As Static Website And CORS Configurations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        static_site = gcp.storage.Bucket("static-site",
            name="image-store.com",
            location="EU",
            force_destroy=True,
            uniform_bucket_level_access=True,
            website={
                "main_page_suffix": "index.html",
                "not_found_page": "404.html",
            },
            cors=[{
                "origins": ["http://image-store.com"],
                "methods": [
                    "GET",
                    "HEAD",
                    "PUT",
                    "POST",
                    "DELETE",
                ],
                "response_headers": ["*"],
                "max_age_seconds": 3600,
            }])
        ```

        ### Life Cycle Settings For Storage Bucket Objects

        ```python
        import pulumi
        import pulumi_gcp as gcp

        auto_expire = gcp.storage.Bucket("auto-expire",
            name="auto-expiring-bucket",
            location="US",
            force_destroy=True,
            lifecycle_rules=[
                {
                    "condition": {
                        "age": 3,
                    },
                    "action": {
                        "type": "Delete",
                    },
                },
                {
                    "condition": {
                        "age": 1,
                    },
                    "action": {
                        "type": "AbortIncompleteMultipartUpload",
                    },
                },
            ])
        ```

        ### Life Cycle Settings For Storage Bucket Objects With `Send_age_if_zero` Disabled
        When creating a life cycle condition that does not also include an `age` field, a default `age` of 0 will be set. Set the `send_age_if_zero` flag to `false` to prevent this and avoid any potentially unintended interactions.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        no_age_enabled = gcp.storage.Bucket("no-age-enabled",
            name="no-age-enabled-bucket",
            location="US",
            force_destroy=True,
            lifecycle_rules=[{
                "action": {
                    "type": "Delete",
                },
                "condition": {
                    "days_since_noncurrent_time": 3,
                    "send_age_if_zero": False,
                },
            }])
        ```

        ### Enabling Public Access Prevention

        ```python
        import pulumi
        import pulumi_gcp as gcp

        no_public_access = gcp.storage.Bucket("no-public-access",
            name="no-public-access-bucket",
            location="US",
            force_destroy=True,
            public_access_prevention="enforced")
        ```

        ### Enabling Hierarchical Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hns_enabled = gcp.storage.Bucket("hns-enabled",
            name="hns-enabled-bucket",
            location="US",
            force_destroy=True,
            hierarchical_namespace={
                "enabled": True,
            })
        ```

        ## Import

        Storage buckets can be imported using the `name` or  `project/name`. If the project is not

        passed to the import command it will be inferred from the provider block or environment variables.

        If it cannot be inferred it will be queried from the Compute API (this will fail if the API is

        not enabled).

        * `{{project_id}}/{{bucket}}`

        * `{{bucket}}`

        When using the `pulumi import` command, Storage buckets can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/bucket:Bucket default {{bucket}}
        ```

        ```sh
        $ pulumi import gcp:storage/bucket:Bucket default {{project_id}}/{{bucket}}
        ```

        `false` in state. If you've set it to `true` in config, run `pulumi up` to

        update the value set in state. If you delete this resource before updating the

        value, objects in the bucket will not be destroyed.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAutoclassArgs', 'BucketAutoclassArgsDict']] autoclass: The bucket's [Autoclass](https://cloud.google.com/storage/docs/autoclass) configuration.  Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketCorArgs', 'BucketCorArgsDict']]]] cors: The bucket's [Cross-Origin Resource Sharing (CORS)](https://www.w3.org/TR/cors/) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input[Union['BucketCustomPlacementConfigArgs', 'BucketCustomPlacementConfigArgsDict']] custom_placement_config: The bucket's custom location configuration, which specifies the individual regions that comprise a dual-region bucket. If the bucket is designated a single or multi-region, the parameters are empty. Structure is documented below.
        :param pulumi.Input[_builtins.bool] default_event_based_hold: Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
        :param pulumi.Input[_builtins.bool] enable_object_retention: Enables [object retention](https://cloud.google.com/storage/docs/object-lock) on a storage bucket.
        :param pulumi.Input[Union['BucketEncryptionArgs', 'BucketEncryptionArgsDict']] encryption: The bucket's encryption configuration. Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_destroy: When deleting a bucket, this
               boolean option will delete all contained objects. If you try to delete a
               bucket that contains objects, the provider will fail that run.
        :param pulumi.Input[Union['BucketHierarchicalNamespaceArgs', 'BucketHierarchicalNamespaceArgsDict']] hierarchical_namespace: The bucket's hierarchical namespace policy, which defines the bucket capability to handle folders in logical structure. Structure is documented below. To use this configuration, `uniform_bucket_level_access` must be enabled on bucket.
        :param pulumi.Input[Union['BucketIpFilterArgs', 'BucketIpFilterArgsDict']] ip_filter: The bucket IP filtering configuration. Specifies the network sources that can access the bucket, as well as its underlying objects. Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]] lifecycle_rules: The bucket's [Lifecycle Rules](https://cloud.google.com/storage/docs/lifecycle#configuration) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The [GCS location](https://cloud.google.com/storage/docs/bucket-locations).
               
               - - -
        :param pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']] logging: The bucket's [Access & Storage Logs](https://cloud.google.com/storage/docs/access-logs) configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] public_access_prevention: Prevents public access to a bucket. Acceptable values are "inherited" or "enforced". If "inherited", the bucket uses [public access prevention](https://cloud.google.com/storage/docs/public-access-prevention) only if the bucket is subject to the public access prevention organization policy constraint. Defaults to "inherited".
        :param pulumi.Input[_builtins.bool] requester_pays: Enables [Requester Pays](https://cloud.google.com/storage/docs/requester-pays) on a storage bucket.
        :param pulumi.Input[Union['BucketRetentionPolicyArgs', 'BucketRetentionPolicyArgsDict']] retention_policy: Configuration of the bucket's data retention policy for how long objects in the bucket should be retained. Structure is documented below.
        :param pulumi.Input[_builtins.str] rpo: The recovery point objective for cross-region replication of the bucket. Applicable only for dual and multi-region buckets. `"DEFAULT"` sets default replication. `"ASYNC_TURBO"` value enables turbo replication, valid for dual-region buckets only. See [Turbo Replication](https://cloud.google.com/storage/docs/managing-turbo-replication) for more information. If rpo is not specified at bucket creation, it defaults to `"DEFAULT"` for dual and multi-region buckets. **NOTE** If used with single-region bucket, It will throw an error.
        :param pulumi.Input[Union['BucketSoftDeletePolicyArgs', 'BucketSoftDeletePolicyArgsDict']] soft_delete_policy: The bucket's soft delete policy, which defines the period of time that soft-deleted objects will be retained, and cannot
               be permanently deleted. If it is not provided, by default Google Cloud Storage sets this to default soft delete policy
        :param pulumi.Input[_builtins.str] storage_class: The [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of the new bucket. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        :param pulumi.Input[_builtins.bool] uniform_bucket_level_access: Enables [Uniform bucket-level access](https://cloud.google.com/storage/docs/uniform-bucket-level-access) access to a bucket.
        :param pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']] versioning: The bucket's [Versioning](https://cloud.google.com/storage/docs/object-versioning) configuration.  Structure is documented below.
        :param pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']] website: Configuration if the bucket acts as a website. Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new bucket in Google cloud storage service (GCS).
        Once a bucket has been created, its location can't be changed.

        For more information see
        [the official documentation](https://cloud.google.com/storage/docs/overview)
        and
        [API](https://cloud.google.com/storage/docs/json_api/v1/buckets).

        **Note**: If the project id is not set on the resource or in the provider block it will be dynamically
        determined which will require enabling the compute api.

        ## Example Usage

        ### Creating A Private Bucket In Standard Storage, In The EU Region. Bucket Configured As Static Website And CORS Configurations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        static_site = gcp.storage.Bucket("static-site",
            name="image-store.com",
            location="EU",
            force_destroy=True,
            uniform_bucket_level_access=True,
            website={
                "main_page_suffix": "index.html",
                "not_found_page": "404.html",
            },
            cors=[{
                "origins": ["http://image-store.com"],
                "methods": [
                    "GET",
                    "HEAD",
                    "PUT",
                    "POST",
                    "DELETE",
                ],
                "response_headers": ["*"],
                "max_age_seconds": 3600,
            }])
        ```

        ### Life Cycle Settings For Storage Bucket Objects

        ```python
        import pulumi
        import pulumi_gcp as gcp

        auto_expire = gcp.storage.Bucket("auto-expire",
            name="auto-expiring-bucket",
            location="US",
            force_destroy=True,
            lifecycle_rules=[
                {
                    "condition": {
                        "age": 3,
                    },
                    "action": {
                        "type": "Delete",
                    },
                },
                {
                    "condition": {
                        "age": 1,
                    },
                    "action": {
                        "type": "AbortIncompleteMultipartUpload",
                    },
                },
            ])
        ```

        ### Life Cycle Settings For Storage Bucket Objects With `Send_age_if_zero` Disabled
        When creating a life cycle condition that does not also include an `age` field, a default `age` of 0 will be set. Set the `send_age_if_zero` flag to `false` to prevent this and avoid any potentially unintended interactions.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        no_age_enabled = gcp.storage.Bucket("no-age-enabled",
            name="no-age-enabled-bucket",
            location="US",
            force_destroy=True,
            lifecycle_rules=[{
                "action": {
                    "type": "Delete",
                },
                "condition": {
                    "days_since_noncurrent_time": 3,
                    "send_age_if_zero": False,
                },
            }])
        ```

        ### Enabling Public Access Prevention

        ```python
        import pulumi
        import pulumi_gcp as gcp

        no_public_access = gcp.storage.Bucket("no-public-access",
            name="no-public-access-bucket",
            location="US",
            force_destroy=True,
            public_access_prevention="enforced")
        ```

        ### Enabling Hierarchical Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        hns_enabled = gcp.storage.Bucket("hns-enabled",
            name="hns-enabled-bucket",
            location="US",
            force_destroy=True,
            hierarchical_namespace={
                "enabled": True,
            })
        ```

        ## Import

        Storage buckets can be imported using the `name` or  `project/name`. If the project is not

        passed to the import command it will be inferred from the provider block or environment variables.

        If it cannot be inferred it will be queried from the Compute API (this will fail if the API is

        not enabled).

        * `{{project_id}}/{{bucket}}`

        * `{{bucket}}`

        When using the `pulumi import` command, Storage buckets can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/bucket:Bucket default {{bucket}}
        ```

        ```sh
        $ pulumi import gcp:storage/bucket:Bucket default {{project_id}}/{{bucket}}
        ```

        `false` in state. If you've set it to `true` in config, run `pulumi up` to

        update the value set in state. If you delete this resource before updating the

        value, objects in the bucket will not be destroyed.

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoclass: Optional[pulumi.Input[Union['BucketAutoclassArgs', 'BucketAutoclassArgsDict']]] = None,
                 cors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorArgs', 'BucketCorArgsDict']]]]] = None,
                 custom_placement_config: Optional[pulumi.Input[Union['BucketCustomPlacementConfigArgs', 'BucketCustomPlacementConfigArgsDict']]] = None,
                 default_event_based_hold: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_object_retention: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['BucketEncryptionArgs', 'BucketEncryptionArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 hierarchical_namespace: Optional[pulumi.Input[Union['BucketHierarchicalNamespaceArgs', 'BucketHierarchicalNamespaceArgsDict']]] = None,
                 ip_filter: Optional[pulumi.Input[Union['BucketIpFilterArgs', 'BucketIpFilterArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 public_access_prevention: Optional[pulumi.Input[_builtins.str]] = None,
                 requester_pays: Optional[pulumi.Input[_builtins.bool]] = None,
                 retention_policy: Optional[pulumi.Input[Union['BucketRetentionPolicyArgs', 'BucketRetentionPolicyArgsDict']]] = None,
                 rpo: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_policy: Optional[pulumi.Input[Union['BucketSoftDeletePolicyArgs', 'BucketSoftDeletePolicyArgsDict']]] = None,
                 storage_class: Optional[pulumi.Input[_builtins.str]] = None,
                 uniform_bucket_level_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["autoclass"] = autoclass
            __props__.__dict__["cors"] = cors
            __props__.__dict__["custom_placement_config"] = custom_placement_config
            __props__.__dict__["default_event_based_hold"] = default_event_based_hold
            __props__.__dict__["enable_object_retention"] = enable_object_retention
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["hierarchical_namespace"] = hierarchical_namespace
            __props__.__dict__["ip_filter"] = ip_filter
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging"] = logging
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["public_access_prevention"] = public_access_prevention
            __props__.__dict__["requester_pays"] = requester_pays
            __props__.__dict__["retention_policy"] = retention_policy
            __props__.__dict__["rpo"] = rpo
            __props__.__dict__["soft_delete_policy"] = soft_delete_policy
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["uniform_bucket_level_access"] = uniform_bucket_level_access
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["project_number"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["updated"] = None
            __props__.__dict__["url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Bucket, __self__).__init__(
            'gcp:storage/bucket:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoclass: Optional[pulumi.Input[Union['BucketAutoclassArgs', 'BucketAutoclassArgsDict']]] = None,
            cors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketCorArgs', 'BucketCorArgsDict']]]]] = None,
            custom_placement_config: Optional[pulumi.Input[Union['BucketCustomPlacementConfigArgs', 'BucketCustomPlacementConfigArgsDict']]] = None,
            default_event_based_hold: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_object_retention: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption: Optional[pulumi.Input[Union['BucketEncryptionArgs', 'BucketEncryptionArgsDict']]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            hierarchical_namespace: Optional[pulumi.Input[Union['BucketHierarchicalNamespaceArgs', 'BucketHierarchicalNamespaceArgsDict']]] = None,
            ip_filter: Optional[pulumi.Input[Union['BucketIpFilterArgs', 'BucketIpFilterArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logging: Optional[pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            project_number: Optional[pulumi.Input[_builtins.int]] = None,
            public_access_prevention: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            requester_pays: Optional[pulumi.Input[_builtins.bool]] = None,
            retention_policy: Optional[pulumi.Input[Union['BucketRetentionPolicyArgs', 'BucketRetentionPolicyArgsDict']]] = None,
            rpo: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            soft_delete_policy: Optional[pulumi.Input[Union['BucketSoftDeletePolicyArgs', 'BucketSoftDeletePolicyArgsDict']]] = None,
            storage_class: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            uniform_bucket_level_access: Optional[pulumi.Input[_builtins.bool]] = None,
            updated: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            versioning: Optional[pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']]] = None,
            website: Optional[pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']]] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['BucketAutoclassArgs', 'BucketAutoclassArgsDict']] autoclass: The bucket's [Autoclass](https://cloud.google.com/storage/docs/autoclass) configuration.  Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketCorArgs', 'BucketCorArgsDict']]]] cors: The bucket's [Cross-Origin Resource Sharing (CORS)](https://www.w3.org/TR/cors/) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input[Union['BucketCustomPlacementConfigArgs', 'BucketCustomPlacementConfigArgsDict']] custom_placement_config: The bucket's custom location configuration, which specifies the individual regions that comprise a dual-region bucket. If the bucket is designated a single or multi-region, the parameters are empty. Structure is documented below.
        :param pulumi.Input[_builtins.bool] default_event_based_hold: Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
        :param pulumi.Input[_builtins.bool] enable_object_retention: Enables [object retention](https://cloud.google.com/storage/docs/object-lock) on a storage bucket.
        :param pulumi.Input[Union['BucketEncryptionArgs', 'BucketEncryptionArgsDict']] encryption: The bucket's encryption configuration. Structure is documented below.
        :param pulumi.Input[_builtins.bool] force_destroy: When deleting a bucket, this
               boolean option will delete all contained objects. If you try to delete a
               bucket that contains objects, the provider will fail that run.
        :param pulumi.Input[Union['BucketHierarchicalNamespaceArgs', 'BucketHierarchicalNamespaceArgsDict']] hierarchical_namespace: The bucket's hierarchical namespace policy, which defines the bucket capability to handle folders in logical structure. Structure is documented below. To use this configuration, `uniform_bucket_level_access` must be enabled on bucket.
        :param pulumi.Input[Union['BucketIpFilterArgs', 'BucketIpFilterArgsDict']] ip_filter: The bucket IP filtering configuration. Specifies the network sources that can access the bucket, as well as its underlying objects. Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map of key/value label pairs to assign to the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BucketLifecycleRuleArgs', 'BucketLifecycleRuleArgsDict']]]] lifecycle_rules: The bucket's [Lifecycle Rules](https://cloud.google.com/storage/docs/lifecycle#configuration) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        :param pulumi.Input[_builtins.str] location: The [GCS location](https://cloud.google.com/storage/docs/bucket-locations).
               
               - - -
        :param pulumi.Input[Union['BucketLoggingArgs', 'BucketLoggingArgsDict']] logging: The bucket's [Access & Storage Logs](https://cloud.google.com/storage/docs/access-logs) configuration. Structure is documented below.
        :param pulumi.Input[_builtins.str] name: The name of the bucket.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[_builtins.int] project_number: The project number of the project in which the resource belongs.
        :param pulumi.Input[_builtins.str] public_access_prevention: Prevents public access to a bucket. Acceptable values are "inherited" or "enforced". If "inherited", the bucket uses [public access prevention](https://cloud.google.com/storage/docs/public-access-prevention) only if the bucket is subject to the public access prevention organization policy constraint. Defaults to "inherited".
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[_builtins.bool] requester_pays: Enables [Requester Pays](https://cloud.google.com/storage/docs/requester-pays) on a storage bucket.
        :param pulumi.Input[Union['BucketRetentionPolicyArgs', 'BucketRetentionPolicyArgsDict']] retention_policy: Configuration of the bucket's data retention policy for how long objects in the bucket should be retained. Structure is documented below.
        :param pulumi.Input[_builtins.str] rpo: The recovery point objective for cross-region replication of the bucket. Applicable only for dual and multi-region buckets. `"DEFAULT"` sets default replication. `"ASYNC_TURBO"` value enables turbo replication, valid for dual-region buckets only. See [Turbo Replication](https://cloud.google.com/storage/docs/managing-turbo-replication) for more information. If rpo is not specified at bucket creation, it defaults to `"DEFAULT"` for dual and multi-region buckets. **NOTE** If used with single-region bucket, It will throw an error.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['BucketSoftDeletePolicyArgs', 'BucketSoftDeletePolicyArgsDict']] soft_delete_policy: The bucket's soft delete policy, which defines the period of time that soft-deleted objects will be retained, and cannot
               be permanently deleted. If it is not provided, by default Google Cloud Storage sets this to default soft delete policy
        :param pulumi.Input[_builtins.str] storage_class: The [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of the new bucket. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        :param pulumi.Input[_builtins.str] time_created: The creation time of the bucket in RFC 3339 format.
        :param pulumi.Input[_builtins.bool] uniform_bucket_level_access: Enables [Uniform bucket-level access](https://cloud.google.com/storage/docs/uniform-bucket-level-access) access to a bucket.
        :param pulumi.Input[_builtins.str] updated: The time at which the bucket's metadata or IAM policy was last updated, in RFC 3339 format.
        :param pulumi.Input[_builtins.str] url: The base URL of the bucket, in the format `gs://<bucket-name>`.
        :param pulumi.Input[Union['BucketVersioningArgs', 'BucketVersioningArgsDict']] versioning: The bucket's [Versioning](https://cloud.google.com/storage/docs/object-versioning) configuration.  Structure is documented below.
        :param pulumi.Input[Union['BucketWebsiteArgs', 'BucketWebsiteArgsDict']] website: Configuration if the bucket acts as a website. Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketState.__new__(_BucketState)

        __props__.__dict__["autoclass"] = autoclass
        __props__.__dict__["cors"] = cors
        __props__.__dict__["custom_placement_config"] = custom_placement_config
        __props__.__dict__["default_event_based_hold"] = default_event_based_hold
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_object_retention"] = enable_object_retention
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["hierarchical_namespace"] = hierarchical_namespace
        __props__.__dict__["ip_filter"] = ip_filter
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["location"] = location
        __props__.__dict__["logging"] = logging
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["project_number"] = project_number
        __props__.__dict__["public_access_prevention"] = public_access_prevention
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["requester_pays"] = requester_pays
        __props__.__dict__["retention_policy"] = retention_policy
        __props__.__dict__["rpo"] = rpo
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["soft_delete_policy"] = soft_delete_policy
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["uniform_bucket_level_access"] = uniform_bucket_level_access
        __props__.__dict__["updated"] = updated
        __props__.__dict__["url"] = url
        __props__.__dict__["versioning"] = versioning
        __props__.__dict__["website"] = website
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def autoclass(self) -> pulumi.Output[Optional['outputs.BucketAutoclass']]:
        """
        The bucket's [Autoclass](https://cloud.google.com/storage/docs/autoclass) configuration.  Structure is documented below.
        """
        return pulumi.get(self, "autoclass")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional[Sequence['outputs.BucketCor']]]:
        """
        The bucket's [Cross-Origin Resource Sharing (CORS)](https://www.w3.org/TR/cors/) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="customPlacementConfig")
    def custom_placement_config(self) -> pulumi.Output[Optional['outputs.BucketCustomPlacementConfig']]:
        """
        The bucket's custom location configuration, which specifies the individual regions that comprise a dual-region bucket. If the bucket is designated a single or multi-region, the parameters are empty. Structure is documented below.
        """
        return pulumi.get(self, "custom_placement_config")

    @_builtins.property
    @pulumi.getter(name="defaultEventBasedHold")
    def default_event_based_hold(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
        """
        return pulumi.get(self, "default_event_based_hold")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="enableObjectRetention")
    def enable_object_retention(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables [object retention](https://cloud.google.com/storage/docs/object-lock) on a storage bucket.
        """
        return pulumi.get(self, "enable_object_retention")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.BucketEncryption']]:
        """
        The bucket's encryption configuration. Structure is documented below.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When deleting a bucket, this
        boolean option will delete all contained objects. If you try to delete a
        bucket that contains objects, the provider will fail that run.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="hierarchicalNamespace")
    def hierarchical_namespace(self) -> pulumi.Output[Optional['outputs.BucketHierarchicalNamespace']]:
        """
        The bucket's hierarchical namespace policy, which defines the bucket capability to handle folders in logical structure. Structure is documented below. To use this configuration, `uniform_bucket_level_access` must be enabled on bucket.
        """
        return pulumi.get(self, "hierarchical_namespace")

    @_builtins.property
    @pulumi.getter(name="ipFilter")
    def ip_filter(self) -> pulumi.Output[Optional['outputs.BucketIpFilter']]:
        """
        The bucket IP filtering configuration. Specifies the network sources that can access the bucket, as well as its underlying objects. Structure is documented below.
        """
        return pulumi.get(self, "ip_filter")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of key/value label pairs to assign to the bucket.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> pulumi.Output[Optional[Sequence['outputs.BucketLifecycleRule']]]:
        """
        The bucket's [Lifecycle Rules](https://cloud.google.com/storage/docs/lifecycle#configuration) configuration. Multiple blocks of this type are permitted. Structure is documented below.
        """
        return pulumi.get(self, "lifecycle_rules")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The [GCS location](https://cloud.google.com/storage/docs/bucket-locations).

        - - -
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.BucketLogging']]:
        """
        The bucket's [Access & Storage Logs](https://cloud.google.com/storage/docs/access-logs) configuration. Structure is documented below.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> pulumi.Output[_builtins.int]:
        """
        The project number of the project in which the resource belongs.
        """
        return pulumi.get(self, "project_number")

    @_builtins.property
    @pulumi.getter(name="publicAccessPrevention")
    def public_access_prevention(self) -> pulumi.Output[_builtins.str]:
        """
        Prevents public access to a bucket. Acceptable values are "inherited" or "enforced". If "inherited", the bucket uses [public access prevention](https://cloud.google.com/storage/docs/public-access-prevention) only if the bucket is subject to the public access prevention organization policy constraint. Defaults to "inherited".
        """
        return pulumi.get(self, "public_access_prevention")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="requesterPays")
    def requester_pays(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables [Requester Pays](https://cloud.google.com/storage/docs/requester-pays) on a storage bucket.
        """
        return pulumi.get(self, "requester_pays")

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output[Optional['outputs.BucketRetentionPolicy']]:
        """
        Configuration of the bucket's data retention policy for how long objects in the bucket should be retained. Structure is documented below.
        """
        return pulumi.get(self, "retention_policy")

    @_builtins.property
    @pulumi.getter
    def rpo(self) -> pulumi.Output[_builtins.str]:
        """
        The recovery point objective for cross-region replication of the bucket. Applicable only for dual and multi-region buckets. `"DEFAULT"` sets default replication. `"ASYNC_TURBO"` value enables turbo replication, valid for dual-region buckets only. See [Turbo Replication](https://cloud.google.com/storage/docs/managing-turbo-replication) for more information. If rpo is not specified at bucket creation, it defaults to `"DEFAULT"` for dual and multi-region buckets. **NOTE** If used with single-region bucket, It will throw an error.
        """
        return pulumi.get(self, "rpo")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="softDeletePolicy")
    def soft_delete_policy(self) -> pulumi.Output['outputs.BucketSoftDeletePolicy']:
        """
        The bucket's soft delete policy, which defines the period of time that soft-deleted objects will be retained, and cannot
        be permanently deleted. If it is not provided, by default Google Cloud Storage sets this to default soft delete policy
        """
        return pulumi.get(self, "soft_delete_policy")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of the new bucket. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the bucket in RFC 3339 format.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="uniformBucketLevelAccess")
    def uniform_bucket_level_access(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables [Uniform bucket-level access](https://cloud.google.com/storage/docs/uniform-bucket-level-access) access to a bucket.
        """
        return pulumi.get(self, "uniform_bucket_level_access")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.str]:
        """
        The time at which the bucket's metadata or IAM policy was last updated, in RFC 3339 format.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        The base URL of the bucket, in the format `gs://<bucket-name>`.
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter
    def versioning(self) -> pulumi.Output['outputs.BucketVersioning']:
        """
        The bucket's [Versioning](https://cloud.google.com/storage/docs/object-versioning) configuration.  Structure is documented below.
        """
        return pulumi.get(self, "versioning")

    @_builtins.property
    @pulumi.getter
    def website(self) -> pulumi.Output['outputs.BucketWebsite']:
        """
        Configuration if the bucket acts as a website. Structure is documented below.
        """
        return pulumi.get(self, "website")

