# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FolderArgs', 'Folder']

@pulumi.input_type
class FolderArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Folder resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket that contains the folder.
        :param pulumi.Input[_builtins.bool] force_destroy: If set to true, items within folder if any will be force destroyed.
        :param pulumi.Input[_builtins.str] name: The name of the folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`, `example@#/`, `a-b/d-f/`.
        """
        pulumi.set(__self__, "bucket", bucket)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the bucket that contains the folder.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, items within folder if any will be force destroyed.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the folder expressed as a path. Must include
        trailing '/'. For example, `example_dir/example_dir2/`, `example@#/`, `a-b/d-f/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FolderState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 metageneration: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 self_link: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Folder resources.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket that contains the folder.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which this folder was created.
        :param pulumi.Input[_builtins.bool] force_destroy: If set to true, items within folder if any will be force destroyed.
        :param pulumi.Input[_builtins.str] metageneration: The metadata generation of the folder.
        :param pulumi.Input[_builtins.str] name: The name of the folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`, `example@#/`, `a-b/d-f/`.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which this folder was most recently updated.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if metageneration is not None:
            pulumi.set(__self__, "metageneration", metageneration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the bucket that contains the folder.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which this folder was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, items within folder if any will be force destroyed.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter
    def metageneration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The metadata generation of the folder.
        """
        return pulumi.get(self, "metageneration")

    @metageneration.setter
    def metageneration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metageneration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the folder expressed as a path. Must include
        trailing '/'. For example, `example_dir/example_dir2/`, `example@#/`, `a-b/d-f/`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "self_link", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp at which this folder was most recently updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:storage/folder:Folder")
class Folder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Google Cloud Storage Folder.

        The Folder resource represents a folder in a Cloud Storage bucket with hierarchical namespace enabled

        To get more information about Folder, see:

        * [API documentation](https://cloud.google.com/storage/docs/json_api/v1/folders)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage/docs/folders-overview)

        ## Example Usage

        ### Storage Folder Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="my-bucket",
            location="EU",
            uniform_bucket_level_access=True,
            hierarchical_namespace={
                "enabled": True,
            })
        folder = gcp.storage.Folder("folder",
            bucket=bucket.name,
            name="parent-folder/")
        subfolder = gcp.storage.Folder("subfolder",
            bucket=bucket.name,
            name=folder.name.apply(lambda name: f"{name}subfolder/"))
        ```

        ## Import

        Folder can be imported using any of these accepted formats:

        * `{{bucket}}/folders/{{name}}`

        * `{{bucket}}/{{name}}`

        When using the `pulumi import` command, Folder can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/folder:Folder default {{bucket}}/folders/{{name}}
        ```

        ```sh
        $ pulumi import gcp:storage/folder:Folder default {{bucket}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket that contains the folder.
        :param pulumi.Input[_builtins.bool] force_destroy: If set to true, items within folder if any will be force destroyed.
        :param pulumi.Input[_builtins.str] name: The name of the folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`, `example@#/`, `a-b/d-f/`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FolderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Google Cloud Storage Folder.

        The Folder resource represents a folder in a Cloud Storage bucket with hierarchical namespace enabled

        To get more information about Folder, see:

        * [API documentation](https://cloud.google.com/storage/docs/json_api/v1/folders)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/storage/docs/folders-overview)

        ## Example Usage

        ### Storage Folder Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        bucket = gcp.storage.Bucket("bucket",
            name="my-bucket",
            location="EU",
            uniform_bucket_level_access=True,
            hierarchical_namespace={
                "enabled": True,
            })
        folder = gcp.storage.Folder("folder",
            bucket=bucket.name,
            name="parent-folder/")
        subfolder = gcp.storage.Folder("subfolder",
            bucket=bucket.name,
            name=folder.name.apply(lambda name: f"{name}subfolder/"))
        ```

        ## Import

        Folder can be imported using any of these accepted formats:

        * `{{bucket}}/folders/{{name}}`

        * `{{bucket}}/{{name}}`

        When using the `pulumi import` command, Folder can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:storage/folder:Folder default {{bucket}}/folders/{{name}}
        ```

        ```sh
        $ pulumi import gcp:storage/folder:Folder default {{bucket}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FolderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FolderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[_builtins.str]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FolderArgs.__new__(FolderArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["name"] = name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["metageneration"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["update_time"] = None
        super(Folder, __self__).__init__(
            'gcp:storage/folder:Folder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            metageneration: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            self_link: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'Folder':
        """
        Get an existing Folder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bucket: The name of the bucket that contains the folder.
        :param pulumi.Input[_builtins.str] create_time: The timestamp at which this folder was created.
        :param pulumi.Input[_builtins.bool] force_destroy: If set to true, items within folder if any will be force destroyed.
        :param pulumi.Input[_builtins.str] metageneration: The metadata generation of the folder.
        :param pulumi.Input[_builtins.str] name: The name of the folder expressed as a path. Must include
               trailing '/'. For example, `example_dir/example_dir2/`, `example@#/`, `a-b/d-f/`.
        :param pulumi.Input[_builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[_builtins.str] update_time: The timestamp at which this folder was most recently updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FolderState.__new__(_FolderState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["metageneration"] = metageneration
        __props__.__dict__["name"] = name
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["update_time"] = update_time
        return Folder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the bucket that contains the folder.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which this folder was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, items within folder if any will be force destroyed.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter
    def metageneration(self) -> pulumi.Output[_builtins.str]:
        """
        The metadata generation of the folder.
        """
        return pulumi.get(self, "metageneration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the folder expressed as a path. Must include
        trailing '/'. For example, `example_dir/example_dir2/`, `example@#/`, `a-b/d-f/`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp at which this folder was most recently updated.
        """
        return pulumi.get(self, "update_time")

