# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BatchOperationsJobBucketList',
    'BatchOperationsJobBucketListBuckets',
    'BatchOperationsJobBucketListBucketsManifest',
    'BatchOperationsJobBucketListBucketsPrefixList',
    'BatchOperationsJobDeleteObject',
    'BatchOperationsJobPutMetadata',
    'BatchOperationsJobPutObjectHold',
    'BatchOperationsJobRewriteObject',
    'BucketAutoclass',
    'BucketCor',
    'BucketCustomPlacementConfig',
    'BucketEncryption',
    'BucketHierarchicalNamespace',
    'BucketIAMBindingCondition',
    'BucketIAMMemberCondition',
    'BucketIpFilter',
    'BucketIpFilterPublicNetworkSource',
    'BucketIpFilterVpcNetworkSource',
    'BucketLifecycleRule',
    'BucketLifecycleRuleAction',
    'BucketLifecycleRuleCondition',
    'BucketLogging',
    'BucketObjectCustomerEncryption',
    'BucketObjectRetention',
    'BucketRetentionPolicy',
    'BucketSoftDeletePolicy',
    'BucketVersioning',
    'BucketWebsite',
    'ControlFolderIntelligenceConfigEffectiveIntelligenceConfig',
    'ControlFolderIntelligenceConfigFilter',
    'ControlFolderIntelligenceConfigFilterExcludedCloudStorageBuckets',
    'ControlFolderIntelligenceConfigFilterExcludedCloudStorageLocations',
    'ControlFolderIntelligenceConfigFilterIncludedCloudStorageBuckets',
    'ControlFolderIntelligenceConfigFilterIncludedCloudStorageLocations',
    'ControlFolderIntelligenceConfigTrialConfig',
    'ControlOrganizationIntelligenceConfigEffectiveIntelligenceConfig',
    'ControlOrganizationIntelligenceConfigFilter',
    'ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBuckets',
    'ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocations',
    'ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBuckets',
    'ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocations',
    'ControlOrganizationIntelligenceConfigTrialConfig',
    'ControlProjectIntelligenceConfigEffectiveIntelligenceConfig',
    'ControlProjectIntelligenceConfigFilter',
    'ControlProjectIntelligenceConfigFilterExcludedCloudStorageBuckets',
    'ControlProjectIntelligenceConfigFilterExcludedCloudStorageLocations',
    'ControlProjectIntelligenceConfigFilterIncludedCloudStorageBuckets',
    'ControlProjectIntelligenceConfigFilterIncludedCloudStorageLocations',
    'ControlProjectIntelligenceConfigTrialConfig',
    'DefaultObjectAccessControlProjectTeam',
    'InsightsReportConfigCsvOptions',
    'InsightsReportConfigFrequencyOptions',
    'InsightsReportConfigFrequencyOptionsEndDate',
    'InsightsReportConfigFrequencyOptionsStartDate',
    'InsightsReportConfigObjectMetadataReportOptions',
    'InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions',
    'InsightsReportConfigObjectMetadataReportOptionsStorageFilters',
    'InsightsReportConfigParquetOptions',
    'ManagedFolderIamBindingCondition',
    'ManagedFolderIamMemberCondition',
    'ObjectAccessControlProjectTeam',
    'TransferAgentPoolBandwidthLimit',
    'TransferJobEventStream',
    'TransferJobLoggingConfig',
    'TransferJobNotificationConfig',
    'TransferJobReplicationSpec',
    'TransferJobReplicationSpecGcsDataSink',
    'TransferJobReplicationSpecGcsDataSource',
    'TransferJobReplicationSpecObjectConditions',
    'TransferJobReplicationSpecTransferOptions',
    'TransferJobReplicationSpecTransferOptionsMetadataOptions',
    'TransferJobSchedule',
    'TransferJobScheduleScheduleEndDate',
    'TransferJobScheduleScheduleStartDate',
    'TransferJobScheduleStartTimeOfDay',
    'TransferJobTransferSpec',
    'TransferJobTransferSpecAwsS3DataSource',
    'TransferJobTransferSpecAwsS3DataSourceAwsAccessKey',
    'TransferJobTransferSpecAzureBlobStorageDataSource',
    'TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials',
    'TransferJobTransferSpecGcsDataSink',
    'TransferJobTransferSpecGcsDataSource',
    'TransferJobTransferSpecHdfsDataSource',
    'TransferJobTransferSpecHttpDataSource',
    'TransferJobTransferSpecObjectConditions',
    'TransferJobTransferSpecPosixDataSink',
    'TransferJobTransferSpecPosixDataSource',
    'TransferJobTransferSpecTransferOptions',
    'TransferJobTransferSpecTransferOptionsMetadataOptions',
    'GetBucketAutoclassResult',
    'GetBucketCorResult',
    'GetBucketCustomPlacementConfigResult',
    'GetBucketEncryptionResult',
    'GetBucketHierarchicalNamespaceResult',
    'GetBucketIpFilterResult',
    'GetBucketIpFilterPublicNetworkSourceResult',
    'GetBucketIpFilterVpcNetworkSourceResult',
    'GetBucketLifecycleRuleResult',
    'GetBucketLifecycleRuleActionResult',
    'GetBucketLifecycleRuleConditionResult',
    'GetBucketLoggingResult',
    'GetBucketObjectContentCustomerEncryptionResult',
    'GetBucketObjectContentRetentionResult',
    'GetBucketObjectCustomerEncryptionResult',
    'GetBucketObjectRetentionResult',
    'GetBucketObjectsBucketObjectResult',
    'GetBucketRetentionPolicyResult',
    'GetBucketSoftDeletePolicyResult',
    'GetBucketVersioningResult',
    'GetBucketWebsiteResult',
    'GetBucketsBucketResult',
    'GetControlFolderIntelligenceConfigEffectiveIntelligenceConfigResult',
    'GetControlFolderIntelligenceConfigFilterResult',
    'GetControlFolderIntelligenceConfigFilterExcludedCloudStorageBucketResult',
    'GetControlFolderIntelligenceConfigFilterExcludedCloudStorageLocationResult',
    'GetControlFolderIntelligenceConfigFilterIncludedCloudStorageBucketResult',
    'GetControlFolderIntelligenceConfigFilterIncludedCloudStorageLocationResult',
    'GetControlFolderIntelligenceConfigTrialConfigResult',
    'GetControlOrganizationIntelligenceConfigEffectiveIntelligenceConfigResult',
    'GetControlOrganizationIntelligenceConfigFilterResult',
    'GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBucketResult',
    'GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocationResult',
    'GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBucketResult',
    'GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocationResult',
    'GetControlOrganizationIntelligenceConfigTrialConfigResult',
    'GetControlProjectIntelligenceConfigEffectiveIntelligenceConfigResult',
    'GetControlProjectIntelligenceConfigFilterResult',
    'GetControlProjectIntelligenceConfigFilterExcludedCloudStorageBucketResult',
    'GetControlProjectIntelligenceConfigFilterExcludedCloudStorageLocationResult',
    'GetControlProjectIntelligenceConfigFilterIncludedCloudStorageBucketResult',
    'GetControlProjectIntelligenceConfigFilterIncludedCloudStorageLocationResult',
    'GetControlProjectIntelligenceConfigTrialConfigResult',
]

@pulumi.output_type
class BatchOperationsJobBucketList(dict):
    def __init__(__self__, *,
                 buckets: 'outputs.BatchOperationsJobBucketListBuckets'):
        """
        :param 'BatchOperationsJobBucketListBucketsArgs' buckets: List of buckets and their objects to be transformed.
               Structure is documented below.
        """
        pulumi.set(__self__, "buckets", buckets)

    @_builtins.property
    @pulumi.getter
    def buckets(self) -> 'outputs.BatchOperationsJobBucketListBuckets':
        """
        List of buckets and their objects to be transformed.
        Structure is documented below.
        """
        return pulumi.get(self, "buckets")


@pulumi.output_type
class BatchOperationsJobBucketListBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixList":
            suggest = "prefix_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOperationsJobBucketListBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOperationsJobBucketListBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOperationsJobBucketListBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 manifest: Optional['outputs.BatchOperationsJobBucketListBucketsManifest'] = None,
                 prefix_list: Optional['outputs.BatchOperationsJobBucketListBucketsPrefixList'] = None):
        """
        :param _builtins.str bucket: Bucket name for the objects to be transformed.
        :param 'BatchOperationsJobBucketListBucketsManifestArgs' manifest: contain the manifest source file that is a CSV file in a Google Cloud Storage bucket.
               Structure is documented below.
        :param 'BatchOperationsJobBucketListBucketsPrefixListArgs' prefix_list: Specifies objects matching a prefix set.
               Structure is documented below.
        """
        pulumi.set(__self__, "bucket", bucket)
        if manifest is not None:
            pulumi.set(__self__, "manifest", manifest)
        if prefix_list is not None:
            pulumi.set(__self__, "prefix_list", prefix_list)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        Bucket name for the objects to be transformed.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter
    def manifest(self) -> Optional['outputs.BatchOperationsJobBucketListBucketsManifest']:
        """
        contain the manifest source file that is a CSV file in a Google Cloud Storage bucket.
        Structure is documented below.
        """
        return pulumi.get(self, "manifest")

    @_builtins.property
    @pulumi.getter(name="prefixList")
    def prefix_list(self) -> Optional['outputs.BatchOperationsJobBucketListBucketsPrefixList']:
        """
        Specifies objects matching a prefix set.
        Structure is documented below.
        """
        return pulumi.get(self, "prefix_list")


@pulumi.output_type
class BatchOperationsJobBucketListBucketsManifest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestLocation":
            suggest = "manifest_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOperationsJobBucketListBucketsManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOperationsJobBucketListBucketsManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOperationsJobBucketListBucketsManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_location: Optional[_builtins.str] = None):
        """
        :param _builtins.str manifest_location: Specifies objects in a manifest file.
        """
        if manifest_location is not None:
            pulumi.set(__self__, "manifest_location", manifest_location)

    @_builtins.property
    @pulumi.getter(name="manifestLocation")
    def manifest_location(self) -> Optional[_builtins.str]:
        """
        Specifies objects in a manifest file.
        """
        return pulumi.get(self, "manifest_location")


@pulumi.output_type
class BatchOperationsJobBucketListBucketsPrefixList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includedObjectPrefixes":
            suggest = "included_object_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOperationsJobBucketListBucketsPrefixList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOperationsJobBucketListBucketsPrefixList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOperationsJobBucketListBucketsPrefixList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 included_object_prefixes: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] included_object_prefixes: (Optional)
        """
        if included_object_prefixes is not None:
            pulumi.set(__self__, "included_object_prefixes", included_object_prefixes)

    @_builtins.property
    @pulumi.getter(name="includedObjectPrefixes")
    def included_object_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Optional)
        """
        return pulumi.get(self, "included_object_prefixes")


@pulumi.output_type
class BatchOperationsJobDeleteObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permanentObjectDeletionEnabled":
            suggest = "permanent_object_deletion_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOperationsJobDeleteObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOperationsJobDeleteObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOperationsJobDeleteObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permanent_object_deletion_enabled: _builtins.bool):
        """
        :param _builtins.bool permanent_object_deletion_enabled: enable flag to permanently delete object and all object versions if versioning is enabled on bucket.
        """
        pulumi.set(__self__, "permanent_object_deletion_enabled", permanent_object_deletion_enabled)

    @_builtins.property
    @pulumi.getter(name="permanentObjectDeletionEnabled")
    def permanent_object_deletion_enabled(self) -> _builtins.bool:
        """
        enable flag to permanently delete object and all object versions if versioning is enabled on bucket.
        """
        return pulumi.get(self, "permanent_object_deletion_enabled")


@pulumi.output_type
class BatchOperationsJobPutMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cacheControl":
            suggest = "cache_control"
        elif key == "contentDisposition":
            suggest = "content_disposition"
        elif key == "contentEncoding":
            suggest = "content_encoding"
        elif key == "contentLanguage":
            suggest = "content_language"
        elif key == "contentType":
            suggest = "content_type"
        elif key == "customMetadata":
            suggest = "custom_metadata"
        elif key == "customTime":
            suggest = "custom_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOperationsJobPutMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOperationsJobPutMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOperationsJobPutMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cache_control: Optional[_builtins.str] = None,
                 content_disposition: Optional[_builtins.str] = None,
                 content_encoding: Optional[_builtins.str] = None,
                 content_language: Optional[_builtins.str] = None,
                 content_type: Optional[_builtins.str] = None,
                 custom_metadata: Optional[Mapping[str, _builtins.str]] = None,
                 custom_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str cache_control: Cache-Control directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        :param _builtins.str content_disposition: Content-Disposition of the object data.
        :param _builtins.str content_encoding: Content Encoding of the object data.
        :param _builtins.str content_language: Content-Language of the object data.
        :param _builtins.str content_type: Content-Type of the object data.
        :param Mapping[str, _builtins.str] custom_metadata: User-provided metadata, in key/value pairs.
        :param _builtins.str custom_time: Updates the objects fixed custom time metadata.
        """
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if custom_metadata is not None:
            pulumi.set(__self__, "custom_metadata", custom_metadata)
        if custom_time is not None:
            pulumi.set(__self__, "custom_time", custom_time)

    @_builtins.property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[_builtins.str]:
        """
        Cache-Control directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        """
        return pulumi.get(self, "cache_control")

    @_builtins.property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[_builtins.str]:
        """
        Content-Disposition of the object data.
        """
        return pulumi.get(self, "content_disposition")

    @_builtins.property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[_builtins.str]:
        """
        Content Encoding of the object data.
        """
        return pulumi.get(self, "content_encoding")

    @_builtins.property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[_builtins.str]:
        """
        Content-Language of the object data.
        """
        return pulumi.get(self, "content_language")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        Content-Type of the object data.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="customMetadata")
    def custom_metadata(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        User-provided metadata, in key/value pairs.
        """
        return pulumi.get(self, "custom_metadata")

    @_builtins.property
    @pulumi.getter(name="customTime")
    def custom_time(self) -> Optional[_builtins.str]:
        """
        Updates the objects fixed custom time metadata.
        """
        return pulumi.get(self, "custom_time")


@pulumi.output_type
class BatchOperationsJobPutObjectHold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventBasedHold":
            suggest = "event_based_hold"
        elif key == "temporaryHold":
            suggest = "temporary_hold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOperationsJobPutObjectHold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOperationsJobPutObjectHold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOperationsJobPutObjectHold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_based_hold: Optional[_builtins.str] = None,
                 temporary_hold: Optional[_builtins.str] = None):
        """
        :param _builtins.str event_based_hold: set/unset to update event based hold for objects.
        :param _builtins.str temporary_hold: set/unset to update temporary based hold for objects.
        """
        if event_based_hold is not None:
            pulumi.set(__self__, "event_based_hold", event_based_hold)
        if temporary_hold is not None:
            pulumi.set(__self__, "temporary_hold", temporary_hold)

    @_builtins.property
    @pulumi.getter(name="eventBasedHold")
    def event_based_hold(self) -> Optional[_builtins.str]:
        """
        set/unset to update event based hold for objects.
        """
        return pulumi.get(self, "event_based_hold")

    @_builtins.property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> Optional[_builtins.str]:
        """
        set/unset to update temporary based hold for objects.
        """
        return pulumi.get(self, "temporary_hold")


@pulumi.output_type
class BatchOperationsJobRewriteObject(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BatchOperationsJobRewriteObject. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BatchOperationsJobRewriteObject.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BatchOperationsJobRewriteObject.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: _builtins.str):
        """
        :param _builtins.str kms_key: valid kms key
        """
        pulumi.set(__self__, "kms_key", kms_key)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> _builtins.str:
        """
        valid kms key
        """
        return pulumi.get(self, "kms_key")


@pulumi.output_type
class BucketAutoclass(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "terminalStorageClass":
            suggest = "terminal_storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketAutoclass. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketAutoclass.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketAutoclass.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 terminal_storage_class: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: While set to `true`, autoclass automatically transitions objects in your bucket to appropriate storage classes based on each object's access pattern.
        :param _builtins.str terminal_storage_class: The storage class that objects in the bucket eventually transition to if they are not read for a certain length of time. Supported values include: `NEARLINE`, `ARCHIVE`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if terminal_storage_class is not None:
            pulumi.set(__self__, "terminal_storage_class", terminal_storage_class)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        While set to `true`, autoclass automatically transitions objects in your bucket to appropriate storage classes based on each object's access pattern.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="terminalStorageClass")
    def terminal_storage_class(self) -> Optional[_builtins.str]:
        """
        The storage class that objects in the bucket eventually transition to if they are not read for a certain length of time. Supported values include: `NEARLINE`, `ARCHIVE`.
        """
        return pulumi.get(self, "terminal_storage_class")


@pulumi.output_type
class BucketCor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxAgeSeconds":
            suggest = "max_age_seconds"
        elif key == "responseHeaders":
            suggest = "response_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_age_seconds: Optional[_builtins.int] = None,
                 methods: Optional[Sequence[_builtins.str]] = None,
                 origins: Optional[Sequence[_builtins.str]] = None,
                 response_headers: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.int max_age_seconds: The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        :param Sequence[_builtins.str] methods: The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        :param Sequence[_builtins.str] origins: The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        :param Sequence[_builtins.str] response_headers: The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if origins is not None:
            pulumi.set(__self__, "origins", origins)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[_builtins.int]:
        """
        The value, in seconds, to return in the [Access-Control-Max-Age header](https://www.w3.org/TR/cors/#access-control-max-age-response-header) used in preflight responses.
        """
        return pulumi.get(self, "max_age_seconds")

    @_builtins.property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        """
        return pulumi.get(self, "methods")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of [Origins](https://tools.ietf.org/html/rfc6454) eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        """
        return pulumi.get(self, "origins")

    @_builtins.property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[Sequence[_builtins.str]]:
        """
        The list of HTTP headers other than the [simple response headers](https://www.w3.org/TR/cors/#simple-response-header) to give permission for the user-agent to share across domains.
        """
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class BucketCustomPlacementConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLocations":
            suggest = "data_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketCustomPlacementConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketCustomPlacementConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketCustomPlacementConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] data_locations: The list of individual regions that comprise a dual-region bucket. See [Cloud Storage bucket locations](https://cloud.google.com/storage/docs/dual-regions#availability) for a list of acceptable regions. **Note**: If any of the data_locations changes, it will [recreate the bucket](https://cloud.google.com/storage/docs/locations#key-concepts).
        """
        pulumi.set(__self__, "data_locations", data_locations)

    @_builtins.property
    @pulumi.getter(name="dataLocations")
    def data_locations(self) -> Sequence[_builtins.str]:
        """
        The list of individual regions that comprise a dual-region bucket. See [Cloud Storage bucket locations](https://cloud.google.com/storage/docs/dual-regions#availability) for a list of acceptable regions. **Note**: If any of the data_locations changes, it will [recreate the bucket](https://cloud.google.com/storage/docs/locations#key-concepts).
        """
        return pulumi.get(self, "data_locations")


@pulumi.output_type
class BucketEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKmsKeyName":
            suggest = "default_kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_kms_key_name: _builtins.str):
        """
        :param _builtins.str default_kms_key_name: The `id` of a Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
               You must pay attention to whether the crypto key is available in the location that this bucket is created in.
               See [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for more details.
               
               > As per [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for customer-managed encryption keys, the IAM policy for the
               specified key must permit the [automatic Google Cloud Storage service account](https://cloud.google.com/storage/docs/projects#service-accounts) for the bucket's
               project to use the specified key for encryption and decryption operations.
               Although the service account email address follows a well-known format, the service account is created on-demand and may not necessarily exist for your project
               until a relevant action has occurred which triggers its creation.
               You should use the [`storage_get_project_service_account`](https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html) data source to obtain the email
               address for the service account when configuring IAM policy on the Cloud KMS key.
               This data source calls an API which creates the account if required, ensuring your provider applies cleanly and repeatedly irrespective of the
               state of the project.
               You should take care for race conditions when the same provider manages IAM policy on the Cloud KMS crypto key. See the data source page for more details.
        """
        pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @_builtins.property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> _builtins.str:
        """
        The `id` of a Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
        You must pay attention to whether the crypto key is available in the location that this bucket is created in.
        See [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for more details.

        > As per [the docs](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) for customer-managed encryption keys, the IAM policy for the
        specified key must permit the [automatic Google Cloud Storage service account](https://cloud.google.com/storage/docs/projects#service-accounts) for the bucket's
        project to use the specified key for encryption and decryption operations.
        Although the service account email address follows a well-known format, the service account is created on-demand and may not necessarily exist for your project
        until a relevant action has occurred which triggers its creation.
        You should use the [`storage_get_project_service_account`](https://www.terraform.io/docs/providers/google/d/storage_project_service_account.html) data source to obtain the email
        address for the service account when configuring IAM policy on the Cloud KMS key.
        This data source calls an API which creates the account if required, ensuring your provider applies cleanly and repeatedly irrespective of the
        state of the project.
        You should take care for race conditions when the same provider manages IAM policy on the Cloud KMS crypto key. See the data source page for more details.
        """
        return pulumi.get(self, "default_kms_key_name")


@pulumi.output_type
class BucketHierarchicalNamespace(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Enables hierarchical namespace for the bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enables hierarchical namespace for the bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketIAMBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param _builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class BucketIAMMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param _builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
               identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
               consider it to be an entirely different resource and will treat it as such.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        > **Warning:** This provider considers the `role` and condition contents (`title`+`description`+`expression`) as the
        identifier for the binding. This means that if any part of the condition is changed out-of-band, the provider will
        consider it to be an entirely different resource and will treat it as such.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class BucketIpFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowAllServiceAgentAccess":
            suggest = "allow_all_service_agent_access"
        elif key == "allowCrossOrgVpcs":
            suggest = "allow_cross_org_vpcs"
        elif key == "publicNetworkSource":
            suggest = "public_network_source"
        elif key == "vpcNetworkSources":
            suggest = "vpc_network_sources"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIpFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIpFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIpFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: _builtins.str,
                 allow_all_service_agent_access: Optional[_builtins.bool] = None,
                 allow_cross_org_vpcs: Optional[_builtins.bool] = None,
                 public_network_source: Optional['outputs.BucketIpFilterPublicNetworkSource'] = None,
                 vpc_network_sources: Optional[Sequence['outputs.BucketIpFilterVpcNetworkSource']] = None):
        """
        :param _builtins.str mode: The state of the IP filter configuration. Valid values are `Enabled` and `Disabled`. When set to `Enabled`, IP filtering rules are applied to a bucket and all incoming requests to the bucket are evaluated against these rules. When set to `Disabled`, IP filtering rules are not applied to a bucket. **Note**: `allow_all_service_agent_access` must be supplied when `mode` is set to `Enabled`, it can be ommited for other values.
        :param _builtins.bool allow_all_service_agent_access: While set `true`, allows all service agents to access the bucket regardless of the IP filter configuration.
        :param _builtins.bool allow_cross_org_vpcs: While set `true`, allows cross-org VPCs in the bucket's IP filter configuration.
        :param 'BucketIpFilterPublicNetworkSourceArgs' public_network_source: The public network IP address ranges that can access the bucket and its data. Structure is documented below.
        :param Sequence['BucketIpFilterVpcNetworkSourceArgs'] vpc_network_sources: The list of VPC networks that can access the bucket. Structure is documented below.
        """
        pulumi.set(__self__, "mode", mode)
        if allow_all_service_agent_access is not None:
            pulumi.set(__self__, "allow_all_service_agent_access", allow_all_service_agent_access)
        if allow_cross_org_vpcs is not None:
            pulumi.set(__self__, "allow_cross_org_vpcs", allow_cross_org_vpcs)
        if public_network_source is not None:
            pulumi.set(__self__, "public_network_source", public_network_source)
        if vpc_network_sources is not None:
            pulumi.set(__self__, "vpc_network_sources", vpc_network_sources)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The state of the IP filter configuration. Valid values are `Enabled` and `Disabled`. When set to `Enabled`, IP filtering rules are applied to a bucket and all incoming requests to the bucket are evaluated against these rules. When set to `Disabled`, IP filtering rules are not applied to a bucket. **Note**: `allow_all_service_agent_access` must be supplied when `mode` is set to `Enabled`, it can be ommited for other values.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="allowAllServiceAgentAccess")
    def allow_all_service_agent_access(self) -> Optional[_builtins.bool]:
        """
        While set `true`, allows all service agents to access the bucket regardless of the IP filter configuration.
        """
        return pulumi.get(self, "allow_all_service_agent_access")

    @_builtins.property
    @pulumi.getter(name="allowCrossOrgVpcs")
    def allow_cross_org_vpcs(self) -> Optional[_builtins.bool]:
        """
        While set `true`, allows cross-org VPCs in the bucket's IP filter configuration.
        """
        return pulumi.get(self, "allow_cross_org_vpcs")

    @_builtins.property
    @pulumi.getter(name="publicNetworkSource")
    def public_network_source(self) -> Optional['outputs.BucketIpFilterPublicNetworkSource']:
        """
        The public network IP address ranges that can access the bucket and its data. Structure is documented below.
        """
        return pulumi.get(self, "public_network_source")

    @_builtins.property
    @pulumi.getter(name="vpcNetworkSources")
    def vpc_network_sources(self) -> Optional[Sequence['outputs.BucketIpFilterVpcNetworkSource']]:
        """
        The list of VPC networks that can access the bucket. Structure is documented below.
        """
        return pulumi.get(self, "vpc_network_sources")


@pulumi.output_type
class BucketIpFilterPublicNetworkSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIpCidrRanges":
            suggest = "allowed_ip_cidr_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIpFilterPublicNetworkSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIpFilterPublicNetworkSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIpFilterPublicNetworkSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_ip_cidr_ranges: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] allowed_ip_cidr_ranges: The list of public IPv4 and IPv6 CIDR ranges that can access the bucket and its data.
        """
        pulumi.set(__self__, "allowed_ip_cidr_ranges", allowed_ip_cidr_ranges)

    @_builtins.property
    @pulumi.getter(name="allowedIpCidrRanges")
    def allowed_ip_cidr_ranges(self) -> Sequence[_builtins.str]:
        """
        The list of public IPv4 and IPv6 CIDR ranges that can access the bucket and its data.
        """
        return pulumi.get(self, "allowed_ip_cidr_ranges")


@pulumi.output_type
class BucketIpFilterVpcNetworkSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIpCidrRanges":
            suggest = "allowed_ip_cidr_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketIpFilterVpcNetworkSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketIpFilterVpcNetworkSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketIpFilterVpcNetworkSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_ip_cidr_ranges: Sequence[_builtins.str],
                 network: _builtins.str):
        """
        :param Sequence[_builtins.str] allowed_ip_cidr_ranges: The list of public or private IPv4 and IPv6 CIDR ranges that can access the bucket.
        :param _builtins.str network: Name of the network. Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
        """
        pulumi.set(__self__, "allowed_ip_cidr_ranges", allowed_ip_cidr_ranges)
        pulumi.set(__self__, "network", network)

    @_builtins.property
    @pulumi.getter(name="allowedIpCidrRanges")
    def allowed_ip_cidr_ranges(self) -> Sequence[_builtins.str]:
        """
        The list of public or private IPv4 and IPv6 CIDR ranges that can access the bucket.
        """
        return pulumi.get(self, "allowed_ip_cidr_ranges")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Name of the network. Format: `projects/PROJECT_ID/global/networks/NETWORK_NAME`
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class BucketLifecycleRule(dict):
    def __init__(__self__, *,
                 action: 'outputs.BucketLifecycleRuleAction',
                 condition: 'outputs.BucketLifecycleRuleCondition'):
        """
        :param 'BucketLifecycleRuleActionArgs' action: The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        :param 'BucketLifecycleRuleConditionArgs' condition: The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "condition", condition)

    @_builtins.property
    @pulumi.getter
    def action(self) -> 'outputs.BucketLifecycleRuleAction':
        """
        The Lifecycle Rule's action configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def condition(self) -> 'outputs.BucketLifecycleRuleCondition':
        """
        The Lifecycle Rule's condition configuration. A single block of this type is supported. Structure is documented below.
        """
        return pulumi.get(self, "condition")


@pulumi.output_type
class BucketLifecycleRuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClass":
            suggest = "storage_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 storage_class: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of the action of this Lifecycle Rule. Supported values include: `Delete`, `SetStorageClass` and `AbortIncompleteMultipartUpload`.
        :param _builtins.str storage_class: The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        pulumi.set(__self__, "type", type)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the action of this Lifecycle Rule. Supported values include: `Delete`, `SetStorageClass` and `AbortIncompleteMultipartUpload`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[_builtins.str]:
        """
        The target [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects affected by this Lifecycle Rule. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class BucketLifecycleRuleCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdBefore":
            suggest = "created_before"
        elif key == "customTimeBefore":
            suggest = "custom_time_before"
        elif key == "daysSinceCustomTime":
            suggest = "days_since_custom_time"
        elif key == "daysSinceNoncurrentTime":
            suggest = "days_since_noncurrent_time"
        elif key == "matchesPrefixes":
            suggest = "matches_prefixes"
        elif key == "matchesStorageClasses":
            suggest = "matches_storage_classes"
        elif key == "matchesSuffixes":
            suggest = "matches_suffixes"
        elif key == "noncurrentTimeBefore":
            suggest = "noncurrent_time_before"
        elif key == "numNewerVersions":
            suggest = "num_newer_versions"
        elif key == "sendAgeIfZero":
            suggest = "send_age_if_zero"
        elif key == "sendDaysSinceCustomTimeIfZero":
            suggest = "send_days_since_custom_time_if_zero"
        elif key == "sendDaysSinceNoncurrentTimeIfZero":
            suggest = "send_days_since_noncurrent_time_if_zero"
        elif key == "sendNumNewerVersionsIfZero":
            suggest = "send_num_newer_versions_if_zero"
        elif key == "withState":
            suggest = "with_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLifecycleRuleCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLifecycleRuleCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLifecycleRuleCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 age: Optional[_builtins.int] = None,
                 created_before: Optional[_builtins.str] = None,
                 custom_time_before: Optional[_builtins.str] = None,
                 days_since_custom_time: Optional[_builtins.int] = None,
                 days_since_noncurrent_time: Optional[_builtins.int] = None,
                 matches_prefixes: Optional[Sequence[_builtins.str]] = None,
                 matches_storage_classes: Optional[Sequence[_builtins.str]] = None,
                 matches_suffixes: Optional[Sequence[_builtins.str]] = None,
                 noncurrent_time_before: Optional[_builtins.str] = None,
                 num_newer_versions: Optional[_builtins.int] = None,
                 send_age_if_zero: Optional[_builtins.bool] = None,
                 send_days_since_custom_time_if_zero: Optional[_builtins.bool] = None,
                 send_days_since_noncurrent_time_if_zero: Optional[_builtins.bool] = None,
                 send_num_newer_versions_if_zero: Optional[_builtins.bool] = None,
                 with_state: Optional[_builtins.str] = None):
        """
        :param _builtins.int age: Minimum age of an object in days to satisfy this condition. **Note** To set `0` value of `age`, `send_age_if_zero` should be set `true` otherwise `0` value of `age` field will be ignored.
        :param _builtins.str created_before: A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when an object is created before midnight of the specified date in UTC.
        :param _builtins.str custom_time_before: A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when the customTime metadata for the object is set to an earlier date than the date used in this lifecycle condition.
        :param _builtins.int days_since_custom_time: Number of days elapsed since the user-specified timestamp set on an object.
        :param _builtins.int days_since_noncurrent_time: Number of days elapsed since the noncurrent timestamp of an object. This
               										condition is relevant only for versioned objects.
        :param Sequence[_builtins.str] matches_prefixes: One or more matching name prefixes to satisfy this condition.
        :param Sequence[_builtins.str] matches_storage_classes: [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`, `DURABLE_REDUCED_AVAILABILITY`.
        :param Sequence[_builtins.str] matches_suffixes: One or more matching name suffixes to satisfy this condition.
        :param _builtins.str noncurrent_time_before: Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        :param _builtins.int num_newer_versions: Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        :param _builtins.bool send_age_if_zero: While set true, `age` value will be sent in the request even for zero value of the field. This field is only useful and required for setting 0 value to the `age` field. It can be used alone or together with `age` attribute. **NOTE** `age` attibute with `0` value will be ommitted from the API request if `send_age_if_zero` field is having `false` value.
        :param _builtins.bool send_days_since_custom_time_if_zero: While set true, `days_since_custom_time` value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the `days_since_custom_time` field. It can be used alone or together with `days_since_custom_time`.
        :param _builtins.bool send_days_since_noncurrent_time_if_zero: While set true, `days_since_noncurrent_time` value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the `days_since_noncurrent_time` field. It can be used alone or together with `days_since_noncurrent_time`.
        :param _builtins.bool send_num_newer_versions_if_zero: While set true, `num_newer_versions` value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the `num_newer_versions` field. It can be used alone or together with `num_newer_versions`.
        :param _builtins.str with_state: Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        if age is not None:
            pulumi.set(__self__, "age", age)
        if created_before is not None:
            pulumi.set(__self__, "created_before", created_before)
        if custom_time_before is not None:
            pulumi.set(__self__, "custom_time_before", custom_time_before)
        if days_since_custom_time is not None:
            pulumi.set(__self__, "days_since_custom_time", days_since_custom_time)
        if days_since_noncurrent_time is not None:
            pulumi.set(__self__, "days_since_noncurrent_time", days_since_noncurrent_time)
        if matches_prefixes is not None:
            pulumi.set(__self__, "matches_prefixes", matches_prefixes)
        if matches_storage_classes is not None:
            pulumi.set(__self__, "matches_storage_classes", matches_storage_classes)
        if matches_suffixes is not None:
            pulumi.set(__self__, "matches_suffixes", matches_suffixes)
        if noncurrent_time_before is not None:
            pulumi.set(__self__, "noncurrent_time_before", noncurrent_time_before)
        if num_newer_versions is not None:
            pulumi.set(__self__, "num_newer_versions", num_newer_versions)
        if send_age_if_zero is not None:
            pulumi.set(__self__, "send_age_if_zero", send_age_if_zero)
        if send_days_since_custom_time_if_zero is not None:
            pulumi.set(__self__, "send_days_since_custom_time_if_zero", send_days_since_custom_time_if_zero)
        if send_days_since_noncurrent_time_if_zero is not None:
            pulumi.set(__self__, "send_days_since_noncurrent_time_if_zero", send_days_since_noncurrent_time_if_zero)
        if send_num_newer_versions_if_zero is not None:
            pulumi.set(__self__, "send_num_newer_versions_if_zero", send_num_newer_versions_if_zero)
        if with_state is not None:
            pulumi.set(__self__, "with_state", with_state)

    @_builtins.property
    @pulumi.getter
    def age(self) -> Optional[_builtins.int]:
        """
        Minimum age of an object in days to satisfy this condition. **Note** To set `0` value of `age`, `send_age_if_zero` should be set `true` otherwise `0` value of `age` field will be ignored.
        """
        return pulumi.get(self, "age")

    @_builtins.property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[_builtins.str]:
        """
        A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when an object is created before midnight of the specified date in UTC.
        """
        return pulumi.get(self, "created_before")

    @_builtins.property
    @pulumi.getter(name="customTimeBefore")
    def custom_time_before(self) -> Optional[_builtins.str]:
        """
        A date in the RFC 3339 format YYYY-MM-DD. This condition is satisfied when the customTime metadata for the object is set to an earlier date than the date used in this lifecycle condition.
        """
        return pulumi.get(self, "custom_time_before")

    @_builtins.property
    @pulumi.getter(name="daysSinceCustomTime")
    def days_since_custom_time(self) -> Optional[_builtins.int]:
        """
        Number of days elapsed since the user-specified timestamp set on an object.
        """
        return pulumi.get(self, "days_since_custom_time")

    @_builtins.property
    @pulumi.getter(name="daysSinceNoncurrentTime")
    def days_since_noncurrent_time(self) -> Optional[_builtins.int]:
        """
        Number of days elapsed since the noncurrent timestamp of an object. This
        										condition is relevant only for versioned objects.
        """
        return pulumi.get(self, "days_since_noncurrent_time")

    @_builtins.property
    @pulumi.getter(name="matchesPrefixes")
    def matches_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more matching name prefixes to satisfy this condition.
        """
        return pulumi.get(self, "matches_prefixes")

    @_builtins.property
    @pulumi.getter(name="matchesStorageClasses")
    def matches_storage_classes(self) -> Optional[Sequence[_builtins.str]]:
        """
        [Storage Class](https://cloud.google.com/storage/docs/storage-classes) of objects to satisfy this condition. Supported values include: `STANDARD`, `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`, `DURABLE_REDUCED_AVAILABILITY`.
        """
        return pulumi.get(self, "matches_storage_classes")

    @_builtins.property
    @pulumi.getter(name="matchesSuffixes")
    def matches_suffixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        One or more matching name suffixes to satisfy this condition.
        """
        return pulumi.get(self, "matches_suffixes")

    @_builtins.property
    @pulumi.getter(name="noncurrentTimeBefore")
    def noncurrent_time_before(self) -> Optional[_builtins.str]:
        """
        Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        """
        return pulumi.get(self, "noncurrent_time_before")

    @_builtins.property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> Optional[_builtins.int]:
        """
        Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        """
        return pulumi.get(self, "num_newer_versions")

    @_builtins.property
    @pulumi.getter(name="sendAgeIfZero")
    def send_age_if_zero(self) -> Optional[_builtins.bool]:
        """
        While set true, `age` value will be sent in the request even for zero value of the field. This field is only useful and required for setting 0 value to the `age` field. It can be used alone or together with `age` attribute. **NOTE** `age` attibute with `0` value will be ommitted from the API request if `send_age_if_zero` field is having `false` value.
        """
        return pulumi.get(self, "send_age_if_zero")

    @_builtins.property
    @pulumi.getter(name="sendDaysSinceCustomTimeIfZero")
    def send_days_since_custom_time_if_zero(self) -> Optional[_builtins.bool]:
        """
        While set true, `days_since_custom_time` value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the `days_since_custom_time` field. It can be used alone or together with `days_since_custom_time`.
        """
        return pulumi.get(self, "send_days_since_custom_time_if_zero")

    @_builtins.property
    @pulumi.getter(name="sendDaysSinceNoncurrentTimeIfZero")
    def send_days_since_noncurrent_time_if_zero(self) -> Optional[_builtins.bool]:
        """
        While set true, `days_since_noncurrent_time` value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the `days_since_noncurrent_time` field. It can be used alone or together with `days_since_noncurrent_time`.
        """
        return pulumi.get(self, "send_days_since_noncurrent_time_if_zero")

    @_builtins.property
    @pulumi.getter(name="sendNumNewerVersionsIfZero")
    def send_num_newer_versions_if_zero(self) -> Optional[_builtins.bool]:
        """
        While set true, `num_newer_versions` value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the `num_newer_versions` field. It can be used alone or together with `num_newer_versions`.
        """
        return pulumi.get(self, "send_num_newer_versions_if_zero")

    @_builtins.property
    @pulumi.getter(name="withState")
    def with_state(self) -> Optional[_builtins.str]:
        """
        Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: `"LIVE"`, `"ARCHIVED"`, `"ANY"`.
        """
        return pulumi.get(self, "with_state")


@pulumi.output_type
class BucketLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logBucket":
            suggest = "log_bucket"
        elif key == "logObjectPrefix":
            suggest = "log_object_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_bucket: _builtins.str,
                 log_object_prefix: Optional[_builtins.str] = None):
        """
        :param _builtins.str log_bucket: The bucket that will receive log objects.
        :param _builtins.str log_object_prefix: The object prefix for log objects. If it's not provided,
               by default GCS sets this to this bucket's name.
        """
        pulumi.set(__self__, "log_bucket", log_bucket)
        if log_object_prefix is not None:
            pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @_builtins.property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> _builtins.str:
        """
        The bucket that will receive log objects.
        """
        return pulumi.get(self, "log_bucket")

    @_builtins.property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> Optional[_builtins.str]:
        """
        The object prefix for log objects. If it's not provided,
        by default GCS sets this to this bucket's name.
        """
        return pulumi.get(self, "log_object_prefix")


@pulumi.output_type
class BucketObjectCustomerEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionKey":
            suggest = "encryption_key"
        elif key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectCustomerEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectCustomerEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectCustomerEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_key: _builtins.str,
                 encryption_algorithm: Optional[_builtins.str] = None):
        """
        :param _builtins.str encryption_key: Base64 encoded Customer-Supplied Encryption Key.
        :param _builtins.str encryption_algorithm: Encryption algorithm. Default: AES256
        """
        pulumi.set(__self__, "encryption_key", encryption_key)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> _builtins.str:
        """
        Base64 encoded Customer-Supplied Encryption Key.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[_builtins.str]:
        """
        Encryption algorithm. Default: AES256
        """
        return pulumi.get(self, "encryption_algorithm")


@pulumi.output_type
class BucketObjectRetention(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainUntilTime":
            suggest = "retain_until_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketObjectRetention. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketObjectRetention.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketObjectRetention.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: _builtins.str,
                 retain_until_time: _builtins.str):
        """
        :param _builtins.str mode: The retention policy mode. Either `Locked` or `Unlocked`.
        :param _builtins.str retain_until_time: The time to retain the object until in RFC 3339 format, for example 2012-11-15T16:19:00.094Z.
               
               <a name>
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "retain_until_time", retain_until_time)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The retention policy mode. Either `Locked` or `Unlocked`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="retainUntilTime")
    def retain_until_time(self) -> _builtins.str:
        """
        The time to retain the object until in RFC 3339 format, for example 2012-11-15T16:19:00.094Z.

        <a name>
        """
        return pulumi.get(self, "retain_until_time")


@pulumi.output_type
class BucketRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"
        elif key == "isLocked":
            suggest = "is_locked"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retention_period: _builtins.int,
                 is_locked: Optional[_builtins.bool] = None):
        """
        :param _builtins.int retention_period: The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        :param _builtins.bool is_locked: If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        pulumi.set(__self__, "retention_period", retention_period)
        if is_locked is not None:
            pulumi.set(__self__, "is_locked", is_locked)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.int:
        """
        The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 2,147,483,647 seconds.
        """
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> Optional[_builtins.bool]:
        """
        If set to `true`, the bucket will be [locked](https://cloud.google.com/storage/docs/using-bucket-lock#lock-bucket) and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        return pulumi.get(self, "is_locked")


@pulumi.output_type
class BucketSoftDeletePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveTime":
            suggest = "effective_time"
        elif key == "retentionDurationSeconds":
            suggest = "retention_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketSoftDeletePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketSoftDeletePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketSoftDeletePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_time: Optional[_builtins.str] = None,
                 retention_duration_seconds: Optional[_builtins.int] = None):
        """
        :param _builtins.str effective_time: Server-determined value that indicates the time from which the policy, or one with a greater retention, was effective. This value is in RFC 3339 format.
        :param _builtins.int retention_duration_seconds: The duration in seconds that soft-deleted objects in the bucket will be retained and cannot be permanently deleted. Default value is 604800. The value must be in between 604800(7 days) and 7776000(90 days). **Note**: To disable the soft delete policy on a bucket, This field must be set to 0.
        """
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if retention_duration_seconds is not None:
            pulumi.set(__self__, "retention_duration_seconds", retention_duration_seconds)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[_builtins.str]:
        """
        Server-determined value that indicates the time from which the policy, or one with a greater retention, was effective. This value is in RFC 3339 format.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="retentionDurationSeconds")
    def retention_duration_seconds(self) -> Optional[_builtins.int]:
        """
        The duration in seconds that soft-deleted objects in the bucket will be retained and cannot be permanently deleted. Default value is 604800. The value must be in between 604800(7 days) and 7776000(90 days). **Note**: To disable the soft delete policy on a bucket, This field must be set to 0.
        """
        return pulumi.get(self, "retention_duration_seconds")


@pulumi.output_type
class BucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: While set to `true`, versioning is fully enabled for this bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        While set to `true`, versioning is fully enabled for this bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class BucketWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mainPageSuffix":
            suggest = "main_page_suffix"
        elif key == "notFoundPage":
            suggest = "not_found_page"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BucketWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BucketWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BucketWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 main_page_suffix: Optional[_builtins.str] = None,
                 not_found_page: Optional[_builtins.str] = None):
        """
        :param _builtins.str main_page_suffix: Behaves as the bucket's directory index where
               missing objects are treated as potential directories.
        :param _builtins.str not_found_page: The custom object to return when a requested
               resource is not found.
        """
        if main_page_suffix is not None:
            pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        if not_found_page is not None:
            pulumi.set(__self__, "not_found_page", not_found_page)

    @_builtins.property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> Optional[_builtins.str]:
        """
        Behaves as the bucket's directory index where
        missing objects are treated as potential directories.
        """
        return pulumi.get(self, "main_page_suffix")

    @_builtins.property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> Optional[_builtins.str]:
        """
        The custom object to return when a requested
        resource is not found.
        """
        return pulumi.get(self, "not_found_page")


@pulumi.output_type
class ControlFolderIntelligenceConfigEffectiveIntelligenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveEdition":
            suggest = "effective_edition"
        elif key == "intelligenceConfig":
            suggest = "intelligence_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlFolderIntelligenceConfigEffectiveIntelligenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlFolderIntelligenceConfigEffectiveIntelligenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlFolderIntelligenceConfigEffectiveIntelligenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_edition: Optional[_builtins.str] = None,
                 intelligence_config: Optional[_builtins.str] = None):
        """
        :param _builtins.str effective_edition: (Output)
               The `StorageIntelligence` edition that is applicable for the resource.
        :param _builtins.str intelligence_config: (Output)
               The Intelligence config resource that is applied for the target resource.
        """
        if effective_edition is not None:
            pulumi.set(__self__, "effective_edition", effective_edition)
        if intelligence_config is not None:
            pulumi.set(__self__, "intelligence_config", intelligence_config)

    @_builtins.property
    @pulumi.getter(name="effectiveEdition")
    def effective_edition(self) -> Optional[_builtins.str]:
        """
        (Output)
        The `StorageIntelligence` edition that is applicable for the resource.
        """
        return pulumi.get(self, "effective_edition")

    @_builtins.property
    @pulumi.getter(name="intelligenceConfig")
    def intelligence_config(self) -> Optional[_builtins.str]:
        """
        (Output)
        The Intelligence config resource that is applied for the target resource.
        """
        return pulumi.get(self, "intelligence_config")


@pulumi.output_type
class ControlFolderIntelligenceConfigFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedCloudStorageBuckets":
            suggest = "excluded_cloud_storage_buckets"
        elif key == "excludedCloudStorageLocations":
            suggest = "excluded_cloud_storage_locations"
        elif key == "includedCloudStorageBuckets":
            suggest = "included_cloud_storage_buckets"
        elif key == "includedCloudStorageLocations":
            suggest = "included_cloud_storage_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlFolderIntelligenceConfigFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlFolderIntelligenceConfigFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlFolderIntelligenceConfigFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_cloud_storage_buckets: Optional['outputs.ControlFolderIntelligenceConfigFilterExcludedCloudStorageBuckets'] = None,
                 excluded_cloud_storage_locations: Optional['outputs.ControlFolderIntelligenceConfigFilterExcludedCloudStorageLocations'] = None,
                 included_cloud_storage_buckets: Optional['outputs.ControlFolderIntelligenceConfigFilterIncludedCloudStorageBuckets'] = None,
                 included_cloud_storage_locations: Optional['outputs.ControlFolderIntelligenceConfigFilterIncludedCloudStorageLocations'] = None):
        """
        :param 'ControlFolderIntelligenceConfigFilterExcludedCloudStorageBucketsArgs' excluded_cloud_storage_buckets: Buckets to exclude from the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlFolderIntelligenceConfigFilterExcludedCloudStorageLocationsArgs' excluded_cloud_storage_locations: Locations to exclude from the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlFolderIntelligenceConfigFilterIncludedCloudStorageBucketsArgs' included_cloud_storage_buckets: Buckets to include in the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlFolderIntelligenceConfigFilterIncludedCloudStorageLocationsArgs' included_cloud_storage_locations: Locations to include in the Storage Intelligence plan.
               Structure is documented below.
        """
        if excluded_cloud_storage_buckets is not None:
            pulumi.set(__self__, "excluded_cloud_storage_buckets", excluded_cloud_storage_buckets)
        if excluded_cloud_storage_locations is not None:
            pulumi.set(__self__, "excluded_cloud_storage_locations", excluded_cloud_storage_locations)
        if included_cloud_storage_buckets is not None:
            pulumi.set(__self__, "included_cloud_storage_buckets", included_cloud_storage_buckets)
        if included_cloud_storage_locations is not None:
            pulumi.set(__self__, "included_cloud_storage_locations", included_cloud_storage_locations)

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageBuckets")
    def excluded_cloud_storage_buckets(self) -> Optional['outputs.ControlFolderIntelligenceConfigFilterExcludedCloudStorageBuckets']:
        """
        Buckets to exclude from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageLocations")
    def excluded_cloud_storage_locations(self) -> Optional['outputs.ControlFolderIntelligenceConfigFilterExcludedCloudStorageLocations']:
        """
        Locations to exclude from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageBuckets")
    def included_cloud_storage_buckets(self) -> Optional['outputs.ControlFolderIntelligenceConfigFilterIncludedCloudStorageBuckets']:
        """
        Buckets to include in the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "included_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageLocations")
    def included_cloud_storage_locations(self) -> Optional['outputs.ControlFolderIntelligenceConfigFilterIncludedCloudStorageLocations']:
        """
        Locations to include in the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "included_cloud_storage_locations")


@pulumi.output_type
class ControlFolderIntelligenceConfigFilterExcludedCloudStorageBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketIdRegexes":
            suggest = "bucket_id_regexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlFolderIntelligenceConfigFilterExcludedCloudStorageBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlFolderIntelligenceConfigFilterExcludedCloudStorageBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlFolderIntelligenceConfigFilterExcludedCloudStorageBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class ControlFolderIntelligenceConfigFilterExcludedCloudStorageLocations(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class ControlFolderIntelligenceConfigFilterIncludedCloudStorageBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketIdRegexes":
            suggest = "bucket_id_regexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlFolderIntelligenceConfigFilterIncludedCloudStorageBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlFolderIntelligenceConfigFilterIncludedCloudStorageBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlFolderIntelligenceConfigFilterIncludedCloudStorageBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class ControlFolderIntelligenceConfigFilterIncludedCloudStorageLocations(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class ControlFolderIntelligenceConfigTrialConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlFolderIntelligenceConfigTrialConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlFolderIntelligenceConfigTrialConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlFolderIntelligenceConfigTrialConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str expire_time: (Output)
               The time at which the trial expires.
        """
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time at which the trial expires.
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class ControlOrganizationIntelligenceConfigEffectiveIntelligenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveEdition":
            suggest = "effective_edition"
        elif key == "intelligenceConfig":
            suggest = "intelligence_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlOrganizationIntelligenceConfigEffectiveIntelligenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlOrganizationIntelligenceConfigEffectiveIntelligenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlOrganizationIntelligenceConfigEffectiveIntelligenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_edition: Optional[_builtins.str] = None,
                 intelligence_config: Optional[_builtins.str] = None):
        """
        :param _builtins.str effective_edition: (Output)
               The `StorageIntelligence` edition that is applicable for the resource.
        :param _builtins.str intelligence_config: (Output)
               The Intelligence config resource that is applied for the target resource.
        """
        if effective_edition is not None:
            pulumi.set(__self__, "effective_edition", effective_edition)
        if intelligence_config is not None:
            pulumi.set(__self__, "intelligence_config", intelligence_config)

    @_builtins.property
    @pulumi.getter(name="effectiveEdition")
    def effective_edition(self) -> Optional[_builtins.str]:
        """
        (Output)
        The `StorageIntelligence` edition that is applicable for the resource.
        """
        return pulumi.get(self, "effective_edition")

    @_builtins.property
    @pulumi.getter(name="intelligenceConfig")
    def intelligence_config(self) -> Optional[_builtins.str]:
        """
        (Output)
        The Intelligence config resource that is applied for the target resource.
        """
        return pulumi.get(self, "intelligence_config")


@pulumi.output_type
class ControlOrganizationIntelligenceConfigFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedCloudStorageBuckets":
            suggest = "excluded_cloud_storage_buckets"
        elif key == "excludedCloudStorageLocations":
            suggest = "excluded_cloud_storage_locations"
        elif key == "includedCloudStorageBuckets":
            suggest = "included_cloud_storage_buckets"
        elif key == "includedCloudStorageLocations":
            suggest = "included_cloud_storage_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlOrganizationIntelligenceConfigFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlOrganizationIntelligenceConfigFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlOrganizationIntelligenceConfigFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_cloud_storage_buckets: Optional['outputs.ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBuckets'] = None,
                 excluded_cloud_storage_locations: Optional['outputs.ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocations'] = None,
                 included_cloud_storage_buckets: Optional['outputs.ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBuckets'] = None,
                 included_cloud_storage_locations: Optional['outputs.ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocations'] = None):
        """
        :param 'ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBucketsArgs' excluded_cloud_storage_buckets: Buckets to exclude from the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocationsArgs' excluded_cloud_storage_locations: Locations to exclude from the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBucketsArgs' included_cloud_storage_buckets: Buckets to include in the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocationsArgs' included_cloud_storage_locations: Locations to include in the Storage Intelligence plan.
               Structure is documented below.
        """
        if excluded_cloud_storage_buckets is not None:
            pulumi.set(__self__, "excluded_cloud_storage_buckets", excluded_cloud_storage_buckets)
        if excluded_cloud_storage_locations is not None:
            pulumi.set(__self__, "excluded_cloud_storage_locations", excluded_cloud_storage_locations)
        if included_cloud_storage_buckets is not None:
            pulumi.set(__self__, "included_cloud_storage_buckets", included_cloud_storage_buckets)
        if included_cloud_storage_locations is not None:
            pulumi.set(__self__, "included_cloud_storage_locations", included_cloud_storage_locations)

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageBuckets")
    def excluded_cloud_storage_buckets(self) -> Optional['outputs.ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBuckets']:
        """
        Buckets to exclude from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageLocations")
    def excluded_cloud_storage_locations(self) -> Optional['outputs.ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocations']:
        """
        Locations to exclude from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageBuckets")
    def included_cloud_storage_buckets(self) -> Optional['outputs.ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBuckets']:
        """
        Buckets to include in the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "included_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageLocations")
    def included_cloud_storage_locations(self) -> Optional['outputs.ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocations']:
        """
        Locations to include in the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "included_cloud_storage_locations")


@pulumi.output_type
class ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketIdRegexes":
            suggest = "bucket_id_regexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class ControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocations(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketIdRegexes":
            suggest = "bucket_id_regexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class ControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocations(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class ControlOrganizationIntelligenceConfigTrialConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlOrganizationIntelligenceConfigTrialConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlOrganizationIntelligenceConfigTrialConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlOrganizationIntelligenceConfigTrialConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str expire_time: (Output)
               The time at which the trial expires.
        """
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time at which the trial expires.
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class ControlProjectIntelligenceConfigEffectiveIntelligenceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveEdition":
            suggest = "effective_edition"
        elif key == "intelligenceConfig":
            suggest = "intelligence_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlProjectIntelligenceConfigEffectiveIntelligenceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlProjectIntelligenceConfigEffectiveIntelligenceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlProjectIntelligenceConfigEffectiveIntelligenceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_edition: Optional[_builtins.str] = None,
                 intelligence_config: Optional[_builtins.str] = None):
        """
        :param _builtins.str effective_edition: (Output)
               The `StorageIntelligence` edition that is applicable for the resource.
        :param _builtins.str intelligence_config: (Output)
               The Intelligence config resource that is applied for the target resource.
        """
        if effective_edition is not None:
            pulumi.set(__self__, "effective_edition", effective_edition)
        if intelligence_config is not None:
            pulumi.set(__self__, "intelligence_config", intelligence_config)

    @_builtins.property
    @pulumi.getter(name="effectiveEdition")
    def effective_edition(self) -> Optional[_builtins.str]:
        """
        (Output)
        The `StorageIntelligence` edition that is applicable for the resource.
        """
        return pulumi.get(self, "effective_edition")

    @_builtins.property
    @pulumi.getter(name="intelligenceConfig")
    def intelligence_config(self) -> Optional[_builtins.str]:
        """
        (Output)
        The Intelligence config resource that is applied for the target resource.
        """
        return pulumi.get(self, "intelligence_config")


@pulumi.output_type
class ControlProjectIntelligenceConfigFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedCloudStorageBuckets":
            suggest = "excluded_cloud_storage_buckets"
        elif key == "excludedCloudStorageLocations":
            suggest = "excluded_cloud_storage_locations"
        elif key == "includedCloudStorageBuckets":
            suggest = "included_cloud_storage_buckets"
        elif key == "includedCloudStorageLocations":
            suggest = "included_cloud_storage_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlProjectIntelligenceConfigFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlProjectIntelligenceConfigFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlProjectIntelligenceConfigFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 excluded_cloud_storage_buckets: Optional['outputs.ControlProjectIntelligenceConfigFilterExcludedCloudStorageBuckets'] = None,
                 excluded_cloud_storage_locations: Optional['outputs.ControlProjectIntelligenceConfigFilterExcludedCloudStorageLocations'] = None,
                 included_cloud_storage_buckets: Optional['outputs.ControlProjectIntelligenceConfigFilterIncludedCloudStorageBuckets'] = None,
                 included_cloud_storage_locations: Optional['outputs.ControlProjectIntelligenceConfigFilterIncludedCloudStorageLocations'] = None):
        """
        :param 'ControlProjectIntelligenceConfigFilterExcludedCloudStorageBucketsArgs' excluded_cloud_storage_buckets: Buckets to exclude from the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlProjectIntelligenceConfigFilterExcludedCloudStorageLocationsArgs' excluded_cloud_storage_locations: Locations to exclude from the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlProjectIntelligenceConfigFilterIncludedCloudStorageBucketsArgs' included_cloud_storage_buckets: Buckets to include in the Storage Intelligence plan.
               Structure is documented below.
        :param 'ControlProjectIntelligenceConfigFilterIncludedCloudStorageLocationsArgs' included_cloud_storage_locations: Locations to include in the Storage Intelligence plan.
               Structure is documented below.
        """
        if excluded_cloud_storage_buckets is not None:
            pulumi.set(__self__, "excluded_cloud_storage_buckets", excluded_cloud_storage_buckets)
        if excluded_cloud_storage_locations is not None:
            pulumi.set(__self__, "excluded_cloud_storage_locations", excluded_cloud_storage_locations)
        if included_cloud_storage_buckets is not None:
            pulumi.set(__self__, "included_cloud_storage_buckets", included_cloud_storage_buckets)
        if included_cloud_storage_locations is not None:
            pulumi.set(__self__, "included_cloud_storage_locations", included_cloud_storage_locations)

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageBuckets")
    def excluded_cloud_storage_buckets(self) -> Optional['outputs.ControlProjectIntelligenceConfigFilterExcludedCloudStorageBuckets']:
        """
        Buckets to exclude from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageLocations")
    def excluded_cloud_storage_locations(self) -> Optional['outputs.ControlProjectIntelligenceConfigFilterExcludedCloudStorageLocations']:
        """
        Locations to exclude from the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "excluded_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageBuckets")
    def included_cloud_storage_buckets(self) -> Optional['outputs.ControlProjectIntelligenceConfigFilterIncludedCloudStorageBuckets']:
        """
        Buckets to include in the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "included_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageLocations")
    def included_cloud_storage_locations(self) -> Optional['outputs.ControlProjectIntelligenceConfigFilterIncludedCloudStorageLocations']:
        """
        Locations to include in the Storage Intelligence plan.
        Structure is documented below.
        """
        return pulumi.get(self, "included_cloud_storage_locations")


@pulumi.output_type
class ControlProjectIntelligenceConfigFilterExcludedCloudStorageBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketIdRegexes":
            suggest = "bucket_id_regexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlProjectIntelligenceConfigFilterExcludedCloudStorageBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlProjectIntelligenceConfigFilterExcludedCloudStorageBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlProjectIntelligenceConfigFilterExcludedCloudStorageBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class ControlProjectIntelligenceConfigFilterExcludedCloudStorageLocations(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class ControlProjectIntelligenceConfigFilterIncludedCloudStorageBuckets(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketIdRegexes":
            suggest = "bucket_id_regexes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlProjectIntelligenceConfigFilterIncludedCloudStorageBuckets. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlProjectIntelligenceConfigFilterIncludedCloudStorageBuckets.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlProjectIntelligenceConfigFilterIncludedCloudStorageBuckets.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class ControlProjectIntelligenceConfigFilterIncludedCloudStorageLocations(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class ControlProjectIntelligenceConfigTrialConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ControlProjectIntelligenceConfigTrialConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ControlProjectIntelligenceConfigTrialConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ControlProjectIntelligenceConfigTrialConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str expire_time: (Output)
               The time at which the trial expires.
        """
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[_builtins.str]:
        """
        (Output)
        The time at which the trial expires.
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class DefaultObjectAccessControlProjectTeam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefaultObjectAccessControlProjectTeam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefaultObjectAccessControlProjectTeam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefaultObjectAccessControlProjectTeam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_number: Optional[_builtins.str] = None,
                 team: Optional[_builtins.str] = None):
        """
        :param _builtins.str project_number: The project team associated with the entity
        :param _builtins.str team: The team.
               Possible values are: `editors`, `owners`, `viewers`.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @_builtins.property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[_builtins.str]:
        """
        The project team associated with the entity
        """
        return pulumi.get(self, "project_number")

    @_builtins.property
    @pulumi.getter
    def team(self) -> Optional[_builtins.str]:
        """
        The team.
        Possible values are: `editors`, `owners`, `viewers`.
        """
        return pulumi.get(self, "team")


@pulumi.output_type
class InsightsReportConfigCsvOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerRequired":
            suggest = "header_required"
        elif key == "recordSeparator":
            suggest = "record_separator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InsightsReportConfigCsvOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InsightsReportConfigCsvOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InsightsReportConfigCsvOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[_builtins.str] = None,
                 header_required: Optional[_builtins.bool] = None,
                 record_separator: Optional[_builtins.str] = None):
        """
        :param _builtins.str delimiter: The delimiter used to separate the fields in the inventory report CSV file.
        :param _builtins.bool header_required: The boolean that indicates whether or not headers are included in the inventory report CSV file.
        :param _builtins.str record_separator: The character used to separate the records in the inventory report CSV file.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if header_required is not None:
            pulumi.set(__self__, "header_required", header_required)
        if record_separator is not None:
            pulumi.set(__self__, "record_separator", record_separator)

    @_builtins.property
    @pulumi.getter
    def delimiter(self) -> Optional[_builtins.str]:
        """
        The delimiter used to separate the fields in the inventory report CSV file.
        """
        return pulumi.get(self, "delimiter")

    @_builtins.property
    @pulumi.getter(name="headerRequired")
    def header_required(self) -> Optional[_builtins.bool]:
        """
        The boolean that indicates whether or not headers are included in the inventory report CSV file.
        """
        return pulumi.get(self, "header_required")

    @_builtins.property
    @pulumi.getter(name="recordSeparator")
    def record_separator(self) -> Optional[_builtins.str]:
        """
        The character used to separate the records in the inventory report CSV file.
        """
        return pulumi.get(self, "record_separator")


@pulumi.output_type
class InsightsReportConfigFrequencyOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "startDate":
            suggest = "start_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InsightsReportConfigFrequencyOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InsightsReportConfigFrequencyOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InsightsReportConfigFrequencyOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_date: 'outputs.InsightsReportConfigFrequencyOptionsEndDate',
                 frequency: _builtins.str,
                 start_date: 'outputs.InsightsReportConfigFrequencyOptionsStartDate'):
        """
        :param 'InsightsReportConfigFrequencyOptionsEndDateArgs' end_date: The date to stop generating inventory reports. For example, {"day": 15, "month": 9, "year": 2022}.
               Structure is documented below.
        :param _builtins.str frequency: The frequency in which inventory reports are generated. Values are DAILY or WEEKLY.
               Possible values are: `DAILY`, `WEEKLY`.
        :param 'InsightsReportConfigFrequencyOptionsStartDateArgs' start_date: The date to start generating inventory reports. For example, {"day": 15, "month": 8, "year": 2022}.
               Structure is documented below.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "start_date", start_date)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> 'outputs.InsightsReportConfigFrequencyOptionsEndDate':
        """
        The date to stop generating inventory reports. For example, {"day": 15, "month": 9, "year": 2022}.
        Structure is documented below.
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.str:
        """
        The frequency in which inventory reports are generated. Values are DAILY or WEEKLY.
        Possible values are: `DAILY`, `WEEKLY`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> 'outputs.InsightsReportConfigFrequencyOptionsStartDate':
        """
        The date to start generating inventory reports. For example, {"day": 15, "month": 8, "year": 2022}.
        Structure is documented below.
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class InsightsReportConfigFrequencyOptionsEndDate(dict):
    def __init__(__self__, *,
                 day: _builtins.int,
                 month: _builtins.int,
                 year: _builtins.int):
        """
        :param _builtins.int day: The day of the month to stop generating inventory reports.
        :param _builtins.int month: The month to stop generating inventory reports.
        :param _builtins.int year: The year to stop generating inventory reports
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.int:
        """
        The day of the month to stop generating inventory reports.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def month(self) -> _builtins.int:
        """
        The month to stop generating inventory reports.
        """
        return pulumi.get(self, "month")

    @_builtins.property
    @pulumi.getter
    def year(self) -> _builtins.int:
        """
        The year to stop generating inventory reports
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class InsightsReportConfigFrequencyOptionsStartDate(dict):
    def __init__(__self__, *,
                 day: _builtins.int,
                 month: _builtins.int,
                 year: _builtins.int):
        """
        :param _builtins.int day: The day of the month to start generating inventory reports.
        :param _builtins.int month: The month to start generating inventory reports.
        :param _builtins.int year: The year to start generating inventory reports
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.int:
        """
        The day of the month to start generating inventory reports.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def month(self) -> _builtins.int:
        """
        The month to start generating inventory reports.
        """
        return pulumi.get(self, "month")

    @_builtins.property
    @pulumi.getter
    def year(self) -> _builtins.int:
        """
        The year to start generating inventory reports
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class InsightsReportConfigObjectMetadataReportOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metadataFields":
            suggest = "metadata_fields"
        elif key == "storageDestinationOptions":
            suggest = "storage_destination_options"
        elif key == "storageFilters":
            suggest = "storage_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InsightsReportConfigObjectMetadataReportOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InsightsReportConfigObjectMetadataReportOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InsightsReportConfigObjectMetadataReportOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metadata_fields: Sequence[_builtins.str],
                 storage_destination_options: 'outputs.InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions',
                 storage_filters: Optional['outputs.InsightsReportConfigObjectMetadataReportOptionsStorageFilters'] = None):
        """
        :param Sequence[_builtins.str] metadata_fields: The metadata fields included in an inventory report.
        :param 'InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptionsArgs' storage_destination_options: Options for where the inventory reports are stored.
               Structure is documented below.
        :param 'InsightsReportConfigObjectMetadataReportOptionsStorageFiltersArgs' storage_filters: A nested object resource.
               Structure is documented below.
        """
        pulumi.set(__self__, "metadata_fields", metadata_fields)
        pulumi.set(__self__, "storage_destination_options", storage_destination_options)
        if storage_filters is not None:
            pulumi.set(__self__, "storage_filters", storage_filters)

    @_builtins.property
    @pulumi.getter(name="metadataFields")
    def metadata_fields(self) -> Sequence[_builtins.str]:
        """
        The metadata fields included in an inventory report.
        """
        return pulumi.get(self, "metadata_fields")

    @_builtins.property
    @pulumi.getter(name="storageDestinationOptions")
    def storage_destination_options(self) -> 'outputs.InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions':
        """
        Options for where the inventory reports are stored.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_destination_options")

    @_builtins.property
    @pulumi.getter(name="storageFilters")
    def storage_filters(self) -> Optional['outputs.InsightsReportConfigObjectMetadataReportOptionsStorageFilters']:
        """
        A nested object resource.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_filters")


@pulumi.output_type
class InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationPath":
            suggest = "destination_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InsightsReportConfigObjectMetadataReportOptionsStorageDestinationOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: _builtins.str,
                 destination_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: The destination bucket that stores the generated inventory reports.
        :param _builtins.str destination_path: The path within the destination bucket to store generated inventory reports.
        """
        pulumi.set(__self__, "bucket", bucket)
        if destination_path is not None:
            pulumi.set(__self__, "destination_path", destination_path)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The destination bucket that stores the generated inventory reports.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="destinationPath")
    def destination_path(self) -> Optional[_builtins.str]:
        """
        The path within the destination bucket to store generated inventory reports.
        """
        return pulumi.get(self, "destination_path")


@pulumi.output_type
class InsightsReportConfigObjectMetadataReportOptionsStorageFilters(dict):
    def __init__(__self__, *,
                 bucket: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket: The filter to use when specifying which bucket to generate inventory reports for.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> Optional[_builtins.str]:
        """
        The filter to use when specifying which bucket to generate inventory reports for.
        """
        return pulumi.get(self, "bucket")


@pulumi.output_type
class InsightsReportConfigParquetOptions(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class ManagedFolderIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ManagedFolderIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param _builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class ObjectAccessControlProjectTeam(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectNumber":
            suggest = "project_number"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectAccessControlProjectTeam. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectAccessControlProjectTeam.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectAccessControlProjectTeam.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_number: Optional[_builtins.str] = None,
                 team: Optional[_builtins.str] = None):
        """
        :param _builtins.str project_number: The project team associated with the entity
        :param _builtins.str team: The team.
               Possible values are: `editors`, `owners`, `viewers`.
        """
        if project_number is not None:
            pulumi.set(__self__, "project_number", project_number)
        if team is not None:
            pulumi.set(__self__, "team", team)

    @_builtins.property
    @pulumi.getter(name="projectNumber")
    def project_number(self) -> Optional[_builtins.str]:
        """
        The project team associated with the entity
        """
        return pulumi.get(self, "project_number")

    @_builtins.property
    @pulumi.getter
    def team(self) -> Optional[_builtins.str]:
        """
        The team.
        Possible values are: `editors`, `owners`, `viewers`.
        """
        return pulumi.get(self, "team")


@pulumi.output_type
class TransferAgentPoolBandwidthLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "limitMbps":
            suggest = "limit_mbps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferAgentPoolBandwidthLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferAgentPoolBandwidthLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferAgentPoolBandwidthLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 limit_mbps: _builtins.str):
        """
        :param _builtins.str limit_mbps: Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        pulumi.set(__self__, "limit_mbps", limit_mbps)

    @_builtins.property
    @pulumi.getter(name="limitMbps")
    def limit_mbps(self) -> _builtins.str:
        """
        Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
        """
        return pulumi.get(self, "limit_mbps")


@pulumi.output_type
class TransferJobEventStream(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventStreamExpirationTime":
            suggest = "event_stream_expiration_time"
        elif key == "eventStreamStartTime":
            suggest = "event_stream_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobEventStream. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobEventStream.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobEventStream.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 event_stream_expiration_time: Optional[_builtins.str] = None,
                 event_stream_start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies a unique name of the resource such as AWS SQS ARN in the form 'arn:aws:sqs:region:account_id:queue_name', or Pub/Sub subscription resource name in the form 'projects/{project}/subscriptions/{sub}'.
        :param _builtins.str event_stream_expiration_time: Specifies the data and time at which Storage Transfer Service stops listening for events from this stream. After this time, any transfers in progress will complete, but no new transfers are initiated.A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str event_stream_start_time: Specifies the date and time that Storage Transfer Service starts listening for events from this stream. If no start time is specified or start time is in the past, Storage Transfer Service starts listening immediately. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        pulumi.set(__self__, "name", name)
        if event_stream_expiration_time is not None:
            pulumi.set(__self__, "event_stream_expiration_time", event_stream_expiration_time)
        if event_stream_start_time is not None:
            pulumi.set(__self__, "event_stream_start_time", event_stream_start_time)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies a unique name of the resource such as AWS SQS ARN in the form 'arn:aws:sqs:region:account_id:queue_name', or Pub/Sub subscription resource name in the form 'projects/{project}/subscriptions/{sub}'.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="eventStreamExpirationTime")
    def event_stream_expiration_time(self) -> Optional[_builtins.str]:
        """
        Specifies the data and time at which Storage Transfer Service stops listening for events from this stream. After this time, any transfers in progress will complete, but no new transfers are initiated.A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "event_stream_expiration_time")

    @_builtins.property
    @pulumi.getter(name="eventStreamStartTime")
    def event_stream_start_time(self) -> Optional[_builtins.str]:
        """
        Specifies the date and time that Storage Transfer Service starts listening for events from this stream. If no start time is specified or start time is in the past, Storage Transfer Service starts listening immediately. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "event_stream_start_time")


@pulumi.output_type
class TransferJobLoggingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableOnPremGcsTransferLogs":
            suggest = "enable_on_prem_gcs_transfer_logs"
        elif key == "logActionStates":
            suggest = "log_action_states"
        elif key == "logActions":
            suggest = "log_actions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobLoggingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobLoggingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobLoggingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_on_prem_gcs_transfer_logs: Optional[_builtins.bool] = None,
                 log_action_states: Optional[Sequence[_builtins.str]] = None,
                 log_actions: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.bool enable_on_prem_gcs_transfer_logs: For transfers with a PosixFilesystem source, this option enables the Cloud Storage transfer logs for this transfer.
        :param Sequence[_builtins.str] log_action_states: States in which logActions are logged. Not supported for transfers with PosifxFilesystem data sources; use enable_on_prem_gcs_transfer_logs instead.
        :param Sequence[_builtins.str] log_actions: Specifies the actions to be logged. Not supported for transfers with PosifxFilesystem data sources; use enable_on_prem_gcs_transfer_logs instead.
        """
        if enable_on_prem_gcs_transfer_logs is not None:
            pulumi.set(__self__, "enable_on_prem_gcs_transfer_logs", enable_on_prem_gcs_transfer_logs)
        if log_action_states is not None:
            pulumi.set(__self__, "log_action_states", log_action_states)
        if log_actions is not None:
            pulumi.set(__self__, "log_actions", log_actions)

    @_builtins.property
    @pulumi.getter(name="enableOnPremGcsTransferLogs")
    def enable_on_prem_gcs_transfer_logs(self) -> Optional[_builtins.bool]:
        """
        For transfers with a PosixFilesystem source, this option enables the Cloud Storage transfer logs for this transfer.
        """
        return pulumi.get(self, "enable_on_prem_gcs_transfer_logs")

    @_builtins.property
    @pulumi.getter(name="logActionStates")
    def log_action_states(self) -> Optional[Sequence[_builtins.str]]:
        """
        States in which logActions are logged. Not supported for transfers with PosifxFilesystem data sources; use enable_on_prem_gcs_transfer_logs instead.
        """
        return pulumi.get(self, "log_action_states")

    @_builtins.property
    @pulumi.getter(name="logActions")
    def log_actions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the actions to be logged. Not supported for transfers with PosifxFilesystem data sources; use enable_on_prem_gcs_transfer_logs instead.
        """
        return pulumi.get(self, "log_actions")


@pulumi.output_type
class TransferJobNotificationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "payloadFormat":
            suggest = "payload_format"
        elif key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "eventTypes":
            suggest = "event_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobNotificationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobNotificationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobNotificationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payload_format: _builtins.str,
                 pubsub_topic: _builtins.str,
                 event_types: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str payload_format: The desired format of the notification message payloads. One of "NONE" or "JSON".
        :param _builtins.str pubsub_topic: The Topic.name of the Pub/Sub topic to which to publish notifications. Must be of the format: projects/{project}/topics/{topic}. Not matching this format results in an INVALID_ARGUMENT error.
        :param Sequence[_builtins.str] event_types: Event types for which a notification is desired. If empty, send notifications for all event types. The valid types are "TRANSFER_OPERATION_SUCCESS", "TRANSFER_OPERATION_FAILED", "TRANSFER_OPERATION_ABORTED".
        """
        pulumi.set(__self__, "payload_format", payload_format)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if event_types is not None:
            pulumi.set(__self__, "event_types", event_types)

    @_builtins.property
    @pulumi.getter(name="payloadFormat")
    def payload_format(self) -> _builtins.str:
        """
        The desired format of the notification message payloads. One of "NONE" or "JSON".
        """
        return pulumi.get(self, "payload_format")

    @_builtins.property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> _builtins.str:
        """
        The Topic.name of the Pub/Sub topic to which to publish notifications. Must be of the format: projects/{project}/topics/{topic}. Not matching this format results in an INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "pubsub_topic")

    @_builtins.property
    @pulumi.getter(name="eventTypes")
    def event_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Event types for which a notification is desired. If empty, send notifications for all event types. The valid types are "TRANSFER_OPERATION_SUCCESS", "TRANSFER_OPERATION_FAILED", "TRANSFER_OPERATION_ABORTED".
        """
        return pulumi.get(self, "event_types")


@pulumi.output_type
class TransferJobReplicationSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsDataSink":
            suggest = "gcs_data_sink"
        elif key == "gcsDataSource":
            suggest = "gcs_data_source"
        elif key == "objectConditions":
            suggest = "object_conditions"
        elif key == "transferOptions":
            suggest = "transfer_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobReplicationSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobReplicationSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobReplicationSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_data_sink: Optional['outputs.TransferJobReplicationSpecGcsDataSink'] = None,
                 gcs_data_source: Optional['outputs.TransferJobReplicationSpecGcsDataSource'] = None,
                 object_conditions: Optional['outputs.TransferJobReplicationSpecObjectConditions'] = None,
                 transfer_options: Optional['outputs.TransferJobReplicationSpecTransferOptions'] = None):
        """
        :param 'TransferJobReplicationSpecGcsDataSinkArgs' gcs_data_sink: A Google Cloud Storage data sink. Structure documented below.
        :param 'TransferJobReplicationSpecGcsDataSourceArgs' gcs_data_source: A Google Cloud Storage data source. Structure documented below.
        :param 'TransferJobReplicationSpecObjectConditionsArgs' object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        :param 'TransferJobReplicationSpecTransferOptionsArgs' transfer_options: Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        if gcs_data_sink is not None:
            pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        if gcs_data_source is not None:
            pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        if object_conditions is not None:
            pulumi.set(__self__, "object_conditions", object_conditions)
        if transfer_options is not None:
            pulumi.set(__self__, "transfer_options", transfer_options)

    @_builtins.property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> Optional['outputs.TransferJobReplicationSpecGcsDataSink']:
        """
        A Google Cloud Storage data sink. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_sink")

    @_builtins.property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> Optional['outputs.TransferJobReplicationSpecGcsDataSource']:
        """
        A Google Cloud Storage data source. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_source")

    @_builtins.property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> Optional['outputs.TransferJobReplicationSpecObjectConditions']:
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        """
        return pulumi.get(self, "object_conditions")

    @_builtins.property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> Optional['outputs.TransferJobReplicationSpecTransferOptions']:
        """
        Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        return pulumi.get(self, "transfer_options")


@pulumi.output_type
class TransferJobReplicationSpecGcsDataSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobReplicationSpecGcsDataSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobReplicationSpecGcsDataSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobReplicationSpecGcsDataSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: Google Cloud Storage bucket name.
        :param _builtins.str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Google Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobReplicationSpecGcsDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobReplicationSpecGcsDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobReplicationSpecGcsDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobReplicationSpecGcsDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: Google Cloud Storage bucket name.
        :param _builtins.str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Google Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobReplicationSpecObjectConditions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludePrefixes":
            suggest = "exclude_prefixes"
        elif key == "includePrefixes":
            suggest = "include_prefixes"
        elif key == "lastModifiedBefore":
            suggest = "last_modified_before"
        elif key == "lastModifiedSince":
            suggest = "last_modified_since"
        elif key == "maxTimeElapsedSinceLastModification":
            suggest = "max_time_elapsed_since_last_modification"
        elif key == "minTimeElapsedSinceLastModification":
            suggest = "min_time_elapsed_since_last_modification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobReplicationSpecObjectConditions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobReplicationSpecObjectConditions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobReplicationSpecObjectConditions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_prefixes: Optional[Sequence[_builtins.str]] = None,
                 include_prefixes: Optional[Sequence[_builtins.str]] = None,
                 last_modified_before: Optional[_builtins.str] = None,
                 last_modified_since: Optional[_builtins.str] = None,
                 max_time_elapsed_since_last_modification: Optional[_builtins.str] = None,
                 min_time_elapsed_since_last_modification: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] exclude_prefixes: `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param Sequence[_builtins.str] include_prefixes: If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param _builtins.str last_modified_before: If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str last_modified_since: If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str max_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.str min_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if exclude_prefixes is not None:
            pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        if include_prefixes is not None:
            pulumi.set(__self__, "include_prefixes", include_prefixes)
        if last_modified_before is not None:
            pulumi.set(__self__, "last_modified_before", last_modified_before)
        if last_modified_since is not None:
            pulumi.set(__self__, "last_modified_since", last_modified_since)
        if max_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        if min_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @_builtins.property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "exclude_prefixes")

    @_builtins.property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "include_prefixes")

    @_builtins.property
    @pulumi.getter(name="lastModifiedBefore")
    def last_modified_before(self) -> Optional[_builtins.str]:
        """
        If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_modified_before")

    @_builtins.property
    @pulumi.getter(name="lastModifiedSince")
    def last_modified_since(self) -> Optional[_builtins.str]:
        """
        If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_modified_since")

    @_builtins.property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> Optional[_builtins.str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @_builtins.property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> Optional[_builtins.str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")


@pulumi.output_type
class TransferJobReplicationSpecTransferOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteObjectsFromSourceAfterTransfer":
            suggest = "delete_objects_from_source_after_transfer"
        elif key == "deleteObjectsUniqueInSink":
            suggest = "delete_objects_unique_in_sink"
        elif key == "metadataOptions":
            suggest = "metadata_options"
        elif key == "overwriteObjectsAlreadyExistingInSink":
            suggest = "overwrite_objects_already_existing_in_sink"
        elif key == "overwriteWhen":
            suggest = "overwrite_when"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobReplicationSpecTransferOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobReplicationSpecTransferOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobReplicationSpecTransferOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: Optional[_builtins.bool] = None,
                 delete_objects_unique_in_sink: Optional[_builtins.bool] = None,
                 metadata_options: Optional['outputs.TransferJobReplicationSpecTransferOptionsMetadataOptions'] = None,
                 overwrite_objects_already_existing_in_sink: Optional[_builtins.bool] = None,
                 overwrite_when: Optional[_builtins.str] = None):
        """
        :param _builtins.bool delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        :param _builtins.bool delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. Note that this option and
               `delete_objects_from_source_after_transfer` are mutually exclusive.
        :param 'TransferJobReplicationSpecTransferOptionsMetadataOptionsArgs' metadata_options: Specifies the metadata options for running a transfer
        :param _builtins.bool overwrite_objects_already_existing_in_sink: Whether overwriting objects that already exist in the sink is allowed.
        :param _builtins.str overwrite_when: When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by `overwrite_objects_already_existing_in_sink`. Possible values: ALWAYS, DIFFERENT, NEVER.
        """
        if delete_objects_from_source_after_transfer is not None:
            pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        if delete_objects_unique_in_sink is not None:
            pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if overwrite_objects_already_existing_in_sink is not None:
            pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)
        if overwrite_when is not None:
            pulumi.set(__self__, "overwrite_when", overwrite_when)

    @_builtins.property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> Optional[_builtins.bool]:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @_builtins.property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> Optional[_builtins.bool]:
        """
        Whether objects that exist only in the sink should be deleted. Note that this option and
        `delete_objects_from_source_after_transfer` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional['outputs.TransferJobReplicationSpecTransferOptionsMetadataOptions']:
        """
        Specifies the metadata options for running a transfer
        """
        return pulumi.get(self, "metadata_options")

    @_builtins.property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> Optional[_builtins.bool]:
        """
        Whether overwriting objects that already exist in the sink is allowed.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")

    @_builtins.property
    @pulumi.getter(name="overwriteWhen")
    def overwrite_when(self) -> Optional[_builtins.str]:
        """
        When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by `overwrite_objects_already_existing_in_sink`. Possible values: ALWAYS, DIFFERENT, NEVER.
        """
        return pulumi.get(self, "overwrite_when")


@pulumi.output_type
class TransferJobReplicationSpecTransferOptionsMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "storageClass":
            suggest = "storage_class"
        elif key == "temporaryHold":
            suggest = "temporary_hold"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobReplicationSpecTransferOptionsMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobReplicationSpecTransferOptionsMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobReplicationSpecTransferOptionsMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl: Optional[_builtins.str] = None,
                 gid: Optional[_builtins.str] = None,
                 kms_key: Optional[_builtins.str] = None,
                 mode: Optional[_builtins.str] = None,
                 storage_class: Optional[_builtins.str] = None,
                 symlink: Optional[_builtins.str] = None,
                 temporary_hold: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str acl: Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets
        :param _builtins.str gid: Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer.
        :param _builtins.str kms_key: Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets
        :param _builtins.str mode: Specifies how each file's mode attribute should be handled by the transfer.
        :param _builtins.str storage_class: Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets
        :param _builtins.str symlink: Specifies how symlinks should be handled by the transfer.
        :param _builtins.str temporary_hold: SSpecifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets
        :param _builtins.str time_created: Specifies how each object's timeCreated metadata is preserved for transfers.
        :param _builtins.str uid: Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if symlink is not None:
            pulumi.set(__self__, "symlink", symlink)
        if temporary_hold is not None:
            pulumi.set(__self__, "temporary_hold", temporary_hold)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[_builtins.str]:
        """
        Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def gid(self) -> Optional[_builtins.str]:
        """
        Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer.
        """
        return pulumi.get(self, "gid")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Specifies how each file's mode attribute should be handled by the transfer.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[_builtins.str]:
        """
        Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def symlink(self) -> Optional[_builtins.str]:
        """
        Specifies how symlinks should be handled by the transfer.
        """
        return pulumi.get(self, "symlink")

    @_builtins.property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> Optional[_builtins.str]:
        """
        SSpecifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets
        """
        return pulumi.get(self, "temporary_hold")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        Specifies how each object's timeCreated metadata is preserved for transfers.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class TransferJobSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleStartDate":
            suggest = "schedule_start_date"
        elif key == "repeatInterval":
            suggest = "repeat_interval"
        elif key == "scheduleEndDate":
            suggest = "schedule_end_date"
        elif key == "startTimeOfDay":
            suggest = "start_time_of_day"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_start_date: 'outputs.TransferJobScheduleScheduleStartDate',
                 repeat_interval: Optional[_builtins.str] = None,
                 schedule_end_date: Optional['outputs.TransferJobScheduleScheduleEndDate'] = None,
                 start_time_of_day: Optional['outputs.TransferJobScheduleStartTimeOfDay'] = None):
        """
        :param 'TransferJobScheduleScheduleStartDateArgs' schedule_start_date: The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        :param _builtins.str repeat_interval: Interval between the start of each scheduled transfer. If unspecified, the default value is 24 hours. This value may not be less than 1 hour. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param 'TransferJobScheduleScheduleEndDateArgs' schedule_end_date: The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        :param 'TransferJobScheduleStartTimeOfDayArgs' start_time_of_day: The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        pulumi.set(__self__, "schedule_start_date", schedule_start_date)
        if repeat_interval is not None:
            pulumi.set(__self__, "repeat_interval", repeat_interval)
        if schedule_end_date is not None:
            pulumi.set(__self__, "schedule_end_date", schedule_end_date)
        if start_time_of_day is not None:
            pulumi.set(__self__, "start_time_of_day", start_time_of_day)

    @_builtins.property
    @pulumi.getter(name="scheduleStartDate")
    def schedule_start_date(self) -> 'outputs.TransferJobScheduleScheduleStartDate':
        """
        The first day the recurring transfer is scheduled to run. If `schedule_start_date` is in the past, the transfer will run for the first time on the following day. Structure documented below.
        """
        return pulumi.get(self, "schedule_start_date")

    @_builtins.property
    @pulumi.getter(name="repeatInterval")
    def repeat_interval(self) -> Optional[_builtins.str]:
        """
        Interval between the start of each scheduled transfer. If unspecified, the default value is 24 hours. This value may not be less than 1 hour. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "repeat_interval")

    @_builtins.property
    @pulumi.getter(name="scheduleEndDate")
    def schedule_end_date(self) -> Optional['outputs.TransferJobScheduleScheduleEndDate']:
        """
        The last day the recurring transfer will be run. If `schedule_end_date` is the same as `schedule_start_date`, the transfer will be executed only once. Structure documented below.
        """
        return pulumi.get(self, "schedule_end_date")

    @_builtins.property
    @pulumi.getter(name="startTimeOfDay")
    def start_time_of_day(self) -> Optional['outputs.TransferJobScheduleStartTimeOfDay']:
        """
        The time in UTC at which the transfer will be scheduled to start in a day. Transfers may start later than this time. If not specified, recurring and one-time transfers that are scheduled to run today will run immediately; recurring transfers that are scheduled to run on a future date will start at approximately midnight UTC on that date. Note that when configuring a transfer with the Cloud Platform Console, the transfer's start time in a day is specified in your local timezone. Structure documented below.
        """
        return pulumi.get(self, "start_time_of_day")


@pulumi.output_type
class TransferJobScheduleScheduleEndDate(dict):
    def __init__(__self__, *,
                 day: _builtins.int,
                 month: _builtins.int,
                 year: _builtins.int):
        """
        :param _builtins.int day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param _builtins.int month: Month of year. Must be from 1 to 12.
        :param _builtins.int year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.int:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def month(self) -> _builtins.int:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @_builtins.property
    @pulumi.getter
    def year(self) -> _builtins.int:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class TransferJobScheduleScheduleStartDate(dict):
    def __init__(__self__, *,
                 day: _builtins.int,
                 month: _builtins.int,
                 year: _builtins.int):
        """
        :param _builtins.int day: Day of month. Must be from 1 to 31 and valid for the year and month.
        :param _builtins.int month: Month of year. Must be from 1 to 12.
        :param _builtins.int year: Year of date. Must be from 1 to 9999.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.int:
        """
        Day of month. Must be from 1 to 31 and valid for the year and month.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def month(self) -> _builtins.int:
        """
        Month of year. Must be from 1 to 12.
        """
        return pulumi.get(self, "month")

    @_builtins.property
    @pulumi.getter
    def year(self) -> _builtins.int:
        """
        Year of date. Must be from 1 to 9999.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class TransferJobScheduleStartTimeOfDay(dict):
    def __init__(__self__, *,
                 hours: _builtins.int,
                 minutes: _builtins.int,
                 nanos: _builtins.int,
                 seconds: _builtins.int):
        """
        :param _builtins.int hours: Hours of day in 24 hour format. Should be from 0 to 23.
        :param _builtins.int minutes: Minutes of hour of day. Must be from 0 to 59.
        :param _builtins.int nanos: Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        :param _builtins.int seconds: Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> _builtins.int:
        """
        Hours of day in 24 hour format. Should be from 0 to 23.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> _builtins.int:
        """
        Minutes of hour of day. Must be from 0 to 59.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter
    def nanos(self) -> _builtins.int:
        """
        Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
        """
        return pulumi.get(self, "nanos")

    @_builtins.property
    @pulumi.getter
    def seconds(self) -> _builtins.int:
        """
        Seconds of minutes of the time. Must normally be from 0 to 59.
        """
        return pulumi.get(self, "seconds")


@pulumi.output_type
class TransferJobTransferSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsS3DataSource":
            suggest = "aws_s3_data_source"
        elif key == "azureBlobStorageDataSource":
            suggest = "azure_blob_storage_data_source"
        elif key == "gcsDataSink":
            suggest = "gcs_data_sink"
        elif key == "gcsDataSource":
            suggest = "gcs_data_source"
        elif key == "hdfsDataSource":
            suggest = "hdfs_data_source"
        elif key == "httpDataSource":
            suggest = "http_data_source"
        elif key == "objectConditions":
            suggest = "object_conditions"
        elif key == "posixDataSink":
            suggest = "posix_data_sink"
        elif key == "posixDataSource":
            suggest = "posix_data_source"
        elif key == "sinkAgentPoolName":
            suggest = "sink_agent_pool_name"
        elif key == "sourceAgentPoolName":
            suggest = "source_agent_pool_name"
        elif key == "transferOptions":
            suggest = "transfer_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_s3_data_source: Optional['outputs.TransferJobTransferSpecAwsS3DataSource'] = None,
                 azure_blob_storage_data_source: Optional['outputs.TransferJobTransferSpecAzureBlobStorageDataSource'] = None,
                 gcs_data_sink: Optional['outputs.TransferJobTransferSpecGcsDataSink'] = None,
                 gcs_data_source: Optional['outputs.TransferJobTransferSpecGcsDataSource'] = None,
                 hdfs_data_source: Optional['outputs.TransferJobTransferSpecHdfsDataSource'] = None,
                 http_data_source: Optional['outputs.TransferJobTransferSpecHttpDataSource'] = None,
                 object_conditions: Optional['outputs.TransferJobTransferSpecObjectConditions'] = None,
                 posix_data_sink: Optional['outputs.TransferJobTransferSpecPosixDataSink'] = None,
                 posix_data_source: Optional['outputs.TransferJobTransferSpecPosixDataSource'] = None,
                 sink_agent_pool_name: Optional[_builtins.str] = None,
                 source_agent_pool_name: Optional[_builtins.str] = None,
                 transfer_options: Optional['outputs.TransferJobTransferSpecTransferOptions'] = None):
        """
        :param 'TransferJobTransferSpecAwsS3DataSourceArgs' aws_s3_data_source: An AWS S3 data source. Structure documented below.
        :param 'TransferJobTransferSpecAzureBlobStorageDataSourceArgs' azure_blob_storage_data_source: An Azure Blob Storage data source. Structure documented below.
        :param 'TransferJobTransferSpecGcsDataSinkArgs' gcs_data_sink: A Google Cloud Storage data sink. Structure documented below.
        :param 'TransferJobTransferSpecGcsDataSourceArgs' gcs_data_source: A Google Cloud Storage data source. Structure documented below.
        :param 'TransferJobTransferSpecHdfsDataSourceArgs' hdfs_data_source: An HDFS data source. Structure documented below.
        :param 'TransferJobTransferSpecHttpDataSourceArgs' http_data_source: A HTTP URL data source. Structure documented below.
        :param 'TransferJobTransferSpecObjectConditionsArgs' object_conditions: Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        :param 'TransferJobTransferSpecPosixDataSinkArgs' posix_data_sink: A POSIX data sink. Structure documented below.
        :param 'TransferJobTransferSpecPosixDataSourceArgs' posix_data_source: A POSIX filesystem data source. Structure documented below.
        :param _builtins.str sink_agent_pool_name: Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        :param _builtins.str source_agent_pool_name: Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        :param 'TransferJobTransferSpecTransferOptionsArgs' transfer_options: Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        if aws_s3_data_source is not None:
            pulumi.set(__self__, "aws_s3_data_source", aws_s3_data_source)
        if azure_blob_storage_data_source is not None:
            pulumi.set(__self__, "azure_blob_storage_data_source", azure_blob_storage_data_source)
        if gcs_data_sink is not None:
            pulumi.set(__self__, "gcs_data_sink", gcs_data_sink)
        if gcs_data_source is not None:
            pulumi.set(__self__, "gcs_data_source", gcs_data_source)
        if hdfs_data_source is not None:
            pulumi.set(__self__, "hdfs_data_source", hdfs_data_source)
        if http_data_source is not None:
            pulumi.set(__self__, "http_data_source", http_data_source)
        if object_conditions is not None:
            pulumi.set(__self__, "object_conditions", object_conditions)
        if posix_data_sink is not None:
            pulumi.set(__self__, "posix_data_sink", posix_data_sink)
        if posix_data_source is not None:
            pulumi.set(__self__, "posix_data_source", posix_data_source)
        if sink_agent_pool_name is not None:
            pulumi.set(__self__, "sink_agent_pool_name", sink_agent_pool_name)
        if source_agent_pool_name is not None:
            pulumi.set(__self__, "source_agent_pool_name", source_agent_pool_name)
        if transfer_options is not None:
            pulumi.set(__self__, "transfer_options", transfer_options)

    @_builtins.property
    @pulumi.getter(name="awsS3DataSource")
    def aws_s3_data_source(self) -> Optional['outputs.TransferJobTransferSpecAwsS3DataSource']:
        """
        An AWS S3 data source. Structure documented below.
        """
        return pulumi.get(self, "aws_s3_data_source")

    @_builtins.property
    @pulumi.getter(name="azureBlobStorageDataSource")
    def azure_blob_storage_data_source(self) -> Optional['outputs.TransferJobTransferSpecAzureBlobStorageDataSource']:
        """
        An Azure Blob Storage data source. Structure documented below.
        """
        return pulumi.get(self, "azure_blob_storage_data_source")

    @_builtins.property
    @pulumi.getter(name="gcsDataSink")
    def gcs_data_sink(self) -> Optional['outputs.TransferJobTransferSpecGcsDataSink']:
        """
        A Google Cloud Storage data sink. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_sink")

    @_builtins.property
    @pulumi.getter(name="gcsDataSource")
    def gcs_data_source(self) -> Optional['outputs.TransferJobTransferSpecGcsDataSource']:
        """
        A Google Cloud Storage data source. Structure documented below.
        """
        return pulumi.get(self, "gcs_data_source")

    @_builtins.property
    @pulumi.getter(name="hdfsDataSource")
    def hdfs_data_source(self) -> Optional['outputs.TransferJobTransferSpecHdfsDataSource']:
        """
        An HDFS data source. Structure documented below.
        """
        return pulumi.get(self, "hdfs_data_source")

    @_builtins.property
    @pulumi.getter(name="httpDataSource")
    def http_data_source(self) -> Optional['outputs.TransferJobTransferSpecHttpDataSource']:
        """
        A HTTP URL data source. Structure documented below.
        """
        return pulumi.get(self, "http_data_source")

    @_builtins.property
    @pulumi.getter(name="objectConditions")
    def object_conditions(self) -> Optional['outputs.TransferJobTransferSpecObjectConditions']:
        """
        Only objects that satisfy these object conditions are included in the set of data source and data sink objects. Object conditions based on objects' `last_modification_time` do not exclude objects in a data sink. Structure documented below.
        """
        return pulumi.get(self, "object_conditions")

    @_builtins.property
    @pulumi.getter(name="posixDataSink")
    def posix_data_sink(self) -> Optional['outputs.TransferJobTransferSpecPosixDataSink']:
        """
        A POSIX data sink. Structure documented below.
        """
        return pulumi.get(self, "posix_data_sink")

    @_builtins.property
    @pulumi.getter(name="posixDataSource")
    def posix_data_source(self) -> Optional['outputs.TransferJobTransferSpecPosixDataSource']:
        """
        A POSIX filesystem data source. Structure documented below.
        """
        return pulumi.get(self, "posix_data_source")

    @_builtins.property
    @pulumi.getter(name="sinkAgentPoolName")
    def sink_agent_pool_name(self) -> Optional[_builtins.str]:
        """
        Specifies the agent pool name associated with the posix data sink. When unspecified, the default name is used.
        """
        return pulumi.get(self, "sink_agent_pool_name")

    @_builtins.property
    @pulumi.getter(name="sourceAgentPoolName")
    def source_agent_pool_name(self) -> Optional[_builtins.str]:
        """
        Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
        """
        return pulumi.get(self, "source_agent_pool_name")

    @_builtins.property
    @pulumi.getter(name="transferOptions")
    def transfer_options(self) -> Optional['outputs.TransferJobTransferSpecTransferOptions']:
        """
        Characteristics of how to treat files from datasource and sink during job. If the option `delete_objects_unique_in_sink` is true, object conditions based on objects' `last_modification_time` are ignored and do not exclude objects in a data source or a data sink. Structure documented below.
        """
        return pulumi.get(self, "transfer_options")


@pulumi.output_type
class TransferJobTransferSpecAwsS3DataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "awsAccessKey":
            suggest = "aws_access_key"
        elif key == "managedPrivateNetwork":
            suggest = "managed_private_network"
        elif key == "roleArn":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAwsS3DataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAwsS3DataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAwsS3DataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 aws_access_key: Optional['outputs.TransferJobTransferSpecAwsS3DataSourceAwsAccessKey'] = None,
                 managed_private_network: Optional[_builtins.bool] = None,
                 path: Optional[_builtins.str] = None,
                 role_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: S3 Bucket name.
        :param 'TransferJobTransferSpecAwsS3DataSourceAwsAccessKeyArgs' aws_access_key: AWS credentials block.
        :param _builtins.bool managed_private_network: Egress bytes over a Google-managed private network. This network is shared between other users of Storage Transfer Service.
        :param _builtins.str path: S3 Bucket path in bucket to transfer.
        :param _builtins.str role_arn: The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if aws_access_key is not None:
            pulumi.set(__self__, "aws_access_key", aws_access_key)
        if managed_private_network is not None:
            pulumi.set(__self__, "managed_private_network", managed_private_network)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        S3 Bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter(name="awsAccessKey")
    def aws_access_key(self) -> Optional['outputs.TransferJobTransferSpecAwsS3DataSourceAwsAccessKey']:
        """
        AWS credentials block.
        """
        return pulumi.get(self, "aws_access_key")

    @_builtins.property
    @pulumi.getter(name="managedPrivateNetwork")
    def managed_private_network(self) -> Optional[_builtins.bool]:
        """
        Egress bytes over a Google-managed private network. This network is shared between other users of Storage Transfer Service.
        """
        return pulumi.get(self, "managed_private_network")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        S3 Bucket path in bucket to transfer.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[_builtins.str]:
        """
        The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
        """
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class TransferJobTransferSpecAwsS3DataSourceAwsAccessKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKeyId":
            suggest = "access_key_id"
        elif key == "secretAccessKey":
            suggest = "secret_access_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAwsS3DataSourceAwsAccessKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAwsS3DataSourceAwsAccessKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAwsS3DataSourceAwsAccessKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_key_id: _builtins.str,
                 secret_access_key: _builtins.str):
        """
        :param _builtins.str access_key_id: AWS Key ID.
        :param _builtins.str secret_access_key: AWS Secret Access Key.
        """
        pulumi.set(__self__, "access_key_id", access_key_id)
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @_builtins.property
    @pulumi.getter(name="accessKeyId")
    def access_key_id(self) -> _builtins.str:
        """
        AWS Key ID.
        """
        return pulumi.get(self, "access_key_id")

    @_builtins.property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> _builtins.str:
        """
        AWS Secret Access Key.
        """
        return pulumi.get(self, "secret_access_key")


@pulumi.output_type
class TransferJobTransferSpecAzureBlobStorageDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccount":
            suggest = "storage_account"
        elif key == "azureCredentials":
            suggest = "azure_credentials"
        elif key == "credentialsSecret":
            suggest = "credentials_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAzureBlobStorageDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container: _builtins.str,
                 storage_account: _builtins.str,
                 azure_credentials: Optional['outputs.TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials'] = None,
                 credentials_secret: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str container: The container to transfer from the Azure Storage account.`
        :param _builtins.str storage_account: The name of the Azure Storage account.
        :param 'TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsArgs' azure_credentials: Credentials used to authenticate API requests to Azure block.
        :param _builtins.str credentials_secret: Full Resource name of a secret in Secret Manager containing [SAS Credentials in JSON form](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#azureblobstoragedata:~:text=begin%20with%20a%20%27/%27.-,credentialsSecret,-string). Service Agent for Storage Transfer must have permissions to access secret. If credentials_secret is specified, do not specify azure_credentials.`,
        :param _builtins.str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "storage_account", storage_account)
        if azure_credentials is not None:
            pulumi.set(__self__, "azure_credentials", azure_credentials)
        if credentials_secret is not None:
            pulumi.set(__self__, "credentials_secret", credentials_secret)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def container(self) -> _builtins.str:
        """
        The container to transfer from the Azure Storage account.`
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter(name="storageAccount")
    def storage_account(self) -> _builtins.str:
        """
        The name of the Azure Storage account.
        """
        return pulumi.get(self, "storage_account")

    @_builtins.property
    @pulumi.getter(name="azureCredentials")
    def azure_credentials(self) -> Optional['outputs.TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials']:
        """
        Credentials used to authenticate API requests to Azure block.
        """
        return pulumi.get(self, "azure_credentials")

    @_builtins.property
    @pulumi.getter(name="credentialsSecret")
    def credentials_secret(self) -> Optional[_builtins.str]:
        """
        Full Resource name of a secret in Secret Manager containing [SAS Credentials in JSON form](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#azureblobstoragedata:~:text=begin%20with%20a%20%27/%27.-,credentialsSecret,-string). Service Agent for Storage Transfer must have permissions to access secret. If credentials_secret is specified, do not specify azure_credentials.`,
        """
        return pulumi.get(self, "credentials_secret")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sasToken":
            suggest = "sas_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sas_token: _builtins.str):
        """
        :param _builtins.str sas_token: Azure shared access signature. See [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).
               
               <a name="nested_schedule_start_end_date"></a>The `schedule_start_date` and `schedule_end_date` blocks support:
        """
        pulumi.set(__self__, "sas_token", sas_token)

    @_builtins.property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> _builtins.str:
        """
        Azure shared access signature. See [Grant limited access to Azure Storage resources using shared access signatures (SAS)](https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview).

        <a name="nested_schedule_start_end_date"></a>The `schedule_start_date` and `schedule_end_date` blocks support:
        """
        return pulumi.get(self, "sas_token")


@pulumi.output_type
class TransferJobTransferSpecGcsDataSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecGcsDataSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecGcsDataSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecGcsDataSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: Google Cloud Storage bucket name.
        :param _builtins.str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Google Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobTransferSpecGcsDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecGcsDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecGcsDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecGcsDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: _builtins.str,
                 path: Optional[_builtins.str] = None):
        """
        :param _builtins.str bucket_name: Google Cloud Storage bucket name.
        :param _builtins.str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> _builtins.str:
        """
        Google Cloud Storage bucket name.
        """
        return pulumi.get(self, "bucket_name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobTransferSpecHdfsDataSource(dict):
    def __init__(__self__, *,
                 path: _builtins.str):
        """
        :param _builtins.str path: Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class TransferJobTransferSpecHttpDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "listUrl":
            suggest = "list_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecHttpDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecHttpDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecHttpDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 list_url: _builtins.str):
        """
        :param _builtins.str list_url: The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        pulumi.set(__self__, "list_url", list_url)

    @_builtins.property
    @pulumi.getter(name="listUrl")
    def list_url(self) -> _builtins.str:
        """
        The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
        """
        return pulumi.get(self, "list_url")


@pulumi.output_type
class TransferJobTransferSpecObjectConditions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludePrefixes":
            suggest = "exclude_prefixes"
        elif key == "includePrefixes":
            suggest = "include_prefixes"
        elif key == "lastModifiedBefore":
            suggest = "last_modified_before"
        elif key == "lastModifiedSince":
            suggest = "last_modified_since"
        elif key == "maxTimeElapsedSinceLastModification":
            suggest = "max_time_elapsed_since_last_modification"
        elif key == "minTimeElapsedSinceLastModification":
            suggest = "min_time_elapsed_since_last_modification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecObjectConditions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecObjectConditions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecObjectConditions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_prefixes: Optional[Sequence[_builtins.str]] = None,
                 include_prefixes: Optional[Sequence[_builtins.str]] = None,
                 last_modified_before: Optional[_builtins.str] = None,
                 last_modified_since: Optional[_builtins.str] = None,
                 max_time_elapsed_since_last_modification: Optional[_builtins.str] = None,
                 min_time_elapsed_since_last_modification: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] exclude_prefixes: `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param Sequence[_builtins.str] include_prefixes: If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        :param _builtins.str last_modified_before: If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str last_modified_since: If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param _builtins.str max_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.str min_time_elapsed_since_last_modification: A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        if exclude_prefixes is not None:
            pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        if include_prefixes is not None:
            pulumi.set(__self__, "include_prefixes", include_prefixes)
        if last_modified_before is not None:
            pulumi.set(__self__, "last_modified_before", last_modified_before)
        if last_modified_since is not None:
            pulumi.set(__self__, "last_modified_since", last_modified_since)
        if max_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "max_time_elapsed_since_last_modification", max_time_elapsed_since_last_modification)
        if min_time_elapsed_since_last_modification is not None:
            pulumi.set(__self__, "min_time_elapsed_since_last_modification", min_time_elapsed_since_last_modification)

    @_builtins.property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        `exclude_prefixes` must follow the requirements described for `include_prefixes`. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "exclude_prefixes")

    @_builtins.property
    @pulumi.getter(name="includePrefixes")
    def include_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        If `include_prefixes` is specified, objects that satisfy the object conditions must have names that start with one of the `include_prefixes` and that do not start with any of the `exclude_prefixes`. If `include_prefixes` is not specified, all objects except those that have names starting with one of the `exclude_prefixes` must satisfy the object conditions. See [Requirements](https://cloud.google.com/storage-transfer/docs/reference/rest/v1/TransferSpec#ObjectConditions).
        """
        return pulumi.get(self, "include_prefixes")

    @_builtins.property
    @pulumi.getter(name="lastModifiedBefore")
    def last_modified_before(self) -> Optional[_builtins.str]:
        """
        If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_modified_before")

    @_builtins.property
    @pulumi.getter(name="lastModifiedSince")
    def last_modified_since(self) -> Optional[_builtins.str]:
        """
        If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "last_modified_since")

    @_builtins.property
    @pulumi.getter(name="maxTimeElapsedSinceLastModification")
    def max_time_elapsed_since_last_modification(self) -> Optional[_builtins.str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_time_elapsed_since_last_modification")

    @_builtins.property
    @pulumi.getter(name="minTimeElapsedSinceLastModification")
    def min_time_elapsed_since_last_modification(self) -> Optional[_builtins.str]:
        """
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "min_time_elapsed_since_last_modification")


@pulumi.output_type
class TransferJobTransferSpecPosixDataSink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecPosixDataSink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecPosixDataSink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecPosixDataSink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 root_directory: _builtins.str):
        """
        :param _builtins.str root_directory: Root directory path to the filesystem.
        """
        pulumi.set(__self__, "root_directory", root_directory)

    @_builtins.property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> _builtins.str:
        """
        Root directory path to the filesystem.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class TransferJobTransferSpecPosixDataSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rootDirectory":
            suggest = "root_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecPosixDataSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecPosixDataSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecPosixDataSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 root_directory: _builtins.str):
        """
        :param _builtins.str root_directory: Root directory path to the filesystem.
        """
        pulumi.set(__self__, "root_directory", root_directory)

    @_builtins.property
    @pulumi.getter(name="rootDirectory")
    def root_directory(self) -> _builtins.str:
        """
        Root directory path to the filesystem.
        """
        return pulumi.get(self, "root_directory")


@pulumi.output_type
class TransferJobTransferSpecTransferOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteObjectsFromSourceAfterTransfer":
            suggest = "delete_objects_from_source_after_transfer"
        elif key == "deleteObjectsUniqueInSink":
            suggest = "delete_objects_unique_in_sink"
        elif key == "metadataOptions":
            suggest = "metadata_options"
        elif key == "overwriteObjectsAlreadyExistingInSink":
            suggest = "overwrite_objects_already_existing_in_sink"
        elif key == "overwriteWhen":
            suggest = "overwrite_when"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecTransferOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecTransferOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecTransferOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_objects_from_source_after_transfer: Optional[_builtins.bool] = None,
                 delete_objects_unique_in_sink: Optional[_builtins.bool] = None,
                 metadata_options: Optional['outputs.TransferJobTransferSpecTransferOptionsMetadataOptions'] = None,
                 overwrite_objects_already_existing_in_sink: Optional[_builtins.bool] = None,
                 overwrite_when: Optional[_builtins.str] = None):
        """
        :param _builtins.bool delete_objects_from_source_after_transfer: Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        :param _builtins.bool delete_objects_unique_in_sink: Whether objects that exist only in the sink should be deleted. Note that this option and
               `delete_objects_from_source_after_transfer` are mutually exclusive.
        :param 'TransferJobTransferSpecTransferOptionsMetadataOptionsArgs' metadata_options: Specifies the metadata options for running a transfer
        :param _builtins.bool overwrite_objects_already_existing_in_sink: Whether overwriting objects that already exist in the sink is allowed.
        :param _builtins.str overwrite_when: When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by `overwrite_objects_already_existing_in_sink`. Possible values: ALWAYS, DIFFERENT, NEVER.
        """
        if delete_objects_from_source_after_transfer is not None:
            pulumi.set(__self__, "delete_objects_from_source_after_transfer", delete_objects_from_source_after_transfer)
        if delete_objects_unique_in_sink is not None:
            pulumi.set(__self__, "delete_objects_unique_in_sink", delete_objects_unique_in_sink)
        if metadata_options is not None:
            pulumi.set(__self__, "metadata_options", metadata_options)
        if overwrite_objects_already_existing_in_sink is not None:
            pulumi.set(__self__, "overwrite_objects_already_existing_in_sink", overwrite_objects_already_existing_in_sink)
        if overwrite_when is not None:
            pulumi.set(__self__, "overwrite_when", overwrite_when)

    @_builtins.property
    @pulumi.getter(name="deleteObjectsFromSourceAfterTransfer")
    def delete_objects_from_source_after_transfer(self) -> Optional[_builtins.bool]:
        """
        Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and `delete_objects_unique_in_sink` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_from_source_after_transfer")

    @_builtins.property
    @pulumi.getter(name="deleteObjectsUniqueInSink")
    def delete_objects_unique_in_sink(self) -> Optional[_builtins.bool]:
        """
        Whether objects that exist only in the sink should be deleted. Note that this option and
        `delete_objects_from_source_after_transfer` are mutually exclusive.
        """
        return pulumi.get(self, "delete_objects_unique_in_sink")

    @_builtins.property
    @pulumi.getter(name="metadataOptions")
    def metadata_options(self) -> Optional['outputs.TransferJobTransferSpecTransferOptionsMetadataOptions']:
        """
        Specifies the metadata options for running a transfer
        """
        return pulumi.get(self, "metadata_options")

    @_builtins.property
    @pulumi.getter(name="overwriteObjectsAlreadyExistingInSink")
    def overwrite_objects_already_existing_in_sink(self) -> Optional[_builtins.bool]:
        """
        Whether overwriting objects that already exist in the sink is allowed.
        """
        return pulumi.get(self, "overwrite_objects_already_existing_in_sink")

    @_builtins.property
    @pulumi.getter(name="overwriteWhen")
    def overwrite_when(self) -> Optional[_builtins.str]:
        """
        When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by `overwrite_objects_already_existing_in_sink`. Possible values: ALWAYS, DIFFERENT, NEVER.
        """
        return pulumi.get(self, "overwrite_when")


@pulumi.output_type
class TransferJobTransferSpecTransferOptionsMetadataOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "storageClass":
            suggest = "storage_class"
        elif key == "temporaryHold":
            suggest = "temporary_hold"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransferJobTransferSpecTransferOptionsMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransferJobTransferSpecTransferOptionsMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransferJobTransferSpecTransferOptionsMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acl: Optional[_builtins.str] = None,
                 gid: Optional[_builtins.str] = None,
                 kms_key: Optional[_builtins.str] = None,
                 mode: Optional[_builtins.str] = None,
                 storage_class: Optional[_builtins.str] = None,
                 symlink: Optional[_builtins.str] = None,
                 temporary_hold: Optional[_builtins.str] = None,
                 time_created: Optional[_builtins.str] = None,
                 uid: Optional[_builtins.str] = None):
        """
        :param _builtins.str acl: Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets
        :param _builtins.str gid: Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer.
        :param _builtins.str kms_key: Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets
        :param _builtins.str mode: Specifies how each file's mode attribute should be handled by the transfer.
        :param _builtins.str storage_class: Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets
        :param _builtins.str symlink: Specifies how symlinks should be handled by the transfer.
        :param _builtins.str temporary_hold: SSpecifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets
        :param _builtins.str time_created: Specifies how each object's timeCreated metadata is preserved for transfers.
        :param _builtins.str uid: Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer.
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if symlink is not None:
            pulumi.set(__self__, "symlink", symlink)
        if temporary_hold is not None:
            pulumi.set(__self__, "temporary_hold", temporary_hold)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @_builtins.property
    @pulumi.getter
    def acl(self) -> Optional[_builtins.str]:
        """
        Specifies how each object's ACLs should be preserved for transfers between Google Cloud Storage buckets
        """
        return pulumi.get(self, "acl")

    @_builtins.property
    @pulumi.getter
    def gid(self) -> Optional[_builtins.str]:
        """
        Specifies how each file's POSIX group ID (GID) attribute should be handled by the transfer.
        """
        return pulumi.get(self, "gid")

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[_builtins.str]:
        """
        Specifies how each object's Cloud KMS customer-managed encryption key (CMEK) is preserved for transfers between Google Cloud Storage buckets
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        Specifies how each file's mode attribute should be handled by the transfer.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[_builtins.str]:
        """
        Specifies the storage class to set on objects being transferred to Google Cloud Storage buckets
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def symlink(self) -> Optional[_builtins.str]:
        """
        Specifies how symlinks should be handled by the transfer.
        """
        return pulumi.get(self, "symlink")

    @_builtins.property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> Optional[_builtins.str]:
        """
        SSpecifies how each object's temporary hold status should be preserved for transfers between Google Cloud Storage buckets
        """
        return pulumi.get(self, "temporary_hold")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[_builtins.str]:
        """
        Specifies how each object's timeCreated metadata is preserved for transfers.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[_builtins.str]:
        """
        Specifies how each file's POSIX user ID (UID) attribute should be handled by the transfer.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetBucketAutoclassResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 terminal_storage_class: _builtins.str):
        """
        :param _builtins.bool enabled: While set to true, autoclass automatically transitions objects in your bucket to appropriate storage classes based on each object's access pattern.
        :param _builtins.str terminal_storage_class: The storage class that objects in the bucket eventually transition to if they are not read for a certain length of time. Supported values include: NEARLINE, ARCHIVE.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "terminal_storage_class", terminal_storage_class)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        While set to true, autoclass automatically transitions objects in your bucket to appropriate storage classes based on each object's access pattern.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="terminalStorageClass")
    def terminal_storage_class(self) -> _builtins.str:
        """
        The storage class that objects in the bucket eventually transition to if they are not read for a certain length of time. Supported values include: NEARLINE, ARCHIVE.
        """
        return pulumi.get(self, "terminal_storage_class")


@pulumi.output_type
class GetBucketCorResult(dict):
    def __init__(__self__, *,
                 max_age_seconds: _builtins.int,
                 methods: Sequence[_builtins.str],
                 origins: Sequence[_builtins.str],
                 response_headers: Sequence[_builtins.str]):
        """
        :param _builtins.int max_age_seconds: The value, in seconds, to return in the Access-Control-Max-Age header used in preflight responses.
        :param Sequence[_builtins.str] methods: The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        :param Sequence[_builtins.str] origins: The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        :param Sequence[_builtins.str] response_headers: The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
        """
        pulumi.set(__self__, "max_age_seconds", max_age_seconds)
        pulumi.set(__self__, "methods", methods)
        pulumi.set(__self__, "origins", origins)
        pulumi.set(__self__, "response_headers", response_headers)

    @_builtins.property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> _builtins.int:
        """
        The value, in seconds, to return in the Access-Control-Max-Age header used in preflight responses.
        """
        return pulumi.get(self, "max_age_seconds")

    @_builtins.property
    @pulumi.getter
    def methods(self) -> Sequence[_builtins.str]:
        """
        The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
        """
        return pulumi.get(self, "methods")

    @_builtins.property
    @pulumi.getter
    def origins(self) -> Sequence[_builtins.str]:
        """
        The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
        """
        return pulumi.get(self, "origins")

    @_builtins.property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Sequence[_builtins.str]:
        """
        The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
        """
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class GetBucketCustomPlacementConfigResult(dict):
    def __init__(__self__, *,
                 data_locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] data_locations: The list of individual regions that comprise a dual-region bucket. See the docs for a list of acceptable regions. Note: If any of the data_locations changes, it will recreate the bucket.
        """
        pulumi.set(__self__, "data_locations", data_locations)

    @_builtins.property
    @pulumi.getter(name="dataLocations")
    def data_locations(self) -> Sequence[_builtins.str]:
        """
        The list of individual regions that comprise a dual-region bucket. See the docs for a list of acceptable regions. Note: If any of the data_locations changes, it will recreate the bucket.
        """
        return pulumi.get(self, "data_locations")


@pulumi.output_type
class GetBucketEncryptionResult(dict):
    def __init__(__self__, *,
                 default_kms_key_name: _builtins.str):
        """
        :param _builtins.str default_kms_key_name: A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified. You must pay attention to whether the crypto key is available in the location that this bucket is created in. See the docs for more details.
        """
        pulumi.set(__self__, "default_kms_key_name", default_kms_key_name)

    @_builtins.property
    @pulumi.getter(name="defaultKmsKeyName")
    def default_kms_key_name(self) -> _builtins.str:
        """
        A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified. You must pay attention to whether the crypto key is available in the location that this bucket is created in. See the docs for more details.
        """
        return pulumi.get(self, "default_kms_key_name")


@pulumi.output_type
class GetBucketHierarchicalNamespaceResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: Set this field true to organize bucket with logical file system structure.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Set this field true to organize bucket with logical file system structure.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetBucketIpFilterResult(dict):
    def __init__(__self__, *,
                 allow_all_service_agent_access: _builtins.bool,
                 allow_cross_org_vpcs: _builtins.bool,
                 mode: _builtins.str,
                 public_network_sources: Sequence['outputs.GetBucketIpFilterPublicNetworkSourceResult'],
                 vpc_network_sources: Sequence['outputs.GetBucketIpFilterVpcNetworkSourceResult']):
        """
        :param _builtins.bool allow_all_service_agent_access: Whether to allow all service agents to access the bucket regardless of the IP filter configuration.
        :param _builtins.bool allow_cross_org_vpcs: Whether to allow cross-org VPCs in the bucket's IP filter configuration.
        :param _builtins.str mode: The mode of the IP filter. Valid values are 'Enabled' and 'Disabled'.
        :param Sequence['GetBucketIpFilterPublicNetworkSourceArgs'] public_network_sources: The public network IP address ranges that can access the bucket and its data.
        :param Sequence['GetBucketIpFilterVpcNetworkSourceArgs'] vpc_network_sources: The list of VPC networks that can access the bucket.
        """
        pulumi.set(__self__, "allow_all_service_agent_access", allow_all_service_agent_access)
        pulumi.set(__self__, "allow_cross_org_vpcs", allow_cross_org_vpcs)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "public_network_sources", public_network_sources)
        pulumi.set(__self__, "vpc_network_sources", vpc_network_sources)

    @_builtins.property
    @pulumi.getter(name="allowAllServiceAgentAccess")
    def allow_all_service_agent_access(self) -> _builtins.bool:
        """
        Whether to allow all service agents to access the bucket regardless of the IP filter configuration.
        """
        return pulumi.get(self, "allow_all_service_agent_access")

    @_builtins.property
    @pulumi.getter(name="allowCrossOrgVpcs")
    def allow_cross_org_vpcs(self) -> _builtins.bool:
        """
        Whether to allow cross-org VPCs in the bucket's IP filter configuration.
        """
        return pulumi.get(self, "allow_cross_org_vpcs")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The mode of the IP filter. Valid values are 'Enabled' and 'Disabled'.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="publicNetworkSources")
    def public_network_sources(self) -> Sequence['outputs.GetBucketIpFilterPublicNetworkSourceResult']:
        """
        The public network IP address ranges that can access the bucket and its data.
        """
        return pulumi.get(self, "public_network_sources")

    @_builtins.property
    @pulumi.getter(name="vpcNetworkSources")
    def vpc_network_sources(self) -> Sequence['outputs.GetBucketIpFilterVpcNetworkSourceResult']:
        """
        The list of VPC networks that can access the bucket.
        """
        return pulumi.get(self, "vpc_network_sources")


@pulumi.output_type
class GetBucketIpFilterPublicNetworkSourceResult(dict):
    def __init__(__self__, *,
                 allowed_ip_cidr_ranges: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] allowed_ip_cidr_ranges: The list of public IPv4, IPv6 cidr ranges that are allowed to access the bucket.
        """
        pulumi.set(__self__, "allowed_ip_cidr_ranges", allowed_ip_cidr_ranges)

    @_builtins.property
    @pulumi.getter(name="allowedIpCidrRanges")
    def allowed_ip_cidr_ranges(self) -> Sequence[_builtins.str]:
        """
        The list of public IPv4, IPv6 cidr ranges that are allowed to access the bucket.
        """
        return pulumi.get(self, "allowed_ip_cidr_ranges")


@pulumi.output_type
class GetBucketIpFilterVpcNetworkSourceResult(dict):
    def __init__(__self__, *,
                 allowed_ip_cidr_ranges: Sequence[_builtins.str],
                 network: _builtins.str):
        """
        :param Sequence[_builtins.str] allowed_ip_cidr_ranges: The list of public or private IPv4 and IPv6 CIDR ranges that can access the bucket.
        :param _builtins.str network: Name of the network. Format: projects/{PROJECT_ID}/global/networks/{NETWORK_NAME}
        """
        pulumi.set(__self__, "allowed_ip_cidr_ranges", allowed_ip_cidr_ranges)
        pulumi.set(__self__, "network", network)

    @_builtins.property
    @pulumi.getter(name="allowedIpCidrRanges")
    def allowed_ip_cidr_ranges(self) -> Sequence[_builtins.str]:
        """
        The list of public or private IPv4 and IPv6 CIDR ranges that can access the bucket.
        """
        return pulumi.get(self, "allowed_ip_cidr_ranges")

    @_builtins.property
    @pulumi.getter
    def network(self) -> _builtins.str:
        """
        Name of the network. Format: projects/{PROJECT_ID}/global/networks/{NETWORK_NAME}
        """
        return pulumi.get(self, "network")


@pulumi.output_type
class GetBucketLifecycleRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetBucketLifecycleRuleActionResult'],
                 conditions: Sequence['outputs.GetBucketLifecycleRuleConditionResult']):
        """
        :param Sequence['GetBucketLifecycleRuleActionArgs'] actions: The Lifecycle Rule's action configuration. A single block of this type is supported.
        :param Sequence['GetBucketLifecycleRuleConditionArgs'] conditions: The Lifecycle Rule's condition configuration.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "conditions", conditions)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetBucketLifecycleRuleActionResult']:
        """
        The Lifecycle Rule's action configuration. A single block of this type is supported.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.GetBucketLifecycleRuleConditionResult']:
        """
        The Lifecycle Rule's condition configuration.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class GetBucketLifecycleRuleActionResult(dict):
    def __init__(__self__, *,
                 storage_class: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str storage_class: The target Storage Class of objects affected by this Lifecycle Rule. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
        :param _builtins.str type: The type of the action of this Lifecycle Rule. Supported values include: Delete, SetStorageClass and AbortIncompleteMultipartUpload.
        """
        pulumi.set(__self__, "storage_class", storage_class)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The target Storage Class of objects affected by this Lifecycle Rule. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
        """
        return pulumi.get(self, "storage_class")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the action of this Lifecycle Rule. Supported values include: Delete, SetStorageClass and AbortIncompleteMultipartUpload.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetBucketLifecycleRuleConditionResult(dict):
    def __init__(__self__, *,
                 age: _builtins.int,
                 created_before: _builtins.str,
                 custom_time_before: _builtins.str,
                 days_since_custom_time: _builtins.int,
                 days_since_noncurrent_time: _builtins.int,
                 matches_prefixes: Sequence[_builtins.str],
                 matches_storage_classes: Sequence[_builtins.str],
                 matches_suffixes: Sequence[_builtins.str],
                 noncurrent_time_before: _builtins.str,
                 num_newer_versions: _builtins.int,
                 send_age_if_zero: _builtins.bool,
                 send_days_since_custom_time_if_zero: _builtins.bool,
                 send_days_since_noncurrent_time_if_zero: _builtins.bool,
                 send_num_newer_versions_if_zero: _builtins.bool,
                 with_state: _builtins.str):
        """
        :param _builtins.int age: Minimum age of an object in days to satisfy this condition.
        :param _builtins.str created_before: Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        :param _builtins.str custom_time_before: Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        :param _builtins.int days_since_custom_time: Number of days elapsed since the user-specified timestamp set on an object.
        :param _builtins.int days_since_noncurrent_time: Number of days elapsed since the noncurrent timestamp of an object. This
               										condition is relevant only for versioned objects.
        :param Sequence[_builtins.str] matches_prefixes: One or more matching name prefixes to satisfy this condition.
        :param Sequence[_builtins.str] matches_storage_classes: Storage Class of objects to satisfy this condition. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, DURABLE_REDUCED_AVAILABILITY.
        :param Sequence[_builtins.str] matches_suffixes: One or more matching name suffixes to satisfy this condition.
        :param _builtins.str noncurrent_time_before: Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        :param _builtins.int num_newer_versions: Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        :param _builtins.bool send_age_if_zero: While set true, age value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the age field. It can be used alone or together with age.
        :param _builtins.bool send_days_since_custom_time_if_zero: While set true, days_since_custom_time value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the days_since_custom_time field. It can be used alone or together with days_since_custom_time.
        :param _builtins.bool send_days_since_noncurrent_time_if_zero: While set true, days_since_noncurrent_time value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the days_since_noncurrent_time field. It can be used alone or together with days_since_noncurrent_time.
        :param _builtins.bool send_num_newer_versions_if_zero: While set true, num_newer_versions value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the num_newer_versions field. It can be used alone or together with num_newer_versions.
        :param _builtins.str with_state: Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: "LIVE", "ARCHIVED", "ANY".
        """
        pulumi.set(__self__, "age", age)
        pulumi.set(__self__, "created_before", created_before)
        pulumi.set(__self__, "custom_time_before", custom_time_before)
        pulumi.set(__self__, "days_since_custom_time", days_since_custom_time)
        pulumi.set(__self__, "days_since_noncurrent_time", days_since_noncurrent_time)
        pulumi.set(__self__, "matches_prefixes", matches_prefixes)
        pulumi.set(__self__, "matches_storage_classes", matches_storage_classes)
        pulumi.set(__self__, "matches_suffixes", matches_suffixes)
        pulumi.set(__self__, "noncurrent_time_before", noncurrent_time_before)
        pulumi.set(__self__, "num_newer_versions", num_newer_versions)
        pulumi.set(__self__, "send_age_if_zero", send_age_if_zero)
        pulumi.set(__self__, "send_days_since_custom_time_if_zero", send_days_since_custom_time_if_zero)
        pulumi.set(__self__, "send_days_since_noncurrent_time_if_zero", send_days_since_noncurrent_time_if_zero)
        pulumi.set(__self__, "send_num_newer_versions_if_zero", send_num_newer_versions_if_zero)
        pulumi.set(__self__, "with_state", with_state)

    @_builtins.property
    @pulumi.getter
    def age(self) -> _builtins.int:
        """
        Minimum age of an object in days to satisfy this condition.
        """
        return pulumi.get(self, "age")

    @_builtins.property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> _builtins.str:
        """
        Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        """
        return pulumi.get(self, "created_before")

    @_builtins.property
    @pulumi.getter(name="customTimeBefore")
    def custom_time_before(self) -> _builtins.str:
        """
        Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        """
        return pulumi.get(self, "custom_time_before")

    @_builtins.property
    @pulumi.getter(name="daysSinceCustomTime")
    def days_since_custom_time(self) -> _builtins.int:
        """
        Number of days elapsed since the user-specified timestamp set on an object.
        """
        return pulumi.get(self, "days_since_custom_time")

    @_builtins.property
    @pulumi.getter(name="daysSinceNoncurrentTime")
    def days_since_noncurrent_time(self) -> _builtins.int:
        """
        Number of days elapsed since the noncurrent timestamp of an object. This
        										condition is relevant only for versioned objects.
        """
        return pulumi.get(self, "days_since_noncurrent_time")

    @_builtins.property
    @pulumi.getter(name="matchesPrefixes")
    def matches_prefixes(self) -> Sequence[_builtins.str]:
        """
        One or more matching name prefixes to satisfy this condition.
        """
        return pulumi.get(self, "matches_prefixes")

    @_builtins.property
    @pulumi.getter(name="matchesStorageClasses")
    def matches_storage_classes(self) -> Sequence[_builtins.str]:
        """
        Storage Class of objects to satisfy this condition. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, DURABLE_REDUCED_AVAILABILITY.
        """
        return pulumi.get(self, "matches_storage_classes")

    @_builtins.property
    @pulumi.getter(name="matchesSuffixes")
    def matches_suffixes(self) -> Sequence[_builtins.str]:
        """
        One or more matching name suffixes to satisfy this condition.
        """
        return pulumi.get(self, "matches_suffixes")

    @_builtins.property
    @pulumi.getter(name="noncurrentTimeBefore")
    def noncurrent_time_before(self) -> _builtins.str:
        """
        Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
        """
        return pulumi.get(self, "noncurrent_time_before")

    @_builtins.property
    @pulumi.getter(name="numNewerVersions")
    def num_newer_versions(self) -> _builtins.int:
        """
        Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
        """
        return pulumi.get(self, "num_newer_versions")

    @_builtins.property
    @pulumi.getter(name="sendAgeIfZero")
    def send_age_if_zero(self) -> _builtins.bool:
        """
        While set true, age value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the age field. It can be used alone or together with age.
        """
        return pulumi.get(self, "send_age_if_zero")

    @_builtins.property
    @pulumi.getter(name="sendDaysSinceCustomTimeIfZero")
    def send_days_since_custom_time_if_zero(self) -> _builtins.bool:
        """
        While set true, days_since_custom_time value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the days_since_custom_time field. It can be used alone or together with days_since_custom_time.
        """
        return pulumi.get(self, "send_days_since_custom_time_if_zero")

    @_builtins.property
    @pulumi.getter(name="sendDaysSinceNoncurrentTimeIfZero")
    def send_days_since_noncurrent_time_if_zero(self) -> _builtins.bool:
        """
        While set true, days_since_noncurrent_time value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the days_since_noncurrent_time field. It can be used alone or together with days_since_noncurrent_time.
        """
        return pulumi.get(self, "send_days_since_noncurrent_time_if_zero")

    @_builtins.property
    @pulumi.getter(name="sendNumNewerVersionsIfZero")
    def send_num_newer_versions_if_zero(self) -> _builtins.bool:
        """
        While set true, num_newer_versions value will be sent in the request even for zero value of the field. This field is only useful for setting 0 value to the num_newer_versions field. It can be used alone or together with num_newer_versions.
        """
        return pulumi.get(self, "send_num_newer_versions_if_zero")

    @_builtins.property
    @pulumi.getter(name="withState")
    def with_state(self) -> _builtins.str:
        """
        Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: "LIVE", "ARCHIVED", "ANY".
        """
        return pulumi.get(self, "with_state")


@pulumi.output_type
class GetBucketLoggingResult(dict):
    def __init__(__self__, *,
                 log_bucket: _builtins.str,
                 log_object_prefix: _builtins.str):
        """
        :param _builtins.str log_bucket: The bucket that will receive log objects.
        :param _builtins.str log_object_prefix: The object prefix for log objects. If it's not provided, by default Google Cloud Storage sets this to this bucket's name.
        """
        pulumi.set(__self__, "log_bucket", log_bucket)
        pulumi.set(__self__, "log_object_prefix", log_object_prefix)

    @_builtins.property
    @pulumi.getter(name="logBucket")
    def log_bucket(self) -> _builtins.str:
        """
        The bucket that will receive log objects.
        """
        return pulumi.get(self, "log_bucket")

    @_builtins.property
    @pulumi.getter(name="logObjectPrefix")
    def log_object_prefix(self) -> _builtins.str:
        """
        The object prefix for log objects. If it's not provided, by default Google Cloud Storage sets this to this bucket's name.
        """
        return pulumi.get(self, "log_object_prefix")


@pulumi.output_type
class GetBucketObjectContentCustomerEncryptionResult(dict):
    def __init__(__self__, *,
                 encryption_algorithm: _builtins.str,
                 encryption_key: _builtins.str):
        """
        :param _builtins.str encryption_algorithm: The encryption algorithm. Default: AES256
        :param _builtins.str encryption_key: Base64 encoded customer supplied encryption key.
        """
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "encryption_key", encryption_key)

    @_builtins.property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> _builtins.str:
        """
        The encryption algorithm. Default: AES256
        """
        return pulumi.get(self, "encryption_algorithm")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> _builtins.str:
        """
        Base64 encoded customer supplied encryption key.
        """
        return pulumi.get(self, "encryption_key")


@pulumi.output_type
class GetBucketObjectContentRetentionResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.str,
                 retain_until_time: _builtins.str):
        """
        :param _builtins.str mode: The object retention mode. Supported values include: "Unlocked", "Locked".
        :param _builtins.str retain_until_time: Time in RFC 3339 (e.g. 2030-01-01T02:03:04Z) until which object retention protects this object.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "retain_until_time", retain_until_time)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The object retention mode. Supported values include: "Unlocked", "Locked".
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="retainUntilTime")
    def retain_until_time(self) -> _builtins.str:
        """
        Time in RFC 3339 (e.g. 2030-01-01T02:03:04Z) until which object retention protects this object.
        """
        return pulumi.get(self, "retain_until_time")


@pulumi.output_type
class GetBucketObjectCustomerEncryptionResult(dict):
    def __init__(__self__, *,
                 encryption_algorithm: _builtins.str,
                 encryption_key: _builtins.str):
        """
        :param _builtins.str encryption_algorithm: The encryption algorithm. Default: AES256
        :param _builtins.str encryption_key: Base64 encoded customer supplied encryption key.
        """
        pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        pulumi.set(__self__, "encryption_key", encryption_key)

    @_builtins.property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> _builtins.str:
        """
        The encryption algorithm. Default: AES256
        """
        return pulumi.get(self, "encryption_algorithm")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> _builtins.str:
        """
        Base64 encoded customer supplied encryption key.
        """
        return pulumi.get(self, "encryption_key")


@pulumi.output_type
class GetBucketObjectRetentionResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.str,
                 retain_until_time: _builtins.str):
        """
        :param _builtins.str mode: The object retention mode. Supported values include: "Unlocked", "Locked".
        :param _builtins.str retain_until_time: Time in RFC 3339 (e.g. 2030-01-01T02:03:04Z) until which object retention protects this object.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "retain_until_time", retain_until_time)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The object retention mode. Supported values include: "Unlocked", "Locked".
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="retainUntilTime")
    def retain_until_time(self) -> _builtins.str:
        """
        Time in RFC 3339 (e.g. 2030-01-01T02:03:04Z) until which object retention protects this object.
        """
        return pulumi.get(self, "retain_until_time")


@pulumi.output_type
class GetBucketObjectsBucketObjectResult(dict):
    def __init__(__self__, *,
                 content_type: _builtins.str,
                 media_link: _builtins.str,
                 name: _builtins.str,
                 self_link: _builtins.str,
                 storage_class: _builtins.str):
        """
        :param _builtins.str content_type: [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data.
        :param _builtins.str media_link: A url reference to download this object.
        :param _builtins.str name: The name of the object.
        :param _builtins.str self_link: A url reference to this object.
        :param _builtins.str storage_class: The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the bucket object.
        """
        pulumi.set(__self__, "content_type", content_type)
        pulumi.set(__self__, "media_link", media_link)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> _builtins.str:
        """
        [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> _builtins.str:
        """
        A url reference to download this object.
        """
        return pulumi.get(self, "media_link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the object.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        A url reference to this object.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the bucket object.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetBucketRetentionPolicyResult(dict):
    def __init__(__self__, *,
                 is_locked: _builtins.bool,
                 retention_period: _builtins.int):
        """
        :param _builtins.bool is_locked: If set to true, the bucket will be locked and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        :param _builtins.int retention_period: The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 3,155,760,000 seconds.
        """
        pulumi.set(__self__, "is_locked", is_locked)
        pulumi.set(__self__, "retention_period", retention_period)

    @_builtins.property
    @pulumi.getter(name="isLocked")
    def is_locked(self) -> _builtins.bool:
        """
        If set to true, the bucket will be locked and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
        """
        return pulumi.get(self, "is_locked")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> _builtins.int:
        """
        The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 3,155,760,000 seconds.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class GetBucketSoftDeletePolicyResult(dict):
    def __init__(__self__, *,
                 effective_time: _builtins.str,
                 retention_duration_seconds: _builtins.int):
        """
        :param _builtins.str effective_time: Server-determined value that indicates the time from which the policy, or one with a greater retention, was effective. This value is in RFC 3339 format.
        :param _builtins.int retention_duration_seconds: The duration in seconds that soft-deleted objects in the bucket will be retained and cannot be permanently deleted. Default value is 604800.
        """
        pulumi.set(__self__, "effective_time", effective_time)
        pulumi.set(__self__, "retention_duration_seconds", retention_duration_seconds)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> _builtins.str:
        """
        Server-determined value that indicates the time from which the policy, or one with a greater retention, was effective. This value is in RFC 3339 format.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter(name="retentionDurationSeconds")
    def retention_duration_seconds(self) -> _builtins.int:
        """
        The duration in seconds that soft-deleted objects in the bucket will be retained and cannot be permanently deleted. Default value is 604800.
        """
        return pulumi.get(self, "retention_duration_seconds")


@pulumi.output_type
class GetBucketVersioningResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool):
        """
        :param _builtins.bool enabled: While set to true, versioning is fully enabled for this bucket.
        """
        pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        While set to true, versioning is fully enabled for this bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetBucketWebsiteResult(dict):
    def __init__(__self__, *,
                 main_page_suffix: _builtins.str,
                 not_found_page: _builtins.str):
        """
        :param _builtins.str main_page_suffix: Behaves as the bucket's directory index where missing objects are treated as potential directories.
        :param _builtins.str not_found_page: The custom object to return when a requested resource is not found.
        """
        pulumi.set(__self__, "main_page_suffix", main_page_suffix)
        pulumi.set(__self__, "not_found_page", not_found_page)

    @_builtins.property
    @pulumi.getter(name="mainPageSuffix")
    def main_page_suffix(self) -> _builtins.str:
        """
        Behaves as the bucket's directory index where missing objects are treated as potential directories.
        """
        return pulumi.get(self, "main_page_suffix")

    @_builtins.property
    @pulumi.getter(name="notFoundPage")
    def not_found_page(self) -> _builtins.str:
        """
        The custom object to return when a requested resource is not found.
        """
        return pulumi.get(self, "not_found_page")


@pulumi.output_type
class GetBucketsBucketResult(dict):
    def __init__(__self__, *,
                 labels: Mapping[str, _builtins.str],
                 location: _builtins.str,
                 name: _builtins.str,
                 self_link: _builtins.str,
                 storage_class: _builtins.str):
        """
        :param Mapping[str, _builtins.str] labels: User-provided bucket labels, in key/value pairs.
        :param _builtins.str location: The location of the bucket.
        :param _builtins.str name: The name of the bucket.
        :param _builtins.str self_link: A url reference to the bucket.
        :param _builtins.str storage_class: The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the bucket.
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "storage_class", storage_class)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Mapping[str, _builtins.str]:
        """
        User-provided bucket labels, in key/value pairs.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The location of the bucket.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> _builtins.str:
        """
        A url reference to the bucket.
        """
        return pulumi.get(self, "self_link")

    @_builtins.property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> _builtins.str:
        """
        The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the bucket.
        """
        return pulumi.get(self, "storage_class")


@pulumi.output_type
class GetControlFolderIntelligenceConfigEffectiveIntelligenceConfigResult(dict):
    def __init__(__self__, *,
                 effective_edition: _builtins.str,
                 intelligence_config: _builtins.str):
        """
        :param _builtins.str effective_edition: The 'StorageIntelligence' edition that is applicable for the resource.
        :param _builtins.str intelligence_config: The Intelligence config resource that is applied for the target resource.
        """
        pulumi.set(__self__, "effective_edition", effective_edition)
        pulumi.set(__self__, "intelligence_config", intelligence_config)

    @_builtins.property
    @pulumi.getter(name="effectiveEdition")
    def effective_edition(self) -> _builtins.str:
        """
        The 'StorageIntelligence' edition that is applicable for the resource.
        """
        return pulumi.get(self, "effective_edition")

    @_builtins.property
    @pulumi.getter(name="intelligenceConfig")
    def intelligence_config(self) -> _builtins.str:
        """
        The Intelligence config resource that is applied for the target resource.
        """
        return pulumi.get(self, "intelligence_config")


@pulumi.output_type
class GetControlFolderIntelligenceConfigFilterResult(dict):
    def __init__(__self__, *,
                 excluded_cloud_storage_buckets: Sequence['outputs.GetControlFolderIntelligenceConfigFilterExcludedCloudStorageBucketResult'],
                 excluded_cloud_storage_locations: Sequence['outputs.GetControlFolderIntelligenceConfigFilterExcludedCloudStorageLocationResult'],
                 included_cloud_storage_buckets: Sequence['outputs.GetControlFolderIntelligenceConfigFilterIncludedCloudStorageBucketResult'],
                 included_cloud_storage_locations: Sequence['outputs.GetControlFolderIntelligenceConfigFilterIncludedCloudStorageLocationResult']):
        """
        :param Sequence['GetControlFolderIntelligenceConfigFilterExcludedCloudStorageBucketArgs'] excluded_cloud_storage_buckets: Buckets to exclude from the Storage Intelligence plan.
        :param Sequence['GetControlFolderIntelligenceConfigFilterExcludedCloudStorageLocationArgs'] excluded_cloud_storage_locations: Locations to exclude from the Storage Intelligence plan.
        :param Sequence['GetControlFolderIntelligenceConfigFilterIncludedCloudStorageBucketArgs'] included_cloud_storage_buckets: Buckets to include in the Storage Intelligence plan.
        :param Sequence['GetControlFolderIntelligenceConfigFilterIncludedCloudStorageLocationArgs'] included_cloud_storage_locations: Locations to include in the Storage Intelligence plan.
        """
        pulumi.set(__self__, "excluded_cloud_storage_buckets", excluded_cloud_storage_buckets)
        pulumi.set(__self__, "excluded_cloud_storage_locations", excluded_cloud_storage_locations)
        pulumi.set(__self__, "included_cloud_storage_buckets", included_cloud_storage_buckets)
        pulumi.set(__self__, "included_cloud_storage_locations", included_cloud_storage_locations)

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageBuckets")
    def excluded_cloud_storage_buckets(self) -> Sequence['outputs.GetControlFolderIntelligenceConfigFilterExcludedCloudStorageBucketResult']:
        """
        Buckets to exclude from the Storage Intelligence plan.
        """
        return pulumi.get(self, "excluded_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageLocations")
    def excluded_cloud_storage_locations(self) -> Sequence['outputs.GetControlFolderIntelligenceConfigFilterExcludedCloudStorageLocationResult']:
        """
        Locations to exclude from the Storage Intelligence plan.
        """
        return pulumi.get(self, "excluded_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageBuckets")
    def included_cloud_storage_buckets(self) -> Sequence['outputs.GetControlFolderIntelligenceConfigFilterIncludedCloudStorageBucketResult']:
        """
        Buckets to include in the Storage Intelligence plan.
        """
        return pulumi.get(self, "included_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageLocations")
    def included_cloud_storage_locations(self) -> Sequence['outputs.GetControlFolderIntelligenceConfigFilterIncludedCloudStorageLocationResult']:
        """
        Locations to include in the Storage Intelligence plan.
        """
        return pulumi.get(self, "included_cloud_storage_locations")


@pulumi.output_type
class GetControlFolderIntelligenceConfigFilterExcludedCloudStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class GetControlFolderIntelligenceConfigFilterExcludedCloudStorageLocationResult(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class GetControlFolderIntelligenceConfigFilterIncludedCloudStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class GetControlFolderIntelligenceConfigFilterIncludedCloudStorageLocationResult(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class GetControlFolderIntelligenceConfigTrialConfigResult(dict):
    def __init__(__self__, *,
                 expire_time: _builtins.str):
        """
        :param _builtins.str expire_time: The time at which the trial expires.
        """
        pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The time at which the trial expires.
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class GetControlOrganizationIntelligenceConfigEffectiveIntelligenceConfigResult(dict):
    def __init__(__self__, *,
                 effective_edition: _builtins.str,
                 intelligence_config: _builtins.str):
        """
        :param _builtins.str effective_edition: The 'StorageIntelligence' edition that is applicable for the resource.
        :param _builtins.str intelligence_config: The Intelligence config resource that is applied for the target resource.
        """
        pulumi.set(__self__, "effective_edition", effective_edition)
        pulumi.set(__self__, "intelligence_config", intelligence_config)

    @_builtins.property
    @pulumi.getter(name="effectiveEdition")
    def effective_edition(self) -> _builtins.str:
        """
        The 'StorageIntelligence' edition that is applicable for the resource.
        """
        return pulumi.get(self, "effective_edition")

    @_builtins.property
    @pulumi.getter(name="intelligenceConfig")
    def intelligence_config(self) -> _builtins.str:
        """
        The Intelligence config resource that is applied for the target resource.
        """
        return pulumi.get(self, "intelligence_config")


@pulumi.output_type
class GetControlOrganizationIntelligenceConfigFilterResult(dict):
    def __init__(__self__, *,
                 excluded_cloud_storage_buckets: Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBucketResult'],
                 excluded_cloud_storage_locations: Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocationResult'],
                 included_cloud_storage_buckets: Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBucketResult'],
                 included_cloud_storage_locations: Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocationResult']):
        """
        :param Sequence['GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBucketArgs'] excluded_cloud_storage_buckets: Buckets to exclude from the Storage Intelligence plan.
        :param Sequence['GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocationArgs'] excluded_cloud_storage_locations: Locations to exclude from the Storage Intelligence plan.
        :param Sequence['GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBucketArgs'] included_cloud_storage_buckets: Buckets to include in the Storage Intelligence plan.
        :param Sequence['GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocationArgs'] included_cloud_storage_locations: Locations to include in the Storage Intelligence plan.
        """
        pulumi.set(__self__, "excluded_cloud_storage_buckets", excluded_cloud_storage_buckets)
        pulumi.set(__self__, "excluded_cloud_storage_locations", excluded_cloud_storage_locations)
        pulumi.set(__self__, "included_cloud_storage_buckets", included_cloud_storage_buckets)
        pulumi.set(__self__, "included_cloud_storage_locations", included_cloud_storage_locations)

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageBuckets")
    def excluded_cloud_storage_buckets(self) -> Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBucketResult']:
        """
        Buckets to exclude from the Storage Intelligence plan.
        """
        return pulumi.get(self, "excluded_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageLocations")
    def excluded_cloud_storage_locations(self) -> Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocationResult']:
        """
        Locations to exclude from the Storage Intelligence plan.
        """
        return pulumi.get(self, "excluded_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageBuckets")
    def included_cloud_storage_buckets(self) -> Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBucketResult']:
        """
        Buckets to include in the Storage Intelligence plan.
        """
        return pulumi.get(self, "included_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageLocations")
    def included_cloud_storage_locations(self) -> Sequence['outputs.GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocationResult']:
        """
        Locations to include in the Storage Intelligence plan.
        """
        return pulumi.get(self, "included_cloud_storage_locations")


@pulumi.output_type
class GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class GetControlOrganizationIntelligenceConfigFilterExcludedCloudStorageLocationResult(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class GetControlOrganizationIntelligenceConfigFilterIncludedCloudStorageLocationResult(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class GetControlOrganizationIntelligenceConfigTrialConfigResult(dict):
    def __init__(__self__, *,
                 expire_time: _builtins.str):
        """
        :param _builtins.str expire_time: The time at which the trial expires.
        """
        pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The time at which the trial expires.
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class GetControlProjectIntelligenceConfigEffectiveIntelligenceConfigResult(dict):
    def __init__(__self__, *,
                 effective_edition: _builtins.str,
                 intelligence_config: _builtins.str):
        """
        :param _builtins.str effective_edition: The 'StorageIntelligence' edition that is applicable for the resource.
        :param _builtins.str intelligence_config: The Intelligence config resource that is applied for the target resource.
        """
        pulumi.set(__self__, "effective_edition", effective_edition)
        pulumi.set(__self__, "intelligence_config", intelligence_config)

    @_builtins.property
    @pulumi.getter(name="effectiveEdition")
    def effective_edition(self) -> _builtins.str:
        """
        The 'StorageIntelligence' edition that is applicable for the resource.
        """
        return pulumi.get(self, "effective_edition")

    @_builtins.property
    @pulumi.getter(name="intelligenceConfig")
    def intelligence_config(self) -> _builtins.str:
        """
        The Intelligence config resource that is applied for the target resource.
        """
        return pulumi.get(self, "intelligence_config")


@pulumi.output_type
class GetControlProjectIntelligenceConfigFilterResult(dict):
    def __init__(__self__, *,
                 excluded_cloud_storage_buckets: Sequence['outputs.GetControlProjectIntelligenceConfigFilterExcludedCloudStorageBucketResult'],
                 excluded_cloud_storage_locations: Sequence['outputs.GetControlProjectIntelligenceConfigFilterExcludedCloudStorageLocationResult'],
                 included_cloud_storage_buckets: Sequence['outputs.GetControlProjectIntelligenceConfigFilterIncludedCloudStorageBucketResult'],
                 included_cloud_storage_locations: Sequence['outputs.GetControlProjectIntelligenceConfigFilterIncludedCloudStorageLocationResult']):
        """
        :param Sequence['GetControlProjectIntelligenceConfigFilterExcludedCloudStorageBucketArgs'] excluded_cloud_storage_buckets: Buckets to exclude from the Storage Intelligence plan.
        :param Sequence['GetControlProjectIntelligenceConfigFilterExcludedCloudStorageLocationArgs'] excluded_cloud_storage_locations: Locations to exclude from the Storage Intelligence plan.
        :param Sequence['GetControlProjectIntelligenceConfigFilterIncludedCloudStorageBucketArgs'] included_cloud_storage_buckets: Buckets to include in the Storage Intelligence plan.
        :param Sequence['GetControlProjectIntelligenceConfigFilterIncludedCloudStorageLocationArgs'] included_cloud_storage_locations: Locations to include in the Storage Intelligence plan.
        """
        pulumi.set(__self__, "excluded_cloud_storage_buckets", excluded_cloud_storage_buckets)
        pulumi.set(__self__, "excluded_cloud_storage_locations", excluded_cloud_storage_locations)
        pulumi.set(__self__, "included_cloud_storage_buckets", included_cloud_storage_buckets)
        pulumi.set(__self__, "included_cloud_storage_locations", included_cloud_storage_locations)

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageBuckets")
    def excluded_cloud_storage_buckets(self) -> Sequence['outputs.GetControlProjectIntelligenceConfigFilterExcludedCloudStorageBucketResult']:
        """
        Buckets to exclude from the Storage Intelligence plan.
        """
        return pulumi.get(self, "excluded_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="excludedCloudStorageLocations")
    def excluded_cloud_storage_locations(self) -> Sequence['outputs.GetControlProjectIntelligenceConfigFilterExcludedCloudStorageLocationResult']:
        """
        Locations to exclude from the Storage Intelligence plan.
        """
        return pulumi.get(self, "excluded_cloud_storage_locations")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageBuckets")
    def included_cloud_storage_buckets(self) -> Sequence['outputs.GetControlProjectIntelligenceConfigFilterIncludedCloudStorageBucketResult']:
        """
        Buckets to include in the Storage Intelligence plan.
        """
        return pulumi.get(self, "included_cloud_storage_buckets")

    @_builtins.property
    @pulumi.getter(name="includedCloudStorageLocations")
    def included_cloud_storage_locations(self) -> Sequence['outputs.GetControlProjectIntelligenceConfigFilterIncludedCloudStorageLocationResult']:
        """
        Locations to include in the Storage Intelligence plan.
        """
        return pulumi.get(self, "included_cloud_storage_locations")


@pulumi.output_type
class GetControlProjectIntelligenceConfigFilterExcludedCloudStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class GetControlProjectIntelligenceConfigFilterExcludedCloudStorageLocationResult(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class GetControlProjectIntelligenceConfigFilterIncludedCloudStorageBucketResult(dict):
    def __init__(__self__, *,
                 bucket_id_regexes: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] bucket_id_regexes: List of bucket id regexes to exclude in the storage intelligence plan.
        """
        pulumi.set(__self__, "bucket_id_regexes", bucket_id_regexes)

    @_builtins.property
    @pulumi.getter(name="bucketIdRegexes")
    def bucket_id_regexes(self) -> Sequence[_builtins.str]:
        """
        List of bucket id regexes to exclude in the storage intelligence plan.
        """
        return pulumi.get(self, "bucket_id_regexes")


@pulumi.output_type
class GetControlProjectIntelligenceConfigFilterIncludedCloudStorageLocationResult(dict):
    def __init__(__self__, *,
                 locations: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] locations: List of locations.
        """
        pulumi.set(__self__, "locations", locations)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Sequence[_builtins.str]:
        """
        List of locations.
        """
        return pulumi.get(self, "locations")


@pulumi.output_type
class GetControlProjectIntelligenceConfigTrialConfigResult(dict):
    def __init__(__self__, *,
                 expire_time: _builtins.str):
        """
        :param _builtins.str expire_time: The time at which the trial expires.
        """
        pulumi.set(__self__, "expire_time", expire_time)

    @_builtins.property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> _builtins.str:
        """
        The time at which the trial expires.
        """
        return pulumi.get(self, "expire_time")


