# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_proxy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_third_party_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 gce_setup: Optional[pulumi.Input['InstanceGceSetupArgs']] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Workbench Instance. Set this field to `ACTIVE` to start the Instance, and `STOPPED` to stop the Instance.
        :param pulumi.Input[_builtins.bool] disable_proxy_access: Optional. If true, the workbench instance will not register with the proxy.
        :param pulumi.Input[_builtins.bool] enable_third_party_identity: Flag that specifies that a notebook can be accessed with third party
               identity provider.
        :param pulumi.Input['InstanceGceSetupArgs'] gce_setup: The definition of how to configure a VM instance outside of Resources and Identity.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Required. User-defined unique ID of this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_owners: 'Optional. Input only. The owner of this instance after creation. Format:
               `alias@example.com` Currently supports one owner only. If not specified, all of
               the service account users of your VM instance''s service account can use the instance.
               If specified, sets the access mode to `Single user`. For more details, see
               https://cloud.google.com/vertex-ai/docs/workbench/instances/manage-access-jupyterlab'
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to apply to this instance. These can be later modified
               by the UpdateInstance method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: The name of this workbench instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if disable_proxy_access is not None:
            pulumi.set(__self__, "disable_proxy_access", disable_proxy_access)
        if enable_third_party_identity is not None:
            pulumi.set(__self__, "enable_third_party_identity", enable_third_party_identity)
        if gce_setup is not None:
            pulumi.set(__self__, "gce_setup", gce_setup)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_owners is not None:
            pulumi.set(__self__, "instance_owners", instance_owners)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired state of the Workbench Instance. Set this field to `ACTIVE` to start the Instance, and `STOPPED` to stop the Instance.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="disableProxyAccess")
    def disable_proxy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. If true, the workbench instance will not register with the proxy.
        """
        return pulumi.get(self, "disable_proxy_access")

    @disable_proxy_access.setter
    def disable_proxy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_proxy_access", value)

    @_builtins.property
    @pulumi.getter(name="enableThirdPartyIdentity")
    def enable_third_party_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that specifies that a notebook can be accessed with third party
        identity provider.
        """
        return pulumi.get(self, "enable_third_party_identity")

    @enable_third_party_identity.setter
    def enable_third_party_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_third_party_identity", value)

    @_builtins.property
    @pulumi.getter(name="gceSetup")
    def gce_setup(self) -> Optional[pulumi.Input['InstanceGceSetupArgs']]:
        """
        The definition of how to configure a VM instance outside of Resources and Identity.
        Structure is documented below.
        """
        return pulumi.get(self, "gce_setup")

    @gce_setup.setter
    def gce_setup(self, value: Optional[pulumi.Input['InstanceGceSetupArgs']]):
        pulumi.set(self, "gce_setup", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. User-defined unique ID of this instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        'Optional. Input only. The owner of this instance after creation. Format:
        `alias@example.com` Currently supports one owner only. If not specified, all of
        the service account users of your VM instance''s service account can use the instance.
        If specified, sets the access mode to `Single user`. For more details, see
        https://cloud.google.com/vertex-ai/docs/workbench/instances/manage-access-jupyterlab'
        """
        return pulumi.get(self, "instance_owners")

    @instance_owners.setter
    def instance_owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_owners", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels to apply to this instance. These can be later modified
        by the UpdateInstance method.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this workbench instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 creator: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_proxy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 enable_third_party_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 gce_setup: Optional[pulumi.Input['InstanceGceSetupArgs']] = None,
                 health_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceHealthInfoArgs']]]] = None,
                 health_state: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_histories: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceUpgradeHistoryArgs']]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] create_time: An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
               The milliseconds portion (".SSS") is optional.
        :param pulumi.Input[_builtins.str] creator: Output only. Email address of entity that sent original CreateInstance request.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Workbench Instance. Set this field to `ACTIVE` to start the Instance, and `STOPPED` to stop the Instance.
        :param pulumi.Input[_builtins.bool] disable_proxy_access: Optional. If true, the workbench instance will not register with the proxy.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_third_party_identity: Flag that specifies that a notebook can be accessed with third party
               identity provider.
        :param pulumi.Input['InstanceGceSetupArgs'] gce_setup: The definition of how to configure a VM instance outside of Resources and Identity.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceHealthInfoArgs']]] health_infos: 'Output only. Additional information about instance health. Example:
               healthInfo": { "docker_proxy_agent_status": "1", "docker_status": "1", "jupyterlab_api_status":
               "-1", "jupyterlab_status": "-1", "updated": "2020-10-18 09:40:03.573409" }'
        :param pulumi.Input[_builtins.str] health_state: Output only. Instance health_state.
        :param pulumi.Input[_builtins.str] instance_id: Required. User-defined unique ID of this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_owners: 'Optional. Input only. The owner of this instance after creation. Format:
               `alias@example.com` Currently supports one owner only. If not specified, all of
               the service account users of your VM instance''s service account can use the instance.
               If specified, sets the access mode to `Single user`. For more details, see
               https://cloud.google.com/vertex-ai/docs/workbench/instances/manage-access-jupyterlab'
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to apply to this instance. These can be later modified
               by the UpdateInstance method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[_builtins.str] name: The name of this workbench instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] proxy_uri: Output only. The proxy endpoint that is used to access the Jupyter notebook.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: (Output)
               Output only. The state of this instance upgrade history entry.
        :param pulumi.Input[_builtins.str] update_time: An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
               The milliseconds portion (".SSS") is optional.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceUpgradeHistoryArgs']]] upgrade_histories: Output only. The upgrade history of this instance.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if disable_proxy_access is not None:
            pulumi.set(__self__, "disable_proxy_access", disable_proxy_access)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_third_party_identity is not None:
            pulumi.set(__self__, "enable_third_party_identity", enable_third_party_identity)
        if gce_setup is not None:
            pulumi.set(__self__, "gce_setup", gce_setup)
        if health_infos is not None:
            pulumi.set(__self__, "health_infos", health_infos)
        if health_state is not None:
            pulumi.set(__self__, "health_state", health_state)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_owners is not None:
            pulumi.set(__self__, "instance_owners", instance_owners)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy_uri is not None:
            pulumi.set(__self__, "proxy_uri", proxy_uri)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if upgrade_histories is not None:
            pulumi.set(__self__, "upgrade_histories", upgrade_histories)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        The milliseconds portion (".SSS") is optional.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Email address of entity that sent original CreateInstance request.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creator", value)

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Desired state of the Workbench Instance. Set this field to `ACTIVE` to start the Instance, and `STOPPED` to stop the Instance.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @_builtins.property
    @pulumi.getter(name="disableProxyAccess")
    def disable_proxy_access(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Optional. If true, the workbench instance will not register with the proxy.
        """
        return pulumi.get(self, "disable_proxy_access")

    @disable_proxy_access.setter
    def disable_proxy_access(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disable_proxy_access", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="enableThirdPartyIdentity")
    def enable_third_party_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag that specifies that a notebook can be accessed with third party
        identity provider.
        """
        return pulumi.get(self, "enable_third_party_identity")

    @enable_third_party_identity.setter
    def enable_third_party_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_third_party_identity", value)

    @_builtins.property
    @pulumi.getter(name="gceSetup")
    def gce_setup(self) -> Optional[pulumi.Input['InstanceGceSetupArgs']]:
        """
        The definition of how to configure a VM instance outside of Resources and Identity.
        Structure is documented below.
        """
        return pulumi.get(self, "gce_setup")

    @gce_setup.setter
    def gce_setup(self, value: Optional[pulumi.Input['InstanceGceSetupArgs']]):
        pulumi.set(self, "gce_setup", value)

    @_builtins.property
    @pulumi.getter(name="healthInfos")
    def health_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceHealthInfoArgs']]]]:
        """
        'Output only. Additional information about instance health. Example:
        healthInfo": { "docker_proxy_agent_status": "1", "docker_status": "1", "jupyterlab_api_status":
        "-1", "jupyterlab_status": "-1", "updated": "2020-10-18 09:40:03.573409" }'
        """
        return pulumi.get(self, "health_infos")

    @health_infos.setter
    def health_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceHealthInfoArgs']]]]):
        pulumi.set(self, "health_infos", value)

    @_builtins.property
    @pulumi.getter(name="healthState")
    def health_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Instance health_state.
        """
        return pulumi.get(self, "health_state")

    @health_state.setter
    def health_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_state", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. User-defined unique ID of this instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        'Optional. Input only. The owner of this instance after creation. Format:
        `alias@example.com` Currently supports one owner only. If not specified, all of
        the service account users of your VM instance''s service account can use the instance.
        If specified, sets the access mode to `Single user`. For more details, see
        https://cloud.google.com/vertex-ai/docs/workbench/instances/manage-access-jupyterlab'
        """
        return pulumi.get(self, "instance_owners")

    @instance_owners.setter
    def instance_owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "instance_owners", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Labels to apply to this instance. These can be later modified
        by the UpdateInstance method.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of this workbench instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The proxy endpoint that is used to access the Jupyter notebook.
        """
        return pulumi.get(self, "proxy_uri")

    @proxy_uri.setter
    def proxy_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_uri", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Output)
        Output only. The state of this instance upgrade history entry.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        The milliseconds portion (".SSS") is optional.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="upgradeHistories")
    def upgrade_histories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceUpgradeHistoryArgs']]]]:
        """
        Output only. The upgrade history of this instance.
        Structure is documented below.
        """
        return pulumi.get(self, "upgrade_histories")

    @upgrade_histories.setter
    def upgrade_histories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceUpgradeHistoryArgs']]]]):
        pulumi.set(self, "upgrade_histories", value)


@pulumi.type_token("gcp:workbench/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_proxy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_third_party_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 gce_setup: Optional[pulumi.Input[Union['InstanceGceSetupArgs', 'InstanceGceSetupArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Workbench instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/workbench/reference/rest/v2/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/docs/workbench/instances/introduction)

        ## Example Usage

        ### Workbench Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-west1-a")
        ```
        ### Workbench Instance Basic Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-west1-a",
            gce_setup={
                "container_image": {
                    "repository": "us-docker.pkg.dev/deeplearning-platform-release/gcr.io/base-cu113.py310",
                    "tag": "latest",
                },
            })
        ```
        ### Workbench Instance Basic Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "n1-standard-1",
                "accelerator_configs": [{
                    "type": "NVIDIA_TESLA_T4",
                    "core_count": "1",
                }],
                "vm_image": {
                    "project": "cloud-notebooks-managed",
                    "family": "workbench-instances",
                },
            })
        ```
        ### Workbench Instance Labels Stopped

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "e2-standard-4",
                "shielded_instance_config": {
                    "enable_secure_boot": False,
                    "enable_vtpm": False,
                    "enable_integrity_monitoring": False,
                },
                "service_accounts": [{
                    "email": "my@service-account.com",
                }],
                "metadata": {
                    "terraform": "true",
                },
            },
            labels={
                "k": "val",
            },
            desired_state="STOPPED")
        ```
        ### Workbench Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="wbi-test-default",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="wbi-test-default",
            network=my_network.id,
            region="us-central1",
            ip_cidr_range="10.0.1.0/24")
        static = gcp.compute.Address("static", name="wbi-test-default")
        act_as_permission = gcp.serviceaccount.IAMBinding("act_as_permission",
            service_account_id="projects/my-project-name/serviceAccounts/my@service-account.com",
            role="roles/iam.serviceAccountUser",
            members=["user:example@example.com"])
        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "n1-standard-4",
                "accelerator_configs": [{
                    "type": "NVIDIA_TESLA_T4",
                    "core_count": "1",
                }],
                "shielded_instance_config": {
                    "enable_secure_boot": True,
                    "enable_vtpm": True,
                    "enable_integrity_monitoring": True,
                },
                "disable_public_ip": False,
                "service_accounts": [{
                    "email": "my@service-account.com",
                }],
                "boot_disk": {
                    "disk_size_gb": "310",
                    "disk_type": "PD_SSD",
                    "disk_encryption": "CMEK",
                    "kms_key": "my-crypto-key",
                },
                "data_disks": {
                    "disk_size_gb": "330",
                    "disk_type": "PD_SSD",
                    "disk_encryption": "CMEK",
                    "kms_key": "my-crypto-key",
                },
                "network_interfaces": [{
                    "network": my_network.id,
                    "subnet": my_subnetwork.id,
                    "nic_type": "GVNIC",
                    "access_configs": [{
                        "external_ip": static.address,
                    }],
                }],
                "metadata": {
                    "terraform": "true",
                    "serial-port-logging-enable": "false",
                },
                "enable_ip_forwarding": True,
                "tags": [
                    "abc",
                    "def",
                ],
            },
            disable_proxy_access=True,
            instance_owners=["example@example.com"],
            labels={
                "k": "val",
            },
            desired_state="ACTIVE",
            enable_third_party_identity=True,
            opts = pulumi.ResourceOptions(depends_on=[
                    my_network,
                    my_subnetwork,
                    static,
                    act_as_permission,
                ]))
        ```
        ### Workbench Instance Confidential Compute

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "n2d-standard-2",
                "shielded_instance_config": {
                    "enable_secure_boot": True,
                    "enable_vtpm": True,
                    "enable_integrity_monitoring": True,
                },
                "metadata": {
                    "terraform": "true",
                },
                "confidential_instance_config": {
                    "confidential_instance_type": "SEV",
                },
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workbench/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:workbench/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:workbench/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Workbench Instance. Set this field to `ACTIVE` to start the Instance, and `STOPPED` to stop the Instance.
        :param pulumi.Input[_builtins.bool] disable_proxy_access: Optional. If true, the workbench instance will not register with the proxy.
        :param pulumi.Input[_builtins.bool] enable_third_party_identity: Flag that specifies that a notebook can be accessed with third party
               identity provider.
        :param pulumi.Input[Union['InstanceGceSetupArgs', 'InstanceGceSetupArgsDict']] gce_setup: The definition of how to configure a VM instance outside of Resources and Identity.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Required. User-defined unique ID of this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_owners: 'Optional. Input only. The owner of this instance after creation. Format:
               `alias@example.com` Currently supports one owner only. If not specified, all of
               the service account users of your VM instance''s service account can use the instance.
               If specified, sets the access mode to `Single user`. For more details, see
               https://cloud.google.com/vertex-ai/docs/workbench/instances/manage-access-jupyterlab'
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to apply to this instance. These can be later modified
               by the UpdateInstance method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[_builtins.str] name: The name of this workbench instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Workbench instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/workbench/reference/rest/v2/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vertex-ai/docs/workbench/instances/introduction)

        ## Example Usage

        ### Workbench Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-west1-a")
        ```
        ### Workbench Instance Basic Container

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-west1-a",
            gce_setup={
                "container_image": {
                    "repository": "us-docker.pkg.dev/deeplearning-platform-release/gcr.io/base-cu113.py310",
                    "tag": "latest",
                },
            })
        ```
        ### Workbench Instance Basic Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "n1-standard-1",
                "accelerator_configs": [{
                    "type": "NVIDIA_TESLA_T4",
                    "core_count": "1",
                }],
                "vm_image": {
                    "project": "cloud-notebooks-managed",
                    "family": "workbench-instances",
                },
            })
        ```
        ### Workbench Instance Labels Stopped

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "e2-standard-4",
                "shielded_instance_config": {
                    "enable_secure_boot": False,
                    "enable_vtpm": False,
                    "enable_integrity_monitoring": False,
                },
                "service_accounts": [{
                    "email": "my@service-account.com",
                }],
                "metadata": {
                    "terraform": "true",
                },
            },
            labels={
                "k": "val",
            },
            desired_state="STOPPED")
        ```
        ### Workbench Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_network = gcp.compute.Network("my_network",
            name="wbi-test-default",
            auto_create_subnetworks=False)
        my_subnetwork = gcp.compute.Subnetwork("my_subnetwork",
            name="wbi-test-default",
            network=my_network.id,
            region="us-central1",
            ip_cidr_range="10.0.1.0/24")
        static = gcp.compute.Address("static", name="wbi-test-default")
        act_as_permission = gcp.serviceaccount.IAMBinding("act_as_permission",
            service_account_id="projects/my-project-name/serviceAccounts/my@service-account.com",
            role="roles/iam.serviceAccountUser",
            members=["user:example@example.com"])
        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "n1-standard-4",
                "accelerator_configs": [{
                    "type": "NVIDIA_TESLA_T4",
                    "core_count": "1",
                }],
                "shielded_instance_config": {
                    "enable_secure_boot": True,
                    "enable_vtpm": True,
                    "enable_integrity_monitoring": True,
                },
                "disable_public_ip": False,
                "service_accounts": [{
                    "email": "my@service-account.com",
                }],
                "boot_disk": {
                    "disk_size_gb": "310",
                    "disk_type": "PD_SSD",
                    "disk_encryption": "CMEK",
                    "kms_key": "my-crypto-key",
                },
                "data_disks": {
                    "disk_size_gb": "330",
                    "disk_type": "PD_SSD",
                    "disk_encryption": "CMEK",
                    "kms_key": "my-crypto-key",
                },
                "network_interfaces": [{
                    "network": my_network.id,
                    "subnet": my_subnetwork.id,
                    "nic_type": "GVNIC",
                    "access_configs": [{
                        "external_ip": static.address,
                    }],
                }],
                "metadata": {
                    "terraform": "true",
                    "serial-port-logging-enable": "false",
                },
                "enable_ip_forwarding": True,
                "tags": [
                    "abc",
                    "def",
                ],
            },
            disable_proxy_access=True,
            instance_owners=["example@example.com"],
            labels={
                "k": "val",
            },
            desired_state="ACTIVE",
            enable_third_party_identity=True,
            opts = pulumi.ResourceOptions(depends_on=[
                    my_network,
                    my_subnetwork,
                    static,
                    act_as_permission,
                ]))
        ```
        ### Workbench Instance Confidential Compute

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.workbench.Instance("instance",
            name="workbench-instance",
            location="us-central1-a",
            gce_setup={
                "machine_type": "n2d-standard-2",
                "shielded_instance_config": {
                    "enable_secure_boot": True,
                    "enable_vtpm": True,
                    "enable_integrity_monitoring": True,
                },
                "metadata": {
                    "terraform": "true",
                },
                "confidential_instance_config": {
                    "confidential_instance_type": "SEV",
                },
            })
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:workbench/instance:Instance default projects/{{project}}/locations/{{location}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:workbench/instance:Instance default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:workbench/instance:Instance default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desired_state: Optional[pulumi.Input[_builtins.str]] = None,
                 disable_proxy_access: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_third_party_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 gce_setup: Optional[pulumi.Input[Union['InstanceGceSetupArgs', 'InstanceGceSetupArgsDict']]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["desired_state"] = desired_state
            __props__.__dict__["disable_proxy_access"] = disable_proxy_access
            __props__.__dict__["enable_third_party_identity"] = enable_third_party_identity
            __props__.__dict__["gce_setup"] = gce_setup
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["instance_owners"] = instance_owners
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["health_infos"] = None
            __props__.__dict__["health_state"] = None
            __props__.__dict__["proxy_uri"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["upgrade_histories"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:workbench/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            creator: Optional[pulumi.Input[_builtins.str]] = None,
            desired_state: Optional[pulumi.Input[_builtins.str]] = None,
            disable_proxy_access: Optional[pulumi.Input[_builtins.bool]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            enable_third_party_identity: Optional[pulumi.Input[_builtins.bool]] = None,
            gce_setup: Optional[pulumi.Input[Union['InstanceGceSetupArgs', 'InstanceGceSetupArgsDict']]] = None,
            health_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceHealthInfoArgs', 'InstanceHealthInfoArgsDict']]]]] = None,
            health_state: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_uri: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_histories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceUpgradeHistoryArgs', 'InstanceUpgradeHistoryArgsDict']]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
               The milliseconds portion (".SSS") is optional.
        :param pulumi.Input[_builtins.str] creator: Output only. Email address of entity that sent original CreateInstance request.
        :param pulumi.Input[_builtins.str] desired_state: Desired state of the Workbench Instance. Set this field to `ACTIVE` to start the Instance, and `STOPPED` to stop the Instance.
        :param pulumi.Input[_builtins.bool] disable_proxy_access: Optional. If true, the workbench instance will not register with the proxy.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.bool] enable_third_party_identity: Flag that specifies that a notebook can be accessed with third party
               identity provider.
        :param pulumi.Input[Union['InstanceGceSetupArgs', 'InstanceGceSetupArgsDict']] gce_setup: The definition of how to configure a VM instance outside of Resources and Identity.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceHealthInfoArgs', 'InstanceHealthInfoArgsDict']]]] health_infos: 'Output only. Additional information about instance health. Example:
               healthInfo": { "docker_proxy_agent_status": "1", "docker_status": "1", "jupyterlab_api_status":
               "-1", "jupyterlab_status": "-1", "updated": "2020-10-18 09:40:03.573409" }'
        :param pulumi.Input[_builtins.str] health_state: Output only. Instance health_state.
        :param pulumi.Input[_builtins.str] instance_id: Required. User-defined unique ID of this instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] instance_owners: 'Optional. Input only. The owner of this instance after creation. Format:
               `alias@example.com` Currently supports one owner only. If not specified, all of
               the service account users of your VM instance''s service account can use the instance.
               If specified, sets the access mode to `Single user`. For more details, see
               https://cloud.google.com/vertex-ai/docs/workbench/instances/manage-access-jupyterlab'
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Labels to apply to this instance. These can be later modified
               by the UpdateInstance method.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: Part of `parent`. See documentation of `projectsId`.
        :param pulumi.Input[_builtins.str] name: The name of this workbench instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] proxy_uri: Output only. The proxy endpoint that is used to access the Jupyter notebook.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] state: (Output)
               Output only. The state of this instance upgrade history entry.
        :param pulumi.Input[_builtins.str] update_time: An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
               The milliseconds portion (".SSS") is optional.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceUpgradeHistoryArgs', 'InstanceUpgradeHistoryArgsDict']]]] upgrade_histories: Output only. The upgrade history of this instance.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["creator"] = creator
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["disable_proxy_access"] = disable_proxy_access
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_third_party_identity"] = enable_third_party_identity
        __props__.__dict__["gce_setup"] = gce_setup
        __props__.__dict__["health_infos"] = health_infos
        __props__.__dict__["health_state"] = health_state
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_owners"] = instance_owners
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["proxy_uri"] = proxy_uri
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["upgrade_histories"] = upgrade_histories
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        The milliseconds portion (".SSS") is optional.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def creator(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Email address of entity that sent original CreateInstance request.
        """
        return pulumi.get(self, "creator")

    @_builtins.property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Desired state of the Workbench Instance. Set this field to `ACTIVE` to start the Instance, and `STOPPED` to stop the Instance.
        """
        return pulumi.get(self, "desired_state")

    @_builtins.property
    @pulumi.getter(name="disableProxyAccess")
    def disable_proxy_access(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Optional. If true, the workbench instance will not register with the proxy.
        """
        return pulumi.get(self, "disable_proxy_access")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="enableThirdPartyIdentity")
    def enable_third_party_identity(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag that specifies that a notebook can be accessed with third party
        identity provider.
        """
        return pulumi.get(self, "enable_third_party_identity")

    @_builtins.property
    @pulumi.getter(name="gceSetup")
    def gce_setup(self) -> pulumi.Output['outputs.InstanceGceSetup']:
        """
        The definition of how to configure a VM instance outside of Resources and Identity.
        Structure is documented below.
        """
        return pulumi.get(self, "gce_setup")

    @_builtins.property
    @pulumi.getter(name="healthInfos")
    def health_infos(self) -> pulumi.Output[Sequence['outputs.InstanceHealthInfo']]:
        """
        'Output only. Additional information about instance health. Example:
        healthInfo": { "docker_proxy_agent_status": "1", "docker_status": "1", "jupyterlab_api_status":
        "-1", "jupyterlab_status": "-1", "updated": "2020-10-18 09:40:03.573409" }'
        """
        return pulumi.get(self, "health_infos")

    @_builtins.property
    @pulumi.getter(name="healthState")
    def health_state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Instance health_state.
        """
        return pulumi.get(self, "health_state")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Required. User-defined unique ID of this instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        'Optional. Input only. The owner of this instance after creation. Format:
        `alias@example.com` Currently supports one owner only. If not specified, all of
        the service account users of your VM instance''s service account can use the instance.
        If specified, sets the access mode to `Single user`. For more details, see
        https://cloud.google.com/vertex-ai/docs/workbench/instances/manage-access-jupyterlab'
        """
        return pulumi.get(self, "instance_owners")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Labels to apply to this instance. These can be later modified
        by the UpdateInstance method.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Part of `parent`. See documentation of `projectsId`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of this workbench instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The proxy endpoint that is used to access the Jupyter notebook.
        """
        return pulumi.get(self, "proxy_uri")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        (Output)
        Output only. The state of this instance upgrade history entry.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        An RFC3339 timestamp in UTC time. This in the format of yyyy-MM-ddTHH:mm:ss.SSSZ.
        The milliseconds portion (".SSS") is optional.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="upgradeHistories")
    def upgrade_histories(self) -> pulumi.Output[Sequence['outputs.InstanceUpgradeHistory']]:
        """
        Output only. The upgrade history of this instance.
        Structure is documented below.
        """
        return pulumi.get(self, "upgrade_histories")

