# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'WorkstationClusterCondition',
    'WorkstationClusterDomainConfig',
    'WorkstationClusterPrivateClusterConfig',
    'WorkstationConfigAllowedPort',
    'WorkstationConfigCondition',
    'WorkstationConfigContainer',
    'WorkstationConfigEncryptionKey',
    'WorkstationConfigEphemeralDirectory',
    'WorkstationConfigEphemeralDirectoryGcePd',
    'WorkstationConfigHost',
    'WorkstationConfigHostGceInstance',
    'WorkstationConfigHostGceInstanceAccelerator',
    'WorkstationConfigHostGceInstanceBoostConfig',
    'WorkstationConfigHostGceInstanceBoostConfigAccelerator',
    'WorkstationConfigHostGceInstanceConfidentialInstanceConfig',
    'WorkstationConfigHostGceInstanceShieldedInstanceConfig',
    'WorkstationConfigIamBindingCondition',
    'WorkstationConfigIamMemberCondition',
    'WorkstationConfigPersistentDirectory',
    'WorkstationConfigPersistentDirectoryGcePd',
    'WorkstationConfigReadinessCheck',
    'WorkstationIamBindingCondition',
    'WorkstationIamMemberCondition',
]

@pulumi.output_type
class WorkstationClusterCondition(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[Sequence[Mapping[str, _builtins.str]]] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, _builtins.str]] details: (Output)
               A list of messages that carry the error details.
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, _builtins.str]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class WorkstationClusterDomainConfig(dict):
    def __init__(__self__, *,
                 domain: _builtins.str):
        """
        :param _builtins.str domain: Domain used by Workstations for HTTP ingress.
        """
        pulumi.set(__self__, "domain", domain)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain used by Workstations for HTTP ingress.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class WorkstationClusterPrivateClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePrivateEndpoint":
            suggest = "enable_private_endpoint"
        elif key == "allowedProjects":
            suggest = "allowed_projects"
        elif key == "clusterHostname":
            suggest = "cluster_hostname"
        elif key == "serviceAttachmentUri":
            suggest = "service_attachment_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationClusterPrivateClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationClusterPrivateClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationClusterPrivateClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_private_endpoint: _builtins.bool,
                 allowed_projects: Optional[Sequence[_builtins.str]] = None,
                 cluster_hostname: Optional[_builtins.str] = None,
                 service_attachment_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enable_private_endpoint: Whether Workstations endpoint is private.
        :param Sequence[_builtins.str] allowed_projects: Additional project IDs that are allowed to attach to the workstation cluster's service attachment.
               By default, the workstation cluster's project and the VPC host project (if different) are allowed.
        :param _builtins.str cluster_hostname: (Output)
               Hostname for the workstation cluster.
               This field will be populated only when private endpoint is enabled.
               To access workstations in the cluster, create a new DNS zone mapping this domain name to an internal IP address and a forwarding rule mapping that address to the service attachment.
        :param _builtins.str service_attachment_uri: (Output)
               Service attachment URI for the workstation cluster.
               The service attachment is created when private endpoint is enabled.
               To access workstations in the cluster, configure access to the managed service using (Private Service Connect)[https://cloud.google.com/vpc/docs/configure-private-service-connect-services].
        """
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if allowed_projects is not None:
            pulumi.set(__self__, "allowed_projects", allowed_projects)
        if cluster_hostname is not None:
            pulumi.set(__self__, "cluster_hostname", cluster_hostname)
        if service_attachment_uri is not None:
            pulumi.set(__self__, "service_attachment_uri", service_attachment_uri)

    @_builtins.property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> _builtins.bool:
        """
        Whether Workstations endpoint is private.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @_builtins.property
    @pulumi.getter(name="allowedProjects")
    def allowed_projects(self) -> Optional[Sequence[_builtins.str]]:
        """
        Additional project IDs that are allowed to attach to the workstation cluster's service attachment.
        By default, the workstation cluster's project and the VPC host project (if different) are allowed.
        """
        return pulumi.get(self, "allowed_projects")

    @_builtins.property
    @pulumi.getter(name="clusterHostname")
    def cluster_hostname(self) -> Optional[_builtins.str]:
        """
        (Output)
        Hostname for the workstation cluster.
        This field will be populated only when private endpoint is enabled.
        To access workstations in the cluster, create a new DNS zone mapping this domain name to an internal IP address and a forwarding rule mapping that address to the service attachment.
        """
        return pulumi.get(self, "cluster_hostname")

    @_builtins.property
    @pulumi.getter(name="serviceAttachmentUri")
    def service_attachment_uri(self) -> Optional[_builtins.str]:
        """
        (Output)
        Service attachment URI for the workstation cluster.
        The service attachment is created when private endpoint is enabled.
        To access workstations in the cluster, configure access to the managed service using (Private Service Connect)[https://cloud.google.com/vpc/docs/configure-private-service-connect-services].
        """
        return pulumi.get(self, "service_attachment_uri")


@pulumi.output_type
class WorkstationConfigAllowedPort(dict):
    def __init__(__self__, *,
                 first: Optional[_builtins.int] = None,
                 last: Optional[_builtins.int] = None):
        """
        :param _builtins.int first: Starting port number for the current range of ports. Valid ports are 22, 80, and ports within the range 1024-65535.
        :param _builtins.int last: Ending port number for the current range of ports. Valid ports are 22, 80, and ports within the range 1024-65535.
        """
        if first is not None:
            pulumi.set(__self__, "first", first)
        if last is not None:
            pulumi.set(__self__, "last", last)

    @_builtins.property
    @pulumi.getter
    def first(self) -> Optional[_builtins.int]:
        """
        Starting port number for the current range of ports. Valid ports are 22, 80, and ports within the range 1024-65535.
        """
        return pulumi.get(self, "first")

    @_builtins.property
    @pulumi.getter
    def last(self) -> Optional[_builtins.int]:
        """
        Ending port number for the current range of ports. Valid ports are 22, 80, and ports within the range 1024-65535.
        """
        return pulumi.get(self, "last")


@pulumi.output_type
class WorkstationConfigCondition(dict):
    def __init__(__self__, *,
                 code: Optional[_builtins.int] = None,
                 details: Optional[Sequence[Mapping[str, _builtins.str]]] = None,
                 message: Optional[_builtins.str] = None):
        """
        :param _builtins.int code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, _builtins.str]] details: (Output)
               A list of messages that carry the error details.
        :param _builtins.str message: (Output)
               Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @_builtins.property
    @pulumi.getter
    def code(self) -> Optional[_builtins.int]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @_builtins.property
    @pulumi.getter
    def details(self) -> Optional[Sequence[Mapping[str, _builtins.str]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[_builtins.str]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class WorkstationConfigContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runAsUser":
            suggest = "run_as_user"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[_builtins.str]] = None,
                 commands: Optional[Sequence[_builtins.str]] = None,
                 env: Optional[Mapping[str, _builtins.str]] = None,
                 image: Optional[_builtins.str] = None,
                 run_as_user: Optional[_builtins.int] = None,
                 working_dir: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] args: Arguments passed to the entrypoint.
        :param Sequence[_builtins.str] commands: If set, overrides the default ENTRYPOINT specified by the image.
        :param Mapping[str, _builtins.str] env: Environment variables passed to the container.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param _builtins.str image: Docker image defining the container. This image must be accessible by the config's service account.
        :param _builtins.int run_as_user: If set, overrides the USER specified in the image with the given uid.
        :param _builtins.str working_dir: If set, overrides the default DIR specified by the image.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if run_as_user is not None:
            pulumi.set(__self__, "run_as_user", run_as_user)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Optional[Sequence[_builtins.str]]:
        """
        Arguments passed to the entrypoint.
        """
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[_builtins.str]]:
        """
        If set, overrides the default ENTRYPOINT specified by the image.
        """
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter
    def env(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Environment variables passed to the container.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Docker image defining the container. This image must be accessible by the config's service account.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[_builtins.int]:
        """
        If set, overrides the USER specified in the image with the given uid.
        """
        return pulumi.get(self, "run_as_user")

    @_builtins.property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[_builtins.str]:
        """
        If set, overrides the default DIR specified by the image.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class WorkstationConfigEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "kmsKeyServiceAccount":
            suggest = "kms_key_service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: _builtins.str,
                 kms_key_service_account: _builtins.str):
        """
        :param _builtins.str kms_key: The name of the Google Cloud KMS encryption key.
        :param _builtins.str kms_key_service_account: The service account to use with the specified KMS key.
        """
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "kms_key_service_account", kms_key_service_account)

    @_builtins.property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> _builtins.str:
        """
        The name of the Google Cloud KMS encryption key.
        """
        return pulumi.get(self, "kms_key")

    @_builtins.property
    @pulumi.getter(name="kmsKeyServiceAccount")
    def kms_key_service_account(self) -> _builtins.str:
        """
        The service account to use with the specified KMS key.
        """
        return pulumi.get(self, "kms_key_service_account")


@pulumi.output_type
class WorkstationConfigEphemeralDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcePd":
            suggest = "gce_pd"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigEphemeralDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigEphemeralDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigEphemeralDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gce_pd: Optional['outputs.WorkstationConfigEphemeralDirectoryGcePd'] = None,
                 mount_path: Optional[_builtins.str] = None):
        """
        :param 'WorkstationConfigEphemeralDirectoryGcePdArgs' gce_pd: An EphemeralDirectory backed by a Compute Engine persistent disk.
               Structure is documented below.
        :param _builtins.str mount_path: Location of this directory in the running workstation.
        """
        if gce_pd is not None:
            pulumi.set(__self__, "gce_pd", gce_pd)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)

    @_builtins.property
    @pulumi.getter(name="gcePd")
    def gce_pd(self) -> Optional['outputs.WorkstationConfigEphemeralDirectoryGcePd']:
        """
        An EphemeralDirectory backed by a Compute Engine persistent disk.
        Structure is documented below.
        """
        return pulumi.get(self, "gce_pd")

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[_builtins.str]:
        """
        Location of this directory in the running workstation.
        """
        return pulumi.get(self, "mount_path")


@pulumi.output_type
class WorkstationConfigEphemeralDirectoryGcePd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskType":
            suggest = "disk_type"
        elif key == "readOnly":
            suggest = "read_only"
        elif key == "sourceImage":
            suggest = "source_image"
        elif key == "sourceSnapshot":
            suggest = "source_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigEphemeralDirectoryGcePd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigEphemeralDirectoryGcePd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigEphemeralDirectoryGcePd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_type: Optional[_builtins.str] = None,
                 read_only: Optional[_builtins.bool] = None,
                 source_image: Optional[_builtins.str] = None,
                 source_snapshot: Optional[_builtins.str] = None):
        """
        :param _builtins.str disk_type: Type of the disk to use. Defaults to `"pd-standard"`.
        :param _builtins.bool read_only: Whether the disk is read only. If true, the disk may be shared by multiple VMs and `sourceSnapshot` must be set.
        :param _builtins.str source_image: Name of the disk image to use as the source for the disk.
               Must be empty `sourceSnapshot` is set.
               Updating `sourceImage` will update content in the ephemeral directory after the workstation is restarted.
        :param _builtins.str source_snapshot: Name of the snapshot to use as the source for the disk.
               Must be empty if `sourceImage` is set.
               Must be empty if `read_only` is false.
               Updating `source_snapshot` will update content in the ephemeral directory after the workstation is restarted.
        """
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[_builtins.str]:
        """
        Type of the disk to use. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[_builtins.bool]:
        """
        Whether the disk is read only. If true, the disk may be shared by multiple VMs and `sourceSnapshot` must be set.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[_builtins.str]:
        """
        Name of the disk image to use as the source for the disk.
        Must be empty `sourceSnapshot` is set.
        Updating `sourceImage` will update content in the ephemeral directory after the workstation is restarted.
        """
        return pulumi.get(self, "source_image")

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[_builtins.str]:
        """
        Name of the snapshot to use as the source for the disk.
        Must be empty if `sourceImage` is set.
        Must be empty if `read_only` is false.
        Updating `source_snapshot` will update content in the ephemeral directory after the workstation is restarted.
        """
        return pulumi.get(self, "source_snapshot")


@pulumi.output_type
class WorkstationConfigHost(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gceInstance":
            suggest = "gce_instance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigHost. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigHost.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigHost.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gce_instance: Optional['outputs.WorkstationConfigHostGceInstance'] = None):
        """
        :param 'WorkstationConfigHostGceInstanceArgs' gce_instance: A runtime using a Compute Engine instance.
               Structure is documented below.
        """
        if gce_instance is not None:
            pulumi.set(__self__, "gce_instance", gce_instance)

    @_builtins.property
    @pulumi.getter(name="gceInstance")
    def gce_instance(self) -> Optional['outputs.WorkstationConfigHostGceInstance']:
        """
        A runtime using a Compute Engine instance.
        Structure is documented below.
        """
        return pulumi.get(self, "gce_instance")


@pulumi.output_type
class WorkstationConfigHostGceInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boostConfigs":
            suggest = "boost_configs"
        elif key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "confidentialInstanceConfig":
            suggest = "confidential_instance_config"
        elif key == "disablePublicIpAddresses":
            suggest = "disable_public_ip_addresses"
        elif key == "disableSsh":
            suggest = "disable_ssh"
        elif key == "enableNestedVirtualization":
            suggest = "enable_nested_virtualization"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "poolSize":
            suggest = "pool_size"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "serviceAccountScopes":
            suggest = "service_account_scopes"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"
        elif key == "vmTags":
            suggest = "vm_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigHostGceInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigHostGceInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigHostGceInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Optional[Sequence['outputs.WorkstationConfigHostGceInstanceAccelerator']] = None,
                 boost_configs: Optional[Sequence['outputs.WorkstationConfigHostGceInstanceBoostConfig']] = None,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 confidential_instance_config: Optional['outputs.WorkstationConfigHostGceInstanceConfidentialInstanceConfig'] = None,
                 disable_public_ip_addresses: Optional[_builtins.bool] = None,
                 disable_ssh: Optional[_builtins.bool] = None,
                 enable_nested_virtualization: Optional[_builtins.bool] = None,
                 machine_type: Optional[_builtins.str] = None,
                 pool_size: Optional[_builtins.int] = None,
                 service_account: Optional[_builtins.str] = None,
                 service_account_scopes: Optional[Sequence[_builtins.str]] = None,
                 shielded_instance_config: Optional['outputs.WorkstationConfigHostGceInstanceShieldedInstanceConfig'] = None,
                 tags: Optional[Sequence[_builtins.str]] = None,
                 vm_tags: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Sequence['WorkstationConfigHostGceInstanceAcceleratorArgs'] accelerators: An accelerator card attached to the instance.
               Structure is documented below.
        :param Sequence['WorkstationConfigHostGceInstanceBoostConfigArgs'] boost_configs: A list of the boost configurations that workstations created using this workstation configuration are allowed to use.
               Structure is documented below.
        :param _builtins.int boot_disk_size_gb: Size of the boot disk in GB.
        :param 'WorkstationConfigHostGceInstanceConfidentialInstanceConfigArgs' confidential_instance_config: A set of Compute Engine Confidential VM instance options.
               Structure is documented below.
        :param _builtins.bool disable_public_ip_addresses: Whether instances have no public IP address.
        :param _builtins.bool disable_ssh: Whether to disable SSH access to the VM.
        :param _builtins.bool enable_nested_virtualization: Whether to enable nested virtualization on the Compute Engine VMs backing the Workstations.
               See https://cloud.google.com/workstations/docs/reference/rest/v1beta/projects.locations.workstationClusters.workstationConfigs#GceInstance.FIELDS.enable_nested_virtualization
        :param _builtins.str machine_type: The name of a Compute Engine machine type.
        :param _builtins.int pool_size: Number of instances to pool for faster workstation startup.
        :param _builtins.str service_account: Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
        :param Sequence[_builtins.str] service_account_scopes: Scopes to grant to the service_account. Various scopes are automatically added based on feature usage. When specified, users of workstations under this configuration must have `iam.serviceAccounts.actAs` on the service account.
        :param 'WorkstationConfigHostGceInstanceShieldedInstanceConfigArgs' shielded_instance_config: A set of Compute Engine Shielded instance options.
               Structure is documented below.
        :param Sequence[_builtins.str] tags: Network tags to add to the Compute Engine machines backing the Workstations.
        :param Mapping[str, _builtins.str] vm_tags: Resource manager tags to be bound to the VM instances backing the Workstations.
               Tag keys and values have the same definition as
               https://cloud.google.com/resource-manager/docs/tags/tags-overview
               Keys must be in the format `tagKeys/{tag_key_id}`, and
               values are in the format `tagValues/456`.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if boost_configs is not None:
            pulumi.set(__self__, "boost_configs", boost_configs)
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if disable_public_ip_addresses is not None:
            pulumi.set(__self__, "disable_public_ip_addresses", disable_public_ip_addresses)
        if disable_ssh is not None:
            pulumi.set(__self__, "disable_ssh", disable_ssh)
        if enable_nested_virtualization is not None:
            pulumi.set(__self__, "enable_nested_virtualization", enable_nested_virtualization)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if pool_size is not None:
            pulumi.set(__self__, "pool_size", pool_size)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_account_scopes is not None:
            pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vm_tags is not None:
            pulumi.set(__self__, "vm_tags", vm_tags)

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.WorkstationConfigHostGceInstanceAccelerator']]:
        """
        An accelerator card attached to the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="boostConfigs")
    def boost_configs(self) -> Optional[Sequence['outputs.WorkstationConfigHostGceInstanceBoostConfig']]:
        """
        A list of the boost configurations that workstations created using this workstation configuration are allowed to use.
        Structure is documented below.
        """
        return pulumi.get(self, "boost_configs")

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size of the boot disk in GB.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional['outputs.WorkstationConfigHostGceInstanceConfidentialInstanceConfig']:
        """
        A set of Compute Engine Confidential VM instance options.
        Structure is documented below.
        """
        return pulumi.get(self, "confidential_instance_config")

    @_builtins.property
    @pulumi.getter(name="disablePublicIpAddresses")
    def disable_public_ip_addresses(self) -> Optional[_builtins.bool]:
        """
        Whether instances have no public IP address.
        """
        return pulumi.get(self, "disable_public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="disableSsh")
    def disable_ssh(self) -> Optional[_builtins.bool]:
        """
        Whether to disable SSH access to the VM.
        """
        return pulumi.get(self, "disable_ssh")

    @_builtins.property
    @pulumi.getter(name="enableNestedVirtualization")
    def enable_nested_virtualization(self) -> Optional[_builtins.bool]:
        """
        Whether to enable nested virtualization on the Compute Engine VMs backing the Workstations.
        See https://cloud.google.com/workstations/docs/reference/rest/v1beta/projects.locations.workstationClusters.workstationConfigs#GceInstance.FIELDS.enable_nested_virtualization
        """
        return pulumi.get(self, "enable_nested_virtualization")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The name of a Compute Engine machine type.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> Optional[_builtins.int]:
        """
        Number of instances to pool for faster workstation startup.
        """
        return pulumi.get(self, "pool_size")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[_builtins.str]:
        """
        Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Scopes to grant to the service_account. Various scopes are automatically added based on feature usage. When specified, users of workstations under this configuration must have `iam.serviceAccounts.actAs` on the service account.
        """
        return pulumi.get(self, "service_account_scopes")

    @_builtins.property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional['outputs.WorkstationConfigHostGceInstanceShieldedInstanceConfig']:
        """
        A set of Compute Engine Shielded instance options.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_config")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[_builtins.str]]:
        """
        Network tags to add to the Compute Engine machines backing the Workstations.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vmTags")
    def vm_tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Resource manager tags to be bound to the VM instances backing the Workstations.
        Tag keys and values have the same definition as
        https://cloud.google.com/resource-manager/docs/tags/tags-overview
        Keys must be in the format `tagKeys/{tag_key_id}`, and
        values are in the format `tagValues/456`.
        """
        return pulumi.get(self, "vm_tags")


@pulumi.output_type
class WorkstationConfigHostGceInstanceAccelerator(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.int count: Number of accelerator cards exposed to the instance.
        :param _builtins.str type: Type of accelerator resource to attach to the instance, for example, "nvidia-tesla-p100".
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Number of accelerator cards exposed to the instance.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of accelerator resource to attach to the instance, for example, "nvidia-tesla-p100".
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkstationConfigHostGceInstanceBoostConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "enableNestedVirtualization":
            suggest = "enable_nested_virtualization"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "poolSize":
            suggest = "pool_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigHostGceInstanceBoostConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigHostGceInstanceBoostConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigHostGceInstanceBoostConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 accelerators: Optional[Sequence['outputs.WorkstationConfigHostGceInstanceBoostConfigAccelerator']] = None,
                 boot_disk_size_gb: Optional[_builtins.int] = None,
                 enable_nested_virtualization: Optional[_builtins.bool] = None,
                 machine_type: Optional[_builtins.str] = None,
                 pool_size: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: The id to be used for the boost config.
        :param Sequence['WorkstationConfigHostGceInstanceBoostConfigAcceleratorArgs'] accelerators: An accelerator card attached to the boost instance.
               Structure is documented below.
        :param _builtins.int boot_disk_size_gb: Size of the boot disk in GB. The minimum boot disk size is `30` GB. Defaults to `50` GB.
        :param _builtins.bool enable_nested_virtualization: Whether to enable nested virtualization on the Compute Engine VMs backing boosted Workstations.
               See https://cloud.google.com/workstations/docs/reference/rest/v1beta/projects.locations.workstationClusters.workstationConfigs#GceInstance.FIELDS.enable_nested_virtualization
        :param _builtins.str machine_type: The type of machine that boosted VM instances will use—for example, e2-standard-4. For more information about machine types that Cloud Workstations supports, see the list of available machine types https://cloud.google.com/workstations/docs/available-machine-types. Defaults to e2-standard-4.
        :param _builtins.int pool_size: Number of instances to pool for faster workstation boosting.
        """
        pulumi.set(__self__, "id", id)
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if boot_disk_size_gb is not None:
            pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        if enable_nested_virtualization is not None:
            pulumi.set(__self__, "enable_nested_virtualization", enable_nested_virtualization)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if pool_size is not None:
            pulumi.set(__self__, "pool_size", pool_size)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id to be used for the boost config.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def accelerators(self) -> Optional[Sequence['outputs.WorkstationConfigHostGceInstanceBoostConfigAccelerator']]:
        """
        An accelerator card attached to the boost instance.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerators")

    @_builtins.property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Size of the boot disk in GB. The minimum boot disk size is `30` GB. Defaults to `50` GB.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="enableNestedVirtualization")
    def enable_nested_virtualization(self) -> Optional[_builtins.bool]:
        """
        Whether to enable nested virtualization on the Compute Engine VMs backing boosted Workstations.
        See https://cloud.google.com/workstations/docs/reference/rest/v1beta/projects.locations.workstationClusters.workstationConfigs#GceInstance.FIELDS.enable_nested_virtualization
        """
        return pulumi.get(self, "enable_nested_virtualization")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[_builtins.str]:
        """
        The type of machine that boosted VM instances will use—for example, e2-standard-4. For more information about machine types that Cloud Workstations supports, see the list of available machine types https://cloud.google.com/workstations/docs/available-machine-types. Defaults to e2-standard-4.
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter(name="poolSize")
    def pool_size(self) -> Optional[_builtins.int]:
        """
        Number of instances to pool for faster workstation boosting.
        """
        return pulumi.get(self, "pool_size")


@pulumi.output_type
class WorkstationConfigHostGceInstanceBoostConfigAccelerator(dict):
    def __init__(__self__, *,
                 count: _builtins.int,
                 type: _builtins.str):
        """
        :param _builtins.int count: Number of accelerator cards exposed to the instance.
        :param _builtins.str type: Type of accelerator resource to attach to the instance, for example, "nvidia-tesla-p100".
        """
        pulumi.set(__self__, "count", count)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def count(self) -> _builtins.int:
        """
        Number of accelerator cards exposed to the instance.
        """
        return pulumi.get(self, "count")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of accelerator resource to attach to the instance, for example, "nvidia-tesla-p100".
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkstationConfigHostGceInstanceConfidentialInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableConfidentialCompute":
            suggest = "enable_confidential_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigHostGceInstanceConfidentialInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigHostGceInstanceConfidentialInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigHostGceInstanceConfidentialInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_confidential_compute: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_confidential_compute: Whether the instance has confidential compute enabled.
        """
        if enable_confidential_compute is not None:
            pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)

    @_builtins.property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> Optional[_builtins.bool]:
        """
        Whether the instance has confidential compute enabled.
        """
        return pulumi.get(self, "enable_confidential_compute")


@pulumi.output_type
class WorkstationConfigHostGceInstanceShieldedInstanceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigHostGceInstanceShieldedInstanceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigHostGceInstanceShieldedInstanceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigHostGceInstanceShieldedInstanceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: Optional[_builtins.bool] = None,
                 enable_secure_boot: Optional[_builtins.bool] = None,
                 enable_vtpm: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool enable_integrity_monitoring: Whether the instance has integrity monitoring enabled.
        :param _builtins.bool enable_secure_boot: Whether the instance has Secure Boot enabled.
        :param _builtins.bool enable_vtpm: Whether the instance has the vTPM enabled.
        """
        if enable_integrity_monitoring is not None:
            pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        if enable_secure_boot is not None:
            pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        if enable_vtpm is not None:
            pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @_builtins.property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> Optional[_builtins.bool]:
        """
        Whether the instance has integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @_builtins.property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> Optional[_builtins.bool]:
        """
        Whether the instance has Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @_builtins.property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> Optional[_builtins.bool]:
        """
        Whether the instance has the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class WorkstationConfigIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class WorkstationConfigIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class WorkstationConfigPersistentDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcePd":
            suggest = "gce_pd"
        elif key == "mountPath":
            suggest = "mount_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigPersistentDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigPersistentDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigPersistentDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gce_pd: Optional['outputs.WorkstationConfigPersistentDirectoryGcePd'] = None,
                 mount_path: Optional[_builtins.str] = None):
        """
        :param 'WorkstationConfigPersistentDirectoryGcePdArgs' gce_pd: A directory to persist across workstation sessions, backed by a Compute Engine regional persistent disk. Can only be updated if not empty during creation.
               Structure is documented below.
        :param _builtins.str mount_path: Location of this directory in the running workstation.
        """
        if gce_pd is not None:
            pulumi.set(__self__, "gce_pd", gce_pd)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)

    @_builtins.property
    @pulumi.getter(name="gcePd")
    def gce_pd(self) -> Optional['outputs.WorkstationConfigPersistentDirectoryGcePd']:
        """
        A directory to persist across workstation sessions, backed by a Compute Engine regional persistent disk. Can only be updated if not empty during creation.
        Structure is documented below.
        """
        return pulumi.get(self, "gce_pd")

    @_builtins.property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[_builtins.str]:
        """
        Location of this directory in the running workstation.
        """
        return pulumi.get(self, "mount_path")


@pulumi.output_type
class WorkstationConfigPersistentDirectoryGcePd(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskType":
            suggest = "disk_type"
        elif key == "fsType":
            suggest = "fs_type"
        elif key == "reclaimPolicy":
            suggest = "reclaim_policy"
        elif key == "sizeGb":
            suggest = "size_gb"
        elif key == "sourceSnapshot":
            suggest = "source_snapshot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkstationConfigPersistentDirectoryGcePd. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkstationConfigPersistentDirectoryGcePd.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkstationConfigPersistentDirectoryGcePd.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_type: Optional[_builtins.str] = None,
                 fs_type: Optional[_builtins.str] = None,
                 reclaim_policy: Optional[_builtins.str] = None,
                 size_gb: Optional[_builtins.int] = None,
                 source_snapshot: Optional[_builtins.str] = None):
        """
        :param _builtins.str disk_type: Type of the disk to use. Defaults to `"pd-standard"`.
        :param _builtins.str fs_type: Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if `sourceSnapshot` is set. Defaults to `ext4`.
        :param _builtins.str reclaim_policy: Whether the persistent disk should be deleted when the workstation is deleted. Valid values are `DELETE` and `RETAIN`. Defaults to `DELETE`.
               Possible values are: `DELETE`, `RETAIN`.
        :param _builtins.int size_gb: The GB capacity of a persistent home directory for each workstation created with this configuration. Must be empty if `sourceSnapshot` is set.
               Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`. Defaults to `200`. If less than `200` GB, the `diskType` must be `pd-balanced` or `pd-ssd`.
        :param _builtins.str source_snapshot: Name of the snapshot to use as the source for the disk.
               Must be empty if `sourceImage` is set.
               Must be empty if `read_only` is false.
               Updating `source_snapshot` will update content in the ephemeral directory after the workstation is restarted.
        """
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if fs_type is not None:
            pulumi.set(__self__, "fs_type", fs_type)
        if reclaim_policy is not None:
            pulumi.set(__self__, "reclaim_policy", reclaim_policy)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)

    @_builtins.property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[_builtins.str]:
        """
        Type of the disk to use. Defaults to `"pd-standard"`.
        """
        return pulumi.get(self, "disk_type")

    @_builtins.property
    @pulumi.getter(name="fsType")
    def fs_type(self) -> Optional[_builtins.str]:
        """
        Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if `sourceSnapshot` is set. Defaults to `ext4`.
        """
        return pulumi.get(self, "fs_type")

    @_builtins.property
    @pulumi.getter(name="reclaimPolicy")
    def reclaim_policy(self) -> Optional[_builtins.str]:
        """
        Whether the persistent disk should be deleted when the workstation is deleted. Valid values are `DELETE` and `RETAIN`. Defaults to `DELETE`.
        Possible values are: `DELETE`, `RETAIN`.
        """
        return pulumi.get(self, "reclaim_policy")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[_builtins.int]:
        """
        The GB capacity of a persistent home directory for each workstation created with this configuration. Must be empty if `sourceSnapshot` is set.
        Valid values are `10`, `50`, `100`, `200`, `500`, or `1000`. Defaults to `200`. If less than `200` GB, the `diskType` must be `pd-balanced` or `pd-ssd`.
        """
        return pulumi.get(self, "size_gb")

    @_builtins.property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[_builtins.str]:
        """
        Name of the snapshot to use as the source for the disk.
        Must be empty if `sourceImage` is set.
        Must be empty if `read_only` is false.
        Updating `source_snapshot` will update content in the ephemeral directory after the workstation is restarted.
        """
        return pulumi.get(self, "source_snapshot")


@pulumi.output_type
class WorkstationConfigReadinessCheck(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 port: _builtins.int):
        """
        :param _builtins.str path: Path to which the request should be sent.
        :param _builtins.int port: Port to which the request should be sent.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to which the request should be sent.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        Port to which the request should be sent.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class WorkstationIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class WorkstationIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: _builtins.str,
                 title: _builtins.str,
                 description: Optional[_builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def expression(self) -> _builtins.str:
        return pulumi.get(self, "expression")

    @_builtins.property
    @pulumi.getter
    def title(self) -> _builtins.str:
        return pulumi.get(self, "title")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "description")


