# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..types.integrations_response import IntegrationsResponse
from .types.integrations_fetch_response import IntegrationsFetchResponse


class RawIntegrationsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def fetch(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[IntegrationsFetchResponse]:
        """
        Retrieve a list of all available provider integrations on the API.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IntegrationsFetchResponse]
            Returns list of all available integrations on the API
        """
        _response = self._client_wrapper.httpx_client.request(
            "integrations",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IntegrationsFetchResponse,
                    construct_type(
                        type_=IntegrationsFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def detailedfetch(
        self, *, sdk: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[IntegrationsResponse]:
        """
        Retrieve a detailed list of supported integrations, optionally filtered by the developer's enabled integrations and the requirement for SDK usage.

        Parameters
        ----------
        sdk : typing.Optional[bool]
            If `true`, allows SDK integrations to be included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IntegrationsResponse]
            Successful response containing a list of integrations.
        """
        _response = self._client_wrapper.httpx_client.request(
            "integrations/detailed",
            method="GET",
            params={
                "sdk": sdk,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IntegrationsResponse,
                    construct_type(
                        type_=IntegrationsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawIntegrationsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def fetch(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[IntegrationsFetchResponse]:
        """
        Retrieve a list of all available provider integrations on the API.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IntegrationsFetchResponse]
            Returns list of all available integrations on the API
        """
        _response = await self._client_wrapper.httpx_client.request(
            "integrations",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IntegrationsFetchResponse,
                    construct_type(
                        type_=IntegrationsFetchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def detailedfetch(
        self, *, sdk: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[IntegrationsResponse]:
        """
        Retrieve a detailed list of supported integrations, optionally filtered by the developer's enabled integrations and the requirement for SDK usage.

        Parameters
        ----------
        sdk : typing.Optional[bool]
            If `true`, allows SDK integrations to be included in the response.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IntegrationsResponse]
            Successful response containing a list of integrations.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "integrations/detailed",
            method="GET",
            params={
                "sdk": sdk,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IntegrationsResponse,
                    construct_type(
                        type_=IntegrationsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
