# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .distance_sample import DistanceSample
from .elevation_sample import ElevationSample
from .floors_climbed_sample import FloorsClimbedSample
from .step_sample import StepSample


class DistanceDataDetailed(UncheckedBaseModel):
    distance_samples: typing.Optional[typing.List[DistanceSample]] = pydantic.Field(default=None)
    """
    Array of detailed samples of distance covered throughout the workout.
    """

    elevation_samples: typing.Optional[typing.List[ElevationSample]] = pydantic.Field(default=None)
    """
    Array of detailed samples of elevation throughout the workout.
    """

    floors_climbed_samples: typing.Optional[typing.List[FloorsClimbedSample]] = pydantic.Field(default=None)
    """
    Array of detailed samples of floors climbed throughout the workout, as determined by the fitness data provider.
    """

    step_samples: typing.Optional[typing.List[StepSample]] = pydantic.Field(default=None)
    """
    Array of detailed samples of steps performed throughout the workout.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
