# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ElevationData(UncheckedBaseModel):
    avg_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Average elevation of the user throughout the workout.
    """

    gain_actual_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Planned elevation gain for the workout.
    """

    gain_planned_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Elevation gain of the user throughout the workout - this includes all elevation gain, and does _not_ represent net gain.
    """

    loss_actual_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Elevation loss of the user throughout the workout.
    """

    max_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum elevation of the user during the workout.
    """

    min_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Minimum elevation of the user during the workout.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
