# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .hr_planned_workout_step_target_target_type import HrPlannedWorkoutStepTargetTargetType


class HrPlannedWorkoutStepTarget(UncheckedBaseModel):
    hr_percentage_low: typing.Optional[float] = pydantic.Field(default=None)
    """
    Maximum max heart rate percentage threshold for the workout step - i.e. the user is to stay under this value during the workout step
    """

    target_type: typing.Optional[HrPlannedWorkoutStepTargetTargetType] = pydantic.Field(default=None)
    """
    Type of target for the workout - i.e. metric type for which a criterion must be met for the workout to be completed
    """

    hr_percentage_high: typing.Optional[float] = pydantic.Field(default=None)
    """
    Minimum heart rate percentage threshold for the workout step - i.e. the user is to stay above this value during the workout
    """

    hr_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Ideal percentage of user's maximum HR to be maintained workout step
    """

    hr_bpm_high: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum heart rate threshold for the workout step - i.e. the user is to stay under this value during the workout step
    """

    hr_bpm_low: typing.Optional[int] = pydantic.Field(default=None)
    """
    Minimum heart rate threshold for the workout step - i.e. the user is to stay above this value during the workout
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
