# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .nutrition_macros import NutritionMacros
from .nutrition_micros import NutritionMicros


class NutritionSummary(UncheckedBaseModel):
    macros: typing.Optional[NutritionMacros] = pydantic.Field(default=None)
    """
    Summary of macronutrient information for a given day.
    """

    micros: typing.Optional[NutritionMicros] = pydantic.Field(default=None)
    """
    Summary of micronutrient information for a given day.
    """

    water_ml: typing.Optional[float] = pydantic.Field(default=None)
    """
    Water consumption of the user for a given day.
    """

    drink_ml: typing.Optional[float] = pydantic.Field(default=None)
    """
    Non-water drink consumption of the user for a given day.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
