# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .planned_workout_metadata_type import PlannedWorkoutMetadataType


class PlannedWorkoutMetadata(UncheckedBaseModel):
    estimated_energy_kj: typing.Optional[float] = pydantic.Field(default=None)
    """
    Estimated energy expenditure for the workout
    """

    estimated_speed_meters_per_second: typing.Optional[float] = pydantic.Field(default=None)
    """
    Estimated speed for the workout
    """

    estimated_elevation_gain_meters: typing.Optional[float] = pydantic.Field(default=None)
    """
    Estimated elevation gain for the workout
    """

    estimated_tss: typing.Optional[float] = pydantic.Field(default=None)
    """
    Estimated Training Stress Score for the workout
    """

    estimated_calories: typing.Optional[int] = pydantic.Field(default=None)
    """
    Estimated calorie burn for the workout
    """

    created_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The creation datetime of the associated workout, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time
    """

    planned_date: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The planned start datetime, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time
    """

    type: typing.Optional[PlannedWorkoutMetadataType] = pydantic.Field(default=None)
    """
    The name - either user-entered or given by the fitness data provider - of the associated workout plan
    """

    id: typing.Optional[str] = None
    estimated_duration_seconds: typing.Optional[int] = pydantic.Field(default=None)
    """
    Estimated workout duration
    """

    estimated_pace_minutes_per_kilometer: typing.Optional[float] = pydantic.Field(default=None)
    """
    Estimated pace for the workout
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the original source of the workout plan
    """

    estimated_tscore: typing.Optional[float] = pydantic.Field(default=None)
    """
    Estimated training stress score for the workout (normalized power-based metric)
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the workout
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the workout plan
    """

    estimated_distance_meters: typing.Optional[int] = pydantic.Field(default=None)
    """
    Estimated distance for the workout
    """

    estimated_if: typing.Optional[float] = pydantic.Field(default=None)
    """
    Estimated Intensity Factor for the workout
    """

    pool_length_meters: typing.Optional[int] = pydantic.Field(default=None)
    """
    Pool length of the pool used for the workout - only relevant for swimming activity types
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
