# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .planned_workout_step import PlannedWorkoutStep
from .planned_workout_step_duration import PlannedWorkoutStepDuration
from .planned_workout_step_target import PlannedWorkoutStepTarget


class PlannedWorkoutRepeatStep(UncheckedBaseModel):
    targets: typing.Optional[typing.List[PlannedWorkoutStepTarget]] = pydantic.Field(default=None)
    """
    List of targets for the workout
    """

    steps: typing.Optional[typing.List[PlannedWorkoutStep]] = pydantic.Field(default=None)
    """
    List of steps to be repeated for this workout step - e.g. if a user wants to schedule 5 repetitions of 100m sprints plus 20s rest in between
    """

    intensity: typing.Optional[int] = pydantic.Field(default=None)
    """
    Planned intensity for the workout step
    """

    order: typing.Optional[int] = pydantic.Field(default=None)
    """
    Position of the workout step in the overall workout
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of workout step
    """

    durations: typing.Optional[typing.List[PlannedWorkoutStepDuration]] = pydantic.Field(default=None)
    """
    List of conditions to be fulfilled for the workout step to be completed - all of the conditions must be completed
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of workout step
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
