# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .snoring_sample import SnoringSample


class SnoringData(UncheckedBaseModel):
    start_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    The start time of the recording of snoring data, in ISO8601 format with microsecond precision. Will always fall on midnight of any given day, and will always be equal to 24h before end_time. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    end_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    The end time of the recording of snoring data, in ISO8601 format with microsecond precision. TimeZone info will be provided whenever possible. If absent, the time corresponds to the user's local time.
    """

    num_snoring_events: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of times over the sleep period when the user started snoring, as determined by the device.
    """

    samples: typing.Optional[typing.List[SnoringSample]] = pydantic.Field(default=None)
    """
    List of snoring information data points sampled throughout the sleep session.
    """

    total_snoring_duration_seconds: typing.Optional[float] = pydantic.Field(default=None)
    """
    Total duration for which the user was snoring.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
