# pnap-location-api
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 2.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://phoenixnap.com](https://phoenixnap.com)

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

You can install this package directly from the [Python Package Index](https://pypi.org/) using:

```sh
$ pip install pnap_location_api
```

Then import the package:
```python
import pnap_location_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pnap_location_api
```

```python

import time
import pnap_location_api
from pnap_location_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.phoenixnap.com/location-api/v1
# See configuration.py for a list of all supported configuration parameters.
configuration = pnap_location_api.Configuration(
    host = "https://api.phoenixnap.com/location-api/v1"
)



# Enter a context with an instance of the API client
with pnap_location_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pnap_location_api.LocationsApi(api_client)
    location = pnap_location_api.LocationEnum() # LocationEnum | Location of interest (optional)
    product_category = pnap_location_api.ProductCategoryEnum() # ProductCategoryEnum | Product category of interest (optional)

    try:
        # Get All Locations
        api_response = api_instance.get_locations(location=location, product_category=product_category)
        print("The response of LocationsApi->get_locations:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling LocationsApi->get_locations: %s\n" % e)

```

To generate a token using the [python-keycloak](https://pypi.org/project/python-keycloak/) library:
```python
from keycloak import KeycloakOpenID

clientId = "YOUR_CLIENT_ID"
clientSecret = "YOUR_CLIENT_SECRET"
serverUrl = "https://auth.phoenixnap.com/auth/"
realmName = "BMC"
grantType = "client_credentials"

keycloakOpenId =  KeycloakOpenID(server_url=serverUrl,
                        realm_name=realmName,
                        client_id=clientId,
                        client_secret_key=clientSecret)

ACCESS_TOKEN = keycloakOpenId.token(grant_type=grantType)['access_token']


## Documentation for API Endpoints

All URIs are relative to *https://api.phoenixnap.com/location-api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*LocationsApi* | [**get_locations**](docs/LocationsApi.md#get_locations) | **GET** /locations | Get All Locations


## Documentation For Models

 - [Error](docs/Error.md)
 - [Location](docs/Location.md)
 - [LocationEnum](docs/LocationEnum.md)
 - [ProductCategory](docs/ProductCategory.md)
 - [ProductCategoryEnum](docs/ProductCategoryEnum.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author

support@phoenixnap.com

