# coding: utf-8

"""
    Locations API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 1.0
    Contact: support@phoenixnap.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, ClassVar, Dict, List, Optional
from pydantic import BaseModel, StrictStr
from pydantic import Field
from pnap_location_api.models.location_enum import LocationEnum
from pnap_location_api.models.product_category import ProductCategory
try:
    from typing import Self
except ImportError:
    from typing_extensions import Self

class Location(BaseModel):
    """
    Location resource
    """ # noqa: E501
    location: LocationEnum
    location_description: Optional[StrictStr] = Field(default=None, alias="locationDescription")
    product_categories: Optional[List[ProductCategory]] = Field(default=None, alias="productCategories")
    __properties: ClassVar[List[str]] = ["location", "locationDescription", "productCategories"]

    model_config = {
        "populate_by_name": True,
        "validate_assignment": True,
        "protected_namespaces": (),
    }


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of Location from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        _dict = self.model_dump(
            by_alias=True,
            exclude={
            },
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in product_categories (list)
        _items = []
        if self.product_categories:
            for _item in self.product_categories:
                if _item:
                    _items.append(_item.to_dict())
            _dict['productCategories'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Dict) -> Self:
        """Create an instance of Location from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "location": obj.get("location"),
            "locationDescription": obj.get("locationDescription"),
            "productCategories": [ProductCategory.from_dict(_item) for _item in obj.get("productCategories")] if obj.get("productCategories") is not None else None
        })
        return _obj


