"""
This file is auto generated. Do not edit this file manually.
Source code: [monorepo]/contracts/generator.py
"""

import datetime
import typing
from dataclasses import dataclass, field

CommonFileNodePathPartsItem = str

CommonFileNodePathParts = typing.List[CommonFileNodePathPartsItem]

CommonFileNodeSize = int

CommonFileNodeLastModified = datetime.datetime

CommonFileNodeType = typing.Union[typing.Literal["file"], typing.Literal["directory"]]

CommonFileNodeTypeValues: typing.List[CommonFileNodeType] = ["file", "directory"]

CommonFileNodeChildrenItemItem = str

CommonFileNodeChildrenItem = typing.List[CommonFileNodeChildrenItemItem]

CommonFileNodeChildren = typing.List[CommonFileNodeChildrenItem]


@dataclass
class CommonFileNode:
    path_parts: CommonFileNodePathParts
    size: CommonFileNodeSize
    last_modified: CommonFileNodeLastModified
    type: CommonFileNodeType
    children: typing.Optional[CommonFileNodeChildren] = field(
        default_factory=lambda: []
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["pathParts"] = self.path_parts
        data["size"] = self.size
        data["lastModified"] = self.last_modified.isoformat()
        data["type"] = self.type
        if self.children is not None:
            data["children"] = [item for item in self.children]
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonFileNode":
        return cls(
            path_parts=[str(item) for item in data["pathParts"]],
            size=int(data["size"]),
            last_modified=datetime.datetime.fromisoformat(data["lastModified"]),
            type=data["type"],
            children=None
            if data.get("children") is None
            else [[str(item) for item in item] for item in data["children"]],
        )


CommonPartialFeatureFlagsPROJECTLIVE = bool

CommonPartialFeatureFlagsALLOWRELEASE = bool

CommonPartialFeatureFlagsCONNECTORSCONSOLE = bool

CommonPartialFeatureFlagsDUPLICATEPROJECTS = bool

CommonPartialFeatureFlagsWEBEDITOR = bool

CommonPartialFeatureFlagsLANGCHAINSMARTCHAT = bool


@dataclass
class CommonPartialFeatureFlags:
    p_r_o_j_e_c_t__l_i_v_e: typing.Optional[CommonPartialFeatureFlagsPROJECTLIVE] = (
        field(default_factory=lambda: None)
    )
    a_l_l_o_w__r_e_l_e_a_s_e: typing.Optional[CommonPartialFeatureFlagsALLOWRELEASE] = (
        field(default_factory=lambda: None)
    )
    c_o_n_n_e_c_t_o_r_s__c_o_n_s_o_l_e: typing.Optional[
        CommonPartialFeatureFlagsCONNECTORSCONSOLE
    ] = field(default_factory=lambda: None)
    d_u_p_l_i_c_a_t_e__p_r_o_j_e_c_t_s: typing.Optional[
        CommonPartialFeatureFlagsDUPLICATEPROJECTS
    ] = field(default_factory=lambda: None)
    w_e_b__e_d_i_t_o_r: typing.Optional[CommonPartialFeatureFlagsWEBEDITOR] = field(
        default_factory=lambda: None
    )
    l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t: typing.Optional[
        CommonPartialFeatureFlagsLANGCHAINSMARTCHAT
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.p_r_o_j_e_c_t__l_i_v_e is not None:
            data["PROJECT_LIVE"] = self.p_r_o_j_e_c_t__l_i_v_e
        if self.a_l_l_o_w__r_e_l_e_a_s_e is not None:
            data["ALLOW_RELEASE"] = self.a_l_l_o_w__r_e_l_e_a_s_e
        if self.c_o_n_n_e_c_t_o_r_s__c_o_n_s_o_l_e is not None:
            data["CONNECTORS_CONSOLE"] = self.c_o_n_n_e_c_t_o_r_s__c_o_n_s_o_l_e
        if self.d_u_p_l_i_c_a_t_e__p_r_o_j_e_c_t_s is not None:
            data["DUPLICATE_PROJECTS"] = self.d_u_p_l_i_c_a_t_e__p_r_o_j_e_c_t_s
        if self.w_e_b__e_d_i_t_o_r is not None:
            data["WEB_EDITOR"] = self.w_e_b__e_d_i_t_o_r
        if self.l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t is not None:
            data["LANGCHAIN_SMART_CHAT"] = self.l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonPartialFeatureFlags":
        return cls(
            p_r_o_j_e_c_t__l_i_v_e=None
            if data.get("PROJECT_LIVE") is None
            else bool(data["PROJECT_LIVE"]),
            a_l_l_o_w__r_e_l_e_a_s_e=None
            if data.get("ALLOW_RELEASE") is None
            else bool(data["ALLOW_RELEASE"]),
            c_o_n_n_e_c_t_o_r_s__c_o_n_s_o_l_e=None
            if data.get("CONNECTORS_CONSOLE") is None
            else bool(data["CONNECTORS_CONSOLE"]),
            d_u_p_l_i_c_a_t_e__p_r_o_j_e_c_t_s=None
            if data.get("DUPLICATE_PROJECTS") is None
            else bool(data["DUPLICATE_PROJECTS"]),
            w_e_b__e_d_i_t_o_r=None
            if data.get("WEB_EDITOR") is None
            else bool(data["WEB_EDITOR"]),
            l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t=None
            if data.get("LANGCHAIN_SMART_CHAT") is None
            else bool(data["LANGCHAIN_SMART_CHAT"]),
        )


CommonPartialBillingMetadataPlan = str

CommonPartialBillingMetadataExpires = str

CommonPartialBillingMetadataMessage = str

CommonPartialBillingMetadataMessageLink = str

CommonPartialBillingMetadataMessageCTA = str


@dataclass
class CommonPartialBillingMetadata:
    plan: typing.Optional[CommonPartialBillingMetadataPlan] = field(
        default_factory=lambda: None
    )
    expires: typing.Optional[CommonPartialBillingMetadataExpires] = field(
        default_factory=lambda: None
    )
    message: typing.Optional[CommonPartialBillingMetadataMessage] = field(
        default_factory=lambda: None
    )
    message_link: typing.Optional[CommonPartialBillingMetadataMessageLink] = field(
        default_factory=lambda: None
    )
    message_c_t_a: typing.Optional[CommonPartialBillingMetadataMessageCTA] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.plan is not None:
            data["plan"] = self.plan
        if self.expires is not None:
            data["expires"] = self.expires
        if self.message is not None:
            data["message"] = self.message
        if self.message_link is not None:
            data["messageLink"] = self.message_link
        if self.message_c_t_a is not None:
            data["messageCTA"] = self.message_c_t_a
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonPartialBillingMetadata":
        return cls(
            plan=None if data.get("plan") is None else str(data["plan"]),
            expires=None if data.get("expires") is None else str(data["expires"]),
            message=None if data.get("message") is None else str(data["message"]),
            message_link=None
            if data.get("messageLink") is None
            else str(data["messageLink"]),
            message_c_t_a=None
            if data.get("messageCTA") is None
            else str(data["messageCTA"]),
        )


CommonRoleId = str

CommonRoleName = str

CommonRoleDescription = str

CommonRoleProjectId = str

CommonRoleCreatedAt = str


@dataclass
class CommonRole:
    id: CommonRoleId
    name: CommonRoleName
    project_id: CommonRoleProjectId
    created_at: CommonRoleCreatedAt
    description: typing.Optional[CommonRoleDescription] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["name"] = self.name
        data["projectId"] = self.project_id
        data["createdAt"] = self.created_at
        if self.description is not None:
            data["description"] = self.description
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonRole":
        return cls(
            id=str(data["id"]),
            name=str(data["name"]),
            project_id=str(data["projectId"]),
            created_at=str(data["createdAt"]),
            description=None
            if data.get("description") is None
            else str(data["description"]),
        )


CommonProjectId = str

CommonProjectFolderId = str

CommonProjectName = str

CommonProjectSubdomain = str

CommonProjectOrganizationId = str

CommonProjectDeploymentResourcesWatermarkEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonProjectDeploymentResourcesWatermarkEnabledValues: typing.List[
    CommonProjectDeploymentResourcesWatermarkEnabled
] = ["true", "false"]

CommonProjectDeploymentResourcesSeleniumInstanceEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonProjectDeploymentResourcesSeleniumInstanceEnabledValues: typing.List[
    CommonProjectDeploymentResourcesSeleniumInstanceEnabled
] = ["true", "false"]

CommonProjectDeploymentResourcesNotificationsEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonProjectDeploymentResourcesNotificationsEnabledValues: typing.List[
    CommonProjectDeploymentResourcesNotificationsEnabled
] = ["true", "false"]

CommonProjectDeploymentResourcesRequestsCPU = str

CommonProjectDeploymentResourcesLimitsCPU = str

CommonProjectDeploymentResourcesRequestsMemory = str

CommonProjectDeploymentResourcesLimitsMemory = str

CommonProjectDeploymentResourcesMinReplicas = str

CommonProjectDeploymentResourcesComputeUnits = float

CommonProjectDeploymentResourcesTimeoutSeconds = str

CommonProjectDeploymentResourcesWorkerType = typing.Union[
    typing.Literal["jusbrasil"],
    typing.Literal["clickbus"],
    typing.Literal["touchsuite"],
    typing.Literal["foursquare"],
    typing.Literal["estoca"],
    typing.Literal["estoca-test"],
    typing.Literal["irko"],
    typing.Literal["dr9"],
    typing.Literal["onfly"],
    typing.Literal["shared"],
    typing.Literal["test"],
]

CommonProjectDeploymentResourcesWorkerTypeValues: typing.List[
    CommonProjectDeploymentResourcesWorkerType
] = [
    "jusbrasil",
    "clickbus",
    "touchsuite",
    "foursquare",
    "estoca",
    "estoca-test",
    "irko",
    "dr9",
    "onfly",
    "shared",
    "test",
]

CommonProjectDeploymentResourcesPythonVersion = typing.Union[
    typing.Literal["3.9"],
    typing.Literal["3.10"],
    typing.Literal["3.11"],
    typing.Literal["3.12"],
]

CommonProjectDeploymentResourcesPythonVersionValues: typing.List[
    CommonProjectDeploymentResourcesPythonVersion
] = ["3.9", "3.10", "3.11", "3.12"]

CommonProjectDeploymentResourcesWorkerNumber = str

CommonProjectDeploymentResourcesBaseDockerfile = str


@dataclass
class CommonProjectDeploymentResources:
    watermark_enabled: typing.Optional[
        CommonProjectDeploymentResourcesWatermarkEnabled
    ] = field(default_factory=lambda: None)
    selenium_instance_enabled: typing.Optional[
        CommonProjectDeploymentResourcesSeleniumInstanceEnabled
    ] = field(default_factory=lambda: None)
    notifications_enabled: typing.Optional[
        CommonProjectDeploymentResourcesNotificationsEnabled
    ] = field(default_factory=lambda: None)
    requests_c_p_u: typing.Optional[CommonProjectDeploymentResourcesRequestsCPU] = (
        field(default_factory=lambda: None)
    )
    limits_c_p_u: typing.Optional[CommonProjectDeploymentResourcesLimitsCPU] = field(
        default_factory=lambda: None
    )
    requests_memory: typing.Optional[CommonProjectDeploymentResourcesRequestsMemory] = (
        field(default_factory=lambda: None)
    )
    limits_memory: typing.Optional[CommonProjectDeploymentResourcesLimitsMemory] = (
        field(default_factory=lambda: None)
    )
    min_replicas: typing.Optional[CommonProjectDeploymentResourcesMinReplicas] = field(
        default_factory=lambda: None
    )
    compute_units: typing.Optional[CommonProjectDeploymentResourcesComputeUnits] = (
        field(default_factory=lambda: None)
    )
    timeout_seconds: typing.Optional[CommonProjectDeploymentResourcesTimeoutSeconds] = (
        field(default_factory=lambda: None)
    )
    worker_type: typing.Optional[CommonProjectDeploymentResourcesWorkerType] = field(
        default_factory=lambda: None
    )
    python_version: typing.Optional[CommonProjectDeploymentResourcesPythonVersion] = (
        field(default_factory=lambda: None)
    )
    worker_number: typing.Optional[CommonProjectDeploymentResourcesWorkerNumber] = (
        field(default_factory=lambda: None)
    )
    base_dockerfile: typing.Optional[CommonProjectDeploymentResourcesBaseDockerfile] = (
        field(default_factory=lambda: None)
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.watermark_enabled is not None:
            data["watermarkEnabled"] = self.watermark_enabled
        if self.selenium_instance_enabled is not None:
            data["seleniumInstanceEnabled"] = self.selenium_instance_enabled
        if self.notifications_enabled is not None:
            data["notificationsEnabled"] = self.notifications_enabled
        if self.requests_c_p_u is not None:
            data["requestsCPU"] = self.requests_c_p_u
        if self.limits_c_p_u is not None:
            data["limitsCPU"] = self.limits_c_p_u
        if self.requests_memory is not None:
            data["requestsMemory"] = self.requests_memory
        if self.limits_memory is not None:
            data["limitsMemory"] = self.limits_memory
        if self.min_replicas is not None:
            data["minReplicas"] = self.min_replicas
        if self.compute_units is not None:
            data["computeUnits"] = self.compute_units
        if self.timeout_seconds is not None:
            data["timeoutSeconds"] = self.timeout_seconds
        if self.worker_type is not None:
            data["workerType"] = self.worker_type
        if self.python_version is not None:
            data["pythonVersion"] = self.python_version
        if self.worker_number is not None:
            data["workerNumber"] = self.worker_number
        if self.base_dockerfile is not None:
            data["baseDockerfile"] = self.base_dockerfile
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonProjectDeploymentResources":
        return cls(
            watermark_enabled=None
            if data.get("watermarkEnabled") is None
            else data["watermarkEnabled"],
            selenium_instance_enabled=None
            if data.get("seleniumInstanceEnabled") is None
            else data["seleniumInstanceEnabled"],
            notifications_enabled=None
            if data.get("notificationsEnabled") is None
            else data["notificationsEnabled"],
            requests_c_p_u=None
            if data.get("requestsCPU") is None
            else str(data["requestsCPU"]),
            limits_c_p_u=None
            if data.get("limitsCPU") is None
            else str(data["limitsCPU"]),
            requests_memory=None
            if data.get("requestsMemory") is None
            else str(data["requestsMemory"]),
            limits_memory=None
            if data.get("limitsMemory") is None
            else str(data["limitsMemory"]),
            min_replicas=None
            if data.get("minReplicas") is None
            else str(data["minReplicas"]),
            compute_units=None
            if data.get("computeUnits") is None
            else float(data["computeUnits"]),
            timeout_seconds=None
            if data.get("timeoutSeconds") is None
            else str(data["timeoutSeconds"]),
            worker_type=None if data.get("workerType") is None else data["workerType"],
            python_version=None
            if data.get("pythonVersion") is None
            else data["pythonVersion"],
            worker_number=None
            if data.get("workerNumber") is None
            else str(data["workerNumber"]),
            base_dockerfile=None
            if data.get("baseDockerfile") is None
            else str(data["baseDockerfile"]),
        )


@dataclass
class CommonProject:
    id: CommonProjectId
    folder_id: CommonProjectFolderId
    name: CommonProjectName
    subdomain: CommonProjectSubdomain
    organization_id: CommonProjectOrganizationId
    deployment_resources: typing.Optional[CommonProjectDeploymentResources] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["folderId"] = self.folder_id
        data["name"] = self.name
        data["subdomain"] = self.subdomain
        data["organizationId"] = self.organization_id
        if self.deployment_resources is not None:
            data["deploymentResources"] = self.deployment_resources.to_dict()
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonProject":
        return cls(
            id=str(data["id"]),
            folder_id=str(data["folderId"]),
            name=str(data["name"]),
            subdomain=str(data["subdomain"]),
            organization_id=str(data["organizationId"]),
            deployment_resources=None
            if data.get("deploymentResources") is None
            else CommonProjectDeploymentResources.from_dict(
                data["deploymentResources"]
            ),
        )


CommonSignupPolicyId = str

CommonSignupPolicyEmailPatternsItem = str

CommonSignupPolicyEmailPatterns = typing.List[CommonSignupPolicyEmailPatternsItem]

CommonSignupPolicyProjectId = str

CommonSignupPolicyCreatedAt = str


@dataclass
class CommonSignupPolicy:
    id: CommonSignupPolicyId
    email_patterns: CommonSignupPolicyEmailPatterns
    project_id: CommonSignupPolicyProjectId
    created_at: CommonSignupPolicyCreatedAt

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["emailPatterns"] = self.email_patterns
        data["projectId"] = self.project_id
        data["createdAt"] = self.created_at
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonSignupPolicy":
        return cls(
            id=str(data["id"]),
            email_patterns=[str(item) for item in data["emailPatterns"]],
            project_id=str(data["projectId"]),
            created_at=str(data["createdAt"]),
        )


CommonTablesPgTypes = typing.Union[
    typing.Literal["bigint"],
    typing.Literal["int8"],
    typing.Literal["bigserial"],
    typing.Literal["serial8"],
    typing.Literal["bit"],
    typing.Literal["bit varying"],
    typing.Literal["varbit"],
    typing.Literal["boolean"],
    typing.Literal["bool"],
    typing.Literal["box"],
    typing.Literal["bytea"],
    typing.Literal["character"],
    typing.Literal["char"],
    typing.Literal["character varying"],
    typing.Literal["varchar"],
    typing.Literal["cidr"],
    typing.Literal["circle"],
    typing.Literal["date"],
    typing.Literal["double precision"],
    typing.Literal["float8"],
    typing.Literal["inet"],
    typing.Literal["integer"],
    typing.Literal["int"],
    typing.Literal["int4"],
    typing.Literal["interval"],
    typing.Literal["json"],
    typing.Literal["jsonb"],
    typing.Literal["line"],
    typing.Literal["lseg"],
    typing.Literal["macaddr"],
    typing.Literal["money"],
    typing.Literal["numeric"],
    typing.Literal["decimal"],
    typing.Literal["path"],
    typing.Literal["pg_lsn"],
    typing.Literal["point"],
    typing.Literal["polygon"],
    typing.Literal["real"],
    typing.Literal["float4"],
    typing.Literal["smallint"],
    typing.Literal["int2"],
    typing.Literal["smallserial"],
    typing.Literal["serial2"],
    typing.Literal["serial"],
    typing.Literal["serial4"],
    typing.Literal["text"],
    typing.Literal["time"],
    typing.Literal["time with time zone"],
    typing.Literal["timetz"],
    typing.Literal["timestamp"],
    typing.Literal["timestamp with time zone"],
    typing.Literal["timestamptz"],
    typing.Literal["tsquery"],
    typing.Literal["tsvector"],
    typing.Literal["txid_snapshot"],
    typing.Literal["uuid"],
    typing.Literal["xml"],
]

CommonTablesPgTypesValues: typing.List[CommonTablesPgTypes] = [
    "bigint",
    "int8",
    "bigserial",
    "serial8",
    "bit",
    "bit varying",
    "varbit",
    "boolean",
    "bool",
    "box",
    "bytea",
    "character",
    "char",
    "character varying",
    "varchar",
    "cidr",
    "circle",
    "date",
    "double precision",
    "float8",
    "inet",
    "integer",
    "int",
    "int4",
    "interval",
    "json",
    "jsonb",
    "line",
    "lseg",
    "macaddr",
    "money",
    "numeric",
    "decimal",
    "path",
    "pg_lsn",
    "point",
    "polygon",
    "real",
    "float4",
    "smallint",
    "int2",
    "smallserial",
    "serial2",
    "serial",
    "serial4",
    "text",
    "time",
    "time with time zone",
    "timetz",
    "timestamp",
    "timestamp with time zone",
    "timestamptz",
    "tsquery",
    "tsvector",
    "txid_snapshot",
    "uuid",
    "xml",
]

CommonUserId = str

CommonUserEmail = str

CommonUserRolesItem = str

CommonUserRoles = typing.List[CommonUserRolesItem]

CommonUserProjectId = str

CommonUserCreatedAt = str


@dataclass
class CommonUser:
    id: CommonUserId
    email: CommonUserEmail
    roles: CommonUserRoles
    project_id: CommonUserProjectId
    created_at: CommonUserCreatedAt

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["email"] = self.email
        data["roles"] = self.roles
        data["projectId"] = self.project_id
        data["createdAt"] = self.created_at
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonUser":
        return cls(
            id=str(data["id"]),
            email=str(data["email"]),
            roles=[str(item) for item in data["roles"]],
            project_id=str(data["projectId"]),
            created_at=str(data["createdAt"]),
        )


CommonTablesSnapshotTablesItemId = str

CommonTablesSnapshotTablesItemName = str

CommonTablesSnapshotTablesItemColumnsItemId = str

CommonTablesSnapshotTablesItemColumnsItemPrimaryKey = bool

CommonTablesSnapshotTablesItemColumnsItemName = str

CommonTablesSnapshotTablesItemColumnsItemType = CommonTablesPgTypes

CommonTablesSnapshotTablesItemColumnsItemUnique = bool

CommonTablesSnapshotTablesItemColumnsItemNullable = bool

CommonTablesSnapshotTablesItemColumnsItemDefault = str

CommonTablesSnapshotTablesItemColumnsItemForeignKeyColumnId = str


@dataclass
class CommonTablesSnapshotTablesItemColumnsItemForeignKey:
    column_id: CommonTablesSnapshotTablesItemColumnsItemForeignKeyColumnId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["columnId"] = self.column_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonTablesSnapshotTablesItemColumnsItemForeignKey":
        return cls(
            column_id=str(data["columnId"]),
        )


@dataclass
class CommonTablesSnapshotTablesItemColumnsItem:
    id: CommonTablesSnapshotTablesItemColumnsItemId
    primary_key: CommonTablesSnapshotTablesItemColumnsItemPrimaryKey
    name: CommonTablesSnapshotTablesItemColumnsItemName
    type: CommonTablesSnapshotTablesItemColumnsItemType
    unique: typing.Optional[CommonTablesSnapshotTablesItemColumnsItemUnique] = field(
        default_factory=lambda: None
    )
    nullable: typing.Optional[CommonTablesSnapshotTablesItemColumnsItemNullable] = (
        field(default_factory=lambda: None)
    )
    default: typing.Optional[CommonTablesSnapshotTablesItemColumnsItemDefault] = field(
        default_factory=lambda: None
    )
    foreign_key: typing.Optional[
        CommonTablesSnapshotTablesItemColumnsItemForeignKey
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["primaryKey"] = self.primary_key
        data["name"] = self.name
        data["type"] = self.type
        if self.unique is not None:
            data["unique"] = self.unique
        if self.nullable is not None:
            data["nullable"] = self.nullable
        if self.default is not None:
            data["default"] = self.default
        if self.foreign_key is not None:
            data["foreignKey"] = self.foreign_key.to_dict()
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonTablesSnapshotTablesItemColumnsItem":
        return cls(
            id=str(data["id"]),
            primary_key=bool(data["primaryKey"]),
            name=str(data["name"]),
            type=data["type"],
            unique=None if data.get("unique") is None else bool(data["unique"]),
            nullable=None if data.get("nullable") is None else bool(data["nullable"]),
            default=None if data.get("default") is None else str(data["default"]),
            foreign_key=None
            if data.get("foreignKey") is None
            else CommonTablesSnapshotTablesItemColumnsItemForeignKey.from_dict(
                data["foreignKey"]
            ),
        )


CommonTablesSnapshotTablesItemColumns = typing.List[
    CommonTablesSnapshotTablesItemColumnsItem
]

CommonTablesSnapshotTablesItemDataItem = typing.Dict[str, typing.Any]

CommonTablesSnapshotTablesItemData = typing.List[CommonTablesSnapshotTablesItemDataItem]


@dataclass
class CommonTablesSnapshotTablesItem:
    id: CommonTablesSnapshotTablesItemId
    name: CommonTablesSnapshotTablesItemName
    columns: CommonTablesSnapshotTablesItemColumns
    data: CommonTablesSnapshotTablesItemData

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["name"] = self.name
        data["columns"] = [item.to_dict() for item in self.columns]
        data["data"] = [item for item in self.data]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonTablesSnapshotTablesItem":
        return cls(
            id=str(data["id"]),
            name=str(data["name"]),
            columns=[
                CommonTablesSnapshotTablesItemColumnsItem.from_dict(item)
                for item in data["columns"]
            ],
            data=[dict(**item) for item in data["data"]],
        )


CommonTablesSnapshotTables = typing.List[CommonTablesSnapshotTablesItem]


@dataclass
class CommonTablesSnapshot:
    tables: CommonTablesSnapshotTables

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["tables"] = [item.to_dict() for item in self.tables]
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonTablesSnapshot":
        return cls(
            tables=[
                CommonTablesSnapshotTablesItem.from_dict(item)
                for item in data["tables"]
            ],
        )


CommonOrganizationId = str

CommonOrganizationName = str

CommonOrganizationFeatureFlagsPROJECTLIVE = bool

CommonOrganizationFeatureFlagsALLOWRELEASE = bool

CommonOrganizationFeatureFlagsCONNECTORSCONSOLE = bool

CommonOrganizationFeatureFlagsDUPLICATEPROJECTS = bool

CommonOrganizationFeatureFlagsWEBEDITOR = bool

CommonOrganizationFeatureFlagsLANGCHAINSMARTCHAT = bool


@dataclass
class CommonOrganizationFeatureFlags:
    p_r_o_j_e_c_t__l_i_v_e: CommonOrganizationFeatureFlagsPROJECTLIVE
    a_l_l_o_w__r_e_l_e_a_s_e: CommonOrganizationFeatureFlagsALLOWRELEASE
    c_o_n_n_e_c_t_o_r_s__c_o_n_s_o_l_e: CommonOrganizationFeatureFlagsCONNECTORSCONSOLE
    d_u_p_l_i_c_a_t_e__p_r_o_j_e_c_t_s: CommonOrganizationFeatureFlagsDUPLICATEPROJECTS
    w_e_b__e_d_i_t_o_r: typing.Optional[CommonOrganizationFeatureFlagsWEBEDITOR] = (
        field(default_factory=lambda: None)
    )
    l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t: typing.Optional[
        CommonOrganizationFeatureFlagsLANGCHAINSMARTCHAT
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["PROJECT_LIVE"] = self.p_r_o_j_e_c_t__l_i_v_e
        data["ALLOW_RELEASE"] = self.a_l_l_o_w__r_e_l_e_a_s_e
        data["CONNECTORS_CONSOLE"] = self.c_o_n_n_e_c_t_o_r_s__c_o_n_s_o_l_e
        data["DUPLICATE_PROJECTS"] = self.d_u_p_l_i_c_a_t_e__p_r_o_j_e_c_t_s
        if self.w_e_b__e_d_i_t_o_r is not None:
            data["WEB_EDITOR"] = self.w_e_b__e_d_i_t_o_r
        if self.l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t is not None:
            data["LANGCHAIN_SMART_CHAT"] = self.l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonOrganizationFeatureFlags":
        return cls(
            p_r_o_j_e_c_t__l_i_v_e=bool(data["PROJECT_LIVE"]),
            a_l_l_o_w__r_e_l_e_a_s_e=bool(data["ALLOW_RELEASE"]),
            c_o_n_n_e_c_t_o_r_s__c_o_n_s_o_l_e=bool(data["CONNECTORS_CONSOLE"]),
            d_u_p_l_i_c_a_t_e__p_r_o_j_e_c_t_s=bool(data["DUPLICATE_PROJECTS"]),
            w_e_b__e_d_i_t_o_r=None
            if data.get("WEB_EDITOR") is None
            else bool(data["WEB_EDITOR"]),
            l_a_n_g_c_h_a_i_n__s_m_a_r_t__c_h_a_t=None
            if data.get("LANGCHAIN_SMART_CHAT") is None
            else bool(data["LANGCHAIN_SMART_CHAT"]),
        )


CommonOrganizationBillingMetadataPlan = str

CommonOrganizationBillingMetadataExpires = str

CommonOrganizationBillingMetadataMessage = str

CommonOrganizationBillingMetadataMessageLink = str

CommonOrganizationBillingMetadataMessageCTA = str


@dataclass
class CommonOrganizationBillingMetadata:
    plan: typing.Optional[CommonOrganizationBillingMetadataPlan] = field(
        default_factory=lambda: None
    )
    expires: typing.Optional[CommonOrganizationBillingMetadataExpires] = field(
        default_factory=lambda: None
    )
    message: typing.Optional[CommonOrganizationBillingMetadataMessage] = field(
        default_factory=lambda: None
    )
    message_link: typing.Optional[CommonOrganizationBillingMetadataMessageLink] = field(
        default_factory=lambda: None
    )
    message_c_t_a: typing.Optional[CommonOrganizationBillingMetadataMessageCTA] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.plan is not None:
            data["plan"] = self.plan
        if self.expires is not None:
            data["expires"] = self.expires
        if self.message is not None:
            data["message"] = self.message
        if self.message_link is not None:
            data["messageLink"] = self.message_link
        if self.message_c_t_a is not None:
            data["messageCTA"] = self.message_c_t_a
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonOrganizationBillingMetadata":
        return cls(
            plan=None if data.get("plan") is None else str(data["plan"]),
            expires=None if data.get("expires") is None else str(data["expires"]),
            message=None if data.get("message") is None else str(data["message"]),
            message_link=None
            if data.get("messageLink") is None
            else str(data["messageLink"]),
            message_c_t_a=None
            if data.get("messageCTA") is None
            else str(data["messageCTA"]),
        )


CommonOrganizationDeploymentResourcesWatermarkEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonOrganizationDeploymentResourcesWatermarkEnabledValues: typing.List[
    CommonOrganizationDeploymentResourcesWatermarkEnabled
] = ["true", "false"]

CommonOrganizationDeploymentResourcesNativeTempDir = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonOrganizationDeploymentResourcesNativeTempDirValues: typing.List[
    CommonOrganizationDeploymentResourcesNativeTempDir
] = ["true", "false"]

CommonOrganizationDeploymentResourcesNotificationsEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonOrganizationDeploymentResourcesNotificationsEnabledValues: typing.List[
    CommonOrganizationDeploymentResourcesNotificationsEnabled
] = ["true", "false"]

CommonOrganizationDeploymentResourcesRequestsCPU = str

CommonOrganizationDeploymentResourcesLimitsCPU = str

CommonOrganizationDeploymentResourcesRequestsMemory = str

CommonOrganizationDeploymentResourcesLimitsMemory = str

CommonOrganizationDeploymentResourcesMinReplicas = str

CommonOrganizationDeploymentResourcesComputeUnits = float

CommonOrganizationDeploymentResourcesTimeoutSeconds = str

CommonOrganizationDeploymentResourcesWorkerType = typing.Union[
    typing.Literal["jusbrasil"],
    typing.Literal["clickbus"],
    typing.Literal["touchsuite"],
    typing.Literal["foursquare"],
    typing.Literal["estoca"],
    typing.Literal["estoca-test"],
    typing.Literal["irko"],
    typing.Literal["dr9"],
    typing.Literal["onfly"],
    typing.Literal["shared"],
    typing.Literal["test"],
]

CommonOrganizationDeploymentResourcesWorkerTypeValues: typing.List[
    CommonOrganizationDeploymentResourcesWorkerType
] = [
    "jusbrasil",
    "clickbus",
    "touchsuite",
    "foursquare",
    "estoca",
    "estoca-test",
    "irko",
    "dr9",
    "onfly",
    "shared",
    "test",
]

CommonOrganizationDeploymentResourcesPythonVersion = typing.Union[
    typing.Literal["3.9"],
    typing.Literal["3.10"],
    typing.Literal["3.11"],
    typing.Literal["3.12"],
]

CommonOrganizationDeploymentResourcesPythonVersionValues: typing.List[
    CommonOrganizationDeploymentResourcesPythonVersion
] = ["3.9", "3.10", "3.11", "3.12"]

CommonOrganizationDeploymentResourcesWorkerNumber = str

CommonOrganizationDeploymentResourcesBaseDockerfile = str


@dataclass
class CommonOrganizationDeploymentResources:
    watermark_enabled: typing.Optional[
        CommonOrganizationDeploymentResourcesWatermarkEnabled
    ] = field(default_factory=lambda: None)
    native_temp_dir: typing.Optional[
        CommonOrganizationDeploymentResourcesNativeTempDir
    ] = field(default_factory=lambda: None)
    notifications_enabled: typing.Optional[
        CommonOrganizationDeploymentResourcesNotificationsEnabled
    ] = field(default_factory=lambda: None)
    requests_c_p_u: typing.Optional[
        CommonOrganizationDeploymentResourcesRequestsCPU
    ] = field(default_factory=lambda: None)
    limits_c_p_u: typing.Optional[CommonOrganizationDeploymentResourcesLimitsCPU] = (
        field(default_factory=lambda: None)
    )
    requests_memory: typing.Optional[
        CommonOrganizationDeploymentResourcesRequestsMemory
    ] = field(default_factory=lambda: None)
    limits_memory: typing.Optional[
        CommonOrganizationDeploymentResourcesLimitsMemory
    ] = field(default_factory=lambda: None)
    min_replicas: typing.Optional[CommonOrganizationDeploymentResourcesMinReplicas] = (
        field(default_factory=lambda: None)
    )
    compute_units: typing.Optional[
        CommonOrganizationDeploymentResourcesComputeUnits
    ] = field(default_factory=lambda: None)
    timeout_seconds: typing.Optional[
        CommonOrganizationDeploymentResourcesTimeoutSeconds
    ] = field(default_factory=lambda: None)
    worker_type: typing.Optional[CommonOrganizationDeploymentResourcesWorkerType] = (
        field(default_factory=lambda: None)
    )
    python_version: typing.Optional[
        CommonOrganizationDeploymentResourcesPythonVersion
    ] = field(default_factory=lambda: None)
    worker_number: typing.Optional[
        CommonOrganizationDeploymentResourcesWorkerNumber
    ] = field(default_factory=lambda: None)
    base_dockerfile: typing.Optional[
        CommonOrganizationDeploymentResourcesBaseDockerfile
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.watermark_enabled is not None:
            data["watermarkEnabled"] = self.watermark_enabled
        if self.native_temp_dir is not None:
            data["nativeTempDir"] = self.native_temp_dir
        if self.notifications_enabled is not None:
            data["notificationsEnabled"] = self.notifications_enabled
        if self.requests_c_p_u is not None:
            data["requestsCPU"] = self.requests_c_p_u
        if self.limits_c_p_u is not None:
            data["limitsCPU"] = self.limits_c_p_u
        if self.requests_memory is not None:
            data["requestsMemory"] = self.requests_memory
        if self.limits_memory is not None:
            data["limitsMemory"] = self.limits_memory
        if self.min_replicas is not None:
            data["minReplicas"] = self.min_replicas
        if self.compute_units is not None:
            data["computeUnits"] = self.compute_units
        if self.timeout_seconds is not None:
            data["timeoutSeconds"] = self.timeout_seconds
        if self.worker_type is not None:
            data["workerType"] = self.worker_type
        if self.python_version is not None:
            data["pythonVersion"] = self.python_version
        if self.worker_number is not None:
            data["workerNumber"] = self.worker_number
        if self.base_dockerfile is not None:
            data["baseDockerfile"] = self.base_dockerfile
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonOrganizationDeploymentResources":
        return cls(
            watermark_enabled=None
            if data.get("watermarkEnabled") is None
            else data["watermarkEnabled"],
            native_temp_dir=None
            if data.get("nativeTempDir") is None
            else data["nativeTempDir"],
            notifications_enabled=None
            if data.get("notificationsEnabled") is None
            else data["notificationsEnabled"],
            requests_c_p_u=None
            if data.get("requestsCPU") is None
            else str(data["requestsCPU"]),
            limits_c_p_u=None
            if data.get("limitsCPU") is None
            else str(data["limitsCPU"]),
            requests_memory=None
            if data.get("requestsMemory") is None
            else str(data["requestsMemory"]),
            limits_memory=None
            if data.get("limitsMemory") is None
            else str(data["limitsMemory"]),
            min_replicas=None
            if data.get("minReplicas") is None
            else str(data["minReplicas"]),
            compute_units=None
            if data.get("computeUnits") is None
            else float(data["computeUnits"]),
            timeout_seconds=None
            if data.get("timeoutSeconds") is None
            else str(data["timeoutSeconds"]),
            worker_type=None if data.get("workerType") is None else data["workerType"],
            python_version=None
            if data.get("pythonVersion") is None
            else data["pythonVersion"],
            worker_number=None
            if data.get("workerNumber") is None
            else str(data["workerNumber"]),
            base_dockerfile=None
            if data.get("baseDockerfile") is None
            else str(data["baseDockerfile"]),
        )


CommonOrganizationMembershipsMetadataWhitelistPatternsItem = str

CommonOrganizationMembershipsMetadataWhitelistPatterns = typing.List[
    CommonOrganizationMembershipsMetadataWhitelistPatternsItem
]


@dataclass
class CommonOrganizationMembershipsMetadata:
    whitelist_patterns: typing.Optional[
        CommonOrganizationMembershipsMetadataWhitelistPatterns
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.whitelist_patterns is not None:
            data["whitelistPatterns"] = self.whitelist_patterns
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonOrganizationMembershipsMetadata":
        return cls(
            whitelist_patterns=None
            if data.get("whitelistPatterns") is None
            else [str(item) for item in data["whitelistPatterns"]],
        )


@dataclass
class CommonOrganization:
    id: CommonOrganizationId
    name: CommonOrganizationName
    feature_flags: CommonOrganizationFeatureFlags
    billing_metadata: CommonOrganizationBillingMetadata
    deployment_resources: typing.Optional[CommonOrganizationDeploymentResources] = (
        field(default_factory=lambda: None)
    )
    memberships_metadata: typing.Optional[CommonOrganizationMembershipsMetadata] = (
        field(default_factory=lambda: None)
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["name"] = self.name
        data["featureFlags"] = self.feature_flags.to_dict()
        data["billingMetadata"] = self.billing_metadata.to_dict()
        if self.deployment_resources is not None:
            data["deploymentResources"] = self.deployment_resources.to_dict()
        if self.memberships_metadata is not None:
            data["membershipsMetadata"] = self.memberships_metadata.to_dict()
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonOrganization":
        return cls(
            id=str(data["id"]),
            name=str(data["name"]),
            feature_flags=CommonOrganizationFeatureFlags.from_dict(
                data["featureFlags"]
            ),
            billing_metadata=CommonOrganizationBillingMetadata.from_dict(
                data["billingMetadata"]
            ),
            deployment_resources=None
            if data.get("deploymentResources") is None
            else CommonOrganizationDeploymentResources.from_dict(
                data["deploymentResources"]
            ),
            memberships_metadata=None
            if data.get("membershipsMetadata") is None
            else CommonOrganizationMembershipsMetadata.from_dict(
                data["membershipsMetadata"]
            ),
        )


CommonPartialMembershipsMetadataWhitelistPatternsItem = str

CommonPartialMembershipsMetadataWhitelistPatterns = typing.List[
    CommonPartialMembershipsMetadataWhitelistPatternsItem
]


@dataclass
class CommonPartialMembershipsMetadata:
    whitelist_patterns: typing.Optional[
        CommonPartialMembershipsMetadataWhitelistPatterns
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.whitelist_patterns is not None:
            data["whitelistPatterns"] = self.whitelist_patterns
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonPartialMembershipsMetadata":
        return cls(
            whitelist_patterns=None
            if data.get("whitelistPatterns") is None
            else [str(item) for item in data["whitelistPatterns"]],
        )


CommonAbstraJsonV15WorkspaceName = str

CommonAbstraJsonV15WorkspaceLanguage = str

CommonAbstraJsonV15WorkspaceThemeString = str

CommonAbstraJsonV15WorkspaceThemeNull = type(None)

CommonAbstraJsonV15WorkspaceTheme = typing.Union[
    CommonAbstraJsonV15WorkspaceThemeString, CommonAbstraJsonV15WorkspaceThemeNull
]

CommonAbstraJsonV15WorkspaceLogoUrlString = str

CommonAbstraJsonV15WorkspaceLogoUrlNull = type(None)

CommonAbstraJsonV15WorkspaceLogoUrl = typing.Union[
    CommonAbstraJsonV15WorkspaceLogoUrlString, CommonAbstraJsonV15WorkspaceLogoUrlNull
]

CommonAbstraJsonV15WorkspaceFaviconUrlString = str

CommonAbstraJsonV15WorkspaceFaviconUrlNull = type(None)

CommonAbstraJsonV15WorkspaceFaviconUrl = typing.Union[
    CommonAbstraJsonV15WorkspaceFaviconUrlString,
    CommonAbstraJsonV15WorkspaceFaviconUrlNull,
]

CommonAbstraJsonV15WorkspaceBrandNameString = str

CommonAbstraJsonV15WorkspaceBrandNameNull = type(None)

CommonAbstraJsonV15WorkspaceBrandName = typing.Union[
    CommonAbstraJsonV15WorkspaceBrandNameString,
    CommonAbstraJsonV15WorkspaceBrandNameNull,
]

CommonAbstraJsonV15WorkspaceMainColorString = str

CommonAbstraJsonV15WorkspaceMainColorNull = type(None)

CommonAbstraJsonV15WorkspaceMainColor = typing.Union[
    CommonAbstraJsonV15WorkspaceMainColorString,
    CommonAbstraJsonV15WorkspaceMainColorNull,
]

CommonAbstraJsonV15WorkspaceFontFamilyString = str

CommonAbstraJsonV15WorkspaceFontFamilyNull = type(None)

CommonAbstraJsonV15WorkspaceFontFamily = typing.Union[
    CommonAbstraJsonV15WorkspaceFontFamilyString,
    CommonAbstraJsonV15WorkspaceFontFamilyNull,
]

CommonAbstraJsonV15WorkspaceFontColorString = str

CommonAbstraJsonV15WorkspaceFontColorNull = type(None)

CommonAbstraJsonV15WorkspaceFontColor = typing.Union[
    CommonAbstraJsonV15WorkspaceFontColorString,
    CommonAbstraJsonV15WorkspaceFontColorNull,
]


@dataclass
class CommonAbstraJsonV15Workspace:
    name: CommonAbstraJsonV15WorkspaceName
    language: CommonAbstraJsonV15WorkspaceLanguage
    theme: CommonAbstraJsonV15WorkspaceTheme
    logo_url: CommonAbstraJsonV15WorkspaceLogoUrl
    favicon_url: CommonAbstraJsonV15WorkspaceFaviconUrl
    brand_name: CommonAbstraJsonV15WorkspaceBrandName
    main_color: CommonAbstraJsonV15WorkspaceMainColor
    font_family: CommonAbstraJsonV15WorkspaceFontFamily
    font_color: CommonAbstraJsonV15WorkspaceFontColor

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["language"] = self.language
        data["theme"] = self.theme if isinstance(self.theme, str) else self.theme
        data["logo_url"] = (
            self.logo_url if isinstance(self.logo_url, str) else self.logo_url
        )
        data["favicon_url"] = (
            self.favicon_url if isinstance(self.favicon_url, str) else self.favicon_url
        )
        data["brand_name"] = (
            self.brand_name if isinstance(self.brand_name, str) else self.brand_name
        )
        data["main_color"] = (
            self.main_color if isinstance(self.main_color, str) else self.main_color
        )
        data["font_family"] = (
            self.font_family if isinstance(self.font_family, str) else self.font_family
        )
        data["font_color"] = (
            self.font_color if isinstance(self.font_color, str) else self.font_color
        )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15Workspace":
        return cls(
            name=str(data["name"]),
            language=str(data["language"]),
            theme=(str(data["theme"]) if isinstance(data["theme"], str) else None),
            logo_url=(
                str(data["logo_url"]) if isinstance(data["logo_url"], str) else None
            ),
            favicon_url=(
                str(data["favicon_url"])
                if isinstance(data["favicon_url"], str)
                else None
            ),
            brand_name=(
                str(data["brand_name"]) if isinstance(data["brand_name"], str) else None
            ),
            main_color=(
                str(data["main_color"]) if isinstance(data["main_color"], str) else None
            ),
            font_family=(
                str(data["font_family"])
                if isinstance(data["font_family"], str)
                else None
            ),
            font_color=(
                str(data["font_color"]) if isinstance(data["font_color"], str) else None
            ),
        )


CommonAbstraJsonV15HomeAccessControlIsPublic = bool

CommonAbstraJsonV15HomeAccessControlRequiredRolesItem = str

CommonAbstraJsonV15HomeAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV15HomeAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV15HomeAccessControl:
    is_public: CommonAbstraJsonV15HomeAccessControlIsPublic
    required_roles: CommonAbstraJsonV15HomeAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15HomeAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


@dataclass
class CommonAbstraJsonV15Home:
    access_control: CommonAbstraJsonV15HomeAccessControl

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["access_control"] = self.access_control.to_dict()
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV15Home":
        return cls(
            access_control=CommonAbstraJsonV15HomeAccessControl.from_dict(
                data["access_control"]
            ),
        )


CommonAbstraJsonV15DefinitionsTransitionId = str

CommonAbstraJsonV15DefinitionsTransitionTargetId = str

CommonAbstraJsonV15DefinitionsTransitionTargetType = str

CommonAbstraJsonV15DefinitionsTransitionType = str

CommonAbstraJsonV15DefinitionsTransitionTaskTypeString = str

CommonAbstraJsonV15DefinitionsTransitionTaskTypeNull = type(None)

CommonAbstraJsonV15DefinitionsTransitionTaskType = typing.Union[
    CommonAbstraJsonV15DefinitionsTransitionTaskTypeString,
    CommonAbstraJsonV15DefinitionsTransitionTaskTypeNull,
]


@dataclass
class CommonAbstraJsonV15DefinitionsTransition:
    id: CommonAbstraJsonV15DefinitionsTransitionId
    target_id: CommonAbstraJsonV15DefinitionsTransitionTargetId
    target_type: CommonAbstraJsonV15DefinitionsTransitionTargetType
    type: CommonAbstraJsonV15DefinitionsTransitionType
    task_type: typing.Optional[CommonAbstraJsonV15DefinitionsTransitionTaskType] = (
        field(default_factory=lambda: None)
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["target_id"] = self.target_id
        data["target_type"] = self.target_type
        data["type"] = self.type
        if self.task_type is not None:
            data["task_type"] = (
                self.task_type if isinstance(self.task_type, str) else self.task_type
            )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15DefinitionsTransition":
        return cls(
            id=str(data["id"]),
            target_id=str(data["target_id"]),
            target_type=str(data["target_type"]),
            type=str(data["type"]),
            task_type=None
            if data.get("task_type") is None
            else (
                str(data["task_type"]) if isinstance(data["task_type"], str) else None
            ),
        )


CommonAbstraJsonV15DefinitionsJobStageTransitionsItem = (
    CommonAbstraJsonV15DefinitionsTransition
)

CommonAbstraJsonV15DefinitionsJobStageTransitions = typing.List[
    CommonAbstraJsonV15DefinitionsJobStageTransitionsItem
]

CommonAbstraJsonV15DefinitionsJobStageId = str

CommonAbstraJsonV15DefinitionsJobStageTitle = str

CommonAbstraJsonV15DefinitionsJobStageFile = str

CommonAbstraJsonV15DefinitionsJobStageWorkflowPositionItem = float

CommonAbstraJsonV15DefinitionsJobStageWorkflowPosition = typing.List[
    CommonAbstraJsonV15DefinitionsJobStageWorkflowPositionItem
]

CommonAbstraJsonV15DefinitionsJobStageSchedule = str


@dataclass
class CommonAbstraJsonV15DefinitionsJobStage:
    transitions: CommonAbstraJsonV15DefinitionsJobStageTransitions
    id: CommonAbstraJsonV15DefinitionsJobStageId
    title: CommonAbstraJsonV15DefinitionsJobStageTitle
    file: CommonAbstraJsonV15DefinitionsJobStageFile
    workflow_position: CommonAbstraJsonV15DefinitionsJobStageWorkflowPosition
    schedule: CommonAbstraJsonV15DefinitionsJobStageSchedule

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["schedule"] = self.schedule
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15DefinitionsJobStage":
        return cls(
            transitions=[
                CommonAbstraJsonV15DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            schedule=str(data["schedule"]),
        )


CommonAbstraJsonV15JobsItem = CommonAbstraJsonV15DefinitionsJobStage

CommonAbstraJsonV15Jobs = typing.List[CommonAbstraJsonV15JobsItem]

CommonAbstraJsonV15DefinitionsHookStageTransitionsItem = (
    CommonAbstraJsonV15DefinitionsTransition
)

CommonAbstraJsonV15DefinitionsHookStageTransitions = typing.List[
    CommonAbstraJsonV15DefinitionsHookStageTransitionsItem
]

CommonAbstraJsonV15DefinitionsHookStageId = str

CommonAbstraJsonV15DefinitionsHookStageTitle = str

CommonAbstraJsonV15DefinitionsHookStageFile = str

CommonAbstraJsonV15DefinitionsHookStageWorkflowPositionItem = float

CommonAbstraJsonV15DefinitionsHookStageWorkflowPosition = typing.List[
    CommonAbstraJsonV15DefinitionsHookStageWorkflowPositionItem
]

CommonAbstraJsonV15DefinitionsHookStageEnabled = bool

CommonAbstraJsonV15DefinitionsHookStagePath = str

CommonAbstraJsonV15DefinitionsHookStageIsInitial = bool


@dataclass
class CommonAbstraJsonV15DefinitionsHookStage:
    transitions: CommonAbstraJsonV15DefinitionsHookStageTransitions
    id: CommonAbstraJsonV15DefinitionsHookStageId
    title: CommonAbstraJsonV15DefinitionsHookStageTitle
    file: CommonAbstraJsonV15DefinitionsHookStageFile
    workflow_position: CommonAbstraJsonV15DefinitionsHookStageWorkflowPosition
    enabled: CommonAbstraJsonV15DefinitionsHookStageEnabled
    path: CommonAbstraJsonV15DefinitionsHookStagePath
    is_initial: CommonAbstraJsonV15DefinitionsHookStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["enabled"] = self.enabled
        data["path"] = self.path
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15DefinitionsHookStage":
        return cls(
            transitions=[
                CommonAbstraJsonV15DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            enabled=bool(data["enabled"]),
            path=str(data["path"]),
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV15HooksItem = CommonAbstraJsonV15DefinitionsHookStage

CommonAbstraJsonV15Hooks = typing.List[CommonAbstraJsonV15HooksItem]

CommonAbstraJsonV15DefinitionsFormStageTransitionsItem = (
    CommonAbstraJsonV15DefinitionsTransition
)

CommonAbstraJsonV15DefinitionsFormStageTransitions = typing.List[
    CommonAbstraJsonV15DefinitionsFormStageTransitionsItem
]

CommonAbstraJsonV15DefinitionsFormStageId = str

CommonAbstraJsonV15DefinitionsFormStageTitle = str

CommonAbstraJsonV15DefinitionsFormStageFile = str

CommonAbstraJsonV15DefinitionsFormStageWorkflowPositionItem = float

CommonAbstraJsonV15DefinitionsFormStageWorkflowPosition = typing.List[
    CommonAbstraJsonV15DefinitionsFormStageWorkflowPositionItem
]

CommonAbstraJsonV15DefinitionsFormStageStartMessageString = str

CommonAbstraJsonV15DefinitionsFormStageStartMessageNull = type(None)

CommonAbstraJsonV15DefinitionsFormStageStartMessage = typing.Union[
    CommonAbstraJsonV15DefinitionsFormStageStartMessageString,
    CommonAbstraJsonV15DefinitionsFormStageStartMessageNull,
]

CommonAbstraJsonV15DefinitionsFormStageAccessControlIsPublic = bool

CommonAbstraJsonV15DefinitionsFormStageAccessControlRequiredRolesItem = str

CommonAbstraJsonV15DefinitionsFormStageAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV15DefinitionsFormStageAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV15DefinitionsFormStageAccessControl:
    is_public: CommonAbstraJsonV15DefinitionsFormStageAccessControlIsPublic
    required_roles: CommonAbstraJsonV15DefinitionsFormStageAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15DefinitionsFormStageAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


CommonAbstraJsonV15DefinitionsFormStagePath = str

CommonAbstraJsonV15DefinitionsFormStageTimeoutMessageString = str

CommonAbstraJsonV15DefinitionsFormStageTimeoutMessageNull = type(None)

CommonAbstraJsonV15DefinitionsFormStageTimeoutMessage = typing.Union[
    CommonAbstraJsonV15DefinitionsFormStageTimeoutMessageString,
    CommonAbstraJsonV15DefinitionsFormStageTimeoutMessageNull,
]

CommonAbstraJsonV15DefinitionsFormStageStartButtonTextString = str

CommonAbstraJsonV15DefinitionsFormStageStartButtonTextNull = type(None)

CommonAbstraJsonV15DefinitionsFormStageStartButtonText = typing.Union[
    CommonAbstraJsonV15DefinitionsFormStageStartButtonTextString,
    CommonAbstraJsonV15DefinitionsFormStageStartButtonTextNull,
]

CommonAbstraJsonV15DefinitionsFormStageWelcomeTitleString = str

CommonAbstraJsonV15DefinitionsFormStageWelcomeTitleNull = type(None)

CommonAbstraJsonV15DefinitionsFormStageWelcomeTitle = typing.Union[
    CommonAbstraJsonV15DefinitionsFormStageWelcomeTitleString,
    CommonAbstraJsonV15DefinitionsFormStageWelcomeTitleNull,
]

CommonAbstraJsonV15DefinitionsFormStageRestartButtonTextString = str

CommonAbstraJsonV15DefinitionsFormStageRestartButtonTextNull = type(None)

CommonAbstraJsonV15DefinitionsFormStageRestartButtonText = typing.Union[
    CommonAbstraJsonV15DefinitionsFormStageRestartButtonTextString,
    CommonAbstraJsonV15DefinitionsFormStageRestartButtonTextNull,
]

CommonAbstraJsonV15DefinitionsFormStageNotificationTriggerVariableName = str

CommonAbstraJsonV15DefinitionsFormStageNotificationTriggerEnabled = bool


@dataclass
class CommonAbstraJsonV15DefinitionsFormStageNotificationTrigger:
    variable_name: (
        CommonAbstraJsonV15DefinitionsFormStageNotificationTriggerVariableName
    )
    enabled: CommonAbstraJsonV15DefinitionsFormStageNotificationTriggerEnabled

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["variable_name"] = self.variable_name
        data["enabled"] = self.enabled
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15DefinitionsFormStageNotificationTrigger":
        return cls(
            variable_name=str(data["variable_name"]),
            enabled=bool(data["enabled"]),
        )


CommonAbstraJsonV15DefinitionsFormStageEndMessageString = str

CommonAbstraJsonV15DefinitionsFormStageEndMessageNull = type(None)

CommonAbstraJsonV15DefinitionsFormStageEndMessage = typing.Union[
    CommonAbstraJsonV15DefinitionsFormStageEndMessageString,
    CommonAbstraJsonV15DefinitionsFormStageEndMessageNull,
]

CommonAbstraJsonV15DefinitionsFormStageAutoStart = bool

CommonAbstraJsonV15DefinitionsFormStageIsInitial = bool

CommonAbstraJsonV15DefinitionsFormStageErrorMessageString = str

CommonAbstraJsonV15DefinitionsFormStageErrorMessageNull = type(None)

CommonAbstraJsonV15DefinitionsFormStageErrorMessage = typing.Union[
    CommonAbstraJsonV15DefinitionsFormStageErrorMessageString,
    CommonAbstraJsonV15DefinitionsFormStageErrorMessageNull,
]

CommonAbstraJsonV15DefinitionsFormStageAllowRestart = bool


@dataclass
class CommonAbstraJsonV15DefinitionsFormStage:
    transitions: CommonAbstraJsonV15DefinitionsFormStageTransitions
    id: CommonAbstraJsonV15DefinitionsFormStageId
    title: CommonAbstraJsonV15DefinitionsFormStageTitle
    file: CommonAbstraJsonV15DefinitionsFormStageFile
    workflow_position: CommonAbstraJsonV15DefinitionsFormStageWorkflowPosition
    start_message: CommonAbstraJsonV15DefinitionsFormStageStartMessage
    access_control: CommonAbstraJsonV15DefinitionsFormStageAccessControl
    path: CommonAbstraJsonV15DefinitionsFormStagePath
    timeout_message: CommonAbstraJsonV15DefinitionsFormStageTimeoutMessage
    start_button_text: CommonAbstraJsonV15DefinitionsFormStageStartButtonText
    welcome_title: CommonAbstraJsonV15DefinitionsFormStageWelcomeTitle
    restart_button_text: CommonAbstraJsonV15DefinitionsFormStageRestartButtonText
    notification_trigger: CommonAbstraJsonV15DefinitionsFormStageNotificationTrigger
    end_message: CommonAbstraJsonV15DefinitionsFormStageEndMessage
    auto_start: CommonAbstraJsonV15DefinitionsFormStageAutoStart
    is_initial: CommonAbstraJsonV15DefinitionsFormStageIsInitial
    error_message: CommonAbstraJsonV15DefinitionsFormStageErrorMessage
    allow_restart: CommonAbstraJsonV15DefinitionsFormStageAllowRestart

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["start_message"] = (
            self.start_message
            if isinstance(self.start_message, str)
            else self.start_message
        )
        data["access_control"] = self.access_control.to_dict()
        data["path"] = self.path
        data["timeout_message"] = (
            self.timeout_message
            if isinstance(self.timeout_message, str)
            else self.timeout_message
        )
        data["start_button_text"] = (
            self.start_button_text
            if isinstance(self.start_button_text, str)
            else self.start_button_text
        )
        data["welcome_title"] = (
            self.welcome_title
            if isinstance(self.welcome_title, str)
            else self.welcome_title
        )
        data["restart_button_text"] = (
            self.restart_button_text
            if isinstance(self.restart_button_text, str)
            else self.restart_button_text
        )
        data["notification_trigger"] = self.notification_trigger.to_dict()
        data["end_message"] = (
            self.end_message if isinstance(self.end_message, str) else self.end_message
        )
        data["auto_start"] = self.auto_start
        data["is_initial"] = self.is_initial
        data["error_message"] = (
            self.error_message
            if isinstance(self.error_message, str)
            else self.error_message
        )
        data["allow_restart"] = self.allow_restart
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15DefinitionsFormStage":
        return cls(
            transitions=[
                CommonAbstraJsonV15DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            start_message=(
                str(data["start_message"])
                if isinstance(data["start_message"], str)
                else None
            ),
            access_control=CommonAbstraJsonV15DefinitionsFormStageAccessControl.from_dict(
                data["access_control"]
            ),
            path=str(data["path"]),
            timeout_message=(
                str(data["timeout_message"])
                if isinstance(data["timeout_message"], str)
                else None
            ),
            start_button_text=(
                str(data["start_button_text"])
                if isinstance(data["start_button_text"], str)
                else None
            ),
            welcome_title=(
                str(data["welcome_title"])
                if isinstance(data["welcome_title"], str)
                else None
            ),
            restart_button_text=(
                str(data["restart_button_text"])
                if isinstance(data["restart_button_text"], str)
                else None
            ),
            notification_trigger=CommonAbstraJsonV15DefinitionsFormStageNotificationTrigger.from_dict(
                data["notification_trigger"]
            ),
            end_message=(
                str(data["end_message"])
                if isinstance(data["end_message"], str)
                else None
            ),
            auto_start=bool(data["auto_start"]),
            is_initial=bool(data["is_initial"]),
            error_message=(
                str(data["error_message"])
                if isinstance(data["error_message"], str)
                else None
            ),
            allow_restart=bool(data["allow_restart"]),
        )


CommonAbstraJsonV15FormsItem = CommonAbstraJsonV15DefinitionsFormStage

CommonAbstraJsonV15Forms = typing.List[CommonAbstraJsonV15FormsItem]

CommonAbstraJsonV15DefinitionsScriptStageTransitionsItem = (
    CommonAbstraJsonV15DefinitionsTransition
)

CommonAbstraJsonV15DefinitionsScriptStageTransitions = typing.List[
    CommonAbstraJsonV15DefinitionsScriptStageTransitionsItem
]

CommonAbstraJsonV15DefinitionsScriptStageId = str

CommonAbstraJsonV15DefinitionsScriptStageTitle = str

CommonAbstraJsonV15DefinitionsScriptStageFile = str

CommonAbstraJsonV15DefinitionsScriptStageWorkflowPositionItem = float

CommonAbstraJsonV15DefinitionsScriptStageWorkflowPosition = typing.List[
    CommonAbstraJsonV15DefinitionsScriptStageWorkflowPositionItem
]

CommonAbstraJsonV15DefinitionsScriptStageIsInitial = bool


@dataclass
class CommonAbstraJsonV15DefinitionsScriptStage:
    transitions: CommonAbstraJsonV15DefinitionsScriptStageTransitions
    id: CommonAbstraJsonV15DefinitionsScriptStageId
    title: CommonAbstraJsonV15DefinitionsScriptStageTitle
    file: CommonAbstraJsonV15DefinitionsScriptStageFile
    workflow_position: CommonAbstraJsonV15DefinitionsScriptStageWorkflowPosition
    is_initial: CommonAbstraJsonV15DefinitionsScriptStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV15DefinitionsScriptStage":
        return cls(
            transitions=[
                CommonAbstraJsonV15DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV15ScriptsItem = CommonAbstraJsonV15DefinitionsScriptStage

CommonAbstraJsonV15Scripts = typing.List[CommonAbstraJsonV15ScriptsItem]

CommonAbstraJsonV15Version = typing.Literal["15.0"]

CommonAbstraJsonV15VersionValues: typing.List[CommonAbstraJsonV15Version] = ["15.0"]


@dataclass
class CommonAbstraJsonV15:
    workspace: CommonAbstraJsonV15Workspace
    home: CommonAbstraJsonV15Home
    jobs: CommonAbstraJsonV15Jobs
    hooks: CommonAbstraJsonV15Hooks
    forms: CommonAbstraJsonV15Forms
    scripts: CommonAbstraJsonV15Scripts
    version: CommonAbstraJsonV15Version

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["workspace"] = self.workspace.to_dict()
        data["home"] = self.home.to_dict()
        data["jobs"] = [item.to_dict() for item in self.jobs]
        data["hooks"] = [item.to_dict() for item in self.hooks]
        data["forms"] = [item.to_dict() for item in self.forms]
        data["scripts"] = [item.to_dict() for item in self.scripts]
        data["version"] = self.version
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV15":
        return cls(
            workspace=CommonAbstraJsonV15Workspace.from_dict(data["workspace"]),
            home=CommonAbstraJsonV15Home.from_dict(data["home"]),
            jobs=[
                CommonAbstraJsonV15DefinitionsJobStage.from_dict(item)
                for item in data["jobs"]
            ],
            hooks=[
                CommonAbstraJsonV15DefinitionsHookStage.from_dict(item)
                for item in data["hooks"]
            ],
            forms=[
                CommonAbstraJsonV15DefinitionsFormStage.from_dict(item)
                for item in data["forms"]
            ],
            scripts=[
                CommonAbstraJsonV15DefinitionsScriptStage.from_dict(item)
                for item in data["scripts"]
            ],
            version=data["version"],
        )


CommonAbstraJsonV14WorkspaceName = str

CommonAbstraJsonV14WorkspaceLanguage = str

CommonAbstraJsonV14WorkspaceThemeString = str

CommonAbstraJsonV14WorkspaceThemeNull = type(None)

CommonAbstraJsonV14WorkspaceTheme = typing.Union[
    CommonAbstraJsonV14WorkspaceThemeString, CommonAbstraJsonV14WorkspaceThemeNull
]

CommonAbstraJsonV14WorkspaceLogoUrlString = str

CommonAbstraJsonV14WorkspaceLogoUrlNull = type(None)

CommonAbstraJsonV14WorkspaceLogoUrl = typing.Union[
    CommonAbstraJsonV14WorkspaceLogoUrlString, CommonAbstraJsonV14WorkspaceLogoUrlNull
]

CommonAbstraJsonV14WorkspaceFaviconUrlString = str

CommonAbstraJsonV14WorkspaceFaviconUrlNull = type(None)

CommonAbstraJsonV14WorkspaceFaviconUrl = typing.Union[
    CommonAbstraJsonV14WorkspaceFaviconUrlString,
    CommonAbstraJsonV14WorkspaceFaviconUrlNull,
]

CommonAbstraJsonV14WorkspaceBrandNameString = str

CommonAbstraJsonV14WorkspaceBrandNameNull = type(None)

CommonAbstraJsonV14WorkspaceBrandName = typing.Union[
    CommonAbstraJsonV14WorkspaceBrandNameString,
    CommonAbstraJsonV14WorkspaceBrandNameNull,
]

CommonAbstraJsonV14WorkspaceMainColorString = str

CommonAbstraJsonV14WorkspaceMainColorNull = type(None)

CommonAbstraJsonV14WorkspaceMainColor = typing.Union[
    CommonAbstraJsonV14WorkspaceMainColorString,
    CommonAbstraJsonV14WorkspaceMainColorNull,
]

CommonAbstraJsonV14WorkspaceFontFamilyString = str

CommonAbstraJsonV14WorkspaceFontFamilyNull = type(None)

CommonAbstraJsonV14WorkspaceFontFamily = typing.Union[
    CommonAbstraJsonV14WorkspaceFontFamilyString,
    CommonAbstraJsonV14WorkspaceFontFamilyNull,
]

CommonAbstraJsonV14WorkspaceFontColorString = str

CommonAbstraJsonV14WorkspaceFontColorNull = type(None)

CommonAbstraJsonV14WorkspaceFontColor = typing.Union[
    CommonAbstraJsonV14WorkspaceFontColorString,
    CommonAbstraJsonV14WorkspaceFontColorNull,
]


@dataclass
class CommonAbstraJsonV14Workspace:
    name: CommonAbstraJsonV14WorkspaceName
    language: CommonAbstraJsonV14WorkspaceLanguage
    theme: CommonAbstraJsonV14WorkspaceTheme
    logo_url: CommonAbstraJsonV14WorkspaceLogoUrl
    favicon_url: CommonAbstraJsonV14WorkspaceFaviconUrl
    brand_name: CommonAbstraJsonV14WorkspaceBrandName
    main_color: CommonAbstraJsonV14WorkspaceMainColor
    font_family: CommonAbstraJsonV14WorkspaceFontFamily
    font_color: CommonAbstraJsonV14WorkspaceFontColor

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["language"] = self.language
        data["theme"] = self.theme if isinstance(self.theme, str) else self.theme
        data["logo_url"] = (
            self.logo_url if isinstance(self.logo_url, str) else self.logo_url
        )
        data["favicon_url"] = (
            self.favicon_url if isinstance(self.favicon_url, str) else self.favicon_url
        )
        data["brand_name"] = (
            self.brand_name if isinstance(self.brand_name, str) else self.brand_name
        )
        data["main_color"] = (
            self.main_color if isinstance(self.main_color, str) else self.main_color
        )
        data["font_family"] = (
            self.font_family if isinstance(self.font_family, str) else self.font_family
        )
        data["font_color"] = (
            self.font_color if isinstance(self.font_color, str) else self.font_color
        )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14Workspace":
        return cls(
            name=str(data["name"]),
            language=str(data["language"]),
            theme=(str(data["theme"]) if isinstance(data["theme"], str) else None),
            logo_url=(
                str(data["logo_url"]) if isinstance(data["logo_url"], str) else None
            ),
            favicon_url=(
                str(data["favicon_url"])
                if isinstance(data["favicon_url"], str)
                else None
            ),
            brand_name=(
                str(data["brand_name"]) if isinstance(data["brand_name"], str) else None
            ),
            main_color=(
                str(data["main_color"]) if isinstance(data["main_color"], str) else None
            ),
            font_family=(
                str(data["font_family"])
                if isinstance(data["font_family"], str)
                else None
            ),
            font_color=(
                str(data["font_color"]) if isinstance(data["font_color"], str) else None
            ),
        )


CommonAbstraJsonV14HomeAccessControlIsPublic = bool

CommonAbstraJsonV14HomeAccessControlRequiredRolesItem = str

CommonAbstraJsonV14HomeAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV14HomeAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV14HomeAccessControl:
    is_public: CommonAbstraJsonV14HomeAccessControlIsPublic
    required_roles: CommonAbstraJsonV14HomeAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14HomeAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


@dataclass
class CommonAbstraJsonV14Home:
    access_control: CommonAbstraJsonV14HomeAccessControl

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["access_control"] = self.access_control.to_dict()
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV14Home":
        return cls(
            access_control=CommonAbstraJsonV14HomeAccessControl.from_dict(
                data["access_control"]
            ),
        )


CommonAbstraJsonV14DefinitionsTransitionId = str

CommonAbstraJsonV14DefinitionsTransitionTargetId = str

CommonAbstraJsonV14DefinitionsTransitionTargetType = str

CommonAbstraJsonV14DefinitionsTransitionType = typing.Literal["task"]

CommonAbstraJsonV14DefinitionsTransitionTypeValues: typing.List[
    CommonAbstraJsonV14DefinitionsTransitionType
] = ["task"]

CommonAbstraJsonV14DefinitionsTransitionTaskTypeString = str

CommonAbstraJsonV14DefinitionsTransitionTaskTypeNull = type(None)

CommonAbstraJsonV14DefinitionsTransitionTaskType = typing.Union[
    CommonAbstraJsonV14DefinitionsTransitionTaskTypeString,
    CommonAbstraJsonV14DefinitionsTransitionTaskTypeNull,
]


@dataclass
class CommonAbstraJsonV14DefinitionsTransition:
    id: CommonAbstraJsonV14DefinitionsTransitionId
    target_id: CommonAbstraJsonV14DefinitionsTransitionTargetId
    target_type: CommonAbstraJsonV14DefinitionsTransitionTargetType
    type: CommonAbstraJsonV14DefinitionsTransitionType
    task_type: typing.Optional[CommonAbstraJsonV14DefinitionsTransitionTaskType] = (
        field(default_factory=lambda: None)
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["target_id"] = self.target_id
        data["target_type"] = self.target_type
        data["type"] = self.type
        if self.task_type is not None:
            data["task_type"] = (
                self.task_type if isinstance(self.task_type, str) else self.task_type
            )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14DefinitionsTransition":
        return cls(
            id=str(data["id"]),
            target_id=str(data["target_id"]),
            target_type=str(data["target_type"]),
            type=data["type"],
            task_type=None
            if data.get("task_type") is None
            else (
                str(data["task_type"]) if isinstance(data["task_type"], str) else None
            ),
        )


CommonAbstraJsonV14DefinitionsJobStageTransitionsItem = (
    CommonAbstraJsonV14DefinitionsTransition
)

CommonAbstraJsonV14DefinitionsJobStageTransitions = typing.List[
    CommonAbstraJsonV14DefinitionsJobStageTransitionsItem
]

CommonAbstraJsonV14DefinitionsJobStageId = str

CommonAbstraJsonV14DefinitionsJobStageTitle = str

CommonAbstraJsonV14DefinitionsJobStageFile = str

CommonAbstraJsonV14DefinitionsJobStageWorkflowPositionItem = float

CommonAbstraJsonV14DefinitionsJobStageWorkflowPosition = typing.List[
    CommonAbstraJsonV14DefinitionsJobStageWorkflowPositionItem
]

CommonAbstraJsonV14DefinitionsJobStageSchedule = str


@dataclass
class CommonAbstraJsonV14DefinitionsJobStage:
    transitions: CommonAbstraJsonV14DefinitionsJobStageTransitions
    id: CommonAbstraJsonV14DefinitionsJobStageId
    title: CommonAbstraJsonV14DefinitionsJobStageTitle
    file: CommonAbstraJsonV14DefinitionsJobStageFile
    workflow_position: CommonAbstraJsonV14DefinitionsJobStageWorkflowPosition
    schedule: CommonAbstraJsonV14DefinitionsJobStageSchedule

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["schedule"] = self.schedule
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14DefinitionsJobStage":
        return cls(
            transitions=[
                CommonAbstraJsonV14DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            schedule=str(data["schedule"]),
        )


CommonAbstraJsonV14JobsItem = CommonAbstraJsonV14DefinitionsJobStage

CommonAbstraJsonV14Jobs = typing.List[CommonAbstraJsonV14JobsItem]

CommonAbstraJsonV14DefinitionsHookStageTransitionsItem = (
    CommonAbstraJsonV14DefinitionsTransition
)

CommonAbstraJsonV14DefinitionsHookStageTransitions = typing.List[
    CommonAbstraJsonV14DefinitionsHookStageTransitionsItem
]

CommonAbstraJsonV14DefinitionsHookStageId = str

CommonAbstraJsonV14DefinitionsHookStageTitle = str

CommonAbstraJsonV14DefinitionsHookStageFile = str

CommonAbstraJsonV14DefinitionsHookStageWorkflowPositionItem = float

CommonAbstraJsonV14DefinitionsHookStageWorkflowPosition = typing.List[
    CommonAbstraJsonV14DefinitionsHookStageWorkflowPositionItem
]

CommonAbstraJsonV14DefinitionsHookStageEnabled = bool

CommonAbstraJsonV14DefinitionsHookStagePath = str

CommonAbstraJsonV14DefinitionsHookStageIsInitial = bool


@dataclass
class CommonAbstraJsonV14DefinitionsHookStage:
    transitions: CommonAbstraJsonV14DefinitionsHookStageTransitions
    id: CommonAbstraJsonV14DefinitionsHookStageId
    title: CommonAbstraJsonV14DefinitionsHookStageTitle
    file: CommonAbstraJsonV14DefinitionsHookStageFile
    workflow_position: CommonAbstraJsonV14DefinitionsHookStageWorkflowPosition
    enabled: CommonAbstraJsonV14DefinitionsHookStageEnabled
    path: CommonAbstraJsonV14DefinitionsHookStagePath
    is_initial: CommonAbstraJsonV14DefinitionsHookStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["enabled"] = self.enabled
        data["path"] = self.path
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14DefinitionsHookStage":
        return cls(
            transitions=[
                CommonAbstraJsonV14DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            enabled=bool(data["enabled"]),
            path=str(data["path"]),
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV14HooksItem = CommonAbstraJsonV14DefinitionsHookStage

CommonAbstraJsonV14Hooks = typing.List[CommonAbstraJsonV14HooksItem]

CommonAbstraJsonV14DefinitionsFormStageTransitionsItem = (
    CommonAbstraJsonV14DefinitionsTransition
)

CommonAbstraJsonV14DefinitionsFormStageTransitions = typing.List[
    CommonAbstraJsonV14DefinitionsFormStageTransitionsItem
]

CommonAbstraJsonV14DefinitionsFormStageId = str

CommonAbstraJsonV14DefinitionsFormStageTitle = str

CommonAbstraJsonV14DefinitionsFormStageFile = str

CommonAbstraJsonV14DefinitionsFormStageWorkflowPositionItem = float

CommonAbstraJsonV14DefinitionsFormStageWorkflowPosition = typing.List[
    CommonAbstraJsonV14DefinitionsFormStageWorkflowPositionItem
]

CommonAbstraJsonV14DefinitionsFormStageStartMessageString = str

CommonAbstraJsonV14DefinitionsFormStageStartMessageNull = type(None)

CommonAbstraJsonV14DefinitionsFormStageStartMessage = typing.Union[
    CommonAbstraJsonV14DefinitionsFormStageStartMessageString,
    CommonAbstraJsonV14DefinitionsFormStageStartMessageNull,
]

CommonAbstraJsonV14DefinitionsFormStageAccessControlIsPublic = bool

CommonAbstraJsonV14DefinitionsFormStageAccessControlRequiredRolesItem = str

CommonAbstraJsonV14DefinitionsFormStageAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV14DefinitionsFormStageAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV14DefinitionsFormStageAccessControl:
    is_public: CommonAbstraJsonV14DefinitionsFormStageAccessControlIsPublic
    required_roles: CommonAbstraJsonV14DefinitionsFormStageAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14DefinitionsFormStageAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


CommonAbstraJsonV14DefinitionsFormStagePath = str

CommonAbstraJsonV14DefinitionsFormStageTimeoutMessageString = str

CommonAbstraJsonV14DefinitionsFormStageTimeoutMessageNull = type(None)

CommonAbstraJsonV14DefinitionsFormStageTimeoutMessage = typing.Union[
    CommonAbstraJsonV14DefinitionsFormStageTimeoutMessageString,
    CommonAbstraJsonV14DefinitionsFormStageTimeoutMessageNull,
]

CommonAbstraJsonV14DefinitionsFormStageStartButtonTextString = str

CommonAbstraJsonV14DefinitionsFormStageStartButtonTextNull = type(None)

CommonAbstraJsonV14DefinitionsFormStageStartButtonText = typing.Union[
    CommonAbstraJsonV14DefinitionsFormStageStartButtonTextString,
    CommonAbstraJsonV14DefinitionsFormStageStartButtonTextNull,
]

CommonAbstraJsonV14DefinitionsFormStageWelcomeTitleString = str

CommonAbstraJsonV14DefinitionsFormStageWelcomeTitleNull = type(None)

CommonAbstraJsonV14DefinitionsFormStageWelcomeTitle = typing.Union[
    CommonAbstraJsonV14DefinitionsFormStageWelcomeTitleString,
    CommonAbstraJsonV14DefinitionsFormStageWelcomeTitleNull,
]

CommonAbstraJsonV14DefinitionsFormStageRestartButtonTextString = str

CommonAbstraJsonV14DefinitionsFormStageRestartButtonTextNull = type(None)

CommonAbstraJsonV14DefinitionsFormStageRestartButtonText = typing.Union[
    CommonAbstraJsonV14DefinitionsFormStageRestartButtonTextString,
    CommonAbstraJsonV14DefinitionsFormStageRestartButtonTextNull,
]

CommonAbstraJsonV14DefinitionsFormStageNotificationTriggerVariableName = str

CommonAbstraJsonV14DefinitionsFormStageNotificationTriggerEnabled = bool


@dataclass
class CommonAbstraJsonV14DefinitionsFormStageNotificationTrigger:
    variable_name: (
        CommonAbstraJsonV14DefinitionsFormStageNotificationTriggerVariableName
    )
    enabled: CommonAbstraJsonV14DefinitionsFormStageNotificationTriggerEnabled

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["variable_name"] = self.variable_name
        data["enabled"] = self.enabled
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14DefinitionsFormStageNotificationTrigger":
        return cls(
            variable_name=str(data["variable_name"]),
            enabled=bool(data["enabled"]),
        )


CommonAbstraJsonV14DefinitionsFormStageEndMessageString = str

CommonAbstraJsonV14DefinitionsFormStageEndMessageNull = type(None)

CommonAbstraJsonV14DefinitionsFormStageEndMessage = typing.Union[
    CommonAbstraJsonV14DefinitionsFormStageEndMessageString,
    CommonAbstraJsonV14DefinitionsFormStageEndMessageNull,
]

CommonAbstraJsonV14DefinitionsFormStageAutoStart = bool

CommonAbstraJsonV14DefinitionsFormStageIsInitial = bool

CommonAbstraJsonV14DefinitionsFormStageErrorMessageString = str

CommonAbstraJsonV14DefinitionsFormStageErrorMessageNull = type(None)

CommonAbstraJsonV14DefinitionsFormStageErrorMessage = typing.Union[
    CommonAbstraJsonV14DefinitionsFormStageErrorMessageString,
    CommonAbstraJsonV14DefinitionsFormStageErrorMessageNull,
]

CommonAbstraJsonV14DefinitionsFormStageAllowRestart = bool


@dataclass
class CommonAbstraJsonV14DefinitionsFormStage:
    transitions: CommonAbstraJsonV14DefinitionsFormStageTransitions
    id: CommonAbstraJsonV14DefinitionsFormStageId
    title: CommonAbstraJsonV14DefinitionsFormStageTitle
    file: CommonAbstraJsonV14DefinitionsFormStageFile
    workflow_position: CommonAbstraJsonV14DefinitionsFormStageWorkflowPosition
    start_message: CommonAbstraJsonV14DefinitionsFormStageStartMessage
    access_control: CommonAbstraJsonV14DefinitionsFormStageAccessControl
    path: CommonAbstraJsonV14DefinitionsFormStagePath
    timeout_message: CommonAbstraJsonV14DefinitionsFormStageTimeoutMessage
    start_button_text: CommonAbstraJsonV14DefinitionsFormStageStartButtonText
    welcome_title: CommonAbstraJsonV14DefinitionsFormStageWelcomeTitle
    restart_button_text: CommonAbstraJsonV14DefinitionsFormStageRestartButtonText
    notification_trigger: CommonAbstraJsonV14DefinitionsFormStageNotificationTrigger
    end_message: CommonAbstraJsonV14DefinitionsFormStageEndMessage
    auto_start: CommonAbstraJsonV14DefinitionsFormStageAutoStart
    is_initial: CommonAbstraJsonV14DefinitionsFormStageIsInitial
    error_message: CommonAbstraJsonV14DefinitionsFormStageErrorMessage
    allow_restart: CommonAbstraJsonV14DefinitionsFormStageAllowRestart

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["start_message"] = (
            self.start_message
            if isinstance(self.start_message, str)
            else self.start_message
        )
        data["access_control"] = self.access_control.to_dict()
        data["path"] = self.path
        data["timeout_message"] = (
            self.timeout_message
            if isinstance(self.timeout_message, str)
            else self.timeout_message
        )
        data["start_button_text"] = (
            self.start_button_text
            if isinstance(self.start_button_text, str)
            else self.start_button_text
        )
        data["welcome_title"] = (
            self.welcome_title
            if isinstance(self.welcome_title, str)
            else self.welcome_title
        )
        data["restart_button_text"] = (
            self.restart_button_text
            if isinstance(self.restart_button_text, str)
            else self.restart_button_text
        )
        data["notification_trigger"] = self.notification_trigger.to_dict()
        data["end_message"] = (
            self.end_message if isinstance(self.end_message, str) else self.end_message
        )
        data["auto_start"] = self.auto_start
        data["is_initial"] = self.is_initial
        data["error_message"] = (
            self.error_message
            if isinstance(self.error_message, str)
            else self.error_message
        )
        data["allow_restart"] = self.allow_restart
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14DefinitionsFormStage":
        return cls(
            transitions=[
                CommonAbstraJsonV14DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            start_message=(
                str(data["start_message"])
                if isinstance(data["start_message"], str)
                else None
            ),
            access_control=CommonAbstraJsonV14DefinitionsFormStageAccessControl.from_dict(
                data["access_control"]
            ),
            path=str(data["path"]),
            timeout_message=(
                str(data["timeout_message"])
                if isinstance(data["timeout_message"], str)
                else None
            ),
            start_button_text=(
                str(data["start_button_text"])
                if isinstance(data["start_button_text"], str)
                else None
            ),
            welcome_title=(
                str(data["welcome_title"])
                if isinstance(data["welcome_title"], str)
                else None
            ),
            restart_button_text=(
                str(data["restart_button_text"])
                if isinstance(data["restart_button_text"], str)
                else None
            ),
            notification_trigger=CommonAbstraJsonV14DefinitionsFormStageNotificationTrigger.from_dict(
                data["notification_trigger"]
            ),
            end_message=(
                str(data["end_message"])
                if isinstance(data["end_message"], str)
                else None
            ),
            auto_start=bool(data["auto_start"]),
            is_initial=bool(data["is_initial"]),
            error_message=(
                str(data["error_message"])
                if isinstance(data["error_message"], str)
                else None
            ),
            allow_restart=bool(data["allow_restart"]),
        )


CommonAbstraJsonV14FormsItem = CommonAbstraJsonV14DefinitionsFormStage

CommonAbstraJsonV14Forms = typing.List[CommonAbstraJsonV14FormsItem]

CommonAbstraJsonV14DefinitionsScriptStageTransitionsItem = (
    CommonAbstraJsonV14DefinitionsTransition
)

CommonAbstraJsonV14DefinitionsScriptStageTransitions = typing.List[
    CommonAbstraJsonV14DefinitionsScriptStageTransitionsItem
]

CommonAbstraJsonV14DefinitionsScriptStageId = str

CommonAbstraJsonV14DefinitionsScriptStageTitle = str

CommonAbstraJsonV14DefinitionsScriptStageFile = str

CommonAbstraJsonV14DefinitionsScriptStageWorkflowPositionItem = float

CommonAbstraJsonV14DefinitionsScriptStageWorkflowPosition = typing.List[
    CommonAbstraJsonV14DefinitionsScriptStageWorkflowPositionItem
]

CommonAbstraJsonV14DefinitionsScriptStageIsInitial = bool


@dataclass
class CommonAbstraJsonV14DefinitionsScriptStage:
    transitions: CommonAbstraJsonV14DefinitionsScriptStageTransitions
    id: CommonAbstraJsonV14DefinitionsScriptStageId
    title: CommonAbstraJsonV14DefinitionsScriptStageTitle
    file: CommonAbstraJsonV14DefinitionsScriptStageFile
    workflow_position: CommonAbstraJsonV14DefinitionsScriptStageWorkflowPosition
    is_initial: CommonAbstraJsonV14DefinitionsScriptStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV14DefinitionsScriptStage":
        return cls(
            transitions=[
                CommonAbstraJsonV14DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV14ScriptsItem = CommonAbstraJsonV14DefinitionsScriptStage

CommonAbstraJsonV14Scripts = typing.List[CommonAbstraJsonV14ScriptsItem]

CommonAbstraJsonV14Version = typing.Literal["14.0"]

CommonAbstraJsonV14VersionValues: typing.List[CommonAbstraJsonV14Version] = ["14.0"]


@dataclass
class CommonAbstraJsonV14:
    workspace: CommonAbstraJsonV14Workspace
    home: CommonAbstraJsonV14Home
    jobs: CommonAbstraJsonV14Jobs
    hooks: CommonAbstraJsonV14Hooks
    forms: CommonAbstraJsonV14Forms
    scripts: CommonAbstraJsonV14Scripts
    version: CommonAbstraJsonV14Version

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["workspace"] = self.workspace.to_dict()
        data["home"] = self.home.to_dict()
        data["jobs"] = [item.to_dict() for item in self.jobs]
        data["hooks"] = [item.to_dict() for item in self.hooks]
        data["forms"] = [item.to_dict() for item in self.forms]
        data["scripts"] = [item.to_dict() for item in self.scripts]
        data["version"] = self.version
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV14":
        return cls(
            workspace=CommonAbstraJsonV14Workspace.from_dict(data["workspace"]),
            home=CommonAbstraJsonV14Home.from_dict(data["home"]),
            jobs=[
                CommonAbstraJsonV14DefinitionsJobStage.from_dict(item)
                for item in data["jobs"]
            ],
            hooks=[
                CommonAbstraJsonV14DefinitionsHookStage.from_dict(item)
                for item in data["hooks"]
            ],
            forms=[
                CommonAbstraJsonV14DefinitionsFormStage.from_dict(item)
                for item in data["forms"]
            ],
            scripts=[
                CommonAbstraJsonV14DefinitionsScriptStage.from_dict(item)
                for item in data["scripts"]
            ],
            version=data["version"],
        )


CommonAbstraJsonV13WorkspaceName = str

CommonAbstraJsonV13WorkspaceLanguage = str

CommonAbstraJsonV13WorkspaceThemeString = str

CommonAbstraJsonV13WorkspaceThemeNull = type(None)

CommonAbstraJsonV13WorkspaceTheme = typing.Union[
    CommonAbstraJsonV13WorkspaceThemeString, CommonAbstraJsonV13WorkspaceThemeNull
]

CommonAbstraJsonV13WorkspaceLogoUrlString = str

CommonAbstraJsonV13WorkspaceLogoUrlNull = type(None)

CommonAbstraJsonV13WorkspaceLogoUrl = typing.Union[
    CommonAbstraJsonV13WorkspaceLogoUrlString, CommonAbstraJsonV13WorkspaceLogoUrlNull
]

CommonAbstraJsonV13WorkspaceFaviconUrlString = str

CommonAbstraJsonV13WorkspaceFaviconUrlNull = type(None)

CommonAbstraJsonV13WorkspaceFaviconUrl = typing.Union[
    CommonAbstraJsonV13WorkspaceFaviconUrlString,
    CommonAbstraJsonV13WorkspaceFaviconUrlNull,
]

CommonAbstraJsonV13WorkspaceBrandNameString = str

CommonAbstraJsonV13WorkspaceBrandNameNull = type(None)

CommonAbstraJsonV13WorkspaceBrandName = typing.Union[
    CommonAbstraJsonV13WorkspaceBrandNameString,
    CommonAbstraJsonV13WorkspaceBrandNameNull,
]

CommonAbstraJsonV13WorkspaceMainColorString = str

CommonAbstraJsonV13WorkspaceMainColorNull = type(None)

CommonAbstraJsonV13WorkspaceMainColor = typing.Union[
    CommonAbstraJsonV13WorkspaceMainColorString,
    CommonAbstraJsonV13WorkspaceMainColorNull,
]

CommonAbstraJsonV13WorkspaceFontFamilyString = str

CommonAbstraJsonV13WorkspaceFontFamilyNull = type(None)

CommonAbstraJsonV13WorkspaceFontFamily = typing.Union[
    CommonAbstraJsonV13WorkspaceFontFamilyString,
    CommonAbstraJsonV13WorkspaceFontFamilyNull,
]

CommonAbstraJsonV13WorkspaceFontColorString = str

CommonAbstraJsonV13WorkspaceFontColorNull = type(None)

CommonAbstraJsonV13WorkspaceFontColor = typing.Union[
    CommonAbstraJsonV13WorkspaceFontColorString,
    CommonAbstraJsonV13WorkspaceFontColorNull,
]


@dataclass
class CommonAbstraJsonV13Workspace:
    name: CommonAbstraJsonV13WorkspaceName
    language: CommonAbstraJsonV13WorkspaceLanguage
    theme: CommonAbstraJsonV13WorkspaceTheme
    logo_url: CommonAbstraJsonV13WorkspaceLogoUrl
    favicon_url: CommonAbstraJsonV13WorkspaceFaviconUrl
    brand_name: CommonAbstraJsonV13WorkspaceBrandName
    main_color: CommonAbstraJsonV13WorkspaceMainColor
    font_family: CommonAbstraJsonV13WorkspaceFontFamily
    font_color: CommonAbstraJsonV13WorkspaceFontColor

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["language"] = self.language
        data["theme"] = self.theme if isinstance(self.theme, str) else self.theme
        data["logo_url"] = (
            self.logo_url if isinstance(self.logo_url, str) else self.logo_url
        )
        data["favicon_url"] = (
            self.favicon_url if isinstance(self.favicon_url, str) else self.favicon_url
        )
        data["brand_name"] = (
            self.brand_name if isinstance(self.brand_name, str) else self.brand_name
        )
        data["main_color"] = (
            self.main_color if isinstance(self.main_color, str) else self.main_color
        )
        data["font_family"] = (
            self.font_family if isinstance(self.font_family, str) else self.font_family
        )
        data["font_color"] = (
            self.font_color if isinstance(self.font_color, str) else self.font_color
        )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13Workspace":
        return cls(
            name=str(data["name"]),
            language=str(data["language"]),
            theme=(str(data["theme"]) if isinstance(data["theme"], str) else None),
            logo_url=(
                str(data["logo_url"]) if isinstance(data["logo_url"], str) else None
            ),
            favicon_url=(
                str(data["favicon_url"])
                if isinstance(data["favicon_url"], str)
                else None
            ),
            brand_name=(
                str(data["brand_name"]) if isinstance(data["brand_name"], str) else None
            ),
            main_color=(
                str(data["main_color"]) if isinstance(data["main_color"], str) else None
            ),
            font_family=(
                str(data["font_family"])
                if isinstance(data["font_family"], str)
                else None
            ),
            font_color=(
                str(data["font_color"]) if isinstance(data["font_color"], str) else None
            ),
        )


CommonAbstraJsonV13HomeAccessControlIsPublic = bool

CommonAbstraJsonV13HomeAccessControlRequiredRolesItem = str

CommonAbstraJsonV13HomeAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV13HomeAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV13HomeAccessControl:
    is_public: CommonAbstraJsonV13HomeAccessControlIsPublic
    required_roles: CommonAbstraJsonV13HomeAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13HomeAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


@dataclass
class CommonAbstraJsonV13Home:
    access_control: CommonAbstraJsonV13HomeAccessControl

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["access_control"] = self.access_control.to_dict()
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV13Home":
        return cls(
            access_control=CommonAbstraJsonV13HomeAccessControl.from_dict(
                data["access_control"]
            ),
        )


CommonAbstraJsonV13DefinitionsTransitionId = str

CommonAbstraJsonV13DefinitionsTransitionTargetId = str

CommonAbstraJsonV13DefinitionsTransitionTargetType = str

CommonAbstraJsonV13DefinitionsTransitionType = str

CommonAbstraJsonV13DefinitionsTransitionTaskTypeString = str

CommonAbstraJsonV13DefinitionsTransitionTaskTypeNull = type(None)

CommonAbstraJsonV13DefinitionsTransitionTaskType = typing.Union[
    CommonAbstraJsonV13DefinitionsTransitionTaskTypeString,
    CommonAbstraJsonV13DefinitionsTransitionTaskTypeNull,
]


@dataclass
class CommonAbstraJsonV13DefinitionsTransition:
    id: CommonAbstraJsonV13DefinitionsTransitionId
    target_id: CommonAbstraJsonV13DefinitionsTransitionTargetId
    target_type: CommonAbstraJsonV13DefinitionsTransitionTargetType
    type: CommonAbstraJsonV13DefinitionsTransitionType
    task_type: typing.Optional[CommonAbstraJsonV13DefinitionsTransitionTaskType] = (
        field(default_factory=lambda: None)
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["target_id"] = self.target_id
        data["target_type"] = self.target_type
        data["type"] = self.type
        if self.task_type is not None:
            data["task_type"] = (
                self.task_type if isinstance(self.task_type, str) else self.task_type
            )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13DefinitionsTransition":
        return cls(
            id=str(data["id"]),
            target_id=str(data["target_id"]),
            target_type=str(data["target_type"]),
            type=str(data["type"]),
            task_type=None
            if data.get("task_type") is None
            else (
                str(data["task_type"]) if isinstance(data["task_type"], str) else None
            ),
        )


CommonAbstraJsonV13DefinitionsJobStageTransitionsItem = (
    CommonAbstraJsonV13DefinitionsTransition
)

CommonAbstraJsonV13DefinitionsJobStageTransitions = typing.List[
    CommonAbstraJsonV13DefinitionsJobStageTransitionsItem
]

CommonAbstraJsonV13DefinitionsJobStageId = str

CommonAbstraJsonV13DefinitionsJobStageTitle = str

CommonAbstraJsonV13DefinitionsJobStageFile = str

CommonAbstraJsonV13DefinitionsJobStageWorkflowPositionItem = float

CommonAbstraJsonV13DefinitionsJobStageWorkflowPosition = typing.List[
    CommonAbstraJsonV13DefinitionsJobStageWorkflowPositionItem
]

CommonAbstraJsonV13DefinitionsJobStageSchedule = str


@dataclass
class CommonAbstraJsonV13DefinitionsJobStage:
    transitions: CommonAbstraJsonV13DefinitionsJobStageTransitions
    id: CommonAbstraJsonV13DefinitionsJobStageId
    title: CommonAbstraJsonV13DefinitionsJobStageTitle
    file: CommonAbstraJsonV13DefinitionsJobStageFile
    workflow_position: CommonAbstraJsonV13DefinitionsJobStageWorkflowPosition
    schedule: CommonAbstraJsonV13DefinitionsJobStageSchedule

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["schedule"] = self.schedule
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13DefinitionsJobStage":
        return cls(
            transitions=[
                CommonAbstraJsonV13DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            schedule=str(data["schedule"]),
        )


CommonAbstraJsonV13JobsItem = CommonAbstraJsonV13DefinitionsJobStage

CommonAbstraJsonV13Jobs = typing.List[CommonAbstraJsonV13JobsItem]

CommonAbstraJsonV13DefinitionsHookStageTransitionsItem = (
    CommonAbstraJsonV13DefinitionsTransition
)

CommonAbstraJsonV13DefinitionsHookStageTransitions = typing.List[
    CommonAbstraJsonV13DefinitionsHookStageTransitionsItem
]

CommonAbstraJsonV13DefinitionsHookStageId = str

CommonAbstraJsonV13DefinitionsHookStageTitle = str

CommonAbstraJsonV13DefinitionsHookStageFile = str

CommonAbstraJsonV13DefinitionsHookStageWorkflowPositionItem = float

CommonAbstraJsonV13DefinitionsHookStageWorkflowPosition = typing.List[
    CommonAbstraJsonV13DefinitionsHookStageWorkflowPositionItem
]

CommonAbstraJsonV13DefinitionsHookStageEnabled = bool

CommonAbstraJsonV13DefinitionsHookStagePath = str

CommonAbstraJsonV13DefinitionsHookStageIsInitial = bool


@dataclass
class CommonAbstraJsonV13DefinitionsHookStage:
    transitions: CommonAbstraJsonV13DefinitionsHookStageTransitions
    id: CommonAbstraJsonV13DefinitionsHookStageId
    title: CommonAbstraJsonV13DefinitionsHookStageTitle
    file: CommonAbstraJsonV13DefinitionsHookStageFile
    workflow_position: CommonAbstraJsonV13DefinitionsHookStageWorkflowPosition
    enabled: CommonAbstraJsonV13DefinitionsHookStageEnabled
    path: CommonAbstraJsonV13DefinitionsHookStagePath
    is_initial: CommonAbstraJsonV13DefinitionsHookStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["enabled"] = self.enabled
        data["path"] = self.path
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13DefinitionsHookStage":
        return cls(
            transitions=[
                CommonAbstraJsonV13DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            enabled=bool(data["enabled"]),
            path=str(data["path"]),
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV13HooksItem = CommonAbstraJsonV13DefinitionsHookStage

CommonAbstraJsonV13Hooks = typing.List[CommonAbstraJsonV13HooksItem]

CommonAbstraJsonV13DefinitionsFormStageTransitionsItem = (
    CommonAbstraJsonV13DefinitionsTransition
)

CommonAbstraJsonV13DefinitionsFormStageTransitions = typing.List[
    CommonAbstraJsonV13DefinitionsFormStageTransitionsItem
]

CommonAbstraJsonV13DefinitionsFormStageId = str

CommonAbstraJsonV13DefinitionsFormStageTitle = str

CommonAbstraJsonV13DefinitionsFormStageFile = str

CommonAbstraJsonV13DefinitionsFormStageWorkflowPositionItem = float

CommonAbstraJsonV13DefinitionsFormStageWorkflowPosition = typing.List[
    CommonAbstraJsonV13DefinitionsFormStageWorkflowPositionItem
]

CommonAbstraJsonV13DefinitionsFormStageStartMessageString = str

CommonAbstraJsonV13DefinitionsFormStageStartMessageNull = type(None)

CommonAbstraJsonV13DefinitionsFormStageStartMessage = typing.Union[
    CommonAbstraJsonV13DefinitionsFormStageStartMessageString,
    CommonAbstraJsonV13DefinitionsFormStageStartMessageNull,
]

CommonAbstraJsonV13DefinitionsFormStageAccessControlIsPublic = bool

CommonAbstraJsonV13DefinitionsFormStageAccessControlRequiredRolesItem = str

CommonAbstraJsonV13DefinitionsFormStageAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV13DefinitionsFormStageAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV13DefinitionsFormStageAccessControl:
    is_public: CommonAbstraJsonV13DefinitionsFormStageAccessControlIsPublic
    required_roles: CommonAbstraJsonV13DefinitionsFormStageAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13DefinitionsFormStageAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


CommonAbstraJsonV13DefinitionsFormStagePath = str

CommonAbstraJsonV13DefinitionsFormStageTimeoutMessageString = str

CommonAbstraJsonV13DefinitionsFormStageTimeoutMessageNull = type(None)

CommonAbstraJsonV13DefinitionsFormStageTimeoutMessage = typing.Union[
    CommonAbstraJsonV13DefinitionsFormStageTimeoutMessageString,
    CommonAbstraJsonV13DefinitionsFormStageTimeoutMessageNull,
]

CommonAbstraJsonV13DefinitionsFormStageStartButtonTextString = str

CommonAbstraJsonV13DefinitionsFormStageStartButtonTextNull = type(None)

CommonAbstraJsonV13DefinitionsFormStageStartButtonText = typing.Union[
    CommonAbstraJsonV13DefinitionsFormStageStartButtonTextString,
    CommonAbstraJsonV13DefinitionsFormStageStartButtonTextNull,
]

CommonAbstraJsonV13DefinitionsFormStageWelcomeTitleString = str

CommonAbstraJsonV13DefinitionsFormStageWelcomeTitleNull = type(None)

CommonAbstraJsonV13DefinitionsFormStageWelcomeTitle = typing.Union[
    CommonAbstraJsonV13DefinitionsFormStageWelcomeTitleString,
    CommonAbstraJsonV13DefinitionsFormStageWelcomeTitleNull,
]

CommonAbstraJsonV13DefinitionsFormStageRestartButtonTextString = str

CommonAbstraJsonV13DefinitionsFormStageRestartButtonTextNull = type(None)

CommonAbstraJsonV13DefinitionsFormStageRestartButtonText = typing.Union[
    CommonAbstraJsonV13DefinitionsFormStageRestartButtonTextString,
    CommonAbstraJsonV13DefinitionsFormStageRestartButtonTextNull,
]

CommonAbstraJsonV13DefinitionsFormStageNotificationTriggerVariableName = str

CommonAbstraJsonV13DefinitionsFormStageNotificationTriggerEnabled = bool


@dataclass
class CommonAbstraJsonV13DefinitionsFormStageNotificationTrigger:
    variable_name: (
        CommonAbstraJsonV13DefinitionsFormStageNotificationTriggerVariableName
    )
    enabled: CommonAbstraJsonV13DefinitionsFormStageNotificationTriggerEnabled

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["variable_name"] = self.variable_name
        data["enabled"] = self.enabled
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13DefinitionsFormStageNotificationTrigger":
        return cls(
            variable_name=str(data["variable_name"]),
            enabled=bool(data["enabled"]),
        )


CommonAbstraJsonV13DefinitionsFormStageEndMessageString = str

CommonAbstraJsonV13DefinitionsFormStageEndMessageNull = type(None)

CommonAbstraJsonV13DefinitionsFormStageEndMessage = typing.Union[
    CommonAbstraJsonV13DefinitionsFormStageEndMessageString,
    CommonAbstraJsonV13DefinitionsFormStageEndMessageNull,
]

CommonAbstraJsonV13DefinitionsFormStageAutoStart = bool

CommonAbstraJsonV13DefinitionsFormStageIsInitial = bool

CommonAbstraJsonV13DefinitionsFormStageErrorMessageString = str

CommonAbstraJsonV13DefinitionsFormStageErrorMessageNull = type(None)

CommonAbstraJsonV13DefinitionsFormStageErrorMessage = typing.Union[
    CommonAbstraJsonV13DefinitionsFormStageErrorMessageString,
    CommonAbstraJsonV13DefinitionsFormStageErrorMessageNull,
]

CommonAbstraJsonV13DefinitionsFormStageAllowRestart = bool


@dataclass
class CommonAbstraJsonV13DefinitionsFormStage:
    transitions: CommonAbstraJsonV13DefinitionsFormStageTransitions
    id: CommonAbstraJsonV13DefinitionsFormStageId
    title: CommonAbstraJsonV13DefinitionsFormStageTitle
    file: CommonAbstraJsonV13DefinitionsFormStageFile
    workflow_position: CommonAbstraJsonV13DefinitionsFormStageWorkflowPosition
    start_message: CommonAbstraJsonV13DefinitionsFormStageStartMessage
    access_control: CommonAbstraJsonV13DefinitionsFormStageAccessControl
    path: CommonAbstraJsonV13DefinitionsFormStagePath
    timeout_message: CommonAbstraJsonV13DefinitionsFormStageTimeoutMessage
    start_button_text: CommonAbstraJsonV13DefinitionsFormStageStartButtonText
    welcome_title: CommonAbstraJsonV13DefinitionsFormStageWelcomeTitle
    restart_button_text: CommonAbstraJsonV13DefinitionsFormStageRestartButtonText
    notification_trigger: CommonAbstraJsonV13DefinitionsFormStageNotificationTrigger
    end_message: CommonAbstraJsonV13DefinitionsFormStageEndMessage
    auto_start: CommonAbstraJsonV13DefinitionsFormStageAutoStart
    is_initial: CommonAbstraJsonV13DefinitionsFormStageIsInitial
    error_message: CommonAbstraJsonV13DefinitionsFormStageErrorMessage
    allow_restart: CommonAbstraJsonV13DefinitionsFormStageAllowRestart

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["start_message"] = (
            self.start_message
            if isinstance(self.start_message, str)
            else self.start_message
        )
        data["access_control"] = self.access_control.to_dict()
        data["path"] = self.path
        data["timeout_message"] = (
            self.timeout_message
            if isinstance(self.timeout_message, str)
            else self.timeout_message
        )
        data["start_button_text"] = (
            self.start_button_text
            if isinstance(self.start_button_text, str)
            else self.start_button_text
        )
        data["welcome_title"] = (
            self.welcome_title
            if isinstance(self.welcome_title, str)
            else self.welcome_title
        )
        data["restart_button_text"] = (
            self.restart_button_text
            if isinstance(self.restart_button_text, str)
            else self.restart_button_text
        )
        data["notification_trigger"] = self.notification_trigger.to_dict()
        data["end_message"] = (
            self.end_message if isinstance(self.end_message, str) else self.end_message
        )
        data["auto_start"] = self.auto_start
        data["is_initial"] = self.is_initial
        data["error_message"] = (
            self.error_message
            if isinstance(self.error_message, str)
            else self.error_message
        )
        data["allow_restart"] = self.allow_restart
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13DefinitionsFormStage":
        return cls(
            transitions=[
                CommonAbstraJsonV13DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            start_message=(
                str(data["start_message"])
                if isinstance(data["start_message"], str)
                else None
            ),
            access_control=CommonAbstraJsonV13DefinitionsFormStageAccessControl.from_dict(
                data["access_control"]
            ),
            path=str(data["path"]),
            timeout_message=(
                str(data["timeout_message"])
                if isinstance(data["timeout_message"], str)
                else None
            ),
            start_button_text=(
                str(data["start_button_text"])
                if isinstance(data["start_button_text"], str)
                else None
            ),
            welcome_title=(
                str(data["welcome_title"])
                if isinstance(data["welcome_title"], str)
                else None
            ),
            restart_button_text=(
                str(data["restart_button_text"])
                if isinstance(data["restart_button_text"], str)
                else None
            ),
            notification_trigger=CommonAbstraJsonV13DefinitionsFormStageNotificationTrigger.from_dict(
                data["notification_trigger"]
            ),
            end_message=(
                str(data["end_message"])
                if isinstance(data["end_message"], str)
                else None
            ),
            auto_start=bool(data["auto_start"]),
            is_initial=bool(data["is_initial"]),
            error_message=(
                str(data["error_message"])
                if isinstance(data["error_message"], str)
                else None
            ),
            allow_restart=bool(data["allow_restart"]),
        )


CommonAbstraJsonV13FormsItem = CommonAbstraJsonV13DefinitionsFormStage

CommonAbstraJsonV13Forms = typing.List[CommonAbstraJsonV13FormsItem]

CommonAbstraJsonV13DefinitionsScriptStageTransitionsItem = (
    CommonAbstraJsonV13DefinitionsTransition
)

CommonAbstraJsonV13DefinitionsScriptStageTransitions = typing.List[
    CommonAbstraJsonV13DefinitionsScriptStageTransitionsItem
]

CommonAbstraJsonV13DefinitionsScriptStageId = str

CommonAbstraJsonV13DefinitionsScriptStageTitle = str

CommonAbstraJsonV13DefinitionsScriptStageFile = str

CommonAbstraJsonV13DefinitionsScriptStageWorkflowPositionItem = float

CommonAbstraJsonV13DefinitionsScriptStageWorkflowPosition = typing.List[
    CommonAbstraJsonV13DefinitionsScriptStageWorkflowPositionItem
]

CommonAbstraJsonV13DefinitionsScriptStageIsInitial = bool


@dataclass
class CommonAbstraJsonV13DefinitionsScriptStage:
    transitions: CommonAbstraJsonV13DefinitionsScriptStageTransitions
    id: CommonAbstraJsonV13DefinitionsScriptStageId
    title: CommonAbstraJsonV13DefinitionsScriptStageTitle
    file: CommonAbstraJsonV13DefinitionsScriptStageFile
    workflow_position: CommonAbstraJsonV13DefinitionsScriptStageWorkflowPosition
    is_initial: CommonAbstraJsonV13DefinitionsScriptStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13DefinitionsScriptStage":
        return cls(
            transitions=[
                CommonAbstraJsonV13DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV13ScriptsItem = CommonAbstraJsonV13DefinitionsScriptStage

CommonAbstraJsonV13Scripts = typing.List[CommonAbstraJsonV13ScriptsItem]

CommonAbstraJsonV13AgentsItemId = str

CommonAbstraJsonV13AgentsItemTitle = str

CommonAbstraJsonV13AgentsItemProjectIdString = str

CommonAbstraJsonV13AgentsItemProjectIdNull = type(None)

CommonAbstraJsonV13AgentsItemProjectId = typing.Union[
    CommonAbstraJsonV13AgentsItemProjectIdString,
    CommonAbstraJsonV13AgentsItemProjectIdNull,
]

CommonAbstraJsonV13AgentsItemWorkflowPositionItem = float

CommonAbstraJsonV13AgentsItemWorkflowPosition = typing.List[
    CommonAbstraJsonV13AgentsItemWorkflowPositionItem
]

CommonAbstraJsonV13AgentsItemTransitionsItem = CommonAbstraJsonV13DefinitionsTransition

CommonAbstraJsonV13AgentsItemTransitions = typing.List[
    CommonAbstraJsonV13AgentsItemTransitionsItem
]

CommonAbstraJsonV13AgentsItemClientStageIdString = str

CommonAbstraJsonV13AgentsItemClientStageIdNull = type(None)

CommonAbstraJsonV13AgentsItemClientStageId = typing.Union[
    CommonAbstraJsonV13AgentsItemClientStageIdString,
    CommonAbstraJsonV13AgentsItemClientStageIdNull,
]


@dataclass
class CommonAbstraJsonV13AgentsItem:
    id: CommonAbstraJsonV13AgentsItemId
    title: CommonAbstraJsonV13AgentsItemTitle
    project_id: CommonAbstraJsonV13AgentsItemProjectId
    workflow_position: CommonAbstraJsonV13AgentsItemWorkflowPosition
    transitions: CommonAbstraJsonV13AgentsItemTransitions
    client_stage_id: CommonAbstraJsonV13AgentsItemClientStageId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["title"] = self.title
        data["project_id"] = (
            self.project_id if isinstance(self.project_id, str) else self.project_id
        )
        data["workflow_position"] = self.workflow_position
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["client_stage_id"] = (
            self.client_stage_id
            if isinstance(self.client_stage_id, str)
            else self.client_stage_id
        )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13AgentsItem":
        return cls(
            id=str(data["id"]),
            title=str(data["title"]),
            project_id=(
                str(data["project_id"]) if isinstance(data["project_id"], str) else None
            ),
            workflow_position=[float(item) for item in data["workflow_position"]],
            transitions=[
                CommonAbstraJsonV13DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            client_stage_id=(
                str(data["client_stage_id"])
                if isinstance(data["client_stage_id"], str)
                else None
            ),
        )


CommonAbstraJsonV13Agents = typing.List[CommonAbstraJsonV13AgentsItem]

CommonAbstraJsonV13ClientsItemId = str

CommonAbstraJsonV13ClientsItemTitle = str

CommonAbstraJsonV13ClientsItemWorkflowPositionItem = float

CommonAbstraJsonV13ClientsItemWorkflowPosition = typing.List[
    CommonAbstraJsonV13ClientsItemWorkflowPositionItem
]

CommonAbstraJsonV13ClientsItemTransitionsItem = CommonAbstraJsonV13DefinitionsTransition

CommonAbstraJsonV13ClientsItemTransitions = typing.List[
    CommonAbstraJsonV13ClientsItemTransitionsItem
]


@dataclass
class CommonAbstraJsonV13ClientsItem:
    id: CommonAbstraJsonV13ClientsItemId
    title: CommonAbstraJsonV13ClientsItemTitle
    workflow_position: CommonAbstraJsonV13ClientsItemWorkflowPosition
    transitions: CommonAbstraJsonV13ClientsItemTransitions

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["title"] = self.title
        data["workflow_position"] = self.workflow_position
        data["transitions"] = [item.to_dict() for item in self.transitions]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV13ClientsItem":
        return cls(
            id=str(data["id"]),
            title=str(data["title"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            transitions=[
                CommonAbstraJsonV13DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
        )


CommonAbstraJsonV13Clients = typing.List[CommonAbstraJsonV13ClientsItem]

CommonAbstraJsonV13Version = typing.Literal["13.0"]

CommonAbstraJsonV13VersionValues: typing.List[CommonAbstraJsonV13Version] = ["13.0"]


@dataclass
class CommonAbstraJsonV13:
    workspace: CommonAbstraJsonV13Workspace
    home: CommonAbstraJsonV13Home
    jobs: CommonAbstraJsonV13Jobs
    hooks: CommonAbstraJsonV13Hooks
    forms: CommonAbstraJsonV13Forms
    scripts: CommonAbstraJsonV13Scripts
    agents: CommonAbstraJsonV13Agents
    clients: CommonAbstraJsonV13Clients
    version: CommonAbstraJsonV13Version

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["workspace"] = self.workspace.to_dict()
        data["home"] = self.home.to_dict()
        data["jobs"] = [item.to_dict() for item in self.jobs]
        data["hooks"] = [item.to_dict() for item in self.hooks]
        data["forms"] = [item.to_dict() for item in self.forms]
        data["scripts"] = [item.to_dict() for item in self.scripts]
        data["agents"] = [item.to_dict() for item in self.agents]
        data["clients"] = [item.to_dict() for item in self.clients]
        data["version"] = self.version
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV13":
        return cls(
            workspace=CommonAbstraJsonV13Workspace.from_dict(data["workspace"]),
            home=CommonAbstraJsonV13Home.from_dict(data["home"]),
            jobs=[
                CommonAbstraJsonV13DefinitionsJobStage.from_dict(item)
                for item in data["jobs"]
            ],
            hooks=[
                CommonAbstraJsonV13DefinitionsHookStage.from_dict(item)
                for item in data["hooks"]
            ],
            forms=[
                CommonAbstraJsonV13DefinitionsFormStage.from_dict(item)
                for item in data["forms"]
            ],
            scripts=[
                CommonAbstraJsonV13DefinitionsScriptStage.from_dict(item)
                for item in data["scripts"]
            ],
            agents=[
                CommonAbstraJsonV13AgentsItem.from_dict(item) for item in data["agents"]
            ],
            clients=[
                CommonAbstraJsonV13ClientsItem.from_dict(item)
                for item in data["clients"]
            ],
            version=data["version"],
        )


CommonAbstraJsonV12WorkspaceName = str

CommonAbstraJsonV12WorkspaceLanguage = str

CommonAbstraJsonV12WorkspaceThemeString = str

CommonAbstraJsonV12WorkspaceThemeNull = type(None)

CommonAbstraJsonV12WorkspaceTheme = typing.Union[
    CommonAbstraJsonV12WorkspaceThemeString, CommonAbstraJsonV12WorkspaceThemeNull
]

CommonAbstraJsonV12WorkspaceLogoUrlString = str

CommonAbstraJsonV12WorkspaceLogoUrlNull = type(None)

CommonAbstraJsonV12WorkspaceLogoUrl = typing.Union[
    CommonAbstraJsonV12WorkspaceLogoUrlString, CommonAbstraJsonV12WorkspaceLogoUrlNull
]

CommonAbstraJsonV12WorkspaceFaviconUrlString = str

CommonAbstraJsonV12WorkspaceFaviconUrlNull = type(None)

CommonAbstraJsonV12WorkspaceFaviconUrl = typing.Union[
    CommonAbstraJsonV12WorkspaceFaviconUrlString,
    CommonAbstraJsonV12WorkspaceFaviconUrlNull,
]

CommonAbstraJsonV12WorkspaceBrandNameString = str

CommonAbstraJsonV12WorkspaceBrandNameNull = type(None)

CommonAbstraJsonV12WorkspaceBrandName = typing.Union[
    CommonAbstraJsonV12WorkspaceBrandNameString,
    CommonAbstraJsonV12WorkspaceBrandNameNull,
]

CommonAbstraJsonV12WorkspaceMainColorString = str

CommonAbstraJsonV12WorkspaceMainColorNull = type(None)

CommonAbstraJsonV12WorkspaceMainColor = typing.Union[
    CommonAbstraJsonV12WorkspaceMainColorString,
    CommonAbstraJsonV12WorkspaceMainColorNull,
]

CommonAbstraJsonV12WorkspaceFontFamilyString = str

CommonAbstraJsonV12WorkspaceFontFamilyNull = type(None)

CommonAbstraJsonV12WorkspaceFontFamily = typing.Union[
    CommonAbstraJsonV12WorkspaceFontFamilyString,
    CommonAbstraJsonV12WorkspaceFontFamilyNull,
]

CommonAbstraJsonV12WorkspaceFontColorString = str

CommonAbstraJsonV12WorkspaceFontColorNull = type(None)

CommonAbstraJsonV12WorkspaceFontColor = typing.Union[
    CommonAbstraJsonV12WorkspaceFontColorString,
    CommonAbstraJsonV12WorkspaceFontColorNull,
]


@dataclass
class CommonAbstraJsonV12Workspace:
    name: CommonAbstraJsonV12WorkspaceName
    language: CommonAbstraJsonV12WorkspaceLanguage
    theme: CommonAbstraJsonV12WorkspaceTheme
    logo_url: CommonAbstraJsonV12WorkspaceLogoUrl
    favicon_url: CommonAbstraJsonV12WorkspaceFaviconUrl
    brand_name: CommonAbstraJsonV12WorkspaceBrandName
    main_color: CommonAbstraJsonV12WorkspaceMainColor
    font_family: CommonAbstraJsonV12WorkspaceFontFamily
    font_color: CommonAbstraJsonV12WorkspaceFontColor

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["language"] = self.language
        data["theme"] = self.theme if isinstance(self.theme, str) else self.theme
        data["logo_url"] = (
            self.logo_url if isinstance(self.logo_url, str) else self.logo_url
        )
        data["favicon_url"] = (
            self.favicon_url if isinstance(self.favicon_url, str) else self.favicon_url
        )
        data["brand_name"] = (
            self.brand_name if isinstance(self.brand_name, str) else self.brand_name
        )
        data["main_color"] = (
            self.main_color if isinstance(self.main_color, str) else self.main_color
        )
        data["font_family"] = (
            self.font_family if isinstance(self.font_family, str) else self.font_family
        )
        data["font_color"] = (
            self.font_color if isinstance(self.font_color, str) else self.font_color
        )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12Workspace":
        return cls(
            name=str(data["name"]),
            language=str(data["language"]),
            theme=(str(data["theme"]) if isinstance(data["theme"], str) else None),
            logo_url=(
                str(data["logo_url"]) if isinstance(data["logo_url"], str) else None
            ),
            favicon_url=(
                str(data["favicon_url"])
                if isinstance(data["favicon_url"], str)
                else None
            ),
            brand_name=(
                str(data["brand_name"]) if isinstance(data["brand_name"], str) else None
            ),
            main_color=(
                str(data["main_color"]) if isinstance(data["main_color"], str) else None
            ),
            font_family=(
                str(data["font_family"])
                if isinstance(data["font_family"], str)
                else None
            ),
            font_color=(
                str(data["font_color"]) if isinstance(data["font_color"], str) else None
            ),
        )


CommonAbstraJsonV12HomeAccessControlIsPublic = bool

CommonAbstraJsonV12HomeAccessControlRequiredRolesItem = str

CommonAbstraJsonV12HomeAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV12HomeAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV12HomeAccessControl:
    is_public: CommonAbstraJsonV12HomeAccessControlIsPublic
    required_roles: CommonAbstraJsonV12HomeAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12HomeAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


@dataclass
class CommonAbstraJsonV12Home:
    access_control: CommonAbstraJsonV12HomeAccessControl

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["access_control"] = self.access_control.to_dict()
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV12Home":
        return cls(
            access_control=CommonAbstraJsonV12HomeAccessControl.from_dict(
                data["access_control"]
            ),
        )


CommonAbstraJsonV12DefinitionsTransitionId = str

CommonAbstraJsonV12DefinitionsTransitionTargetId = str

CommonAbstraJsonV12DefinitionsTransitionTargetType = str

CommonAbstraJsonV12DefinitionsTransitionType = str

CommonAbstraJsonV12DefinitionsTransitionTaskTypeString = str

CommonAbstraJsonV12DefinitionsTransitionTaskTypeNull = type(None)

CommonAbstraJsonV12DefinitionsTransitionTaskType = typing.Union[
    CommonAbstraJsonV12DefinitionsTransitionTaskTypeString,
    CommonAbstraJsonV12DefinitionsTransitionTaskTypeNull,
]


@dataclass
class CommonAbstraJsonV12DefinitionsTransition:
    id: CommonAbstraJsonV12DefinitionsTransitionId
    target_id: CommonAbstraJsonV12DefinitionsTransitionTargetId
    target_type: CommonAbstraJsonV12DefinitionsTransitionTargetType
    type: CommonAbstraJsonV12DefinitionsTransitionType
    task_type: typing.Optional[CommonAbstraJsonV12DefinitionsTransitionTaskType] = (
        field(default_factory=lambda: None)
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["target_id"] = self.target_id
        data["target_type"] = self.target_type
        data["type"] = self.type
        if self.task_type is not None:
            data["task_type"] = (
                self.task_type if isinstance(self.task_type, str) else self.task_type
            )
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12DefinitionsTransition":
        return cls(
            id=str(data["id"]),
            target_id=str(data["target_id"]),
            target_type=str(data["target_type"]),
            type=str(data["type"]),
            task_type=None
            if data.get("task_type") is None
            else (
                str(data["task_type"]) if isinstance(data["task_type"], str) else None
            ),
        )


CommonAbstraJsonV12DefinitionsJobStageTransitionsItem = (
    CommonAbstraJsonV12DefinitionsTransition
)

CommonAbstraJsonV12DefinitionsJobStageTransitions = typing.List[
    CommonAbstraJsonV12DefinitionsJobStageTransitionsItem
]

CommonAbstraJsonV12DefinitionsJobStageId = str

CommonAbstraJsonV12DefinitionsJobStageTitle = str

CommonAbstraJsonV12DefinitionsJobStageFile = str

CommonAbstraJsonV12DefinitionsJobStageWorkflowPositionItem = float

CommonAbstraJsonV12DefinitionsJobStageWorkflowPosition = typing.List[
    CommonAbstraJsonV12DefinitionsJobStageWorkflowPositionItem
]

CommonAbstraJsonV12DefinitionsJobStageSchedule = str


@dataclass
class CommonAbstraJsonV12DefinitionsJobStage:
    transitions: CommonAbstraJsonV12DefinitionsJobStageTransitions
    id: CommonAbstraJsonV12DefinitionsJobStageId
    title: CommonAbstraJsonV12DefinitionsJobStageTitle
    file: CommonAbstraJsonV12DefinitionsJobStageFile
    workflow_position: CommonAbstraJsonV12DefinitionsJobStageWorkflowPosition
    schedule: CommonAbstraJsonV12DefinitionsJobStageSchedule

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["schedule"] = self.schedule
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12DefinitionsJobStage":
        return cls(
            transitions=[
                CommonAbstraJsonV12DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            schedule=str(data["schedule"]),
        )


CommonAbstraJsonV12JobsItem = CommonAbstraJsonV12DefinitionsJobStage

CommonAbstraJsonV12Jobs = typing.List[CommonAbstraJsonV12JobsItem]

CommonAbstraJsonV12DefinitionsHookStageTransitionsItem = (
    CommonAbstraJsonV12DefinitionsTransition
)

CommonAbstraJsonV12DefinitionsHookStageTransitions = typing.List[
    CommonAbstraJsonV12DefinitionsHookStageTransitionsItem
]

CommonAbstraJsonV12DefinitionsHookStageId = str

CommonAbstraJsonV12DefinitionsHookStageTitle = str

CommonAbstraJsonV12DefinitionsHookStageFile = str

CommonAbstraJsonV12DefinitionsHookStageWorkflowPositionItem = float

CommonAbstraJsonV12DefinitionsHookStageWorkflowPosition = typing.List[
    CommonAbstraJsonV12DefinitionsHookStageWorkflowPositionItem
]

CommonAbstraJsonV12DefinitionsHookStageEnabled = bool

CommonAbstraJsonV12DefinitionsHookStagePath = str

CommonAbstraJsonV12DefinitionsHookStageIsInitial = bool


@dataclass
class CommonAbstraJsonV12DefinitionsHookStage:
    transitions: CommonAbstraJsonV12DefinitionsHookStageTransitions
    id: CommonAbstraJsonV12DefinitionsHookStageId
    title: CommonAbstraJsonV12DefinitionsHookStageTitle
    file: CommonAbstraJsonV12DefinitionsHookStageFile
    workflow_position: CommonAbstraJsonV12DefinitionsHookStageWorkflowPosition
    enabled: CommonAbstraJsonV12DefinitionsHookStageEnabled
    path: CommonAbstraJsonV12DefinitionsHookStagePath
    is_initial: CommonAbstraJsonV12DefinitionsHookStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["enabled"] = self.enabled
        data["path"] = self.path
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12DefinitionsHookStage":
        return cls(
            transitions=[
                CommonAbstraJsonV12DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            enabled=bool(data["enabled"]),
            path=str(data["path"]),
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV12HooksItem = CommonAbstraJsonV12DefinitionsHookStage

CommonAbstraJsonV12Hooks = typing.List[CommonAbstraJsonV12HooksItem]

CommonAbstraJsonV12DefinitionsFormStageTransitionsItem = (
    CommonAbstraJsonV12DefinitionsTransition
)

CommonAbstraJsonV12DefinitionsFormStageTransitions = typing.List[
    CommonAbstraJsonV12DefinitionsFormStageTransitionsItem
]

CommonAbstraJsonV12DefinitionsFormStageId = str

CommonAbstraJsonV12DefinitionsFormStageTitle = str

CommonAbstraJsonV12DefinitionsFormStageFile = str

CommonAbstraJsonV12DefinitionsFormStageWorkflowPositionItem = float

CommonAbstraJsonV12DefinitionsFormStageWorkflowPosition = typing.List[
    CommonAbstraJsonV12DefinitionsFormStageWorkflowPositionItem
]

CommonAbstraJsonV12DefinitionsFormStageStartMessageString = str

CommonAbstraJsonV12DefinitionsFormStageStartMessageNull = type(None)

CommonAbstraJsonV12DefinitionsFormStageStartMessage = typing.Union[
    CommonAbstraJsonV12DefinitionsFormStageStartMessageString,
    CommonAbstraJsonV12DefinitionsFormStageStartMessageNull,
]

CommonAbstraJsonV12DefinitionsFormStageAccessControlIsPublic = bool

CommonAbstraJsonV12DefinitionsFormStageAccessControlRequiredRolesItem = str

CommonAbstraJsonV12DefinitionsFormStageAccessControlRequiredRoles = typing.List[
    CommonAbstraJsonV12DefinitionsFormStageAccessControlRequiredRolesItem
]


@dataclass
class CommonAbstraJsonV12DefinitionsFormStageAccessControl:
    is_public: CommonAbstraJsonV12DefinitionsFormStageAccessControlIsPublic
    required_roles: CommonAbstraJsonV12DefinitionsFormStageAccessControlRequiredRoles

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["is_public"] = self.is_public
        data["required_roles"] = self.required_roles
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12DefinitionsFormStageAccessControl":
        return cls(
            is_public=bool(data["is_public"]),
            required_roles=[str(item) for item in data["required_roles"]],
        )


CommonAbstraJsonV12DefinitionsFormStagePath = str

CommonAbstraJsonV12DefinitionsFormStageTimeoutMessageString = str

CommonAbstraJsonV12DefinitionsFormStageTimeoutMessageNull = type(None)

CommonAbstraJsonV12DefinitionsFormStageTimeoutMessage = typing.Union[
    CommonAbstraJsonV12DefinitionsFormStageTimeoutMessageString,
    CommonAbstraJsonV12DefinitionsFormStageTimeoutMessageNull,
]

CommonAbstraJsonV12DefinitionsFormStageStartButtonTextString = str

CommonAbstraJsonV12DefinitionsFormStageStartButtonTextNull = type(None)

CommonAbstraJsonV12DefinitionsFormStageStartButtonText = typing.Union[
    CommonAbstraJsonV12DefinitionsFormStageStartButtonTextString,
    CommonAbstraJsonV12DefinitionsFormStageStartButtonTextNull,
]

CommonAbstraJsonV12DefinitionsFormStageWelcomeTitleString = str

CommonAbstraJsonV12DefinitionsFormStageWelcomeTitleNull = type(None)

CommonAbstraJsonV12DefinitionsFormStageWelcomeTitle = typing.Union[
    CommonAbstraJsonV12DefinitionsFormStageWelcomeTitleString,
    CommonAbstraJsonV12DefinitionsFormStageWelcomeTitleNull,
]

CommonAbstraJsonV12DefinitionsFormStageRestartButtonTextString = str

CommonAbstraJsonV12DefinitionsFormStageRestartButtonTextNull = type(None)

CommonAbstraJsonV12DefinitionsFormStageRestartButtonText = typing.Union[
    CommonAbstraJsonV12DefinitionsFormStageRestartButtonTextString,
    CommonAbstraJsonV12DefinitionsFormStageRestartButtonTextNull,
]

CommonAbstraJsonV12DefinitionsFormStageNotificationTriggerVariableName = str

CommonAbstraJsonV12DefinitionsFormStageNotificationTriggerEnabled = bool


@dataclass
class CommonAbstraJsonV12DefinitionsFormStageNotificationTrigger:
    variable_name: (
        CommonAbstraJsonV12DefinitionsFormStageNotificationTriggerVariableName
    )
    enabled: CommonAbstraJsonV12DefinitionsFormStageNotificationTriggerEnabled

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["variable_name"] = self.variable_name
        data["enabled"] = self.enabled
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12DefinitionsFormStageNotificationTrigger":
        return cls(
            variable_name=str(data["variable_name"]),
            enabled=bool(data["enabled"]),
        )


CommonAbstraJsonV12DefinitionsFormStageEndMessageString = str

CommonAbstraJsonV12DefinitionsFormStageEndMessageNull = type(None)

CommonAbstraJsonV12DefinitionsFormStageEndMessage = typing.Union[
    CommonAbstraJsonV12DefinitionsFormStageEndMessageString,
    CommonAbstraJsonV12DefinitionsFormStageEndMessageNull,
]

CommonAbstraJsonV12DefinitionsFormStageAutoStart = bool

CommonAbstraJsonV12DefinitionsFormStageIsInitial = bool

CommonAbstraJsonV12DefinitionsFormStageErrorMessageString = str

CommonAbstraJsonV12DefinitionsFormStageErrorMessageNull = type(None)

CommonAbstraJsonV12DefinitionsFormStageErrorMessage = typing.Union[
    CommonAbstraJsonV12DefinitionsFormStageErrorMessageString,
    CommonAbstraJsonV12DefinitionsFormStageErrorMessageNull,
]

CommonAbstraJsonV12DefinitionsFormStageAllowRestart = bool


@dataclass
class CommonAbstraJsonV12DefinitionsFormStage:
    transitions: CommonAbstraJsonV12DefinitionsFormStageTransitions
    id: CommonAbstraJsonV12DefinitionsFormStageId
    title: CommonAbstraJsonV12DefinitionsFormStageTitle
    file: CommonAbstraJsonV12DefinitionsFormStageFile
    workflow_position: CommonAbstraJsonV12DefinitionsFormStageWorkflowPosition
    start_message: CommonAbstraJsonV12DefinitionsFormStageStartMessage
    access_control: CommonAbstraJsonV12DefinitionsFormStageAccessControl
    path: CommonAbstraJsonV12DefinitionsFormStagePath
    timeout_message: CommonAbstraJsonV12DefinitionsFormStageTimeoutMessage
    start_button_text: CommonAbstraJsonV12DefinitionsFormStageStartButtonText
    welcome_title: CommonAbstraJsonV12DefinitionsFormStageWelcomeTitle
    restart_button_text: CommonAbstraJsonV12DefinitionsFormStageRestartButtonText
    notification_trigger: CommonAbstraJsonV12DefinitionsFormStageNotificationTrigger
    end_message: CommonAbstraJsonV12DefinitionsFormStageEndMessage
    auto_start: CommonAbstraJsonV12DefinitionsFormStageAutoStart
    is_initial: CommonAbstraJsonV12DefinitionsFormStageIsInitial
    error_message: CommonAbstraJsonV12DefinitionsFormStageErrorMessage
    allow_restart: CommonAbstraJsonV12DefinitionsFormStageAllowRestart

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["start_message"] = (
            self.start_message
            if isinstance(self.start_message, str)
            else self.start_message
        )
        data["access_control"] = self.access_control.to_dict()
        data["path"] = self.path
        data["timeout_message"] = (
            self.timeout_message
            if isinstance(self.timeout_message, str)
            else self.timeout_message
        )
        data["start_button_text"] = (
            self.start_button_text
            if isinstance(self.start_button_text, str)
            else self.start_button_text
        )
        data["welcome_title"] = (
            self.welcome_title
            if isinstance(self.welcome_title, str)
            else self.welcome_title
        )
        data["restart_button_text"] = (
            self.restart_button_text
            if isinstance(self.restart_button_text, str)
            else self.restart_button_text
        )
        data["notification_trigger"] = self.notification_trigger.to_dict()
        data["end_message"] = (
            self.end_message if isinstance(self.end_message, str) else self.end_message
        )
        data["auto_start"] = self.auto_start
        data["is_initial"] = self.is_initial
        data["error_message"] = (
            self.error_message
            if isinstance(self.error_message, str)
            else self.error_message
        )
        data["allow_restart"] = self.allow_restart
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12DefinitionsFormStage":
        return cls(
            transitions=[
                CommonAbstraJsonV12DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            start_message=(
                str(data["start_message"])
                if isinstance(data["start_message"], str)
                else None
            ),
            access_control=CommonAbstraJsonV12DefinitionsFormStageAccessControl.from_dict(
                data["access_control"]
            ),
            path=str(data["path"]),
            timeout_message=(
                str(data["timeout_message"])
                if isinstance(data["timeout_message"], str)
                else None
            ),
            start_button_text=(
                str(data["start_button_text"])
                if isinstance(data["start_button_text"], str)
                else None
            ),
            welcome_title=(
                str(data["welcome_title"])
                if isinstance(data["welcome_title"], str)
                else None
            ),
            restart_button_text=(
                str(data["restart_button_text"])
                if isinstance(data["restart_button_text"], str)
                else None
            ),
            notification_trigger=CommonAbstraJsonV12DefinitionsFormStageNotificationTrigger.from_dict(
                data["notification_trigger"]
            ),
            end_message=(
                str(data["end_message"])
                if isinstance(data["end_message"], str)
                else None
            ),
            auto_start=bool(data["auto_start"]),
            is_initial=bool(data["is_initial"]),
            error_message=(
                str(data["error_message"])
                if isinstance(data["error_message"], str)
                else None
            ),
            allow_restart=bool(data["allow_restart"]),
        )


CommonAbstraJsonV12FormsItem = CommonAbstraJsonV12DefinitionsFormStage

CommonAbstraJsonV12Forms = typing.List[CommonAbstraJsonV12FormsItem]

CommonAbstraJsonV12DefinitionsScriptStageTransitionsItem = (
    CommonAbstraJsonV12DefinitionsTransition
)

CommonAbstraJsonV12DefinitionsScriptStageTransitions = typing.List[
    CommonAbstraJsonV12DefinitionsScriptStageTransitionsItem
]

CommonAbstraJsonV12DefinitionsScriptStageId = str

CommonAbstraJsonV12DefinitionsScriptStageTitle = str

CommonAbstraJsonV12DefinitionsScriptStageFile = str

CommonAbstraJsonV12DefinitionsScriptStageWorkflowPositionItem = float

CommonAbstraJsonV12DefinitionsScriptStageWorkflowPosition = typing.List[
    CommonAbstraJsonV12DefinitionsScriptStageWorkflowPositionItem
]

CommonAbstraJsonV12DefinitionsScriptStageIsInitial = bool


@dataclass
class CommonAbstraJsonV12DefinitionsScriptStage:
    transitions: CommonAbstraJsonV12DefinitionsScriptStageTransitions
    id: CommonAbstraJsonV12DefinitionsScriptStageId
    title: CommonAbstraJsonV12DefinitionsScriptStageTitle
    file: CommonAbstraJsonV12DefinitionsScriptStageFile
    workflow_position: CommonAbstraJsonV12DefinitionsScriptStageWorkflowPosition
    is_initial: CommonAbstraJsonV12DefinitionsScriptStageIsInitial

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["transitions"] = [item.to_dict() for item in self.transitions]
        data["id"] = self.id
        data["title"] = self.title
        data["file"] = self.file
        data["workflow_position"] = self.workflow_position
        data["is_initial"] = self.is_initial
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAbstraJsonV12DefinitionsScriptStage":
        return cls(
            transitions=[
                CommonAbstraJsonV12DefinitionsTransition.from_dict(item)
                for item in data["transitions"]
            ],
            id=str(data["id"]),
            title=str(data["title"]),
            file=str(data["file"]),
            workflow_position=[float(item) for item in data["workflow_position"]],
            is_initial=bool(data["is_initial"]),
        )


CommonAbstraJsonV12ScriptsItem = CommonAbstraJsonV12DefinitionsScriptStage

CommonAbstraJsonV12Scripts = typing.List[CommonAbstraJsonV12ScriptsItem]

CommonAbstraJsonV12Version = typing.Literal["12.0"]

CommonAbstraJsonV12VersionValues: typing.List[CommonAbstraJsonV12Version] = ["12.0"]


@dataclass
class CommonAbstraJsonV12:
    workspace: CommonAbstraJsonV12Workspace
    home: CommonAbstraJsonV12Home
    jobs: CommonAbstraJsonV12Jobs
    hooks: CommonAbstraJsonV12Hooks
    forms: CommonAbstraJsonV12Forms
    scripts: CommonAbstraJsonV12Scripts
    version: CommonAbstraJsonV12Version

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["workspace"] = self.workspace.to_dict()
        data["home"] = self.home.to_dict()
        data["jobs"] = [item.to_dict() for item in self.jobs]
        data["hooks"] = [item.to_dict() for item in self.hooks]
        data["forms"] = [item.to_dict() for item in self.forms]
        data["scripts"] = [item.to_dict() for item in self.scripts]
        data["version"] = self.version
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "CommonAbstraJsonV12":
        return cls(
            workspace=CommonAbstraJsonV12Workspace.from_dict(data["workspace"]),
            home=CommonAbstraJsonV12Home.from_dict(data["home"]),
            jobs=[
                CommonAbstraJsonV12DefinitionsJobStage.from_dict(item)
                for item in data["jobs"]
            ],
            hooks=[
                CommonAbstraJsonV12DefinitionsHookStage.from_dict(item)
                for item in data["hooks"]
            ],
            forms=[
                CommonAbstraJsonV12DefinitionsFormStage.from_dict(item)
                for item in data["forms"]
            ],
            scripts=[
                CommonAbstraJsonV12DefinitionsScriptStage.from_dict(item)
                for item in data["scripts"]
            ],
            version=data["version"],
        )


CommonAiActionsV1StageReplaceCodeAction = typing.Literal["replace-code"]

CommonAiActionsV1StageReplaceCodeActionValues: typing.List[
    CommonAiActionsV1StageReplaceCodeAction
] = ["replace-code"]

CommonAiActionsV1StageReplaceCodeActionLabel = str

CommonAiActionsV1StageReplaceCodeNewCode = str

CommonAiActionsV1StageReplaceCodeType = typing.Literal["replace-code"]

CommonAiActionsV1StageReplaceCodeTypeValues: typing.List[
    CommonAiActionsV1StageReplaceCodeType
] = ["replace-code"]


@dataclass
class CommonAiActionsV1StageReplaceCode:
    action: CommonAiActionsV1StageReplaceCodeAction
    action_label: CommonAiActionsV1StageReplaceCodeActionLabel
    new_code: CommonAiActionsV1StageReplaceCodeNewCode
    type: typing.Optional[CommonAiActionsV1StageReplaceCodeType] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["newCode"] = self.new_code
        if self.type is not None:
            data["type"] = self.type
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1StageReplaceCode":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            new_code=str(data["newCode"]),
            type=None if data.get("type") is None else data["type"],
        )


CommonAiActionsV1StageActionsActionsItem0 = CommonAiActionsV1StageReplaceCode

CommonAiActionsV1StageEditStageNameAction = typing.Literal["edit-stage-name"]

CommonAiActionsV1StageEditStageNameActionValues: typing.List[
    CommonAiActionsV1StageEditStageNameAction
] = ["edit-stage-name"]

CommonAiActionsV1StageEditStageNameActionLabel = str

CommonAiActionsV1StageEditStageNameNewName = str

CommonAiActionsV1StageEditStageNameType = typing.Literal["edit-stage-name"]

CommonAiActionsV1StageEditStageNameTypeValues: typing.List[
    CommonAiActionsV1StageEditStageNameType
] = ["edit-stage-name"]


@dataclass
class CommonAiActionsV1StageEditStageName:
    action: CommonAiActionsV1StageEditStageNameAction
    action_label: CommonAiActionsV1StageEditStageNameActionLabel
    new_name: CommonAiActionsV1StageEditStageNameNewName
    type: typing.Optional[CommonAiActionsV1StageEditStageNameType] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["newName"] = self.new_name
        if self.type is not None:
            data["type"] = self.type
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1StageEditStageName":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            new_name=str(data["newName"]),
            type=None if data.get("type") is None else data["type"],
        )


CommonAiActionsV1StageActionsActionsItem1 = CommonAiActionsV1StageEditStageName

CommonAiActionsV1StageAddNotifiableEmailAction = typing.Literal["add-notifiable-email"]

CommonAiActionsV1StageAddNotifiableEmailActionValues: typing.List[
    CommonAiActionsV1StageAddNotifiableEmailAction
] = ["add-notifiable-email"]

CommonAiActionsV1StageAddNotifiableEmailActionLabel = str

CommonAiActionsV1StageAddNotifiableEmailEmail = str


@dataclass
class CommonAiActionsV1StageAddNotifiableEmail:
    action: CommonAiActionsV1StageAddNotifiableEmailAction
    action_label: CommonAiActionsV1StageAddNotifiableEmailActionLabel
    email: CommonAiActionsV1StageAddNotifiableEmailEmail

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["email"] = self.email
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1StageAddNotifiableEmail":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            email=str(data["email"]),
        )


CommonAiActionsV1StageActionsActionsItem2 = CommonAiActionsV1StageAddNotifiableEmail

CommonAiActionsV1StageEditStageFilenameAction = typing.Literal["edit-stage-filename"]

CommonAiActionsV1StageEditStageFilenameActionValues: typing.List[
    CommonAiActionsV1StageEditStageFilenameAction
] = ["edit-stage-filename"]

CommonAiActionsV1StageEditStageFilenameActionLabel = str

CommonAiActionsV1StageEditStageFilenameNewFilename = str

CommonAiActionsV1StageEditStageFilenameType = typing.Literal["edit-stage-filename"]

CommonAiActionsV1StageEditStageFilenameTypeValues: typing.List[
    CommonAiActionsV1StageEditStageFilenameType
] = ["edit-stage-filename"]


@dataclass
class CommonAiActionsV1StageEditStageFilename:
    action: CommonAiActionsV1StageEditStageFilenameAction
    action_label: CommonAiActionsV1StageEditStageFilenameActionLabel
    new_filename: CommonAiActionsV1StageEditStageFilenameNewFilename
    type: typing.Optional[CommonAiActionsV1StageEditStageFilenameType] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["newFilename"] = self.new_filename
        if self.type is not None:
            data["type"] = self.type
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1StageEditStageFilename":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            new_filename=str(data["newFilename"]),
            type=None if data.get("type") is None else data["type"],
        )


CommonAiActionsV1StageActionsActionsItem3 = CommonAiActionsV1StageEditStageFilename

CommonAiActionsV1StageActionsActionsItem = typing.Union[
    CommonAiActionsV1StageActionsActionsItem0,
    CommonAiActionsV1StageActionsActionsItem1,
    CommonAiActionsV1StageActionsActionsItem2,
    CommonAiActionsV1StageActionsActionsItem3,
]

CommonAiActionsV1StageActionsActions = typing.List[
    CommonAiActionsV1StageActionsActionsItem
]


@dataclass
class CommonAiActionsV1StageActions:
    actions: CommonAiActionsV1StageActionsActions

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["actions"] = [
            item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "replace-code")
            and (item.get("type", None) == "replace-code")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "edit-stage-name")
            and (item.get("type", None) == "edit-stage-name")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "add-notifiable-email")
            else item.to_dict()
            for item in self.actions
        ]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1StageActions":
        return cls(
            actions=[
                (
                    CommonAiActionsV1StageReplaceCode.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "replace-code")
                    and (item.get("type", None) == "replace-code")
                    else CommonAiActionsV1StageEditStageName.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "edit-stage-name")
                    and (item.get("type", None) == "edit-stage-name")
                    else CommonAiActionsV1StageAddNotifiableEmail.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "add-notifiable-email")
                    else CommonAiActionsV1StageEditStageFilename.from_dict(item)
                )
                for item in data["actions"]
            ],
        )


CommonAiActionsV1GeneralCreateTableAction = typing.Literal["create-table"]

CommonAiActionsV1GeneralCreateTableActionValues: typing.List[
    CommonAiActionsV1GeneralCreateTableAction
] = ["create-table"]

CommonAiActionsV1GeneralCreateTableActionLabel = str

CommonAiActionsV1GeneralCreateTableTableId = str

CommonAiActionsV1GeneralCreateTableTableName = str


@dataclass
class CommonAiActionsV1GeneralCreateTable:
    action: CommonAiActionsV1GeneralCreateTableAction
    action_label: CommonAiActionsV1GeneralCreateTableActionLabel
    table_id: CommonAiActionsV1GeneralCreateTableTableId
    table_name: CommonAiActionsV1GeneralCreateTableTableName

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["tableId"] = self.table_id
        data["tableName"] = self.table_name
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralCreateTable":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            table_id=str(data["tableId"]),
            table_name=str(data["tableName"]),
        )


CommonAiActionsV1GeneralActionsActionsItem0 = CommonAiActionsV1GeneralCreateTable

CommonAiActionsV1GeneralCreateColumnAction = typing.Literal["create-column"]

CommonAiActionsV1GeneralCreateColumnActionValues: typing.List[
    CommonAiActionsV1GeneralCreateColumnAction
] = ["create-column"]

CommonAiActionsV1GeneralCreateColumnActionLabel = str

CommonAiActionsV1GeneralCreateColumnTableId = str

CommonAiActionsV1GeneralCreateColumnColumnName = str

CommonAiActionsV1GeneralCreateColumnColumnType = typing.Union[
    typing.Literal["varchar"],
    typing.Literal["int"],
    typing.Literal["boolean"],
    typing.Literal["json"],
    typing.Literal["date"],
    typing.Literal["timestamp"],
    typing.Literal["uuid"],
    typing.Literal["real"],
]

CommonAiActionsV1GeneralCreateColumnColumnTypeValues: typing.List[
    CommonAiActionsV1GeneralCreateColumnColumnType
] = ["varchar", "int", "boolean", "json", "date", "timestamp", "uuid", "real"]

CommonAiActionsV1GeneralCreateColumnNullable = bool

CommonAiActionsV1GeneralCreateColumnDefault = str

CommonAiActionsV1GeneralCreateColumnUnique = bool


@dataclass
class CommonAiActionsV1GeneralCreateColumn:
    action: CommonAiActionsV1GeneralCreateColumnAction
    action_label: CommonAiActionsV1GeneralCreateColumnActionLabel
    table_id: CommonAiActionsV1GeneralCreateColumnTableId
    column_name: CommonAiActionsV1GeneralCreateColumnColumnName
    column_type: CommonAiActionsV1GeneralCreateColumnColumnType
    nullable: CommonAiActionsV1GeneralCreateColumnNullable
    default: CommonAiActionsV1GeneralCreateColumnDefault
    unique: CommonAiActionsV1GeneralCreateColumnUnique

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["tableId"] = self.table_id
        data["columnName"] = self.column_name
        data["columnType"] = self.column_type
        data["nullable"] = self.nullable
        data["default"] = self.default
        data["unique"] = self.unique
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralCreateColumn":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            table_id=str(data["tableId"]),
            column_name=str(data["columnName"]),
            column_type=data["columnType"],
            nullable=bool(data["nullable"]),
            default=str(data["default"]),
            unique=bool(data["unique"]),
        )


CommonAiActionsV1GeneralActionsActionsItem1 = CommonAiActionsV1GeneralCreateColumn

CommonAiActionsV1GeneralInsertRowsAction = typing.Literal["insert-rows"]

CommonAiActionsV1GeneralInsertRowsActionValues: typing.List[
    CommonAiActionsV1GeneralInsertRowsAction
] = ["insert-rows"]

CommonAiActionsV1GeneralInsertRowsActionLabel = str

CommonAiActionsV1GeneralInsertRowsTableId = str

CommonAiActionsV1GeneralInsertRowsRowsItem = typing.Dict[str, typing.Any]

CommonAiActionsV1GeneralInsertRowsRows = typing.List[
    CommonAiActionsV1GeneralInsertRowsRowsItem
]


@dataclass
class CommonAiActionsV1GeneralInsertRows:
    action: CommonAiActionsV1GeneralInsertRowsAction
    action_label: CommonAiActionsV1GeneralInsertRowsActionLabel
    table_id: CommonAiActionsV1GeneralInsertRowsTableId
    rows: CommonAiActionsV1GeneralInsertRowsRows

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["tableId"] = self.table_id
        data["rows"] = [item for item in self.rows]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralInsertRows":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            table_id=str(data["tableId"]),
            rows=[dict(**item) for item in data["rows"]],
        )


CommonAiActionsV1GeneralActionsActionsItem2 = CommonAiActionsV1GeneralInsertRows

CommonAiActionsV1GeneralEditTableAction = typing.Literal["edit-table"]

CommonAiActionsV1GeneralEditTableActionValues: typing.List[
    CommonAiActionsV1GeneralEditTableAction
] = ["edit-table"]

CommonAiActionsV1GeneralEditTableActionLabel = str

CommonAiActionsV1GeneralEditTableTableId = str

CommonAiActionsV1GeneralEditTableNewTableName = str


@dataclass
class CommonAiActionsV1GeneralEditTable:
    action: CommonAiActionsV1GeneralEditTableAction
    action_label: CommonAiActionsV1GeneralEditTableActionLabel
    table_id: CommonAiActionsV1GeneralEditTableTableId
    new_table_name: CommonAiActionsV1GeneralEditTableNewTableName

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["tableId"] = self.table_id
        data["newTableName"] = self.new_table_name
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralEditTable":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            table_id=str(data["tableId"]),
            new_table_name=str(data["newTableName"]),
        )


CommonAiActionsV1GeneralActionsActionsItem3 = CommonAiActionsV1GeneralEditTable

CommonAiActionsV1GeneralEditColumnAction = typing.Literal["edit-column"]

CommonAiActionsV1GeneralEditColumnActionValues: typing.List[
    CommonAiActionsV1GeneralEditColumnAction
] = ["edit-column"]

CommonAiActionsV1GeneralEditColumnActionLabel = str

CommonAiActionsV1GeneralEditColumnColumnId = str

CommonAiActionsV1GeneralEditColumnTableId = str

CommonAiActionsV1GeneralEditColumnChangesColumnName = str

CommonAiActionsV1GeneralEditColumnChangesColumnType = typing.Union[
    typing.Literal["varchar"],
    typing.Literal["int"],
    typing.Literal["boolean"],
    typing.Literal["json"],
    typing.Literal["date"],
    typing.Literal["timestamp"],
    typing.Literal["uuid"],
    typing.Literal["real"],
]

CommonAiActionsV1GeneralEditColumnChangesColumnTypeValues: typing.List[
    CommonAiActionsV1GeneralEditColumnChangesColumnType
] = ["varchar", "int", "boolean", "json", "date", "timestamp", "uuid", "real"]

CommonAiActionsV1GeneralEditColumnChangesNullable = bool

CommonAiActionsV1GeneralEditColumnChangesDefault = str

CommonAiActionsV1GeneralEditColumnChangesUnique = bool

CommonAiActionsV1GeneralEditColumnChangesForeignKeyColumnId = str


@dataclass
class CommonAiActionsV1GeneralEditColumnChangesForeignKey:
    column_id: CommonAiActionsV1GeneralEditColumnChangesForeignKeyColumnId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["columnId"] = self.column_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralEditColumnChangesForeignKey":
        return cls(
            column_id=str(data["columnId"]),
        )


@dataclass
class CommonAiActionsV1GeneralEditColumnChanges:
    column_name: typing.Optional[
        CommonAiActionsV1GeneralEditColumnChangesColumnName
    ] = field(default_factory=lambda: None)
    column_type: typing.Optional[
        CommonAiActionsV1GeneralEditColumnChangesColumnType
    ] = field(default_factory=lambda: None)
    nullable: typing.Optional[CommonAiActionsV1GeneralEditColumnChangesNullable] = (
        field(default_factory=lambda: None)
    )
    default: typing.Optional[CommonAiActionsV1GeneralEditColumnChangesDefault] = field(
        default_factory=lambda: None
    )
    unique: typing.Optional[CommonAiActionsV1GeneralEditColumnChangesUnique] = field(
        default_factory=lambda: None
    )
    foreign_key: typing.Optional[
        CommonAiActionsV1GeneralEditColumnChangesForeignKey
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.column_name is not None:
            data["columnName"] = self.column_name
        if self.column_type is not None:
            data["columnType"] = self.column_type
        if self.nullable is not None:
            data["nullable"] = self.nullable
        if self.default is not None:
            data["default"] = self.default
        if self.unique is not None:
            data["unique"] = self.unique
        if self.foreign_key is not None:
            data["foreignKey"] = self.foreign_key.to_dict()
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralEditColumnChanges":
        return cls(
            column_name=None
            if data.get("columnName") is None
            else str(data["columnName"]),
            column_type=None if data.get("columnType") is None else data["columnType"],
            nullable=None if data.get("nullable") is None else bool(data["nullable"]),
            default=None if data.get("default") is None else str(data["default"]),
            unique=None if data.get("unique") is None else bool(data["unique"]),
            foreign_key=None
            if data.get("foreignKey") is None
            else CommonAiActionsV1GeneralEditColumnChangesForeignKey.from_dict(
                data["foreignKey"]
            ),
        )


@dataclass
class CommonAiActionsV1GeneralEditColumn:
    action: CommonAiActionsV1GeneralEditColumnAction
    action_label: CommonAiActionsV1GeneralEditColumnActionLabel
    column_id: CommonAiActionsV1GeneralEditColumnColumnId
    table_id: CommonAiActionsV1GeneralEditColumnTableId
    changes: CommonAiActionsV1GeneralEditColumnChanges

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["columnId"] = self.column_id
        data["tableId"] = self.table_id
        data["changes"] = self.changes.to_dict()
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralEditColumn":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            column_id=str(data["columnId"]),
            table_id=str(data["tableId"]),
            changes=CommonAiActionsV1GeneralEditColumnChanges.from_dict(
                data["changes"]
            ),
        )


CommonAiActionsV1GeneralActionsActionsItem4 = CommonAiActionsV1GeneralEditColumn

CommonAiActionsV1GeneralEditEnvVarAction = typing.Literal["edit-env-var"]

CommonAiActionsV1GeneralEditEnvVarActionValues: typing.List[
    CommonAiActionsV1GeneralEditEnvVarAction
] = ["edit-env-var"]

CommonAiActionsV1GeneralEditEnvVarActionLabel = str

CommonAiActionsV1GeneralEditEnvVarKey = str

CommonAiActionsV1GeneralEditEnvVarNewValue = str


@dataclass
class CommonAiActionsV1GeneralEditEnvVar:
    action: CommonAiActionsV1GeneralEditEnvVarAction
    action_label: CommonAiActionsV1GeneralEditEnvVarActionLabel
    key: CommonAiActionsV1GeneralEditEnvVarKey
    new_value: CommonAiActionsV1GeneralEditEnvVarNewValue

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["key"] = self.key
        data["newValue"] = self.new_value
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralEditEnvVar":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            key=str(data["key"]),
            new_value=str(data["newValue"]),
        )


CommonAiActionsV1GeneralActionsActionsItem5 = CommonAiActionsV1GeneralEditEnvVar

CommonAiActionsV1GeneralSetEnvVarAction = typing.Literal["set-env-var"]

CommonAiActionsV1GeneralSetEnvVarActionValues: typing.List[
    CommonAiActionsV1GeneralSetEnvVarAction
] = ["set-env-var"]

CommonAiActionsV1GeneralSetEnvVarActionLabel = str

CommonAiActionsV1GeneralSetEnvVarKey = str

CommonAiActionsV1GeneralSetEnvVarValue = str


@dataclass
class CommonAiActionsV1GeneralSetEnvVar:
    action: CommonAiActionsV1GeneralSetEnvVarAction
    action_label: CommonAiActionsV1GeneralSetEnvVarActionLabel
    key: CommonAiActionsV1GeneralSetEnvVarKey
    value: CommonAiActionsV1GeneralSetEnvVarValue

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["key"] = self.key
        data["value"] = self.value
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralSetEnvVar":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            key=str(data["key"]),
            value=str(data["value"]),
        )


CommonAiActionsV1GeneralActionsActionsItem6 = CommonAiActionsV1GeneralSetEnvVar

CommonAiActionsV1GeneralInstallPackageAction = typing.Literal["install-package"]

CommonAiActionsV1GeneralInstallPackageActionValues: typing.List[
    CommonAiActionsV1GeneralInstallPackageAction
] = ["install-package"]

CommonAiActionsV1GeneralInstallPackageActionLabel = str

CommonAiActionsV1GeneralInstallPackagePackageName = str


@dataclass
class CommonAiActionsV1GeneralInstallPackage:
    action: CommonAiActionsV1GeneralInstallPackageAction
    action_label: CommonAiActionsV1GeneralInstallPackageActionLabel
    package_name: CommonAiActionsV1GeneralInstallPackagePackageName

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["packageName"] = self.package_name
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralInstallPackage":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            package_name=str(data["packageName"]),
        )


CommonAiActionsV1GeneralActionsActionsItem7 = CommonAiActionsV1GeneralInstallPackage

CommonAiActionsV1GeneralCreateStageAction = typing.Literal["create-stage"]

CommonAiActionsV1GeneralCreateStageActionValues: typing.List[
    CommonAiActionsV1GeneralCreateStageAction
] = ["create-stage"]

CommonAiActionsV1GeneralCreateStageActionLabel = str

CommonAiActionsV1GeneralCreateStageId = str

CommonAiActionsV1GeneralCreateStageStageType = typing.Union[
    typing.Literal["form"],
    typing.Literal["job"],
    typing.Literal["hook"],
    typing.Literal["tasklet"],
]

CommonAiActionsV1GeneralCreateStageStageTypeValues: typing.List[
    CommonAiActionsV1GeneralCreateStageStageType
] = ["form", "job", "hook", "tasklet"]

CommonAiActionsV1GeneralCreateStageStageName = str

CommonAiActionsV1GeneralCreateStageCode = str

CommonAiActionsV1GeneralCreateStageFilename = str

CommonAiActionsV1GeneralCreateStagePositionX = float

CommonAiActionsV1GeneralCreateStagePositionY = float


@dataclass
class CommonAiActionsV1GeneralCreateStagePosition:
    x: CommonAiActionsV1GeneralCreateStagePositionX
    y: CommonAiActionsV1GeneralCreateStagePositionY

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["x"] = self.x
        data["y"] = self.y
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralCreateStagePosition":
        return cls(
            x=float(data["x"]),
            y=float(data["y"]),
        )


CommonAiActionsV1GeneralCreateStageType = typing.Literal["create-stage"]

CommonAiActionsV1GeneralCreateStageTypeValues: typing.List[
    CommonAiActionsV1GeneralCreateStageType
] = ["create-stage"]


@dataclass
class CommonAiActionsV1GeneralCreateStage:
    action: CommonAiActionsV1GeneralCreateStageAction
    action_label: CommonAiActionsV1GeneralCreateStageActionLabel
    id: CommonAiActionsV1GeneralCreateStageId
    stage_type: CommonAiActionsV1GeneralCreateStageStageType
    stage_name: CommonAiActionsV1GeneralCreateStageStageName
    code: CommonAiActionsV1GeneralCreateStageCode
    filename: CommonAiActionsV1GeneralCreateStageFilename
    position: CommonAiActionsV1GeneralCreateStagePosition
    type: typing.Optional[CommonAiActionsV1GeneralCreateStageType] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["id"] = self.id
        data["stageType"] = self.stage_type
        data["stageName"] = self.stage_name
        data["code"] = self.code
        data["filename"] = self.filename
        data["position"] = self.position.to_dict()
        if self.type is not None:
            data["type"] = self.type
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralCreateStage":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            id=str(data["id"]),
            stage_type=data["stageType"],
            stage_name=str(data["stageName"]),
            code=str(data["code"]),
            filename=str(data["filename"]),
            position=CommonAiActionsV1GeneralCreateStagePosition.from_dict(
                data["position"]
            ),
            type=None if data.get("type") is None else data["type"],
        )


CommonAiActionsV1GeneralActionsActionsItem8 = CommonAiActionsV1GeneralCreateStage

CommonAiActionsV1GeneralCreateTransitionAction = typing.Literal["add-transition"]

CommonAiActionsV1GeneralCreateTransitionActionValues: typing.List[
    CommonAiActionsV1GeneralCreateTransitionAction
] = ["add-transition"]

CommonAiActionsV1GeneralCreateTransitionActionLabel = str

CommonAiActionsV1GeneralCreateTransitionSourceStageId = str

CommonAiActionsV1GeneralCreateTransitionTargetStageId = str


@dataclass
class CommonAiActionsV1GeneralCreateTransition:
    action: CommonAiActionsV1GeneralCreateTransitionAction
    action_label: CommonAiActionsV1GeneralCreateTransitionActionLabel
    source_stage_id: CommonAiActionsV1GeneralCreateTransitionSourceStageId
    target_stage_id: CommonAiActionsV1GeneralCreateTransitionTargetStageId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["sourceStageId"] = self.source_stage_id
        data["targetStageId"] = self.target_stage_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralCreateTransition":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            source_stage_id=str(data["sourceStageId"]),
            target_stage_id=str(data["targetStageId"]),
        )


CommonAiActionsV1GeneralActionsActionsItem9 = CommonAiActionsV1GeneralCreateTransition

CommonAiActionsV1GeneralEditStageAction = typing.Literal["edit-stage"]

CommonAiActionsV1GeneralEditStageActionValues: typing.List[
    CommonAiActionsV1GeneralEditStageAction
] = ["edit-stage"]

CommonAiActionsV1GeneralEditStageActionLabel = str

CommonAiActionsV1GeneralEditStageStageId = str

CommonAiActionsV1GeneralEditStageStageType = typing.Union[
    typing.Literal["form"],
    typing.Literal["job"],
    typing.Literal["hook"],
    typing.Literal["tasklet"],
]

CommonAiActionsV1GeneralEditStageStageTypeValues: typing.List[
    CommonAiActionsV1GeneralEditStageStageType
] = ["form", "job", "hook", "tasklet"]

CommonAiActionsV1GeneralEditStageStageNewTitle = str


@dataclass
class CommonAiActionsV1GeneralEditStage:
    action: CommonAiActionsV1GeneralEditStageAction
    action_label: CommonAiActionsV1GeneralEditStageActionLabel
    stage_id: CommonAiActionsV1GeneralEditStageStageId
    stage_type: CommonAiActionsV1GeneralEditStageStageType
    stage_new_title: CommonAiActionsV1GeneralEditStageStageNewTitle

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["stageId"] = self.stage_id
        data["stageType"] = self.stage_type
        data["stageNewTitle"] = self.stage_new_title
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralEditStage":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            stage_id=str(data["stageId"]),
            stage_type=data["stageType"],
            stage_new_title=str(data["stageNewTitle"]),
        )


CommonAiActionsV1GeneralActionsActionsItem10 = CommonAiActionsV1GeneralEditStage

CommonAiActionsV1GeneralActionsActionsItem = typing.Union[
    CommonAiActionsV1GeneralActionsActionsItem0,
    CommonAiActionsV1GeneralActionsActionsItem1,
    CommonAiActionsV1GeneralActionsActionsItem2,
    CommonAiActionsV1GeneralActionsActionsItem3,
    CommonAiActionsV1GeneralActionsActionsItem4,
    CommonAiActionsV1GeneralActionsActionsItem5,
    CommonAiActionsV1GeneralActionsActionsItem6,
    CommonAiActionsV1GeneralActionsActionsItem7,
    CommonAiActionsV1GeneralActionsActionsItem8,
    CommonAiActionsV1GeneralActionsActionsItem9,
    CommonAiActionsV1GeneralActionsActionsItem10,
]

CommonAiActionsV1GeneralActionsActions = typing.List[
    CommonAiActionsV1GeneralActionsActionsItem
]


@dataclass
class CommonAiActionsV1GeneralActions:
    actions: CommonAiActionsV1GeneralActionsActions

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["actions"] = [
            item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "create-table")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "create-column")
            and (
                item.get("columnType", None) == "varchar"
                or item.get("columnType", None) == "int"
                or item.get("columnType", None) == "boolean"
                or item.get("columnType", None) == "json"
                or item.get("columnType", None) == "date"
                or item.get("columnType", None) == "timestamp"
                or item.get("columnType", None) == "uuid"
                or item.get("columnType", None) == "real"
            )
            else item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "insert-rows")
            else item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "edit-table")
            else item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "edit-column")
            else item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "edit-env-var")
            else item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "set-env-var")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "install-package")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "create-stage")
            and (
                item.get("stageType", None) == "form"
                or item.get("stageType", None) == "job"
                or item.get("stageType", None) == "hook"
                or item.get("stageType", None) == "tasklet"
            )
            and (item.get("type", None) == "create-stage")
            else item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "add-transition")
            else item.to_dict()
            for item in self.actions
        ]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV1GeneralActions":
        return cls(
            actions=[
                (
                    CommonAiActionsV1GeneralCreateTable.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "create-table")
                    else CommonAiActionsV1GeneralCreateColumn.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "create-column")
                    and (
                        item.get("columnType", None) == "varchar"
                        or item.get("columnType", None) == "int"
                        or item.get("columnType", None) == "boolean"
                        or item.get("columnType", None) == "json"
                        or item.get("columnType", None) == "date"
                        or item.get("columnType", None) == "timestamp"
                        or item.get("columnType", None) == "uuid"
                        or item.get("columnType", None) == "real"
                    )
                    else CommonAiActionsV1GeneralInsertRows.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "insert-rows")
                    else CommonAiActionsV1GeneralEditTable.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "edit-table")
                    else CommonAiActionsV1GeneralEditColumn.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "edit-column")
                    else CommonAiActionsV1GeneralEditEnvVar.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "edit-env-var")
                    else CommonAiActionsV1GeneralSetEnvVar.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "set-env-var")
                    else CommonAiActionsV1GeneralInstallPackage.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "install-package")
                    else CommonAiActionsV1GeneralCreateStage.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "create-stage")
                    and (
                        item.get("stageType", None) == "form"
                        or item.get("stageType", None) == "job"
                        or item.get("stageType", None) == "hook"
                        or item.get("stageType", None) == "tasklet"
                    )
                    and (item.get("type", None) == "create-stage")
                    else CommonAiActionsV1GeneralCreateTransition.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "add-transition")
                    else CommonAiActionsV1GeneralEditStage.from_dict(item)
                )
                for item in data["actions"]
            ],
        )


CommonAiActionsV0StageReplaceCodeAction = typing.Literal["replace-code"]

CommonAiActionsV0StageReplaceCodeActionValues: typing.List[
    CommonAiActionsV0StageReplaceCodeAction
] = ["replace-code"]

CommonAiActionsV0StageReplaceCodeActionLabel = str

CommonAiActionsV0StageReplaceCodeLinesStart = float

CommonAiActionsV0StageReplaceCodeLinesEnd = float


@dataclass
class CommonAiActionsV0StageReplaceCodeLines:
    start: CommonAiActionsV0StageReplaceCodeLinesStart
    end: CommonAiActionsV0StageReplaceCodeLinesEnd

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["start"] = self.start
        data["end"] = self.end
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0StageReplaceCodeLines":
        return cls(
            start=float(data["start"]),
            end=float(data["end"]),
        )


CommonAiActionsV0StageReplaceCodeNewCode = str


@dataclass
class CommonAiActionsV0StageReplaceCode:
    action: CommonAiActionsV0StageReplaceCodeAction
    action_label: CommonAiActionsV0StageReplaceCodeActionLabel
    lines: CommonAiActionsV0StageReplaceCodeLines
    new_code: CommonAiActionsV0StageReplaceCodeNewCode

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["lines"] = self.lines.to_dict()
        data["newCode"] = self.new_code
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0StageReplaceCode":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            lines=CommonAiActionsV0StageReplaceCodeLines.from_dict(data["lines"]),
            new_code=str(data["newCode"]),
        )


CommonAiActionsV0StageActionsActionsItem0 = CommonAiActionsV0StageReplaceCode

CommonAiActionsV0StageEditStageNameAction = typing.Literal["edit-stage-name"]

CommonAiActionsV0StageEditStageNameActionValues: typing.List[
    CommonAiActionsV0StageEditStageNameAction
] = ["edit-stage-name"]

CommonAiActionsV0StageEditStageNameActionLabel = str

CommonAiActionsV0StageEditStageNameNewName = str


@dataclass
class CommonAiActionsV0StageEditStageName:
    action: CommonAiActionsV0StageEditStageNameAction
    action_label: CommonAiActionsV0StageEditStageNameActionLabel
    new_name: CommonAiActionsV0StageEditStageNameNewName

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["newName"] = self.new_name
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0StageEditStageName":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            new_name=str(data["newName"]),
        )


CommonAiActionsV0StageActionsActionsItem1 = CommonAiActionsV0StageEditStageName

CommonAiActionsV0StageAddNotifiableEmailAction = typing.Literal["add-notifiable-email"]

CommonAiActionsV0StageAddNotifiableEmailActionValues: typing.List[
    CommonAiActionsV0StageAddNotifiableEmailAction
] = ["add-notifiable-email"]

CommonAiActionsV0StageAddNotifiableEmailActionLabel = str

CommonAiActionsV0StageAddNotifiableEmailEmail = str


@dataclass
class CommonAiActionsV0StageAddNotifiableEmail:
    action: CommonAiActionsV0StageAddNotifiableEmailAction
    action_label: CommonAiActionsV0StageAddNotifiableEmailActionLabel
    email: CommonAiActionsV0StageAddNotifiableEmailEmail

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["email"] = self.email
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0StageAddNotifiableEmail":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            email=str(data["email"]),
        )


CommonAiActionsV0StageActionsActionsItem2 = CommonAiActionsV0StageAddNotifiableEmail

CommonAiActionsV0StageActionsActionsItem = typing.Union[
    CommonAiActionsV0StageActionsActionsItem0,
    CommonAiActionsV0StageActionsActionsItem1,
    CommonAiActionsV0StageActionsActionsItem2,
]

CommonAiActionsV0StageActionsActions = typing.List[
    CommonAiActionsV0StageActionsActionsItem
]


@dataclass
class CommonAiActionsV0StageActions:
    actions: CommonAiActionsV0StageActionsActions

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["actions"] = [
            item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "replace-code")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "edit-stage-name")
            else item.to_dict()
            for item in self.actions
        ]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0StageActions":
        return cls(
            actions=[
                (
                    CommonAiActionsV0StageReplaceCode.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "replace-code")
                    else CommonAiActionsV0StageEditStageName.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "edit-stage-name")
                    else CommonAiActionsV0StageAddNotifiableEmail.from_dict(item)
                )
                for item in data["actions"]
            ],
        )


CommonAiActionsV0GeneralCreateTableAction = typing.Literal["create-table"]

CommonAiActionsV0GeneralCreateTableActionValues: typing.List[
    CommonAiActionsV0GeneralCreateTableAction
] = ["create-table"]

CommonAiActionsV0GeneralCreateTableActionLabel = str

CommonAiActionsV0GeneralCreateTableTableId = str

CommonAiActionsV0GeneralCreateTableTableName = str


@dataclass
class CommonAiActionsV0GeneralCreateTable:
    action: CommonAiActionsV0GeneralCreateTableAction
    action_label: CommonAiActionsV0GeneralCreateTableActionLabel
    table_id: CommonAiActionsV0GeneralCreateTableTableId
    table_name: CommonAiActionsV0GeneralCreateTableTableName

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["tableId"] = self.table_id
        data["tableName"] = self.table_name
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0GeneralCreateTable":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            table_id=str(data["tableId"]),
            table_name=str(data["tableName"]),
        )


CommonAiActionsV0GeneralActionsActionsItem0 = CommonAiActionsV0GeneralCreateTable

CommonAiActionsV0GeneralCreateColumnAction = typing.Literal["create-column"]

CommonAiActionsV0GeneralCreateColumnActionValues: typing.List[
    CommonAiActionsV0GeneralCreateColumnAction
] = ["create-column"]

CommonAiActionsV0GeneralCreateColumnActionLabel = str

CommonAiActionsV0GeneralCreateColumnTableId = str

CommonAiActionsV0GeneralCreateColumnColumnName = str

CommonAiActionsV0GeneralCreateColumnColumnType = typing.Union[
    typing.Literal["varchar"],
    typing.Literal["int"],
    typing.Literal["boolean"],
    typing.Literal["json"],
    typing.Literal["date"],
    typing.Literal["timestamp"],
    typing.Literal["uuid"],
    typing.Literal["real"],
]

CommonAiActionsV0GeneralCreateColumnColumnTypeValues: typing.List[
    CommonAiActionsV0GeneralCreateColumnColumnType
] = ["varchar", "int", "boolean", "json", "date", "timestamp", "uuid", "real"]


@dataclass
class CommonAiActionsV0GeneralCreateColumn:
    action: CommonAiActionsV0GeneralCreateColumnAction
    action_label: CommonAiActionsV0GeneralCreateColumnActionLabel
    table_id: CommonAiActionsV0GeneralCreateColumnTableId
    column_name: CommonAiActionsV0GeneralCreateColumnColumnName
    column_type: CommonAiActionsV0GeneralCreateColumnColumnType

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["tableId"] = self.table_id
        data["columnName"] = self.column_name
        data["columnType"] = self.column_type
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0GeneralCreateColumn":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            table_id=str(data["tableId"]),
            column_name=str(data["columnName"]),
            column_type=data["columnType"],
        )


CommonAiActionsV0GeneralActionsActionsItem1 = CommonAiActionsV0GeneralCreateColumn

CommonAiActionsV0GeneralSetEnvVarAction = typing.Literal["set-env-var"]

CommonAiActionsV0GeneralSetEnvVarActionValues: typing.List[
    CommonAiActionsV0GeneralSetEnvVarAction
] = ["set-env-var"]

CommonAiActionsV0GeneralSetEnvVarActionLabel = str

CommonAiActionsV0GeneralSetEnvVarKey = str

CommonAiActionsV0GeneralSetEnvVarValue = str


@dataclass
class CommonAiActionsV0GeneralSetEnvVar:
    action: CommonAiActionsV0GeneralSetEnvVarAction
    action_label: CommonAiActionsV0GeneralSetEnvVarActionLabel
    key: CommonAiActionsV0GeneralSetEnvVarKey
    value: CommonAiActionsV0GeneralSetEnvVarValue

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["key"] = self.key
        data["value"] = self.value
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0GeneralSetEnvVar":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            key=str(data["key"]),
            value=str(data["value"]),
        )


CommonAiActionsV0GeneralActionsActionsItem2 = CommonAiActionsV0GeneralSetEnvVar

CommonAiActionsV0GeneralCreateStageAction = typing.Literal["create-stage"]

CommonAiActionsV0GeneralCreateStageActionValues: typing.List[
    CommonAiActionsV0GeneralCreateStageAction
] = ["create-stage"]

CommonAiActionsV0GeneralCreateStageActionLabel = str

CommonAiActionsV0GeneralCreateStageId = str

CommonAiActionsV0GeneralCreateStageStageType = typing.Union[
    typing.Literal["form"],
    typing.Literal["job"],
    typing.Literal["hook"],
    typing.Literal["tasklet"],
]

CommonAiActionsV0GeneralCreateStageStageTypeValues: typing.List[
    CommonAiActionsV0GeneralCreateStageStageType
] = ["form", "job", "hook", "tasklet"]

CommonAiActionsV0GeneralCreateStageStageName = str

CommonAiActionsV0GeneralCreateStageCode = str

CommonAiActionsV0GeneralCreateStageFilename = str

CommonAiActionsV0GeneralCreateStagePositionX = float

CommonAiActionsV0GeneralCreateStagePositionY = float


@dataclass
class CommonAiActionsV0GeneralCreateStagePosition:
    x: CommonAiActionsV0GeneralCreateStagePositionX
    y: CommonAiActionsV0GeneralCreateStagePositionY

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["x"] = self.x
        data["y"] = self.y
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0GeneralCreateStagePosition":
        return cls(
            x=float(data["x"]),
            y=float(data["y"]),
        )


@dataclass
class CommonAiActionsV0GeneralCreateStage:
    action: CommonAiActionsV0GeneralCreateStageAction
    action_label: CommonAiActionsV0GeneralCreateStageActionLabel
    id: CommonAiActionsV0GeneralCreateStageId
    stage_type: CommonAiActionsV0GeneralCreateStageStageType
    stage_name: CommonAiActionsV0GeneralCreateStageStageName
    code: CommonAiActionsV0GeneralCreateStageCode
    filename: CommonAiActionsV0GeneralCreateStageFilename
    position: CommonAiActionsV0GeneralCreateStagePosition

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["id"] = self.id
        data["stageType"] = self.stage_type
        data["stageName"] = self.stage_name
        data["code"] = self.code
        data["filename"] = self.filename
        data["position"] = self.position.to_dict()
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0GeneralCreateStage":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            id=str(data["id"]),
            stage_type=data["stageType"],
            stage_name=str(data["stageName"]),
            code=str(data["code"]),
            filename=str(data["filename"]),
            position=CommonAiActionsV0GeneralCreateStagePosition.from_dict(
                data["position"]
            ),
        )


CommonAiActionsV0GeneralActionsActionsItem3 = CommonAiActionsV0GeneralCreateStage

CommonAiActionsV0GeneralCreateTransitionAction = typing.Literal["add-transition"]

CommonAiActionsV0GeneralCreateTransitionActionValues: typing.List[
    CommonAiActionsV0GeneralCreateTransitionAction
] = ["add-transition"]

CommonAiActionsV0GeneralCreateTransitionActionLabel = str

CommonAiActionsV0GeneralCreateTransitionSourceStageId = str

CommonAiActionsV0GeneralCreateTransitionTargetStageId = str


@dataclass
class CommonAiActionsV0GeneralCreateTransition:
    action: CommonAiActionsV0GeneralCreateTransitionAction
    action_label: CommonAiActionsV0GeneralCreateTransitionActionLabel
    source_stage_id: CommonAiActionsV0GeneralCreateTransitionSourceStageId
    target_stage_id: CommonAiActionsV0GeneralCreateTransitionTargetStageId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["action"] = self.action
        data["actionLabel"] = self.action_label
        data["sourceStageId"] = self.source_stage_id
        data["targetStageId"] = self.target_stage_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0GeneralCreateTransition":
        return cls(
            action=data["action"],
            action_label=str(data["actionLabel"]),
            source_stage_id=str(data["sourceStageId"]),
            target_stage_id=str(data["targetStageId"]),
        )


CommonAiActionsV0GeneralActionsActionsItem4 = CommonAiActionsV0GeneralCreateTransition

CommonAiActionsV0GeneralActionsActionsItem = typing.Union[
    CommonAiActionsV0GeneralActionsActionsItem0,
    CommonAiActionsV0GeneralActionsActionsItem1,
    CommonAiActionsV0GeneralActionsActionsItem2,
    CommonAiActionsV0GeneralActionsActionsItem3,
    CommonAiActionsV0GeneralActionsActionsItem4,
]

CommonAiActionsV0GeneralActionsActions = typing.List[
    CommonAiActionsV0GeneralActionsActionsItem
]


@dataclass
class CommonAiActionsV0GeneralActions:
    actions: CommonAiActionsV0GeneralActionsActions

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["actions"] = [
            item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "create-table")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "create-column")
            and (
                item.get("columnType", None) == "varchar"
                or item.get("columnType", None) == "int"
                or item.get("columnType", None) == "boolean"
                or item.get("columnType", None) == "json"
                or item.get("columnType", None) == "date"
                or item.get("columnType", None) == "timestamp"
                or item.get("columnType", None) == "uuid"
                or item.get("columnType", None) == "real"
            )
            else item.to_dict()
            if isinstance(item, dict) and (item.get("action", None) == "set-env-var")
            else item.to_dict()
            if isinstance(item, dict)
            and (item.get("action", None) == "create-stage")
            and (
                item.get("stageType", None) == "form"
                or item.get("stageType", None) == "job"
                or item.get("stageType", None) == "hook"
                or item.get("stageType", None) == "tasklet"
            )
            else item.to_dict()
            for item in self.actions
        ]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonAiActionsV0GeneralActions":
        return cls(
            actions=[
                (
                    CommonAiActionsV0GeneralCreateTable.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "create-table")
                    else CommonAiActionsV0GeneralCreateColumn.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "create-column")
                    and (
                        item.get("columnType", None) == "varchar"
                        or item.get("columnType", None) == "int"
                        or item.get("columnType", None) == "boolean"
                        or item.get("columnType", None) == "json"
                        or item.get("columnType", None) == "date"
                        or item.get("columnType", None) == "timestamp"
                        or item.get("columnType", None) == "uuid"
                        or item.get("columnType", None) == "real"
                    )
                    else CommonAiActionsV0GeneralSetEnvVar.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "set-env-var")
                    else CommonAiActionsV0GeneralCreateStage.from_dict(item)
                    if isinstance(item, dict)
                    and (item.get("action", None) == "create-stage")
                    and (
                        item.get("stageType", None) == "form"
                        or item.get("stageType", None) == "job"
                        or item.get("stageType", None) == "hook"
                        or item.get("stageType", None) == "tasklet"
                    )
                    else CommonAiActionsV0GeneralCreateTransition.from_dict(item)
                )
                for item in data["actions"]
            ],
        )


CommonDeploymentResourcesOrganizationDeploymentResourcesWatermarkEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonDeploymentResourcesOrganizationDeploymentResourcesWatermarkEnabledValues: typing.List[
    CommonDeploymentResourcesOrganizationDeploymentResourcesWatermarkEnabled
] = ["true", "false"]

CommonDeploymentResourcesOrganizationDeploymentResourcesNativeTempDir = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonDeploymentResourcesOrganizationDeploymentResourcesNativeTempDirValues: typing.List[
    CommonDeploymentResourcesOrganizationDeploymentResourcesNativeTempDir
] = ["true", "false"]

CommonDeploymentResourcesOrganizationDeploymentResourcesNotificationsEnabled = (
    typing.Union[typing.Literal["true"], typing.Literal["false"]]
)

CommonDeploymentResourcesOrganizationDeploymentResourcesNotificationsEnabledValues: typing.List[
    CommonDeploymentResourcesOrganizationDeploymentResourcesNotificationsEnabled
] = ["true", "false"]

CommonDeploymentResourcesOrganizationDeploymentResourcesRequestsCPU = str

CommonDeploymentResourcesOrganizationDeploymentResourcesLimitsCPU = str

CommonDeploymentResourcesOrganizationDeploymentResourcesRequestsMemory = str

CommonDeploymentResourcesOrganizationDeploymentResourcesLimitsMemory = str

CommonDeploymentResourcesOrganizationDeploymentResourcesMinReplicas = str

CommonDeploymentResourcesOrganizationDeploymentResourcesComputeUnits = float

CommonDeploymentResourcesOrganizationDeploymentResourcesTimeoutSeconds = str

CommonDeploymentResourcesOrganizationDeploymentResourcesWorkerType = typing.Union[
    typing.Literal["jusbrasil"],
    typing.Literal["clickbus"],
    typing.Literal["touchsuite"],
    typing.Literal["foursquare"],
    typing.Literal["estoca"],
    typing.Literal["estoca-test"],
    typing.Literal["irko"],
    typing.Literal["dr9"],
    typing.Literal["onfly"],
    typing.Literal["shared"],
    typing.Literal["test"],
]

CommonDeploymentResourcesOrganizationDeploymentResourcesWorkerTypeValues: typing.List[
    CommonDeploymentResourcesOrganizationDeploymentResourcesWorkerType
] = [
    "jusbrasil",
    "clickbus",
    "touchsuite",
    "foursquare",
    "estoca",
    "estoca-test",
    "irko",
    "dr9",
    "onfly",
    "shared",
    "test",
]

CommonDeploymentResourcesOrganizationDeploymentResourcesPythonVersion = typing.Union[
    typing.Literal["3.9"],
    typing.Literal["3.10"],
    typing.Literal["3.11"],
    typing.Literal["3.12"],
]

CommonDeploymentResourcesOrganizationDeploymentResourcesPythonVersionValues: typing.List[
    CommonDeploymentResourcesOrganizationDeploymentResourcesPythonVersion
] = ["3.9", "3.10", "3.11", "3.12"]

CommonDeploymentResourcesOrganizationDeploymentResourcesWorkerNumber = str

CommonDeploymentResourcesOrganizationDeploymentResourcesBaseDockerfile = str


@dataclass
class CommonDeploymentResourcesOrganizationDeploymentResources:
    watermark_enabled: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesWatermarkEnabled
    ] = field(default_factory=lambda: None)
    native_temp_dir: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesNativeTempDir
    ] = field(default_factory=lambda: None)
    notifications_enabled: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesNotificationsEnabled
    ] = field(default_factory=lambda: None)
    requests_c_p_u: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesRequestsCPU
    ] = field(default_factory=lambda: None)
    limits_c_p_u: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesLimitsCPU
    ] = field(default_factory=lambda: None)
    requests_memory: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesRequestsMemory
    ] = field(default_factory=lambda: None)
    limits_memory: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesLimitsMemory
    ] = field(default_factory=lambda: None)
    min_replicas: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesMinReplicas
    ] = field(default_factory=lambda: None)
    compute_units: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesComputeUnits
    ] = field(default_factory=lambda: None)
    timeout_seconds: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesTimeoutSeconds
    ] = field(default_factory=lambda: None)
    worker_type: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesWorkerType
    ] = field(default_factory=lambda: None)
    python_version: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesPythonVersion
    ] = field(default_factory=lambda: None)
    worker_number: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesWorkerNumber
    ] = field(default_factory=lambda: None)
    base_dockerfile: typing.Optional[
        CommonDeploymentResourcesOrganizationDeploymentResourcesBaseDockerfile
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.watermark_enabled is not None:
            data["watermarkEnabled"] = self.watermark_enabled
        if self.native_temp_dir is not None:
            data["nativeTempDir"] = self.native_temp_dir
        if self.notifications_enabled is not None:
            data["notificationsEnabled"] = self.notifications_enabled
        if self.requests_c_p_u is not None:
            data["requestsCPU"] = self.requests_c_p_u
        if self.limits_c_p_u is not None:
            data["limitsCPU"] = self.limits_c_p_u
        if self.requests_memory is not None:
            data["requestsMemory"] = self.requests_memory
        if self.limits_memory is not None:
            data["limitsMemory"] = self.limits_memory
        if self.min_replicas is not None:
            data["minReplicas"] = self.min_replicas
        if self.compute_units is not None:
            data["computeUnits"] = self.compute_units
        if self.timeout_seconds is not None:
            data["timeoutSeconds"] = self.timeout_seconds
        if self.worker_type is not None:
            data["workerType"] = self.worker_type
        if self.python_version is not None:
            data["pythonVersion"] = self.python_version
        if self.worker_number is not None:
            data["workerNumber"] = self.worker_number
        if self.base_dockerfile is not None:
            data["baseDockerfile"] = self.base_dockerfile
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonDeploymentResourcesOrganizationDeploymentResources":
        return cls(
            watermark_enabled=None
            if data.get("watermarkEnabled") is None
            else data["watermarkEnabled"],
            native_temp_dir=None
            if data.get("nativeTempDir") is None
            else data["nativeTempDir"],
            notifications_enabled=None
            if data.get("notificationsEnabled") is None
            else data["notificationsEnabled"],
            requests_c_p_u=None
            if data.get("requestsCPU") is None
            else str(data["requestsCPU"]),
            limits_c_p_u=None
            if data.get("limitsCPU") is None
            else str(data["limitsCPU"]),
            requests_memory=None
            if data.get("requestsMemory") is None
            else str(data["requestsMemory"]),
            limits_memory=None
            if data.get("limitsMemory") is None
            else str(data["limitsMemory"]),
            min_replicas=None
            if data.get("minReplicas") is None
            else str(data["minReplicas"]),
            compute_units=None
            if data.get("computeUnits") is None
            else float(data["computeUnits"]),
            timeout_seconds=None
            if data.get("timeoutSeconds") is None
            else str(data["timeoutSeconds"]),
            worker_type=None if data.get("workerType") is None else data["workerType"],
            python_version=None
            if data.get("pythonVersion") is None
            else data["pythonVersion"],
            worker_number=None
            if data.get("workerNumber") is None
            else str(data["workerNumber"]),
            base_dockerfile=None
            if data.get("baseDockerfile") is None
            else str(data["baseDockerfile"]),
        )


CommonDeploymentResourcesProjectDeploymentResourcesWatermarkEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonDeploymentResourcesProjectDeploymentResourcesWatermarkEnabledValues: typing.List[
    CommonDeploymentResourcesProjectDeploymentResourcesWatermarkEnabled
] = ["true", "false"]

CommonDeploymentResourcesProjectDeploymentResourcesSeleniumInstanceEnabled = (
    typing.Union[typing.Literal["true"], typing.Literal["false"]]
)

CommonDeploymentResourcesProjectDeploymentResourcesSeleniumInstanceEnabledValues: typing.List[
    CommonDeploymentResourcesProjectDeploymentResourcesSeleniumInstanceEnabled
] = ["true", "false"]

CommonDeploymentResourcesProjectDeploymentResourcesNotificationsEnabled = typing.Union[
    typing.Literal["true"], typing.Literal["false"]
]

CommonDeploymentResourcesProjectDeploymentResourcesNotificationsEnabledValues: typing.List[
    CommonDeploymentResourcesProjectDeploymentResourcesNotificationsEnabled
] = ["true", "false"]

CommonDeploymentResourcesProjectDeploymentResourcesRequestsCPU = str

CommonDeploymentResourcesProjectDeploymentResourcesLimitsCPU = str

CommonDeploymentResourcesProjectDeploymentResourcesRequestsMemory = str

CommonDeploymentResourcesProjectDeploymentResourcesLimitsMemory = str

CommonDeploymentResourcesProjectDeploymentResourcesMinReplicas = str

CommonDeploymentResourcesProjectDeploymentResourcesComputeUnits = float

CommonDeploymentResourcesProjectDeploymentResourcesTimeoutSeconds = str

CommonDeploymentResourcesProjectDeploymentResourcesWorkerType = typing.Union[
    typing.Literal["jusbrasil"],
    typing.Literal["clickbus"],
    typing.Literal["touchsuite"],
    typing.Literal["foursquare"],
    typing.Literal["estoca"],
    typing.Literal["estoca-test"],
    typing.Literal["irko"],
    typing.Literal["dr9"],
    typing.Literal["onfly"],
    typing.Literal["shared"],
    typing.Literal["test"],
]

CommonDeploymentResourcesProjectDeploymentResourcesWorkerTypeValues: typing.List[
    CommonDeploymentResourcesProjectDeploymentResourcesWorkerType
] = [
    "jusbrasil",
    "clickbus",
    "touchsuite",
    "foursquare",
    "estoca",
    "estoca-test",
    "irko",
    "dr9",
    "onfly",
    "shared",
    "test",
]

CommonDeploymentResourcesProjectDeploymentResourcesPythonVersion = typing.Union[
    typing.Literal["3.9"],
    typing.Literal["3.10"],
    typing.Literal["3.11"],
    typing.Literal["3.12"],
]

CommonDeploymentResourcesProjectDeploymentResourcesPythonVersionValues: typing.List[
    CommonDeploymentResourcesProjectDeploymentResourcesPythonVersion
] = ["3.9", "3.10", "3.11", "3.12"]

CommonDeploymentResourcesProjectDeploymentResourcesWorkerNumber = str

CommonDeploymentResourcesProjectDeploymentResourcesBaseDockerfile = str


@dataclass
class CommonDeploymentResourcesProjectDeploymentResources:
    watermark_enabled: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesWatermarkEnabled
    ] = field(default_factory=lambda: None)
    selenium_instance_enabled: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesSeleniumInstanceEnabled
    ] = field(default_factory=lambda: None)
    notifications_enabled: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesNotificationsEnabled
    ] = field(default_factory=lambda: None)
    requests_c_p_u: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesRequestsCPU
    ] = field(default_factory=lambda: None)
    limits_c_p_u: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesLimitsCPU
    ] = field(default_factory=lambda: None)
    requests_memory: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesRequestsMemory
    ] = field(default_factory=lambda: None)
    limits_memory: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesLimitsMemory
    ] = field(default_factory=lambda: None)
    min_replicas: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesMinReplicas
    ] = field(default_factory=lambda: None)
    compute_units: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesComputeUnits
    ] = field(default_factory=lambda: None)
    timeout_seconds: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesTimeoutSeconds
    ] = field(default_factory=lambda: None)
    worker_type: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesWorkerType
    ] = field(default_factory=lambda: None)
    python_version: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesPythonVersion
    ] = field(default_factory=lambda: None)
    worker_number: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesWorkerNumber
    ] = field(default_factory=lambda: None)
    base_dockerfile: typing.Optional[
        CommonDeploymentResourcesProjectDeploymentResourcesBaseDockerfile
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.watermark_enabled is not None:
            data["watermarkEnabled"] = self.watermark_enabled
        if self.selenium_instance_enabled is not None:
            data["seleniumInstanceEnabled"] = self.selenium_instance_enabled
        if self.notifications_enabled is not None:
            data["notificationsEnabled"] = self.notifications_enabled
        if self.requests_c_p_u is not None:
            data["requestsCPU"] = self.requests_c_p_u
        if self.limits_c_p_u is not None:
            data["limitsCPU"] = self.limits_c_p_u
        if self.requests_memory is not None:
            data["requestsMemory"] = self.requests_memory
        if self.limits_memory is not None:
            data["limitsMemory"] = self.limits_memory
        if self.min_replicas is not None:
            data["minReplicas"] = self.min_replicas
        if self.compute_units is not None:
            data["computeUnits"] = self.compute_units
        if self.timeout_seconds is not None:
            data["timeoutSeconds"] = self.timeout_seconds
        if self.worker_type is not None:
            data["workerType"] = self.worker_type
        if self.python_version is not None:
            data["pythonVersion"] = self.python_version
        if self.worker_number is not None:
            data["workerNumber"] = self.worker_number
        if self.base_dockerfile is not None:
            data["baseDockerfile"] = self.base_dockerfile
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CommonDeploymentResourcesProjectDeploymentResources":
        return cls(
            watermark_enabled=None
            if data.get("watermarkEnabled") is None
            else data["watermarkEnabled"],
            selenium_instance_enabled=None
            if data.get("seleniumInstanceEnabled") is None
            else data["seleniumInstanceEnabled"],
            notifications_enabled=None
            if data.get("notificationsEnabled") is None
            else data["notificationsEnabled"],
            requests_c_p_u=None
            if data.get("requestsCPU") is None
            else str(data["requestsCPU"]),
            limits_c_p_u=None
            if data.get("limitsCPU") is None
            else str(data["limitsCPU"]),
            requests_memory=None
            if data.get("requestsMemory") is None
            else str(data["requestsMemory"]),
            limits_memory=None
            if data.get("limitsMemory") is None
            else str(data["limitsMemory"]),
            min_replicas=None
            if data.get("minReplicas") is None
            else str(data["minReplicas"]),
            compute_units=None
            if data.get("computeUnits") is None
            else float(data["computeUnits"]),
            timeout_seconds=None
            if data.get("timeoutSeconds") is None
            else str(data["timeoutSeconds"]),
            worker_type=None if data.get("workerType") is None else data["workerType"],
            python_version=None
            if data.get("pythonVersion") is None
            else data["pythonVersion"],
            worker_number=None
            if data.get("workerNumber") is None
            else str(data["workerNumber"]),
            base_dockerfile=None
            if data.get("baseDockerfile") is None
            else str(data["baseDockerfile"]),
        )


CloudApiCliTablesDumpResponse = CommonTablesSnapshot

CloudApiCliTablesRestoreRequest = CommonTablesSnapshot

CloudApiCliAiV2AbortRequestConversationId = str


@dataclass
class CloudApiCliAiV2AbortRequest:
    conversation_id: CloudApiCliAiV2AbortRequestConversationId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["conversationId"] = self.conversation_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2AbortRequest":
        return cls(
            conversation_id=str(data["conversationId"]),
        )


CloudApiCliAiV2StreamRequestConversationId = str

CloudApiCliAiV2StreamRequestTunnelSessionPath = str

CloudApiCliAiV2StreamRequestSecretKey = str

CloudApiCliAiV2StreamRequestHumanApproval = str

CloudApiCliAiV2StreamRequestEmail = str

CloudApiCliAiV2StreamRequestStatus = typing.Union[
    typing.Literal["pending"], typing.Literal["active"], typing.Literal["invited"]
]

CloudApiCliAiV2StreamRequestStatusValues: typing.List[
    CloudApiCliAiV2StreamRequestStatus
] = ["pending", "active", "invited"]

CloudApiCliAiV2StreamRequestContentItemAssistantTextInputType = typing.Literal["text"]

CloudApiCliAiV2StreamRequestContentItemAssistantTextInputTypeValues: typing.List[
    CloudApiCliAiV2StreamRequestContentItemAssistantTextInputType
] = ["text"]

CloudApiCliAiV2StreamRequestContentItemAssistantTextInputText = str


@dataclass
class CloudApiCliAiV2StreamRequestContentItemAssistantTextInput:
    type: CloudApiCliAiV2StreamRequestContentItemAssistantTextInputType
    text: CloudApiCliAiV2StreamRequestContentItemAssistantTextInputText

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["type"] = self.type
        data["text"] = self.text
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2StreamRequestContentItemAssistantTextInput":
        return cls(
            type=data["type"],
            text=str(data["text"]),
        )


CloudApiCliAiV2StreamRequestContentItemAssistantFileInputType = typing.Literal["file"]

CloudApiCliAiV2StreamRequestContentItemAssistantFileInputTypeValues: typing.List[
    CloudApiCliAiV2StreamRequestContentItemAssistantFileInputType
] = ["file"]

CloudApiCliAiV2StreamRequestContentItemAssistantFileInputFileName = str

CloudApiCliAiV2StreamRequestContentItemAssistantFileInputFileContent = str


@dataclass
class CloudApiCliAiV2StreamRequestContentItemAssistantFileInput:
    type: CloudApiCliAiV2StreamRequestContentItemAssistantFileInputType
    file_name: CloudApiCliAiV2StreamRequestContentItemAssistantFileInputFileName
    file_content: CloudApiCliAiV2StreamRequestContentItemAssistantFileInputFileContent

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["type"] = self.type
        data["fileName"] = self.file_name
        data["fileContent"] = self.file_content
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2StreamRequestContentItemAssistantFileInput":
        return cls(
            type=data["type"],
            file_name=str(data["fileName"]),
            file_content=str(data["fileContent"]),
        )


CloudApiCliAiV2StreamRequestContentItem = typing.Union[
    CloudApiCliAiV2StreamRequestContentItemAssistantTextInput,
    CloudApiCliAiV2StreamRequestContentItemAssistantFileInput,
]

CloudApiCliAiV2StreamRequestContent = typing.List[
    CloudApiCliAiV2StreamRequestContentItem
]

CloudApiCliAiV2StreamRequestContext = typing.Dict[str, typing.Any]


@dataclass
class CloudApiCliAiV2StreamRequest:
    conversation_id: CloudApiCliAiV2StreamRequestConversationId
    content: CloudApiCliAiV2StreamRequestContent
    tunnel_session_path: typing.Optional[
        CloudApiCliAiV2StreamRequestTunnelSessionPath
    ] = field(default_factory=lambda: None)
    secret_key: typing.Optional[CloudApiCliAiV2StreamRequestSecretKey] = field(
        default_factory=lambda: None
    )
    human_approval: typing.Optional[CloudApiCliAiV2StreamRequestHumanApproval] = field(
        default_factory=lambda: None
    )
    email: typing.Optional[CloudApiCliAiV2StreamRequestEmail] = field(
        default_factory=lambda: None
    )
    status: typing.Optional[CloudApiCliAiV2StreamRequestStatus] = field(
        default_factory=lambda: None
    )
    context: typing.Optional[CloudApiCliAiV2StreamRequestContext] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["conversationId"] = self.conversation_id
        data["content"] = [
            item.to_dict()
            if isinstance(item, dict) and (item.get("type", None) == "text")
            else item.to_dict()
            for item in self.content
        ]
        if self.tunnel_session_path is not None:
            data["tunnelSessionPath"] = self.tunnel_session_path
        if self.secret_key is not None:
            data["secretKey"] = self.secret_key
        if self.human_approval is not None:
            data["humanApproval"] = self.human_approval
        if self.email is not None:
            data["email"] = self.email
        if self.status is not None:
            data["status"] = self.status
        if self.context is not None:
            data["context"] = self.context
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2StreamRequest":
        return cls(
            conversation_id=str(data["conversationId"]),
            content=[
                (
                    CloudApiCliAiV2StreamRequestContentItemAssistantTextInput.from_dict(
                        item
                    )
                    if isinstance(item, dict) and (item.get("type", None) == "text")
                    else CloudApiCliAiV2StreamRequestContentItemAssistantFileInput.from_dict(
                        item
                    )
                )
                for item in data["content"]
            ],
            tunnel_session_path=None
            if data.get("tunnelSessionPath") is None
            else str(data["tunnelSessionPath"]),
            secret_key=None
            if data.get("secretKey") is None
            else str(data["secretKey"]),
            human_approval=None
            if data.get("humanApproval") is None
            else str(data["humanApproval"]),
            email=None if data.get("email") is None else str(data["email"]),
            status=None if data.get("status") is None else data["status"],
            context=None if data.get("context") is None else dict(**data["context"]),
        )


CloudApiCliAiV2PromptPostRequestMessagesItemRole = typing.Union[
    typing.Literal["system"], typing.Literal["user"], typing.Literal["assistant"]
]

CloudApiCliAiV2PromptPostRequestMessagesItemRoleValues: typing.List[
    CloudApiCliAiV2PromptPostRequestMessagesItemRole
] = ["system", "user", "assistant"]

CloudApiCliAiV2PromptPostRequestMessagesItemContentItemTextType = typing.Literal["text"]

CloudApiCliAiV2PromptPostRequestMessagesItemContentItemTextTypeValues: typing.List[
    CloudApiCliAiV2PromptPostRequestMessagesItemContentItemTextType
] = ["text"]

CloudApiCliAiV2PromptPostRequestMessagesItemContentItemTextText = str


@dataclass
class CloudApiCliAiV2PromptPostRequestMessagesItemContentItemText:
    type: typing.Optional[
        CloudApiCliAiV2PromptPostRequestMessagesItemContentItemTextType
    ] = field(default_factory=lambda: None)
    text: typing.Optional[
        CloudApiCliAiV2PromptPostRequestMessagesItemContentItemTextText
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.type is not None:
            data["type"] = self.type
        if self.text is not None:
            data["text"] = self.text
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2PromptPostRequestMessagesItemContentItemText":
        return cls(
            type=None if data.get("type") is None else data["type"],
            text=None if data.get("text") is None else str(data["text"]),
        )


CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageType = typing.Literal[
    "image"
]

CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageTypeValues: typing.List[
    CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageType
] = ["image"]

CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageImageUrl = str


@dataclass
class CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageImage:
    url: CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageImageUrl

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["url"] = self.url
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageImage":
        return cls(
            url=str(data["url"]),
        )


@dataclass
class CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImage:
    type: typing.Optional[
        CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageType
    ] = field(default_factory=lambda: None)
    image: typing.Optional[
        CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageImage
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.type is not None:
            data["type"] = self.type
        if self.image is not None:
            data["image"] = self.image.to_dict()
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImage":
        return cls(
            type=None if data.get("type") is None else data["type"],
            image=None
            if data.get("image") is None
            else CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImageImage.from_dict(
                data["image"]
            ),
        )


CloudApiCliAiV2PromptPostRequestMessagesItemContentItem = typing.Union[
    CloudApiCliAiV2PromptPostRequestMessagesItemContentItemText,
    CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImage,
]

CloudApiCliAiV2PromptPostRequestMessagesItemContent = typing.List[
    CloudApiCliAiV2PromptPostRequestMessagesItemContentItem
]


@dataclass
class CloudApiCliAiV2PromptPostRequestMessagesItem:
    role: CloudApiCliAiV2PromptPostRequestMessagesItemRole
    content: CloudApiCliAiV2PromptPostRequestMessagesItemContent

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["role"] = self.role
        data["content"] = [
            item.to_dict()
            if isinstance(item, dict) and (item.get("type", None) == "text")
            else item.to_dict()
            for item in self.content
        ]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2PromptPostRequestMessagesItem":
        return cls(
            role=data["role"],
            content=[
                (
                    CloudApiCliAiV2PromptPostRequestMessagesItemContentItemText.from_dict(
                        item
                    )
                    if isinstance(item, dict) and (item.get("type", None) == "text")
                    else CloudApiCliAiV2PromptPostRequestMessagesItemContentItemImage.from_dict(
                        item
                    )
                )
                for item in data["content"]
            ],
        )


CloudApiCliAiV2PromptPostRequestMessages = typing.List[
    CloudApiCliAiV2PromptPostRequestMessagesItem
]

CloudApiCliAiV2PromptPostRequestToolsItemType = typing.Literal["function"]

CloudApiCliAiV2PromptPostRequestToolsItemTypeValues: typing.List[
    CloudApiCliAiV2PromptPostRequestToolsItemType
] = ["function"]

CloudApiCliAiV2PromptPostRequestToolsItemFunctionName = str

CloudApiCliAiV2PromptPostRequestToolsItemFunctionParameters = typing.Dict[
    str, typing.Any
]

CloudApiCliAiV2PromptPostRequestToolsItemFunctionDescription = str


@dataclass
class CloudApiCliAiV2PromptPostRequestToolsItemFunction:
    name: CloudApiCliAiV2PromptPostRequestToolsItemFunctionName
    parameters: CloudApiCliAiV2PromptPostRequestToolsItemFunctionParameters
    description: typing.Optional[
        CloudApiCliAiV2PromptPostRequestToolsItemFunctionDescription
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["parameters"] = self.parameters
        if self.description is not None:
            data["description"] = self.description
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2PromptPostRequestToolsItemFunction":
        return cls(
            name=str(data["name"]),
            parameters=dict(**data["parameters"]),
            description=None
            if data.get("description") is None
            else str(data["description"]),
        )


@dataclass
class CloudApiCliAiV2PromptPostRequestToolsItem:
    type: CloudApiCliAiV2PromptPostRequestToolsItemType
    function: CloudApiCliAiV2PromptPostRequestToolsItemFunction

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["type"] = self.type
        data["function"] = self.function.to_dict()
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2PromptPostRequestToolsItem":
        return cls(
            type=data["type"],
            function=CloudApiCliAiV2PromptPostRequestToolsItemFunction.from_dict(
                data["function"]
            ),
        )


CloudApiCliAiV2PromptPostRequestTools = typing.List[
    CloudApiCliAiV2PromptPostRequestToolsItem
]

CloudApiCliAiV2PromptPostRequestTemperature = float


@dataclass
class CloudApiCliAiV2PromptPostRequest:
    messages: CloudApiCliAiV2PromptPostRequestMessages
    tools: CloudApiCliAiV2PromptPostRequestTools
    temperature: typing.Optional[CloudApiCliAiV2PromptPostRequestTemperature] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["messages"] = [item.to_dict() for item in self.messages]
        data["tools"] = [item.to_dict() for item in self.tools]
        if self.temperature is not None:
            data["temperature"] = self.temperature
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2PromptPostRequest":
        return cls(
            messages=[
                CloudApiCliAiV2PromptPostRequestMessagesItem.from_dict(item)
                for item in data["messages"]
            ],
            tools=[
                CloudApiCliAiV2PromptPostRequestToolsItem.from_dict(item)
                for item in data["tools"]
            ],
            temperature=None
            if data.get("temperature") is None
            else float(data["temperature"]),
        )


CloudApiCliAiV2ConversationGetResponseId = str

CloudApiCliAiV2ConversationGetResponseCreatedAt = datetime.datetime

CloudApiCliAiV2ConversationGetResponseMessagesItemRole = typing.Union[
    typing.Literal["user"], typing.Literal["assistant"]
]

CloudApiCliAiV2ConversationGetResponseMessagesItemRoleValues: typing.List[
    CloudApiCliAiV2ConversationGetResponseMessagesItemRole
] = ["user", "assistant"]

CloudApiCliAiV2ConversationGetResponseMessagesItemContent = str

CloudApiCliAiV2ConversationGetResponseMessagesItemCreatedAt = datetime.datetime

CloudApiCliAiV2ConversationGetResponseMessagesItemToolTitle = str

CloudApiCliAiV2ConversationGetResponseMessagesItemToolCallId = str


@dataclass
class CloudApiCliAiV2ConversationGetResponseMessagesItem:
    role: CloudApiCliAiV2ConversationGetResponseMessagesItemRole
    content: CloudApiCliAiV2ConversationGetResponseMessagesItemContent
    created_at: CloudApiCliAiV2ConversationGetResponseMessagesItemCreatedAt
    tool_title: typing.Optional[
        CloudApiCliAiV2ConversationGetResponseMessagesItemToolTitle
    ] = field(default_factory=lambda: None)
    tool_call_id: typing.Optional[
        CloudApiCliAiV2ConversationGetResponseMessagesItemToolCallId
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["role"] = self.role
        data["content"] = self.content
        data["createdAt"] = self.created_at.isoformat()
        if self.tool_title is not None:
            data["toolTitle"] = self.tool_title
        if self.tool_call_id is not None:
            data["toolCallId"] = self.tool_call_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2ConversationGetResponseMessagesItem":
        return cls(
            role=data["role"],
            content=str(data["content"]),
            created_at=datetime.datetime.fromisoformat(data["createdAt"]),
            tool_title=None
            if data.get("toolTitle") is None
            else str(data["toolTitle"]),
            tool_call_id=None
            if data.get("toolCallId") is None
            else str(data["toolCallId"]),
        )


CloudApiCliAiV2ConversationGetResponseMessages = typing.List[
    CloudApiCliAiV2ConversationGetResponseMessagesItem
]


@dataclass
class CloudApiCliAiV2ConversationGetResponse:
    id: CloudApiCliAiV2ConversationGetResponseId
    created_at: CloudApiCliAiV2ConversationGetResponseCreatedAt
    messages: CloudApiCliAiV2ConversationGetResponseMessages

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["createdAt"] = self.created_at.isoformat()
        data["messages"] = [item.to_dict() for item in self.messages]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2ConversationGetResponse":
        return cls(
            id=str(data["id"]),
            created_at=datetime.datetime.fromisoformat(data["createdAt"]),
            messages=[
                CloudApiCliAiV2ConversationGetResponseMessagesItem.from_dict(item)
                for item in data["messages"]
            ],
        )


CloudApiCliAiV2ConversationsResponseItem = CloudApiCliAiV2ConversationGetResponse

CloudApiCliAiV2ConversationsResponse = typing.List[
    CloudApiCliAiV2ConversationsResponseItem
]

CloudApiCliAiV2ConversationPostRequestTunnelSessionPath = str

CloudApiCliAiV2ConversationPostRequestSecretKey = str


@dataclass
class CloudApiCliAiV2ConversationPostRequest:
    tunnel_session_path: CloudApiCliAiV2ConversationPostRequestTunnelSessionPath
    secret_key: CloudApiCliAiV2ConversationPostRequestSecretKey

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["tunnelSessionPath"] = self.tunnel_session_path
        data["secretKey"] = self.secret_key
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2ConversationPostRequest":
        return cls(
            tunnel_session_path=str(data["tunnelSessionPath"]),
            secret_key=str(data["secretKey"]),
        )


CloudApiCliAiV2ConversationPostResponseConversationId = str


@dataclass
class CloudApiCliAiV2ConversationPostResponse:
    conversation_id: CloudApiCliAiV2ConversationPostResponseConversationId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["conversationId"] = self.conversation_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliAiV2ConversationPostResponse":
        return cls(
            conversation_id=str(data["conversationId"]),
        )


CloudApiCliRoleUpdateRequestDescription = CommonRoleDescription


@dataclass
class CloudApiCliRoleUpdateRequest:
    description: CloudApiCliRoleUpdateRequestDescription

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["description"] = self.description
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliRoleUpdateRequest":
        return cls(
            description=str(data["description"]),
        )


CloudApiCliRoleUpdateResponse = CommonRole

CloudApiCliRoleListQueryOffset = int

CloudApiCliRoleListQueryLimit = int


@dataclass
class CloudApiCliRoleListQuery:
    offset: typing.Optional[CloudApiCliRoleListQueryOffset] = field(
        default_factory=lambda: 0
    )
    limit: typing.Optional[CloudApiCliRoleListQueryLimit] = field(
        default_factory=lambda: 10
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.offset is not None:
            data["offset"] = self.offset
        if self.limit is not None:
            data["limit"] = self.limit
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliRoleListQuery":
        return cls(
            offset=None if data.get("offset") is None else int(data["offset"]),
            limit=data.get("limit", 10),
        )


CloudApiCliRoleListResponseItem = CommonRole

CloudApiCliRoleListResponse = typing.List[CloudApiCliRoleListResponseItem]

CloudApiCliRoleCreateRequestName = CommonRoleName

CloudApiCliRoleCreateRequestDescription = CommonRoleDescription


@dataclass
class CloudApiCliRoleCreateRequest:
    name: CloudApiCliRoleCreateRequestName
    description: typing.Optional[CloudApiCliRoleCreateRequestDescription] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        if self.description is not None:
            data["description"] = self.description
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliRoleCreateRequest":
        return cls(
            name=str(data["name"]),
            description=None
            if data.get("description") is None
            else str(data["description"]),
        )


CloudApiCliRoleCreateResponse = CommonRole

CloudApiCliUserGetResponse = CommonUser

CloudApiCliModelsNfseResponseBairroPrestador = str

CloudApiCliModelsNfseResponseBairroTomador = str

CloudApiCliModelsNfseResponseCepPrestador = str

CloudApiCliModelsNfseResponseCepTomador = str

CloudApiCliModelsNfseResponseCnpjPrestador = str

CloudApiCliModelsNfseResponseCnpjTomador = str

CloudApiCliModelsNfseResponseDataEmissao = datetime.date

CloudApiCliModelsNfseResponseDescricao = str

CloudApiCliModelsNfseResponseEmailPrestador = str

CloudApiCliModelsNfseResponseEmailTomador = str

CloudApiCliModelsNfseResponseEnderecoPrestador = str

CloudApiCliModelsNfseResponseEnderecoTomador = str

CloudApiCliModelsNfseResponseInscricaoMunicipalPrestador = str

CloudApiCliModelsNfseResponseMunicipioPrestador = str

CloudApiCliModelsNfseResponseNumeroNota = int

CloudApiCliModelsNfseResponseRazaoSocialPrestador = str

CloudApiCliModelsNfseResponseRazaoSocialTomador = str

CloudApiCliModelsNfseResponseUfPrestador = str

CloudApiCliModelsNfseResponseUfTomador = str

CloudApiCliModelsNfseResponseValorLiquidoCentavos = int

CloudApiCliModelsNfseResponseValorTotalCentavos = int


@dataclass
class CloudApiCliModelsNfseResponse:
    bairro_prestador: typing.Optional[CloudApiCliModelsNfseResponseBairroPrestador] = (
        field(default_factory=lambda: None)
    )
    bairro_tomador: typing.Optional[CloudApiCliModelsNfseResponseBairroTomador] = field(
        default_factory=lambda: None
    )
    cep_prestador: typing.Optional[CloudApiCliModelsNfseResponseCepPrestador] = field(
        default_factory=lambda: None
    )
    cep_tomador: typing.Optional[CloudApiCliModelsNfseResponseCepTomador] = field(
        default_factory=lambda: None
    )
    cnpj_prestador: typing.Optional[CloudApiCliModelsNfseResponseCnpjPrestador] = field(
        default_factory=lambda: None
    )
    cnpj_tomador: typing.Optional[CloudApiCliModelsNfseResponseCnpjTomador] = field(
        default_factory=lambda: None
    )
    data_emissao: typing.Optional[CloudApiCliModelsNfseResponseDataEmissao] = field(
        default_factory=lambda: None
    )
    descricao: typing.Optional[CloudApiCliModelsNfseResponseDescricao] = field(
        default_factory=lambda: None
    )
    email_prestador: typing.Optional[CloudApiCliModelsNfseResponseEmailPrestador] = (
        field(default_factory=lambda: None)
    )
    email_tomador: typing.Optional[CloudApiCliModelsNfseResponseEmailTomador] = field(
        default_factory=lambda: None
    )
    endereco_prestador: typing.Optional[
        CloudApiCliModelsNfseResponseEnderecoPrestador
    ] = field(default_factory=lambda: None)
    endereco_tomador: typing.Optional[CloudApiCliModelsNfseResponseEnderecoTomador] = (
        field(default_factory=lambda: None)
    )
    inscricao_municipal_prestador: typing.Optional[
        CloudApiCliModelsNfseResponseInscricaoMunicipalPrestador
    ] = field(default_factory=lambda: None)
    municipio_prestador: typing.Optional[
        CloudApiCliModelsNfseResponseMunicipioPrestador
    ] = field(default_factory=lambda: None)
    numero_nota: typing.Optional[CloudApiCliModelsNfseResponseNumeroNota] = field(
        default_factory=lambda: None
    )
    razao_social_prestador: typing.Optional[
        CloudApiCliModelsNfseResponseRazaoSocialPrestador
    ] = field(default_factory=lambda: None)
    razao_social_tomador: typing.Optional[
        CloudApiCliModelsNfseResponseRazaoSocialTomador
    ] = field(default_factory=lambda: None)
    uf_prestador: typing.Optional[CloudApiCliModelsNfseResponseUfPrestador] = field(
        default_factory=lambda: None
    )
    uf_tomador: typing.Optional[CloudApiCliModelsNfseResponseUfTomador] = field(
        default_factory=lambda: None
    )
    valor_liquido_centavos: typing.Optional[
        CloudApiCliModelsNfseResponseValorLiquidoCentavos
    ] = field(default_factory=lambda: None)
    valor_total_centavos: typing.Optional[
        CloudApiCliModelsNfseResponseValorTotalCentavos
    ] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.bairro_prestador is not None:
            data["bairro_prestador"] = self.bairro_prestador
        if self.bairro_tomador is not None:
            data["bairro_tomador"] = self.bairro_tomador
        if self.cep_prestador is not None:
            data["cep_prestador"] = self.cep_prestador
        if self.cep_tomador is not None:
            data["cep_tomador"] = self.cep_tomador
        if self.cnpj_prestador is not None:
            data["cnpj_prestador"] = self.cnpj_prestador
        if self.cnpj_tomador is not None:
            data["cnpj_tomador"] = self.cnpj_tomador
        if self.data_emissao is not None:
            data["data_emissao"] = self.data_emissao.isoformat()
        if self.descricao is not None:
            data["descricao"] = self.descricao
        if self.email_prestador is not None:
            data["email_prestador"] = self.email_prestador
        if self.email_tomador is not None:
            data["email_tomador"] = self.email_tomador
        if self.endereco_prestador is not None:
            data["endereco_prestador"] = self.endereco_prestador
        if self.endereco_tomador is not None:
            data["endereco_tomador"] = self.endereco_tomador
        if self.inscricao_municipal_prestador is not None:
            data["inscricao_municipal_prestador"] = self.inscricao_municipal_prestador
        if self.municipio_prestador is not None:
            data["municipio_prestador"] = self.municipio_prestador
        if self.numero_nota is not None:
            data["numero_nota"] = self.numero_nota
        if self.razao_social_prestador is not None:
            data["razao_social_prestador"] = self.razao_social_prestador
        if self.razao_social_tomador is not None:
            data["razao_social_tomador"] = self.razao_social_tomador
        if self.uf_prestador is not None:
            data["uf_prestador"] = self.uf_prestador
        if self.uf_tomador is not None:
            data["uf_tomador"] = self.uf_tomador
        if self.valor_liquido_centavos is not None:
            data["valor_liquido_centavos"] = self.valor_liquido_centavos
        if self.valor_total_centavos is not None:
            data["valor_total_centavos"] = self.valor_total_centavos
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliModelsNfseResponse":
        return cls(
            bairro_prestador=None
            if data.get("bairro_prestador") is None
            else str(data["bairro_prestador"]),
            bairro_tomador=None
            if data.get("bairro_tomador") is None
            else str(data["bairro_tomador"]),
            cep_prestador=None
            if data.get("cep_prestador") is None
            else str(data["cep_prestador"]),
            cep_tomador=None
            if data.get("cep_tomador") is None
            else str(data["cep_tomador"]),
            cnpj_prestador=None
            if data.get("cnpj_prestador") is None
            else str(data["cnpj_prestador"]),
            cnpj_tomador=None
            if data.get("cnpj_tomador") is None
            else str(data["cnpj_tomador"]),
            data_emissao=None
            if data.get("data_emissao") is None
            else datetime.date.fromisoformat(data["data_emissao"]),
            descricao=None if data.get("descricao") is None else str(data["descricao"]),
            email_prestador=None
            if data.get("email_prestador") is None
            else str(data["email_prestador"]),
            email_tomador=None
            if data.get("email_tomador") is None
            else str(data["email_tomador"]),
            endereco_prestador=None
            if data.get("endereco_prestador") is None
            else str(data["endereco_prestador"]),
            endereco_tomador=None
            if data.get("endereco_tomador") is None
            else str(data["endereco_tomador"]),
            inscricao_municipal_prestador=None
            if data.get("inscricao_municipal_prestador") is None
            else str(data["inscricao_municipal_prestador"]),
            municipio_prestador=None
            if data.get("municipio_prestador") is None
            else str(data["municipio_prestador"]),
            numero_nota=None
            if data.get("numero_nota") is None
            else int(data["numero_nota"]),
            razao_social_prestador=None
            if data.get("razao_social_prestador") is None
            else str(data["razao_social_prestador"]),
            razao_social_tomador=None
            if data.get("razao_social_tomador") is None
            else str(data["razao_social_tomador"]),
            uf_prestador=None
            if data.get("uf_prestador") is None
            else str(data["uf_prestador"]),
            uf_tomador=None
            if data.get("uf_tomador") is None
            else str(data["uf_tomador"]),
            valor_liquido_centavos=None
            if data.get("valor_liquido_centavos") is None
            else int(data["valor_liquido_centavos"]),
            valor_total_centavos=None
            if data.get("valor_total_centavos") is None
            else int(data["valor_total_centavos"]),
        )


CloudApiCliModelsBoletoResponseAgenciaCodBeneficiario = str

CloudApiCliModelsBoletoResponseBeneficiario = str

CloudApiCliModelsBoletoResponseCarteira = str

CloudApiCliModelsBoletoResponseCpfCnpjBeneficiario = str

CloudApiCliModelsBoletoResponseCpfCnpjPagador = str

CloudApiCliModelsBoletoResponseCodigoDeBarras = str

CloudApiCliModelsBoletoResponseDataEmissao = datetime.date

CloudApiCliModelsBoletoResponseDataProcessamento = datetime.date

CloudApiCliModelsBoletoResponseEnderecoBeneficiario = str

CloudApiCliModelsBoletoResponseEnderecoPagador = str

CloudApiCliModelsBoletoResponseNossoNumero = str

CloudApiCliModelsBoletoResponseNumeroDocumento = str

CloudApiCliModelsBoletoResponsePagador = str

CloudApiCliModelsBoletoResponseValor = int

CloudApiCliModelsBoletoResponseVencimento = datetime.date


@dataclass
class CloudApiCliModelsBoletoResponse:
    agencia_cod_beneficiario: typing.Optional[
        CloudApiCliModelsBoletoResponseAgenciaCodBeneficiario
    ] = field(default_factory=lambda: None)
    beneficiario: typing.Optional[CloudApiCliModelsBoletoResponseBeneficiario] = field(
        default_factory=lambda: None
    )
    carteira: typing.Optional[CloudApiCliModelsBoletoResponseCarteira] = field(
        default_factory=lambda: None
    )
    cpf_cnpj_beneficiario: typing.Optional[
        CloudApiCliModelsBoletoResponseCpfCnpjBeneficiario
    ] = field(default_factory=lambda: None)
    cpf_cnpj_pagador: typing.Optional[CloudApiCliModelsBoletoResponseCpfCnpjPagador] = (
        field(default_factory=lambda: None)
    )
    codigo_de_barras: typing.Optional[CloudApiCliModelsBoletoResponseCodigoDeBarras] = (
        field(default_factory=lambda: None)
    )
    data_emissao: typing.Optional[CloudApiCliModelsBoletoResponseDataEmissao] = field(
        default_factory=lambda: None
    )
    data_processamento: typing.Optional[
        CloudApiCliModelsBoletoResponseDataProcessamento
    ] = field(default_factory=lambda: None)
    endereco_beneficiario: typing.Optional[
        CloudApiCliModelsBoletoResponseEnderecoBeneficiario
    ] = field(default_factory=lambda: None)
    endereco_pagador: typing.Optional[
        CloudApiCliModelsBoletoResponseEnderecoPagador
    ] = field(default_factory=lambda: None)
    nosso_numero: typing.Optional[CloudApiCliModelsBoletoResponseNossoNumero] = field(
        default_factory=lambda: None
    )
    numero_documento: typing.Optional[
        CloudApiCliModelsBoletoResponseNumeroDocumento
    ] = field(default_factory=lambda: None)
    pagador: typing.Optional[CloudApiCliModelsBoletoResponsePagador] = field(
        default_factory=lambda: None
    )
    valor: typing.Optional[CloudApiCliModelsBoletoResponseValor] = field(
        default_factory=lambda: None
    )
    vencimento: typing.Optional[CloudApiCliModelsBoletoResponseVencimento] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.agencia_cod_beneficiario is not None:
            data["agencia_cod_beneficiario"] = self.agencia_cod_beneficiario
        if self.beneficiario is not None:
            data["beneficiario"] = self.beneficiario
        if self.carteira is not None:
            data["carteira"] = self.carteira
        if self.cpf_cnpj_beneficiario is not None:
            data["cpf_cnpj_beneficiario"] = self.cpf_cnpj_beneficiario
        if self.cpf_cnpj_pagador is not None:
            data["cpf_cnpj_pagador"] = self.cpf_cnpj_pagador
        if self.codigo_de_barras is not None:
            data["codigo_de_barras"] = self.codigo_de_barras
        if self.data_emissao is not None:
            data["data_emissao"] = self.data_emissao.isoformat()
        if self.data_processamento is not None:
            data["data_processamento"] = self.data_processamento.isoformat()
        if self.endereco_beneficiario is not None:
            data["endereco_beneficiario"] = self.endereco_beneficiario
        if self.endereco_pagador is not None:
            data["endereco_pagador"] = self.endereco_pagador
        if self.nosso_numero is not None:
            data["nosso_numero"] = self.nosso_numero
        if self.numero_documento is not None:
            data["numero_documento"] = self.numero_documento
        if self.pagador is not None:
            data["pagador"] = self.pagador
        if self.valor is not None:
            data["valor"] = self.valor
        if self.vencimento is not None:
            data["vencimento"] = self.vencimento.isoformat()
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliModelsBoletoResponse":
        return cls(
            agencia_cod_beneficiario=None
            if data.get("agencia_cod_beneficiario") is None
            else str(data["agencia_cod_beneficiario"]),
            beneficiario=None
            if data.get("beneficiario") is None
            else str(data["beneficiario"]),
            carteira=None if data.get("carteira") is None else str(data["carteira"]),
            cpf_cnpj_beneficiario=None
            if data.get("cpf_cnpj_beneficiario") is None
            else str(data["cpf_cnpj_beneficiario"]),
            cpf_cnpj_pagador=None
            if data.get("cpf_cnpj_pagador") is None
            else str(data["cpf_cnpj_pagador"]),
            codigo_de_barras=None
            if data.get("codigo_de_barras") is None
            else str(data["codigo_de_barras"]),
            data_emissao=None
            if data.get("data_emissao") is None
            else datetime.date.fromisoformat(data["data_emissao"]),
            data_processamento=None
            if data.get("data_processamento") is None
            else datetime.date.fromisoformat(data["data_processamento"]),
            endereco_beneficiario=None
            if data.get("endereco_beneficiario") is None
            else str(data["endereco_beneficiario"]),
            endereco_pagador=None
            if data.get("endereco_pagador") is None
            else str(data["endereco_pagador"]),
            nosso_numero=None
            if data.get("nosso_numero") is None
            else str(data["nosso_numero"]),
            numero_documento=None
            if data.get("numero_documento") is None
            else str(data["numero_documento"]),
            pagador=None if data.get("pagador") is None else str(data["pagador"]),
            valor=None if data.get("valor") is None else int(data["valor"]),
            vencimento=None
            if data.get("vencimento") is None
            else datetime.date.fromisoformat(data["vencimento"]),
        )


CloudApiCliBuildCreateResponseUrl = str

CloudApiCliBuildCreateResponseBuildId = str


@dataclass
class CloudApiCliBuildCreateResponse:
    url: CloudApiCliBuildCreateResponseUrl
    build_id: CloudApiCliBuildCreateResponseBuildId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["url"] = self.url
        data["buildId"] = self.build_id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliBuildCreateResponse":
        return cls(
            url=str(data["url"]),
            build_id=str(data["buildId"]),
        )


CloudApiCliApiKeyInfoResponseAuthorId = str

CloudApiCliApiKeyInfoResponseProjectId = str

CloudApiCliApiKeyInfoResponseEmail = str

CloudApiCliApiKeyInfoResponseIntercomHash = str


@dataclass
class CloudApiCliApiKeyInfoResponse:
    author_id: CloudApiCliApiKeyInfoResponseAuthorId
    project_id: CloudApiCliApiKeyInfoResponseProjectId
    email: CloudApiCliApiKeyInfoResponseEmail
    intercom_hash: CloudApiCliApiKeyInfoResponseIntercomHash

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["authorId"] = self.author_id
        data["projectId"] = self.project_id
        data["email"] = self.email
        data["intercomHash"] = self.intercom_hash
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "CloudApiCliApiKeyInfoResponse":
        return cls(
            author_id=str(data["authorId"]),
            project_id=str(data["projectId"]),
            email=str(data["email"]),
            intercom_hash=str(data["intercomHash"]),
        )


AbstraLibApiStageCardContentKey = str

AbstraLibApiStageCardContentValue = typing.Dict[str, typing.Any]

AbstraLibApiStageCardContentType = str


@dataclass
class AbstraLibApiStageCardContent:
    key: AbstraLibApiStageCardContentKey
    value: AbstraLibApiStageCardContentValue
    type: AbstraLibApiStageCardContentType

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["key"] = self.key
        data["value"] = self.value
        data["type"] = self.type
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiStageCardContent":
        return cls(
            key=str(data["key"]),
            value=dict(**data["value"]),
            type=str(data["type"]),
        )


AbstraLibApiStageCardContentsItem = AbstraLibApiStageCardContent

AbstraLibApiStageCardContents = typing.List[AbstraLibApiStageCardContentsItem]

AbstraLibApiStageRunId = str

AbstraLibApiStageRunStage = str

AbstraLibApiStageRunData = typing.Dict[str, typing.Any]

AbstraLibApiStageRunStatus = typing.Union[
    typing.Literal["waiting"],
    typing.Literal["running"],
    typing.Literal["processing"],
    typing.Literal["finished"],
    typing.Literal["failed"],
    typing.Literal["abandoned"],
]

AbstraLibApiStageRunStatusValues: typing.List[AbstraLibApiStageRunStatus] = [
    "waiting",
    "running",
    "processing",
    "finished",
    "failed",
    "abandoned",
]

AbstraLibApiStageRunCreatedAt = str

AbstraLibApiStageRunUpdatedAt = str

AbstraLibApiStageRunParentId = str

AbstraLibApiStageRunExecutionId = str


@dataclass
class AbstraLibApiStageRun:
    id: AbstraLibApiStageRunId
    stage: AbstraLibApiStageRunStage
    data: AbstraLibApiStageRunData
    status: AbstraLibApiStageRunStatus
    created_at: AbstraLibApiStageRunCreatedAt
    updated_at: AbstraLibApiStageRunUpdatedAt
    parent_id: typing.Optional[AbstraLibApiStageRunParentId] = field(
        default_factory=lambda: None
    )
    execution_id: typing.Optional[AbstraLibApiStageRunExecutionId] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["stage"] = self.stage
        data["data"] = self.data
        data["status"] = self.status
        data["created_at"] = self.created_at
        data["updated_at"] = self.updated_at
        if self.parent_id is not None:
            data["parent_id"] = self.parent_id
        if self.execution_id is not None:
            data["execution_id"] = self.execution_id
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "AbstraLibApiStageRun":
        return cls(
            id=str(data["id"]),
            stage=str(data["stage"]),
            data=dict(**data["data"]),
            status=data["status"],
            created_at=str(data["created_at"]),
            updated_at=str(data["updated_at"]),
            parent_id=None if data.get("parent_id") is None else str(data["parent_id"]),
            execution_id=None
            if data.get("execution_id") is None
            else str(data["execution_id"]),
        )


AbstraLibApiStageRunCardId = str

AbstraLibApiStageRunCardCreatedAt = str

AbstraLibApiStageRunCardUpdatedAt = str

AbstraLibApiStageRunCardAssignee = str

AbstraLibApiStageRunCardStatus = AbstraLibApiStageRunStatus

AbstraLibApiStageRunCardContent = AbstraLibApiStageCardContents

AbstraLibApiStageRunCardStage = str


@dataclass
class AbstraLibApiStageRunCard:
    id: AbstraLibApiStageRunCardId
    created_at: AbstraLibApiStageRunCardCreatedAt
    status: AbstraLibApiStageRunCardStatus
    content: AbstraLibApiStageRunCardContent
    updated_at: typing.Optional[AbstraLibApiStageRunCardUpdatedAt] = field(
        default_factory=lambda: None
    )
    assignee: typing.Optional[AbstraLibApiStageRunCardAssignee] = field(
        default_factory=lambda: None
    )
    stage: typing.Optional[AbstraLibApiStageRunCardStage] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["created_at"] = self.created_at
        data["status"] = self.status
        data["content"] = [item.to_dict() for item in self.content]
        if self.updated_at is not None:
            data["updated_at"] = self.updated_at
        if self.assignee is not None:
            data["assignee"] = self.assignee
        if self.stage is not None:
            data["stage"] = self.stage
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiStageRunCard":
        return cls(
            id=str(data["id"]),
            created_at=str(data["created_at"]),
            status=data["status"],
            content=[
                AbstraLibApiStageCardContent.from_dict(item) for item in data["content"]
            ],
            updated_at=None
            if data.get("updated_at") is None
            else str(data["updated_at"]),
            assignee=None if data.get("assignee") is None else str(data["assignee"]),
            stage=None if data.get("stage") is None else str(data["stage"]),
        )


AbstraLibApiStageRunCardsItem = AbstraLibApiStageRunCard

AbstraLibApiStageRunCards = typing.List[AbstraLibApiStageRunCardsItem]

AbstraLibApiStageId = str

AbstraLibApiStageType = typing.Union[
    typing.Literal["form"],
    typing.Literal["hook"],
    typing.Literal["job"],
    typing.Literal["script"],
]

AbstraLibApiStageTypeValues: typing.List[AbstraLibApiStageType] = [
    "form",
    "hook",
    "job",
    "script",
]

AbstraLibApiStageTitle = str

AbstraLibApiStagePath = str

AbstraLibApiStageCanBeStarted = bool


@dataclass
class AbstraLibApiStage:
    id: AbstraLibApiStageId
    type: AbstraLibApiStageType
    title: AbstraLibApiStageTitle
    can_be_started: AbstraLibApiStageCanBeStarted
    path: typing.Optional[AbstraLibApiStagePath] = field(default_factory=lambda: None)

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["id"] = self.id
        data["type"] = self.type
        data["title"] = self.title
        data["can_be_started"] = self.can_be_started
        if self.path is not None:
            data["path"] = self.path
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "AbstraLibApiStage":
        return cls(
            id=str(data["id"]),
            type=data["type"],
            title=str(data["title"]),
            can_be_started=bool(data["can_be_started"]),
            path=None if data.get("path") is None else str(data["path"]),
        )


AbstraLibApiKanbanColumnSelectedStage = AbstraLibApiStage

AbstraLibApiKanbanColumnStageRunCards = AbstraLibApiStageRunCards

AbstraLibApiKanbanColumnTotalCount = int

AbstraLibApiKanbanColumnLoading = bool


@dataclass
class AbstraLibApiKanbanColumn:
    selected_stage: AbstraLibApiKanbanColumnSelectedStage
    stage_run_cards: AbstraLibApiKanbanColumnStageRunCards
    total_count: AbstraLibApiKanbanColumnTotalCount
    loading: typing.Optional[AbstraLibApiKanbanColumnLoading] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["selected_stage"] = self.selected_stage.to_dict()
        data["stage_run_cards"] = [item.to_dict() for item in self.stage_run_cards]
        data["total_count"] = self.total_count
        if self.loading is not None:
            data["loading"] = self.loading
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiKanbanColumn":
        return cls(
            selected_stage=AbstraLibApiStage.from_dict(data["selected_stage"]),
            stage_run_cards=[
                AbstraLibApiStageRunCard.from_dict(item)
                for item in data["stage_run_cards"]
            ],
            total_count=int(data["total_count"]),
            loading=None if data.get("loading") is None else bool(data["loading"]),
        )


AbstraLibApiKanbanColumnsItem = AbstraLibApiKanbanColumn

AbstraLibApiKanbanColumns = typing.List[AbstraLibApiKanbanColumnsItem]

AbstraLibApiKanbanDataColumns = AbstraLibApiKanbanColumns


@dataclass
class AbstraLibApiKanbanData:
    columns: AbstraLibApiKanbanDataColumns

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["columns"] = [item.to_dict() for item in self.columns]
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "AbstraLibApiKanbanData":
        return cls(
            columns=[
                AbstraLibApiKanbanColumn.from_dict(item) for item in data["columns"]
            ],
        )


AbstraLibApiThreadsStageRunCards = AbstraLibApiStageRunCards

AbstraLibApiThreadsNotFoundStagesItem = str

AbstraLibApiThreadsNotFoundStages = typing.List[AbstraLibApiThreadsNotFoundStagesItem]

AbstraLibApiThreadsTotalCount = int


@dataclass
class AbstraLibApiThreads:
    stage_run_cards: AbstraLibApiThreadsStageRunCards
    not_found_stages: AbstraLibApiThreadsNotFoundStages
    total_count: AbstraLibApiThreadsTotalCount

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["stage_run_cards"] = [item.to_dict() for item in self.stage_run_cards]
        data["not_found_stages"] = self.not_found_stages
        data["total_count"] = self.total_count
        return data

    @classmethod
    def from_dict(cls, data: typing.Dict[str, typing.Any]) -> "AbstraLibApiThreads":
        return cls(
            stage_run_cards=[
                AbstraLibApiStageRunCard.from_dict(item)
                for item in data["stage_run_cards"]
            ],
            not_found_stages=[str(item) for item in data["not_found_stages"]],
            total_count=int(data["total_count"]),
        )


AbstraLibApiStagesItem = AbstraLibApiStage

AbstraLibApiStages = typing.List[AbstraLibApiStagesItem]

AbstraLibApiAiStreamRequestConversationId = CloudApiCliAiV2StreamRequestConversationId

AbstraLibApiAiStreamRequestContent = CloudApiCliAiV2StreamRequestContent

AbstraLibApiAiStreamRequestContext = typing.Dict[str, typing.Any]

AbstraLibApiAiStreamRequestHumanApproval = str


@dataclass
class AbstraLibApiAiStreamRequest:
    conversation_id: AbstraLibApiAiStreamRequestConversationId
    content: AbstraLibApiAiStreamRequestContent
    context: AbstraLibApiAiStreamRequestContext
    human_approval: typing.Optional[AbstraLibApiAiStreamRequestHumanApproval] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["conversationId"] = self.conversation_id
        data["content"] = [
            item.to_dict()
            if isinstance(item, dict) and (item.get("type", None) == "text")
            else item.to_dict()
            for item in self.content
        ]
        data["context"] = self.context
        if self.human_approval is not None:
            data["humanApproval"] = self.human_approval
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiAiStreamRequest":
        return cls(
            conversation_id=str(data["conversationId"]),
            content=[
                (
                    CloudApiCliAiV2StreamRequestContentItemAssistantTextInput.from_dict(
                        item
                    )
                    if isinstance(item, dict) and (item.get("type", None) == "text")
                    else CloudApiCliAiV2StreamRequestContentItemAssistantFileInput.from_dict(
                        item
                    )
                )
                for item in data["content"]
            ],
            context=dict(**data["context"]),
            human_approval=None
            if data.get("humanApproval") is None
            else str(data["humanApproval"]),
        )


AbstraLibApiEditorCodebaseEventsMessageFilepath = str

AbstraLibApiEditorCodebaseEventsMessageEvent = typing.Union[
    typing.Literal["changed"],
    typing.Literal["created"],
    typing.Literal["deleted"],
    typing.Literal["moved"],
]

AbstraLibApiEditorCodebaseEventsMessageEventValues: typing.List[
    AbstraLibApiEditorCodebaseEventsMessageEvent
] = ["changed", "created", "deleted", "moved"]


@dataclass
class AbstraLibApiEditorCodebaseEventsMessage:
    filepath: AbstraLibApiEditorCodebaseEventsMessageFilepath
    event: AbstraLibApiEditorCodebaseEventsMessageEvent

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["filepath"] = self.filepath
        data["event"] = self.event
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorCodebaseEventsMessage":
        return cls(
            filepath=str(data["filepath"]),
            event=data["event"],
        )


AbstraLibApiEditorFilesSettingsResponseSeparator = str


@dataclass
class AbstraLibApiEditorFilesSettingsResponse:
    separator: AbstraLibApiEditorFilesSettingsResponseSeparator

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["separator"] = self.separator
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesSettingsResponse":
        return cls(
            separator=str(data["separator"]),
        )


AbstraLibApiEditorFilesDeleteResponseOk = bool


@dataclass
class AbstraLibApiEditorFilesDeleteResponse:
    ok: typing.Optional[AbstraLibApiEditorFilesDeleteResponseOk] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.ok is not None:
            data["ok"] = self.ok
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesDeleteResponse":
        return cls(
            ok=None if data.get("ok") is None else bool(data["ok"]),
        )


AbstraLibApiEditorFilesEditResponseOk = bool


@dataclass
class AbstraLibApiEditorFilesEditResponse:
    ok: typing.Optional[AbstraLibApiEditorFilesEditResponseOk] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.ok is not None:
            data["ok"] = self.ok
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesEditResponse":
        return cls(
            ok=None if data.get("ok") is None else bool(data["ok"]),
        )


AbstraLibApiEditorFilesListResponseItemFile = CommonFileNode

AbstraLibApiEditorFilesListResponseItemStagesItemType = typing.Union[
    typing.Literal["form"],
    typing.Literal["hook"],
    typing.Literal["job"],
    typing.Literal["script"],
]

AbstraLibApiEditorFilesListResponseItemStagesItemTypeValues: typing.List[
    AbstraLibApiEditorFilesListResponseItemStagesItemType
] = ["form", "hook", "job", "script"]

AbstraLibApiEditorFilesListResponseItemStagesItemId = str


@dataclass
class AbstraLibApiEditorFilesListResponseItemStagesItem:
    type: AbstraLibApiEditorFilesListResponseItemStagesItemType
    id: AbstraLibApiEditorFilesListResponseItemStagesItemId

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["type"] = self.type
        data["id"] = self.id
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesListResponseItemStagesItem":
        return cls(
            type=data["type"],
            id=str(data["id"]),
        )


AbstraLibApiEditorFilesListResponseItemStages = typing.List[
    AbstraLibApiEditorFilesListResponseItemStagesItem
]


@dataclass
class AbstraLibApiEditorFilesListResponseItem:
    file: AbstraLibApiEditorFilesListResponseItemFile
    stages: AbstraLibApiEditorFilesListResponseItemStages

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["file"] = self.file.to_dict()
        data["stages"] = [item.to_dict() for item in self.stages]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesListResponseItem":
        return cls(
            file=CommonFileNode.from_dict(data["file"]),
            stages=[
                AbstraLibApiEditorFilesListResponseItemStagesItem.from_dict(item)
                for item in data["stages"]
            ],
        )


AbstraLibApiEditorFilesListResponse = typing.List[
    AbstraLibApiEditorFilesListResponseItem
]

AbstraLibApiEditorFilesMkdirResponseOk = bool


@dataclass
class AbstraLibApiEditorFilesMkdirResponse:
    ok: typing.Optional[AbstraLibApiEditorFilesMkdirResponseOk] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.ok is not None:
            data["ok"] = self.ok
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesMkdirResponse":
        return cls(
            ok=None if data.get("ok") is None else bool(data["ok"]),
        )


AbstraLibApiEditorFilesRenameRequestPathPartsItem = str

AbstraLibApiEditorFilesRenameRequestPathParts = typing.List[
    AbstraLibApiEditorFilesRenameRequestPathPartsItem
]

AbstraLibApiEditorFilesRenameRequestNewPathPartsItem = str

AbstraLibApiEditorFilesRenameRequestNewPathParts = typing.List[
    AbstraLibApiEditorFilesRenameRequestNewPathPartsItem
]


@dataclass
class AbstraLibApiEditorFilesRenameRequest:
    path_parts: AbstraLibApiEditorFilesRenameRequestPathParts
    new_path_parts: AbstraLibApiEditorFilesRenameRequestNewPathParts

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["pathParts"] = self.path_parts
        data["newPathParts"] = self.new_path_parts
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesRenameRequest":
        return cls(
            path_parts=[str(item) for item in data["pathParts"]],
            new_path_parts=[str(item) for item in data["newPathParts"]],
        )


AbstraLibApiEditorFilesRenameResponseOk = bool


@dataclass
class AbstraLibApiEditorFilesRenameResponse:
    ok: typing.Optional[AbstraLibApiEditorFilesRenameResponseOk] = field(
        default_factory=lambda: None
    )

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        if self.ok is not None:
            data["ok"] = self.ok
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorFilesRenameResponse":
        return cls(
            ok=None if data.get("ok") is None else bool(data["ok"]),
        )


AbstraLibApiEditorFilesCreateResponse = CommonFileNode

AbstraLibApiEditorLintersRuleName = str

AbstraLibApiEditorLintersRuleLabel = str

AbstraLibApiEditorLintersRuleType = typing.Literal["bug"]

AbstraLibApiEditorLintersRuleTypeValues: typing.List[
    AbstraLibApiEditorLintersRuleType
] = ["bug"]

AbstraLibApiEditorLintersIssueLabel = str

AbstraLibApiEditorLintersFixName = str

AbstraLibApiEditorLintersFixLabel = str


@dataclass
class AbstraLibApiEditorLintersFix:
    name: AbstraLibApiEditorLintersFixName
    label: AbstraLibApiEditorLintersFixLabel

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["label"] = self.label
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorLintersFix":
        return cls(
            name=str(data["name"]),
            label=str(data["label"]),
        )


AbstraLibApiEditorLintersIssueFixesItem = AbstraLibApiEditorLintersFix

AbstraLibApiEditorLintersIssueFixes = typing.List[
    AbstraLibApiEditorLintersIssueFixesItem
]


@dataclass
class AbstraLibApiEditorLintersIssue:
    label: AbstraLibApiEditorLintersIssueLabel
    fixes: AbstraLibApiEditorLintersIssueFixes

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["label"] = self.label
        data["fixes"] = [item.to_dict() for item in self.fixes]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorLintersIssue":
        return cls(
            label=str(data["label"]),
            fixes=[
                AbstraLibApiEditorLintersFix.from_dict(item) for item in data["fixes"]
            ],
        )


AbstraLibApiEditorLintersRuleIssuesItem = AbstraLibApiEditorLintersIssue

AbstraLibApiEditorLintersRuleIssues = typing.List[
    AbstraLibApiEditorLintersRuleIssuesItem
]


@dataclass
class AbstraLibApiEditorLintersRule:
    name: AbstraLibApiEditorLintersRuleName
    label: AbstraLibApiEditorLintersRuleLabel
    type: AbstraLibApiEditorLintersRuleType
    issues: AbstraLibApiEditorLintersRuleIssues

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["label"] = self.label
        data["type"] = self.type
        data["issues"] = [item.to_dict() for item in self.issues]
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorLintersRule":
        return cls(
            name=str(data["name"]),
            label=str(data["label"]),
            type=data["type"],
            issues=[
                AbstraLibApiEditorLintersIssue.from_dict(item)
                for item in data["issues"]
            ],
        )


AbstraLibApiEditorLintersFixResponseSuccess = bool


@dataclass
class AbstraLibApiEditorLintersFixResponse:
    success: AbstraLibApiEditorLintersFixResponseSuccess

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["success"] = self.success
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorLintersFixResponse":
        return cls(
            success=bool(data["success"]),
        )


AbstraLibApiEditorLintersCheckResponseItem = AbstraLibApiEditorLintersRule

AbstraLibApiEditorLintersCheckResponse = typing.List[
    AbstraLibApiEditorLintersCheckResponseItem
]

AbstraLibApiEditorWebEditorResponseWaitingRoomUrl = str


@dataclass
class AbstraLibApiEditorWebEditorResponse:
    waiting_room_url: AbstraLibApiEditorWebEditorResponseWaitingRoomUrl

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["waitingRoomUrl"] = self.waiting_room_url
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorWebEditorResponse":
        return cls(
            waiting_room_url=str(data["waitingRoomUrl"]),
        )


AbstraLibApiEditorEnvVarsModelName = str

AbstraLibApiEditorEnvVarsModelValue = str


@dataclass
class AbstraLibApiEditorEnvVarsModel:
    name: AbstraLibApiEditorEnvVarsModelName
    value: AbstraLibApiEditorEnvVarsModelValue

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["name"] = self.name
        data["value"] = self.value
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiEditorEnvVarsModel":
        return cls(
            name=str(data["name"]),
            value=str(data["value"]),
        )


AbstraLibApiEditorEnvVarsListResponseItem = AbstraLibApiEditorEnvVarsModel

AbstraLibApiEditorEnvVarsListResponse = typing.List[
    AbstraLibApiEditorEnvVarsListResponseItem
]

AbstraLibApiEditorEnvVarsCreateRequest = AbstraLibApiEditorEnvVarsModel

AbstraLibApiEditorEnvVarsCreateResponse = AbstraLibApiEditorEnvVarsModel

AbstraLibApiPlayerUserSignupEmail = CommonUserEmail


@dataclass
class AbstraLibApiPlayerUserSignup:
    email: AbstraLibApiPlayerUserSignupEmail

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["email"] = self.email
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiPlayerUserSignup":
        return cls(
            email=str(data["email"]),
        )


AbstraLibApiPlayerUserNavigationGuardStatus = typing.Union[
    typing.Literal["ALLOWED"],
    typing.Literal["UNAUTHORIZED"],
    typing.Literal["FORBIDEN"],
    typing.Literal["NOT_FOUND"],
]

AbstraLibApiPlayerUserNavigationGuardStatusValues: typing.List[
    AbstraLibApiPlayerUserNavigationGuardStatus
] = ["ALLOWED", "UNAUTHORIZED", "FORBIDEN", "NOT_FOUND"]


@dataclass
class AbstraLibApiPlayerUserNavigationGuard:
    status: AbstraLibApiPlayerUserNavigationGuardStatus

    def to_dict(self) -> typing.Dict[str, typing.Any]:
        data = {}
        data["status"] = self.status
        return data

    @classmethod
    def from_dict(
        cls, data: typing.Dict[str, typing.Any]
    ) -> "AbstraLibApiPlayerUserNavigationGuard":
        return cls(
            status=data["status"],
        )
