# "SatKit" 

![PyPI - Version](https://img.shields.io/pypi/v/satkit)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/satkit)
![PyPI - Implementation](https://img.shields.io/pypi/implementation/satkit)
![PyPI - Status](https://img.shields.io/pypi/status/satkit)

**SatKit** is a python library providing tools that enable computation and prediction of satellite orbits, satellite maneuvers, and (soon) satellite attitude dynamics.  

The SatKit core code is written in [rust](https://www.rust-lang.org) for speed and safety.  The python bindings are done via the [pyo3](https://pyo3.rs) package.  All calculations are performed natively in rust, making the package much faster than a pure-python equivalent.

## Features

- High-precision coordinate transforms between:
  - International Terrestrial Reference Frame (ITRF)
  - Geocentric Celestial Reference Frame (GCRF) using IAU-2000 reduction
  - True-Equinox Mean Equator (TEME) frame used in SGP4 propagation of TLEs
  - Celestial Intermediate Reference Frame (CIRF)
  - Terrestrial Intermediate Reference Frame (TIRF)
  - Terrestrial Geodetic frame (latitude, longitude)
- Geodesic distances
- SGP4, and Keplerian orbit propagation
- JPL high-precision planetary ephemerides
- High-order gravity models
- High-precision, high-speed numerical satellite orbit propagation with high-order efficient Runga-Kutta solvers, ability to solve for state transition matrix, and inclusion following forces:
  - High-order Earth gravity with multiple models
  - Solar gravity
  - Lunar gravity
  - Drag (NRL MISE-00 density model)
  - Radiation pressure

## ODE Solvers

The high-precision numerical satellite orbit propagation makes use of standard Runga-Kutta methods for integration of ordinary differential equations. The ODE solver is included as part of the library.

The methods use Runga-Kutta pairs for ODE integration and error estimation generated by Jim Verner: [https://www.sfu.ca/~jverner/](https://www.sfu.ca/~jverner/)



## Author

Steven Michael (ssmichael@gmail.com)

Please reach out of you find errors in code or calculations, are interested in contributing to this repository, or have suggestions for improvements to the API.

# Table of Contents

```{eval-rst}
.. toctree::
  :maxdepth: 1
  :caption: Basics

  install
  references
  datafiles

.. toctree::
  :maxdepth: 1
  :caption: User Documentation

  time
  quaternion
  frametransform
  TLE
  itrfcoord
  satprop
  satstate
  density

.. toctree::
  :caption: Examples

  examples/ITRF Coordinates.ipynb
  examples/Satellite Ground Contacts.ipynb
  examples/Two-Line Element Set.ipynb
  examples/Eclipse.ipynb
  examples/Plots.ipynb
  examples/sunrise_sunset.ipynb
  examples/riseset.ipynb
  examples/TLE Fitting.ipynb
  examples/High Precision Propagation.ipynb

.. toctree::
  :caption: API Reference

  api/time.md
  api/quaternion.md
  api/frametransform.md
  api/satprop.md
  api/jplephem.md
  api/itrfcoord.md
  api/earthgravity.md
  api/satstate.md
  api/tle.md
  api/consts.md
  api/kepler.md
  api/utils.md
  api/density.md

```
