import argparse
from .controller import run_pipeline

def main():
    parser = argparse.ArgumentParser(description="NestAI Secure Prompt Hardener")
    parser.add_argument("prompt", nargs="+", help="Prompt to secure")
    args = parser.parse_args()

    original_prompt = " ".join(args.prompt)
    result = run_pipeline(original_prompt)

    print("=== Original Prompt ===")
    print(result["original_prompt"])
    print()

    print("=== Red Team Findings ===")
    for f in result["findings"]:
        print("-", f)
    print()

    print("=== Final Secure Prompt ===")
    print(result["secure_prompt"])
    print()

    print("=== Code Preview (from secure prompt) ===")
    print("```")
    print(result["code_preview"])
    print("```")
