from .red_team import run_red_team
from .blue_team import blue_agent_rewrite
from .codegen import generate_code_preview

def run_pipeline(original_prompt: str):
    findings = run_red_team(original_prompt)
    secure_prompt = blue_agent_rewrite(original_prompt, findings)
    code_preview = generate_code_preview(secure_prompt)

    return {
        "original_prompt": original_prompt,
        "findings": findings,
        "secure_prompt": secure_prompt,
        "code_preview": code_preview,
    }
