# coding: utf-8

# flake8: noqa

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.0"

# Define package exports
__all__ = [
    "AdminKeyApi",
    "AncestorsApi",
    "AppPropertiesApi",
    "AttachmentApi",
    "BlogPostApi",
    "ChildrenApi",
    "ClassificationLevelApi",
    "CommentApi",
    "ContentApi",
    "ContentPropertiesApi",
    "CustomContentApi",
    "DataPoliciesApi",
    "DatabaseApi",
    "DescendantsApi",
    "EAPApi",
    "FolderApi",
    "LabelApi",
    "LikeApi",
    "OperationApi",
    "PageApi",
    "RedactionsApi",
    "SmartLinkApi",
    "SpaceApi",
    "SpacePermissionsApi",
    "SpacePropertiesApi",
    "SpaceRolesApi",
    "TaskApi",
    "UserApi",
    "VersionApi",
    "WhiteboardApi",
    "ApiResponse",
    "ApiClient",
    "Configuration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "AbstractPageLinks",
    "AccountStatus",
    "AccountType",
    "AdminKeyResponse",
    "Ancestor",
    "AncestorType",
    "AttachmentBulk",
    "AttachmentCommentModel",
    "AttachmentLinks",
    "AttachmentSingle",
    "AttachmentSingleLabels",
    "AttachmentSingleOperations",
    "AttachmentSingleProperties",
    "AttachmentSingleVersions",
    "AttachmentSortOrder",
    "AttachmentVersion",
    "BlogPostBodyWrite",
    "BlogPostBulk",
    "BlogPostCommentModel",
    "BlogPostContentStatus",
    "BlogPostInlineCommentModel",
    "BlogPostNestedBodyWrite",
    "BlogPostSingle",
    "BlogPostSingleLikes",
    "BlogPostSortOrder",
    "BlogPostVersion",
    "BodyBulk",
    "BodySingle",
    "BodyType",
    "CheckAccessByEmail200Response",
    "CheckAccessByEmailRequest",
    "ChildCustomContent",
    "ChildCustomContentSortOrder",
    "ChildPage",
    "ChildPageSortOrder",
    "ChildrenCommentModel",
    "ChildrenResponse",
    "ClassificationLevel",
    "ClassificationLevelColor",
    "ClassificationLevelStatus",
    "CommentBodyWrite",
    "CommentLinks",
    "CommentNestedBodyWrite",
    "CommentSortOrder",
    "CommentVersion",
    "ContentIdToContentTypeResponse",
    "ContentIdToContentTypeResponseResultsValue",
    "ContentProperty",
    "ContentPropertyCreateRequest",
    "ContentPropertySortOrder",
    "ContentPropertyUpdateRequest",
    "ContentPropertyUpdateRequestVersion",
    "ContentSortOrder",
    "ContentStatus",
    "ConvertContentIdsToContentTypesRequest",
    "ConvertContentIdsToContentTypesRequestContentIdsInner",
    "CreateBlogPost200Response",
    "CreateBlogPostRequest",
    "CreateBlogPostRequestBody",
    "CreateBulkUserLookupRequest",
    "CreateCustomContent201Response",
    "CreateCustomContentRequest",
    "CreateCustomContentRequestBody",
    "CreateDatabase200Response",
    "CreateDatabaseRequest",
    "CreateFolder200Response",
    "CreateFolderRequest",
    "CreateFooterComment201Response",
    "CreateFooterCommentModel",
    "CreateFooterCommentModelBody",
    "CreateInlineComment201Response",
    "CreateInlineCommentModel",
    "CreateInlineCommentModelInlineCommentProperties",
    "CreatePage200Response",
    "CreatePageRequest",
    "CreateSmartLink200Response",
    "CreateSmartLinkRequest",
    "CreateSpace201Response",
    "CreateSpaceRequest",
    "CreateSpaceRequestDescription",
    "CreateSpaceRequestRoleAssignmentsInner",
    "CreateSpaceRoleRequest",
    "CreateWhiteboard200Response",
    "CreateWhiteboardRequest",
    "CustomContentBodyBulk",
    "CustomContentBodyRepresentation",
    "CustomContentBodyRepresentationSingle",
    "CustomContentBodySingle",
    "CustomContentBodyWrite",
    "CustomContentBulk",
    "CustomContentCommentModel",
    "CustomContentLinks",
    "CustomContentNestedBodyWrite",
    "CustomContentSingle",
    "CustomContentSortOrder",
    "CustomContentVersion",
    "DataPolicyMetadata",
    "DataPolicySpace",
    "DataPolicySpaceDataPolicy",
    "DatabaseLinks",
    "DatabaseSingle",
    "DeleteSpaceRoleResponse",
    "DescendantsResponse",
    "DetailedVersion",
    "EnableAdminKeyRequest",
    "FolderLinks",
    "FolderSingle",
    "FooterCommentModel",
    "GetAttachmentById200Response",
    "GetAttachmentById200ResponseAllOfLinks",
    "GetForgeAppProperty200Response",
    "GetSpaceById200Response",
    "GetSpaceRoleMode200Response",
    "GetSpaceRolesById200Response",
    "Icon",
    "InlineCommentChildrenModel",
    "InlineCommentModel",
    "InlineCommentModelProperties",
    "InlineCommentProperties",
    "InlineCommentResolutionStatus",
    "Integer",
    "Label",
    "LabelSortOrder",
    "Like",
    "MultiEntityLinks",
    "MultiEntityResultAncestor",
    "MultiEntityResultAncestor1",
    "MultiEntityResultAppProperty",
    "MultiEntityResultAppPropertyResultsInner",
    "MultiEntityResultAttachment",
    "MultiEntityResultAttachmentCommentModel",
    "MultiEntityResultBlogPost",
    "MultiEntityResultBlogPostCommentModel",
    "MultiEntityResultBlogPostInlineCommentModel",
    "MultiEntityResultChildCustomContent",
    "MultiEntityResultChildPage",
    "MultiEntityResultChildrenCommentModel",
    "MultiEntityResultChildrenResponse",
    "MultiEntityResultContentProperty",
    "MultiEntityResultCustomContent",
    "MultiEntityResultCustomContentCommentModel",
    "MultiEntityResultDataPolicySpace",
    "MultiEntityResultDescendantsResponse",
    "MultiEntityResultFooterCommentModel",
    "MultiEntityResultInlineCommentChildrenModel",
    "MultiEntityResultInlineCommentModel",
    "MultiEntityResultLabel",
    "MultiEntityResultPage",
    "MultiEntityResultPageCommentModel",
    "MultiEntityResultPageInlineCommentModel",
    "MultiEntityResultSpace",
    "MultiEntityResultSpacePermission",
    "MultiEntityResultSpacePermissionAssignment",
    "MultiEntityResultSpaceProperty",
    "MultiEntityResultSpaceRole",
    "MultiEntityResultSpaceRoleAssignment",
    "MultiEntityResultString",
    "MultiEntityResultTask",
    "MultiEntityResultUser",
    "MultiEntityResultVersion",
    "MultiEntityResultVersion1",
    "MultiEntityResultVersion2",
    "MultiEntityResultVersion3",
    "MultiEntityResultVersion4",
    "OnlyArchivedAndCurrentContentStatus",
    "Operation",
    "OptionalFieldLinks",
    "OptionalFieldMeta",
    "PageBodyWrite",
    "PageBulk",
    "PageCommentModel",
    "PageInlineCommentModel",
    "PageSingle",
    "PageSortOrder",
    "PageVersion",
    "ParentContentType",
    "PermittedOperationsResponse",
    "PostPageClassificationLevelRequest",
    "PostRedactPageRequest",
    "PostRedactPageRequestBody",
    "PostWhiteboardClassificationLevelRequest",
    "PrimaryBodyRepresentation",
    "PrimaryBodyRepresentationSingle",
    "Principal",
    "PrincipalType",
    "PutPageClassificationLevelRequest",
    "PutSpaceDefaultClassificationLevelRequest",
    "PutWhiteboardClassificationLevelRequest",
    "Redaction",
    "RedactionPointer",
    "RedactionPointerResponse",
    "RedactionResponse",
    "RedactionSectionResponse",
    "RoleType",
    "SetSpaceRoleAssignmentsRequestInner",
    "SmartLinkLinks",
    "SmartLinkSingle",
    "SpaceBulk",
    "SpaceDescription",
    "SpaceDescriptionBodyRepresentation",
    "SpaceIcon",
    "SpaceLinks",
    "SpacePermission",
    "SpacePermissionAssignment",
    "SpacePermissionAssignmentOperation",
    "SpacePermissionAssignmentPrincipal",
    "SpaceProperty",
    "SpacePropertyCreateRequest",
    "SpacePropertyUpdateRequest",
    "SpacePropertyVersion",
    "SpaceRole",
    "SpaceRoleAssignment",
    "SpaceSingle",
    "SpaceSinglePermissions",
    "SpaceSingleProperties",
    "SpaceSortOrder",
    "SpaceStatus",
    "SpaceType",
    "Task",
    "TaskBodySingle",
    "UpdateBlogPostRequest",
    "UpdateBlogPostRequestVersion",
    "UpdateCustomContentRequest",
    "UpdateCustomContentRequestVersion",
    "UpdateFooterCommentModel",
    "UpdateFooterCommentModelVersion",
    "UpdateFooterCommentRequest",
    "UpdateInlineCommentModel",
    "UpdatePageRequest",
    "UpdatePageRequestVersion",
    "UpdatePageTitleRequest",
    "UpdateSpaceRoleRequest",
    "UpdateSpaceRoleResponse",
    "UpdateTaskRequest",
    "User",
    "Version",
    "VersionSortOrder",
    "VersionedEntity",
    "WhiteboardLinks",
    "WhiteboardSingle",
]

# import apis into sdk package
from devopso.clients.confluence_cloud.api.admin_key_api import AdminKeyApi as AdminKeyApi
from devopso.clients.confluence_cloud.api.ancestors_api import AncestorsApi as AncestorsApi
from devopso.clients.confluence_cloud.api.app_properties_api import AppPropertiesApi as AppPropertiesApi
from devopso.clients.confluence_cloud.api.attachment_api import AttachmentApi as AttachmentApi
from devopso.clients.confluence_cloud.api.blog_post_api import BlogPostApi as BlogPostApi
from devopso.clients.confluence_cloud.api.children_api import ChildrenApi as ChildrenApi
from devopso.clients.confluence_cloud.api.classification_level_api import ClassificationLevelApi as ClassificationLevelApi
from devopso.clients.confluence_cloud.api.comment_api import CommentApi as CommentApi
from devopso.clients.confluence_cloud.api.content_api import ContentApi as ContentApi
from devopso.clients.confluence_cloud.api.content_properties_api import ContentPropertiesApi as ContentPropertiesApi
from devopso.clients.confluence_cloud.api.custom_content_api import CustomContentApi as CustomContentApi
from devopso.clients.confluence_cloud.api.data_policies_api import DataPoliciesApi as DataPoliciesApi
from devopso.clients.confluence_cloud.api.database_api import DatabaseApi as DatabaseApi
from devopso.clients.confluence_cloud.api.descendants_api import DescendantsApi as DescendantsApi
from devopso.clients.confluence_cloud.api.eap_api import EAPApi as EAPApi
from devopso.clients.confluence_cloud.api.folder_api import FolderApi as FolderApi
from devopso.clients.confluence_cloud.api.label_api import LabelApi as LabelApi
from devopso.clients.confluence_cloud.api.like_api import LikeApi as LikeApi
from devopso.clients.confluence_cloud.api.operation_api import OperationApi as OperationApi
from devopso.clients.confluence_cloud.api.page_api import PageApi as PageApi
from devopso.clients.confluence_cloud.api.redactions_api import RedactionsApi as RedactionsApi
from devopso.clients.confluence_cloud.api.smart_link_api import SmartLinkApi as SmartLinkApi
from devopso.clients.confluence_cloud.api.space_api import SpaceApi as SpaceApi
from devopso.clients.confluence_cloud.api.space_permissions_api import SpacePermissionsApi as SpacePermissionsApi
from devopso.clients.confluence_cloud.api.space_properties_api import SpacePropertiesApi as SpacePropertiesApi
from devopso.clients.confluence_cloud.api.space_roles_api import SpaceRolesApi as SpaceRolesApi
from devopso.clients.confluence_cloud.api.task_api import TaskApi as TaskApi
from devopso.clients.confluence_cloud.api.user_api import UserApi as UserApi
from devopso.clients.confluence_cloud.api.version_api import VersionApi as VersionApi
from devopso.clients.confluence_cloud.api.whiteboard_api import WhiteboardApi as WhiteboardApi

# import ApiClient
from devopso.clients.confluence_cloud.api_response import ApiResponse as ApiResponse
from devopso.clients.confluence_cloud.api_client import ApiClient as ApiClient
from devopso.clients.confluence_cloud.configuration import Configuration as Configuration
from devopso.clients.confluence_cloud.exceptions import OpenApiException as OpenApiException
from devopso.clients.confluence_cloud.exceptions import ApiTypeError as ApiTypeError
from devopso.clients.confluence_cloud.exceptions import ApiValueError as ApiValueError
from devopso.clients.confluence_cloud.exceptions import ApiKeyError as ApiKeyError
from devopso.clients.confluence_cloud.exceptions import ApiAttributeError as ApiAttributeError
from devopso.clients.confluence_cloud.exceptions import ApiException as ApiException

# import models into sdk package
from devopso.clients.confluence_cloud.models.abstract_page_links import AbstractPageLinks as AbstractPageLinks
from devopso.clients.confluence_cloud.models.account_status import AccountStatus as AccountStatus
from devopso.clients.confluence_cloud.models.account_type import AccountType as AccountType
from devopso.clients.confluence_cloud.models.admin_key_response import AdminKeyResponse as AdminKeyResponse
from devopso.clients.confluence_cloud.models.ancestor import Ancestor as Ancestor
from devopso.clients.confluence_cloud.models.ancestor_type import AncestorType as AncestorType
from devopso.clients.confluence_cloud.models.attachment_bulk import AttachmentBulk as AttachmentBulk
from devopso.clients.confluence_cloud.models.attachment_comment_model import AttachmentCommentModel as AttachmentCommentModel
from devopso.clients.confluence_cloud.models.attachment_links import AttachmentLinks as AttachmentLinks
from devopso.clients.confluence_cloud.models.attachment_single import AttachmentSingle as AttachmentSingle
from devopso.clients.confluence_cloud.models.attachment_single_labels import AttachmentSingleLabels as AttachmentSingleLabels
from devopso.clients.confluence_cloud.models.attachment_single_operations import AttachmentSingleOperations as AttachmentSingleOperations
from devopso.clients.confluence_cloud.models.attachment_single_properties import AttachmentSingleProperties as AttachmentSingleProperties
from devopso.clients.confluence_cloud.models.attachment_single_versions import AttachmentSingleVersions as AttachmentSingleVersions
from devopso.clients.confluence_cloud.models.attachment_sort_order import AttachmentSortOrder as AttachmentSortOrder
from devopso.clients.confluence_cloud.models.attachment_version import AttachmentVersion as AttachmentVersion
from devopso.clients.confluence_cloud.models.blog_post_body_write import BlogPostBodyWrite as BlogPostBodyWrite
from devopso.clients.confluence_cloud.models.blog_post_bulk import BlogPostBulk as BlogPostBulk
from devopso.clients.confluence_cloud.models.blog_post_comment_model import BlogPostCommentModel as BlogPostCommentModel
from devopso.clients.confluence_cloud.models.blog_post_content_status import BlogPostContentStatus as BlogPostContentStatus
from devopso.clients.confluence_cloud.models.blog_post_inline_comment_model import BlogPostInlineCommentModel as BlogPostInlineCommentModel
from devopso.clients.confluence_cloud.models.blog_post_nested_body_write import BlogPostNestedBodyWrite as BlogPostNestedBodyWrite
from devopso.clients.confluence_cloud.models.blog_post_single import BlogPostSingle as BlogPostSingle
from devopso.clients.confluence_cloud.models.blog_post_single_likes import BlogPostSingleLikes as BlogPostSingleLikes
from devopso.clients.confluence_cloud.models.blog_post_sort_order import BlogPostSortOrder as BlogPostSortOrder
from devopso.clients.confluence_cloud.models.blog_post_version import BlogPostVersion as BlogPostVersion
from devopso.clients.confluence_cloud.models.body_bulk import BodyBulk as BodyBulk
from devopso.clients.confluence_cloud.models.body_single import BodySingle as BodySingle
from devopso.clients.confluence_cloud.models.body_type import BodyType as BodyType
from devopso.clients.confluence_cloud.models.check_access_by_email200_response import CheckAccessByEmail200Response as CheckAccessByEmail200Response
from devopso.clients.confluence_cloud.models.check_access_by_email_request import CheckAccessByEmailRequest as CheckAccessByEmailRequest
from devopso.clients.confluence_cloud.models.child_custom_content import ChildCustomContent as ChildCustomContent
from devopso.clients.confluence_cloud.models.child_custom_content_sort_order import ChildCustomContentSortOrder as ChildCustomContentSortOrder
from devopso.clients.confluence_cloud.models.child_page import ChildPage as ChildPage
from devopso.clients.confluence_cloud.models.child_page_sort_order import ChildPageSortOrder as ChildPageSortOrder
from devopso.clients.confluence_cloud.models.children_comment_model import ChildrenCommentModel as ChildrenCommentModel
from devopso.clients.confluence_cloud.models.children_response import ChildrenResponse as ChildrenResponse
from devopso.clients.confluence_cloud.models.classification_level import ClassificationLevel as ClassificationLevel
from devopso.clients.confluence_cloud.models.classification_level_color import ClassificationLevelColor as ClassificationLevelColor
from devopso.clients.confluence_cloud.models.classification_level_status import ClassificationLevelStatus as ClassificationLevelStatus
from devopso.clients.confluence_cloud.models.comment_body_write import CommentBodyWrite as CommentBodyWrite
from devopso.clients.confluence_cloud.models.comment_links import CommentLinks as CommentLinks
from devopso.clients.confluence_cloud.models.comment_nested_body_write import CommentNestedBodyWrite as CommentNestedBodyWrite
from devopso.clients.confluence_cloud.models.comment_sort_order import CommentSortOrder as CommentSortOrder
from devopso.clients.confluence_cloud.models.comment_version import CommentVersion as CommentVersion
from devopso.clients.confluence_cloud.models.content_id_to_content_type_response import ContentIdToContentTypeResponse as ContentIdToContentTypeResponse
from devopso.clients.confluence_cloud.models.content_id_to_content_type_response_results_value import ContentIdToContentTypeResponseResultsValue as ContentIdToContentTypeResponseResultsValue
from devopso.clients.confluence_cloud.models.content_property import ContentProperty as ContentProperty
from devopso.clients.confluence_cloud.models.content_property_create_request import ContentPropertyCreateRequest as ContentPropertyCreateRequest
from devopso.clients.confluence_cloud.models.content_property_sort_order import ContentPropertySortOrder as ContentPropertySortOrder
from devopso.clients.confluence_cloud.models.content_property_update_request import ContentPropertyUpdateRequest as ContentPropertyUpdateRequest
from devopso.clients.confluence_cloud.models.content_property_update_request_version import ContentPropertyUpdateRequestVersion as ContentPropertyUpdateRequestVersion
from devopso.clients.confluence_cloud.models.content_sort_order import ContentSortOrder as ContentSortOrder
from devopso.clients.confluence_cloud.models.content_status import ContentStatus as ContentStatus
from devopso.clients.confluence_cloud.models.convert_content_ids_to_content_types_request import ConvertContentIdsToContentTypesRequest as ConvertContentIdsToContentTypesRequest
from devopso.clients.confluence_cloud.models.convert_content_ids_to_content_types_request_content_ids_inner import ConvertContentIdsToContentTypesRequestContentIdsInner as ConvertContentIdsToContentTypesRequestContentIdsInner
from devopso.clients.confluence_cloud.models.create_blog_post200_response import CreateBlogPost200Response as CreateBlogPost200Response
from devopso.clients.confluence_cloud.models.create_blog_post_request import CreateBlogPostRequest as CreateBlogPostRequest
from devopso.clients.confluence_cloud.models.create_blog_post_request_body import CreateBlogPostRequestBody as CreateBlogPostRequestBody
from devopso.clients.confluence_cloud.models.create_bulk_user_lookup_request import CreateBulkUserLookupRequest as CreateBulkUserLookupRequest
from devopso.clients.confluence_cloud.models.create_custom_content201_response import CreateCustomContent201Response as CreateCustomContent201Response
from devopso.clients.confluence_cloud.models.create_custom_content_request import CreateCustomContentRequest as CreateCustomContentRequest
from devopso.clients.confluence_cloud.models.create_custom_content_request_body import CreateCustomContentRequestBody as CreateCustomContentRequestBody
from devopso.clients.confluence_cloud.models.create_database200_response import CreateDatabase200Response as CreateDatabase200Response
from devopso.clients.confluence_cloud.models.create_database_request import CreateDatabaseRequest as CreateDatabaseRequest
from devopso.clients.confluence_cloud.models.create_folder200_response import CreateFolder200Response as CreateFolder200Response
from devopso.clients.confluence_cloud.models.create_folder_request import CreateFolderRequest as CreateFolderRequest
from devopso.clients.confluence_cloud.models.create_footer_comment201_response import CreateFooterComment201Response as CreateFooterComment201Response
from devopso.clients.confluence_cloud.models.create_footer_comment_model import CreateFooterCommentModel as CreateFooterCommentModel
from devopso.clients.confluence_cloud.models.create_footer_comment_model_body import CreateFooterCommentModelBody as CreateFooterCommentModelBody
from devopso.clients.confluence_cloud.models.create_inline_comment201_response import CreateInlineComment201Response as CreateInlineComment201Response
from devopso.clients.confluence_cloud.models.create_inline_comment_model import CreateInlineCommentModel as CreateInlineCommentModel
from devopso.clients.confluence_cloud.models.create_inline_comment_model_inline_comment_properties import CreateInlineCommentModelInlineCommentProperties as CreateInlineCommentModelInlineCommentProperties
from devopso.clients.confluence_cloud.models.create_page200_response import CreatePage200Response as CreatePage200Response
from devopso.clients.confluence_cloud.models.create_page_request import CreatePageRequest as CreatePageRequest
from devopso.clients.confluence_cloud.models.create_smart_link200_response import CreateSmartLink200Response as CreateSmartLink200Response
from devopso.clients.confluence_cloud.models.create_smart_link_request import CreateSmartLinkRequest as CreateSmartLinkRequest
from devopso.clients.confluence_cloud.models.create_space201_response import CreateSpace201Response as CreateSpace201Response
from devopso.clients.confluence_cloud.models.create_space_request import CreateSpaceRequest as CreateSpaceRequest
from devopso.clients.confluence_cloud.models.create_space_request_description import CreateSpaceRequestDescription as CreateSpaceRequestDescription
from devopso.clients.confluence_cloud.models.create_space_request_role_assignments_inner import CreateSpaceRequestRoleAssignmentsInner as CreateSpaceRequestRoleAssignmentsInner
from devopso.clients.confluence_cloud.models.create_space_role_request import CreateSpaceRoleRequest as CreateSpaceRoleRequest
from devopso.clients.confluence_cloud.models.create_whiteboard200_response import CreateWhiteboard200Response as CreateWhiteboard200Response
from devopso.clients.confluence_cloud.models.create_whiteboard_request import CreateWhiteboardRequest as CreateWhiteboardRequest
from devopso.clients.confluence_cloud.models.custom_content_body_bulk import CustomContentBodyBulk as CustomContentBodyBulk
from devopso.clients.confluence_cloud.models.custom_content_body_representation import CustomContentBodyRepresentation as CustomContentBodyRepresentation
from devopso.clients.confluence_cloud.models.custom_content_body_representation_single import CustomContentBodyRepresentationSingle as CustomContentBodyRepresentationSingle
from devopso.clients.confluence_cloud.models.custom_content_body_single import CustomContentBodySingle as CustomContentBodySingle
from devopso.clients.confluence_cloud.models.custom_content_body_write import CustomContentBodyWrite as CustomContentBodyWrite
from devopso.clients.confluence_cloud.models.custom_content_bulk import CustomContentBulk as CustomContentBulk
from devopso.clients.confluence_cloud.models.custom_content_comment_model import CustomContentCommentModel as CustomContentCommentModel
from devopso.clients.confluence_cloud.models.custom_content_links import CustomContentLinks as CustomContentLinks
from devopso.clients.confluence_cloud.models.custom_content_nested_body_write import CustomContentNestedBodyWrite as CustomContentNestedBodyWrite
from devopso.clients.confluence_cloud.models.custom_content_single import CustomContentSingle as CustomContentSingle
from devopso.clients.confluence_cloud.models.custom_content_sort_order import CustomContentSortOrder as CustomContentSortOrder
from devopso.clients.confluence_cloud.models.custom_content_version import CustomContentVersion as CustomContentVersion
from devopso.clients.confluence_cloud.models.data_policy_metadata import DataPolicyMetadata as DataPolicyMetadata
from devopso.clients.confluence_cloud.models.data_policy_space import DataPolicySpace as DataPolicySpace
from devopso.clients.confluence_cloud.models.data_policy_space_data_policy import DataPolicySpaceDataPolicy as DataPolicySpaceDataPolicy
from devopso.clients.confluence_cloud.models.database_links import DatabaseLinks as DatabaseLinks
from devopso.clients.confluence_cloud.models.database_single import DatabaseSingle as DatabaseSingle
from devopso.clients.confluence_cloud.models.delete_space_role_response import DeleteSpaceRoleResponse as DeleteSpaceRoleResponse
from devopso.clients.confluence_cloud.models.descendants_response import DescendantsResponse as DescendantsResponse
from devopso.clients.confluence_cloud.models.detailed_version import DetailedVersion as DetailedVersion
from devopso.clients.confluence_cloud.models.enable_admin_key_request import EnableAdminKeyRequest as EnableAdminKeyRequest
from devopso.clients.confluence_cloud.models.folder_links import FolderLinks as FolderLinks
from devopso.clients.confluence_cloud.models.folder_single import FolderSingle as FolderSingle
from devopso.clients.confluence_cloud.models.footer_comment_model import FooterCommentModel as FooterCommentModel
from devopso.clients.confluence_cloud.models.get_attachment_by_id200_response import GetAttachmentById200Response as GetAttachmentById200Response
from devopso.clients.confluence_cloud.models.get_attachment_by_id200_response_all_of_links import GetAttachmentById200ResponseAllOfLinks as GetAttachmentById200ResponseAllOfLinks
from devopso.clients.confluence_cloud.models.get_forge_app_property200_response import GetForgeAppProperty200Response as GetForgeAppProperty200Response
from devopso.clients.confluence_cloud.models.get_space_by_id200_response import GetSpaceById200Response as GetSpaceById200Response
from devopso.clients.confluence_cloud.models.get_space_role_mode200_response import GetSpaceRoleMode200Response as GetSpaceRoleMode200Response
from devopso.clients.confluence_cloud.models.get_space_roles_by_id200_response import GetSpaceRolesById200Response as GetSpaceRolesById200Response
from devopso.clients.confluence_cloud.models.icon import Icon as Icon
from devopso.clients.confluence_cloud.models.inline_comment_children_model import InlineCommentChildrenModel as InlineCommentChildrenModel
from devopso.clients.confluence_cloud.models.inline_comment_model import InlineCommentModel as InlineCommentModel
from devopso.clients.confluence_cloud.models.inline_comment_model_properties import InlineCommentModelProperties as InlineCommentModelProperties
from devopso.clients.confluence_cloud.models.inline_comment_properties import InlineCommentProperties as InlineCommentProperties
from devopso.clients.confluence_cloud.models.inline_comment_resolution_status import InlineCommentResolutionStatus as InlineCommentResolutionStatus
from devopso.clients.confluence_cloud.models.integer import Integer as Integer
from devopso.clients.confluence_cloud.models.label import Label as Label
from devopso.clients.confluence_cloud.models.label_sort_order import LabelSortOrder as LabelSortOrder
from devopso.clients.confluence_cloud.models.like import Like as Like
from devopso.clients.confluence_cloud.models.multi_entity_links import MultiEntityLinks as MultiEntityLinks
from devopso.clients.confluence_cloud.models.multi_entity_result_ancestor import MultiEntityResultAncestor as MultiEntityResultAncestor
from devopso.clients.confluence_cloud.models.multi_entity_result_ancestor1 import MultiEntityResultAncestor1 as MultiEntityResultAncestor1
from devopso.clients.confluence_cloud.models.multi_entity_result_app_property import MultiEntityResultAppProperty as MultiEntityResultAppProperty
from devopso.clients.confluence_cloud.models.multi_entity_result_app_property_results_inner import MultiEntityResultAppPropertyResultsInner as MultiEntityResultAppPropertyResultsInner
from devopso.clients.confluence_cloud.models.multi_entity_result_attachment import MultiEntityResultAttachment as MultiEntityResultAttachment
from devopso.clients.confluence_cloud.models.multi_entity_result_attachment_comment_model import MultiEntityResultAttachmentCommentModel as MultiEntityResultAttachmentCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_blog_post import MultiEntityResultBlogPost as MultiEntityResultBlogPost
from devopso.clients.confluence_cloud.models.multi_entity_result_blog_post_comment_model import MultiEntityResultBlogPostCommentModel as MultiEntityResultBlogPostCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_blog_post_inline_comment_model import MultiEntityResultBlogPostInlineCommentModel as MultiEntityResultBlogPostInlineCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_child_custom_content import MultiEntityResultChildCustomContent as MultiEntityResultChildCustomContent
from devopso.clients.confluence_cloud.models.multi_entity_result_child_page import MultiEntityResultChildPage as MultiEntityResultChildPage
from devopso.clients.confluence_cloud.models.multi_entity_result_children_comment_model import MultiEntityResultChildrenCommentModel as MultiEntityResultChildrenCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_children_response import MultiEntityResultChildrenResponse as MultiEntityResultChildrenResponse
from devopso.clients.confluence_cloud.models.multi_entity_result_content_property import MultiEntityResultContentProperty as MultiEntityResultContentProperty
from devopso.clients.confluence_cloud.models.multi_entity_result_custom_content import MultiEntityResultCustomContent as MultiEntityResultCustomContent
from devopso.clients.confluence_cloud.models.multi_entity_result_custom_content_comment_model import MultiEntityResultCustomContentCommentModel as MultiEntityResultCustomContentCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_data_policy_space import MultiEntityResultDataPolicySpace as MultiEntityResultDataPolicySpace
from devopso.clients.confluence_cloud.models.multi_entity_result_descendants_response import MultiEntityResultDescendantsResponse as MultiEntityResultDescendantsResponse
from devopso.clients.confluence_cloud.models.multi_entity_result_footer_comment_model import MultiEntityResultFooterCommentModel as MultiEntityResultFooterCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_inline_comment_children_model import MultiEntityResultInlineCommentChildrenModel as MultiEntityResultInlineCommentChildrenModel
from devopso.clients.confluence_cloud.models.multi_entity_result_inline_comment_model import MultiEntityResultInlineCommentModel as MultiEntityResultInlineCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_label import MultiEntityResultLabel as MultiEntityResultLabel
from devopso.clients.confluence_cloud.models.multi_entity_result_page import MultiEntityResultPage as MultiEntityResultPage
from devopso.clients.confluence_cloud.models.multi_entity_result_page_comment_model import MultiEntityResultPageCommentModel as MultiEntityResultPageCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_page_inline_comment_model import MultiEntityResultPageInlineCommentModel as MultiEntityResultPageInlineCommentModel
from devopso.clients.confluence_cloud.models.multi_entity_result_space import MultiEntityResultSpace as MultiEntityResultSpace
from devopso.clients.confluence_cloud.models.multi_entity_result_space_permission import MultiEntityResultSpacePermission as MultiEntityResultSpacePermission
from devopso.clients.confluence_cloud.models.multi_entity_result_space_permission_assignment import MultiEntityResultSpacePermissionAssignment as MultiEntityResultSpacePermissionAssignment
from devopso.clients.confluence_cloud.models.multi_entity_result_space_property import MultiEntityResultSpaceProperty as MultiEntityResultSpaceProperty
from devopso.clients.confluence_cloud.models.multi_entity_result_space_role import MultiEntityResultSpaceRole as MultiEntityResultSpaceRole
from devopso.clients.confluence_cloud.models.multi_entity_result_space_role_assignment import MultiEntityResultSpaceRoleAssignment as MultiEntityResultSpaceRoleAssignment
from devopso.clients.confluence_cloud.models.multi_entity_result_string import MultiEntityResultString as MultiEntityResultString
from devopso.clients.confluence_cloud.models.multi_entity_result_task import MultiEntityResultTask as MultiEntityResultTask
from devopso.clients.confluence_cloud.models.multi_entity_result_user import MultiEntityResultUser as MultiEntityResultUser
from devopso.clients.confluence_cloud.models.multi_entity_result_version import MultiEntityResultVersion as MultiEntityResultVersion
from devopso.clients.confluence_cloud.models.multi_entity_result_version1 import MultiEntityResultVersion1 as MultiEntityResultVersion1
from devopso.clients.confluence_cloud.models.multi_entity_result_version2 import MultiEntityResultVersion2 as MultiEntityResultVersion2
from devopso.clients.confluence_cloud.models.multi_entity_result_version3 import MultiEntityResultVersion3 as MultiEntityResultVersion3
from devopso.clients.confluence_cloud.models.multi_entity_result_version4 import MultiEntityResultVersion4 as MultiEntityResultVersion4
from devopso.clients.confluence_cloud.models.only_archived_and_current_content_status import OnlyArchivedAndCurrentContentStatus as OnlyArchivedAndCurrentContentStatus
from devopso.clients.confluence_cloud.models.operation import Operation as Operation
from devopso.clients.confluence_cloud.models.optional_field_links import OptionalFieldLinks as OptionalFieldLinks
from devopso.clients.confluence_cloud.models.optional_field_meta import OptionalFieldMeta as OptionalFieldMeta
from devopso.clients.confluence_cloud.models.page_body_write import PageBodyWrite as PageBodyWrite
from devopso.clients.confluence_cloud.models.page_bulk import PageBulk as PageBulk
from devopso.clients.confluence_cloud.models.page_comment_model import PageCommentModel as PageCommentModel
from devopso.clients.confluence_cloud.models.page_inline_comment_model import PageInlineCommentModel as PageInlineCommentModel
from devopso.clients.confluence_cloud.models.page_single import PageSingle as PageSingle
from devopso.clients.confluence_cloud.models.page_sort_order import PageSortOrder as PageSortOrder
from devopso.clients.confluence_cloud.models.page_version import PageVersion as PageVersion
from devopso.clients.confluence_cloud.models.parent_content_type import ParentContentType as ParentContentType
from devopso.clients.confluence_cloud.models.permitted_operations_response import PermittedOperationsResponse as PermittedOperationsResponse
from devopso.clients.confluence_cloud.models.post_page_classification_level_request import PostPageClassificationLevelRequest as PostPageClassificationLevelRequest
from devopso.clients.confluence_cloud.models.post_redact_page_request import PostRedactPageRequest as PostRedactPageRequest
from devopso.clients.confluence_cloud.models.post_redact_page_request_body import PostRedactPageRequestBody as PostRedactPageRequestBody
from devopso.clients.confluence_cloud.models.post_whiteboard_classification_level_request import PostWhiteboardClassificationLevelRequest as PostWhiteboardClassificationLevelRequest
from devopso.clients.confluence_cloud.models.primary_body_representation import PrimaryBodyRepresentation as PrimaryBodyRepresentation
from devopso.clients.confluence_cloud.models.primary_body_representation_single import PrimaryBodyRepresentationSingle as PrimaryBodyRepresentationSingle
from devopso.clients.confluence_cloud.models.principal import Principal as Principal
from devopso.clients.confluence_cloud.models.principal_type import PrincipalType as PrincipalType
from devopso.clients.confluence_cloud.models.put_page_classification_level_request import PutPageClassificationLevelRequest as PutPageClassificationLevelRequest
from devopso.clients.confluence_cloud.models.put_space_default_classification_level_request import PutSpaceDefaultClassificationLevelRequest as PutSpaceDefaultClassificationLevelRequest
from devopso.clients.confluence_cloud.models.put_whiteboard_classification_level_request import PutWhiteboardClassificationLevelRequest as PutWhiteboardClassificationLevelRequest
from devopso.clients.confluence_cloud.models.redaction import Redaction as Redaction
from devopso.clients.confluence_cloud.models.redaction_pointer import RedactionPointer as RedactionPointer
from devopso.clients.confluence_cloud.models.redaction_pointer_response import RedactionPointerResponse as RedactionPointerResponse
from devopso.clients.confluence_cloud.models.redaction_response import RedactionResponse as RedactionResponse
from devopso.clients.confluence_cloud.models.redaction_section_response import RedactionSectionResponse as RedactionSectionResponse
from devopso.clients.confluence_cloud.models.role_type import RoleType as RoleType
from devopso.clients.confluence_cloud.models.set_space_role_assignments_request_inner import SetSpaceRoleAssignmentsRequestInner as SetSpaceRoleAssignmentsRequestInner
from devopso.clients.confluence_cloud.models.smart_link_links import SmartLinkLinks as SmartLinkLinks
from devopso.clients.confluence_cloud.models.smart_link_single import SmartLinkSingle as SmartLinkSingle
from devopso.clients.confluence_cloud.models.space_bulk import SpaceBulk as SpaceBulk
from devopso.clients.confluence_cloud.models.space_description import SpaceDescription as SpaceDescription
from devopso.clients.confluence_cloud.models.space_description_body_representation import SpaceDescriptionBodyRepresentation as SpaceDescriptionBodyRepresentation
from devopso.clients.confluence_cloud.models.space_icon import SpaceIcon as SpaceIcon
from devopso.clients.confluence_cloud.models.space_links import SpaceLinks as SpaceLinks
from devopso.clients.confluence_cloud.models.space_permission import SpacePermission as SpacePermission
from devopso.clients.confluence_cloud.models.space_permission_assignment import SpacePermissionAssignment as SpacePermissionAssignment
from devopso.clients.confluence_cloud.models.space_permission_assignment_operation import SpacePermissionAssignmentOperation as SpacePermissionAssignmentOperation
from devopso.clients.confluence_cloud.models.space_permission_assignment_principal import SpacePermissionAssignmentPrincipal as SpacePermissionAssignmentPrincipal
from devopso.clients.confluence_cloud.models.space_property import SpaceProperty as SpaceProperty
from devopso.clients.confluence_cloud.models.space_property_create_request import SpacePropertyCreateRequest as SpacePropertyCreateRequest
from devopso.clients.confluence_cloud.models.space_property_update_request import SpacePropertyUpdateRequest as SpacePropertyUpdateRequest
from devopso.clients.confluence_cloud.models.space_property_version import SpacePropertyVersion as SpacePropertyVersion
from devopso.clients.confluence_cloud.models.space_role import SpaceRole as SpaceRole
from devopso.clients.confluence_cloud.models.space_role_assignment import SpaceRoleAssignment as SpaceRoleAssignment
from devopso.clients.confluence_cloud.models.space_single import SpaceSingle as SpaceSingle
from devopso.clients.confluence_cloud.models.space_single_permissions import SpaceSinglePermissions as SpaceSinglePermissions
from devopso.clients.confluence_cloud.models.space_single_properties import SpaceSingleProperties as SpaceSingleProperties
from devopso.clients.confluence_cloud.models.space_sort_order import SpaceSortOrder as SpaceSortOrder
from devopso.clients.confluence_cloud.models.space_status import SpaceStatus as SpaceStatus
from devopso.clients.confluence_cloud.models.space_type import SpaceType as SpaceType
from devopso.clients.confluence_cloud.models.task import Task as Task
from devopso.clients.confluence_cloud.models.task_body_single import TaskBodySingle as TaskBodySingle
from devopso.clients.confluence_cloud.models.update_blog_post_request import UpdateBlogPostRequest as UpdateBlogPostRequest
from devopso.clients.confluence_cloud.models.update_blog_post_request_version import UpdateBlogPostRequestVersion as UpdateBlogPostRequestVersion
from devopso.clients.confluence_cloud.models.update_custom_content_request import UpdateCustomContentRequest as UpdateCustomContentRequest
from devopso.clients.confluence_cloud.models.update_custom_content_request_version import UpdateCustomContentRequestVersion as UpdateCustomContentRequestVersion
from devopso.clients.confluence_cloud.models.update_footer_comment_model import UpdateFooterCommentModel as UpdateFooterCommentModel
from devopso.clients.confluence_cloud.models.update_footer_comment_model_version import UpdateFooterCommentModelVersion as UpdateFooterCommentModelVersion
from devopso.clients.confluence_cloud.models.update_footer_comment_request import UpdateFooterCommentRequest as UpdateFooterCommentRequest
from devopso.clients.confluence_cloud.models.update_inline_comment_model import UpdateInlineCommentModel as UpdateInlineCommentModel
from devopso.clients.confluence_cloud.models.update_page_request import UpdatePageRequest as UpdatePageRequest
from devopso.clients.confluence_cloud.models.update_page_request_version import UpdatePageRequestVersion as UpdatePageRequestVersion
from devopso.clients.confluence_cloud.models.update_page_title_request import UpdatePageTitleRequest as UpdatePageTitleRequest
from devopso.clients.confluence_cloud.models.update_space_role_request import UpdateSpaceRoleRequest as UpdateSpaceRoleRequest
from devopso.clients.confluence_cloud.models.update_space_role_response import UpdateSpaceRoleResponse as UpdateSpaceRoleResponse
from devopso.clients.confluence_cloud.models.update_task_request import UpdateTaskRequest as UpdateTaskRequest
from devopso.clients.confluence_cloud.models.user import User as User
from devopso.clients.confluence_cloud.models.version import Version as Version
from devopso.clients.confluence_cloud.models.version_sort_order import VersionSortOrder as VersionSortOrder
from devopso.clients.confluence_cloud.models.versioned_entity import VersionedEntity as VersionedEntity
from devopso.clients.confluence_cloud.models.whiteboard_links import WhiteboardLinks as WhiteboardLinks
from devopso.clients.confluence_cloud.models.whiteboard_single import WhiteboardSingle as WhiteboardSingle

