# coding: utf-8

"""
    The Confluence Cloud REST API v2

    This document describes Confluence's v2 APIs. This is intended to be an iteration on the existing Confluence Cloud REST API with improvements in both endpoint definitions and performance.

    The version of the OpenAPI document: 2.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from devopso.clients.confluence_cloud.models.blog_post_sort_order import BlogPostSortOrder
from devopso.clients.confluence_cloud.models.create_blog_post200_response import CreateBlogPost200Response
from devopso.clients.confluence_cloud.models.create_blog_post_request import CreateBlogPostRequest
from devopso.clients.confluence_cloud.models.multi_entity_result_blog_post import MultiEntityResultBlogPost
from devopso.clients.confluence_cloud.models.primary_body_representation import PrimaryBodyRepresentation
from devopso.clients.confluence_cloud.models.primary_body_representation_single import PrimaryBodyRepresentationSingle
from devopso.clients.confluence_cloud.models.update_blog_post_request import UpdateBlogPostRequest

from devopso.clients.confluence_cloud.api_client import ApiClient, RequestSerialized
from devopso.clients.confluence_cloud.api_response import ApiResponse
from devopso.clients.confluence_cloud.rest import RESTResponseType


class BlogPostApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_blog_post(
        self,
        create_blog_post_request: CreateBlogPostRequest,
        private: Annotated[Optional[StrictBool], Field(description="The blog post will be private. Only the user who creates this blog post will have permission to view and edit one.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateBlogPost200Response:
        """Create blog post

        Creates a new blog post in the space specified by the spaceId.  By default this will create the blog post as a non-draft, unless the status is specified as draft. If creating a non-draft, the title must not be empty.  Currently only supports the storage representation specified in the body.representation enums below

        :param create_blog_post_request: (required)
        :type create_blog_post_request: CreateBlogPostRequest
        :param private: The blog post will be private. Only the user who creates this blog post will have permission to view and edit one.
        :type private: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_blog_post_serialize(
            create_blog_post_request=create_blog_post_request,
            private=private,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_blog_post_with_http_info(
        self,
        create_blog_post_request: CreateBlogPostRequest,
        private: Annotated[Optional[StrictBool], Field(description="The blog post will be private. Only the user who creates this blog post will have permission to view and edit one.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateBlogPost200Response]:
        """Create blog post

        Creates a new blog post in the space specified by the spaceId.  By default this will create the blog post as a non-draft, unless the status is specified as draft. If creating a non-draft, the title must not be empty.  Currently only supports the storage representation specified in the body.representation enums below

        :param create_blog_post_request: (required)
        :type create_blog_post_request: CreateBlogPostRequest
        :param private: The blog post will be private. Only the user who creates this blog post will have permission to view and edit one.
        :type private: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_blog_post_serialize(
            create_blog_post_request=create_blog_post_request,
            private=private,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_blog_post_without_preload_content(
        self,
        create_blog_post_request: CreateBlogPostRequest,
        private: Annotated[Optional[StrictBool], Field(description="The blog post will be private. Only the user who creates this blog post will have permission to view and edit one.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create blog post

        Creates a new blog post in the space specified by the spaceId.  By default this will create the blog post as a non-draft, unless the status is specified as draft. If creating a non-draft, the title must not be empty.  Currently only supports the storage representation specified in the body.representation enums below

        :param create_blog_post_request: (required)
        :type create_blog_post_request: CreateBlogPostRequest
        :param private: The blog post will be private. Only the user who creates this blog post will have permission to view and edit one.
        :type private: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_blog_post_serialize(
            create_blog_post_request=create_blog_post_request,
            private=private,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
            '413': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_blog_post_serialize(
        self,
        create_blog_post_request,
        private,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if private is not None:
            
            _query_params.append(('private', private))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if create_blog_post_request is not None:
            _body_params = create_blog_post_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/blogposts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_blog_post(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be deleted.")],
        purge: Annotated[Optional[StrictBool], Field(description="If attempting to purge the blog post.")] = None,
        draft: Annotated[Optional[StrictBool], Field(description="If attempting to delete a blog post that is a draft.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete blog post

        Delete a blog post by id.  By default this will delete blog posts that are non-drafts. To delete a blog post that is a draft, the endpoint must be called on a  draft with the following param `draft=true`. Discarded drafts are not sent to the trash and are permanently deleted.  Deleting a blog post that is not a draft moves the blog post to the trash, where it can be restored later. To permanently delete a blog post (or \"purge\" it), the endpoint must be called on a **trashed** blog post with the following param `purge=true`.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space. Permission to delete blog posts in the space. Permission to administer the space (if attempting to purge).

        :param id: The ID of the blog post to be deleted. (required)
        :type id: int
        :param purge: If attempting to purge the blog post.
        :type purge: bool
        :param draft: If attempting to delete a blog post that is a draft.
        :type draft: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_blog_post_serialize(
            id=id,
            purge=purge,
            draft=draft,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_blog_post_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be deleted.")],
        purge: Annotated[Optional[StrictBool], Field(description="If attempting to purge the blog post.")] = None,
        draft: Annotated[Optional[StrictBool], Field(description="If attempting to delete a blog post that is a draft.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete blog post

        Delete a blog post by id.  By default this will delete blog posts that are non-drafts. To delete a blog post that is a draft, the endpoint must be called on a  draft with the following param `draft=true`. Discarded drafts are not sent to the trash and are permanently deleted.  Deleting a blog post that is not a draft moves the blog post to the trash, where it can be restored later. To permanently delete a blog post (or \"purge\" it), the endpoint must be called on a **trashed** blog post with the following param `purge=true`.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space. Permission to delete blog posts in the space. Permission to administer the space (if attempting to purge).

        :param id: The ID of the blog post to be deleted. (required)
        :type id: int
        :param purge: If attempting to purge the blog post.
        :type purge: bool
        :param draft: If attempting to delete a blog post that is a draft.
        :type draft: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_blog_post_serialize(
            id=id,
            purge=purge,
            draft=draft,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_blog_post_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be deleted.")],
        purge: Annotated[Optional[StrictBool], Field(description="If attempting to purge the blog post.")] = None,
        draft: Annotated[Optional[StrictBool], Field(description="If attempting to delete a blog post that is a draft.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete blog post

        Delete a blog post by id.  By default this will delete blog posts that are non-drafts. To delete a blog post that is a draft, the endpoint must be called on a  draft with the following param `draft=true`. Discarded drafts are not sent to the trash and are permanently deleted.  Deleting a blog post that is not a draft moves the blog post to the trash, where it can be restored later. To permanently delete a blog post (or \"purge\" it), the endpoint must be called on a **trashed** blog post with the following param `purge=true`.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space. Permission to delete blog posts in the space. Permission to administer the space (if attempting to purge).

        :param id: The ID of the blog post to be deleted. (required)
        :type id: int
        :param purge: If attempting to purge the blog post.
        :type purge: bool
        :param draft: If attempting to delete a blog post that is a draft.
        :type draft: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_blog_post_serialize(
            id=id,
            purge=purge,
            draft=draft,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_blog_post_serialize(
        self,
        id,
        purge,
        draft,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if purge is not None:
            
            _query_params.append(('purge', purge))
            
        if draft is not None:
            
            _query_params.append(('draft', draft))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter




        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/blogposts/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_blog_post_by_id(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be returned. If you don't know the blog post ID, use Get blog posts and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentationSingle], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        get_draft: Annotated[Optional[StrictBool], Field(description="Retrieve the draft version of this blog post.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the blog post being retrieved by its status.")] = None,
        version: Annotated[Optional[StrictInt], Field(description="Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes content properties associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this blog post in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_likes: Annotated[Optional[StrictBool], Field(description="Includes likes associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_versions: Annotated[Optional[StrictBool], Field(description="Includes versions associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_version: Annotated[Optional[StrictBool], Field(description="Includes the current version associated with this blog post in the response. By default this is included and can be omitted by setting the value to `false`.")] = None,
        include_favorited_by_current_user_status: Annotated[Optional[StrictBool], Field(description="Includes whether this blog post has been favorited by the current user.")] = None,
        include_webresources: Annotated[Optional[StrictBool], Field(description="Includes web resources that can be used to render blog post content on a client.")] = None,
        include_collaborators: Annotated[Optional[StrictBool], Field(description="Includes collaborators on the blog post.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateBlogPost200Response:
        """Get blog post by id

        Returns a specific blog post.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space.

        :param id: The ID of the blog post to be returned. If you don't know the blog post ID, use Get blog posts and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentationSingle
        :param get_draft: Retrieve the draft version of this blog post.
        :type get_draft: bool
        :param status: Filter the blog post being retrieved by its status.
        :type status: List[str]
        :param version: Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.
        :type version: int
        :param include_labels: Includes labels associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param include_properties: Includes content properties associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_operations: Includes operations associated with this blog post in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_likes: Includes likes associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_likes: bool
        :param include_versions: Includes versions associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_versions: bool
        :param include_version: Includes the current version associated with this blog post in the response. By default this is included and can be omitted by setting the value to `false`.
        :type include_version: bool
        :param include_favorited_by_current_user_status: Includes whether this blog post has been favorited by the current user.
        :type include_favorited_by_current_user_status: bool
        :param include_webresources: Includes web resources that can be used to render blog post content on a client.
        :type include_webresources: bool
        :param include_collaborators: Includes collaborators on the blog post.
        :type include_collaborators: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_post_by_id_serialize(
            id=id,
            body_format=body_format,
            get_draft=get_draft,
            status=status,
            version=version,
            include_labels=include_labels,
            include_properties=include_properties,
            include_operations=include_operations,
            include_likes=include_likes,
            include_versions=include_versions,
            include_version=include_version,
            include_favorited_by_current_user_status=include_favorited_by_current_user_status,
            include_webresources=include_webresources,
            include_collaborators=include_collaborators,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_blog_post_by_id_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be returned. If you don't know the blog post ID, use Get blog posts and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentationSingle], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        get_draft: Annotated[Optional[StrictBool], Field(description="Retrieve the draft version of this blog post.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the blog post being retrieved by its status.")] = None,
        version: Annotated[Optional[StrictInt], Field(description="Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes content properties associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this blog post in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_likes: Annotated[Optional[StrictBool], Field(description="Includes likes associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_versions: Annotated[Optional[StrictBool], Field(description="Includes versions associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_version: Annotated[Optional[StrictBool], Field(description="Includes the current version associated with this blog post in the response. By default this is included and can be omitted by setting the value to `false`.")] = None,
        include_favorited_by_current_user_status: Annotated[Optional[StrictBool], Field(description="Includes whether this blog post has been favorited by the current user.")] = None,
        include_webresources: Annotated[Optional[StrictBool], Field(description="Includes web resources that can be used to render blog post content on a client.")] = None,
        include_collaborators: Annotated[Optional[StrictBool], Field(description="Includes collaborators on the blog post.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateBlogPost200Response]:
        """Get blog post by id

        Returns a specific blog post.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space.

        :param id: The ID of the blog post to be returned. If you don't know the blog post ID, use Get blog posts and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentationSingle
        :param get_draft: Retrieve the draft version of this blog post.
        :type get_draft: bool
        :param status: Filter the blog post being retrieved by its status.
        :type status: List[str]
        :param version: Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.
        :type version: int
        :param include_labels: Includes labels associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param include_properties: Includes content properties associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_operations: Includes operations associated with this blog post in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_likes: Includes likes associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_likes: bool
        :param include_versions: Includes versions associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_versions: bool
        :param include_version: Includes the current version associated with this blog post in the response. By default this is included and can be omitted by setting the value to `false`.
        :type include_version: bool
        :param include_favorited_by_current_user_status: Includes whether this blog post has been favorited by the current user.
        :type include_favorited_by_current_user_status: bool
        :param include_webresources: Includes web resources that can be used to render blog post content on a client.
        :type include_webresources: bool
        :param include_collaborators: Includes collaborators on the blog post.
        :type include_collaborators: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_post_by_id_serialize(
            id=id,
            body_format=body_format,
            get_draft=get_draft,
            status=status,
            version=version,
            include_labels=include_labels,
            include_properties=include_properties,
            include_operations=include_operations,
            include_likes=include_likes,
            include_versions=include_versions,
            include_version=include_version,
            include_favorited_by_current_user_status=include_favorited_by_current_user_status,
            include_webresources=include_webresources,
            include_collaborators=include_collaborators,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_blog_post_by_id_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be returned. If you don't know the blog post ID, use Get blog posts and filter the results.")],
        body_format: Annotated[Optional[PrimaryBodyRepresentationSingle], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        get_draft: Annotated[Optional[StrictBool], Field(description="Retrieve the draft version of this blog post.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the blog post being retrieved by its status.")] = None,
        version: Annotated[Optional[StrictInt], Field(description="Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.")] = None,
        include_labels: Annotated[Optional[StrictBool], Field(description="Includes labels associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_properties: Annotated[Optional[StrictBool], Field(description="Includes content properties associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_operations: Annotated[Optional[StrictBool], Field(description="Includes operations associated with this blog post in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_likes: Annotated[Optional[StrictBool], Field(description="Includes likes associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_versions: Annotated[Optional[StrictBool], Field(description="Includes versions associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.")] = None,
        include_version: Annotated[Optional[StrictBool], Field(description="Includes the current version associated with this blog post in the response. By default this is included and can be omitted by setting the value to `false`.")] = None,
        include_favorited_by_current_user_status: Annotated[Optional[StrictBool], Field(description="Includes whether this blog post has been favorited by the current user.")] = None,
        include_webresources: Annotated[Optional[StrictBool], Field(description="Includes web resources that can be used to render blog post content on a client.")] = None,
        include_collaborators: Annotated[Optional[StrictBool], Field(description="Includes collaborators on the blog post.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get blog post by id

        Returns a specific blog post.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space.

        :param id: The ID of the blog post to be returned. If you don't know the blog post ID, use Get blog posts and filter the results. (required)
        :type id: int
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentationSingle
        :param get_draft: Retrieve the draft version of this blog post.
        :type get_draft: bool
        :param status: Filter the blog post being retrieved by its status.
        :type status: List[str]
        :param version: Allows you to retrieve a previously published version. Specify the previous version's number to retrieve its details.
        :type version: int
        :param include_labels: Includes labels associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_labels: bool
        :param include_properties: Includes content properties associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_properties: bool
        :param include_operations: Includes operations associated with this blog post in the response, as defined in the `Operation` object. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_operations: bool
        :param include_likes: Includes likes associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_likes: bool
        :param include_versions: Includes versions associated with this blog post in the response. The number of results will be limited to 50 and sorted in the default sort order.  A `meta` and `_links` property will be present to indicate if more results are available and a link to retrieve the rest of the results.
        :type include_versions: bool
        :param include_version: Includes the current version associated with this blog post in the response. By default this is included and can be omitted by setting the value to `false`.
        :type include_version: bool
        :param include_favorited_by_current_user_status: Includes whether this blog post has been favorited by the current user.
        :type include_favorited_by_current_user_status: bool
        :param include_webresources: Includes web resources that can be used to render blog post content on a client.
        :type include_webresources: bool
        :param include_collaborators: Includes collaborators on the blog post.
        :type include_collaborators: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_post_by_id_serialize(
            id=id,
            body_format=body_format,
            get_draft=get_draft,
            status=status,
            version=version,
            include_labels=include_labels,
            include_properties=include_properties,
            include_operations=include_operations,
            include_likes=include_likes,
            include_versions=include_versions,
            include_version=include_version,
            include_favorited_by_current_user_status=include_favorited_by_current_user_status,
            include_webresources=include_webresources,
            include_collaborators=include_collaborators,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_blog_post_by_id_serialize(
        self,
        id,
        body_format,
        get_draft,
        status,
        version,
        include_labels,
        include_properties,
        include_operations,
        include_likes,
        include_versions,
        include_version,
        include_favorited_by_current_user_status,
        include_webresources,
        include_collaborators,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'status': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if get_draft is not None:
            
            _query_params.append(('get-draft', get_draft))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if version is not None:
            
            _query_params.append(('version', version))
            
        if include_labels is not None:
            
            _query_params.append(('include-labels', include_labels))
            
        if include_properties is not None:
            
            _query_params.append(('include-properties', include_properties))
            
        if include_operations is not None:
            
            _query_params.append(('include-operations', include_operations))
            
        if include_likes is not None:
            
            _query_params.append(('include-likes', include_likes))
            
        if include_versions is not None:
            
            _query_params.append(('include-versions', include_versions))
            
        if include_version is not None:
            
            _query_params.append(('include-version', include_version))
            
        if include_favorited_by_current_user_status is not None:
            
            _query_params.append(('include-favorited-by-current-user-status', include_favorited_by_current_user_status))
            
        if include_webresources is not None:
            
            _query_params.append(('include-webresources', include_webresources))
            
        if include_collaborators is not None:
            
            _query_params.append(('include-collaborators', include_collaborators))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/blogposts/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_blog_posts(
        self,
        id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results based on blog post ids. Multiple blog post ids can be specified as a comma-separated list.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to blog posts based on their status. By default, `current` is used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to blog posts based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultBlogPost:
        """Get blog posts

        Returns all blog posts. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only blog posts that the user has permission to view will be returned.

        :param id: Filter the results based on blog post ids. Multiple blog post ids can be specified as a comma-separated list.
        :type id: List[int]
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param status: Filter the results to blog posts based on their status. By default, `current` is used.
        :type status: List[str]
        :param title: Filter the results to blog posts based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_serialize(
            id=id,
            space_id=space_id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_blog_posts_with_http_info(
        self,
        id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results based on blog post ids. Multiple blog post ids can be specified as a comma-separated list.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to blog posts based on their status. By default, `current` is used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to blog posts based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultBlogPost]:
        """Get blog posts

        Returns all blog posts. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only blog posts that the user has permission to view will be returned.

        :param id: Filter the results based on blog post ids. Multiple blog post ids can be specified as a comma-separated list.
        :type id: List[int]
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param status: Filter the results to blog posts based on their status. By default, `current` is used.
        :type status: List[str]
        :param title: Filter the results to blog posts based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_serialize(
            id=id,
            space_id=space_id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_blog_posts_without_preload_content(
        self,
        id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=250)]], Field(description="Filter the results based on blog post ids. Multiple blog post ids can be specified as a comma-separated list.")] = None,
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to blog posts based on their status. By default, `current` is used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to blog posts based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get blog posts

        Returns all blog posts. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission). Only blog posts that the user has permission to view will be returned.

        :param id: Filter the results based on blog post ids. Multiple blog post ids can be specified as a comma-separated list.
        :type id: List[int]
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param status: Filter the results to blog posts based on their status. By default, `current` is used.
        :type status: List[str]
        :param title: Filter the results to blog posts based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` response header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_serialize(
            id=id,
            space_id=space_id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_blog_posts_serialize(
        self,
        id,
        space_id,
        sort,
        status,
        title,
        body_format,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'id': 'multi',
            'space-id': 'multi',
            'status': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if id is not None:
            
            _query_params.append(('id', id))
            
        if space_id is not None:
            
            _query_params.append(('space-id', space_id))
            
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/blogposts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_blog_posts_in_space(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space for which blog posts should be returned.")],
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to blog posts based on their status. By default, `current` is used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to blog posts based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultBlogPost:
        """Get blog posts in space

        Returns all blog posts in a space. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission) and view the space. Only blog posts that the user has permission to view will be returned.

        :param id: The ID of the space for which blog posts should be returned. (required)
        :type id: int
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param status: Filter the results to blog posts based on their status. By default, `current` is used.
        :type status: List[str]
        :param title: Filter the results to blog posts based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_in_space_serialize(
            id=id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_blog_posts_in_space_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space for which blog posts should be returned.")],
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to blog posts based on their status. By default, `current` is used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to blog posts based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultBlogPost]:
        """Get blog posts in space

        Returns all blog posts in a space. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission) and view the space. Only blog posts that the user has permission to view will be returned.

        :param id: The ID of the space for which blog posts should be returned. (required)
        :type id: int
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param status: Filter the results to blog posts based on their status. By default, `current` is used.
        :type status: List[str]
        :param title: Filter the results to blog posts based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_in_space_serialize(
            id=id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_blog_posts_in_space_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the space for which blog posts should be returned.")],
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        status: Annotated[Optional[List[StrictStr]], Field(description="Filter the results to blog posts based on their status. By default, `current` is used.")] = None,
        title: Annotated[Optional[StrictStr], Field(description="Filter the results to blog posts based on their title.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get blog posts in space

        Returns all blog posts in a space. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to access the Confluence site ('Can use' global permission) and view the space. Only blog posts that the user has permission to view will be returned.

        :param id: The ID of the space for which blog posts should be returned. (required)
        :type id: int
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param status: Filter the results to blog posts based on their status. By default, `current` is used.
        :type status: List[str]
        :param title: Filter the results to blog posts based on their title.
        :type title: str
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_blog_posts_in_space_serialize(
            id=id,
            sort=sort,
            status=status,
            title=title,
            body_format=body_format,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_blog_posts_in_space_serialize(
        self,
        id,
        sort,
        status,
        title,
        body_format,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'status': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if status is not None:
            
            _query_params.append(('status', status))
            
        if title is not None:
            
            _query_params.append(('title', title))
            
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/spaces/{id}/blogposts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_label_blog_posts(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the label for which blog posts should be returned.")],
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> MultiEntityResultBlogPost:
        """Get blog posts for label

        Returns the blogposts of specified label. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the content of the page and its corresponding space.

        :param id: The ID of the label for which blog posts should be returned. (required)
        :type id: int
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_label_blog_posts_serialize(
            id=id,
            space_id=space_id,
            body_format=body_format,
            sort=sort,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_label_blog_posts_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the label for which blog posts should be returned.")],
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[MultiEntityResultBlogPost]:
        """Get blog posts for label

        Returns the blogposts of specified label. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the content of the page and its corresponding space.

        :param id: The ID of the label for which blog posts should be returned. (required)
        :type id: int
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_label_blog_posts_serialize(
            id=id,
            space_id=space_id,
            body_format=body_format,
            sort=sort,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_label_blog_posts_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the label for which blog posts should be returned.")],
        space_id: Annotated[Optional[Annotated[List[StrictInt], Field(max_length=100)]], Field(description="Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.")] = None,
        body_format: Annotated[Optional[PrimaryBodyRepresentation], Field(description="The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.")] = None,
        sort: Annotated[Optional[BlogPostSortOrder], Field(description="Used to sort the result by a particular field.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.")] = None,
        limit: Annotated[Optional[Annotated[int, Field(le=250, strict=True, ge=1)]], Field(description="Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get blog posts for label

        Returns the blogposts of specified label. The number of results is limited by the `limit` parameter and additional results (if available) will be available through the `next` URL present in the `Link` response header.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the content of the page and its corresponding space.

        :param id: The ID of the label for which blog posts should be returned. (required)
        :type id: int
        :param space_id: Filter the results based on space ids. Multiple space ids can be specified as a comma-separated list.
        :type space_id: List[int]
        :param body_format: The content format types to be returned in the `body` field of the response. If available, the representation will be available under a response field of the same name under the `body` field.
        :type body_format: PrimaryBodyRepresentation
        :param sort: Used to sort the result by a particular field.
        :type sort: BlogPostSortOrder
        :param cursor: Used for pagination, this opaque cursor will be returned in the `next` URL in the `Link` response header. Use the relative URL in the `Link` header to retrieve the `next` set of results.
        :type cursor: str
        :param limit: Maximum number of blog posts per result to return. If more results exist, use the `Link` header to retrieve a relative URL that will return the next set of results.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_label_blog_posts_serialize(
            id=id,
            space_id=space_id,
            body_format=body_format,
            sort=sort,
            cursor=cursor,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "MultiEntityResultBlogPost",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_label_blog_posts_serialize(
        self,
        id,
        space_id,
        body_format,
        sort,
        cursor,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'space-id': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if space_id is not None:
            
            _query_params.append(('space-id', space_id))
            
        if body_format is not None:
            
            _query_params.append(('body-format', body_format.value))
            
        if sort is not None:
            
            _query_params.append(('sort', sort.value))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/labels/{id}/blogposts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def update_blog_post(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be updated. If you don't know the blog post ID, use Get Blog Posts and filter the results.")],
        update_blog_post_request: UpdateBlogPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateBlogPost200Response:
        """Update blog post

        Update a blog post by id.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space. Permission to update blog posts in the space.

        :param id: The ID of the blog post to be updated. If you don't know the blog post ID, use Get Blog Posts and filter the results. (required)
        :type id: int
        :param update_blog_post_request: (required)
        :type update_blog_post_request: UpdateBlogPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_blog_post_serialize(
            id=id,
            update_blog_post_request=update_blog_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def update_blog_post_with_http_info(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be updated. If you don't know the blog post ID, use Get Blog Posts and filter the results.")],
        update_blog_post_request: UpdateBlogPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateBlogPost200Response]:
        """Update blog post

        Update a blog post by id.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space. Permission to update blog posts in the space.

        :param id: The ID of the blog post to be updated. If you don't know the blog post ID, use Get Blog Posts and filter the results. (required)
        :type id: int
        :param update_blog_post_request: (required)
        :type update_blog_post_request: UpdateBlogPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_blog_post_serialize(
            id=id,
            update_blog_post_request=update_blog_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def update_blog_post_without_preload_content(
        self,
        id: Annotated[StrictInt, Field(description="The ID of the blog post to be updated. If you don't know the blog post ID, use Get Blog Posts and filter the results.")],
        update_blog_post_request: UpdateBlogPostRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update blog post

        Update a blog post by id.  **[Permissions](https://confluence.atlassian.com/x/_AozKw) required**: Permission to view the blog post and its corresponding space. Permission to update blog posts in the space.

        :param id: The ID of the blog post to be updated. If you don't know the blog post ID, use Get Blog Posts and filter the results. (required)
        :type id: int
        :param update_blog_post_request: (required)
        :type update_blog_post_request: UpdateBlogPostRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._update_blog_post_serialize(
            id=id,
            update_blog_post_request=update_blog_post_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateBlogPost200Response",
            '400': None,
            '401': None,
            '404': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _update_blog_post_serialize(
        self,
        id,
        update_blog_post_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if update_blog_post_request is not None:
            _body_params = update_blog_post_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'basicAuth', 
            'oAuthDefinitions'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/blogposts/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


